/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tpu.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class QueuedResourceName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_QUEUED_RESOURCE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/queuedResources/{queued_resource}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String queuedResource;

    @Deprecated
    protected QueuedResourceName() {
        this.project = null;
        this.location = null;
        this.queuedResource = null;
    }

    private QueuedResourceName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.queuedResource = (String)Preconditions.checkNotNull((Object)builder.getQueuedResource());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getQueuedResource() {
        return this.queuedResource;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static QueuedResourceName of(String project, String location, String queuedResource) {
        return QueuedResourceName.newBuilder().setProject(project).setLocation(location).setQueuedResource(queuedResource).build();
    }

    public static String format(String project, String location, String queuedResource) {
        return QueuedResourceName.newBuilder().setProject(project).setLocation(location).setQueuedResource(queuedResource).build().toString();
    }

    public static QueuedResourceName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_QUEUED_RESOURCE.validatedMatch(formattedString, "QueuedResourceName.parse: formattedString not in valid format");
        return QueuedResourceName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("queued_resource"));
    }

    public static List<QueuedResourceName> parseList(List<String> formattedStrings) {
        ArrayList<QueuedResourceName> list = new ArrayList<QueuedResourceName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(QueuedResourceName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<QueuedResourceName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (QueuedResourceName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_QUEUED_RESOURCE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            QueuedResourceName queuedResourceName = this;
            synchronized (queuedResourceName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.queuedResource != null) {
                        fieldMapBuilder.put((Object)"queued_resource", (Object)this.queuedResource);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_QUEUED_RESOURCE.instantiate(new String[]{"project", this.project, "location", this.location, "queued_resource", this.queuedResource});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            QueuedResourceName that = (QueuedResourceName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.queuedResource, that.queuedResource);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.queuedResource);
    }

    public static class Builder {
        private String project;
        private String location;
        private String queuedResource;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getQueuedResource() {
            return this.queuedResource;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setQueuedResource(String queuedResource) {
            this.queuedResource = queuedResource;
            return this;
        }

        private Builder(QueuedResourceName queuedResourceName) {
            this.project = queuedResourceName.project;
            this.location = queuedResourceName.location;
            this.queuedResource = queuedResourceName.queuedResource;
        }

        public QueuedResourceName build() {
            return new QueuedResourceName(this);
        }
    }
}

