/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tasks.v2beta2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class QueueName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_QUEUE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/queues/{queue}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String queue;

    @Deprecated
    protected QueueName() {
        this.project = null;
        this.location = null;
        this.queue = null;
    }

    private QueueName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.queue = (String)Preconditions.checkNotNull((Object)builder.getQueue());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getQueue() {
        return this.queue;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static QueueName of(String project, String location, String queue) {
        return QueueName.newBuilder().setProject(project).setLocation(location).setQueue(queue).build();
    }

    public static String format(String project, String location, String queue) {
        return QueueName.newBuilder().setProject(project).setLocation(location).setQueue(queue).build().toString();
    }

    public static QueueName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_QUEUE.validatedMatch(formattedString, "QueueName.parse: formattedString not in valid format");
        return QueueName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("queue"));
    }

    public static List<QueueName> parseList(List<String> formattedStrings) {
        ArrayList<QueueName> list = new ArrayList<QueueName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(QueueName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<QueueName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (QueueName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_QUEUE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            QueueName queueName = this;
            synchronized (queueName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.queue != null) {
                        fieldMapBuilder.put((Object)"queue", (Object)this.queue);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_QUEUE.instantiate(new String[]{"project", this.project, "location", this.location, "queue", this.queue});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            QueueName that = (QueueName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.queue, that.queue);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.queue);
    }

    public static class Builder {
        private String project;
        private String location;
        private String queue;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getQueue() {
            return this.queue;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setQueue(String queue) {
            this.queue = queue;
            return this;
        }

        private Builder(QueueName queueName) {
            this.project = queueName.project;
            this.location = queueName.location;
            this.queue = queueName.queue;
        }

        public QueueName build() {
            return new QueueName(this);
        }
    }
}

