/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.talent.v4beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ProfileName
implements ResourceName {
    private static final PathTemplate PROJECT_TENANT_PROFILE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/tenants/{tenant}/profiles/{profile}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String tenant;
    private final String profile;

    @Deprecated
    protected ProfileName() {
        this.project = null;
        this.tenant = null;
        this.profile = null;
    }

    private ProfileName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.tenant = (String)Preconditions.checkNotNull((Object)builder.getTenant());
        this.profile = (String)Preconditions.checkNotNull((Object)builder.getProfile());
    }

    public String getProject() {
        return this.project;
    }

    public String getTenant() {
        return this.tenant;
    }

    public String getProfile() {
        return this.profile;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ProfileName of(String project, String tenant, String profile) {
        return ProfileName.newBuilder().setProject(project).setTenant(tenant).setProfile(profile).build();
    }

    public static String format(String project, String tenant, String profile) {
        return ProfileName.newBuilder().setProject(project).setTenant(tenant).setProfile(profile).build().toString();
    }

    public static ProfileName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_TENANT_PROFILE.validatedMatch(formattedString, "ProfileName.parse: formattedString not in valid format");
        return ProfileName.of((String)matchMap.get("project"), (String)matchMap.get("tenant"), (String)matchMap.get("profile"));
    }

    public static List<ProfileName> parseList(List<String> formattedStrings) {
        ArrayList<ProfileName> list = new ArrayList<ProfileName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ProfileName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ProfileName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ProfileName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_TENANT_PROFILE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProfileName profileName = this;
            synchronized (profileName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.tenant != null) {
                        fieldMapBuilder.put((Object)"tenant", (Object)this.tenant);
                    }
                    if (this.profile != null) {
                        fieldMapBuilder.put((Object)"profile", (Object)this.profile);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_TENANT_PROFILE.instantiate(new String[]{"project", this.project, "tenant", this.tenant, "profile", this.profile});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            ProfileName that = (ProfileName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.tenant, that.tenant) && Objects.equals(this.profile, that.profile);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.tenant);
        h *= 1000003;
        return h ^= Objects.hashCode(this.profile);
    }

    public static class Builder {
        private String project;
        private String tenant;
        private String profile;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getTenant() {
            return this.tenant;
        }

        public String getProfile() {
            return this.profile;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setTenant(String tenant) {
            this.tenant = tenant;
            return this;
        }

        public Builder setProfile(String profile) {
            this.profile = profile;
            return this;
        }

        private Builder(ProfileName profileName) {
            this.project = profileName.project;
            this.tenant = profileName.tenant;
            this.profile = profileName.profile;
        }

        public ProfileName build() {
            return new ProfileName(this);
        }
    }
}

