/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.talent.v4beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ApplicationName
implements ResourceName {
    private static final PathTemplate PROJECT_TENANT_PROFILE_APPLICATION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/tenants/{tenant}/profiles/{profile}/applications/{application}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String tenant;
    private final String profile;
    private final String application;

    @Deprecated
    protected ApplicationName() {
        this.project = null;
        this.tenant = null;
        this.profile = null;
        this.application = null;
    }

    private ApplicationName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.tenant = (String)Preconditions.checkNotNull((Object)builder.getTenant());
        this.profile = (String)Preconditions.checkNotNull((Object)builder.getProfile());
        this.application = (String)Preconditions.checkNotNull((Object)builder.getApplication());
    }

    public String getProject() {
        return this.project;
    }

    public String getTenant() {
        return this.tenant;
    }

    public String getProfile() {
        return this.profile;
    }

    public String getApplication() {
        return this.application;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ApplicationName of(String project, String tenant, String profile, String application) {
        return ApplicationName.newBuilder().setProject(project).setTenant(tenant).setProfile(profile).setApplication(application).build();
    }

    public static String format(String project, String tenant, String profile, String application) {
        return ApplicationName.newBuilder().setProject(project).setTenant(tenant).setProfile(profile).setApplication(application).build().toString();
    }

    public static ApplicationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_TENANT_PROFILE_APPLICATION.validatedMatch(formattedString, "ApplicationName.parse: formattedString not in valid format");
        return ApplicationName.of((String)matchMap.get("project"), (String)matchMap.get("tenant"), (String)matchMap.get("profile"), (String)matchMap.get("application"));
    }

    public static List<ApplicationName> parseList(List<String> formattedStrings) {
        ArrayList<ApplicationName> list = new ArrayList<ApplicationName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ApplicationName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ApplicationName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ApplicationName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_TENANT_PROFILE_APPLICATION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ApplicationName applicationName = this;
            synchronized (applicationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.tenant != null) {
                        fieldMapBuilder.put((Object)"tenant", (Object)this.tenant);
                    }
                    if (this.profile != null) {
                        fieldMapBuilder.put((Object)"profile", (Object)this.profile);
                    }
                    if (this.application != null) {
                        fieldMapBuilder.put((Object)"application", (Object)this.application);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_TENANT_PROFILE_APPLICATION.instantiate(new String[]{"project", this.project, "tenant", this.tenant, "profile", this.profile, "application", this.application});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            ApplicationName that = (ApplicationName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.tenant, that.tenant) && Objects.equals(this.profile, that.profile) && Objects.equals(this.application, that.application);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.tenant);
        h *= 1000003;
        h ^= Objects.hashCode(this.profile);
        h *= 1000003;
        return h ^= Objects.hashCode(this.application);
    }

    public static class Builder {
        private String project;
        private String tenant;
        private String profile;
        private String application;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getTenant() {
            return this.tenant;
        }

        public String getProfile() {
            return this.profile;
        }

        public String getApplication() {
            return this.application;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setTenant(String tenant) {
            this.tenant = tenant;
            return this;
        }

        public Builder setProfile(String profile) {
            this.profile = profile;
            return this;
        }

        public Builder setApplication(String application) {
            this.application = application;
            return this;
        }

        private Builder(ApplicationName applicationName) {
            this.project = applicationName.project;
            this.tenant = applicationName.tenant;
            this.profile = applicationName.profile;
            this.application = applicationName.application;
        }

        public ApplicationName build() {
            return new ApplicationName(this);
        }
    }
}

