/*
 * Copyright 2026 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// NO CHECKED-IN PROTOBUF GENCODE
// source: google/storage/v2/storage.proto
// Protobuf Java Version: 4.33.2

package com.google.storage.v2;

@com.google.protobuf.Generated
public interface GetObjectRequestOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.storage.v2.GetObjectRequest)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. Name of the bucket in which the object resides.
   * </pre>
   *
   * <code>
   * string bucket = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bucket.
   */
  java.lang.String getBucket();

  /**
   *
   *
   * <pre>
   * Required. Name of the bucket in which the object resides.
   * </pre>
   *
   * <code>
   * string bucket = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for bucket.
   */
  com.google.protobuf.ByteString getBucketBytes();

  /**
   *
   *
   * <pre>
   * Required. Name of the object.
   * </pre>
   *
   * <code>string object = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The object.
   */
  java.lang.String getObject();

  /**
   *
   *
   * <pre>
   * Required. Name of the object.
   * </pre>
   *
   * <code>string object = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for object.
   */
  com.google.protobuf.ByteString getObjectBytes();

  /**
   *
   *
   * <pre>
   * Optional. If present, selects a specific revision of this object (as
   * opposed to the latest version, the default).
   * </pre>
   *
   * <code>int64 generation = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The generation.
   */
  long getGeneration();

  /**
   *
   *
   * <pre>
   * If true, return the soft-deleted version of this object.
   * </pre>
   *
   * <code>optional bool soft_deleted = 11;</code>
   *
   * @return Whether the softDeleted field is set.
   */
  boolean hasSoftDeleted();

  /**
   *
   *
   * <pre>
   * If true, return the soft-deleted version of this object.
   * </pre>
   *
   * <code>optional bool soft_deleted = 11;</code>
   *
   * @return The softDeleted.
   */
  boolean getSoftDeleted();

  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the object's current generation
   * matches the given value. Setting to 0 makes the operation succeed only if
   * there are no live versions of the object.
   * </pre>
   *
   * <code>optional int64 if_generation_match = 4;</code>
   *
   * @return Whether the ifGenerationMatch field is set.
   */
  boolean hasIfGenerationMatch();

  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the object's current generation
   * matches the given value. Setting to 0 makes the operation succeed only if
   * there are no live versions of the object.
   * </pre>
   *
   * <code>optional int64 if_generation_match = 4;</code>
   *
   * @return The ifGenerationMatch.
   */
  long getIfGenerationMatch();

  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the object's live generation
   * does not match the given value. If no live object exists, the precondition
   * fails. Setting to 0 makes the operation succeed only if there is a live
   * version of the object.
   * </pre>
   *
   * <code>optional int64 if_generation_not_match = 5;</code>
   *
   * @return Whether the ifGenerationNotMatch field is set.
   */
  boolean hasIfGenerationNotMatch();

  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the object's live generation
   * does not match the given value. If no live object exists, the precondition
   * fails. Setting to 0 makes the operation succeed only if there is a live
   * version of the object.
   * </pre>
   *
   * <code>optional int64 if_generation_not_match = 5;</code>
   *
   * @return The ifGenerationNotMatch.
   */
  long getIfGenerationNotMatch();

  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the object's current
   * metageneration matches the given value.
   * </pre>
   *
   * <code>optional int64 if_metageneration_match = 6;</code>
   *
   * @return Whether the ifMetagenerationMatch field is set.
   */
  boolean hasIfMetagenerationMatch();

  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the object's current
   * metageneration matches the given value.
   * </pre>
   *
   * <code>optional int64 if_metageneration_match = 6;</code>
   *
   * @return The ifMetagenerationMatch.
   */
  long getIfMetagenerationMatch();

  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the object's current
   * metageneration does not match the given value.
   * </pre>
   *
   * <code>optional int64 if_metageneration_not_match = 7;</code>
   *
   * @return Whether the ifMetagenerationNotMatch field is set.
   */
  boolean hasIfMetagenerationNotMatch();

  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the object's current
   * metageneration does not match the given value.
   * </pre>
   *
   * <code>optional int64 if_metageneration_not_match = 7;</code>
   *
   * @return The ifMetagenerationNotMatch.
   */
  long getIfMetagenerationNotMatch();

  /**
   *
   *
   * <pre>
   * Optional. A set of parameters common to Storage API requests concerning an
   * object.
   * </pre>
   *
   * <code>
   * .google.storage.v2.CommonObjectRequestParams common_object_request_params = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the commonObjectRequestParams field is set.
   */
  boolean hasCommonObjectRequestParams();

  /**
   *
   *
   * <pre>
   * Optional. A set of parameters common to Storage API requests concerning an
   * object.
   * </pre>
   *
   * <code>
   * .google.storage.v2.CommonObjectRequestParams common_object_request_params = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The commonObjectRequestParams.
   */
  com.google.storage.v2.CommonObjectRequestParams getCommonObjectRequestParams();

  /**
   *
   *
   * <pre>
   * Optional. A set of parameters common to Storage API requests concerning an
   * object.
   * </pre>
   *
   * <code>
   * .google.storage.v2.CommonObjectRequestParams common_object_request_params = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.storage.v2.CommonObjectRequestParamsOrBuilder getCommonObjectRequestParamsOrBuilder();

  /**
   *
   *
   * <pre>
   * Mask specifying which fields to read.
   * If no mask is specified, it defaults to all fields except `metadata.
   * acl` and `metadata.owner`.
   * `*` might be used to mean "all fields".
   * </pre>
   *
   * <code>optional .google.protobuf.FieldMask read_mask = 10;</code>
   *
   * @return Whether the readMask field is set.
   */
  boolean hasReadMask();

  /**
   *
   *
   * <pre>
   * Mask specifying which fields to read.
   * If no mask is specified, it defaults to all fields except `metadata.
   * acl` and `metadata.owner`.
   * `*` might be used to mean "all fields".
   * </pre>
   *
   * <code>optional .google.protobuf.FieldMask read_mask = 10;</code>
   *
   * @return The readMask.
   */
  com.google.protobuf.FieldMask getReadMask();

  /**
   *
   *
   * <pre>
   * Mask specifying which fields to read.
   * If no mask is specified, it defaults to all fields except `metadata.
   * acl` and `metadata.owner`.
   * `*` might be used to mean "all fields".
   * </pre>
   *
   * <code>optional .google.protobuf.FieldMask read_mask = 10;</code>
   */
  com.google.protobuf.FieldMaskOrBuilder getReadMaskOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. Restore token used to differentiate soft-deleted objects with the
   * same name and generation. Only applicable for hierarchical namespace
   * buckets and if `soft_deleted` is set to `true`. This parameter is optional,
   * and is only required in the rare case when there are multiple soft-deleted
   * objects with the same `name` and `generation`.
   * </pre>
   *
   * <code>string restore_token = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The restoreToken.
   */
  java.lang.String getRestoreToken();

  /**
   *
   *
   * <pre>
   * Optional. Restore token used to differentiate soft-deleted objects with the
   * same name and generation. Only applicable for hierarchical namespace
   * buckets and if `soft_deleted` is set to `true`. This parameter is optional,
   * and is only required in the rare case when there are multiple soft-deleted
   * objects with the same `name` and `generation`.
   * </pre>
   *
   * <code>string restore_token = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for restoreToken.
   */
  com.google.protobuf.ByteString getRestoreTokenBytes();
}
