/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/storage/v2/storage.proto

// Protobuf Java Version: 3.25.8
package com.google.storage.v2;

/**
 *
 *
 * <pre>
 * Shared constants.
 * </pre>
 *
 * Protobuf type {@code google.storage.v2.ServiceConstants}
 */
public final class ServiceConstants extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.storage.v2.ServiceConstants)
    ServiceConstantsOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use ServiceConstants.newBuilder() to construct.
  private ServiceConstants(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ServiceConstants() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ServiceConstants();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.storage.v2.StorageProto
        .internal_static_google_storage_v2_ServiceConstants_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.storage.v2.StorageProto
        .internal_static_google_storage_v2_ServiceConstants_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.storage.v2.ServiceConstants.class,
            com.google.storage.v2.ServiceConstants.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * A collection of constant values meaningful to the Storage API.
   * </pre>
   *
   * Protobuf enum {@code google.storage.v2.ServiceConstants.Values}
   */
  public enum Values implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unused. Proto3 requires first enum to be 0.
     * </pre>
     *
     * <code>VALUES_UNSPECIFIED = 0;</code>
     */
    VALUES_UNSPECIFIED(0, 0),
    /**
     *
     *
     * <pre>
     * The maximum size chunk that can be returned in a single
     * `ReadRequest`.
     * 2 MiB.
     * </pre>
     *
     * <code>MAX_READ_CHUNK_BYTES = 2097152;</code>
     */
    MAX_READ_CHUNK_BYTES(1, 2097152),
    /**
     *
     *
     * <pre>
     * The maximum size of an object in MB - whether written in a single stream
     * or composed from multiple other objects.
     * 5 TiB.
     * </pre>
     *
     * <code>MAX_OBJECT_SIZE_MB = 5242880;</code>
     */
    MAX_OBJECT_SIZE_MB(3, 5242880),
    /**
     *
     *
     * <pre>
     * The maximum length field name that can be sent in a single
     * custom metadata field.
     * 1 KiB.
     * </pre>
     *
     * <code>MAX_CUSTOM_METADATA_FIELD_NAME_BYTES = 1024;</code>
     */
    MAX_CUSTOM_METADATA_FIELD_NAME_BYTES(4, 1024),
    /**
     *
     *
     * <pre>
     * The maximum length field value that can be sent in a single
     * custom_metadata field.
     * 4 KiB.
     * </pre>
     *
     * <code>MAX_CUSTOM_METADATA_FIELD_VALUE_BYTES = 4096;</code>
     */
    MAX_CUSTOM_METADATA_FIELD_VALUE_BYTES(5, 4096),
    /**
     *
     *
     * <pre>
     * The maximum total bytes that can be populated into all field names and
     * values of the custom_metadata for one object.
     * 8 KiB.
     * </pre>
     *
     * <code>MAX_CUSTOM_METADATA_TOTAL_SIZE_BYTES = 8192;</code>
     */
    MAX_CUSTOM_METADATA_TOTAL_SIZE_BYTES(6, 8192),
    /**
     *
     *
     * <pre>
     * The maximum total bytes that can be populated into all bucket metadata
     * fields.
     * 20 KiB.
     * </pre>
     *
     * <code>MAX_BUCKET_METADATA_TOTAL_SIZE_BYTES = 20480;</code>
     */
    MAX_BUCKET_METADATA_TOTAL_SIZE_BYTES(7, 20480),
    /**
     *
     *
     * <pre>
     * The maximum number of NotificationConfigs that can be registered
     * for a given bucket.
     * </pre>
     *
     * <code>MAX_NOTIFICATION_CONFIGS_PER_BUCKET = 100;</code>
     */
    MAX_NOTIFICATION_CONFIGS_PER_BUCKET(8, 100),
    /**
     *
     *
     * <pre>
     * The maximum number of custom attributes per NotificationConfigs.
     * </pre>
     *
     * <code>MAX_NOTIFICATION_CUSTOM_ATTRIBUTES = 5;</code>
     */
    MAX_NOTIFICATION_CUSTOM_ATTRIBUTES(10, 5),
    /**
     *
     *
     * <pre>
     * The maximum length of a custom attribute key included in
     * NotificationConfig.
     * </pre>
     *
     * <code>MAX_NOTIFICATION_CUSTOM_ATTRIBUTE_KEY_LENGTH = 256;</code>
     */
    MAX_NOTIFICATION_CUSTOM_ATTRIBUTE_KEY_LENGTH(11, 256),
    /**
     *
     *
     * <pre>
     * The maximum number of key/value entries per bucket label.
     * </pre>
     *
     * <code>MAX_LABELS_ENTRIES_COUNT = 64;</code>
     */
    MAX_LABELS_ENTRIES_COUNT(13, 64),
    /**
     *
     *
     * <pre>
     * The maximum character length of the key or value in a bucket
     * label map.
     * </pre>
     *
     * <code>MAX_LABELS_KEY_VALUE_LENGTH = 63;</code>
     */
    MAX_LABELS_KEY_VALUE_LENGTH(14, 63),
    /**
     *
     *
     * <pre>
     * The maximum byte size of the key or value in a bucket label
     * map.
     * </pre>
     *
     * <code>MAX_LABELS_KEY_VALUE_BYTES = 128;</code>
     */
    MAX_LABELS_KEY_VALUE_BYTES(15, 128),
    /**
     *
     *
     * <pre>
     * The maximum number of object IDs that can be included in a
     * DeleteObjectsRequest.
     * </pre>
     *
     * <code>MAX_OBJECT_IDS_PER_DELETE_OBJECTS_REQUEST = 1000;</code>
     */
    MAX_OBJECT_IDS_PER_DELETE_OBJECTS_REQUEST(16, 1000),
    /**
     *
     *
     * <pre>
     * The maximum number of days for which a token returned by the
     * GetListObjectsSplitPoints RPC is valid.
     * </pre>
     *
     * <code>SPLIT_TOKEN_MAX_VALID_DAYS = 14;</code>
     */
    SPLIT_TOKEN_MAX_VALID_DAYS(17, 14),
    UNRECOGNIZED(-1, -1),
    ;

    /**
     *
     *
     * <pre>
     * The maximum size chunk that can be sent in a single WriteObjectRequest.
     * 2 MiB.
     * </pre>
     *
     * <code>MAX_WRITE_CHUNK_BYTES = 2097152;</code>
     */
    public static final Values MAX_WRITE_CHUNK_BYTES = MAX_READ_CHUNK_BYTES;

    /**
     *
     *
     * <pre>
     * The maximum number of LifecycleRules that can be registered for a given
     * bucket.
     * </pre>
     *
     * <code>MAX_LIFECYCLE_RULES_PER_BUCKET = 100;</code>
     */
    public static final Values MAX_LIFECYCLE_RULES_PER_BUCKET = MAX_NOTIFICATION_CONFIGS_PER_BUCKET;

    /**
     *
     *
     * <pre>
     * The maximum length of a custom attribute value included in a
     * NotificationConfig.
     * </pre>
     *
     * <code>MAX_NOTIFICATION_CUSTOM_ATTRIBUTE_VALUE_LENGTH = 1024;</code>
     */
    public static final Values MAX_NOTIFICATION_CUSTOM_ATTRIBUTE_VALUE_LENGTH =
        MAX_CUSTOM_METADATA_FIELD_NAME_BYTES;

    /**
     *
     *
     * <pre>
     * Unused. Proto3 requires first enum to be 0.
     * </pre>
     *
     * <code>VALUES_UNSPECIFIED = 0;</code>
     */
    public static final int VALUES_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * The maximum size chunk that can be returned in a single
     * `ReadRequest`.
     * 2 MiB.
     * </pre>
     *
     * <code>MAX_READ_CHUNK_BYTES = 2097152;</code>
     */
    public static final int MAX_READ_CHUNK_BYTES_VALUE = 2097152;

    /**
     *
     *
     * <pre>
     * The maximum size chunk that can be sent in a single WriteObjectRequest.
     * 2 MiB.
     * </pre>
     *
     * <code>MAX_WRITE_CHUNK_BYTES = 2097152;</code>
     */
    public static final int MAX_WRITE_CHUNK_BYTES_VALUE = 2097152;

    /**
     *
     *
     * <pre>
     * The maximum size of an object in MB - whether written in a single stream
     * or composed from multiple other objects.
     * 5 TiB.
     * </pre>
     *
     * <code>MAX_OBJECT_SIZE_MB = 5242880;</code>
     */
    public static final int MAX_OBJECT_SIZE_MB_VALUE = 5242880;

    /**
     *
     *
     * <pre>
     * The maximum length field name that can be sent in a single
     * custom metadata field.
     * 1 KiB.
     * </pre>
     *
     * <code>MAX_CUSTOM_METADATA_FIELD_NAME_BYTES = 1024;</code>
     */
    public static final int MAX_CUSTOM_METADATA_FIELD_NAME_BYTES_VALUE = 1024;

    /**
     *
     *
     * <pre>
     * The maximum length field value that can be sent in a single
     * custom_metadata field.
     * 4 KiB.
     * </pre>
     *
     * <code>MAX_CUSTOM_METADATA_FIELD_VALUE_BYTES = 4096;</code>
     */
    public static final int MAX_CUSTOM_METADATA_FIELD_VALUE_BYTES_VALUE = 4096;

    /**
     *
     *
     * <pre>
     * The maximum total bytes that can be populated into all field names and
     * values of the custom_metadata for one object.
     * 8 KiB.
     * </pre>
     *
     * <code>MAX_CUSTOM_METADATA_TOTAL_SIZE_BYTES = 8192;</code>
     */
    public static final int MAX_CUSTOM_METADATA_TOTAL_SIZE_BYTES_VALUE = 8192;

    /**
     *
     *
     * <pre>
     * The maximum total bytes that can be populated into all bucket metadata
     * fields.
     * 20 KiB.
     * </pre>
     *
     * <code>MAX_BUCKET_METADATA_TOTAL_SIZE_BYTES = 20480;</code>
     */
    public static final int MAX_BUCKET_METADATA_TOTAL_SIZE_BYTES_VALUE = 20480;

    /**
     *
     *
     * <pre>
     * The maximum number of NotificationConfigs that can be registered
     * for a given bucket.
     * </pre>
     *
     * <code>MAX_NOTIFICATION_CONFIGS_PER_BUCKET = 100;</code>
     */
    public static final int MAX_NOTIFICATION_CONFIGS_PER_BUCKET_VALUE = 100;

    /**
     *
     *
     * <pre>
     * The maximum number of LifecycleRules that can be registered for a given
     * bucket.
     * </pre>
     *
     * <code>MAX_LIFECYCLE_RULES_PER_BUCKET = 100;</code>
     */
    public static final int MAX_LIFECYCLE_RULES_PER_BUCKET_VALUE = 100;

    /**
     *
     *
     * <pre>
     * The maximum number of custom attributes per NotificationConfigs.
     * </pre>
     *
     * <code>MAX_NOTIFICATION_CUSTOM_ATTRIBUTES = 5;</code>
     */
    public static final int MAX_NOTIFICATION_CUSTOM_ATTRIBUTES_VALUE = 5;

    /**
     *
     *
     * <pre>
     * The maximum length of a custom attribute key included in
     * NotificationConfig.
     * </pre>
     *
     * <code>MAX_NOTIFICATION_CUSTOM_ATTRIBUTE_KEY_LENGTH = 256;</code>
     */
    public static final int MAX_NOTIFICATION_CUSTOM_ATTRIBUTE_KEY_LENGTH_VALUE = 256;

    /**
     *
     *
     * <pre>
     * The maximum length of a custom attribute value included in a
     * NotificationConfig.
     * </pre>
     *
     * <code>MAX_NOTIFICATION_CUSTOM_ATTRIBUTE_VALUE_LENGTH = 1024;</code>
     */
    public static final int MAX_NOTIFICATION_CUSTOM_ATTRIBUTE_VALUE_LENGTH_VALUE = 1024;

    /**
     *
     *
     * <pre>
     * The maximum number of key/value entries per bucket label.
     * </pre>
     *
     * <code>MAX_LABELS_ENTRIES_COUNT = 64;</code>
     */
    public static final int MAX_LABELS_ENTRIES_COUNT_VALUE = 64;

    /**
     *
     *
     * <pre>
     * The maximum character length of the key or value in a bucket
     * label map.
     * </pre>
     *
     * <code>MAX_LABELS_KEY_VALUE_LENGTH = 63;</code>
     */
    public static final int MAX_LABELS_KEY_VALUE_LENGTH_VALUE = 63;

    /**
     *
     *
     * <pre>
     * The maximum byte size of the key or value in a bucket label
     * map.
     * </pre>
     *
     * <code>MAX_LABELS_KEY_VALUE_BYTES = 128;</code>
     */
    public static final int MAX_LABELS_KEY_VALUE_BYTES_VALUE = 128;

    /**
     *
     *
     * <pre>
     * The maximum number of object IDs that can be included in a
     * DeleteObjectsRequest.
     * </pre>
     *
     * <code>MAX_OBJECT_IDS_PER_DELETE_OBJECTS_REQUEST = 1000;</code>
     */
    public static final int MAX_OBJECT_IDS_PER_DELETE_OBJECTS_REQUEST_VALUE = 1000;

    /**
     *
     *
     * <pre>
     * The maximum number of days for which a token returned by the
     * GetListObjectsSplitPoints RPC is valid.
     * </pre>
     *
     * <code>SPLIT_TOKEN_MAX_VALID_DAYS = 14;</code>
     */
    public static final int SPLIT_TOKEN_MAX_VALID_DAYS_VALUE = 14;

    public final int getNumber() {
      if (index == -1) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Values valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Values forNumber(int value) {
      switch (value) {
        case 0:
          return VALUES_UNSPECIFIED;
        case 2097152:
          return MAX_READ_CHUNK_BYTES;
        case 5242880:
          return MAX_OBJECT_SIZE_MB;
        case 1024:
          return MAX_CUSTOM_METADATA_FIELD_NAME_BYTES;
        case 4096:
          return MAX_CUSTOM_METADATA_FIELD_VALUE_BYTES;
        case 8192:
          return MAX_CUSTOM_METADATA_TOTAL_SIZE_BYTES;
        case 20480:
          return MAX_BUCKET_METADATA_TOTAL_SIZE_BYTES;
        case 100:
          return MAX_NOTIFICATION_CONFIGS_PER_BUCKET;
        case 5:
          return MAX_NOTIFICATION_CUSTOM_ATTRIBUTES;
        case 256:
          return MAX_NOTIFICATION_CUSTOM_ATTRIBUTE_KEY_LENGTH;
        case 64:
          return MAX_LABELS_ENTRIES_COUNT;
        case 63:
          return MAX_LABELS_KEY_VALUE_LENGTH;
        case 128:
          return MAX_LABELS_KEY_VALUE_BYTES;
        case 1000:
          return MAX_OBJECT_IDS_PER_DELETE_OBJECTS_REQUEST;
        case 14:
          return SPLIT_TOKEN_MAX_VALID_DAYS;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Values> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Values> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Values>() {
          public Values findValueByNumber(int number) {
            return Values.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (index == -1) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(index);
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.storage.v2.ServiceConstants.getDescriptor().getEnumTypes().get(0);
    }

    private static final Values[] VALUES = getStaticValuesArray();

    private static Values[] getStaticValuesArray() {
      return new Values[] {
        VALUES_UNSPECIFIED,
        MAX_READ_CHUNK_BYTES,
        MAX_WRITE_CHUNK_BYTES,
        MAX_OBJECT_SIZE_MB,
        MAX_CUSTOM_METADATA_FIELD_NAME_BYTES,
        MAX_CUSTOM_METADATA_FIELD_VALUE_BYTES,
        MAX_CUSTOM_METADATA_TOTAL_SIZE_BYTES,
        MAX_BUCKET_METADATA_TOTAL_SIZE_BYTES,
        MAX_NOTIFICATION_CONFIGS_PER_BUCKET,
        MAX_LIFECYCLE_RULES_PER_BUCKET,
        MAX_NOTIFICATION_CUSTOM_ATTRIBUTES,
        MAX_NOTIFICATION_CUSTOM_ATTRIBUTE_KEY_LENGTH,
        MAX_NOTIFICATION_CUSTOM_ATTRIBUTE_VALUE_LENGTH,
        MAX_LABELS_ENTRIES_COUNT,
        MAX_LABELS_KEY_VALUE_LENGTH,
        MAX_LABELS_KEY_VALUE_BYTES,
        MAX_OBJECT_IDS_PER_DELETE_OBJECTS_REQUEST,
        SPLIT_TOKEN_MAX_VALID_DAYS,
      };
    }

    public static Values valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int index;
    private final int value;

    private Values(int index, int value) {
      this.index = index;
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.storage.v2.ServiceConstants.Values)
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.storage.v2.ServiceConstants)) {
      return super.equals(obj);
    }
    com.google.storage.v2.ServiceConstants other = (com.google.storage.v2.ServiceConstants) obj;

    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.storage.v2.ServiceConstants parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.ServiceConstants parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.ServiceConstants parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.ServiceConstants parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.ServiceConstants parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.ServiceConstants parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.ServiceConstants parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.ServiceConstants parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.storage.v2.ServiceConstants parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.ServiceConstants parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.storage.v2.ServiceConstants parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.ServiceConstants parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.storage.v2.ServiceConstants prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Shared constants.
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.ServiceConstants}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.storage.v2.ServiceConstants)
      com.google.storage.v2.ServiceConstantsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_ServiceConstants_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_ServiceConstants_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.ServiceConstants.class,
              com.google.storage.v2.ServiceConstants.Builder.class);
    }

    // Construct using com.google.storage.v2.ServiceConstants.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_ServiceConstants_descriptor;
    }

    @java.lang.Override
    public com.google.storage.v2.ServiceConstants getDefaultInstanceForType() {
      return com.google.storage.v2.ServiceConstants.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.storage.v2.ServiceConstants build() {
      com.google.storage.v2.ServiceConstants result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.storage.v2.ServiceConstants buildPartial() {
      com.google.storage.v2.ServiceConstants result =
          new com.google.storage.v2.ServiceConstants(this);
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.storage.v2.ServiceConstants) {
        return mergeFrom((com.google.storage.v2.ServiceConstants) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.storage.v2.ServiceConstants other) {
      if (other == com.google.storage.v2.ServiceConstants.getDefaultInstance()) return this;
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.storage.v2.ServiceConstants)
  }

  // @@protoc_insertion_point(class_scope:google.storage.v2.ServiceConstants)
  private static final com.google.storage.v2.ServiceConstants DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.storage.v2.ServiceConstants();
  }

  public static com.google.storage.v2.ServiceConstants getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ServiceConstants> PARSER =
      new com.google.protobuf.AbstractParser<ServiceConstants>() {
        @java.lang.Override
        public ServiceConstants parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ServiceConstants> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ServiceConstants> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.storage.v2.ServiceConstants getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
