/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/storage/v2/storage.proto

// Protobuf Java Version: 3.25.8
package com.google.storage.v2;

public interface BucketOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.storage.v2.Bucket)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Identifier. The name of the bucket.
   * Format: `projects/{project}/buckets/{bucket}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The name.
   */
  java.lang.String getName();

  /**
   *
   *
   * <pre>
   * Identifier. The name of the bucket.
   * Format: `projects/{project}/buckets/{bucket}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Output only. The user-chosen part of the bucket name. The `{bucket}`
   * portion of the `name` field. For globally unique buckets, this is equal to
   * the `bucket name` of other Cloud Storage APIs. Example: `pub`.
   * </pre>
   *
   * <code>string bucket_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bucketId.
   */
  java.lang.String getBucketId();

  /**
   *
   *
   * <pre>
   * Output only. The user-chosen part of the bucket name. The `{bucket}`
   * portion of the `name` field. For globally unique buckets, this is equal to
   * the `bucket name` of other Cloud Storage APIs. Example: `pub`.
   * </pre>
   *
   * <code>string bucket_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for bucketId.
   */
  com.google.protobuf.ByteString getBucketIdBytes();

  /**
   *
   *
   * <pre>
   * The etag of the bucket.
   * If included in the metadata of an `UpdateBucketRequest`, the operation is
   * only performed if the `etag` matches that of the bucket.
   * </pre>
   *
   * <code>string etag = 29;</code>
   *
   * @return The etag.
   */
  java.lang.String getEtag();

  /**
   *
   *
   * <pre>
   * The etag of the bucket.
   * If included in the metadata of an `UpdateBucketRequest`, the operation is
   * only performed if the `etag` matches that of the bucket.
   * </pre>
   *
   * <code>string etag = 29;</code>
   *
   * @return The bytes for etag.
   */
  com.google.protobuf.ByteString getEtagBytes();

  /**
   *
   *
   * <pre>
   * Immutable. The project which owns this bucket, in the format of
   * `projects/{projectIdentifier}`.
   * `{projectIdentifier}` can be the project ID or project number.
   * Output values are always in the project number format.
   * </pre>
   *
   * <code>
   * string project = 3 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The project.
   */
  java.lang.String getProject();

  /**
   *
   *
   * <pre>
   * Immutable. The project which owns this bucket, in the format of
   * `projects/{projectIdentifier}`.
   * `{projectIdentifier}` can be the project ID or project number.
   * Output values are always in the project number format.
   * </pre>
   *
   * <code>
   * string project = 3 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for project.
   */
  com.google.protobuf.ByteString getProjectBytes();

  /**
   *
   *
   * <pre>
   * Output only. The metadata generation of this bucket.
   * </pre>
   *
   * <code>int64 metageneration = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The metageneration.
   */
  long getMetageneration();

  /**
   *
   *
   * <pre>
   * Immutable. The location of the bucket. Object data for objects in the
   * bucket resides in physical storage within this region.  Defaults to `US`.
   * Attempting to update this field after the bucket is created results in an
   * error.
   * </pre>
   *
   * <code>string location = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The location.
   */
  java.lang.String getLocation();

  /**
   *
   *
   * <pre>
   * Immutable. The location of the bucket. Object data for objects in the
   * bucket resides in physical storage within this region.  Defaults to `US`.
   * Attempting to update this field after the bucket is created results in an
   * error.
   * </pre>
   *
   * <code>string location = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for location.
   */
  com.google.protobuf.ByteString getLocationBytes();

  /**
   *
   *
   * <pre>
   * Output only. The location type of the bucket (region, dual-region,
   * multi-region, etc).
   * </pre>
   *
   * <code>string location_type = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The locationType.
   */
  java.lang.String getLocationType();

  /**
   *
   *
   * <pre>
   * Output only. The location type of the bucket (region, dual-region,
   * multi-region, etc).
   * </pre>
   *
   * <code>string location_type = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for locationType.
   */
  com.google.protobuf.ByteString getLocationTypeBytes();

  /**
   *
   *
   * <pre>
   * Optional. The bucket's default storage class, used whenever no storageClass
   * is specified for a newly-created object. This defines how objects in the
   * bucket are stored and determines the SLA and the cost of storage.
   * If this value is not specified when the bucket is created, it defaults
   * to `STANDARD`. For more information, see [Storage
   * classes](https://developers.google.com/storage/docs/storage-classes).
   * </pre>
   *
   * <code>string storage_class = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The storageClass.
   */
  java.lang.String getStorageClass();

  /**
   *
   *
   * <pre>
   * Optional. The bucket's default storage class, used whenever no storageClass
   * is specified for a newly-created object. This defines how objects in the
   * bucket are stored and determines the SLA and the cost of storage.
   * If this value is not specified when the bucket is created, it defaults
   * to `STANDARD`. For more information, see [Storage
   * classes](https://developers.google.com/storage/docs/storage-classes).
   * </pre>
   *
   * <code>string storage_class = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for storageClass.
   */
  com.google.protobuf.ByteString getStorageClassBytes();

  /**
   *
   *
   * <pre>
   * Optional. The recovery point objective for cross-region replication of the
   * bucket. Applicable only for dual- and multi-region buckets. `DEFAULT` uses
   * default replication. `ASYNC_TURBO` enables turbo replication, valid for
   * dual-region buckets only. If rpo is not specified when the bucket is
   * created, it defaults to `DEFAULT`. For more information, see [Turbo
   * replication](https://cloud.google.com/storage/docs/availability-durability#turbo-replication).
   * </pre>
   *
   * <code>string rpo = 27 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The rpo.
   */
  java.lang.String getRpo();

  /**
   *
   *
   * <pre>
   * Optional. The recovery point objective for cross-region replication of the
   * bucket. Applicable only for dual- and multi-region buckets. `DEFAULT` uses
   * default replication. `ASYNC_TURBO` enables turbo replication, valid for
   * dual-region buckets only. If rpo is not specified when the bucket is
   * created, it defaults to `DEFAULT`. For more information, see [Turbo
   * replication](https://cloud.google.com/storage/docs/availability-durability#turbo-replication).
   * </pre>
   *
   * <code>string rpo = 27 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for rpo.
   */
  com.google.protobuf.ByteString getRpoBytes();

  /**
   *
   *
   * <pre>
   * Optional. Access controls on the bucket.
   * If `iam_config.uniform_bucket_level_access` is enabled on this bucket,
   * requests to set, read, or modify acl is an error.
   * </pre>
   *
   * <code>
   * repeated .google.storage.v2.BucketAccessControl acl = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.util.List<com.google.storage.v2.BucketAccessControl> getAclList();

  /**
   *
   *
   * <pre>
   * Optional. Access controls on the bucket.
   * If `iam_config.uniform_bucket_level_access` is enabled on this bucket,
   * requests to set, read, or modify acl is an error.
   * </pre>
   *
   * <code>
   * repeated .google.storage.v2.BucketAccessControl acl = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.storage.v2.BucketAccessControl getAcl(int index);

  /**
   *
   *
   * <pre>
   * Optional. Access controls on the bucket.
   * If `iam_config.uniform_bucket_level_access` is enabled on this bucket,
   * requests to set, read, or modify acl is an error.
   * </pre>
   *
   * <code>
   * repeated .google.storage.v2.BucketAccessControl acl = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  int getAclCount();

  /**
   *
   *
   * <pre>
   * Optional. Access controls on the bucket.
   * If `iam_config.uniform_bucket_level_access` is enabled on this bucket,
   * requests to set, read, or modify acl is an error.
   * </pre>
   *
   * <code>
   * repeated .google.storage.v2.BucketAccessControl acl = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.util.List<? extends com.google.storage.v2.BucketAccessControlOrBuilder>
      getAclOrBuilderList();

  /**
   *
   *
   * <pre>
   * Optional. Access controls on the bucket.
   * If `iam_config.uniform_bucket_level_access` is enabled on this bucket,
   * requests to set, read, or modify acl is an error.
   * </pre>
   *
   * <code>
   * repeated .google.storage.v2.BucketAccessControl acl = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.storage.v2.BucketAccessControlOrBuilder getAclOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Optional. Default access controls to apply to new objects when no ACL is
   * provided. If `iam_config.uniform_bucket_level_access` is enabled on this
   * bucket, requests to set, read, or modify acl is an error.
   * </pre>
   *
   * <code>
   * repeated .google.storage.v2.ObjectAccessControl default_object_acl = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.util.List<com.google.storage.v2.ObjectAccessControl> getDefaultObjectAclList();

  /**
   *
   *
   * <pre>
   * Optional. Default access controls to apply to new objects when no ACL is
   * provided. If `iam_config.uniform_bucket_level_access` is enabled on this
   * bucket, requests to set, read, or modify acl is an error.
   * </pre>
   *
   * <code>
   * repeated .google.storage.v2.ObjectAccessControl default_object_acl = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.storage.v2.ObjectAccessControl getDefaultObjectAcl(int index);

  /**
   *
   *
   * <pre>
   * Optional. Default access controls to apply to new objects when no ACL is
   * provided. If `iam_config.uniform_bucket_level_access` is enabled on this
   * bucket, requests to set, read, or modify acl is an error.
   * </pre>
   *
   * <code>
   * repeated .google.storage.v2.ObjectAccessControl default_object_acl = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  int getDefaultObjectAclCount();

  /**
   *
   *
   * <pre>
   * Optional. Default access controls to apply to new objects when no ACL is
   * provided. If `iam_config.uniform_bucket_level_access` is enabled on this
   * bucket, requests to set, read, or modify acl is an error.
   * </pre>
   *
   * <code>
   * repeated .google.storage.v2.ObjectAccessControl default_object_acl = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.util.List<? extends com.google.storage.v2.ObjectAccessControlOrBuilder>
      getDefaultObjectAclOrBuilderList();

  /**
   *
   *
   * <pre>
   * Optional. Default access controls to apply to new objects when no ACL is
   * provided. If `iam_config.uniform_bucket_level_access` is enabled on this
   * bucket, requests to set, read, or modify acl is an error.
   * </pre>
   *
   * <code>
   * repeated .google.storage.v2.ObjectAccessControl default_object_acl = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.storage.v2.ObjectAccessControlOrBuilder getDefaultObjectAclOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Optional. The bucket's lifecycle configuration. See [Lifecycle
   * Management](https://developers.google.com/storage/docs/lifecycle) for more
   * information.
   * </pre>
   *
   * <code>
   * .google.storage.v2.Bucket.Lifecycle lifecycle = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the lifecycle field is set.
   */
  boolean hasLifecycle();

  /**
   *
   *
   * <pre>
   * Optional. The bucket's lifecycle configuration. See [Lifecycle
   * Management](https://developers.google.com/storage/docs/lifecycle) for more
   * information.
   * </pre>
   *
   * <code>
   * .google.storage.v2.Bucket.Lifecycle lifecycle = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The lifecycle.
   */
  com.google.storage.v2.Bucket.Lifecycle getLifecycle();

  /**
   *
   *
   * <pre>
   * Optional. The bucket's lifecycle configuration. See [Lifecycle
   * Management](https://developers.google.com/storage/docs/lifecycle) for more
   * information.
   * </pre>
   *
   * <code>
   * .google.storage.v2.Bucket.Lifecycle lifecycle = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.storage.v2.Bucket.LifecycleOrBuilder getLifecycleOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. The creation time of the bucket.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  boolean hasCreateTime();

  /**
   *
   *
   * <pre>
   * Output only. The creation time of the bucket.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  com.google.protobuf.Timestamp getCreateTime();

  /**
   *
   *
   * <pre>
   * Output only. The creation time of the bucket.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. The bucket's [CORS](https://www.w3.org/TR/cors/)
   * configuration.
   * </pre>
   *
   * <code>
   * repeated .google.storage.v2.Bucket.Cors cors = 12 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.util.List<com.google.storage.v2.Bucket.Cors> getCorsList();

  /**
   *
   *
   * <pre>
   * Optional. The bucket's [CORS](https://www.w3.org/TR/cors/)
   * configuration.
   * </pre>
   *
   * <code>
   * repeated .google.storage.v2.Bucket.Cors cors = 12 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.storage.v2.Bucket.Cors getCors(int index);

  /**
   *
   *
   * <pre>
   * Optional. The bucket's [CORS](https://www.w3.org/TR/cors/)
   * configuration.
   * </pre>
   *
   * <code>
   * repeated .google.storage.v2.Bucket.Cors cors = 12 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  int getCorsCount();

  /**
   *
   *
   * <pre>
   * Optional. The bucket's [CORS](https://www.w3.org/TR/cors/)
   * configuration.
   * </pre>
   *
   * <code>
   * repeated .google.storage.v2.Bucket.Cors cors = 12 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.util.List<? extends com.google.storage.v2.Bucket.CorsOrBuilder> getCorsOrBuilderList();

  /**
   *
   *
   * <pre>
   * Optional. The bucket's [CORS](https://www.w3.org/TR/cors/)
   * configuration.
   * </pre>
   *
   * <code>
   * repeated .google.storage.v2.Bucket.Cors cors = 12 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.storage.v2.Bucket.CorsOrBuilder getCorsOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Output only. The modification time of the bucket.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  boolean hasUpdateTime();

  /**
   *
   *
   * <pre>
   * Output only. The modification time of the bucket.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  com.google.protobuf.Timestamp getUpdateTime();

  /**
   *
   *
   * <pre>
   * Output only. The modification time of the bucket.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. The default value for event-based hold on newly created objects
   * in this bucket.  Event-based hold is a way to retain objects indefinitely
   * until an event occurs, signified by the hold's release. After being
   * released, such objects are subject to bucket-level retention (if any).  One
   * sample use case of this flag is for banks to hold loan documents for at
   * least 3 years after loan is paid in full. Here, bucket-level retention is 3
   * years and the event is loan being paid in full. In this example, these
   * objects are held intact for any number of years until the event has
   * occurred (event-based hold on the object is released) and then 3 more years
   * after that. That means retention duration of the objects begins from the
   * moment event-based hold transitioned from true to false.  Objects under
   * event-based hold cannot be deleted, overwritten or archived until the hold
   * is removed.
   * </pre>
   *
   * <code>bool default_event_based_hold = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The defaultEventBasedHold.
   */
  boolean getDefaultEventBasedHold();

  /**
   *
   *
   * <pre>
   * Optional. User-provided labels, in key/value pairs.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  int getLabelsCount();

  /**
   *
   *
   * <pre>
   * Optional. User-provided labels, in key/value pairs.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  boolean containsLabels(java.lang.String key);

  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, java.lang.String> getLabels();

  /**
   *
   *
   * <pre>
   * Optional. User-provided labels, in key/value pairs.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  java.util.Map<java.lang.String, java.lang.String> getLabelsMap();

  /**
   *
   *
   * <pre>
   * Optional. User-provided labels, in key/value pairs.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  /* nullable */
  java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue);

  /**
   *
   *
   * <pre>
   * Optional. User-provided labels, in key/value pairs.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  java.lang.String getLabelsOrThrow(java.lang.String key);

  /**
   *
   *
   * <pre>
   * Optional. The bucket's website config, controlling how the service behaves
   * when accessing bucket contents as a web site. See the [Static website
   * examples](https://cloud.google.com/storage/docs/static-website) for more
   * information.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.Website website = 16 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the website field is set.
   */
  boolean hasWebsite();

  /**
   *
   *
   * <pre>
   * Optional. The bucket's website config, controlling how the service behaves
   * when accessing bucket contents as a web site. See the [Static website
   * examples](https://cloud.google.com/storage/docs/static-website) for more
   * information.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.Website website = 16 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The website.
   */
  com.google.storage.v2.Bucket.Website getWebsite();

  /**
   *
   *
   * <pre>
   * Optional. The bucket's website config, controlling how the service behaves
   * when accessing bucket contents as a web site. See the [Static website
   * examples](https://cloud.google.com/storage/docs/static-website) for more
   * information.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.Website website = 16 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.storage.v2.Bucket.WebsiteOrBuilder getWebsiteOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. The bucket's versioning configuration.
   * </pre>
   *
   * <code>
   * .google.storage.v2.Bucket.Versioning versioning = 17 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the versioning field is set.
   */
  boolean hasVersioning();

  /**
   *
   *
   * <pre>
   * Optional. The bucket's versioning configuration.
   * </pre>
   *
   * <code>
   * .google.storage.v2.Bucket.Versioning versioning = 17 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The versioning.
   */
  com.google.storage.v2.Bucket.Versioning getVersioning();

  /**
   *
   *
   * <pre>
   * Optional. The bucket's versioning configuration.
   * </pre>
   *
   * <code>
   * .google.storage.v2.Bucket.Versioning versioning = 17 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.storage.v2.Bucket.VersioningOrBuilder getVersioningOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. The bucket's logging config, which defines the destination bucket
   * and name prefix (if any) for the current bucket's logs.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.Logging logging = 18 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the logging field is set.
   */
  boolean hasLogging();

  /**
   *
   *
   * <pre>
   * Optional. The bucket's logging config, which defines the destination bucket
   * and name prefix (if any) for the current bucket's logs.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.Logging logging = 18 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The logging.
   */
  com.google.storage.v2.Bucket.Logging getLogging();

  /**
   *
   *
   * <pre>
   * Optional. The bucket's logging config, which defines the destination bucket
   * and name prefix (if any) for the current bucket's logs.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.Logging logging = 18 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.storage.v2.Bucket.LoggingOrBuilder getLoggingOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. The owner of the bucket. This is always the project team's
   * owner group.
   * </pre>
   *
   * <code>.google.storage.v2.Owner owner = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return Whether the owner field is set.
   */
  boolean hasOwner();

  /**
   *
   *
   * <pre>
   * Output only. The owner of the bucket. This is always the project team's
   * owner group.
   * </pre>
   *
   * <code>.google.storage.v2.Owner owner = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The owner.
   */
  com.google.storage.v2.Owner getOwner();

  /**
   *
   *
   * <pre>
   * Output only. The owner of the bucket. This is always the project team's
   * owner group.
   * </pre>
   *
   * <code>.google.storage.v2.Owner owner = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  com.google.storage.v2.OwnerOrBuilder getOwnerOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. Encryption config for a bucket.
   * </pre>
   *
   * <code>
   * .google.storage.v2.Bucket.Encryption encryption = 20 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the encryption field is set.
   */
  boolean hasEncryption();

  /**
   *
   *
   * <pre>
   * Optional. Encryption config for a bucket.
   * </pre>
   *
   * <code>
   * .google.storage.v2.Bucket.Encryption encryption = 20 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The encryption.
   */
  com.google.storage.v2.Bucket.Encryption getEncryption();

  /**
   *
   *
   * <pre>
   * Optional. Encryption config for a bucket.
   * </pre>
   *
   * <code>
   * .google.storage.v2.Bucket.Encryption encryption = 20 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.storage.v2.Bucket.EncryptionOrBuilder getEncryptionOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. The bucket's billing configuration.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.Billing billing = 21 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the billing field is set.
   */
  boolean hasBilling();

  /**
   *
   *
   * <pre>
   * Optional. The bucket's billing configuration.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.Billing billing = 21 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The billing.
   */
  com.google.storage.v2.Bucket.Billing getBilling();

  /**
   *
   *
   * <pre>
   * Optional. The bucket's billing configuration.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.Billing billing = 21 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.storage.v2.Bucket.BillingOrBuilder getBillingOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. The bucket's retention policy. The retention policy enforces a
   * minimum retention time for all objects contained in the bucket, based on
   * their creation time. Any attempt to overwrite or delete objects younger
   * than the retention period results in a `PERMISSION_DENIED` error.  An
   * unlocked retention policy can be modified or removed from the bucket via a
   * storage.buckets.update operation. A locked retention policy cannot be
   * removed or shortened in duration for the lifetime of the bucket.
   * Attempting to remove or decrease period of a locked retention policy
   * results in a `PERMISSION_DENIED` error.
   * </pre>
   *
   * <code>
   * .google.storage.v2.Bucket.RetentionPolicy retention_policy = 22 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the retentionPolicy field is set.
   */
  boolean hasRetentionPolicy();

  /**
   *
   *
   * <pre>
   * Optional. The bucket's retention policy. The retention policy enforces a
   * minimum retention time for all objects contained in the bucket, based on
   * their creation time. Any attempt to overwrite or delete objects younger
   * than the retention period results in a `PERMISSION_DENIED` error.  An
   * unlocked retention policy can be modified or removed from the bucket via a
   * storage.buckets.update operation. A locked retention policy cannot be
   * removed or shortened in duration for the lifetime of the bucket.
   * Attempting to remove or decrease period of a locked retention policy
   * results in a `PERMISSION_DENIED` error.
   * </pre>
   *
   * <code>
   * .google.storage.v2.Bucket.RetentionPolicy retention_policy = 22 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The retentionPolicy.
   */
  com.google.storage.v2.Bucket.RetentionPolicy getRetentionPolicy();

  /**
   *
   *
   * <pre>
   * Optional. The bucket's retention policy. The retention policy enforces a
   * minimum retention time for all objects contained in the bucket, based on
   * their creation time. Any attempt to overwrite or delete objects younger
   * than the retention period results in a `PERMISSION_DENIED` error.  An
   * unlocked retention policy can be modified or removed from the bucket via a
   * storage.buckets.update operation. A locked retention policy cannot be
   * removed or shortened in duration for the lifetime of the bucket.
   * Attempting to remove or decrease period of a locked retention policy
   * results in a `PERMISSION_DENIED` error.
   * </pre>
   *
   * <code>
   * .google.storage.v2.Bucket.RetentionPolicy retention_policy = 22 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.storage.v2.Bucket.RetentionPolicyOrBuilder getRetentionPolicyOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. The bucket's IAM configuration.
   * </pre>
   *
   * <code>
   * .google.storage.v2.Bucket.IamConfig iam_config = 23 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the iamConfig field is set.
   */
  boolean hasIamConfig();

  /**
   *
   *
   * <pre>
   * Optional. The bucket's IAM configuration.
   * </pre>
   *
   * <code>
   * .google.storage.v2.Bucket.IamConfig iam_config = 23 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The iamConfig.
   */
  com.google.storage.v2.Bucket.IamConfig getIamConfig();

  /**
   *
   *
   * <pre>
   * Optional. The bucket's IAM configuration.
   * </pre>
   *
   * <code>
   * .google.storage.v2.Bucket.IamConfig iam_config = 23 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.storage.v2.Bucket.IamConfigOrBuilder getIamConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. Reserved for future use.
   * </pre>
   *
   * <code>bool satisfies_pzs = 25 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The satisfiesPzs.
   */
  boolean getSatisfiesPzs();

  /**
   *
   *
   * <pre>
   * Optional. Configuration that, if present, specifies the data placement for
   * a [configurable
   * dual-region](https://cloud.google.com/storage/docs/locations#location-dr).
   * </pre>
   *
   * <code>
   * .google.storage.v2.Bucket.CustomPlacementConfig custom_placement_config = 26 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the customPlacementConfig field is set.
   */
  boolean hasCustomPlacementConfig();

  /**
   *
   *
   * <pre>
   * Optional. Configuration that, if present, specifies the data placement for
   * a [configurable
   * dual-region](https://cloud.google.com/storage/docs/locations#location-dr).
   * </pre>
   *
   * <code>
   * .google.storage.v2.Bucket.CustomPlacementConfig custom_placement_config = 26 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The customPlacementConfig.
   */
  com.google.storage.v2.Bucket.CustomPlacementConfig getCustomPlacementConfig();

  /**
   *
   *
   * <pre>
   * Optional. Configuration that, if present, specifies the data placement for
   * a [configurable
   * dual-region](https://cloud.google.com/storage/docs/locations#location-dr).
   * </pre>
   *
   * <code>
   * .google.storage.v2.Bucket.CustomPlacementConfig custom_placement_config = 26 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.storage.v2.Bucket.CustomPlacementConfigOrBuilder getCustomPlacementConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. The bucket's Autoclass configuration. If there is no
   * configuration, the Autoclass feature is disabled and has no effect on the
   * bucket.
   * </pre>
   *
   * <code>
   * .google.storage.v2.Bucket.Autoclass autoclass = 28 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the autoclass field is set.
   */
  boolean hasAutoclass();

  /**
   *
   *
   * <pre>
   * Optional. The bucket's Autoclass configuration. If there is no
   * configuration, the Autoclass feature is disabled and has no effect on the
   * bucket.
   * </pre>
   *
   * <code>
   * .google.storage.v2.Bucket.Autoclass autoclass = 28 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The autoclass.
   */
  com.google.storage.v2.Bucket.Autoclass getAutoclass();

  /**
   *
   *
   * <pre>
   * Optional. The bucket's Autoclass configuration. If there is no
   * configuration, the Autoclass feature is disabled and has no effect on the
   * bucket.
   * </pre>
   *
   * <code>
   * .google.storage.v2.Bucket.Autoclass autoclass = 28 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.storage.v2.Bucket.AutoclassOrBuilder getAutoclassOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. The bucket's hierarchical namespace configuration. If there is no
   * configuration, the hierarchical namespace feature is disabled and has
   * no effect on the bucket.
   * </pre>
   *
   * <code>
   * .google.storage.v2.Bucket.HierarchicalNamespace hierarchical_namespace = 32 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the hierarchicalNamespace field is set.
   */
  boolean hasHierarchicalNamespace();

  /**
   *
   *
   * <pre>
   * Optional. The bucket's hierarchical namespace configuration. If there is no
   * configuration, the hierarchical namespace feature is disabled and has
   * no effect on the bucket.
   * </pre>
   *
   * <code>
   * .google.storage.v2.Bucket.HierarchicalNamespace hierarchical_namespace = 32 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The hierarchicalNamespace.
   */
  com.google.storage.v2.Bucket.HierarchicalNamespace getHierarchicalNamespace();

  /**
   *
   *
   * <pre>
   * Optional. The bucket's hierarchical namespace configuration. If there is no
   * configuration, the hierarchical namespace feature is disabled and has
   * no effect on the bucket.
   * </pre>
   *
   * <code>
   * .google.storage.v2.Bucket.HierarchicalNamespace hierarchical_namespace = 32 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.storage.v2.Bucket.HierarchicalNamespaceOrBuilder getHierarchicalNamespaceOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. The bucket's soft delete policy. The soft delete policy prevents
   * soft-deleted objects from being permanently deleted.
   * </pre>
   *
   * <code>
   * .google.storage.v2.Bucket.SoftDeletePolicy soft_delete_policy = 31 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the softDeletePolicy field is set.
   */
  boolean hasSoftDeletePolicy();

  /**
   *
   *
   * <pre>
   * Optional. The bucket's soft delete policy. The soft delete policy prevents
   * soft-deleted objects from being permanently deleted.
   * </pre>
   *
   * <code>
   * .google.storage.v2.Bucket.SoftDeletePolicy soft_delete_policy = 31 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The softDeletePolicy.
   */
  com.google.storage.v2.Bucket.SoftDeletePolicy getSoftDeletePolicy();

  /**
   *
   *
   * <pre>
   * Optional. The bucket's soft delete policy. The soft delete policy prevents
   * soft-deleted objects from being permanently deleted.
   * </pre>
   *
   * <code>
   * .google.storage.v2.Bucket.SoftDeletePolicy soft_delete_policy = 31 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.storage.v2.Bucket.SoftDeletePolicyOrBuilder getSoftDeletePolicyOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. The bucket's object retention configuration. Must be enabled
   * before objects in the bucket might have retention configured.
   * </pre>
   *
   * <code>
   * .google.storage.v2.Bucket.ObjectRetention object_retention = 33 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the objectRetention field is set.
   */
  boolean hasObjectRetention();

  /**
   *
   *
   * <pre>
   * Optional. The bucket's object retention configuration. Must be enabled
   * before objects in the bucket might have retention configured.
   * </pre>
   *
   * <code>
   * .google.storage.v2.Bucket.ObjectRetention object_retention = 33 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The objectRetention.
   */
  com.google.storage.v2.Bucket.ObjectRetention getObjectRetention();

  /**
   *
   *
   * <pre>
   * Optional. The bucket's object retention configuration. Must be enabled
   * before objects in the bucket might have retention configured.
   * </pre>
   *
   * <code>
   * .google.storage.v2.Bucket.ObjectRetention object_retention = 33 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.storage.v2.Bucket.ObjectRetentionOrBuilder getObjectRetentionOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. The bucket's IP filter configuration.
   * </pre>
   *
   * <code>
   * optional .google.storage.v2.Bucket.IpFilter ip_filter = 38 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the ipFilter field is set.
   */
  boolean hasIpFilter();

  /**
   *
   *
   * <pre>
   * Optional. The bucket's IP filter configuration.
   * </pre>
   *
   * <code>
   * optional .google.storage.v2.Bucket.IpFilter ip_filter = 38 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The ipFilter.
   */
  com.google.storage.v2.Bucket.IpFilter getIpFilter();

  /**
   *
   *
   * <pre>
   * Optional. The bucket's IP filter configuration.
   * </pre>
   *
   * <code>
   * optional .google.storage.v2.Bucket.IpFilter ip_filter = 38 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.storage.v2.Bucket.IpFilterOrBuilder getIpFilterOrBuilder();
}
