/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/storage/v2/storage.proto

// Protobuf Java Version: 3.25.5
package com.google.storage.v2;

/**
 *
 *
 * <pre>
 * Error proto containing details for a redirected write. This error is only
 * returned on initial open in case of a redirect.
 * </pre>
 *
 * Protobuf type {@code google.storage.v2.BidiWriteObjectRedirectedError}
 */
public final class BidiWriteObjectRedirectedError extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.storage.v2.BidiWriteObjectRedirectedError)
    BidiWriteObjectRedirectedErrorOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BidiWriteObjectRedirectedError.newBuilder() to construct.
  private BidiWriteObjectRedirectedError(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BidiWriteObjectRedirectedError() {
    routingToken_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BidiWriteObjectRedirectedError();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.storage.v2.StorageProto
        .internal_static_google_storage_v2_BidiWriteObjectRedirectedError_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.storage.v2.StorageProto
        .internal_static_google_storage_v2_BidiWriteObjectRedirectedError_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.storage.v2.BidiWriteObjectRedirectedError.class,
            com.google.storage.v2.BidiWriteObjectRedirectedError.Builder.class);
  }

  private int bitField0_;
  public static final int ROUTING_TOKEN_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object routingToken_ = "";
  /**
   *
   *
   * <pre>
   * The routing token that should be used when reopening the write stream.
   * </pre>
   *
   * <code>optional string routing_token = 1;</code>
   *
   * @return Whether the routingToken field is set.
   */
  @java.lang.Override
  public boolean hasRoutingToken() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The routing token that should be used when reopening the write stream.
   * </pre>
   *
   * <code>optional string routing_token = 1;</code>
   *
   * @return The routingToken.
   */
  @java.lang.Override
  public java.lang.String getRoutingToken() {
    java.lang.Object ref = routingToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      routingToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The routing token that should be used when reopening the write stream.
   * </pre>
   *
   * <code>optional string routing_token = 1;</code>
   *
   * @return The bytes for routingToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRoutingTokenBytes() {
    java.lang.Object ref = routingToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      routingToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int WRITE_HANDLE_FIELD_NUMBER = 2;
  private com.google.storage.v2.BidiWriteHandle writeHandle_;
  /**
   *
   *
   * <pre>
   * Opaque value describing a previous write.
   * </pre>
   *
   * <code>optional .google.storage.v2.BidiWriteHandle write_handle = 2;</code>
   *
   * @return Whether the writeHandle field is set.
   */
  @java.lang.Override
  public boolean hasWriteHandle() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Opaque value describing a previous write.
   * </pre>
   *
   * <code>optional .google.storage.v2.BidiWriteHandle write_handle = 2;</code>
   *
   * @return The writeHandle.
   */
  @java.lang.Override
  public com.google.storage.v2.BidiWriteHandle getWriteHandle() {
    return writeHandle_ == null
        ? com.google.storage.v2.BidiWriteHandle.getDefaultInstance()
        : writeHandle_;
  }
  /**
   *
   *
   * <pre>
   * Opaque value describing a previous write.
   * </pre>
   *
   * <code>optional .google.storage.v2.BidiWriteHandle write_handle = 2;</code>
   */
  @java.lang.Override
  public com.google.storage.v2.BidiWriteHandleOrBuilder getWriteHandleOrBuilder() {
    return writeHandle_ == null
        ? com.google.storage.v2.BidiWriteHandle.getDefaultInstance()
        : writeHandle_;
  }

  public static final int GENERATION_FIELD_NUMBER = 3;
  private long generation_ = 0L;
  /**
   *
   *
   * <pre>
   * The generation of the object that triggered the redirect.
   * Note that if this error was returned as part of an appendable object
   * create, this object generation is now successfully created and
   * append_object_spec should be used when reconnecting.
   * </pre>
   *
   * <code>optional int64 generation = 3;</code>
   *
   * @return Whether the generation field is set.
   */
  @java.lang.Override
  public boolean hasGeneration() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * The generation of the object that triggered the redirect.
   * Note that if this error was returned as part of an appendable object
   * create, this object generation is now successfully created and
   * append_object_spec should be used when reconnecting.
   * </pre>
   *
   * <code>optional int64 generation = 3;</code>
   *
   * @return The generation.
   */
  @java.lang.Override
  public long getGeneration() {
    return generation_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, routingToken_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getWriteHandle());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeInt64(3, generation_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, routingToken_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getWriteHandle());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(3, generation_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.storage.v2.BidiWriteObjectRedirectedError)) {
      return super.equals(obj);
    }
    com.google.storage.v2.BidiWriteObjectRedirectedError other =
        (com.google.storage.v2.BidiWriteObjectRedirectedError) obj;

    if (hasRoutingToken() != other.hasRoutingToken()) return false;
    if (hasRoutingToken()) {
      if (!getRoutingToken().equals(other.getRoutingToken())) return false;
    }
    if (hasWriteHandle() != other.hasWriteHandle()) return false;
    if (hasWriteHandle()) {
      if (!getWriteHandle().equals(other.getWriteHandle())) return false;
    }
    if (hasGeneration() != other.hasGeneration()) return false;
    if (hasGeneration()) {
      if (getGeneration() != other.getGeneration()) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasRoutingToken()) {
      hash = (37 * hash) + ROUTING_TOKEN_FIELD_NUMBER;
      hash = (53 * hash) + getRoutingToken().hashCode();
    }
    if (hasWriteHandle()) {
      hash = (37 * hash) + WRITE_HANDLE_FIELD_NUMBER;
      hash = (53 * hash) + getWriteHandle().hashCode();
    }
    if (hasGeneration()) {
      hash = (37 * hash) + GENERATION_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getGeneration());
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.storage.v2.BidiWriteObjectRedirectedError parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.BidiWriteObjectRedirectedError parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.BidiWriteObjectRedirectedError parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.BidiWriteObjectRedirectedError parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.BidiWriteObjectRedirectedError parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.BidiWriteObjectRedirectedError parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.BidiWriteObjectRedirectedError parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.BidiWriteObjectRedirectedError parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.storage.v2.BidiWriteObjectRedirectedError parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.BidiWriteObjectRedirectedError parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.storage.v2.BidiWriteObjectRedirectedError parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.BidiWriteObjectRedirectedError parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.storage.v2.BidiWriteObjectRedirectedError prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Error proto containing details for a redirected write. This error is only
   * returned on initial open in case of a redirect.
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.BidiWriteObjectRedirectedError}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.storage.v2.BidiWriteObjectRedirectedError)
      com.google.storage.v2.BidiWriteObjectRedirectedErrorOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_BidiWriteObjectRedirectedError_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_BidiWriteObjectRedirectedError_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.BidiWriteObjectRedirectedError.class,
              com.google.storage.v2.BidiWriteObjectRedirectedError.Builder.class);
    }

    // Construct using com.google.storage.v2.BidiWriteObjectRedirectedError.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getWriteHandleFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      routingToken_ = "";
      writeHandle_ = null;
      if (writeHandleBuilder_ != null) {
        writeHandleBuilder_.dispose();
        writeHandleBuilder_ = null;
      }
      generation_ = 0L;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_BidiWriteObjectRedirectedError_descriptor;
    }

    @java.lang.Override
    public com.google.storage.v2.BidiWriteObjectRedirectedError getDefaultInstanceForType() {
      return com.google.storage.v2.BidiWriteObjectRedirectedError.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.storage.v2.BidiWriteObjectRedirectedError build() {
      com.google.storage.v2.BidiWriteObjectRedirectedError result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.storage.v2.BidiWriteObjectRedirectedError buildPartial() {
      com.google.storage.v2.BidiWriteObjectRedirectedError result =
          new com.google.storage.v2.BidiWriteObjectRedirectedError(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.storage.v2.BidiWriteObjectRedirectedError result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.routingToken_ = routingToken_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.writeHandle_ =
            writeHandleBuilder_ == null ? writeHandle_ : writeHandleBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.generation_ = generation_;
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.storage.v2.BidiWriteObjectRedirectedError) {
        return mergeFrom((com.google.storage.v2.BidiWriteObjectRedirectedError) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.storage.v2.BidiWriteObjectRedirectedError other) {
      if (other == com.google.storage.v2.BidiWriteObjectRedirectedError.getDefaultInstance())
        return this;
      if (other.hasRoutingToken()) {
        routingToken_ = other.routingToken_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasWriteHandle()) {
        mergeWriteHandle(other.getWriteHandle());
      }
      if (other.hasGeneration()) {
        setGeneration(other.getGeneration());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                routingToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getWriteHandleFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                generation_ = input.readInt64();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object routingToken_ = "";
    /**
     *
     *
     * <pre>
     * The routing token that should be used when reopening the write stream.
     * </pre>
     *
     * <code>optional string routing_token = 1;</code>
     *
     * @return Whether the routingToken field is set.
     */
    public boolean hasRoutingToken() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The routing token that should be used when reopening the write stream.
     * </pre>
     *
     * <code>optional string routing_token = 1;</code>
     *
     * @return The routingToken.
     */
    public java.lang.String getRoutingToken() {
      java.lang.Object ref = routingToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        routingToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The routing token that should be used when reopening the write stream.
     * </pre>
     *
     * <code>optional string routing_token = 1;</code>
     *
     * @return The bytes for routingToken.
     */
    public com.google.protobuf.ByteString getRoutingTokenBytes() {
      java.lang.Object ref = routingToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        routingToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The routing token that should be used when reopening the write stream.
     * </pre>
     *
     * <code>optional string routing_token = 1;</code>
     *
     * @param value The routingToken to set.
     * @return This builder for chaining.
     */
    public Builder setRoutingToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      routingToken_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The routing token that should be used when reopening the write stream.
     * </pre>
     *
     * <code>optional string routing_token = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRoutingToken() {
      routingToken_ = getDefaultInstance().getRoutingToken();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The routing token that should be used when reopening the write stream.
     * </pre>
     *
     * <code>optional string routing_token = 1;</code>
     *
     * @param value The bytes for routingToken to set.
     * @return This builder for chaining.
     */
    public Builder setRoutingTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      routingToken_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.storage.v2.BidiWriteHandle writeHandle_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.BidiWriteHandle,
            com.google.storage.v2.BidiWriteHandle.Builder,
            com.google.storage.v2.BidiWriteHandleOrBuilder>
        writeHandleBuilder_;
    /**
     *
     *
     * <pre>
     * Opaque value describing a previous write.
     * </pre>
     *
     * <code>optional .google.storage.v2.BidiWriteHandle write_handle = 2;</code>
     *
     * @return Whether the writeHandle field is set.
     */
    public boolean hasWriteHandle() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Opaque value describing a previous write.
     * </pre>
     *
     * <code>optional .google.storage.v2.BidiWriteHandle write_handle = 2;</code>
     *
     * @return The writeHandle.
     */
    public com.google.storage.v2.BidiWriteHandle getWriteHandle() {
      if (writeHandleBuilder_ == null) {
        return writeHandle_ == null
            ? com.google.storage.v2.BidiWriteHandle.getDefaultInstance()
            : writeHandle_;
      } else {
        return writeHandleBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Opaque value describing a previous write.
     * </pre>
     *
     * <code>optional .google.storage.v2.BidiWriteHandle write_handle = 2;</code>
     */
    public Builder setWriteHandle(com.google.storage.v2.BidiWriteHandle value) {
      if (writeHandleBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        writeHandle_ = value;
      } else {
        writeHandleBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Opaque value describing a previous write.
     * </pre>
     *
     * <code>optional .google.storage.v2.BidiWriteHandle write_handle = 2;</code>
     */
    public Builder setWriteHandle(com.google.storage.v2.BidiWriteHandle.Builder builderForValue) {
      if (writeHandleBuilder_ == null) {
        writeHandle_ = builderForValue.build();
      } else {
        writeHandleBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Opaque value describing a previous write.
     * </pre>
     *
     * <code>optional .google.storage.v2.BidiWriteHandle write_handle = 2;</code>
     */
    public Builder mergeWriteHandle(com.google.storage.v2.BidiWriteHandle value) {
      if (writeHandleBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && writeHandle_ != null
            && writeHandle_ != com.google.storage.v2.BidiWriteHandle.getDefaultInstance()) {
          getWriteHandleBuilder().mergeFrom(value);
        } else {
          writeHandle_ = value;
        }
      } else {
        writeHandleBuilder_.mergeFrom(value);
      }
      if (writeHandle_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Opaque value describing a previous write.
     * </pre>
     *
     * <code>optional .google.storage.v2.BidiWriteHandle write_handle = 2;</code>
     */
    public Builder clearWriteHandle() {
      bitField0_ = (bitField0_ & ~0x00000002);
      writeHandle_ = null;
      if (writeHandleBuilder_ != null) {
        writeHandleBuilder_.dispose();
        writeHandleBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Opaque value describing a previous write.
     * </pre>
     *
     * <code>optional .google.storage.v2.BidiWriteHandle write_handle = 2;</code>
     */
    public com.google.storage.v2.BidiWriteHandle.Builder getWriteHandleBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getWriteHandleFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Opaque value describing a previous write.
     * </pre>
     *
     * <code>optional .google.storage.v2.BidiWriteHandle write_handle = 2;</code>
     */
    public com.google.storage.v2.BidiWriteHandleOrBuilder getWriteHandleOrBuilder() {
      if (writeHandleBuilder_ != null) {
        return writeHandleBuilder_.getMessageOrBuilder();
      } else {
        return writeHandle_ == null
            ? com.google.storage.v2.BidiWriteHandle.getDefaultInstance()
            : writeHandle_;
      }
    }
    /**
     *
     *
     * <pre>
     * Opaque value describing a previous write.
     * </pre>
     *
     * <code>optional .google.storage.v2.BidiWriteHandle write_handle = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.BidiWriteHandle,
            com.google.storage.v2.BidiWriteHandle.Builder,
            com.google.storage.v2.BidiWriteHandleOrBuilder>
        getWriteHandleFieldBuilder() {
      if (writeHandleBuilder_ == null) {
        writeHandleBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.BidiWriteHandle,
                com.google.storage.v2.BidiWriteHandle.Builder,
                com.google.storage.v2.BidiWriteHandleOrBuilder>(
                getWriteHandle(), getParentForChildren(), isClean());
        writeHandle_ = null;
      }
      return writeHandleBuilder_;
    }

    private long generation_;
    /**
     *
     *
     * <pre>
     * The generation of the object that triggered the redirect.
     * Note that if this error was returned as part of an appendable object
     * create, this object generation is now successfully created and
     * append_object_spec should be used when reconnecting.
     * </pre>
     *
     * <code>optional int64 generation = 3;</code>
     *
     * @return Whether the generation field is set.
     */
    @java.lang.Override
    public boolean hasGeneration() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The generation of the object that triggered the redirect.
     * Note that if this error was returned as part of an appendable object
     * create, this object generation is now successfully created and
     * append_object_spec should be used when reconnecting.
     * </pre>
     *
     * <code>optional int64 generation = 3;</code>
     *
     * @return The generation.
     */
    @java.lang.Override
    public long getGeneration() {
      return generation_;
    }
    /**
     *
     *
     * <pre>
     * The generation of the object that triggered the redirect.
     * Note that if this error was returned as part of an appendable object
     * create, this object generation is now successfully created and
     * append_object_spec should be used when reconnecting.
     * </pre>
     *
     * <code>optional int64 generation = 3;</code>
     *
     * @param value The generation to set.
     * @return This builder for chaining.
     */
    public Builder setGeneration(long value) {

      generation_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The generation of the object that triggered the redirect.
     * Note that if this error was returned as part of an appendable object
     * create, this object generation is now successfully created and
     * append_object_spec should be used when reconnecting.
     * </pre>
     *
     * <code>optional int64 generation = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGeneration() {
      bitField0_ = (bitField0_ & ~0x00000004);
      generation_ = 0L;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.storage.v2.BidiWriteObjectRedirectedError)
  }

  // @@protoc_insertion_point(class_scope:google.storage.v2.BidiWriteObjectRedirectedError)
  private static final com.google.storage.v2.BidiWriteObjectRedirectedError DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.storage.v2.BidiWriteObjectRedirectedError();
  }

  public static com.google.storage.v2.BidiWriteObjectRedirectedError getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BidiWriteObjectRedirectedError> PARSER =
      new com.google.protobuf.AbstractParser<BidiWriteObjectRedirectedError>() {
        @java.lang.Override
        public BidiWriteObjectRedirectedError parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BidiWriteObjectRedirectedError> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BidiWriteObjectRedirectedError> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.storage.v2.BidiWriteObjectRedirectedError getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
