/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/storage/v2/storage.proto

// Protobuf Java Version: 3.25.3
package com.google.storage.v2;

/**
 *
 *
 * <pre>
 * A bucket.
 * </pre>
 *
 * Protobuf type {@code google.storage.v2.Bucket}
 */
public final class Bucket extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.storage.v2.Bucket)
    BucketOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Bucket.newBuilder() to construct.
  private Bucket(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Bucket() {
    name_ = "";
    bucketId_ = "";
    etag_ = "";
    project_ = "";
    location_ = "";
    locationType_ = "";
    storageClass_ = "";
    rpo_ = "";
    acl_ = java.util.Collections.emptyList();
    defaultObjectAcl_ = java.util.Collections.emptyList();
    cors_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Bucket();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.storage.v2.StorageProto.internal_static_google_storage_v2_Bucket_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 15:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.storage.v2.StorageProto
        .internal_static_google_storage_v2_Bucket_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.storage.v2.Bucket.class, com.google.storage.v2.Bucket.Builder.class);
  }

  public interface BillingOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storage.v2.Bucket.Billing)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * When set to true, Requester Pays is enabled for this bucket.
     * </pre>
     *
     * <code>bool requester_pays = 1;</code>
     *
     * @return The requesterPays.
     */
    boolean getRequesterPays();
  }
  /**
   *
   *
   * <pre>
   * Billing properties of a bucket.
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.Bucket.Billing}
   */
  public static final class Billing extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storage.v2.Bucket.Billing)
      BillingOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Billing.newBuilder() to construct.
    private Billing(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Billing() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Billing();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_Billing_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_Billing_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.Bucket.Billing.class,
              com.google.storage.v2.Bucket.Billing.Builder.class);
    }

    public static final int REQUESTER_PAYS_FIELD_NUMBER = 1;
    private boolean requesterPays_ = false;
    /**
     *
     *
     * <pre>
     * When set to true, Requester Pays is enabled for this bucket.
     * </pre>
     *
     * <code>bool requester_pays = 1;</code>
     *
     * @return The requesterPays.
     */
    @java.lang.Override
    public boolean getRequesterPays() {
      return requesterPays_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (requesterPays_ != false) {
        output.writeBool(1, requesterPays_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (requesterPays_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, requesterPays_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.storage.v2.Bucket.Billing)) {
        return super.equals(obj);
      }
      com.google.storage.v2.Bucket.Billing other = (com.google.storage.v2.Bucket.Billing) obj;

      if (getRequesterPays() != other.getRequesterPays()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + REQUESTER_PAYS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getRequesterPays());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storage.v2.Bucket.Billing parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Billing parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Billing parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Billing parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Billing parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Billing parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Billing parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Billing parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Billing parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Billing parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Billing parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Billing parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.storage.v2.Bucket.Billing prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Billing properties of a bucket.
     * </pre>
     *
     * Protobuf type {@code google.storage.v2.Bucket.Billing}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storage.v2.Bucket.Billing)
        com.google.storage.v2.Bucket.BillingOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Billing_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Billing_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storage.v2.Bucket.Billing.class,
                com.google.storage.v2.Bucket.Billing.Builder.class);
      }

      // Construct using com.google.storage.v2.Bucket.Billing.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        requesterPays_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Billing_descriptor;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Billing getDefaultInstanceForType() {
        return com.google.storage.v2.Bucket.Billing.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Billing build() {
        com.google.storage.v2.Bucket.Billing result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Billing buildPartial() {
        com.google.storage.v2.Bucket.Billing result =
            new com.google.storage.v2.Bucket.Billing(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.storage.v2.Bucket.Billing result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.requesterPays_ = requesterPays_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.storage.v2.Bucket.Billing) {
          return mergeFrom((com.google.storage.v2.Bucket.Billing) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.storage.v2.Bucket.Billing other) {
        if (other == com.google.storage.v2.Bucket.Billing.getDefaultInstance()) return this;
        if (other.getRequesterPays() != false) {
          setRequesterPays(other.getRequesterPays());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  requesterPays_ = input.readBool();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private boolean requesterPays_;
      /**
       *
       *
       * <pre>
       * When set to true, Requester Pays is enabled for this bucket.
       * </pre>
       *
       * <code>bool requester_pays = 1;</code>
       *
       * @return The requesterPays.
       */
      @java.lang.Override
      public boolean getRequesterPays() {
        return requesterPays_;
      }
      /**
       *
       *
       * <pre>
       * When set to true, Requester Pays is enabled for this bucket.
       * </pre>
       *
       * <code>bool requester_pays = 1;</code>
       *
       * @param value The requesterPays to set.
       * @return This builder for chaining.
       */
      public Builder setRequesterPays(boolean value) {

        requesterPays_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * When set to true, Requester Pays is enabled for this bucket.
       * </pre>
       *
       * <code>bool requester_pays = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRequesterPays() {
        bitField0_ = (bitField0_ & ~0x00000001);
        requesterPays_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storage.v2.Bucket.Billing)
    }

    // @@protoc_insertion_point(class_scope:google.storage.v2.Bucket.Billing)
    private static final com.google.storage.v2.Bucket.Billing DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.storage.v2.Bucket.Billing();
    }

    public static com.google.storage.v2.Bucket.Billing getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Billing> PARSER =
        new com.google.protobuf.AbstractParser<Billing>() {
          @java.lang.Override
          public Billing parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Billing> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Billing> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storage.v2.Bucket.Billing getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface CorsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storage.v2.Bucket.Cors)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The list of Origins eligible to receive CORS response headers. See
     * [https://tools.ietf.org/html/rfc6454][RFC 6454] for more on origins.
     * Note: "*" is permitted in the list of origins, and means "any Origin".
     * </pre>
     *
     * <code>repeated string origin = 1;</code>
     *
     * @return A list containing the origin.
     */
    java.util.List<java.lang.String> getOriginList();
    /**
     *
     *
     * <pre>
     * The list of Origins eligible to receive CORS response headers. See
     * [https://tools.ietf.org/html/rfc6454][RFC 6454] for more on origins.
     * Note: "*" is permitted in the list of origins, and means "any Origin".
     * </pre>
     *
     * <code>repeated string origin = 1;</code>
     *
     * @return The count of origin.
     */
    int getOriginCount();
    /**
     *
     *
     * <pre>
     * The list of Origins eligible to receive CORS response headers. See
     * [https://tools.ietf.org/html/rfc6454][RFC 6454] for more on origins.
     * Note: "*" is permitted in the list of origins, and means "any Origin".
     * </pre>
     *
     * <code>repeated string origin = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The origin at the given index.
     */
    java.lang.String getOrigin(int index);
    /**
     *
     *
     * <pre>
     * The list of Origins eligible to receive CORS response headers. See
     * [https://tools.ietf.org/html/rfc6454][RFC 6454] for more on origins.
     * Note: "*" is permitted in the list of origins, and means "any Origin".
     * </pre>
     *
     * <code>repeated string origin = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the origin at the given index.
     */
    com.google.protobuf.ByteString getOriginBytes(int index);

    /**
     *
     *
     * <pre>
     * The list of HTTP methods on which to include CORS response headers,
     * (`GET`, `OPTIONS`, `POST`, etc) Note: "*" is permitted in the list of
     * methods, and means "any method".
     * </pre>
     *
     * <code>repeated string method = 2;</code>
     *
     * @return A list containing the method.
     */
    java.util.List<java.lang.String> getMethodList();
    /**
     *
     *
     * <pre>
     * The list of HTTP methods on which to include CORS response headers,
     * (`GET`, `OPTIONS`, `POST`, etc) Note: "*" is permitted in the list of
     * methods, and means "any method".
     * </pre>
     *
     * <code>repeated string method = 2;</code>
     *
     * @return The count of method.
     */
    int getMethodCount();
    /**
     *
     *
     * <pre>
     * The list of HTTP methods on which to include CORS response headers,
     * (`GET`, `OPTIONS`, `POST`, etc) Note: "*" is permitted in the list of
     * methods, and means "any method".
     * </pre>
     *
     * <code>repeated string method = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The method at the given index.
     */
    java.lang.String getMethod(int index);
    /**
     *
     *
     * <pre>
     * The list of HTTP methods on which to include CORS response headers,
     * (`GET`, `OPTIONS`, `POST`, etc) Note: "*" is permitted in the list of
     * methods, and means "any method".
     * </pre>
     *
     * <code>repeated string method = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the method at the given index.
     */
    com.google.protobuf.ByteString getMethodBytes(int index);

    /**
     *
     *
     * <pre>
     * The list of HTTP headers other than the
     * [https://www.w3.org/TR/cors/#simple-response-header][simple response
     * headers] to give permission for the user-agent to share across domains.
     * </pre>
     *
     * <code>repeated string response_header = 3;</code>
     *
     * @return A list containing the responseHeader.
     */
    java.util.List<java.lang.String> getResponseHeaderList();
    /**
     *
     *
     * <pre>
     * The list of HTTP headers other than the
     * [https://www.w3.org/TR/cors/#simple-response-header][simple response
     * headers] to give permission for the user-agent to share across domains.
     * </pre>
     *
     * <code>repeated string response_header = 3;</code>
     *
     * @return The count of responseHeader.
     */
    int getResponseHeaderCount();
    /**
     *
     *
     * <pre>
     * The list of HTTP headers other than the
     * [https://www.w3.org/TR/cors/#simple-response-header][simple response
     * headers] to give permission for the user-agent to share across domains.
     * </pre>
     *
     * <code>repeated string response_header = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The responseHeader at the given index.
     */
    java.lang.String getResponseHeader(int index);
    /**
     *
     *
     * <pre>
     * The list of HTTP headers other than the
     * [https://www.w3.org/TR/cors/#simple-response-header][simple response
     * headers] to give permission for the user-agent to share across domains.
     * </pre>
     *
     * <code>repeated string response_header = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the responseHeader at the given index.
     */
    com.google.protobuf.ByteString getResponseHeaderBytes(int index);

    /**
     *
     *
     * <pre>
     * The value, in seconds, to return in the
     * [https://www.w3.org/TR/cors/#access-control-max-age-response-header][Access-Control-Max-Age
     * header] used in preflight responses.
     * </pre>
     *
     * <code>int32 max_age_seconds = 4;</code>
     *
     * @return The maxAgeSeconds.
     */
    int getMaxAgeSeconds();
  }
  /**
   *
   *
   * <pre>
   * Cross-Origin Response sharing (CORS) properties for a bucket.
   * For more on Cloud Storage and CORS, see
   * https://cloud.google.com/storage/docs/cross-origin.
   * For more on CORS in general, see https://tools.ietf.org/html/rfc6454.
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.Bucket.Cors}
   */
  public static final class Cors extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storage.v2.Bucket.Cors)
      CorsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Cors.newBuilder() to construct.
    private Cors(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Cors() {
      origin_ = com.google.protobuf.LazyStringArrayList.emptyList();
      method_ = com.google.protobuf.LazyStringArrayList.emptyList();
      responseHeader_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Cors();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_Cors_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_Cors_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.Bucket.Cors.class,
              com.google.storage.v2.Bucket.Cors.Builder.class);
    }

    public static final int ORIGIN_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList origin_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * The list of Origins eligible to receive CORS response headers. See
     * [https://tools.ietf.org/html/rfc6454][RFC 6454] for more on origins.
     * Note: "*" is permitted in the list of origins, and means "any Origin".
     * </pre>
     *
     * <code>repeated string origin = 1;</code>
     *
     * @return A list containing the origin.
     */
    public com.google.protobuf.ProtocolStringList getOriginList() {
      return origin_;
    }
    /**
     *
     *
     * <pre>
     * The list of Origins eligible to receive CORS response headers. See
     * [https://tools.ietf.org/html/rfc6454][RFC 6454] for more on origins.
     * Note: "*" is permitted in the list of origins, and means "any Origin".
     * </pre>
     *
     * <code>repeated string origin = 1;</code>
     *
     * @return The count of origin.
     */
    public int getOriginCount() {
      return origin_.size();
    }
    /**
     *
     *
     * <pre>
     * The list of Origins eligible to receive CORS response headers. See
     * [https://tools.ietf.org/html/rfc6454][RFC 6454] for more on origins.
     * Note: "*" is permitted in the list of origins, and means "any Origin".
     * </pre>
     *
     * <code>repeated string origin = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The origin at the given index.
     */
    public java.lang.String getOrigin(int index) {
      return origin_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The list of Origins eligible to receive CORS response headers. See
     * [https://tools.ietf.org/html/rfc6454][RFC 6454] for more on origins.
     * Note: "*" is permitted in the list of origins, and means "any Origin".
     * </pre>
     *
     * <code>repeated string origin = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the origin at the given index.
     */
    public com.google.protobuf.ByteString getOriginBytes(int index) {
      return origin_.getByteString(index);
    }

    public static final int METHOD_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList method_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * The list of HTTP methods on which to include CORS response headers,
     * (`GET`, `OPTIONS`, `POST`, etc) Note: "*" is permitted in the list of
     * methods, and means "any method".
     * </pre>
     *
     * <code>repeated string method = 2;</code>
     *
     * @return A list containing the method.
     */
    public com.google.protobuf.ProtocolStringList getMethodList() {
      return method_;
    }
    /**
     *
     *
     * <pre>
     * The list of HTTP methods on which to include CORS response headers,
     * (`GET`, `OPTIONS`, `POST`, etc) Note: "*" is permitted in the list of
     * methods, and means "any method".
     * </pre>
     *
     * <code>repeated string method = 2;</code>
     *
     * @return The count of method.
     */
    public int getMethodCount() {
      return method_.size();
    }
    /**
     *
     *
     * <pre>
     * The list of HTTP methods on which to include CORS response headers,
     * (`GET`, `OPTIONS`, `POST`, etc) Note: "*" is permitted in the list of
     * methods, and means "any method".
     * </pre>
     *
     * <code>repeated string method = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The method at the given index.
     */
    public java.lang.String getMethod(int index) {
      return method_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The list of HTTP methods on which to include CORS response headers,
     * (`GET`, `OPTIONS`, `POST`, etc) Note: "*" is permitted in the list of
     * methods, and means "any method".
     * </pre>
     *
     * <code>repeated string method = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the method at the given index.
     */
    public com.google.protobuf.ByteString getMethodBytes(int index) {
      return method_.getByteString(index);
    }

    public static final int RESPONSE_HEADER_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList responseHeader_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * The list of HTTP headers other than the
     * [https://www.w3.org/TR/cors/#simple-response-header][simple response
     * headers] to give permission for the user-agent to share across domains.
     * </pre>
     *
     * <code>repeated string response_header = 3;</code>
     *
     * @return A list containing the responseHeader.
     */
    public com.google.protobuf.ProtocolStringList getResponseHeaderList() {
      return responseHeader_;
    }
    /**
     *
     *
     * <pre>
     * The list of HTTP headers other than the
     * [https://www.w3.org/TR/cors/#simple-response-header][simple response
     * headers] to give permission for the user-agent to share across domains.
     * </pre>
     *
     * <code>repeated string response_header = 3;</code>
     *
     * @return The count of responseHeader.
     */
    public int getResponseHeaderCount() {
      return responseHeader_.size();
    }
    /**
     *
     *
     * <pre>
     * The list of HTTP headers other than the
     * [https://www.w3.org/TR/cors/#simple-response-header][simple response
     * headers] to give permission for the user-agent to share across domains.
     * </pre>
     *
     * <code>repeated string response_header = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The responseHeader at the given index.
     */
    public java.lang.String getResponseHeader(int index) {
      return responseHeader_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The list of HTTP headers other than the
     * [https://www.w3.org/TR/cors/#simple-response-header][simple response
     * headers] to give permission for the user-agent to share across domains.
     * </pre>
     *
     * <code>repeated string response_header = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the responseHeader at the given index.
     */
    public com.google.protobuf.ByteString getResponseHeaderBytes(int index) {
      return responseHeader_.getByteString(index);
    }

    public static final int MAX_AGE_SECONDS_FIELD_NUMBER = 4;
    private int maxAgeSeconds_ = 0;
    /**
     *
     *
     * <pre>
     * The value, in seconds, to return in the
     * [https://www.w3.org/TR/cors/#access-control-max-age-response-header][Access-Control-Max-Age
     * header] used in preflight responses.
     * </pre>
     *
     * <code>int32 max_age_seconds = 4;</code>
     *
     * @return The maxAgeSeconds.
     */
    @java.lang.Override
    public int getMaxAgeSeconds() {
      return maxAgeSeconds_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < origin_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, origin_.getRaw(i));
      }
      for (int i = 0; i < method_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, method_.getRaw(i));
      }
      for (int i = 0; i < responseHeader_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, responseHeader_.getRaw(i));
      }
      if (maxAgeSeconds_ != 0) {
        output.writeInt32(4, maxAgeSeconds_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < origin_.size(); i++) {
          dataSize += computeStringSizeNoTag(origin_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getOriginList().size();
      }
      {
        int dataSize = 0;
        for (int i = 0; i < method_.size(); i++) {
          dataSize += computeStringSizeNoTag(method_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getMethodList().size();
      }
      {
        int dataSize = 0;
        for (int i = 0; i < responseHeader_.size(); i++) {
          dataSize += computeStringSizeNoTag(responseHeader_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getResponseHeaderList().size();
      }
      if (maxAgeSeconds_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, maxAgeSeconds_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.storage.v2.Bucket.Cors)) {
        return super.equals(obj);
      }
      com.google.storage.v2.Bucket.Cors other = (com.google.storage.v2.Bucket.Cors) obj;

      if (!getOriginList().equals(other.getOriginList())) return false;
      if (!getMethodList().equals(other.getMethodList())) return false;
      if (!getResponseHeaderList().equals(other.getResponseHeaderList())) return false;
      if (getMaxAgeSeconds() != other.getMaxAgeSeconds()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getOriginCount() > 0) {
        hash = (37 * hash) + ORIGIN_FIELD_NUMBER;
        hash = (53 * hash) + getOriginList().hashCode();
      }
      if (getMethodCount() > 0) {
        hash = (37 * hash) + METHOD_FIELD_NUMBER;
        hash = (53 * hash) + getMethodList().hashCode();
      }
      if (getResponseHeaderCount() > 0) {
        hash = (37 * hash) + RESPONSE_HEADER_FIELD_NUMBER;
        hash = (53 * hash) + getResponseHeaderList().hashCode();
      }
      hash = (37 * hash) + MAX_AGE_SECONDS_FIELD_NUMBER;
      hash = (53 * hash) + getMaxAgeSeconds();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storage.v2.Bucket.Cors parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Cors parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Cors parseFrom(com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Cors parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Cors parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Cors parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Cors parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Cors parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Cors parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Cors parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Cors parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Cors parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.storage.v2.Bucket.Cors prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Cross-Origin Response sharing (CORS) properties for a bucket.
     * For more on Cloud Storage and CORS, see
     * https://cloud.google.com/storage/docs/cross-origin.
     * For more on CORS in general, see https://tools.ietf.org/html/rfc6454.
     * </pre>
     *
     * Protobuf type {@code google.storage.v2.Bucket.Cors}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storage.v2.Bucket.Cors)
        com.google.storage.v2.Bucket.CorsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Cors_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Cors_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storage.v2.Bucket.Cors.class,
                com.google.storage.v2.Bucket.Cors.Builder.class);
      }

      // Construct using com.google.storage.v2.Bucket.Cors.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        origin_ = com.google.protobuf.LazyStringArrayList.emptyList();
        method_ = com.google.protobuf.LazyStringArrayList.emptyList();
        responseHeader_ = com.google.protobuf.LazyStringArrayList.emptyList();
        maxAgeSeconds_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Cors_descriptor;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Cors getDefaultInstanceForType() {
        return com.google.storage.v2.Bucket.Cors.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Cors build() {
        com.google.storage.v2.Bucket.Cors result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Cors buildPartial() {
        com.google.storage.v2.Bucket.Cors result = new com.google.storage.v2.Bucket.Cors(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.storage.v2.Bucket.Cors result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          origin_.makeImmutable();
          result.origin_ = origin_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          method_.makeImmutable();
          result.method_ = method_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          responseHeader_.makeImmutable();
          result.responseHeader_ = responseHeader_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.maxAgeSeconds_ = maxAgeSeconds_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.storage.v2.Bucket.Cors) {
          return mergeFrom((com.google.storage.v2.Bucket.Cors) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.storage.v2.Bucket.Cors other) {
        if (other == com.google.storage.v2.Bucket.Cors.getDefaultInstance()) return this;
        if (!other.origin_.isEmpty()) {
          if (origin_.isEmpty()) {
            origin_ = other.origin_;
            bitField0_ |= 0x00000001;
          } else {
            ensureOriginIsMutable();
            origin_.addAll(other.origin_);
          }
          onChanged();
        }
        if (!other.method_.isEmpty()) {
          if (method_.isEmpty()) {
            method_ = other.method_;
            bitField0_ |= 0x00000002;
          } else {
            ensureMethodIsMutable();
            method_.addAll(other.method_);
          }
          onChanged();
        }
        if (!other.responseHeader_.isEmpty()) {
          if (responseHeader_.isEmpty()) {
            responseHeader_ = other.responseHeader_;
            bitField0_ |= 0x00000004;
          } else {
            ensureResponseHeaderIsMutable();
            responseHeader_.addAll(other.responseHeader_);
          }
          onChanged();
        }
        if (other.getMaxAgeSeconds() != 0) {
          setMaxAgeSeconds(other.getMaxAgeSeconds());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureOriginIsMutable();
                  origin_.add(s);
                  break;
                } // case 10
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureMethodIsMutable();
                  method_.add(s);
                  break;
                } // case 18
              case 26:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureResponseHeaderIsMutable();
                  responseHeader_.add(s);
                  break;
                } // case 26
              case 32:
                {
                  maxAgeSeconds_ = input.readInt32();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 32
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.LazyStringArrayList origin_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureOriginIsMutable() {
        if (!origin_.isModifiable()) {
          origin_ = new com.google.protobuf.LazyStringArrayList(origin_);
        }
        bitField0_ |= 0x00000001;
      }
      /**
       *
       *
       * <pre>
       * The list of Origins eligible to receive CORS response headers. See
       * [https://tools.ietf.org/html/rfc6454][RFC 6454] for more on origins.
       * Note: "*" is permitted in the list of origins, and means "any Origin".
       * </pre>
       *
       * <code>repeated string origin = 1;</code>
       *
       * @return A list containing the origin.
       */
      public com.google.protobuf.ProtocolStringList getOriginList() {
        origin_.makeImmutable();
        return origin_;
      }
      /**
       *
       *
       * <pre>
       * The list of Origins eligible to receive CORS response headers. See
       * [https://tools.ietf.org/html/rfc6454][RFC 6454] for more on origins.
       * Note: "*" is permitted in the list of origins, and means "any Origin".
       * </pre>
       *
       * <code>repeated string origin = 1;</code>
       *
       * @return The count of origin.
       */
      public int getOriginCount() {
        return origin_.size();
      }
      /**
       *
       *
       * <pre>
       * The list of Origins eligible to receive CORS response headers. See
       * [https://tools.ietf.org/html/rfc6454][RFC 6454] for more on origins.
       * Note: "*" is permitted in the list of origins, and means "any Origin".
       * </pre>
       *
       * <code>repeated string origin = 1;</code>
       *
       * @param index The index of the element to return.
       * @return The origin at the given index.
       */
      public java.lang.String getOrigin(int index) {
        return origin_.get(index);
      }
      /**
       *
       *
       * <pre>
       * The list of Origins eligible to receive CORS response headers. See
       * [https://tools.ietf.org/html/rfc6454][RFC 6454] for more on origins.
       * Note: "*" is permitted in the list of origins, and means "any Origin".
       * </pre>
       *
       * <code>repeated string origin = 1;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the origin at the given index.
       */
      public com.google.protobuf.ByteString getOriginBytes(int index) {
        return origin_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * The list of Origins eligible to receive CORS response headers. See
       * [https://tools.ietf.org/html/rfc6454][RFC 6454] for more on origins.
       * Note: "*" is permitted in the list of origins, and means "any Origin".
       * </pre>
       *
       * <code>repeated string origin = 1;</code>
       *
       * @param index The index to set the value at.
       * @param value The origin to set.
       * @return This builder for chaining.
       */
      public Builder setOrigin(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOriginIsMutable();
        origin_.set(index, value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of Origins eligible to receive CORS response headers. See
       * [https://tools.ietf.org/html/rfc6454][RFC 6454] for more on origins.
       * Note: "*" is permitted in the list of origins, and means "any Origin".
       * </pre>
       *
       * <code>repeated string origin = 1;</code>
       *
       * @param value The origin to add.
       * @return This builder for chaining.
       */
      public Builder addOrigin(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOriginIsMutable();
        origin_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of Origins eligible to receive CORS response headers. See
       * [https://tools.ietf.org/html/rfc6454][RFC 6454] for more on origins.
       * Note: "*" is permitted in the list of origins, and means "any Origin".
       * </pre>
       *
       * <code>repeated string origin = 1;</code>
       *
       * @param values The origin to add.
       * @return This builder for chaining.
       */
      public Builder addAllOrigin(java.lang.Iterable<java.lang.String> values) {
        ensureOriginIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, origin_);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of Origins eligible to receive CORS response headers. See
       * [https://tools.ietf.org/html/rfc6454][RFC 6454] for more on origins.
       * Note: "*" is permitted in the list of origins, and means "any Origin".
       * </pre>
       *
       * <code>repeated string origin = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearOrigin() {
        origin_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of Origins eligible to receive CORS response headers. See
       * [https://tools.ietf.org/html/rfc6454][RFC 6454] for more on origins.
       * Note: "*" is permitted in the list of origins, and means "any Origin".
       * </pre>
       *
       * <code>repeated string origin = 1;</code>
       *
       * @param value The bytes of the origin to add.
       * @return This builder for chaining.
       */
      public Builder addOriginBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureOriginIsMutable();
        origin_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList method_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureMethodIsMutable() {
        if (!method_.isModifiable()) {
          method_ = new com.google.protobuf.LazyStringArrayList(method_);
        }
        bitField0_ |= 0x00000002;
      }
      /**
       *
       *
       * <pre>
       * The list of HTTP methods on which to include CORS response headers,
       * (`GET`, `OPTIONS`, `POST`, etc) Note: "*" is permitted in the list of
       * methods, and means "any method".
       * </pre>
       *
       * <code>repeated string method = 2;</code>
       *
       * @return A list containing the method.
       */
      public com.google.protobuf.ProtocolStringList getMethodList() {
        method_.makeImmutable();
        return method_;
      }
      /**
       *
       *
       * <pre>
       * The list of HTTP methods on which to include CORS response headers,
       * (`GET`, `OPTIONS`, `POST`, etc) Note: "*" is permitted in the list of
       * methods, and means "any method".
       * </pre>
       *
       * <code>repeated string method = 2;</code>
       *
       * @return The count of method.
       */
      public int getMethodCount() {
        return method_.size();
      }
      /**
       *
       *
       * <pre>
       * The list of HTTP methods on which to include CORS response headers,
       * (`GET`, `OPTIONS`, `POST`, etc) Note: "*" is permitted in the list of
       * methods, and means "any method".
       * </pre>
       *
       * <code>repeated string method = 2;</code>
       *
       * @param index The index of the element to return.
       * @return The method at the given index.
       */
      public java.lang.String getMethod(int index) {
        return method_.get(index);
      }
      /**
       *
       *
       * <pre>
       * The list of HTTP methods on which to include CORS response headers,
       * (`GET`, `OPTIONS`, `POST`, etc) Note: "*" is permitted in the list of
       * methods, and means "any method".
       * </pre>
       *
       * <code>repeated string method = 2;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the method at the given index.
       */
      public com.google.protobuf.ByteString getMethodBytes(int index) {
        return method_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * The list of HTTP methods on which to include CORS response headers,
       * (`GET`, `OPTIONS`, `POST`, etc) Note: "*" is permitted in the list of
       * methods, and means "any method".
       * </pre>
       *
       * <code>repeated string method = 2;</code>
       *
       * @param index The index to set the value at.
       * @param value The method to set.
       * @return This builder for chaining.
       */
      public Builder setMethod(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMethodIsMutable();
        method_.set(index, value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of HTTP methods on which to include CORS response headers,
       * (`GET`, `OPTIONS`, `POST`, etc) Note: "*" is permitted in the list of
       * methods, and means "any method".
       * </pre>
       *
       * <code>repeated string method = 2;</code>
       *
       * @param value The method to add.
       * @return This builder for chaining.
       */
      public Builder addMethod(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMethodIsMutable();
        method_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of HTTP methods on which to include CORS response headers,
       * (`GET`, `OPTIONS`, `POST`, etc) Note: "*" is permitted in the list of
       * methods, and means "any method".
       * </pre>
       *
       * <code>repeated string method = 2;</code>
       *
       * @param values The method to add.
       * @return This builder for chaining.
       */
      public Builder addAllMethod(java.lang.Iterable<java.lang.String> values) {
        ensureMethodIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, method_);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of HTTP methods on which to include CORS response headers,
       * (`GET`, `OPTIONS`, `POST`, etc) Note: "*" is permitted in the list of
       * methods, and means "any method".
       * </pre>
       *
       * <code>repeated string method = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMethod() {
        method_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of HTTP methods on which to include CORS response headers,
       * (`GET`, `OPTIONS`, `POST`, etc) Note: "*" is permitted in the list of
       * methods, and means "any method".
       * </pre>
       *
       * <code>repeated string method = 2;</code>
       *
       * @param value The bytes of the method to add.
       * @return This builder for chaining.
       */
      public Builder addMethodBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureMethodIsMutable();
        method_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList responseHeader_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureResponseHeaderIsMutable() {
        if (!responseHeader_.isModifiable()) {
          responseHeader_ = new com.google.protobuf.LazyStringArrayList(responseHeader_);
        }
        bitField0_ |= 0x00000004;
      }
      /**
       *
       *
       * <pre>
       * The list of HTTP headers other than the
       * [https://www.w3.org/TR/cors/#simple-response-header][simple response
       * headers] to give permission for the user-agent to share across domains.
       * </pre>
       *
       * <code>repeated string response_header = 3;</code>
       *
       * @return A list containing the responseHeader.
       */
      public com.google.protobuf.ProtocolStringList getResponseHeaderList() {
        responseHeader_.makeImmutable();
        return responseHeader_;
      }
      /**
       *
       *
       * <pre>
       * The list of HTTP headers other than the
       * [https://www.w3.org/TR/cors/#simple-response-header][simple response
       * headers] to give permission for the user-agent to share across domains.
       * </pre>
       *
       * <code>repeated string response_header = 3;</code>
       *
       * @return The count of responseHeader.
       */
      public int getResponseHeaderCount() {
        return responseHeader_.size();
      }
      /**
       *
       *
       * <pre>
       * The list of HTTP headers other than the
       * [https://www.w3.org/TR/cors/#simple-response-header][simple response
       * headers] to give permission for the user-agent to share across domains.
       * </pre>
       *
       * <code>repeated string response_header = 3;</code>
       *
       * @param index The index of the element to return.
       * @return The responseHeader at the given index.
       */
      public java.lang.String getResponseHeader(int index) {
        return responseHeader_.get(index);
      }
      /**
       *
       *
       * <pre>
       * The list of HTTP headers other than the
       * [https://www.w3.org/TR/cors/#simple-response-header][simple response
       * headers] to give permission for the user-agent to share across domains.
       * </pre>
       *
       * <code>repeated string response_header = 3;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the responseHeader at the given index.
       */
      public com.google.protobuf.ByteString getResponseHeaderBytes(int index) {
        return responseHeader_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * The list of HTTP headers other than the
       * [https://www.w3.org/TR/cors/#simple-response-header][simple response
       * headers] to give permission for the user-agent to share across domains.
       * </pre>
       *
       * <code>repeated string response_header = 3;</code>
       *
       * @param index The index to set the value at.
       * @param value The responseHeader to set.
       * @return This builder for chaining.
       */
      public Builder setResponseHeader(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResponseHeaderIsMutable();
        responseHeader_.set(index, value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of HTTP headers other than the
       * [https://www.w3.org/TR/cors/#simple-response-header][simple response
       * headers] to give permission for the user-agent to share across domains.
       * </pre>
       *
       * <code>repeated string response_header = 3;</code>
       *
       * @param value The responseHeader to add.
       * @return This builder for chaining.
       */
      public Builder addResponseHeader(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResponseHeaderIsMutable();
        responseHeader_.add(value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of HTTP headers other than the
       * [https://www.w3.org/TR/cors/#simple-response-header][simple response
       * headers] to give permission for the user-agent to share across domains.
       * </pre>
       *
       * <code>repeated string response_header = 3;</code>
       *
       * @param values The responseHeader to add.
       * @return This builder for chaining.
       */
      public Builder addAllResponseHeader(java.lang.Iterable<java.lang.String> values) {
        ensureResponseHeaderIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, responseHeader_);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of HTTP headers other than the
       * [https://www.w3.org/TR/cors/#simple-response-header][simple response
       * headers] to give permission for the user-agent to share across domains.
       * </pre>
       *
       * <code>repeated string response_header = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearResponseHeader() {
        responseHeader_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of HTTP headers other than the
       * [https://www.w3.org/TR/cors/#simple-response-header][simple response
       * headers] to give permission for the user-agent to share across domains.
       * </pre>
       *
       * <code>repeated string response_header = 3;</code>
       *
       * @param value The bytes of the responseHeader to add.
       * @return This builder for chaining.
       */
      public Builder addResponseHeaderBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureResponseHeaderIsMutable();
        responseHeader_.add(value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private int maxAgeSeconds_;
      /**
       *
       *
       * <pre>
       * The value, in seconds, to return in the
       * [https://www.w3.org/TR/cors/#access-control-max-age-response-header][Access-Control-Max-Age
       * header] used in preflight responses.
       * </pre>
       *
       * <code>int32 max_age_seconds = 4;</code>
       *
       * @return The maxAgeSeconds.
       */
      @java.lang.Override
      public int getMaxAgeSeconds() {
        return maxAgeSeconds_;
      }
      /**
       *
       *
       * <pre>
       * The value, in seconds, to return in the
       * [https://www.w3.org/TR/cors/#access-control-max-age-response-header][Access-Control-Max-Age
       * header] used in preflight responses.
       * </pre>
       *
       * <code>int32 max_age_seconds = 4;</code>
       *
       * @param value The maxAgeSeconds to set.
       * @return This builder for chaining.
       */
      public Builder setMaxAgeSeconds(int value) {

        maxAgeSeconds_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The value, in seconds, to return in the
       * [https://www.w3.org/TR/cors/#access-control-max-age-response-header][Access-Control-Max-Age
       * header] used in preflight responses.
       * </pre>
       *
       * <code>int32 max_age_seconds = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMaxAgeSeconds() {
        bitField0_ = (bitField0_ & ~0x00000008);
        maxAgeSeconds_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storage.v2.Bucket.Cors)
    }

    // @@protoc_insertion_point(class_scope:google.storage.v2.Bucket.Cors)
    private static final com.google.storage.v2.Bucket.Cors DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.storage.v2.Bucket.Cors();
    }

    public static com.google.storage.v2.Bucket.Cors getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Cors> PARSER =
        new com.google.protobuf.AbstractParser<Cors>() {
          @java.lang.Override
          public Cors parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Cors> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Cors> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storage.v2.Bucket.Cors getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface EncryptionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storage.v2.Bucket.Encryption)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The name of the Cloud KMS key that will be used to encrypt objects
     * inserted into this bucket, if no encryption method is specified.
     * </pre>
     *
     * <code>string default_kms_key = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The defaultKmsKey.
     */
    java.lang.String getDefaultKmsKey();
    /**
     *
     *
     * <pre>
     * The name of the Cloud KMS key that will be used to encrypt objects
     * inserted into this bucket, if no encryption method is specified.
     * </pre>
     *
     * <code>string default_kms_key = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for defaultKmsKey.
     */
    com.google.protobuf.ByteString getDefaultKmsKeyBytes();
  }
  /**
   *
   *
   * <pre>
   * Encryption properties of a bucket.
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.Bucket.Encryption}
   */
  public static final class Encryption extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storage.v2.Bucket.Encryption)
      EncryptionOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Encryption.newBuilder() to construct.
    private Encryption(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Encryption() {
      defaultKmsKey_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Encryption();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_Encryption_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_Encryption_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.Bucket.Encryption.class,
              com.google.storage.v2.Bucket.Encryption.Builder.class);
    }

    public static final int DEFAULT_KMS_KEY_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object defaultKmsKey_ = "";
    /**
     *
     *
     * <pre>
     * The name of the Cloud KMS key that will be used to encrypt objects
     * inserted into this bucket, if no encryption method is specified.
     * </pre>
     *
     * <code>string default_kms_key = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The defaultKmsKey.
     */
    @java.lang.Override
    public java.lang.String getDefaultKmsKey() {
      java.lang.Object ref = defaultKmsKey_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        defaultKmsKey_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the Cloud KMS key that will be used to encrypt objects
     * inserted into this bucket, if no encryption method is specified.
     * </pre>
     *
     * <code>string default_kms_key = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for defaultKmsKey.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDefaultKmsKeyBytes() {
      java.lang.Object ref = defaultKmsKey_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        defaultKmsKey_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(defaultKmsKey_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, defaultKmsKey_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(defaultKmsKey_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, defaultKmsKey_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.storage.v2.Bucket.Encryption)) {
        return super.equals(obj);
      }
      com.google.storage.v2.Bucket.Encryption other = (com.google.storage.v2.Bucket.Encryption) obj;

      if (!getDefaultKmsKey().equals(other.getDefaultKmsKey())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + DEFAULT_KMS_KEY_FIELD_NUMBER;
      hash = (53 * hash) + getDefaultKmsKey().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storage.v2.Bucket.Encryption parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Encryption parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Encryption parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Encryption parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Encryption parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Encryption parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Encryption parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Encryption parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Encryption parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Encryption parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Encryption parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Encryption parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.storage.v2.Bucket.Encryption prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Encryption properties of a bucket.
     * </pre>
     *
     * Protobuf type {@code google.storage.v2.Bucket.Encryption}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storage.v2.Bucket.Encryption)
        com.google.storage.v2.Bucket.EncryptionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Encryption_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Encryption_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storage.v2.Bucket.Encryption.class,
                com.google.storage.v2.Bucket.Encryption.Builder.class);
      }

      // Construct using com.google.storage.v2.Bucket.Encryption.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        defaultKmsKey_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Encryption_descriptor;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Encryption getDefaultInstanceForType() {
        return com.google.storage.v2.Bucket.Encryption.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Encryption build() {
        com.google.storage.v2.Bucket.Encryption result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Encryption buildPartial() {
        com.google.storage.v2.Bucket.Encryption result =
            new com.google.storage.v2.Bucket.Encryption(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.storage.v2.Bucket.Encryption result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.defaultKmsKey_ = defaultKmsKey_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.storage.v2.Bucket.Encryption) {
          return mergeFrom((com.google.storage.v2.Bucket.Encryption) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.storage.v2.Bucket.Encryption other) {
        if (other == com.google.storage.v2.Bucket.Encryption.getDefaultInstance()) return this;
        if (!other.getDefaultKmsKey().isEmpty()) {
          defaultKmsKey_ = other.defaultKmsKey_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  defaultKmsKey_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object defaultKmsKey_ = "";
      /**
       *
       *
       * <pre>
       * The name of the Cloud KMS key that will be used to encrypt objects
       * inserted into this bucket, if no encryption method is specified.
       * </pre>
       *
       * <code>string default_kms_key = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The defaultKmsKey.
       */
      public java.lang.String getDefaultKmsKey() {
        java.lang.Object ref = defaultKmsKey_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          defaultKmsKey_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the Cloud KMS key that will be used to encrypt objects
       * inserted into this bucket, if no encryption method is specified.
       * </pre>
       *
       * <code>string default_kms_key = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The bytes for defaultKmsKey.
       */
      public com.google.protobuf.ByteString getDefaultKmsKeyBytes() {
        java.lang.Object ref = defaultKmsKey_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          defaultKmsKey_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the Cloud KMS key that will be used to encrypt objects
       * inserted into this bucket, if no encryption method is specified.
       * </pre>
       *
       * <code>string default_kms_key = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The defaultKmsKey to set.
       * @return This builder for chaining.
       */
      public Builder setDefaultKmsKey(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        defaultKmsKey_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the Cloud KMS key that will be used to encrypt objects
       * inserted into this bucket, if no encryption method is specified.
       * </pre>
       *
       * <code>string default_kms_key = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDefaultKmsKey() {
        defaultKmsKey_ = getDefaultInstance().getDefaultKmsKey();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the Cloud KMS key that will be used to encrypt objects
       * inserted into this bucket, if no encryption method is specified.
       * </pre>
       *
       * <code>string default_kms_key = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The bytes for defaultKmsKey to set.
       * @return This builder for chaining.
       */
      public Builder setDefaultKmsKeyBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        defaultKmsKey_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storage.v2.Bucket.Encryption)
    }

    // @@protoc_insertion_point(class_scope:google.storage.v2.Bucket.Encryption)
    private static final com.google.storage.v2.Bucket.Encryption DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.storage.v2.Bucket.Encryption();
    }

    public static com.google.storage.v2.Bucket.Encryption getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Encryption> PARSER =
        new com.google.protobuf.AbstractParser<Encryption>() {
          @java.lang.Override
          public Encryption parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Encryption> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Encryption> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storage.v2.Bucket.Encryption getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface IamConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storage.v2.Bucket.IamConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Bucket restriction options currently enforced on the bucket.
     * </pre>
     *
     * <code>
     * .google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess uniform_bucket_level_access = 1;
     * </code>
     *
     * @return Whether the uniformBucketLevelAccess field is set.
     */
    boolean hasUniformBucketLevelAccess();
    /**
     *
     *
     * <pre>
     * Bucket restriction options currently enforced on the bucket.
     * </pre>
     *
     * <code>
     * .google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess uniform_bucket_level_access = 1;
     * </code>
     *
     * @return The uniformBucketLevelAccess.
     */
    com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess getUniformBucketLevelAccess();
    /**
     *
     *
     * <pre>
     * Bucket restriction options currently enforced on the bucket.
     * </pre>
     *
     * <code>
     * .google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess uniform_bucket_level_access = 1;
     * </code>
     */
    com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccessOrBuilder
        getUniformBucketLevelAccessOrBuilder();

    /**
     *
     *
     * <pre>
     * Whether IAM will enforce public access prevention. Valid values are
     * "enforced" or "inherited".
     * </pre>
     *
     * <code>string public_access_prevention = 3;</code>
     *
     * @return The publicAccessPrevention.
     */
    java.lang.String getPublicAccessPrevention();
    /**
     *
     *
     * <pre>
     * Whether IAM will enforce public access prevention. Valid values are
     * "enforced" or "inherited".
     * </pre>
     *
     * <code>string public_access_prevention = 3;</code>
     *
     * @return The bytes for publicAccessPrevention.
     */
    com.google.protobuf.ByteString getPublicAccessPreventionBytes();
  }
  /**
   *
   *
   * <pre>
   * Bucket restriction options.
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.Bucket.IamConfig}
   */
  public static final class IamConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storage.v2.Bucket.IamConfig)
      IamConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use IamConfig.newBuilder() to construct.
    private IamConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private IamConfig() {
      publicAccessPrevention_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new IamConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_IamConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_IamConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.Bucket.IamConfig.class,
              com.google.storage.v2.Bucket.IamConfig.Builder.class);
    }

    public interface UniformBucketLevelAccessOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * If set, access checks only use bucket-level IAM policies or above.
       * </pre>
       *
       * <code>bool enabled = 1;</code>
       *
       * @return The enabled.
       */
      boolean getEnabled();

      /**
       *
       *
       * <pre>
       * The deadline time for changing
       * `iam_config.uniform_bucket_level_access.enabled` from `true` to
       * `false`. Mutable until the specified deadline is reached, but not
       * afterward.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp lock_time = 2;</code>
       *
       * @return Whether the lockTime field is set.
       */
      boolean hasLockTime();
      /**
       *
       *
       * <pre>
       * The deadline time for changing
       * `iam_config.uniform_bucket_level_access.enabled` from `true` to
       * `false`. Mutable until the specified deadline is reached, but not
       * afterward.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp lock_time = 2;</code>
       *
       * @return The lockTime.
       */
      com.google.protobuf.Timestamp getLockTime();
      /**
       *
       *
       * <pre>
       * The deadline time for changing
       * `iam_config.uniform_bucket_level_access.enabled` from `true` to
       * `false`. Mutable until the specified deadline is reached, but not
       * afterward.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp lock_time = 2;</code>
       */
      com.google.protobuf.TimestampOrBuilder getLockTimeOrBuilder();
    }
    /**
     *
     *
     * <pre>
     * Settings for Uniform Bucket level access.
     * See https://cloud.google.com/storage/docs/uniform-bucket-level-access.
     * </pre>
     *
     * Protobuf type {@code google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess}
     */
    public static final class UniformBucketLevelAccess
        extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess)
        UniformBucketLevelAccessOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use UniformBucketLevelAccess.newBuilder() to construct.
      private UniformBucketLevelAccess(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private UniformBucketLevelAccess() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new UniformBucketLevelAccess();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_IamConfig_UniformBucketLevelAccess_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_IamConfig_UniformBucketLevelAccess_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess.class,
                com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess.Builder.class);
      }

      private int bitField0_;
      public static final int ENABLED_FIELD_NUMBER = 1;
      private boolean enabled_ = false;
      /**
       *
       *
       * <pre>
       * If set, access checks only use bucket-level IAM policies or above.
       * </pre>
       *
       * <code>bool enabled = 1;</code>
       *
       * @return The enabled.
       */
      @java.lang.Override
      public boolean getEnabled() {
        return enabled_;
      }

      public static final int LOCK_TIME_FIELD_NUMBER = 2;
      private com.google.protobuf.Timestamp lockTime_;
      /**
       *
       *
       * <pre>
       * The deadline time for changing
       * `iam_config.uniform_bucket_level_access.enabled` from `true` to
       * `false`. Mutable until the specified deadline is reached, but not
       * afterward.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp lock_time = 2;</code>
       *
       * @return Whether the lockTime field is set.
       */
      @java.lang.Override
      public boolean hasLockTime() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * The deadline time for changing
       * `iam_config.uniform_bucket_level_access.enabled` from `true` to
       * `false`. Mutable until the specified deadline is reached, but not
       * afterward.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp lock_time = 2;</code>
       *
       * @return The lockTime.
       */
      @java.lang.Override
      public com.google.protobuf.Timestamp getLockTime() {
        return lockTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : lockTime_;
      }
      /**
       *
       *
       * <pre>
       * The deadline time for changing
       * `iam_config.uniform_bucket_level_access.enabled` from `true` to
       * `false`. Mutable until the specified deadline is reached, but not
       * afterward.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp lock_time = 2;</code>
       */
      @java.lang.Override
      public com.google.protobuf.TimestampOrBuilder getLockTimeOrBuilder() {
        return lockTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : lockTime_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (enabled_ != false) {
          output.writeBool(1, enabled_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(2, getLockTime());
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (enabled_ != false) {
          size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, enabled_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getLockTime());
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess)) {
          return super.equals(obj);
        }
        com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess other =
            (com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess) obj;

        if (getEnabled() != other.getEnabled()) return false;
        if (hasLockTime() != other.hasLockTime()) return false;
        if (hasLockTime()) {
          if (!getLockTime().equals(other.getLockTime())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + ENABLED_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnabled());
        if (hasLockTime()) {
          hash = (37 * hash) + LOCK_TIME_FIELD_NUMBER;
          hash = (53 * hash) + getLockTime().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Settings for Uniform Bucket level access.
       * See https://cloud.google.com/storage/docs/uniform-bucket-level-access.
       * </pre>
       *
       * Protobuf type {@code google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess)
          com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccessOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.storage.v2.StorageProto
              .internal_static_google_storage_v2_Bucket_IamConfig_UniformBucketLevelAccess_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.storage.v2.StorageProto
              .internal_static_google_storage_v2_Bucket_IamConfig_UniformBucketLevelAccess_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess.class,
                  com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess.Builder.class);
        }

        // Construct using
        // com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getLockTimeFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          enabled_ = false;
          lockTime_ = null;
          if (lockTimeBuilder_ != null) {
            lockTimeBuilder_.dispose();
            lockTimeBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.storage.v2.StorageProto
              .internal_static_google_storage_v2_Bucket_IamConfig_UniformBucketLevelAccess_descriptor;
        }

        @java.lang.Override
        public com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess
            getDefaultInstanceForType() {
          return com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess build() {
          com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess buildPartial() {
          com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess result =
              new com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.enabled_ = enabled_;
          }
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.lockTime_ = lockTimeBuilder_ == null ? lockTime_ : lockTimeBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess) {
            return mergeFrom(
                (com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess other) {
          if (other
              == com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess
                  .getDefaultInstance()) return this;
          if (other.getEnabled() != false) {
            setEnabled(other.getEnabled());
          }
          if (other.hasLockTime()) {
            mergeLockTime(other.getLockTime());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8:
                  {
                    enabled_ = input.readBool();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 8
                case 18:
                  {
                    input.readMessage(getLockTimeFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private boolean enabled_;
        /**
         *
         *
         * <pre>
         * If set, access checks only use bucket-level IAM policies or above.
         * </pre>
         *
         * <code>bool enabled = 1;</code>
         *
         * @return The enabled.
         */
        @java.lang.Override
        public boolean getEnabled() {
          return enabled_;
        }
        /**
         *
         *
         * <pre>
         * If set, access checks only use bucket-level IAM policies or above.
         * </pre>
         *
         * <code>bool enabled = 1;</code>
         *
         * @param value The enabled to set.
         * @return This builder for chaining.
         */
        public Builder setEnabled(boolean value) {

          enabled_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * If set, access checks only use bucket-level IAM policies or above.
         * </pre>
         *
         * <code>bool enabled = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearEnabled() {
          bitField0_ = (bitField0_ & ~0x00000001);
          enabled_ = false;
          onChanged();
          return this;
        }

        private com.google.protobuf.Timestamp lockTime_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>
            lockTimeBuilder_;
        /**
         *
         *
         * <pre>
         * The deadline time for changing
         * `iam_config.uniform_bucket_level_access.enabled` from `true` to
         * `false`. Mutable until the specified deadline is reached, but not
         * afterward.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp lock_time = 2;</code>
         *
         * @return Whether the lockTime field is set.
         */
        public boolean hasLockTime() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         *
         *
         * <pre>
         * The deadline time for changing
         * `iam_config.uniform_bucket_level_access.enabled` from `true` to
         * `false`. Mutable until the specified deadline is reached, but not
         * afterward.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp lock_time = 2;</code>
         *
         * @return The lockTime.
         */
        public com.google.protobuf.Timestamp getLockTime() {
          if (lockTimeBuilder_ == null) {
            return lockTime_ == null
                ? com.google.protobuf.Timestamp.getDefaultInstance()
                : lockTime_;
          } else {
            return lockTimeBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * The deadline time for changing
         * `iam_config.uniform_bucket_level_access.enabled` from `true` to
         * `false`. Mutable until the specified deadline is reached, but not
         * afterward.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp lock_time = 2;</code>
         */
        public Builder setLockTime(com.google.protobuf.Timestamp value) {
          if (lockTimeBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            lockTime_ = value;
          } else {
            lockTimeBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The deadline time for changing
         * `iam_config.uniform_bucket_level_access.enabled` from `true` to
         * `false`. Mutable until the specified deadline is reached, but not
         * afterward.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp lock_time = 2;</code>
         */
        public Builder setLockTime(com.google.protobuf.Timestamp.Builder builderForValue) {
          if (lockTimeBuilder_ == null) {
            lockTime_ = builderForValue.build();
          } else {
            lockTimeBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The deadline time for changing
         * `iam_config.uniform_bucket_level_access.enabled` from `true` to
         * `false`. Mutable until the specified deadline is reached, but not
         * afterward.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp lock_time = 2;</code>
         */
        public Builder mergeLockTime(com.google.protobuf.Timestamp value) {
          if (lockTimeBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0)
                && lockTime_ != null
                && lockTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
              getLockTimeBuilder().mergeFrom(value);
            } else {
              lockTime_ = value;
            }
          } else {
            lockTimeBuilder_.mergeFrom(value);
          }
          if (lockTime_ != null) {
            bitField0_ |= 0x00000002;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The deadline time for changing
         * `iam_config.uniform_bucket_level_access.enabled` from `true` to
         * `false`. Mutable until the specified deadline is reached, but not
         * afterward.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp lock_time = 2;</code>
         */
        public Builder clearLockTime() {
          bitField0_ = (bitField0_ & ~0x00000002);
          lockTime_ = null;
          if (lockTimeBuilder_ != null) {
            lockTimeBuilder_.dispose();
            lockTimeBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The deadline time for changing
         * `iam_config.uniform_bucket_level_access.enabled` from `true` to
         * `false`. Mutable until the specified deadline is reached, but not
         * afterward.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp lock_time = 2;</code>
         */
        public com.google.protobuf.Timestamp.Builder getLockTimeBuilder() {
          bitField0_ |= 0x00000002;
          onChanged();
          return getLockTimeFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * The deadline time for changing
         * `iam_config.uniform_bucket_level_access.enabled` from `true` to
         * `false`. Mutable until the specified deadline is reached, but not
         * afterward.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp lock_time = 2;</code>
         */
        public com.google.protobuf.TimestampOrBuilder getLockTimeOrBuilder() {
          if (lockTimeBuilder_ != null) {
            return lockTimeBuilder_.getMessageOrBuilder();
          } else {
            return lockTime_ == null
                ? com.google.protobuf.Timestamp.getDefaultInstance()
                : lockTime_;
          }
        }
        /**
         *
         *
         * <pre>
         * The deadline time for changing
         * `iam_config.uniform_bucket_level_access.enabled` from `true` to
         * `false`. Mutable until the specified deadline is reached, but not
         * afterward.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp lock_time = 2;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>
            getLockTimeFieldBuilder() {
          if (lockTimeBuilder_ == null) {
            lockTimeBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.protobuf.Timestamp,
                    com.google.protobuf.Timestamp.Builder,
                    com.google.protobuf.TimestampOrBuilder>(
                    getLockTime(), getParentForChildren(), isClean());
            lockTime_ = null;
          }
          return lockTimeBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess)
      }

      // @@protoc_insertion_point(class_scope:google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess)
      private static final com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess();
      }

      public static com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<UniformBucketLevelAccess> PARSER =
          new com.google.protobuf.AbstractParser<UniformBucketLevelAccess>() {
            @java.lang.Override
            public UniformBucketLevelAccess parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<UniformBucketLevelAccess> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<UniformBucketLevelAccess> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int UNIFORM_BUCKET_LEVEL_ACCESS_FIELD_NUMBER = 1;
    private com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess
        uniformBucketLevelAccess_;
    /**
     *
     *
     * <pre>
     * Bucket restriction options currently enforced on the bucket.
     * </pre>
     *
     * <code>
     * .google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess uniform_bucket_level_access = 1;
     * </code>
     *
     * @return Whether the uniformBucketLevelAccess field is set.
     */
    @java.lang.Override
    public boolean hasUniformBucketLevelAccess() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Bucket restriction options currently enforced on the bucket.
     * </pre>
     *
     * <code>
     * .google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess uniform_bucket_level_access = 1;
     * </code>
     *
     * @return The uniformBucketLevelAccess.
     */
    @java.lang.Override
    public com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess
        getUniformBucketLevelAccess() {
      return uniformBucketLevelAccess_ == null
          ? com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess.getDefaultInstance()
          : uniformBucketLevelAccess_;
    }
    /**
     *
     *
     * <pre>
     * Bucket restriction options currently enforced on the bucket.
     * </pre>
     *
     * <code>
     * .google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess uniform_bucket_level_access = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccessOrBuilder
        getUniformBucketLevelAccessOrBuilder() {
      return uniformBucketLevelAccess_ == null
          ? com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess.getDefaultInstance()
          : uniformBucketLevelAccess_;
    }

    public static final int PUBLIC_ACCESS_PREVENTION_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object publicAccessPrevention_ = "";
    /**
     *
     *
     * <pre>
     * Whether IAM will enforce public access prevention. Valid values are
     * "enforced" or "inherited".
     * </pre>
     *
     * <code>string public_access_prevention = 3;</code>
     *
     * @return The publicAccessPrevention.
     */
    @java.lang.Override
    public java.lang.String getPublicAccessPrevention() {
      java.lang.Object ref = publicAccessPrevention_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        publicAccessPrevention_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Whether IAM will enforce public access prevention. Valid values are
     * "enforced" or "inherited".
     * </pre>
     *
     * <code>string public_access_prevention = 3;</code>
     *
     * @return The bytes for publicAccessPrevention.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPublicAccessPreventionBytes() {
      java.lang.Object ref = publicAccessPrevention_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        publicAccessPrevention_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getUniformBucketLevelAccess());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(publicAccessPrevention_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, publicAccessPrevention_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1, getUniformBucketLevelAccess());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(publicAccessPrevention_)) {
        size +=
            com.google.protobuf.GeneratedMessageV3.computeStringSize(3, publicAccessPrevention_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.storage.v2.Bucket.IamConfig)) {
        return super.equals(obj);
      }
      com.google.storage.v2.Bucket.IamConfig other = (com.google.storage.v2.Bucket.IamConfig) obj;

      if (hasUniformBucketLevelAccess() != other.hasUniformBucketLevelAccess()) return false;
      if (hasUniformBucketLevelAccess()) {
        if (!getUniformBucketLevelAccess().equals(other.getUniformBucketLevelAccess()))
          return false;
      }
      if (!getPublicAccessPrevention().equals(other.getPublicAccessPrevention())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasUniformBucketLevelAccess()) {
        hash = (37 * hash) + UNIFORM_BUCKET_LEVEL_ACCESS_FIELD_NUMBER;
        hash = (53 * hash) + getUniformBucketLevelAccess().hashCode();
      }
      hash = (37 * hash) + PUBLIC_ACCESS_PREVENTION_FIELD_NUMBER;
      hash = (53 * hash) + getPublicAccessPrevention().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storage.v2.Bucket.IamConfig parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.IamConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.IamConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.IamConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.IamConfig parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.IamConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.IamConfig parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.IamConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.IamConfig parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.IamConfig parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.IamConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.IamConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.storage.v2.Bucket.IamConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Bucket restriction options.
     * </pre>
     *
     * Protobuf type {@code google.storage.v2.Bucket.IamConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storage.v2.Bucket.IamConfig)
        com.google.storage.v2.Bucket.IamConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_IamConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_IamConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storage.v2.Bucket.IamConfig.class,
                com.google.storage.v2.Bucket.IamConfig.Builder.class);
      }

      // Construct using com.google.storage.v2.Bucket.IamConfig.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getUniformBucketLevelAccessFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        uniformBucketLevelAccess_ = null;
        if (uniformBucketLevelAccessBuilder_ != null) {
          uniformBucketLevelAccessBuilder_.dispose();
          uniformBucketLevelAccessBuilder_ = null;
        }
        publicAccessPrevention_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_IamConfig_descriptor;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.IamConfig getDefaultInstanceForType() {
        return com.google.storage.v2.Bucket.IamConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.IamConfig build() {
        com.google.storage.v2.Bucket.IamConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.IamConfig buildPartial() {
        com.google.storage.v2.Bucket.IamConfig result =
            new com.google.storage.v2.Bucket.IamConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.storage.v2.Bucket.IamConfig result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.uniformBucketLevelAccess_ =
              uniformBucketLevelAccessBuilder_ == null
                  ? uniformBucketLevelAccess_
                  : uniformBucketLevelAccessBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.publicAccessPrevention_ = publicAccessPrevention_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.storage.v2.Bucket.IamConfig) {
          return mergeFrom((com.google.storage.v2.Bucket.IamConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.storage.v2.Bucket.IamConfig other) {
        if (other == com.google.storage.v2.Bucket.IamConfig.getDefaultInstance()) return this;
        if (other.hasUniformBucketLevelAccess()) {
          mergeUniformBucketLevelAccess(other.getUniformBucketLevelAccess());
        }
        if (!other.getPublicAccessPrevention().isEmpty()) {
          publicAccessPrevention_ = other.publicAccessPrevention_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getUniformBucketLevelAccessFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 26:
                {
                  publicAccessPrevention_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess
          uniformBucketLevelAccess_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess,
              com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess.Builder,
              com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccessOrBuilder>
          uniformBucketLevelAccessBuilder_;
      /**
       *
       *
       * <pre>
       * Bucket restriction options currently enforced on the bucket.
       * </pre>
       *
       * <code>
       * .google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess uniform_bucket_level_access = 1;
       * </code>
       *
       * @return Whether the uniformBucketLevelAccess field is set.
       */
      public boolean hasUniformBucketLevelAccess() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Bucket restriction options currently enforced on the bucket.
       * </pre>
       *
       * <code>
       * .google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess uniform_bucket_level_access = 1;
       * </code>
       *
       * @return The uniformBucketLevelAccess.
       */
      public com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess
          getUniformBucketLevelAccess() {
        if (uniformBucketLevelAccessBuilder_ == null) {
          return uniformBucketLevelAccess_ == null
              ? com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess.getDefaultInstance()
              : uniformBucketLevelAccess_;
        } else {
          return uniformBucketLevelAccessBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Bucket restriction options currently enforced on the bucket.
       * </pre>
       *
       * <code>
       * .google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess uniform_bucket_level_access = 1;
       * </code>
       */
      public Builder setUniformBucketLevelAccess(
          com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess value) {
        if (uniformBucketLevelAccessBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          uniformBucketLevelAccess_ = value;
        } else {
          uniformBucketLevelAccessBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Bucket restriction options currently enforced on the bucket.
       * </pre>
       *
       * <code>
       * .google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess uniform_bucket_level_access = 1;
       * </code>
       */
      public Builder setUniformBucketLevelAccess(
          com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess.Builder builderForValue) {
        if (uniformBucketLevelAccessBuilder_ == null) {
          uniformBucketLevelAccess_ = builderForValue.build();
        } else {
          uniformBucketLevelAccessBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Bucket restriction options currently enforced on the bucket.
       * </pre>
       *
       * <code>
       * .google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess uniform_bucket_level_access = 1;
       * </code>
       */
      public Builder mergeUniformBucketLevelAccess(
          com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess value) {
        if (uniformBucketLevelAccessBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && uniformBucketLevelAccess_ != null
              && uniformBucketLevelAccess_
                  != com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess
                      .getDefaultInstance()) {
            getUniformBucketLevelAccessBuilder().mergeFrom(value);
          } else {
            uniformBucketLevelAccess_ = value;
          }
        } else {
          uniformBucketLevelAccessBuilder_.mergeFrom(value);
        }
        if (uniformBucketLevelAccess_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Bucket restriction options currently enforced on the bucket.
       * </pre>
       *
       * <code>
       * .google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess uniform_bucket_level_access = 1;
       * </code>
       */
      public Builder clearUniformBucketLevelAccess() {
        bitField0_ = (bitField0_ & ~0x00000001);
        uniformBucketLevelAccess_ = null;
        if (uniformBucketLevelAccessBuilder_ != null) {
          uniformBucketLevelAccessBuilder_.dispose();
          uniformBucketLevelAccessBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Bucket restriction options currently enforced on the bucket.
       * </pre>
       *
       * <code>
       * .google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess uniform_bucket_level_access = 1;
       * </code>
       */
      public com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess.Builder
          getUniformBucketLevelAccessBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getUniformBucketLevelAccessFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Bucket restriction options currently enforced on the bucket.
       * </pre>
       *
       * <code>
       * .google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess uniform_bucket_level_access = 1;
       * </code>
       */
      public com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccessOrBuilder
          getUniformBucketLevelAccessOrBuilder() {
        if (uniformBucketLevelAccessBuilder_ != null) {
          return uniformBucketLevelAccessBuilder_.getMessageOrBuilder();
        } else {
          return uniformBucketLevelAccess_ == null
              ? com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess.getDefaultInstance()
              : uniformBucketLevelAccess_;
        }
      }
      /**
       *
       *
       * <pre>
       * Bucket restriction options currently enforced on the bucket.
       * </pre>
       *
       * <code>
       * .google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess uniform_bucket_level_access = 1;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess,
              com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess.Builder,
              com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccessOrBuilder>
          getUniformBucketLevelAccessFieldBuilder() {
        if (uniformBucketLevelAccessBuilder_ == null) {
          uniformBucketLevelAccessBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess,
                  com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess.Builder,
                  com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccessOrBuilder>(
                  getUniformBucketLevelAccess(), getParentForChildren(), isClean());
          uniformBucketLevelAccess_ = null;
        }
        return uniformBucketLevelAccessBuilder_;
      }

      private java.lang.Object publicAccessPrevention_ = "";
      /**
       *
       *
       * <pre>
       * Whether IAM will enforce public access prevention. Valid values are
       * "enforced" or "inherited".
       * </pre>
       *
       * <code>string public_access_prevention = 3;</code>
       *
       * @return The publicAccessPrevention.
       */
      public java.lang.String getPublicAccessPrevention() {
        java.lang.Object ref = publicAccessPrevention_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          publicAccessPrevention_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Whether IAM will enforce public access prevention. Valid values are
       * "enforced" or "inherited".
       * </pre>
       *
       * <code>string public_access_prevention = 3;</code>
       *
       * @return The bytes for publicAccessPrevention.
       */
      public com.google.protobuf.ByteString getPublicAccessPreventionBytes() {
        java.lang.Object ref = publicAccessPrevention_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          publicAccessPrevention_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Whether IAM will enforce public access prevention. Valid values are
       * "enforced" or "inherited".
       * </pre>
       *
       * <code>string public_access_prevention = 3;</code>
       *
       * @param value The publicAccessPrevention to set.
       * @return This builder for chaining.
       */
      public Builder setPublicAccessPrevention(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        publicAccessPrevention_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Whether IAM will enforce public access prevention. Valid values are
       * "enforced" or "inherited".
       * </pre>
       *
       * <code>string public_access_prevention = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPublicAccessPrevention() {
        publicAccessPrevention_ = getDefaultInstance().getPublicAccessPrevention();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Whether IAM will enforce public access prevention. Valid values are
       * "enforced" or "inherited".
       * </pre>
       *
       * <code>string public_access_prevention = 3;</code>
       *
       * @param value The bytes for publicAccessPrevention to set.
       * @return This builder for chaining.
       */
      public Builder setPublicAccessPreventionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        publicAccessPrevention_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storage.v2.Bucket.IamConfig)
    }

    // @@protoc_insertion_point(class_scope:google.storage.v2.Bucket.IamConfig)
    private static final com.google.storage.v2.Bucket.IamConfig DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.storage.v2.Bucket.IamConfig();
    }

    public static com.google.storage.v2.Bucket.IamConfig getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<IamConfig> PARSER =
        new com.google.protobuf.AbstractParser<IamConfig>() {
          @java.lang.Override
          public IamConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<IamConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<IamConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storage.v2.Bucket.IamConfig getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface LifecycleOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storage.v2.Bucket.Lifecycle)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * A lifecycle management rule, which is made of an action to take and the
     * condition(s) under which the action will be taken.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1;</code>
     */
    java.util.List<com.google.storage.v2.Bucket.Lifecycle.Rule> getRuleList();
    /**
     *
     *
     * <pre>
     * A lifecycle management rule, which is made of an action to take and the
     * condition(s) under which the action will be taken.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1;</code>
     */
    com.google.storage.v2.Bucket.Lifecycle.Rule getRule(int index);
    /**
     *
     *
     * <pre>
     * A lifecycle management rule, which is made of an action to take and the
     * condition(s) under which the action will be taken.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1;</code>
     */
    int getRuleCount();
    /**
     *
     *
     * <pre>
     * A lifecycle management rule, which is made of an action to take and the
     * condition(s) under which the action will be taken.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1;</code>
     */
    java.util.List<? extends com.google.storage.v2.Bucket.Lifecycle.RuleOrBuilder>
        getRuleOrBuilderList();
    /**
     *
     *
     * <pre>
     * A lifecycle management rule, which is made of an action to take and the
     * condition(s) under which the action will be taken.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1;</code>
     */
    com.google.storage.v2.Bucket.Lifecycle.RuleOrBuilder getRuleOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * Lifecycle properties of a bucket.
   * For more information, see https://cloud.google.com/storage/docs/lifecycle.
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.Bucket.Lifecycle}
   */
  public static final class Lifecycle extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storage.v2.Bucket.Lifecycle)
      LifecycleOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Lifecycle.newBuilder() to construct.
    private Lifecycle(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Lifecycle() {
      rule_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Lifecycle();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_Lifecycle_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_Lifecycle_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.Bucket.Lifecycle.class,
              com.google.storage.v2.Bucket.Lifecycle.Builder.class);
    }

    public interface RuleOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.storage.v2.Bucket.Lifecycle.Rule)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The action to take.
       * </pre>
       *
       * <code>.google.storage.v2.Bucket.Lifecycle.Rule.Action action = 1;</code>
       *
       * @return Whether the action field is set.
       */
      boolean hasAction();
      /**
       *
       *
       * <pre>
       * The action to take.
       * </pre>
       *
       * <code>.google.storage.v2.Bucket.Lifecycle.Rule.Action action = 1;</code>
       *
       * @return The action.
       */
      com.google.storage.v2.Bucket.Lifecycle.Rule.Action getAction();
      /**
       *
       *
       * <pre>
       * The action to take.
       * </pre>
       *
       * <code>.google.storage.v2.Bucket.Lifecycle.Rule.Action action = 1;</code>
       */
      com.google.storage.v2.Bucket.Lifecycle.Rule.ActionOrBuilder getActionOrBuilder();

      /**
       *
       *
       * <pre>
       * The condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>.google.storage.v2.Bucket.Lifecycle.Rule.Condition condition = 2;</code>
       *
       * @return Whether the condition field is set.
       */
      boolean hasCondition();
      /**
       *
       *
       * <pre>
       * The condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>.google.storage.v2.Bucket.Lifecycle.Rule.Condition condition = 2;</code>
       *
       * @return The condition.
       */
      com.google.storage.v2.Bucket.Lifecycle.Rule.Condition getCondition();
      /**
       *
       *
       * <pre>
       * The condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>.google.storage.v2.Bucket.Lifecycle.Rule.Condition condition = 2;</code>
       */
      com.google.storage.v2.Bucket.Lifecycle.Rule.ConditionOrBuilder getConditionOrBuilder();
    }
    /**
     *
     *
     * <pre>
     * A lifecycle Rule, combining an action to take on an object and a
     * condition which will trigger that action.
     * </pre>
     *
     * Protobuf type {@code google.storage.v2.Bucket.Lifecycle.Rule}
     */
    public static final class Rule extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.storage.v2.Bucket.Lifecycle.Rule)
        RuleOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Rule.newBuilder() to construct.
      private Rule(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Rule() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Rule();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Lifecycle_Rule_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Lifecycle_Rule_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storage.v2.Bucket.Lifecycle.Rule.class,
                com.google.storage.v2.Bucket.Lifecycle.Rule.Builder.class);
      }

      public interface ActionOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.storage.v2.Bucket.Lifecycle.Rule.Action)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Type of the action. Currently, only `Delete`, `SetStorageClass`, and
         * `AbortIncompleteMultipartUpload` are supported.
         * </pre>
         *
         * <code>string type = 1;</code>
         *
         * @return The type.
         */
        java.lang.String getType();
        /**
         *
         *
         * <pre>
         * Type of the action. Currently, only `Delete`, `SetStorageClass`, and
         * `AbortIncompleteMultipartUpload` are supported.
         * </pre>
         *
         * <code>string type = 1;</code>
         *
         * @return The bytes for type.
         */
        com.google.protobuf.ByteString getTypeBytes();

        /**
         *
         *
         * <pre>
         * Target storage class. Required iff the type of the action is
         * SetStorageClass.
         * </pre>
         *
         * <code>string storage_class = 2;</code>
         *
         * @return The storageClass.
         */
        java.lang.String getStorageClass();
        /**
         *
         *
         * <pre>
         * Target storage class. Required iff the type of the action is
         * SetStorageClass.
         * </pre>
         *
         * <code>string storage_class = 2;</code>
         *
         * @return The bytes for storageClass.
         */
        com.google.protobuf.ByteString getStorageClassBytes();
      }
      /**
       *
       *
       * <pre>
       * An action to take on an object.
       * </pre>
       *
       * Protobuf type {@code google.storage.v2.Bucket.Lifecycle.Rule.Action}
       */
      public static final class Action extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.storage.v2.Bucket.Lifecycle.Rule.Action)
          ActionOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use Action.newBuilder() to construct.
        private Action(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private Action() {
          type_ = "";
          storageClass_ = "";
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new Action();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.storage.v2.StorageProto
              .internal_static_google_storage_v2_Bucket_Lifecycle_Rule_Action_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.storage.v2.StorageProto
              .internal_static_google_storage_v2_Bucket_Lifecycle_Rule_Action_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.storage.v2.Bucket.Lifecycle.Rule.Action.class,
                  com.google.storage.v2.Bucket.Lifecycle.Rule.Action.Builder.class);
        }

        public static final int TYPE_FIELD_NUMBER = 1;

        @SuppressWarnings("serial")
        private volatile java.lang.Object type_ = "";
        /**
         *
         *
         * <pre>
         * Type of the action. Currently, only `Delete`, `SetStorageClass`, and
         * `AbortIncompleteMultipartUpload` are supported.
         * </pre>
         *
         * <code>string type = 1;</code>
         *
         * @return The type.
         */
        @java.lang.Override
        public java.lang.String getType() {
          java.lang.Object ref = type_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            type_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * Type of the action. Currently, only `Delete`, `SetStorageClass`, and
         * `AbortIncompleteMultipartUpload` are supported.
         * </pre>
         *
         * <code>string type = 1;</code>
         *
         * @return The bytes for type.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getTypeBytes() {
          java.lang.Object ref = type_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            type_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int STORAGE_CLASS_FIELD_NUMBER = 2;

        @SuppressWarnings("serial")
        private volatile java.lang.Object storageClass_ = "";
        /**
         *
         *
         * <pre>
         * Target storage class. Required iff the type of the action is
         * SetStorageClass.
         * </pre>
         *
         * <code>string storage_class = 2;</code>
         *
         * @return The storageClass.
         */
        @java.lang.Override
        public java.lang.String getStorageClass() {
          java.lang.Object ref = storageClass_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            storageClass_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * Target storage class. Required iff the type of the action is
         * SetStorageClass.
         * </pre>
         *
         * <code>string storage_class = 2;</code>
         *
         * @return The bytes for storageClass.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getStorageClassBytes() {
          java.lang.Object ref = storageClass_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            storageClass_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 1, type_);
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(storageClass_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 2, storageClass_);
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, type_);
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(storageClass_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, storageClass_);
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj instanceof com.google.storage.v2.Bucket.Lifecycle.Rule.Action)) {
            return super.equals(obj);
          }
          com.google.storage.v2.Bucket.Lifecycle.Rule.Action other =
              (com.google.storage.v2.Bucket.Lifecycle.Rule.Action) obj;

          if (!getType().equals(other.getType())) return false;
          if (!getStorageClass().equals(other.getStorageClass())) return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (37 * hash) + TYPE_FIELD_NUMBER;
          hash = (53 * hash) + getType().hashCode();
          hash = (37 * hash) + STORAGE_CLASS_FIELD_NUMBER;
          hash = (53 * hash) + getStorageClass().hashCode();
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Action parseFrom(
            java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Action parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Action parseFrom(
            com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Action parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Action parseFrom(byte[] data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Action parseFrom(
            byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Action parseFrom(
            java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Action parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Action parseDelimitedFrom(
            java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Action parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Action parseFrom(
            com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Action parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.storage.v2.Bucket.Lifecycle.Rule.Action prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * An action to take on an object.
         * </pre>
         *
         * Protobuf type {@code google.storage.v2.Bucket.Lifecycle.Rule.Action}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.storage.v2.Bucket.Lifecycle.Rule.Action)
            com.google.storage.v2.Bucket.Lifecycle.Rule.ActionOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.storage.v2.StorageProto
                .internal_static_google_storage_v2_Bucket_Lifecycle_Rule_Action_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.storage.v2.StorageProto
                .internal_static_google_storage_v2_Bucket_Lifecycle_Rule_Action_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.storage.v2.Bucket.Lifecycle.Rule.Action.class,
                    com.google.storage.v2.Bucket.Lifecycle.Rule.Action.Builder.class);
          }

          // Construct using com.google.storage.v2.Bucket.Lifecycle.Rule.Action.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            type_ = "";
            storageClass_ = "";
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.storage.v2.StorageProto
                .internal_static_google_storage_v2_Bucket_Lifecycle_Rule_Action_descriptor;
          }

          @java.lang.Override
          public com.google.storage.v2.Bucket.Lifecycle.Rule.Action getDefaultInstanceForType() {
            return com.google.storage.v2.Bucket.Lifecycle.Rule.Action.getDefaultInstance();
          }

          @java.lang.Override
          public com.google.storage.v2.Bucket.Lifecycle.Rule.Action build() {
            com.google.storage.v2.Bucket.Lifecycle.Rule.Action result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.storage.v2.Bucket.Lifecycle.Rule.Action buildPartial() {
            com.google.storage.v2.Bucket.Lifecycle.Rule.Action result =
                new com.google.storage.v2.Bucket.Lifecycle.Rule.Action(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(com.google.storage.v2.Bucket.Lifecycle.Rule.Action result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.type_ = type_;
            }
            if (((from_bitField0_ & 0x00000002) != 0)) {
              result.storageClass_ = storageClass_;
            }
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other instanceof com.google.storage.v2.Bucket.Lifecycle.Rule.Action) {
              return mergeFrom((com.google.storage.v2.Bucket.Lifecycle.Rule.Action) other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(com.google.storage.v2.Bucket.Lifecycle.Rule.Action other) {
            if (other == com.google.storage.v2.Bucket.Lifecycle.Rule.Action.getDefaultInstance())
              return this;
            if (!other.getType().isEmpty()) {
              type_ = other.type_;
              bitField0_ |= 0x00000001;
              onChanged();
            }
            if (!other.getStorageClass().isEmpty()) {
              storageClass_ = other.storageClass_;
              bitField0_ |= 0x00000002;
              onChanged();
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      type_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 10
                  case 18:
                    {
                      storageClass_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000002;
                      break;
                    } // case 18
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private java.lang.Object type_ = "";
          /**
           *
           *
           * <pre>
           * Type of the action. Currently, only `Delete`, `SetStorageClass`, and
           * `AbortIncompleteMultipartUpload` are supported.
           * </pre>
           *
           * <code>string type = 1;</code>
           *
           * @return The type.
           */
          public java.lang.String getType() {
            java.lang.Object ref = type_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              type_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Type of the action. Currently, only `Delete`, `SetStorageClass`, and
           * `AbortIncompleteMultipartUpload` are supported.
           * </pre>
           *
           * <code>string type = 1;</code>
           *
           * @return The bytes for type.
           */
          public com.google.protobuf.ByteString getTypeBytes() {
            java.lang.Object ref = type_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              type_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Type of the action. Currently, only `Delete`, `SetStorageClass`, and
           * `AbortIncompleteMultipartUpload` are supported.
           * </pre>
           *
           * <code>string type = 1;</code>
           *
           * @param value The type to set.
           * @return This builder for chaining.
           */
          public Builder setType(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            type_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Type of the action. Currently, only `Delete`, `SetStorageClass`, and
           * `AbortIncompleteMultipartUpload` are supported.
           * </pre>
           *
           * <code>string type = 1;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearType() {
            type_ = getDefaultInstance().getType();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Type of the action. Currently, only `Delete`, `SetStorageClass`, and
           * `AbortIncompleteMultipartUpload` are supported.
           * </pre>
           *
           * <code>string type = 1;</code>
           *
           * @param value The bytes for type to set.
           * @return This builder for chaining.
           */
          public Builder setTypeBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            type_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }

          private java.lang.Object storageClass_ = "";
          /**
           *
           *
           * <pre>
           * Target storage class. Required iff the type of the action is
           * SetStorageClass.
           * </pre>
           *
           * <code>string storage_class = 2;</code>
           *
           * @return The storageClass.
           */
          public java.lang.String getStorageClass() {
            java.lang.Object ref = storageClass_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              storageClass_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Target storage class. Required iff the type of the action is
           * SetStorageClass.
           * </pre>
           *
           * <code>string storage_class = 2;</code>
           *
           * @return The bytes for storageClass.
           */
          public com.google.protobuf.ByteString getStorageClassBytes() {
            java.lang.Object ref = storageClass_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              storageClass_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Target storage class. Required iff the type of the action is
           * SetStorageClass.
           * </pre>
           *
           * <code>string storage_class = 2;</code>
           *
           * @param value The storageClass to set.
           * @return This builder for chaining.
           */
          public Builder setStorageClass(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            storageClass_ = value;
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Target storage class. Required iff the type of the action is
           * SetStorageClass.
           * </pre>
           *
           * <code>string storage_class = 2;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearStorageClass() {
            storageClass_ = getDefaultInstance().getStorageClass();
            bitField0_ = (bitField0_ & ~0x00000002);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Target storage class. Required iff the type of the action is
           * SetStorageClass.
           * </pre>
           *
           * <code>string storage_class = 2;</code>
           *
           * @param value The bytes for storageClass to set.
           * @return This builder for chaining.
           */
          public Builder setStorageClassBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            storageClass_ = value;
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.storage.v2.Bucket.Lifecycle.Rule.Action)
        }

        // @@protoc_insertion_point(class_scope:google.storage.v2.Bucket.Lifecycle.Rule.Action)
        private static final com.google.storage.v2.Bucket.Lifecycle.Rule.Action DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE = new com.google.storage.v2.Bucket.Lifecycle.Rule.Action();
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Action getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<Action> PARSER =
            new com.google.protobuf.AbstractParser<Action>() {
              @java.lang.Override
              public Action parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<Action> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<Action> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.storage.v2.Bucket.Lifecycle.Rule.Action getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public interface ConditionOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.storage.v2.Bucket.Lifecycle.Rule.Condition)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Age of an object (in days). This condition is satisfied when an
         * object reaches the specified age.
         * A value of 0 indicates that all objects immediately match this
         * condition.
         * </pre>
         *
         * <code>optional int32 age_days = 1;</code>
         *
         * @return Whether the ageDays field is set.
         */
        boolean hasAgeDays();
        /**
         *
         *
         * <pre>
         * Age of an object (in days). This condition is satisfied when an
         * object reaches the specified age.
         * A value of 0 indicates that all objects immediately match this
         * condition.
         * </pre>
         *
         * <code>optional int32 age_days = 1;</code>
         *
         * @return The ageDays.
         */
        int getAgeDays();

        /**
         *
         *
         * <pre>
         * This condition is satisfied when an object is created before midnight
         * of the specified date in UTC.
         * </pre>
         *
         * <code>.google.type.Date created_before = 2;</code>
         *
         * @return Whether the createdBefore field is set.
         */
        boolean hasCreatedBefore();
        /**
         *
         *
         * <pre>
         * This condition is satisfied when an object is created before midnight
         * of the specified date in UTC.
         * </pre>
         *
         * <code>.google.type.Date created_before = 2;</code>
         *
         * @return The createdBefore.
         */
        com.google.type.Date getCreatedBefore();
        /**
         *
         *
         * <pre>
         * This condition is satisfied when an object is created before midnight
         * of the specified date in UTC.
         * </pre>
         *
         * <code>.google.type.Date created_before = 2;</code>
         */
        com.google.type.DateOrBuilder getCreatedBeforeOrBuilder();

        /**
         *
         *
         * <pre>
         * Relevant only for versioned objects. If the value is
         * `true`, this condition matches live objects; if the value
         * is `false`, it matches archived objects.
         * </pre>
         *
         * <code>optional bool is_live = 3;</code>
         *
         * @return Whether the isLive field is set.
         */
        boolean hasIsLive();
        /**
         *
         *
         * <pre>
         * Relevant only for versioned objects. If the value is
         * `true`, this condition matches live objects; if the value
         * is `false`, it matches archived objects.
         * </pre>
         *
         * <code>optional bool is_live = 3;</code>
         *
         * @return The isLive.
         */
        boolean getIsLive();

        /**
         *
         *
         * <pre>
         * Relevant only for versioned objects. If the value is N, this
         * condition is satisfied when there are at least N versions (including
         * the live version) newer than this version of the object.
         * </pre>
         *
         * <code>optional int32 num_newer_versions = 4;</code>
         *
         * @return Whether the numNewerVersions field is set.
         */
        boolean hasNumNewerVersions();
        /**
         *
         *
         * <pre>
         * Relevant only for versioned objects. If the value is N, this
         * condition is satisfied when there are at least N versions (including
         * the live version) newer than this version of the object.
         * </pre>
         *
         * <code>optional int32 num_newer_versions = 4;</code>
         *
         * @return The numNewerVersions.
         */
        int getNumNewerVersions();

        /**
         *
         *
         * <pre>
         * Objects having any of the storage classes specified by this condition
         * will be matched. Values include `MULTI_REGIONAL`, `REGIONAL`,
         * `NEARLINE`, `COLDLINE`, `STANDARD`, and
         * `DURABLE_REDUCED_AVAILABILITY`.
         * </pre>
         *
         * <code>repeated string matches_storage_class = 5;</code>
         *
         * @return A list containing the matchesStorageClass.
         */
        java.util.List<java.lang.String> getMatchesStorageClassList();
        /**
         *
         *
         * <pre>
         * Objects having any of the storage classes specified by this condition
         * will be matched. Values include `MULTI_REGIONAL`, `REGIONAL`,
         * `NEARLINE`, `COLDLINE`, `STANDARD`, and
         * `DURABLE_REDUCED_AVAILABILITY`.
         * </pre>
         *
         * <code>repeated string matches_storage_class = 5;</code>
         *
         * @return The count of matchesStorageClass.
         */
        int getMatchesStorageClassCount();
        /**
         *
         *
         * <pre>
         * Objects having any of the storage classes specified by this condition
         * will be matched. Values include `MULTI_REGIONAL`, `REGIONAL`,
         * `NEARLINE`, `COLDLINE`, `STANDARD`, and
         * `DURABLE_REDUCED_AVAILABILITY`.
         * </pre>
         *
         * <code>repeated string matches_storage_class = 5;</code>
         *
         * @param index The index of the element to return.
         * @return The matchesStorageClass at the given index.
         */
        java.lang.String getMatchesStorageClass(int index);
        /**
         *
         *
         * <pre>
         * Objects having any of the storage classes specified by this condition
         * will be matched. Values include `MULTI_REGIONAL`, `REGIONAL`,
         * `NEARLINE`, `COLDLINE`, `STANDARD`, and
         * `DURABLE_REDUCED_AVAILABILITY`.
         * </pre>
         *
         * <code>repeated string matches_storage_class = 5;</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the matchesStorageClass at the given index.
         */
        com.google.protobuf.ByteString getMatchesStorageClassBytes(int index);

        /**
         *
         *
         * <pre>
         * Number of days that have elapsed since the custom timestamp set on an
         * object.
         * The value of the field must be a nonnegative integer.
         * </pre>
         *
         * <code>optional int32 days_since_custom_time = 7;</code>
         *
         * @return Whether the daysSinceCustomTime field is set.
         */
        boolean hasDaysSinceCustomTime();
        /**
         *
         *
         * <pre>
         * Number of days that have elapsed since the custom timestamp set on an
         * object.
         * The value of the field must be a nonnegative integer.
         * </pre>
         *
         * <code>optional int32 days_since_custom_time = 7;</code>
         *
         * @return The daysSinceCustomTime.
         */
        int getDaysSinceCustomTime();

        /**
         *
         *
         * <pre>
         * An object matches this condition if the custom timestamp set on the
         * object is before the specified date in UTC.
         * </pre>
         *
         * <code>.google.type.Date custom_time_before = 8;</code>
         *
         * @return Whether the customTimeBefore field is set.
         */
        boolean hasCustomTimeBefore();
        /**
         *
         *
         * <pre>
         * An object matches this condition if the custom timestamp set on the
         * object is before the specified date in UTC.
         * </pre>
         *
         * <code>.google.type.Date custom_time_before = 8;</code>
         *
         * @return The customTimeBefore.
         */
        com.google.type.Date getCustomTimeBefore();
        /**
         *
         *
         * <pre>
         * An object matches this condition if the custom timestamp set on the
         * object is before the specified date in UTC.
         * </pre>
         *
         * <code>.google.type.Date custom_time_before = 8;</code>
         */
        com.google.type.DateOrBuilder getCustomTimeBeforeOrBuilder();

        /**
         *
         *
         * <pre>
         * This condition is relevant only for versioned objects. An object
         * version satisfies this condition only if these many days have been
         * passed since it became noncurrent. The value of the field must be a
         * nonnegative integer. If it's zero, the object version will become
         * eligible for Lifecycle action as soon as it becomes noncurrent.
         * </pre>
         *
         * <code>optional int32 days_since_noncurrent_time = 9;</code>
         *
         * @return Whether the daysSinceNoncurrentTime field is set.
         */
        boolean hasDaysSinceNoncurrentTime();
        /**
         *
         *
         * <pre>
         * This condition is relevant only for versioned objects. An object
         * version satisfies this condition only if these many days have been
         * passed since it became noncurrent. The value of the field must be a
         * nonnegative integer. If it's zero, the object version will become
         * eligible for Lifecycle action as soon as it becomes noncurrent.
         * </pre>
         *
         * <code>optional int32 days_since_noncurrent_time = 9;</code>
         *
         * @return The daysSinceNoncurrentTime.
         */
        int getDaysSinceNoncurrentTime();

        /**
         *
         *
         * <pre>
         * This condition is relevant only for versioned objects. An object
         * version satisfies this condition only if it became noncurrent before
         * the specified date in UTC.
         * </pre>
         *
         * <code>.google.type.Date noncurrent_time_before = 10;</code>
         *
         * @return Whether the noncurrentTimeBefore field is set.
         */
        boolean hasNoncurrentTimeBefore();
        /**
         *
         *
         * <pre>
         * This condition is relevant only for versioned objects. An object
         * version satisfies this condition only if it became noncurrent before
         * the specified date in UTC.
         * </pre>
         *
         * <code>.google.type.Date noncurrent_time_before = 10;</code>
         *
         * @return The noncurrentTimeBefore.
         */
        com.google.type.Date getNoncurrentTimeBefore();
        /**
         *
         *
         * <pre>
         * This condition is relevant only for versioned objects. An object
         * version satisfies this condition only if it became noncurrent before
         * the specified date in UTC.
         * </pre>
         *
         * <code>.google.type.Date noncurrent_time_before = 10;</code>
         */
        com.google.type.DateOrBuilder getNoncurrentTimeBeforeOrBuilder();

        /**
         *
         *
         * <pre>
         * List of object name prefixes. If any prefix exactly matches the
         * beginning of the object name, the condition evaluates to true.
         * </pre>
         *
         * <code>repeated string matches_prefix = 11;</code>
         *
         * @return A list containing the matchesPrefix.
         */
        java.util.List<java.lang.String> getMatchesPrefixList();
        /**
         *
         *
         * <pre>
         * List of object name prefixes. If any prefix exactly matches the
         * beginning of the object name, the condition evaluates to true.
         * </pre>
         *
         * <code>repeated string matches_prefix = 11;</code>
         *
         * @return The count of matchesPrefix.
         */
        int getMatchesPrefixCount();
        /**
         *
         *
         * <pre>
         * List of object name prefixes. If any prefix exactly matches the
         * beginning of the object name, the condition evaluates to true.
         * </pre>
         *
         * <code>repeated string matches_prefix = 11;</code>
         *
         * @param index The index of the element to return.
         * @return The matchesPrefix at the given index.
         */
        java.lang.String getMatchesPrefix(int index);
        /**
         *
         *
         * <pre>
         * List of object name prefixes. If any prefix exactly matches the
         * beginning of the object name, the condition evaluates to true.
         * </pre>
         *
         * <code>repeated string matches_prefix = 11;</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the matchesPrefix at the given index.
         */
        com.google.protobuf.ByteString getMatchesPrefixBytes(int index);

        /**
         *
         *
         * <pre>
         * List of object name suffixes. If any suffix exactly matches the
         * end of the object name, the condition evaluates to true.
         * </pre>
         *
         * <code>repeated string matches_suffix = 12;</code>
         *
         * @return A list containing the matchesSuffix.
         */
        java.util.List<java.lang.String> getMatchesSuffixList();
        /**
         *
         *
         * <pre>
         * List of object name suffixes. If any suffix exactly matches the
         * end of the object name, the condition evaluates to true.
         * </pre>
         *
         * <code>repeated string matches_suffix = 12;</code>
         *
         * @return The count of matchesSuffix.
         */
        int getMatchesSuffixCount();
        /**
         *
         *
         * <pre>
         * List of object name suffixes. If any suffix exactly matches the
         * end of the object name, the condition evaluates to true.
         * </pre>
         *
         * <code>repeated string matches_suffix = 12;</code>
         *
         * @param index The index of the element to return.
         * @return The matchesSuffix at the given index.
         */
        java.lang.String getMatchesSuffix(int index);
        /**
         *
         *
         * <pre>
         * List of object name suffixes. If any suffix exactly matches the
         * end of the object name, the condition evaluates to true.
         * </pre>
         *
         * <code>repeated string matches_suffix = 12;</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the matchesSuffix at the given index.
         */
        com.google.protobuf.ByteString getMatchesSuffixBytes(int index);
      }
      /**
       *
       *
       * <pre>
       * A condition of an object which triggers some action.
       * </pre>
       *
       * Protobuf type {@code google.storage.v2.Bucket.Lifecycle.Rule.Condition}
       */
      public static final class Condition extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.storage.v2.Bucket.Lifecycle.Rule.Condition)
          ConditionOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use Condition.newBuilder() to construct.
        private Condition(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private Condition() {
          matchesStorageClass_ = com.google.protobuf.LazyStringArrayList.emptyList();
          matchesPrefix_ = com.google.protobuf.LazyStringArrayList.emptyList();
          matchesSuffix_ = com.google.protobuf.LazyStringArrayList.emptyList();
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new Condition();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.storage.v2.StorageProto
              .internal_static_google_storage_v2_Bucket_Lifecycle_Rule_Condition_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.storage.v2.StorageProto
              .internal_static_google_storage_v2_Bucket_Lifecycle_Rule_Condition_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.storage.v2.Bucket.Lifecycle.Rule.Condition.class,
                  com.google.storage.v2.Bucket.Lifecycle.Rule.Condition.Builder.class);
        }

        private int bitField0_;
        public static final int AGE_DAYS_FIELD_NUMBER = 1;
        private int ageDays_ = 0;
        /**
         *
         *
         * <pre>
         * Age of an object (in days). This condition is satisfied when an
         * object reaches the specified age.
         * A value of 0 indicates that all objects immediately match this
         * condition.
         * </pre>
         *
         * <code>optional int32 age_days = 1;</code>
         *
         * @return Whether the ageDays field is set.
         */
        @java.lang.Override
        public boolean hasAgeDays() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         *
         *
         * <pre>
         * Age of an object (in days). This condition is satisfied when an
         * object reaches the specified age.
         * A value of 0 indicates that all objects immediately match this
         * condition.
         * </pre>
         *
         * <code>optional int32 age_days = 1;</code>
         *
         * @return The ageDays.
         */
        @java.lang.Override
        public int getAgeDays() {
          return ageDays_;
        }

        public static final int CREATED_BEFORE_FIELD_NUMBER = 2;
        private com.google.type.Date createdBefore_;
        /**
         *
         *
         * <pre>
         * This condition is satisfied when an object is created before midnight
         * of the specified date in UTC.
         * </pre>
         *
         * <code>.google.type.Date created_before = 2;</code>
         *
         * @return Whether the createdBefore field is set.
         */
        @java.lang.Override
        public boolean hasCreatedBefore() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         *
         *
         * <pre>
         * This condition is satisfied when an object is created before midnight
         * of the specified date in UTC.
         * </pre>
         *
         * <code>.google.type.Date created_before = 2;</code>
         *
         * @return The createdBefore.
         */
        @java.lang.Override
        public com.google.type.Date getCreatedBefore() {
          return createdBefore_ == null
              ? com.google.type.Date.getDefaultInstance()
              : createdBefore_;
        }
        /**
         *
         *
         * <pre>
         * This condition is satisfied when an object is created before midnight
         * of the specified date in UTC.
         * </pre>
         *
         * <code>.google.type.Date created_before = 2;</code>
         */
        @java.lang.Override
        public com.google.type.DateOrBuilder getCreatedBeforeOrBuilder() {
          return createdBefore_ == null
              ? com.google.type.Date.getDefaultInstance()
              : createdBefore_;
        }

        public static final int IS_LIVE_FIELD_NUMBER = 3;
        private boolean isLive_ = false;
        /**
         *
         *
         * <pre>
         * Relevant only for versioned objects. If the value is
         * `true`, this condition matches live objects; if the value
         * is `false`, it matches archived objects.
         * </pre>
         *
         * <code>optional bool is_live = 3;</code>
         *
         * @return Whether the isLive field is set.
         */
        @java.lang.Override
        public boolean hasIsLive() {
          return ((bitField0_ & 0x00000004) != 0);
        }
        /**
         *
         *
         * <pre>
         * Relevant only for versioned objects. If the value is
         * `true`, this condition matches live objects; if the value
         * is `false`, it matches archived objects.
         * </pre>
         *
         * <code>optional bool is_live = 3;</code>
         *
         * @return The isLive.
         */
        @java.lang.Override
        public boolean getIsLive() {
          return isLive_;
        }

        public static final int NUM_NEWER_VERSIONS_FIELD_NUMBER = 4;
        private int numNewerVersions_ = 0;
        /**
         *
         *
         * <pre>
         * Relevant only for versioned objects. If the value is N, this
         * condition is satisfied when there are at least N versions (including
         * the live version) newer than this version of the object.
         * </pre>
         *
         * <code>optional int32 num_newer_versions = 4;</code>
         *
         * @return Whether the numNewerVersions field is set.
         */
        @java.lang.Override
        public boolean hasNumNewerVersions() {
          return ((bitField0_ & 0x00000008) != 0);
        }
        /**
         *
         *
         * <pre>
         * Relevant only for versioned objects. If the value is N, this
         * condition is satisfied when there are at least N versions (including
         * the live version) newer than this version of the object.
         * </pre>
         *
         * <code>optional int32 num_newer_versions = 4;</code>
         *
         * @return The numNewerVersions.
         */
        @java.lang.Override
        public int getNumNewerVersions() {
          return numNewerVersions_;
        }

        public static final int MATCHES_STORAGE_CLASS_FIELD_NUMBER = 5;

        @SuppressWarnings("serial")
        private com.google.protobuf.LazyStringArrayList matchesStorageClass_ =
            com.google.protobuf.LazyStringArrayList.emptyList();
        /**
         *
         *
         * <pre>
         * Objects having any of the storage classes specified by this condition
         * will be matched. Values include `MULTI_REGIONAL`, `REGIONAL`,
         * `NEARLINE`, `COLDLINE`, `STANDARD`, and
         * `DURABLE_REDUCED_AVAILABILITY`.
         * </pre>
         *
         * <code>repeated string matches_storage_class = 5;</code>
         *
         * @return A list containing the matchesStorageClass.
         */
        public com.google.protobuf.ProtocolStringList getMatchesStorageClassList() {
          return matchesStorageClass_;
        }
        /**
         *
         *
         * <pre>
         * Objects having any of the storage classes specified by this condition
         * will be matched. Values include `MULTI_REGIONAL`, `REGIONAL`,
         * `NEARLINE`, `COLDLINE`, `STANDARD`, and
         * `DURABLE_REDUCED_AVAILABILITY`.
         * </pre>
         *
         * <code>repeated string matches_storage_class = 5;</code>
         *
         * @return The count of matchesStorageClass.
         */
        public int getMatchesStorageClassCount() {
          return matchesStorageClass_.size();
        }
        /**
         *
         *
         * <pre>
         * Objects having any of the storage classes specified by this condition
         * will be matched. Values include `MULTI_REGIONAL`, `REGIONAL`,
         * `NEARLINE`, `COLDLINE`, `STANDARD`, and
         * `DURABLE_REDUCED_AVAILABILITY`.
         * </pre>
         *
         * <code>repeated string matches_storage_class = 5;</code>
         *
         * @param index The index of the element to return.
         * @return The matchesStorageClass at the given index.
         */
        public java.lang.String getMatchesStorageClass(int index) {
          return matchesStorageClass_.get(index);
        }
        /**
         *
         *
         * <pre>
         * Objects having any of the storage classes specified by this condition
         * will be matched. Values include `MULTI_REGIONAL`, `REGIONAL`,
         * `NEARLINE`, `COLDLINE`, `STANDARD`, and
         * `DURABLE_REDUCED_AVAILABILITY`.
         * </pre>
         *
         * <code>repeated string matches_storage_class = 5;</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the matchesStorageClass at the given index.
         */
        public com.google.protobuf.ByteString getMatchesStorageClassBytes(int index) {
          return matchesStorageClass_.getByteString(index);
        }

        public static final int DAYS_SINCE_CUSTOM_TIME_FIELD_NUMBER = 7;
        private int daysSinceCustomTime_ = 0;
        /**
         *
         *
         * <pre>
         * Number of days that have elapsed since the custom timestamp set on an
         * object.
         * The value of the field must be a nonnegative integer.
         * </pre>
         *
         * <code>optional int32 days_since_custom_time = 7;</code>
         *
         * @return Whether the daysSinceCustomTime field is set.
         */
        @java.lang.Override
        public boolean hasDaysSinceCustomTime() {
          return ((bitField0_ & 0x00000010) != 0);
        }
        /**
         *
         *
         * <pre>
         * Number of days that have elapsed since the custom timestamp set on an
         * object.
         * The value of the field must be a nonnegative integer.
         * </pre>
         *
         * <code>optional int32 days_since_custom_time = 7;</code>
         *
         * @return The daysSinceCustomTime.
         */
        @java.lang.Override
        public int getDaysSinceCustomTime() {
          return daysSinceCustomTime_;
        }

        public static final int CUSTOM_TIME_BEFORE_FIELD_NUMBER = 8;
        private com.google.type.Date customTimeBefore_;
        /**
         *
         *
         * <pre>
         * An object matches this condition if the custom timestamp set on the
         * object is before the specified date in UTC.
         * </pre>
         *
         * <code>.google.type.Date custom_time_before = 8;</code>
         *
         * @return Whether the customTimeBefore field is set.
         */
        @java.lang.Override
        public boolean hasCustomTimeBefore() {
          return ((bitField0_ & 0x00000020) != 0);
        }
        /**
         *
         *
         * <pre>
         * An object matches this condition if the custom timestamp set on the
         * object is before the specified date in UTC.
         * </pre>
         *
         * <code>.google.type.Date custom_time_before = 8;</code>
         *
         * @return The customTimeBefore.
         */
        @java.lang.Override
        public com.google.type.Date getCustomTimeBefore() {
          return customTimeBefore_ == null
              ? com.google.type.Date.getDefaultInstance()
              : customTimeBefore_;
        }
        /**
         *
         *
         * <pre>
         * An object matches this condition if the custom timestamp set on the
         * object is before the specified date in UTC.
         * </pre>
         *
         * <code>.google.type.Date custom_time_before = 8;</code>
         */
        @java.lang.Override
        public com.google.type.DateOrBuilder getCustomTimeBeforeOrBuilder() {
          return customTimeBefore_ == null
              ? com.google.type.Date.getDefaultInstance()
              : customTimeBefore_;
        }

        public static final int DAYS_SINCE_NONCURRENT_TIME_FIELD_NUMBER = 9;
        private int daysSinceNoncurrentTime_ = 0;
        /**
         *
         *
         * <pre>
         * This condition is relevant only for versioned objects. An object
         * version satisfies this condition only if these many days have been
         * passed since it became noncurrent. The value of the field must be a
         * nonnegative integer. If it's zero, the object version will become
         * eligible for Lifecycle action as soon as it becomes noncurrent.
         * </pre>
         *
         * <code>optional int32 days_since_noncurrent_time = 9;</code>
         *
         * @return Whether the daysSinceNoncurrentTime field is set.
         */
        @java.lang.Override
        public boolean hasDaysSinceNoncurrentTime() {
          return ((bitField0_ & 0x00000040) != 0);
        }
        /**
         *
         *
         * <pre>
         * This condition is relevant only for versioned objects. An object
         * version satisfies this condition only if these many days have been
         * passed since it became noncurrent. The value of the field must be a
         * nonnegative integer. If it's zero, the object version will become
         * eligible for Lifecycle action as soon as it becomes noncurrent.
         * </pre>
         *
         * <code>optional int32 days_since_noncurrent_time = 9;</code>
         *
         * @return The daysSinceNoncurrentTime.
         */
        @java.lang.Override
        public int getDaysSinceNoncurrentTime() {
          return daysSinceNoncurrentTime_;
        }

        public static final int NONCURRENT_TIME_BEFORE_FIELD_NUMBER = 10;
        private com.google.type.Date noncurrentTimeBefore_;
        /**
         *
         *
         * <pre>
         * This condition is relevant only for versioned objects. An object
         * version satisfies this condition only if it became noncurrent before
         * the specified date in UTC.
         * </pre>
         *
         * <code>.google.type.Date noncurrent_time_before = 10;</code>
         *
         * @return Whether the noncurrentTimeBefore field is set.
         */
        @java.lang.Override
        public boolean hasNoncurrentTimeBefore() {
          return ((bitField0_ & 0x00000080) != 0);
        }
        /**
         *
         *
         * <pre>
         * This condition is relevant only for versioned objects. An object
         * version satisfies this condition only if it became noncurrent before
         * the specified date in UTC.
         * </pre>
         *
         * <code>.google.type.Date noncurrent_time_before = 10;</code>
         *
         * @return The noncurrentTimeBefore.
         */
        @java.lang.Override
        public com.google.type.Date getNoncurrentTimeBefore() {
          return noncurrentTimeBefore_ == null
              ? com.google.type.Date.getDefaultInstance()
              : noncurrentTimeBefore_;
        }
        /**
         *
         *
         * <pre>
         * This condition is relevant only for versioned objects. An object
         * version satisfies this condition only if it became noncurrent before
         * the specified date in UTC.
         * </pre>
         *
         * <code>.google.type.Date noncurrent_time_before = 10;</code>
         */
        @java.lang.Override
        public com.google.type.DateOrBuilder getNoncurrentTimeBeforeOrBuilder() {
          return noncurrentTimeBefore_ == null
              ? com.google.type.Date.getDefaultInstance()
              : noncurrentTimeBefore_;
        }

        public static final int MATCHES_PREFIX_FIELD_NUMBER = 11;

        @SuppressWarnings("serial")
        private com.google.protobuf.LazyStringArrayList matchesPrefix_ =
            com.google.protobuf.LazyStringArrayList.emptyList();
        /**
         *
         *
         * <pre>
         * List of object name prefixes. If any prefix exactly matches the
         * beginning of the object name, the condition evaluates to true.
         * </pre>
         *
         * <code>repeated string matches_prefix = 11;</code>
         *
         * @return A list containing the matchesPrefix.
         */
        public com.google.protobuf.ProtocolStringList getMatchesPrefixList() {
          return matchesPrefix_;
        }
        /**
         *
         *
         * <pre>
         * List of object name prefixes. If any prefix exactly matches the
         * beginning of the object name, the condition evaluates to true.
         * </pre>
         *
         * <code>repeated string matches_prefix = 11;</code>
         *
         * @return The count of matchesPrefix.
         */
        public int getMatchesPrefixCount() {
          return matchesPrefix_.size();
        }
        /**
         *
         *
         * <pre>
         * List of object name prefixes. If any prefix exactly matches the
         * beginning of the object name, the condition evaluates to true.
         * </pre>
         *
         * <code>repeated string matches_prefix = 11;</code>
         *
         * @param index The index of the element to return.
         * @return The matchesPrefix at the given index.
         */
        public java.lang.String getMatchesPrefix(int index) {
          return matchesPrefix_.get(index);
        }
        /**
         *
         *
         * <pre>
         * List of object name prefixes. If any prefix exactly matches the
         * beginning of the object name, the condition evaluates to true.
         * </pre>
         *
         * <code>repeated string matches_prefix = 11;</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the matchesPrefix at the given index.
         */
        public com.google.protobuf.ByteString getMatchesPrefixBytes(int index) {
          return matchesPrefix_.getByteString(index);
        }

        public static final int MATCHES_SUFFIX_FIELD_NUMBER = 12;

        @SuppressWarnings("serial")
        private com.google.protobuf.LazyStringArrayList matchesSuffix_ =
            com.google.protobuf.LazyStringArrayList.emptyList();
        /**
         *
         *
         * <pre>
         * List of object name suffixes. If any suffix exactly matches the
         * end of the object name, the condition evaluates to true.
         * </pre>
         *
         * <code>repeated string matches_suffix = 12;</code>
         *
         * @return A list containing the matchesSuffix.
         */
        public com.google.protobuf.ProtocolStringList getMatchesSuffixList() {
          return matchesSuffix_;
        }
        /**
         *
         *
         * <pre>
         * List of object name suffixes. If any suffix exactly matches the
         * end of the object name, the condition evaluates to true.
         * </pre>
         *
         * <code>repeated string matches_suffix = 12;</code>
         *
         * @return The count of matchesSuffix.
         */
        public int getMatchesSuffixCount() {
          return matchesSuffix_.size();
        }
        /**
         *
         *
         * <pre>
         * List of object name suffixes. If any suffix exactly matches the
         * end of the object name, the condition evaluates to true.
         * </pre>
         *
         * <code>repeated string matches_suffix = 12;</code>
         *
         * @param index The index of the element to return.
         * @return The matchesSuffix at the given index.
         */
        public java.lang.String getMatchesSuffix(int index) {
          return matchesSuffix_.get(index);
        }
        /**
         *
         *
         * <pre>
         * List of object name suffixes. If any suffix exactly matches the
         * end of the object name, the condition evaluates to true.
         * </pre>
         *
         * <code>repeated string matches_suffix = 12;</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the matchesSuffix at the given index.
         */
        public com.google.protobuf.ByteString getMatchesSuffixBytes(int index) {
          return matchesSuffix_.getByteString(index);
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (((bitField0_ & 0x00000001) != 0)) {
            output.writeInt32(1, ageDays_);
          }
          if (((bitField0_ & 0x00000002) != 0)) {
            output.writeMessage(2, getCreatedBefore());
          }
          if (((bitField0_ & 0x00000004) != 0)) {
            output.writeBool(3, isLive_);
          }
          if (((bitField0_ & 0x00000008) != 0)) {
            output.writeInt32(4, numNewerVersions_);
          }
          for (int i = 0; i < matchesStorageClass_.size(); i++) {
            com.google.protobuf.GeneratedMessageV3.writeString(
                output, 5, matchesStorageClass_.getRaw(i));
          }
          if (((bitField0_ & 0x00000010) != 0)) {
            output.writeInt32(7, daysSinceCustomTime_);
          }
          if (((bitField0_ & 0x00000020) != 0)) {
            output.writeMessage(8, getCustomTimeBefore());
          }
          if (((bitField0_ & 0x00000040) != 0)) {
            output.writeInt32(9, daysSinceNoncurrentTime_);
          }
          if (((bitField0_ & 0x00000080) != 0)) {
            output.writeMessage(10, getNoncurrentTimeBefore());
          }
          for (int i = 0; i < matchesPrefix_.size(); i++) {
            com.google.protobuf.GeneratedMessageV3.writeString(
                output, 11, matchesPrefix_.getRaw(i));
          }
          for (int i = 0; i < matchesSuffix_.size(); i++) {
            com.google.protobuf.GeneratedMessageV3.writeString(
                output, 12, matchesSuffix_.getRaw(i));
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (((bitField0_ & 0x00000001) != 0)) {
            size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, ageDays_);
          }
          if (((bitField0_ & 0x00000002) != 0)) {
            size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCreatedBefore());
          }
          if (((bitField0_ & 0x00000004) != 0)) {
            size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, isLive_);
          }
          if (((bitField0_ & 0x00000008) != 0)) {
            size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, numNewerVersions_);
          }
          {
            int dataSize = 0;
            for (int i = 0; i < matchesStorageClass_.size(); i++) {
              dataSize += computeStringSizeNoTag(matchesStorageClass_.getRaw(i));
            }
            size += dataSize;
            size += 1 * getMatchesStorageClassList().size();
          }
          if (((bitField0_ & 0x00000010) != 0)) {
            size += com.google.protobuf.CodedOutputStream.computeInt32Size(7, daysSinceCustomTime_);
          }
          if (((bitField0_ & 0x00000020) != 0)) {
            size +=
                com.google.protobuf.CodedOutputStream.computeMessageSize(8, getCustomTimeBefore());
          }
          if (((bitField0_ & 0x00000040) != 0)) {
            size +=
                com.google.protobuf.CodedOutputStream.computeInt32Size(9, daysSinceNoncurrentTime_);
          }
          if (((bitField0_ & 0x00000080) != 0)) {
            size +=
                com.google.protobuf.CodedOutputStream.computeMessageSize(
                    10, getNoncurrentTimeBefore());
          }
          {
            int dataSize = 0;
            for (int i = 0; i < matchesPrefix_.size(); i++) {
              dataSize += computeStringSizeNoTag(matchesPrefix_.getRaw(i));
            }
            size += dataSize;
            size += 1 * getMatchesPrefixList().size();
          }
          {
            int dataSize = 0;
            for (int i = 0; i < matchesSuffix_.size(); i++) {
              dataSize += computeStringSizeNoTag(matchesSuffix_.getRaw(i));
            }
            size += dataSize;
            size += 1 * getMatchesSuffixList().size();
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj instanceof com.google.storage.v2.Bucket.Lifecycle.Rule.Condition)) {
            return super.equals(obj);
          }
          com.google.storage.v2.Bucket.Lifecycle.Rule.Condition other =
              (com.google.storage.v2.Bucket.Lifecycle.Rule.Condition) obj;

          if (hasAgeDays() != other.hasAgeDays()) return false;
          if (hasAgeDays()) {
            if (getAgeDays() != other.getAgeDays()) return false;
          }
          if (hasCreatedBefore() != other.hasCreatedBefore()) return false;
          if (hasCreatedBefore()) {
            if (!getCreatedBefore().equals(other.getCreatedBefore())) return false;
          }
          if (hasIsLive() != other.hasIsLive()) return false;
          if (hasIsLive()) {
            if (getIsLive() != other.getIsLive()) return false;
          }
          if (hasNumNewerVersions() != other.hasNumNewerVersions()) return false;
          if (hasNumNewerVersions()) {
            if (getNumNewerVersions() != other.getNumNewerVersions()) return false;
          }
          if (!getMatchesStorageClassList().equals(other.getMatchesStorageClassList()))
            return false;
          if (hasDaysSinceCustomTime() != other.hasDaysSinceCustomTime()) return false;
          if (hasDaysSinceCustomTime()) {
            if (getDaysSinceCustomTime() != other.getDaysSinceCustomTime()) return false;
          }
          if (hasCustomTimeBefore() != other.hasCustomTimeBefore()) return false;
          if (hasCustomTimeBefore()) {
            if (!getCustomTimeBefore().equals(other.getCustomTimeBefore())) return false;
          }
          if (hasDaysSinceNoncurrentTime() != other.hasDaysSinceNoncurrentTime()) return false;
          if (hasDaysSinceNoncurrentTime()) {
            if (getDaysSinceNoncurrentTime() != other.getDaysSinceNoncurrentTime()) return false;
          }
          if (hasNoncurrentTimeBefore() != other.hasNoncurrentTimeBefore()) return false;
          if (hasNoncurrentTimeBefore()) {
            if (!getNoncurrentTimeBefore().equals(other.getNoncurrentTimeBefore())) return false;
          }
          if (!getMatchesPrefixList().equals(other.getMatchesPrefixList())) return false;
          if (!getMatchesSuffixList().equals(other.getMatchesSuffixList())) return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          if (hasAgeDays()) {
            hash = (37 * hash) + AGE_DAYS_FIELD_NUMBER;
            hash = (53 * hash) + getAgeDays();
          }
          if (hasCreatedBefore()) {
            hash = (37 * hash) + CREATED_BEFORE_FIELD_NUMBER;
            hash = (53 * hash) + getCreatedBefore().hashCode();
          }
          if (hasIsLive()) {
            hash = (37 * hash) + IS_LIVE_FIELD_NUMBER;
            hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIsLive());
          }
          if (hasNumNewerVersions()) {
            hash = (37 * hash) + NUM_NEWER_VERSIONS_FIELD_NUMBER;
            hash = (53 * hash) + getNumNewerVersions();
          }
          if (getMatchesStorageClassCount() > 0) {
            hash = (37 * hash) + MATCHES_STORAGE_CLASS_FIELD_NUMBER;
            hash = (53 * hash) + getMatchesStorageClassList().hashCode();
          }
          if (hasDaysSinceCustomTime()) {
            hash = (37 * hash) + DAYS_SINCE_CUSTOM_TIME_FIELD_NUMBER;
            hash = (53 * hash) + getDaysSinceCustomTime();
          }
          if (hasCustomTimeBefore()) {
            hash = (37 * hash) + CUSTOM_TIME_BEFORE_FIELD_NUMBER;
            hash = (53 * hash) + getCustomTimeBefore().hashCode();
          }
          if (hasDaysSinceNoncurrentTime()) {
            hash = (37 * hash) + DAYS_SINCE_NONCURRENT_TIME_FIELD_NUMBER;
            hash = (53 * hash) + getDaysSinceNoncurrentTime();
          }
          if (hasNoncurrentTimeBefore()) {
            hash = (37 * hash) + NONCURRENT_TIME_BEFORE_FIELD_NUMBER;
            hash = (53 * hash) + getNoncurrentTimeBefore().hashCode();
          }
          if (getMatchesPrefixCount() > 0) {
            hash = (37 * hash) + MATCHES_PREFIX_FIELD_NUMBER;
            hash = (53 * hash) + getMatchesPrefixList().hashCode();
          }
          if (getMatchesSuffixCount() > 0) {
            hash = (37 * hash) + MATCHES_SUFFIX_FIELD_NUMBER;
            hash = (53 * hash) + getMatchesSuffixList().hashCode();
          }
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Condition parseFrom(
            java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Condition parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Condition parseFrom(
            com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Condition parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Condition parseFrom(byte[] data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Condition parseFrom(
            byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Condition parseFrom(
            java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Condition parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Condition parseDelimitedFrom(
            java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Condition parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Condition parseFrom(
            com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Condition parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.storage.v2.Bucket.Lifecycle.Rule.Condition prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * A condition of an object which triggers some action.
         * </pre>
         *
         * Protobuf type {@code google.storage.v2.Bucket.Lifecycle.Rule.Condition}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.storage.v2.Bucket.Lifecycle.Rule.Condition)
            com.google.storage.v2.Bucket.Lifecycle.Rule.ConditionOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.storage.v2.StorageProto
                .internal_static_google_storage_v2_Bucket_Lifecycle_Rule_Condition_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.storage.v2.StorageProto
                .internal_static_google_storage_v2_Bucket_Lifecycle_Rule_Condition_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.storage.v2.Bucket.Lifecycle.Rule.Condition.class,
                    com.google.storage.v2.Bucket.Lifecycle.Rule.Condition.Builder.class);
          }

          // Construct using com.google.storage.v2.Bucket.Lifecycle.Rule.Condition.newBuilder()
          private Builder() {
            maybeForceBuilderInitialization();
          }

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            maybeForceBuilderInitialization();
          }

          private void maybeForceBuilderInitialization() {
            if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
              getCreatedBeforeFieldBuilder();
              getCustomTimeBeforeFieldBuilder();
              getNoncurrentTimeBeforeFieldBuilder();
            }
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            ageDays_ = 0;
            createdBefore_ = null;
            if (createdBeforeBuilder_ != null) {
              createdBeforeBuilder_.dispose();
              createdBeforeBuilder_ = null;
            }
            isLive_ = false;
            numNewerVersions_ = 0;
            matchesStorageClass_ = com.google.protobuf.LazyStringArrayList.emptyList();
            daysSinceCustomTime_ = 0;
            customTimeBefore_ = null;
            if (customTimeBeforeBuilder_ != null) {
              customTimeBeforeBuilder_.dispose();
              customTimeBeforeBuilder_ = null;
            }
            daysSinceNoncurrentTime_ = 0;
            noncurrentTimeBefore_ = null;
            if (noncurrentTimeBeforeBuilder_ != null) {
              noncurrentTimeBeforeBuilder_.dispose();
              noncurrentTimeBeforeBuilder_ = null;
            }
            matchesPrefix_ = com.google.protobuf.LazyStringArrayList.emptyList();
            matchesSuffix_ = com.google.protobuf.LazyStringArrayList.emptyList();
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.storage.v2.StorageProto
                .internal_static_google_storage_v2_Bucket_Lifecycle_Rule_Condition_descriptor;
          }

          @java.lang.Override
          public com.google.storage.v2.Bucket.Lifecycle.Rule.Condition getDefaultInstanceForType() {
            return com.google.storage.v2.Bucket.Lifecycle.Rule.Condition.getDefaultInstance();
          }

          @java.lang.Override
          public com.google.storage.v2.Bucket.Lifecycle.Rule.Condition build() {
            com.google.storage.v2.Bucket.Lifecycle.Rule.Condition result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.storage.v2.Bucket.Lifecycle.Rule.Condition buildPartial() {
            com.google.storage.v2.Bucket.Lifecycle.Rule.Condition result =
                new com.google.storage.v2.Bucket.Lifecycle.Rule.Condition(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(com.google.storage.v2.Bucket.Lifecycle.Rule.Condition result) {
            int from_bitField0_ = bitField0_;
            int to_bitField0_ = 0;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.ageDays_ = ageDays_;
              to_bitField0_ |= 0x00000001;
            }
            if (((from_bitField0_ & 0x00000002) != 0)) {
              result.createdBefore_ =
                  createdBeforeBuilder_ == null ? createdBefore_ : createdBeforeBuilder_.build();
              to_bitField0_ |= 0x00000002;
            }
            if (((from_bitField0_ & 0x00000004) != 0)) {
              result.isLive_ = isLive_;
              to_bitField0_ |= 0x00000004;
            }
            if (((from_bitField0_ & 0x00000008) != 0)) {
              result.numNewerVersions_ = numNewerVersions_;
              to_bitField0_ |= 0x00000008;
            }
            if (((from_bitField0_ & 0x00000010) != 0)) {
              matchesStorageClass_.makeImmutable();
              result.matchesStorageClass_ = matchesStorageClass_;
            }
            if (((from_bitField0_ & 0x00000020) != 0)) {
              result.daysSinceCustomTime_ = daysSinceCustomTime_;
              to_bitField0_ |= 0x00000010;
            }
            if (((from_bitField0_ & 0x00000040) != 0)) {
              result.customTimeBefore_ =
                  customTimeBeforeBuilder_ == null
                      ? customTimeBefore_
                      : customTimeBeforeBuilder_.build();
              to_bitField0_ |= 0x00000020;
            }
            if (((from_bitField0_ & 0x00000080) != 0)) {
              result.daysSinceNoncurrentTime_ = daysSinceNoncurrentTime_;
              to_bitField0_ |= 0x00000040;
            }
            if (((from_bitField0_ & 0x00000100) != 0)) {
              result.noncurrentTimeBefore_ =
                  noncurrentTimeBeforeBuilder_ == null
                      ? noncurrentTimeBefore_
                      : noncurrentTimeBeforeBuilder_.build();
              to_bitField0_ |= 0x00000080;
            }
            if (((from_bitField0_ & 0x00000200) != 0)) {
              matchesPrefix_.makeImmutable();
              result.matchesPrefix_ = matchesPrefix_;
            }
            if (((from_bitField0_ & 0x00000400) != 0)) {
              matchesSuffix_.makeImmutable();
              result.matchesSuffix_ = matchesSuffix_;
            }
            result.bitField0_ |= to_bitField0_;
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other instanceof com.google.storage.v2.Bucket.Lifecycle.Rule.Condition) {
              return mergeFrom((com.google.storage.v2.Bucket.Lifecycle.Rule.Condition) other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(com.google.storage.v2.Bucket.Lifecycle.Rule.Condition other) {
            if (other == com.google.storage.v2.Bucket.Lifecycle.Rule.Condition.getDefaultInstance())
              return this;
            if (other.hasAgeDays()) {
              setAgeDays(other.getAgeDays());
            }
            if (other.hasCreatedBefore()) {
              mergeCreatedBefore(other.getCreatedBefore());
            }
            if (other.hasIsLive()) {
              setIsLive(other.getIsLive());
            }
            if (other.hasNumNewerVersions()) {
              setNumNewerVersions(other.getNumNewerVersions());
            }
            if (!other.matchesStorageClass_.isEmpty()) {
              if (matchesStorageClass_.isEmpty()) {
                matchesStorageClass_ = other.matchesStorageClass_;
                bitField0_ |= 0x00000010;
              } else {
                ensureMatchesStorageClassIsMutable();
                matchesStorageClass_.addAll(other.matchesStorageClass_);
              }
              onChanged();
            }
            if (other.hasDaysSinceCustomTime()) {
              setDaysSinceCustomTime(other.getDaysSinceCustomTime());
            }
            if (other.hasCustomTimeBefore()) {
              mergeCustomTimeBefore(other.getCustomTimeBefore());
            }
            if (other.hasDaysSinceNoncurrentTime()) {
              setDaysSinceNoncurrentTime(other.getDaysSinceNoncurrentTime());
            }
            if (other.hasNoncurrentTimeBefore()) {
              mergeNoncurrentTimeBefore(other.getNoncurrentTimeBefore());
            }
            if (!other.matchesPrefix_.isEmpty()) {
              if (matchesPrefix_.isEmpty()) {
                matchesPrefix_ = other.matchesPrefix_;
                bitField0_ |= 0x00000200;
              } else {
                ensureMatchesPrefixIsMutable();
                matchesPrefix_.addAll(other.matchesPrefix_);
              }
              onChanged();
            }
            if (!other.matchesSuffix_.isEmpty()) {
              if (matchesSuffix_.isEmpty()) {
                matchesSuffix_ = other.matchesSuffix_;
                bitField0_ |= 0x00000400;
              } else {
                ensureMatchesSuffixIsMutable();
                matchesSuffix_.addAll(other.matchesSuffix_);
              }
              onChanged();
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 8:
                    {
                      ageDays_ = input.readInt32();
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 8
                  case 18:
                    {
                      input.readMessage(
                          getCreatedBeforeFieldBuilder().getBuilder(), extensionRegistry);
                      bitField0_ |= 0x00000002;
                      break;
                    } // case 18
                  case 24:
                    {
                      isLive_ = input.readBool();
                      bitField0_ |= 0x00000004;
                      break;
                    } // case 24
                  case 32:
                    {
                      numNewerVersions_ = input.readInt32();
                      bitField0_ |= 0x00000008;
                      break;
                    } // case 32
                  case 42:
                    {
                      java.lang.String s = input.readStringRequireUtf8();
                      ensureMatchesStorageClassIsMutable();
                      matchesStorageClass_.add(s);
                      break;
                    } // case 42
                  case 56:
                    {
                      daysSinceCustomTime_ = input.readInt32();
                      bitField0_ |= 0x00000020;
                      break;
                    } // case 56
                  case 66:
                    {
                      input.readMessage(
                          getCustomTimeBeforeFieldBuilder().getBuilder(), extensionRegistry);
                      bitField0_ |= 0x00000040;
                      break;
                    } // case 66
                  case 72:
                    {
                      daysSinceNoncurrentTime_ = input.readInt32();
                      bitField0_ |= 0x00000080;
                      break;
                    } // case 72
                  case 82:
                    {
                      input.readMessage(
                          getNoncurrentTimeBeforeFieldBuilder().getBuilder(), extensionRegistry);
                      bitField0_ |= 0x00000100;
                      break;
                    } // case 82
                  case 90:
                    {
                      java.lang.String s = input.readStringRequireUtf8();
                      ensureMatchesPrefixIsMutable();
                      matchesPrefix_.add(s);
                      break;
                    } // case 90
                  case 98:
                    {
                      java.lang.String s = input.readStringRequireUtf8();
                      ensureMatchesSuffixIsMutable();
                      matchesSuffix_.add(s);
                      break;
                    } // case 98
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private int ageDays_;
          /**
           *
           *
           * <pre>
           * Age of an object (in days). This condition is satisfied when an
           * object reaches the specified age.
           * A value of 0 indicates that all objects immediately match this
           * condition.
           * </pre>
           *
           * <code>optional int32 age_days = 1;</code>
           *
           * @return Whether the ageDays field is set.
           */
          @java.lang.Override
          public boolean hasAgeDays() {
            return ((bitField0_ & 0x00000001) != 0);
          }
          /**
           *
           *
           * <pre>
           * Age of an object (in days). This condition is satisfied when an
           * object reaches the specified age.
           * A value of 0 indicates that all objects immediately match this
           * condition.
           * </pre>
           *
           * <code>optional int32 age_days = 1;</code>
           *
           * @return The ageDays.
           */
          @java.lang.Override
          public int getAgeDays() {
            return ageDays_;
          }
          /**
           *
           *
           * <pre>
           * Age of an object (in days). This condition is satisfied when an
           * object reaches the specified age.
           * A value of 0 indicates that all objects immediately match this
           * condition.
           * </pre>
           *
           * <code>optional int32 age_days = 1;</code>
           *
           * @param value The ageDays to set.
           * @return This builder for chaining.
           */
          public Builder setAgeDays(int value) {

            ageDays_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Age of an object (in days). This condition is satisfied when an
           * object reaches the specified age.
           * A value of 0 indicates that all objects immediately match this
           * condition.
           * </pre>
           *
           * <code>optional int32 age_days = 1;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearAgeDays() {
            bitField0_ = (bitField0_ & ~0x00000001);
            ageDays_ = 0;
            onChanged();
            return this;
          }

          private com.google.type.Date createdBefore_;
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.type.Date, com.google.type.Date.Builder, com.google.type.DateOrBuilder>
              createdBeforeBuilder_;
          /**
           *
           *
           * <pre>
           * This condition is satisfied when an object is created before midnight
           * of the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date created_before = 2;</code>
           *
           * @return Whether the createdBefore field is set.
           */
          public boolean hasCreatedBefore() {
            return ((bitField0_ & 0x00000002) != 0);
          }
          /**
           *
           *
           * <pre>
           * This condition is satisfied when an object is created before midnight
           * of the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date created_before = 2;</code>
           *
           * @return The createdBefore.
           */
          public com.google.type.Date getCreatedBefore() {
            if (createdBeforeBuilder_ == null) {
              return createdBefore_ == null
                  ? com.google.type.Date.getDefaultInstance()
                  : createdBefore_;
            } else {
              return createdBeforeBuilder_.getMessage();
            }
          }
          /**
           *
           *
           * <pre>
           * This condition is satisfied when an object is created before midnight
           * of the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date created_before = 2;</code>
           */
          public Builder setCreatedBefore(com.google.type.Date value) {
            if (createdBeforeBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              createdBefore_ = value;
            } else {
              createdBeforeBuilder_.setMessage(value);
            }
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * This condition is satisfied when an object is created before midnight
           * of the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date created_before = 2;</code>
           */
          public Builder setCreatedBefore(com.google.type.Date.Builder builderForValue) {
            if (createdBeforeBuilder_ == null) {
              createdBefore_ = builderForValue.build();
            } else {
              createdBeforeBuilder_.setMessage(builderForValue.build());
            }
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * This condition is satisfied when an object is created before midnight
           * of the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date created_before = 2;</code>
           */
          public Builder mergeCreatedBefore(com.google.type.Date value) {
            if (createdBeforeBuilder_ == null) {
              if (((bitField0_ & 0x00000002) != 0)
                  && createdBefore_ != null
                  && createdBefore_ != com.google.type.Date.getDefaultInstance()) {
                getCreatedBeforeBuilder().mergeFrom(value);
              } else {
                createdBefore_ = value;
              }
            } else {
              createdBeforeBuilder_.mergeFrom(value);
            }
            if (createdBefore_ != null) {
              bitField0_ |= 0x00000002;
              onChanged();
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * This condition is satisfied when an object is created before midnight
           * of the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date created_before = 2;</code>
           */
          public Builder clearCreatedBefore() {
            bitField0_ = (bitField0_ & ~0x00000002);
            createdBefore_ = null;
            if (createdBeforeBuilder_ != null) {
              createdBeforeBuilder_.dispose();
              createdBeforeBuilder_ = null;
            }
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * This condition is satisfied when an object is created before midnight
           * of the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date created_before = 2;</code>
           */
          public com.google.type.Date.Builder getCreatedBeforeBuilder() {
            bitField0_ |= 0x00000002;
            onChanged();
            return getCreatedBeforeFieldBuilder().getBuilder();
          }
          /**
           *
           *
           * <pre>
           * This condition is satisfied when an object is created before midnight
           * of the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date created_before = 2;</code>
           */
          public com.google.type.DateOrBuilder getCreatedBeforeOrBuilder() {
            if (createdBeforeBuilder_ != null) {
              return createdBeforeBuilder_.getMessageOrBuilder();
            } else {
              return createdBefore_ == null
                  ? com.google.type.Date.getDefaultInstance()
                  : createdBefore_;
            }
          }
          /**
           *
           *
           * <pre>
           * This condition is satisfied when an object is created before midnight
           * of the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date created_before = 2;</code>
           */
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.type.Date, com.google.type.Date.Builder, com.google.type.DateOrBuilder>
              getCreatedBeforeFieldBuilder() {
            if (createdBeforeBuilder_ == null) {
              createdBeforeBuilder_ =
                  new com.google.protobuf.SingleFieldBuilderV3<
                      com.google.type.Date,
                      com.google.type.Date.Builder,
                      com.google.type.DateOrBuilder>(
                      getCreatedBefore(), getParentForChildren(), isClean());
              createdBefore_ = null;
            }
            return createdBeforeBuilder_;
          }

          private boolean isLive_;
          /**
           *
           *
           * <pre>
           * Relevant only for versioned objects. If the value is
           * `true`, this condition matches live objects; if the value
           * is `false`, it matches archived objects.
           * </pre>
           *
           * <code>optional bool is_live = 3;</code>
           *
           * @return Whether the isLive field is set.
           */
          @java.lang.Override
          public boolean hasIsLive() {
            return ((bitField0_ & 0x00000004) != 0);
          }
          /**
           *
           *
           * <pre>
           * Relevant only for versioned objects. If the value is
           * `true`, this condition matches live objects; if the value
           * is `false`, it matches archived objects.
           * </pre>
           *
           * <code>optional bool is_live = 3;</code>
           *
           * @return The isLive.
           */
          @java.lang.Override
          public boolean getIsLive() {
            return isLive_;
          }
          /**
           *
           *
           * <pre>
           * Relevant only for versioned objects. If the value is
           * `true`, this condition matches live objects; if the value
           * is `false`, it matches archived objects.
           * </pre>
           *
           * <code>optional bool is_live = 3;</code>
           *
           * @param value The isLive to set.
           * @return This builder for chaining.
           */
          public Builder setIsLive(boolean value) {

            isLive_ = value;
            bitField0_ |= 0x00000004;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Relevant only for versioned objects. If the value is
           * `true`, this condition matches live objects; if the value
           * is `false`, it matches archived objects.
           * </pre>
           *
           * <code>optional bool is_live = 3;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearIsLive() {
            bitField0_ = (bitField0_ & ~0x00000004);
            isLive_ = false;
            onChanged();
            return this;
          }

          private int numNewerVersions_;
          /**
           *
           *
           * <pre>
           * Relevant only for versioned objects. If the value is N, this
           * condition is satisfied when there are at least N versions (including
           * the live version) newer than this version of the object.
           * </pre>
           *
           * <code>optional int32 num_newer_versions = 4;</code>
           *
           * @return Whether the numNewerVersions field is set.
           */
          @java.lang.Override
          public boolean hasNumNewerVersions() {
            return ((bitField0_ & 0x00000008) != 0);
          }
          /**
           *
           *
           * <pre>
           * Relevant only for versioned objects. If the value is N, this
           * condition is satisfied when there are at least N versions (including
           * the live version) newer than this version of the object.
           * </pre>
           *
           * <code>optional int32 num_newer_versions = 4;</code>
           *
           * @return The numNewerVersions.
           */
          @java.lang.Override
          public int getNumNewerVersions() {
            return numNewerVersions_;
          }
          /**
           *
           *
           * <pre>
           * Relevant only for versioned objects. If the value is N, this
           * condition is satisfied when there are at least N versions (including
           * the live version) newer than this version of the object.
           * </pre>
           *
           * <code>optional int32 num_newer_versions = 4;</code>
           *
           * @param value The numNewerVersions to set.
           * @return This builder for chaining.
           */
          public Builder setNumNewerVersions(int value) {

            numNewerVersions_ = value;
            bitField0_ |= 0x00000008;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Relevant only for versioned objects. If the value is N, this
           * condition is satisfied when there are at least N versions (including
           * the live version) newer than this version of the object.
           * </pre>
           *
           * <code>optional int32 num_newer_versions = 4;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearNumNewerVersions() {
            bitField0_ = (bitField0_ & ~0x00000008);
            numNewerVersions_ = 0;
            onChanged();
            return this;
          }

          private com.google.protobuf.LazyStringArrayList matchesStorageClass_ =
              com.google.protobuf.LazyStringArrayList.emptyList();

          private void ensureMatchesStorageClassIsMutable() {
            if (!matchesStorageClass_.isModifiable()) {
              matchesStorageClass_ =
                  new com.google.protobuf.LazyStringArrayList(matchesStorageClass_);
            }
            bitField0_ |= 0x00000010;
          }
          /**
           *
           *
           * <pre>
           * Objects having any of the storage classes specified by this condition
           * will be matched. Values include `MULTI_REGIONAL`, `REGIONAL`,
           * `NEARLINE`, `COLDLINE`, `STANDARD`, and
           * `DURABLE_REDUCED_AVAILABILITY`.
           * </pre>
           *
           * <code>repeated string matches_storage_class = 5;</code>
           *
           * @return A list containing the matchesStorageClass.
           */
          public com.google.protobuf.ProtocolStringList getMatchesStorageClassList() {
            matchesStorageClass_.makeImmutable();
            return matchesStorageClass_;
          }
          /**
           *
           *
           * <pre>
           * Objects having any of the storage classes specified by this condition
           * will be matched. Values include `MULTI_REGIONAL`, `REGIONAL`,
           * `NEARLINE`, `COLDLINE`, `STANDARD`, and
           * `DURABLE_REDUCED_AVAILABILITY`.
           * </pre>
           *
           * <code>repeated string matches_storage_class = 5;</code>
           *
           * @return The count of matchesStorageClass.
           */
          public int getMatchesStorageClassCount() {
            return matchesStorageClass_.size();
          }
          /**
           *
           *
           * <pre>
           * Objects having any of the storage classes specified by this condition
           * will be matched. Values include `MULTI_REGIONAL`, `REGIONAL`,
           * `NEARLINE`, `COLDLINE`, `STANDARD`, and
           * `DURABLE_REDUCED_AVAILABILITY`.
           * </pre>
           *
           * <code>repeated string matches_storage_class = 5;</code>
           *
           * @param index The index of the element to return.
           * @return The matchesStorageClass at the given index.
           */
          public java.lang.String getMatchesStorageClass(int index) {
            return matchesStorageClass_.get(index);
          }
          /**
           *
           *
           * <pre>
           * Objects having any of the storage classes specified by this condition
           * will be matched. Values include `MULTI_REGIONAL`, `REGIONAL`,
           * `NEARLINE`, `COLDLINE`, `STANDARD`, and
           * `DURABLE_REDUCED_AVAILABILITY`.
           * </pre>
           *
           * <code>repeated string matches_storage_class = 5;</code>
           *
           * @param index The index of the value to return.
           * @return The bytes of the matchesStorageClass at the given index.
           */
          public com.google.protobuf.ByteString getMatchesStorageClassBytes(int index) {
            return matchesStorageClass_.getByteString(index);
          }
          /**
           *
           *
           * <pre>
           * Objects having any of the storage classes specified by this condition
           * will be matched. Values include `MULTI_REGIONAL`, `REGIONAL`,
           * `NEARLINE`, `COLDLINE`, `STANDARD`, and
           * `DURABLE_REDUCED_AVAILABILITY`.
           * </pre>
           *
           * <code>repeated string matches_storage_class = 5;</code>
           *
           * @param index The index to set the value at.
           * @param value The matchesStorageClass to set.
           * @return This builder for chaining.
           */
          public Builder setMatchesStorageClass(int index, java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureMatchesStorageClassIsMutable();
            matchesStorageClass_.set(index, value);
            bitField0_ |= 0x00000010;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Objects having any of the storage classes specified by this condition
           * will be matched. Values include `MULTI_REGIONAL`, `REGIONAL`,
           * `NEARLINE`, `COLDLINE`, `STANDARD`, and
           * `DURABLE_REDUCED_AVAILABILITY`.
           * </pre>
           *
           * <code>repeated string matches_storage_class = 5;</code>
           *
           * @param value The matchesStorageClass to add.
           * @return This builder for chaining.
           */
          public Builder addMatchesStorageClass(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureMatchesStorageClassIsMutable();
            matchesStorageClass_.add(value);
            bitField0_ |= 0x00000010;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Objects having any of the storage classes specified by this condition
           * will be matched. Values include `MULTI_REGIONAL`, `REGIONAL`,
           * `NEARLINE`, `COLDLINE`, `STANDARD`, and
           * `DURABLE_REDUCED_AVAILABILITY`.
           * </pre>
           *
           * <code>repeated string matches_storage_class = 5;</code>
           *
           * @param values The matchesStorageClass to add.
           * @return This builder for chaining.
           */
          public Builder addAllMatchesStorageClass(java.lang.Iterable<java.lang.String> values) {
            ensureMatchesStorageClassIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, matchesStorageClass_);
            bitField0_ |= 0x00000010;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Objects having any of the storage classes specified by this condition
           * will be matched. Values include `MULTI_REGIONAL`, `REGIONAL`,
           * `NEARLINE`, `COLDLINE`, `STANDARD`, and
           * `DURABLE_REDUCED_AVAILABILITY`.
           * </pre>
           *
           * <code>repeated string matches_storage_class = 5;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearMatchesStorageClass() {
            matchesStorageClass_ = com.google.protobuf.LazyStringArrayList.emptyList();
            bitField0_ = (bitField0_ & ~0x00000010);
            ;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Objects having any of the storage classes specified by this condition
           * will be matched. Values include `MULTI_REGIONAL`, `REGIONAL`,
           * `NEARLINE`, `COLDLINE`, `STANDARD`, and
           * `DURABLE_REDUCED_AVAILABILITY`.
           * </pre>
           *
           * <code>repeated string matches_storage_class = 5;</code>
           *
           * @param value The bytes of the matchesStorageClass to add.
           * @return This builder for chaining.
           */
          public Builder addMatchesStorageClassBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            ensureMatchesStorageClassIsMutable();
            matchesStorageClass_.add(value);
            bitField0_ |= 0x00000010;
            onChanged();
            return this;
          }

          private int daysSinceCustomTime_;
          /**
           *
           *
           * <pre>
           * Number of days that have elapsed since the custom timestamp set on an
           * object.
           * The value of the field must be a nonnegative integer.
           * </pre>
           *
           * <code>optional int32 days_since_custom_time = 7;</code>
           *
           * @return Whether the daysSinceCustomTime field is set.
           */
          @java.lang.Override
          public boolean hasDaysSinceCustomTime() {
            return ((bitField0_ & 0x00000020) != 0);
          }
          /**
           *
           *
           * <pre>
           * Number of days that have elapsed since the custom timestamp set on an
           * object.
           * The value of the field must be a nonnegative integer.
           * </pre>
           *
           * <code>optional int32 days_since_custom_time = 7;</code>
           *
           * @return The daysSinceCustomTime.
           */
          @java.lang.Override
          public int getDaysSinceCustomTime() {
            return daysSinceCustomTime_;
          }
          /**
           *
           *
           * <pre>
           * Number of days that have elapsed since the custom timestamp set on an
           * object.
           * The value of the field must be a nonnegative integer.
           * </pre>
           *
           * <code>optional int32 days_since_custom_time = 7;</code>
           *
           * @param value The daysSinceCustomTime to set.
           * @return This builder for chaining.
           */
          public Builder setDaysSinceCustomTime(int value) {

            daysSinceCustomTime_ = value;
            bitField0_ |= 0x00000020;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Number of days that have elapsed since the custom timestamp set on an
           * object.
           * The value of the field must be a nonnegative integer.
           * </pre>
           *
           * <code>optional int32 days_since_custom_time = 7;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearDaysSinceCustomTime() {
            bitField0_ = (bitField0_ & ~0x00000020);
            daysSinceCustomTime_ = 0;
            onChanged();
            return this;
          }

          private com.google.type.Date customTimeBefore_;
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.type.Date, com.google.type.Date.Builder, com.google.type.DateOrBuilder>
              customTimeBeforeBuilder_;
          /**
           *
           *
           * <pre>
           * An object matches this condition if the custom timestamp set on the
           * object is before the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date custom_time_before = 8;</code>
           *
           * @return Whether the customTimeBefore field is set.
           */
          public boolean hasCustomTimeBefore() {
            return ((bitField0_ & 0x00000040) != 0);
          }
          /**
           *
           *
           * <pre>
           * An object matches this condition if the custom timestamp set on the
           * object is before the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date custom_time_before = 8;</code>
           *
           * @return The customTimeBefore.
           */
          public com.google.type.Date getCustomTimeBefore() {
            if (customTimeBeforeBuilder_ == null) {
              return customTimeBefore_ == null
                  ? com.google.type.Date.getDefaultInstance()
                  : customTimeBefore_;
            } else {
              return customTimeBeforeBuilder_.getMessage();
            }
          }
          /**
           *
           *
           * <pre>
           * An object matches this condition if the custom timestamp set on the
           * object is before the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date custom_time_before = 8;</code>
           */
          public Builder setCustomTimeBefore(com.google.type.Date value) {
            if (customTimeBeforeBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              customTimeBefore_ = value;
            } else {
              customTimeBeforeBuilder_.setMessage(value);
            }
            bitField0_ |= 0x00000040;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * An object matches this condition if the custom timestamp set on the
           * object is before the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date custom_time_before = 8;</code>
           */
          public Builder setCustomTimeBefore(com.google.type.Date.Builder builderForValue) {
            if (customTimeBeforeBuilder_ == null) {
              customTimeBefore_ = builderForValue.build();
            } else {
              customTimeBeforeBuilder_.setMessage(builderForValue.build());
            }
            bitField0_ |= 0x00000040;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * An object matches this condition if the custom timestamp set on the
           * object is before the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date custom_time_before = 8;</code>
           */
          public Builder mergeCustomTimeBefore(com.google.type.Date value) {
            if (customTimeBeforeBuilder_ == null) {
              if (((bitField0_ & 0x00000040) != 0)
                  && customTimeBefore_ != null
                  && customTimeBefore_ != com.google.type.Date.getDefaultInstance()) {
                getCustomTimeBeforeBuilder().mergeFrom(value);
              } else {
                customTimeBefore_ = value;
              }
            } else {
              customTimeBeforeBuilder_.mergeFrom(value);
            }
            if (customTimeBefore_ != null) {
              bitField0_ |= 0x00000040;
              onChanged();
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * An object matches this condition if the custom timestamp set on the
           * object is before the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date custom_time_before = 8;</code>
           */
          public Builder clearCustomTimeBefore() {
            bitField0_ = (bitField0_ & ~0x00000040);
            customTimeBefore_ = null;
            if (customTimeBeforeBuilder_ != null) {
              customTimeBeforeBuilder_.dispose();
              customTimeBeforeBuilder_ = null;
            }
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * An object matches this condition if the custom timestamp set on the
           * object is before the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date custom_time_before = 8;</code>
           */
          public com.google.type.Date.Builder getCustomTimeBeforeBuilder() {
            bitField0_ |= 0x00000040;
            onChanged();
            return getCustomTimeBeforeFieldBuilder().getBuilder();
          }
          /**
           *
           *
           * <pre>
           * An object matches this condition if the custom timestamp set on the
           * object is before the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date custom_time_before = 8;</code>
           */
          public com.google.type.DateOrBuilder getCustomTimeBeforeOrBuilder() {
            if (customTimeBeforeBuilder_ != null) {
              return customTimeBeforeBuilder_.getMessageOrBuilder();
            } else {
              return customTimeBefore_ == null
                  ? com.google.type.Date.getDefaultInstance()
                  : customTimeBefore_;
            }
          }
          /**
           *
           *
           * <pre>
           * An object matches this condition if the custom timestamp set on the
           * object is before the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date custom_time_before = 8;</code>
           */
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.type.Date, com.google.type.Date.Builder, com.google.type.DateOrBuilder>
              getCustomTimeBeforeFieldBuilder() {
            if (customTimeBeforeBuilder_ == null) {
              customTimeBeforeBuilder_ =
                  new com.google.protobuf.SingleFieldBuilderV3<
                      com.google.type.Date,
                      com.google.type.Date.Builder,
                      com.google.type.DateOrBuilder>(
                      getCustomTimeBefore(), getParentForChildren(), isClean());
              customTimeBefore_ = null;
            }
            return customTimeBeforeBuilder_;
          }

          private int daysSinceNoncurrentTime_;
          /**
           *
           *
           * <pre>
           * This condition is relevant only for versioned objects. An object
           * version satisfies this condition only if these many days have been
           * passed since it became noncurrent. The value of the field must be a
           * nonnegative integer. If it's zero, the object version will become
           * eligible for Lifecycle action as soon as it becomes noncurrent.
           * </pre>
           *
           * <code>optional int32 days_since_noncurrent_time = 9;</code>
           *
           * @return Whether the daysSinceNoncurrentTime field is set.
           */
          @java.lang.Override
          public boolean hasDaysSinceNoncurrentTime() {
            return ((bitField0_ & 0x00000080) != 0);
          }
          /**
           *
           *
           * <pre>
           * This condition is relevant only for versioned objects. An object
           * version satisfies this condition only if these many days have been
           * passed since it became noncurrent. The value of the field must be a
           * nonnegative integer. If it's zero, the object version will become
           * eligible for Lifecycle action as soon as it becomes noncurrent.
           * </pre>
           *
           * <code>optional int32 days_since_noncurrent_time = 9;</code>
           *
           * @return The daysSinceNoncurrentTime.
           */
          @java.lang.Override
          public int getDaysSinceNoncurrentTime() {
            return daysSinceNoncurrentTime_;
          }
          /**
           *
           *
           * <pre>
           * This condition is relevant only for versioned objects. An object
           * version satisfies this condition only if these many days have been
           * passed since it became noncurrent. The value of the field must be a
           * nonnegative integer. If it's zero, the object version will become
           * eligible for Lifecycle action as soon as it becomes noncurrent.
           * </pre>
           *
           * <code>optional int32 days_since_noncurrent_time = 9;</code>
           *
           * @param value The daysSinceNoncurrentTime to set.
           * @return This builder for chaining.
           */
          public Builder setDaysSinceNoncurrentTime(int value) {

            daysSinceNoncurrentTime_ = value;
            bitField0_ |= 0x00000080;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * This condition is relevant only for versioned objects. An object
           * version satisfies this condition only if these many days have been
           * passed since it became noncurrent. The value of the field must be a
           * nonnegative integer. If it's zero, the object version will become
           * eligible for Lifecycle action as soon as it becomes noncurrent.
           * </pre>
           *
           * <code>optional int32 days_since_noncurrent_time = 9;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearDaysSinceNoncurrentTime() {
            bitField0_ = (bitField0_ & ~0x00000080);
            daysSinceNoncurrentTime_ = 0;
            onChanged();
            return this;
          }

          private com.google.type.Date noncurrentTimeBefore_;
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.type.Date, com.google.type.Date.Builder, com.google.type.DateOrBuilder>
              noncurrentTimeBeforeBuilder_;
          /**
           *
           *
           * <pre>
           * This condition is relevant only for versioned objects. An object
           * version satisfies this condition only if it became noncurrent before
           * the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date noncurrent_time_before = 10;</code>
           *
           * @return Whether the noncurrentTimeBefore field is set.
           */
          public boolean hasNoncurrentTimeBefore() {
            return ((bitField0_ & 0x00000100) != 0);
          }
          /**
           *
           *
           * <pre>
           * This condition is relevant only for versioned objects. An object
           * version satisfies this condition only if it became noncurrent before
           * the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date noncurrent_time_before = 10;</code>
           *
           * @return The noncurrentTimeBefore.
           */
          public com.google.type.Date getNoncurrentTimeBefore() {
            if (noncurrentTimeBeforeBuilder_ == null) {
              return noncurrentTimeBefore_ == null
                  ? com.google.type.Date.getDefaultInstance()
                  : noncurrentTimeBefore_;
            } else {
              return noncurrentTimeBeforeBuilder_.getMessage();
            }
          }
          /**
           *
           *
           * <pre>
           * This condition is relevant only for versioned objects. An object
           * version satisfies this condition only if it became noncurrent before
           * the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date noncurrent_time_before = 10;</code>
           */
          public Builder setNoncurrentTimeBefore(com.google.type.Date value) {
            if (noncurrentTimeBeforeBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              noncurrentTimeBefore_ = value;
            } else {
              noncurrentTimeBeforeBuilder_.setMessage(value);
            }
            bitField0_ |= 0x00000100;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * This condition is relevant only for versioned objects. An object
           * version satisfies this condition only if it became noncurrent before
           * the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date noncurrent_time_before = 10;</code>
           */
          public Builder setNoncurrentTimeBefore(com.google.type.Date.Builder builderForValue) {
            if (noncurrentTimeBeforeBuilder_ == null) {
              noncurrentTimeBefore_ = builderForValue.build();
            } else {
              noncurrentTimeBeforeBuilder_.setMessage(builderForValue.build());
            }
            bitField0_ |= 0x00000100;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * This condition is relevant only for versioned objects. An object
           * version satisfies this condition only if it became noncurrent before
           * the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date noncurrent_time_before = 10;</code>
           */
          public Builder mergeNoncurrentTimeBefore(com.google.type.Date value) {
            if (noncurrentTimeBeforeBuilder_ == null) {
              if (((bitField0_ & 0x00000100) != 0)
                  && noncurrentTimeBefore_ != null
                  && noncurrentTimeBefore_ != com.google.type.Date.getDefaultInstance()) {
                getNoncurrentTimeBeforeBuilder().mergeFrom(value);
              } else {
                noncurrentTimeBefore_ = value;
              }
            } else {
              noncurrentTimeBeforeBuilder_.mergeFrom(value);
            }
            if (noncurrentTimeBefore_ != null) {
              bitField0_ |= 0x00000100;
              onChanged();
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * This condition is relevant only for versioned objects. An object
           * version satisfies this condition only if it became noncurrent before
           * the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date noncurrent_time_before = 10;</code>
           */
          public Builder clearNoncurrentTimeBefore() {
            bitField0_ = (bitField0_ & ~0x00000100);
            noncurrentTimeBefore_ = null;
            if (noncurrentTimeBeforeBuilder_ != null) {
              noncurrentTimeBeforeBuilder_.dispose();
              noncurrentTimeBeforeBuilder_ = null;
            }
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * This condition is relevant only for versioned objects. An object
           * version satisfies this condition only if it became noncurrent before
           * the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date noncurrent_time_before = 10;</code>
           */
          public com.google.type.Date.Builder getNoncurrentTimeBeforeBuilder() {
            bitField0_ |= 0x00000100;
            onChanged();
            return getNoncurrentTimeBeforeFieldBuilder().getBuilder();
          }
          /**
           *
           *
           * <pre>
           * This condition is relevant only for versioned objects. An object
           * version satisfies this condition only if it became noncurrent before
           * the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date noncurrent_time_before = 10;</code>
           */
          public com.google.type.DateOrBuilder getNoncurrentTimeBeforeOrBuilder() {
            if (noncurrentTimeBeforeBuilder_ != null) {
              return noncurrentTimeBeforeBuilder_.getMessageOrBuilder();
            } else {
              return noncurrentTimeBefore_ == null
                  ? com.google.type.Date.getDefaultInstance()
                  : noncurrentTimeBefore_;
            }
          }
          /**
           *
           *
           * <pre>
           * This condition is relevant only for versioned objects. An object
           * version satisfies this condition only if it became noncurrent before
           * the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date noncurrent_time_before = 10;</code>
           */
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.type.Date, com.google.type.Date.Builder, com.google.type.DateOrBuilder>
              getNoncurrentTimeBeforeFieldBuilder() {
            if (noncurrentTimeBeforeBuilder_ == null) {
              noncurrentTimeBeforeBuilder_ =
                  new com.google.protobuf.SingleFieldBuilderV3<
                      com.google.type.Date,
                      com.google.type.Date.Builder,
                      com.google.type.DateOrBuilder>(
                      getNoncurrentTimeBefore(), getParentForChildren(), isClean());
              noncurrentTimeBefore_ = null;
            }
            return noncurrentTimeBeforeBuilder_;
          }

          private com.google.protobuf.LazyStringArrayList matchesPrefix_ =
              com.google.protobuf.LazyStringArrayList.emptyList();

          private void ensureMatchesPrefixIsMutable() {
            if (!matchesPrefix_.isModifiable()) {
              matchesPrefix_ = new com.google.protobuf.LazyStringArrayList(matchesPrefix_);
            }
            bitField0_ |= 0x00000200;
          }
          /**
           *
           *
           * <pre>
           * List of object name prefixes. If any prefix exactly matches the
           * beginning of the object name, the condition evaluates to true.
           * </pre>
           *
           * <code>repeated string matches_prefix = 11;</code>
           *
           * @return A list containing the matchesPrefix.
           */
          public com.google.protobuf.ProtocolStringList getMatchesPrefixList() {
            matchesPrefix_.makeImmutable();
            return matchesPrefix_;
          }
          /**
           *
           *
           * <pre>
           * List of object name prefixes. If any prefix exactly matches the
           * beginning of the object name, the condition evaluates to true.
           * </pre>
           *
           * <code>repeated string matches_prefix = 11;</code>
           *
           * @return The count of matchesPrefix.
           */
          public int getMatchesPrefixCount() {
            return matchesPrefix_.size();
          }
          /**
           *
           *
           * <pre>
           * List of object name prefixes. If any prefix exactly matches the
           * beginning of the object name, the condition evaluates to true.
           * </pre>
           *
           * <code>repeated string matches_prefix = 11;</code>
           *
           * @param index The index of the element to return.
           * @return The matchesPrefix at the given index.
           */
          public java.lang.String getMatchesPrefix(int index) {
            return matchesPrefix_.get(index);
          }
          /**
           *
           *
           * <pre>
           * List of object name prefixes. If any prefix exactly matches the
           * beginning of the object name, the condition evaluates to true.
           * </pre>
           *
           * <code>repeated string matches_prefix = 11;</code>
           *
           * @param index The index of the value to return.
           * @return The bytes of the matchesPrefix at the given index.
           */
          public com.google.protobuf.ByteString getMatchesPrefixBytes(int index) {
            return matchesPrefix_.getByteString(index);
          }
          /**
           *
           *
           * <pre>
           * List of object name prefixes. If any prefix exactly matches the
           * beginning of the object name, the condition evaluates to true.
           * </pre>
           *
           * <code>repeated string matches_prefix = 11;</code>
           *
           * @param index The index to set the value at.
           * @param value The matchesPrefix to set.
           * @return This builder for chaining.
           */
          public Builder setMatchesPrefix(int index, java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureMatchesPrefixIsMutable();
            matchesPrefix_.set(index, value);
            bitField0_ |= 0x00000200;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * List of object name prefixes. If any prefix exactly matches the
           * beginning of the object name, the condition evaluates to true.
           * </pre>
           *
           * <code>repeated string matches_prefix = 11;</code>
           *
           * @param value The matchesPrefix to add.
           * @return This builder for chaining.
           */
          public Builder addMatchesPrefix(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureMatchesPrefixIsMutable();
            matchesPrefix_.add(value);
            bitField0_ |= 0x00000200;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * List of object name prefixes. If any prefix exactly matches the
           * beginning of the object name, the condition evaluates to true.
           * </pre>
           *
           * <code>repeated string matches_prefix = 11;</code>
           *
           * @param values The matchesPrefix to add.
           * @return This builder for chaining.
           */
          public Builder addAllMatchesPrefix(java.lang.Iterable<java.lang.String> values) {
            ensureMatchesPrefixIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, matchesPrefix_);
            bitField0_ |= 0x00000200;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * List of object name prefixes. If any prefix exactly matches the
           * beginning of the object name, the condition evaluates to true.
           * </pre>
           *
           * <code>repeated string matches_prefix = 11;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearMatchesPrefix() {
            matchesPrefix_ = com.google.protobuf.LazyStringArrayList.emptyList();
            bitField0_ = (bitField0_ & ~0x00000200);
            ;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * List of object name prefixes. If any prefix exactly matches the
           * beginning of the object name, the condition evaluates to true.
           * </pre>
           *
           * <code>repeated string matches_prefix = 11;</code>
           *
           * @param value The bytes of the matchesPrefix to add.
           * @return This builder for chaining.
           */
          public Builder addMatchesPrefixBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            ensureMatchesPrefixIsMutable();
            matchesPrefix_.add(value);
            bitField0_ |= 0x00000200;
            onChanged();
            return this;
          }

          private com.google.protobuf.LazyStringArrayList matchesSuffix_ =
              com.google.protobuf.LazyStringArrayList.emptyList();

          private void ensureMatchesSuffixIsMutable() {
            if (!matchesSuffix_.isModifiable()) {
              matchesSuffix_ = new com.google.protobuf.LazyStringArrayList(matchesSuffix_);
            }
            bitField0_ |= 0x00000400;
          }
          /**
           *
           *
           * <pre>
           * List of object name suffixes. If any suffix exactly matches the
           * end of the object name, the condition evaluates to true.
           * </pre>
           *
           * <code>repeated string matches_suffix = 12;</code>
           *
           * @return A list containing the matchesSuffix.
           */
          public com.google.protobuf.ProtocolStringList getMatchesSuffixList() {
            matchesSuffix_.makeImmutable();
            return matchesSuffix_;
          }
          /**
           *
           *
           * <pre>
           * List of object name suffixes. If any suffix exactly matches the
           * end of the object name, the condition evaluates to true.
           * </pre>
           *
           * <code>repeated string matches_suffix = 12;</code>
           *
           * @return The count of matchesSuffix.
           */
          public int getMatchesSuffixCount() {
            return matchesSuffix_.size();
          }
          /**
           *
           *
           * <pre>
           * List of object name suffixes. If any suffix exactly matches the
           * end of the object name, the condition evaluates to true.
           * </pre>
           *
           * <code>repeated string matches_suffix = 12;</code>
           *
           * @param index The index of the element to return.
           * @return The matchesSuffix at the given index.
           */
          public java.lang.String getMatchesSuffix(int index) {
            return matchesSuffix_.get(index);
          }
          /**
           *
           *
           * <pre>
           * List of object name suffixes. If any suffix exactly matches the
           * end of the object name, the condition evaluates to true.
           * </pre>
           *
           * <code>repeated string matches_suffix = 12;</code>
           *
           * @param index The index of the value to return.
           * @return The bytes of the matchesSuffix at the given index.
           */
          public com.google.protobuf.ByteString getMatchesSuffixBytes(int index) {
            return matchesSuffix_.getByteString(index);
          }
          /**
           *
           *
           * <pre>
           * List of object name suffixes. If any suffix exactly matches the
           * end of the object name, the condition evaluates to true.
           * </pre>
           *
           * <code>repeated string matches_suffix = 12;</code>
           *
           * @param index The index to set the value at.
           * @param value The matchesSuffix to set.
           * @return This builder for chaining.
           */
          public Builder setMatchesSuffix(int index, java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureMatchesSuffixIsMutable();
            matchesSuffix_.set(index, value);
            bitField0_ |= 0x00000400;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * List of object name suffixes. If any suffix exactly matches the
           * end of the object name, the condition evaluates to true.
           * </pre>
           *
           * <code>repeated string matches_suffix = 12;</code>
           *
           * @param value The matchesSuffix to add.
           * @return This builder for chaining.
           */
          public Builder addMatchesSuffix(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureMatchesSuffixIsMutable();
            matchesSuffix_.add(value);
            bitField0_ |= 0x00000400;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * List of object name suffixes. If any suffix exactly matches the
           * end of the object name, the condition evaluates to true.
           * </pre>
           *
           * <code>repeated string matches_suffix = 12;</code>
           *
           * @param values The matchesSuffix to add.
           * @return This builder for chaining.
           */
          public Builder addAllMatchesSuffix(java.lang.Iterable<java.lang.String> values) {
            ensureMatchesSuffixIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, matchesSuffix_);
            bitField0_ |= 0x00000400;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * List of object name suffixes. If any suffix exactly matches the
           * end of the object name, the condition evaluates to true.
           * </pre>
           *
           * <code>repeated string matches_suffix = 12;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearMatchesSuffix() {
            matchesSuffix_ = com.google.protobuf.LazyStringArrayList.emptyList();
            bitField0_ = (bitField0_ & ~0x00000400);
            ;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * List of object name suffixes. If any suffix exactly matches the
           * end of the object name, the condition evaluates to true.
           * </pre>
           *
           * <code>repeated string matches_suffix = 12;</code>
           *
           * @param value The bytes of the matchesSuffix to add.
           * @return This builder for chaining.
           */
          public Builder addMatchesSuffixBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            ensureMatchesSuffixIsMutable();
            matchesSuffix_.add(value);
            bitField0_ |= 0x00000400;
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.storage.v2.Bucket.Lifecycle.Rule.Condition)
        }

        // @@protoc_insertion_point(class_scope:google.storage.v2.Bucket.Lifecycle.Rule.Condition)
        private static final com.google.storage.v2.Bucket.Lifecycle.Rule.Condition DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE = new com.google.storage.v2.Bucket.Lifecycle.Rule.Condition();
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Condition getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<Condition> PARSER =
            new com.google.protobuf.AbstractParser<Condition>() {
              @java.lang.Override
              public Condition parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<Condition> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<Condition> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.storage.v2.Bucket.Lifecycle.Rule.Condition getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      private int bitField0_;
      public static final int ACTION_FIELD_NUMBER = 1;
      private com.google.storage.v2.Bucket.Lifecycle.Rule.Action action_;
      /**
       *
       *
       * <pre>
       * The action to take.
       * </pre>
       *
       * <code>.google.storage.v2.Bucket.Lifecycle.Rule.Action action = 1;</code>
       *
       * @return Whether the action field is set.
       */
      @java.lang.Override
      public boolean hasAction() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * The action to take.
       * </pre>
       *
       * <code>.google.storage.v2.Bucket.Lifecycle.Rule.Action action = 1;</code>
       *
       * @return The action.
       */
      @java.lang.Override
      public com.google.storage.v2.Bucket.Lifecycle.Rule.Action getAction() {
        return action_ == null
            ? com.google.storage.v2.Bucket.Lifecycle.Rule.Action.getDefaultInstance()
            : action_;
      }
      /**
       *
       *
       * <pre>
       * The action to take.
       * </pre>
       *
       * <code>.google.storage.v2.Bucket.Lifecycle.Rule.Action action = 1;</code>
       */
      @java.lang.Override
      public com.google.storage.v2.Bucket.Lifecycle.Rule.ActionOrBuilder getActionOrBuilder() {
        return action_ == null
            ? com.google.storage.v2.Bucket.Lifecycle.Rule.Action.getDefaultInstance()
            : action_;
      }

      public static final int CONDITION_FIELD_NUMBER = 2;
      private com.google.storage.v2.Bucket.Lifecycle.Rule.Condition condition_;
      /**
       *
       *
       * <pre>
       * The condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>.google.storage.v2.Bucket.Lifecycle.Rule.Condition condition = 2;</code>
       *
       * @return Whether the condition field is set.
       */
      @java.lang.Override
      public boolean hasCondition() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * The condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>.google.storage.v2.Bucket.Lifecycle.Rule.Condition condition = 2;</code>
       *
       * @return The condition.
       */
      @java.lang.Override
      public com.google.storage.v2.Bucket.Lifecycle.Rule.Condition getCondition() {
        return condition_ == null
            ? com.google.storage.v2.Bucket.Lifecycle.Rule.Condition.getDefaultInstance()
            : condition_;
      }
      /**
       *
       *
       * <pre>
       * The condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>.google.storage.v2.Bucket.Lifecycle.Rule.Condition condition = 2;</code>
       */
      @java.lang.Override
      public com.google.storage.v2.Bucket.Lifecycle.Rule.ConditionOrBuilder
          getConditionOrBuilder() {
        return condition_ == null
            ? com.google.storage.v2.Bucket.Lifecycle.Rule.Condition.getDefaultInstance()
            : condition_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(1, getAction());
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          output.writeMessage(2, getCondition());
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getAction());
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCondition());
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.storage.v2.Bucket.Lifecycle.Rule)) {
          return super.equals(obj);
        }
        com.google.storage.v2.Bucket.Lifecycle.Rule other =
            (com.google.storage.v2.Bucket.Lifecycle.Rule) obj;

        if (hasAction() != other.hasAction()) return false;
        if (hasAction()) {
          if (!getAction().equals(other.getAction())) return false;
        }
        if (hasCondition() != other.hasCondition()) return false;
        if (hasCondition()) {
          if (!getCondition().equals(other.getCondition())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasAction()) {
          hash = (37 * hash) + ACTION_FIELD_NUMBER;
          hash = (53 * hash) + getAction().hashCode();
        }
        if (hasCondition()) {
          hash = (37 * hash) + CONDITION_FIELD_NUMBER;
          hash = (53 * hash) + getCondition().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.storage.v2.Bucket.Lifecycle.Rule parseFrom(java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.storage.v2.Bucket.Lifecycle.Rule parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.storage.v2.Bucket.Lifecycle.Rule parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.storage.v2.Bucket.Lifecycle.Rule parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.storage.v2.Bucket.Lifecycle.Rule parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.storage.v2.Bucket.Lifecycle.Rule parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.storage.v2.Bucket.Lifecycle.Rule parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.storage.v2.Bucket.Lifecycle.Rule parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.storage.v2.Bucket.Lifecycle.Rule parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.storage.v2.Bucket.Lifecycle.Rule parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.storage.v2.Bucket.Lifecycle.Rule parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.storage.v2.Bucket.Lifecycle.Rule parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(com.google.storage.v2.Bucket.Lifecycle.Rule prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * A lifecycle Rule, combining an action to take on an object and a
       * condition which will trigger that action.
       * </pre>
       *
       * Protobuf type {@code google.storage.v2.Bucket.Lifecycle.Rule}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.storage.v2.Bucket.Lifecycle.Rule)
          com.google.storage.v2.Bucket.Lifecycle.RuleOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.storage.v2.StorageProto
              .internal_static_google_storage_v2_Bucket_Lifecycle_Rule_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.storage.v2.StorageProto
              .internal_static_google_storage_v2_Bucket_Lifecycle_Rule_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.storage.v2.Bucket.Lifecycle.Rule.class,
                  com.google.storage.v2.Bucket.Lifecycle.Rule.Builder.class);
        }

        // Construct using com.google.storage.v2.Bucket.Lifecycle.Rule.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getActionFieldBuilder();
            getConditionFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          action_ = null;
          if (actionBuilder_ != null) {
            actionBuilder_.dispose();
            actionBuilder_ = null;
          }
          condition_ = null;
          if (conditionBuilder_ != null) {
            conditionBuilder_.dispose();
            conditionBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.storage.v2.StorageProto
              .internal_static_google_storage_v2_Bucket_Lifecycle_Rule_descriptor;
        }

        @java.lang.Override
        public com.google.storage.v2.Bucket.Lifecycle.Rule getDefaultInstanceForType() {
          return com.google.storage.v2.Bucket.Lifecycle.Rule.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.storage.v2.Bucket.Lifecycle.Rule build() {
          com.google.storage.v2.Bucket.Lifecycle.Rule result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.storage.v2.Bucket.Lifecycle.Rule buildPartial() {
          com.google.storage.v2.Bucket.Lifecycle.Rule result =
              new com.google.storage.v2.Bucket.Lifecycle.Rule(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(com.google.storage.v2.Bucket.Lifecycle.Rule result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.action_ = actionBuilder_ == null ? action_ : actionBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.condition_ = conditionBuilder_ == null ? condition_ : conditionBuilder_.build();
            to_bitField0_ |= 0x00000002;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.storage.v2.Bucket.Lifecycle.Rule) {
            return mergeFrom((com.google.storage.v2.Bucket.Lifecycle.Rule) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.storage.v2.Bucket.Lifecycle.Rule other) {
          if (other == com.google.storage.v2.Bucket.Lifecycle.Rule.getDefaultInstance())
            return this;
          if (other.hasAction()) {
            mergeAction(other.getAction());
          }
          if (other.hasCondition()) {
            mergeCondition(other.getCondition());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    input.readMessage(getActionFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    input.readMessage(getConditionFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private com.google.storage.v2.Bucket.Lifecycle.Rule.Action action_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.Bucket.Lifecycle.Rule.Action,
                com.google.storage.v2.Bucket.Lifecycle.Rule.Action.Builder,
                com.google.storage.v2.Bucket.Lifecycle.Rule.ActionOrBuilder>
            actionBuilder_;
        /**
         *
         *
         * <pre>
         * The action to take.
         * </pre>
         *
         * <code>.google.storage.v2.Bucket.Lifecycle.Rule.Action action = 1;</code>
         *
         * @return Whether the action field is set.
         */
        public boolean hasAction() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         *
         *
         * <pre>
         * The action to take.
         * </pre>
         *
         * <code>.google.storage.v2.Bucket.Lifecycle.Rule.Action action = 1;</code>
         *
         * @return The action.
         */
        public com.google.storage.v2.Bucket.Lifecycle.Rule.Action getAction() {
          if (actionBuilder_ == null) {
            return action_ == null
                ? com.google.storage.v2.Bucket.Lifecycle.Rule.Action.getDefaultInstance()
                : action_;
          } else {
            return actionBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * The action to take.
         * </pre>
         *
         * <code>.google.storage.v2.Bucket.Lifecycle.Rule.Action action = 1;</code>
         */
        public Builder setAction(com.google.storage.v2.Bucket.Lifecycle.Rule.Action value) {
          if (actionBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            action_ = value;
          } else {
            actionBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The action to take.
         * </pre>
         *
         * <code>.google.storage.v2.Bucket.Lifecycle.Rule.Action action = 1;</code>
         */
        public Builder setAction(
            com.google.storage.v2.Bucket.Lifecycle.Rule.Action.Builder builderForValue) {
          if (actionBuilder_ == null) {
            action_ = builderForValue.build();
          } else {
            actionBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The action to take.
         * </pre>
         *
         * <code>.google.storage.v2.Bucket.Lifecycle.Rule.Action action = 1;</code>
         */
        public Builder mergeAction(com.google.storage.v2.Bucket.Lifecycle.Rule.Action value) {
          if (actionBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)
                && action_ != null
                && action_
                    != com.google.storage.v2.Bucket.Lifecycle.Rule.Action.getDefaultInstance()) {
              getActionBuilder().mergeFrom(value);
            } else {
              action_ = value;
            }
          } else {
            actionBuilder_.mergeFrom(value);
          }
          if (action_ != null) {
            bitField0_ |= 0x00000001;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The action to take.
         * </pre>
         *
         * <code>.google.storage.v2.Bucket.Lifecycle.Rule.Action action = 1;</code>
         */
        public Builder clearAction() {
          bitField0_ = (bitField0_ & ~0x00000001);
          action_ = null;
          if (actionBuilder_ != null) {
            actionBuilder_.dispose();
            actionBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The action to take.
         * </pre>
         *
         * <code>.google.storage.v2.Bucket.Lifecycle.Rule.Action action = 1;</code>
         */
        public com.google.storage.v2.Bucket.Lifecycle.Rule.Action.Builder getActionBuilder() {
          bitField0_ |= 0x00000001;
          onChanged();
          return getActionFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * The action to take.
         * </pre>
         *
         * <code>.google.storage.v2.Bucket.Lifecycle.Rule.Action action = 1;</code>
         */
        public com.google.storage.v2.Bucket.Lifecycle.Rule.ActionOrBuilder getActionOrBuilder() {
          if (actionBuilder_ != null) {
            return actionBuilder_.getMessageOrBuilder();
          } else {
            return action_ == null
                ? com.google.storage.v2.Bucket.Lifecycle.Rule.Action.getDefaultInstance()
                : action_;
          }
        }
        /**
         *
         *
         * <pre>
         * The action to take.
         * </pre>
         *
         * <code>.google.storage.v2.Bucket.Lifecycle.Rule.Action action = 1;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.Bucket.Lifecycle.Rule.Action,
                com.google.storage.v2.Bucket.Lifecycle.Rule.Action.Builder,
                com.google.storage.v2.Bucket.Lifecycle.Rule.ActionOrBuilder>
            getActionFieldBuilder() {
          if (actionBuilder_ == null) {
            actionBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.storage.v2.Bucket.Lifecycle.Rule.Action,
                    com.google.storage.v2.Bucket.Lifecycle.Rule.Action.Builder,
                    com.google.storage.v2.Bucket.Lifecycle.Rule.ActionOrBuilder>(
                    getAction(), getParentForChildren(), isClean());
            action_ = null;
          }
          return actionBuilder_;
        }

        private com.google.storage.v2.Bucket.Lifecycle.Rule.Condition condition_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.Bucket.Lifecycle.Rule.Condition,
                com.google.storage.v2.Bucket.Lifecycle.Rule.Condition.Builder,
                com.google.storage.v2.Bucket.Lifecycle.Rule.ConditionOrBuilder>
            conditionBuilder_;
        /**
         *
         *
         * <pre>
         * The condition(s) under which the action will be taken.
         * </pre>
         *
         * <code>.google.storage.v2.Bucket.Lifecycle.Rule.Condition condition = 2;</code>
         *
         * @return Whether the condition field is set.
         */
        public boolean hasCondition() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         *
         *
         * <pre>
         * The condition(s) under which the action will be taken.
         * </pre>
         *
         * <code>.google.storage.v2.Bucket.Lifecycle.Rule.Condition condition = 2;</code>
         *
         * @return The condition.
         */
        public com.google.storage.v2.Bucket.Lifecycle.Rule.Condition getCondition() {
          if (conditionBuilder_ == null) {
            return condition_ == null
                ? com.google.storage.v2.Bucket.Lifecycle.Rule.Condition.getDefaultInstance()
                : condition_;
          } else {
            return conditionBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * The condition(s) under which the action will be taken.
         * </pre>
         *
         * <code>.google.storage.v2.Bucket.Lifecycle.Rule.Condition condition = 2;</code>
         */
        public Builder setCondition(com.google.storage.v2.Bucket.Lifecycle.Rule.Condition value) {
          if (conditionBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            condition_ = value;
          } else {
            conditionBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The condition(s) under which the action will be taken.
         * </pre>
         *
         * <code>.google.storage.v2.Bucket.Lifecycle.Rule.Condition condition = 2;</code>
         */
        public Builder setCondition(
            com.google.storage.v2.Bucket.Lifecycle.Rule.Condition.Builder builderForValue) {
          if (conditionBuilder_ == null) {
            condition_ = builderForValue.build();
          } else {
            conditionBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The condition(s) under which the action will be taken.
         * </pre>
         *
         * <code>.google.storage.v2.Bucket.Lifecycle.Rule.Condition condition = 2;</code>
         */
        public Builder mergeCondition(com.google.storage.v2.Bucket.Lifecycle.Rule.Condition value) {
          if (conditionBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0)
                && condition_ != null
                && condition_
                    != com.google.storage.v2.Bucket.Lifecycle.Rule.Condition.getDefaultInstance()) {
              getConditionBuilder().mergeFrom(value);
            } else {
              condition_ = value;
            }
          } else {
            conditionBuilder_.mergeFrom(value);
          }
          if (condition_ != null) {
            bitField0_ |= 0x00000002;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The condition(s) under which the action will be taken.
         * </pre>
         *
         * <code>.google.storage.v2.Bucket.Lifecycle.Rule.Condition condition = 2;</code>
         */
        public Builder clearCondition() {
          bitField0_ = (bitField0_ & ~0x00000002);
          condition_ = null;
          if (conditionBuilder_ != null) {
            conditionBuilder_.dispose();
            conditionBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The condition(s) under which the action will be taken.
         * </pre>
         *
         * <code>.google.storage.v2.Bucket.Lifecycle.Rule.Condition condition = 2;</code>
         */
        public com.google.storage.v2.Bucket.Lifecycle.Rule.Condition.Builder getConditionBuilder() {
          bitField0_ |= 0x00000002;
          onChanged();
          return getConditionFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * The condition(s) under which the action will be taken.
         * </pre>
         *
         * <code>.google.storage.v2.Bucket.Lifecycle.Rule.Condition condition = 2;</code>
         */
        public com.google.storage.v2.Bucket.Lifecycle.Rule.ConditionOrBuilder
            getConditionOrBuilder() {
          if (conditionBuilder_ != null) {
            return conditionBuilder_.getMessageOrBuilder();
          } else {
            return condition_ == null
                ? com.google.storage.v2.Bucket.Lifecycle.Rule.Condition.getDefaultInstance()
                : condition_;
          }
        }
        /**
         *
         *
         * <pre>
         * The condition(s) under which the action will be taken.
         * </pre>
         *
         * <code>.google.storage.v2.Bucket.Lifecycle.Rule.Condition condition = 2;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.Bucket.Lifecycle.Rule.Condition,
                com.google.storage.v2.Bucket.Lifecycle.Rule.Condition.Builder,
                com.google.storage.v2.Bucket.Lifecycle.Rule.ConditionOrBuilder>
            getConditionFieldBuilder() {
          if (conditionBuilder_ == null) {
            conditionBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.storage.v2.Bucket.Lifecycle.Rule.Condition,
                    com.google.storage.v2.Bucket.Lifecycle.Rule.Condition.Builder,
                    com.google.storage.v2.Bucket.Lifecycle.Rule.ConditionOrBuilder>(
                    getCondition(), getParentForChildren(), isClean());
            condition_ = null;
          }
          return conditionBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.storage.v2.Bucket.Lifecycle.Rule)
      }

      // @@protoc_insertion_point(class_scope:google.storage.v2.Bucket.Lifecycle.Rule)
      private static final com.google.storage.v2.Bucket.Lifecycle.Rule DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.storage.v2.Bucket.Lifecycle.Rule();
      }

      public static com.google.storage.v2.Bucket.Lifecycle.Rule getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Rule> PARSER =
          new com.google.protobuf.AbstractParser<Rule>() {
            @java.lang.Override
            public Rule parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Rule> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Rule> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Lifecycle.Rule getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int RULE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<com.google.storage.v2.Bucket.Lifecycle.Rule> rule_;
    /**
     *
     *
     * <pre>
     * A lifecycle management rule, which is made of an action to take and the
     * condition(s) under which the action will be taken.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.storage.v2.Bucket.Lifecycle.Rule> getRuleList() {
      return rule_;
    }
    /**
     *
     *
     * <pre>
     * A lifecycle management rule, which is made of an action to take and the
     * condition(s) under which the action will be taken.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.storage.v2.Bucket.Lifecycle.RuleOrBuilder>
        getRuleOrBuilderList() {
      return rule_;
    }
    /**
     *
     *
     * <pre>
     * A lifecycle management rule, which is made of an action to take and the
     * condition(s) under which the action will be taken.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1;</code>
     */
    @java.lang.Override
    public int getRuleCount() {
      return rule_.size();
    }
    /**
     *
     *
     * <pre>
     * A lifecycle management rule, which is made of an action to take and the
     * condition(s) under which the action will be taken.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1;</code>
     */
    @java.lang.Override
    public com.google.storage.v2.Bucket.Lifecycle.Rule getRule(int index) {
      return rule_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A lifecycle management rule, which is made of an action to take and the
     * condition(s) under which the action will be taken.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1;</code>
     */
    @java.lang.Override
    public com.google.storage.v2.Bucket.Lifecycle.RuleOrBuilder getRuleOrBuilder(int index) {
      return rule_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < rule_.size(); i++) {
        output.writeMessage(1, rule_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < rule_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, rule_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.storage.v2.Bucket.Lifecycle)) {
        return super.equals(obj);
      }
      com.google.storage.v2.Bucket.Lifecycle other = (com.google.storage.v2.Bucket.Lifecycle) obj;

      if (!getRuleList().equals(other.getRuleList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getRuleCount() > 0) {
        hash = (37 * hash) + RULE_FIELD_NUMBER;
        hash = (53 * hash) + getRuleList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storage.v2.Bucket.Lifecycle parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Lifecycle parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Lifecycle parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Lifecycle parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Lifecycle parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Lifecycle parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Lifecycle parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Lifecycle parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Lifecycle parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Lifecycle parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Lifecycle parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Lifecycle parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.storage.v2.Bucket.Lifecycle prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Lifecycle properties of a bucket.
     * For more information, see https://cloud.google.com/storage/docs/lifecycle.
     * </pre>
     *
     * Protobuf type {@code google.storage.v2.Bucket.Lifecycle}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storage.v2.Bucket.Lifecycle)
        com.google.storage.v2.Bucket.LifecycleOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Lifecycle_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Lifecycle_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storage.v2.Bucket.Lifecycle.class,
                com.google.storage.v2.Bucket.Lifecycle.Builder.class);
      }

      // Construct using com.google.storage.v2.Bucket.Lifecycle.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (ruleBuilder_ == null) {
          rule_ = java.util.Collections.emptyList();
        } else {
          rule_ = null;
          ruleBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Lifecycle_descriptor;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Lifecycle getDefaultInstanceForType() {
        return com.google.storage.v2.Bucket.Lifecycle.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Lifecycle build() {
        com.google.storage.v2.Bucket.Lifecycle result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Lifecycle buildPartial() {
        com.google.storage.v2.Bucket.Lifecycle result =
            new com.google.storage.v2.Bucket.Lifecycle(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(com.google.storage.v2.Bucket.Lifecycle result) {
        if (ruleBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            rule_ = java.util.Collections.unmodifiableList(rule_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.rule_ = rule_;
        } else {
          result.rule_ = ruleBuilder_.build();
        }
      }

      private void buildPartial0(com.google.storage.v2.Bucket.Lifecycle result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.storage.v2.Bucket.Lifecycle) {
          return mergeFrom((com.google.storage.v2.Bucket.Lifecycle) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.storage.v2.Bucket.Lifecycle other) {
        if (other == com.google.storage.v2.Bucket.Lifecycle.getDefaultInstance()) return this;
        if (ruleBuilder_ == null) {
          if (!other.rule_.isEmpty()) {
            if (rule_.isEmpty()) {
              rule_ = other.rule_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureRuleIsMutable();
              rule_.addAll(other.rule_);
            }
            onChanged();
          }
        } else {
          if (!other.rule_.isEmpty()) {
            if (ruleBuilder_.isEmpty()) {
              ruleBuilder_.dispose();
              ruleBuilder_ = null;
              rule_ = other.rule_;
              bitField0_ = (bitField0_ & ~0x00000001);
              ruleBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getRuleFieldBuilder()
                      : null;
            } else {
              ruleBuilder_.addAllMessages(other.rule_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.storage.v2.Bucket.Lifecycle.Rule m =
                      input.readMessage(
                          com.google.storage.v2.Bucket.Lifecycle.Rule.parser(), extensionRegistry);
                  if (ruleBuilder_ == null) {
                    ensureRuleIsMutable();
                    rule_.add(m);
                  } else {
                    ruleBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.storage.v2.Bucket.Lifecycle.Rule> rule_ =
          java.util.Collections.emptyList();

      private void ensureRuleIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          rule_ = new java.util.ArrayList<com.google.storage.v2.Bucket.Lifecycle.Rule>(rule_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.storage.v2.Bucket.Lifecycle.Rule,
              com.google.storage.v2.Bucket.Lifecycle.Rule.Builder,
              com.google.storage.v2.Bucket.Lifecycle.RuleOrBuilder>
          ruleBuilder_;

      /**
       *
       *
       * <pre>
       * A lifecycle management rule, which is made of an action to take and the
       * condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1;</code>
       */
      public java.util.List<com.google.storage.v2.Bucket.Lifecycle.Rule> getRuleList() {
        if (ruleBuilder_ == null) {
          return java.util.Collections.unmodifiableList(rule_);
        } else {
          return ruleBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * A lifecycle management rule, which is made of an action to take and the
       * condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1;</code>
       */
      public int getRuleCount() {
        if (ruleBuilder_ == null) {
          return rule_.size();
        } else {
          return ruleBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * A lifecycle management rule, which is made of an action to take and the
       * condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1;</code>
       */
      public com.google.storage.v2.Bucket.Lifecycle.Rule getRule(int index) {
        if (ruleBuilder_ == null) {
          return rule_.get(index);
        } else {
          return ruleBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * A lifecycle management rule, which is made of an action to take and the
       * condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1;</code>
       */
      public Builder setRule(int index, com.google.storage.v2.Bucket.Lifecycle.Rule value) {
        if (ruleBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRuleIsMutable();
          rule_.set(index, value);
          onChanged();
        } else {
          ruleBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A lifecycle management rule, which is made of an action to take and the
       * condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1;</code>
       */
      public Builder setRule(
          int index, com.google.storage.v2.Bucket.Lifecycle.Rule.Builder builderForValue) {
        if (ruleBuilder_ == null) {
          ensureRuleIsMutable();
          rule_.set(index, builderForValue.build());
          onChanged();
        } else {
          ruleBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A lifecycle management rule, which is made of an action to take and the
       * condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1;</code>
       */
      public Builder addRule(com.google.storage.v2.Bucket.Lifecycle.Rule value) {
        if (ruleBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRuleIsMutable();
          rule_.add(value);
          onChanged();
        } else {
          ruleBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A lifecycle management rule, which is made of an action to take and the
       * condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1;</code>
       */
      public Builder addRule(int index, com.google.storage.v2.Bucket.Lifecycle.Rule value) {
        if (ruleBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRuleIsMutable();
          rule_.add(index, value);
          onChanged();
        } else {
          ruleBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A lifecycle management rule, which is made of an action to take and the
       * condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1;</code>
       */
      public Builder addRule(com.google.storage.v2.Bucket.Lifecycle.Rule.Builder builderForValue) {
        if (ruleBuilder_ == null) {
          ensureRuleIsMutable();
          rule_.add(builderForValue.build());
          onChanged();
        } else {
          ruleBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A lifecycle management rule, which is made of an action to take and the
       * condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1;</code>
       */
      public Builder addRule(
          int index, com.google.storage.v2.Bucket.Lifecycle.Rule.Builder builderForValue) {
        if (ruleBuilder_ == null) {
          ensureRuleIsMutable();
          rule_.add(index, builderForValue.build());
          onChanged();
        } else {
          ruleBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A lifecycle management rule, which is made of an action to take and the
       * condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1;</code>
       */
      public Builder addAllRule(
          java.lang.Iterable<? extends com.google.storage.v2.Bucket.Lifecycle.Rule> values) {
        if (ruleBuilder_ == null) {
          ensureRuleIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, rule_);
          onChanged();
        } else {
          ruleBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A lifecycle management rule, which is made of an action to take and the
       * condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1;</code>
       */
      public Builder clearRule() {
        if (ruleBuilder_ == null) {
          rule_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          ruleBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A lifecycle management rule, which is made of an action to take and the
       * condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1;</code>
       */
      public Builder removeRule(int index) {
        if (ruleBuilder_ == null) {
          ensureRuleIsMutable();
          rule_.remove(index);
          onChanged();
        } else {
          ruleBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A lifecycle management rule, which is made of an action to take and the
       * condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1;</code>
       */
      public com.google.storage.v2.Bucket.Lifecycle.Rule.Builder getRuleBuilder(int index) {
        return getRuleFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * A lifecycle management rule, which is made of an action to take and the
       * condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1;</code>
       */
      public com.google.storage.v2.Bucket.Lifecycle.RuleOrBuilder getRuleOrBuilder(int index) {
        if (ruleBuilder_ == null) {
          return rule_.get(index);
        } else {
          return ruleBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * A lifecycle management rule, which is made of an action to take and the
       * condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1;</code>
       */
      public java.util.List<? extends com.google.storage.v2.Bucket.Lifecycle.RuleOrBuilder>
          getRuleOrBuilderList() {
        if (ruleBuilder_ != null) {
          return ruleBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(rule_);
        }
      }
      /**
       *
       *
       * <pre>
       * A lifecycle management rule, which is made of an action to take and the
       * condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1;</code>
       */
      public com.google.storage.v2.Bucket.Lifecycle.Rule.Builder addRuleBuilder() {
        return getRuleFieldBuilder()
            .addBuilder(com.google.storage.v2.Bucket.Lifecycle.Rule.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * A lifecycle management rule, which is made of an action to take and the
       * condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1;</code>
       */
      public com.google.storage.v2.Bucket.Lifecycle.Rule.Builder addRuleBuilder(int index) {
        return getRuleFieldBuilder()
            .addBuilder(index, com.google.storage.v2.Bucket.Lifecycle.Rule.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * A lifecycle management rule, which is made of an action to take and the
       * condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1;</code>
       */
      public java.util.List<com.google.storage.v2.Bucket.Lifecycle.Rule.Builder>
          getRuleBuilderList() {
        return getRuleFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.storage.v2.Bucket.Lifecycle.Rule,
              com.google.storage.v2.Bucket.Lifecycle.Rule.Builder,
              com.google.storage.v2.Bucket.Lifecycle.RuleOrBuilder>
          getRuleFieldBuilder() {
        if (ruleBuilder_ == null) {
          ruleBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.storage.v2.Bucket.Lifecycle.Rule,
                  com.google.storage.v2.Bucket.Lifecycle.Rule.Builder,
                  com.google.storage.v2.Bucket.Lifecycle.RuleOrBuilder>(
                  rule_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
          rule_ = null;
        }
        return ruleBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storage.v2.Bucket.Lifecycle)
    }

    // @@protoc_insertion_point(class_scope:google.storage.v2.Bucket.Lifecycle)
    private static final com.google.storage.v2.Bucket.Lifecycle DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.storage.v2.Bucket.Lifecycle();
    }

    public static com.google.storage.v2.Bucket.Lifecycle getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Lifecycle> PARSER =
        new com.google.protobuf.AbstractParser<Lifecycle>() {
          @java.lang.Override
          public Lifecycle parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Lifecycle> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Lifecycle> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storage.v2.Bucket.Lifecycle getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface LoggingOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storage.v2.Bucket.Logging)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The destination bucket where the current bucket's logs should be placed,
     * using path format (like `projects/123456/buckets/foo`).
     * </pre>
     *
     * <code>string log_bucket = 1;</code>
     *
     * @return The logBucket.
     */
    java.lang.String getLogBucket();
    /**
     *
     *
     * <pre>
     * The destination bucket where the current bucket's logs should be placed,
     * using path format (like `projects/123456/buckets/foo`).
     * </pre>
     *
     * <code>string log_bucket = 1;</code>
     *
     * @return The bytes for logBucket.
     */
    com.google.protobuf.ByteString getLogBucketBytes();

    /**
     *
     *
     * <pre>
     * A prefix for log object names.
     * </pre>
     *
     * <code>string log_object_prefix = 2;</code>
     *
     * @return The logObjectPrefix.
     */
    java.lang.String getLogObjectPrefix();
    /**
     *
     *
     * <pre>
     * A prefix for log object names.
     * </pre>
     *
     * <code>string log_object_prefix = 2;</code>
     *
     * @return The bytes for logObjectPrefix.
     */
    com.google.protobuf.ByteString getLogObjectPrefixBytes();
  }
  /**
   *
   *
   * <pre>
   * Logging-related properties of a bucket.
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.Bucket.Logging}
   */
  public static final class Logging extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storage.v2.Bucket.Logging)
      LoggingOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Logging.newBuilder() to construct.
    private Logging(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Logging() {
      logBucket_ = "";
      logObjectPrefix_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Logging();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_Logging_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_Logging_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.Bucket.Logging.class,
              com.google.storage.v2.Bucket.Logging.Builder.class);
    }

    public static final int LOG_BUCKET_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object logBucket_ = "";
    /**
     *
     *
     * <pre>
     * The destination bucket where the current bucket's logs should be placed,
     * using path format (like `projects/123456/buckets/foo`).
     * </pre>
     *
     * <code>string log_bucket = 1;</code>
     *
     * @return The logBucket.
     */
    @java.lang.Override
    public java.lang.String getLogBucket() {
      java.lang.Object ref = logBucket_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        logBucket_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The destination bucket where the current bucket's logs should be placed,
     * using path format (like `projects/123456/buckets/foo`).
     * </pre>
     *
     * <code>string log_bucket = 1;</code>
     *
     * @return The bytes for logBucket.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getLogBucketBytes() {
      java.lang.Object ref = logBucket_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        logBucket_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int LOG_OBJECT_PREFIX_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object logObjectPrefix_ = "";
    /**
     *
     *
     * <pre>
     * A prefix for log object names.
     * </pre>
     *
     * <code>string log_object_prefix = 2;</code>
     *
     * @return The logObjectPrefix.
     */
    @java.lang.Override
    public java.lang.String getLogObjectPrefix() {
      java.lang.Object ref = logObjectPrefix_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        logObjectPrefix_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * A prefix for log object names.
     * </pre>
     *
     * <code>string log_object_prefix = 2;</code>
     *
     * @return The bytes for logObjectPrefix.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getLogObjectPrefixBytes() {
      java.lang.Object ref = logObjectPrefix_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        logObjectPrefix_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(logBucket_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, logBucket_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(logObjectPrefix_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, logObjectPrefix_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(logBucket_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, logBucket_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(logObjectPrefix_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, logObjectPrefix_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.storage.v2.Bucket.Logging)) {
        return super.equals(obj);
      }
      com.google.storage.v2.Bucket.Logging other = (com.google.storage.v2.Bucket.Logging) obj;

      if (!getLogBucket().equals(other.getLogBucket())) return false;
      if (!getLogObjectPrefix().equals(other.getLogObjectPrefix())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + LOG_BUCKET_FIELD_NUMBER;
      hash = (53 * hash) + getLogBucket().hashCode();
      hash = (37 * hash) + LOG_OBJECT_PREFIX_FIELD_NUMBER;
      hash = (53 * hash) + getLogObjectPrefix().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storage.v2.Bucket.Logging parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Logging parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Logging parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Logging parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Logging parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Logging parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Logging parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Logging parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Logging parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Logging parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Logging parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Logging parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.storage.v2.Bucket.Logging prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Logging-related properties of a bucket.
     * </pre>
     *
     * Protobuf type {@code google.storage.v2.Bucket.Logging}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storage.v2.Bucket.Logging)
        com.google.storage.v2.Bucket.LoggingOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Logging_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Logging_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storage.v2.Bucket.Logging.class,
                com.google.storage.v2.Bucket.Logging.Builder.class);
      }

      // Construct using com.google.storage.v2.Bucket.Logging.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        logBucket_ = "";
        logObjectPrefix_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Logging_descriptor;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Logging getDefaultInstanceForType() {
        return com.google.storage.v2.Bucket.Logging.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Logging build() {
        com.google.storage.v2.Bucket.Logging result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Logging buildPartial() {
        com.google.storage.v2.Bucket.Logging result =
            new com.google.storage.v2.Bucket.Logging(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.storage.v2.Bucket.Logging result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.logBucket_ = logBucket_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.logObjectPrefix_ = logObjectPrefix_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.storage.v2.Bucket.Logging) {
          return mergeFrom((com.google.storage.v2.Bucket.Logging) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.storage.v2.Bucket.Logging other) {
        if (other == com.google.storage.v2.Bucket.Logging.getDefaultInstance()) return this;
        if (!other.getLogBucket().isEmpty()) {
          logBucket_ = other.logBucket_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getLogObjectPrefix().isEmpty()) {
          logObjectPrefix_ = other.logObjectPrefix_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  logBucket_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  logObjectPrefix_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object logBucket_ = "";
      /**
       *
       *
       * <pre>
       * The destination bucket where the current bucket's logs should be placed,
       * using path format (like `projects/123456/buckets/foo`).
       * </pre>
       *
       * <code>string log_bucket = 1;</code>
       *
       * @return The logBucket.
       */
      public java.lang.String getLogBucket() {
        java.lang.Object ref = logBucket_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          logBucket_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The destination bucket where the current bucket's logs should be placed,
       * using path format (like `projects/123456/buckets/foo`).
       * </pre>
       *
       * <code>string log_bucket = 1;</code>
       *
       * @return The bytes for logBucket.
       */
      public com.google.protobuf.ByteString getLogBucketBytes() {
        java.lang.Object ref = logBucket_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          logBucket_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The destination bucket where the current bucket's logs should be placed,
       * using path format (like `projects/123456/buckets/foo`).
       * </pre>
       *
       * <code>string log_bucket = 1;</code>
       *
       * @param value The logBucket to set.
       * @return This builder for chaining.
       */
      public Builder setLogBucket(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        logBucket_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The destination bucket where the current bucket's logs should be placed,
       * using path format (like `projects/123456/buckets/foo`).
       * </pre>
       *
       * <code>string log_bucket = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLogBucket() {
        logBucket_ = getDefaultInstance().getLogBucket();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The destination bucket where the current bucket's logs should be placed,
       * using path format (like `projects/123456/buckets/foo`).
       * </pre>
       *
       * <code>string log_bucket = 1;</code>
       *
       * @param value The bytes for logBucket to set.
       * @return This builder for chaining.
       */
      public Builder setLogBucketBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        logBucket_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object logObjectPrefix_ = "";
      /**
       *
       *
       * <pre>
       * A prefix for log object names.
       * </pre>
       *
       * <code>string log_object_prefix = 2;</code>
       *
       * @return The logObjectPrefix.
       */
      public java.lang.String getLogObjectPrefix() {
        java.lang.Object ref = logObjectPrefix_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          logObjectPrefix_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A prefix for log object names.
       * </pre>
       *
       * <code>string log_object_prefix = 2;</code>
       *
       * @return The bytes for logObjectPrefix.
       */
      public com.google.protobuf.ByteString getLogObjectPrefixBytes() {
        java.lang.Object ref = logObjectPrefix_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          logObjectPrefix_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A prefix for log object names.
       * </pre>
       *
       * <code>string log_object_prefix = 2;</code>
       *
       * @param value The logObjectPrefix to set.
       * @return This builder for chaining.
       */
      public Builder setLogObjectPrefix(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        logObjectPrefix_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A prefix for log object names.
       * </pre>
       *
       * <code>string log_object_prefix = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLogObjectPrefix() {
        logObjectPrefix_ = getDefaultInstance().getLogObjectPrefix();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A prefix for log object names.
       * </pre>
       *
       * <code>string log_object_prefix = 2;</code>
       *
       * @param value The bytes for logObjectPrefix to set.
       * @return This builder for chaining.
       */
      public Builder setLogObjectPrefixBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        logObjectPrefix_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storage.v2.Bucket.Logging)
    }

    // @@protoc_insertion_point(class_scope:google.storage.v2.Bucket.Logging)
    private static final com.google.storage.v2.Bucket.Logging DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.storage.v2.Bucket.Logging();
    }

    public static com.google.storage.v2.Bucket.Logging getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Logging> PARSER =
        new com.google.protobuf.AbstractParser<Logging>() {
          @java.lang.Override
          public Logging parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Logging> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Logging> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storage.v2.Bucket.Logging getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface RetentionPolicyOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storage.v2.Bucket.RetentionPolicy)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Server-determined value that indicates the time from which policy was
     * enforced and effective.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp effective_time = 1;</code>
     *
     * @return Whether the effectiveTime field is set.
     */
    boolean hasEffectiveTime();
    /**
     *
     *
     * <pre>
     * Server-determined value that indicates the time from which policy was
     * enforced and effective.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp effective_time = 1;</code>
     *
     * @return The effectiveTime.
     */
    com.google.protobuf.Timestamp getEffectiveTime();
    /**
     *
     *
     * <pre>
     * Server-determined value that indicates the time from which policy was
     * enforced and effective.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp effective_time = 1;</code>
     */
    com.google.protobuf.TimestampOrBuilder getEffectiveTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * Once locked, an object retention policy cannot be modified.
     * </pre>
     *
     * <code>bool is_locked = 2;</code>
     *
     * @return The isLocked.
     */
    boolean getIsLocked();

    /**
     *
     *
     * <pre>
     * The duration that objects need to be retained. Retention duration must be
     * greater than zero and less than 100 years. Note that enforcement of
     * retention periods less than a day is not guaranteed. Such periods should
     * only be used for testing purposes. Any `nanos` value specified will be
     * rounded down to the nearest second.
     * </pre>
     *
     * <code>.google.protobuf.Duration retention_duration = 4;</code>
     *
     * @return Whether the retentionDuration field is set.
     */
    boolean hasRetentionDuration();
    /**
     *
     *
     * <pre>
     * The duration that objects need to be retained. Retention duration must be
     * greater than zero and less than 100 years. Note that enforcement of
     * retention periods less than a day is not guaranteed. Such periods should
     * only be used for testing purposes. Any `nanos` value specified will be
     * rounded down to the nearest second.
     * </pre>
     *
     * <code>.google.protobuf.Duration retention_duration = 4;</code>
     *
     * @return The retentionDuration.
     */
    com.google.protobuf.Duration getRetentionDuration();
    /**
     *
     *
     * <pre>
     * The duration that objects need to be retained. Retention duration must be
     * greater than zero and less than 100 years. Note that enforcement of
     * retention periods less than a day is not guaranteed. Such periods should
     * only be used for testing purposes. Any `nanos` value specified will be
     * rounded down to the nearest second.
     * </pre>
     *
     * <code>.google.protobuf.Duration retention_duration = 4;</code>
     */
    com.google.protobuf.DurationOrBuilder getRetentionDurationOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Retention policy properties of a bucket.
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.Bucket.RetentionPolicy}
   */
  public static final class RetentionPolicy extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storage.v2.Bucket.RetentionPolicy)
      RetentionPolicyOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use RetentionPolicy.newBuilder() to construct.
    private RetentionPolicy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private RetentionPolicy() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new RetentionPolicy();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_RetentionPolicy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_RetentionPolicy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.Bucket.RetentionPolicy.class,
              com.google.storage.v2.Bucket.RetentionPolicy.Builder.class);
    }

    private int bitField0_;
    public static final int EFFECTIVE_TIME_FIELD_NUMBER = 1;
    private com.google.protobuf.Timestamp effectiveTime_;
    /**
     *
     *
     * <pre>
     * Server-determined value that indicates the time from which policy was
     * enforced and effective.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp effective_time = 1;</code>
     *
     * @return Whether the effectiveTime field is set.
     */
    @java.lang.Override
    public boolean hasEffectiveTime() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Server-determined value that indicates the time from which policy was
     * enforced and effective.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp effective_time = 1;</code>
     *
     * @return The effectiveTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getEffectiveTime() {
      return effectiveTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : effectiveTime_;
    }
    /**
     *
     *
     * <pre>
     * Server-determined value that indicates the time from which policy was
     * enforced and effective.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp effective_time = 1;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getEffectiveTimeOrBuilder() {
      return effectiveTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : effectiveTime_;
    }

    public static final int IS_LOCKED_FIELD_NUMBER = 2;
    private boolean isLocked_ = false;
    /**
     *
     *
     * <pre>
     * Once locked, an object retention policy cannot be modified.
     * </pre>
     *
     * <code>bool is_locked = 2;</code>
     *
     * @return The isLocked.
     */
    @java.lang.Override
    public boolean getIsLocked() {
      return isLocked_;
    }

    public static final int RETENTION_DURATION_FIELD_NUMBER = 4;
    private com.google.protobuf.Duration retentionDuration_;
    /**
     *
     *
     * <pre>
     * The duration that objects need to be retained. Retention duration must be
     * greater than zero and less than 100 years. Note that enforcement of
     * retention periods less than a day is not guaranteed. Such periods should
     * only be used for testing purposes. Any `nanos` value specified will be
     * rounded down to the nearest second.
     * </pre>
     *
     * <code>.google.protobuf.Duration retention_duration = 4;</code>
     *
     * @return Whether the retentionDuration field is set.
     */
    @java.lang.Override
    public boolean hasRetentionDuration() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The duration that objects need to be retained. Retention duration must be
     * greater than zero and less than 100 years. Note that enforcement of
     * retention periods less than a day is not guaranteed. Such periods should
     * only be used for testing purposes. Any `nanos` value specified will be
     * rounded down to the nearest second.
     * </pre>
     *
     * <code>.google.protobuf.Duration retention_duration = 4;</code>
     *
     * @return The retentionDuration.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getRetentionDuration() {
      return retentionDuration_ == null
          ? com.google.protobuf.Duration.getDefaultInstance()
          : retentionDuration_;
    }
    /**
     *
     *
     * <pre>
     * The duration that objects need to be retained. Retention duration must be
     * greater than zero and less than 100 years. Note that enforcement of
     * retention periods less than a day is not guaranteed. Such periods should
     * only be used for testing purposes. Any `nanos` value specified will be
     * rounded down to the nearest second.
     * </pre>
     *
     * <code>.google.protobuf.Duration retention_duration = 4;</code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getRetentionDurationOrBuilder() {
      return retentionDuration_ == null
          ? com.google.protobuf.Duration.getDefaultInstance()
          : retentionDuration_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getEffectiveTime());
      }
      if (isLocked_ != false) {
        output.writeBool(2, isLocked_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(4, getRetentionDuration());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getEffectiveTime());
      }
      if (isLocked_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, isLocked_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getRetentionDuration());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.storage.v2.Bucket.RetentionPolicy)) {
        return super.equals(obj);
      }
      com.google.storage.v2.Bucket.RetentionPolicy other =
          (com.google.storage.v2.Bucket.RetentionPolicy) obj;

      if (hasEffectiveTime() != other.hasEffectiveTime()) return false;
      if (hasEffectiveTime()) {
        if (!getEffectiveTime().equals(other.getEffectiveTime())) return false;
      }
      if (getIsLocked() != other.getIsLocked()) return false;
      if (hasRetentionDuration() != other.hasRetentionDuration()) return false;
      if (hasRetentionDuration()) {
        if (!getRetentionDuration().equals(other.getRetentionDuration())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasEffectiveTime()) {
        hash = (37 * hash) + EFFECTIVE_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getEffectiveTime().hashCode();
      }
      hash = (37 * hash) + IS_LOCKED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIsLocked());
      if (hasRetentionDuration()) {
        hash = (37 * hash) + RETENTION_DURATION_FIELD_NUMBER;
        hash = (53 * hash) + getRetentionDuration().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storage.v2.Bucket.RetentionPolicy parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.RetentionPolicy parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.RetentionPolicy parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.RetentionPolicy parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.RetentionPolicy parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.RetentionPolicy parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.RetentionPolicy parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.RetentionPolicy parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.RetentionPolicy parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.RetentionPolicy parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.RetentionPolicy parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.RetentionPolicy parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.storage.v2.Bucket.RetentionPolicy prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Retention policy properties of a bucket.
     * </pre>
     *
     * Protobuf type {@code google.storage.v2.Bucket.RetentionPolicy}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storage.v2.Bucket.RetentionPolicy)
        com.google.storage.v2.Bucket.RetentionPolicyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_RetentionPolicy_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_RetentionPolicy_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storage.v2.Bucket.RetentionPolicy.class,
                com.google.storage.v2.Bucket.RetentionPolicy.Builder.class);
      }

      // Construct using com.google.storage.v2.Bucket.RetentionPolicy.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getEffectiveTimeFieldBuilder();
          getRetentionDurationFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        effectiveTime_ = null;
        if (effectiveTimeBuilder_ != null) {
          effectiveTimeBuilder_.dispose();
          effectiveTimeBuilder_ = null;
        }
        isLocked_ = false;
        retentionDuration_ = null;
        if (retentionDurationBuilder_ != null) {
          retentionDurationBuilder_.dispose();
          retentionDurationBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_RetentionPolicy_descriptor;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.RetentionPolicy getDefaultInstanceForType() {
        return com.google.storage.v2.Bucket.RetentionPolicy.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.RetentionPolicy build() {
        com.google.storage.v2.Bucket.RetentionPolicy result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.RetentionPolicy buildPartial() {
        com.google.storage.v2.Bucket.RetentionPolicy result =
            new com.google.storage.v2.Bucket.RetentionPolicy(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.storage.v2.Bucket.RetentionPolicy result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.effectiveTime_ =
              effectiveTimeBuilder_ == null ? effectiveTime_ : effectiveTimeBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.isLocked_ = isLocked_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.retentionDuration_ =
              retentionDurationBuilder_ == null
                  ? retentionDuration_
                  : retentionDurationBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.storage.v2.Bucket.RetentionPolicy) {
          return mergeFrom((com.google.storage.v2.Bucket.RetentionPolicy) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.storage.v2.Bucket.RetentionPolicy other) {
        if (other == com.google.storage.v2.Bucket.RetentionPolicy.getDefaultInstance()) return this;
        if (other.hasEffectiveTime()) {
          mergeEffectiveTime(other.getEffectiveTime());
        }
        if (other.getIsLocked() != false) {
          setIsLocked(other.getIsLocked());
        }
        if (other.hasRetentionDuration()) {
          mergeRetentionDuration(other.getRetentionDuration());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getEffectiveTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  isLocked_ = input.readBool();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 34:
                {
                  input.readMessage(
                      getRetentionDurationFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.Timestamp effectiveTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          effectiveTimeBuilder_;
      /**
       *
       *
       * <pre>
       * Server-determined value that indicates the time from which policy was
       * enforced and effective.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp effective_time = 1;</code>
       *
       * @return Whether the effectiveTime field is set.
       */
      public boolean hasEffectiveTime() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Server-determined value that indicates the time from which policy was
       * enforced and effective.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp effective_time = 1;</code>
       *
       * @return The effectiveTime.
       */
      public com.google.protobuf.Timestamp getEffectiveTime() {
        if (effectiveTimeBuilder_ == null) {
          return effectiveTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : effectiveTime_;
        } else {
          return effectiveTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Server-determined value that indicates the time from which policy was
       * enforced and effective.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp effective_time = 1;</code>
       */
      public Builder setEffectiveTime(com.google.protobuf.Timestamp value) {
        if (effectiveTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          effectiveTime_ = value;
        } else {
          effectiveTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Server-determined value that indicates the time from which policy was
       * enforced and effective.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp effective_time = 1;</code>
       */
      public Builder setEffectiveTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (effectiveTimeBuilder_ == null) {
          effectiveTime_ = builderForValue.build();
        } else {
          effectiveTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Server-determined value that indicates the time from which policy was
       * enforced and effective.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp effective_time = 1;</code>
       */
      public Builder mergeEffectiveTime(com.google.protobuf.Timestamp value) {
        if (effectiveTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && effectiveTime_ != null
              && effectiveTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getEffectiveTimeBuilder().mergeFrom(value);
          } else {
            effectiveTime_ = value;
          }
        } else {
          effectiveTimeBuilder_.mergeFrom(value);
        }
        if (effectiveTime_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Server-determined value that indicates the time from which policy was
       * enforced and effective.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp effective_time = 1;</code>
       */
      public Builder clearEffectiveTime() {
        bitField0_ = (bitField0_ & ~0x00000001);
        effectiveTime_ = null;
        if (effectiveTimeBuilder_ != null) {
          effectiveTimeBuilder_.dispose();
          effectiveTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Server-determined value that indicates the time from which policy was
       * enforced and effective.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp effective_time = 1;</code>
       */
      public com.google.protobuf.Timestamp.Builder getEffectiveTimeBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getEffectiveTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Server-determined value that indicates the time from which policy was
       * enforced and effective.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp effective_time = 1;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getEffectiveTimeOrBuilder() {
        if (effectiveTimeBuilder_ != null) {
          return effectiveTimeBuilder_.getMessageOrBuilder();
        } else {
          return effectiveTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : effectiveTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * Server-determined value that indicates the time from which policy was
       * enforced and effective.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp effective_time = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getEffectiveTimeFieldBuilder() {
        if (effectiveTimeBuilder_ == null) {
          effectiveTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getEffectiveTime(), getParentForChildren(), isClean());
          effectiveTime_ = null;
        }
        return effectiveTimeBuilder_;
      }

      private boolean isLocked_;
      /**
       *
       *
       * <pre>
       * Once locked, an object retention policy cannot be modified.
       * </pre>
       *
       * <code>bool is_locked = 2;</code>
       *
       * @return The isLocked.
       */
      @java.lang.Override
      public boolean getIsLocked() {
        return isLocked_;
      }
      /**
       *
       *
       * <pre>
       * Once locked, an object retention policy cannot be modified.
       * </pre>
       *
       * <code>bool is_locked = 2;</code>
       *
       * @param value The isLocked to set.
       * @return This builder for chaining.
       */
      public Builder setIsLocked(boolean value) {

        isLocked_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Once locked, an object retention policy cannot be modified.
       * </pre>
       *
       * <code>bool is_locked = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearIsLocked() {
        bitField0_ = (bitField0_ & ~0x00000002);
        isLocked_ = false;
        onChanged();
        return this;
      }

      private com.google.protobuf.Duration retentionDuration_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          retentionDurationBuilder_;
      /**
       *
       *
       * <pre>
       * The duration that objects need to be retained. Retention duration must be
       * greater than zero and less than 100 years. Note that enforcement of
       * retention periods less than a day is not guaranteed. Such periods should
       * only be used for testing purposes. Any `nanos` value specified will be
       * rounded down to the nearest second.
       * </pre>
       *
       * <code>.google.protobuf.Duration retention_duration = 4;</code>
       *
       * @return Whether the retentionDuration field is set.
       */
      public boolean hasRetentionDuration() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * The duration that objects need to be retained. Retention duration must be
       * greater than zero and less than 100 years. Note that enforcement of
       * retention periods less than a day is not guaranteed. Such periods should
       * only be used for testing purposes. Any `nanos` value specified will be
       * rounded down to the nearest second.
       * </pre>
       *
       * <code>.google.protobuf.Duration retention_duration = 4;</code>
       *
       * @return The retentionDuration.
       */
      public com.google.protobuf.Duration getRetentionDuration() {
        if (retentionDurationBuilder_ == null) {
          return retentionDuration_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : retentionDuration_;
        } else {
          return retentionDurationBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The duration that objects need to be retained. Retention duration must be
       * greater than zero and less than 100 years. Note that enforcement of
       * retention periods less than a day is not guaranteed. Such periods should
       * only be used for testing purposes. Any `nanos` value specified will be
       * rounded down to the nearest second.
       * </pre>
       *
       * <code>.google.protobuf.Duration retention_duration = 4;</code>
       */
      public Builder setRetentionDuration(com.google.protobuf.Duration value) {
        if (retentionDurationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          retentionDuration_ = value;
        } else {
          retentionDurationBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The duration that objects need to be retained. Retention duration must be
       * greater than zero and less than 100 years. Note that enforcement of
       * retention periods less than a day is not guaranteed. Such periods should
       * only be used for testing purposes. Any `nanos` value specified will be
       * rounded down to the nearest second.
       * </pre>
       *
       * <code>.google.protobuf.Duration retention_duration = 4;</code>
       */
      public Builder setRetentionDuration(com.google.protobuf.Duration.Builder builderForValue) {
        if (retentionDurationBuilder_ == null) {
          retentionDuration_ = builderForValue.build();
        } else {
          retentionDurationBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The duration that objects need to be retained. Retention duration must be
       * greater than zero and less than 100 years. Note that enforcement of
       * retention periods less than a day is not guaranteed. Such periods should
       * only be used for testing purposes. Any `nanos` value specified will be
       * rounded down to the nearest second.
       * </pre>
       *
       * <code>.google.protobuf.Duration retention_duration = 4;</code>
       */
      public Builder mergeRetentionDuration(com.google.protobuf.Duration value) {
        if (retentionDurationBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && retentionDuration_ != null
              && retentionDuration_ != com.google.protobuf.Duration.getDefaultInstance()) {
            getRetentionDurationBuilder().mergeFrom(value);
          } else {
            retentionDuration_ = value;
          }
        } else {
          retentionDurationBuilder_.mergeFrom(value);
        }
        if (retentionDuration_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The duration that objects need to be retained. Retention duration must be
       * greater than zero and less than 100 years. Note that enforcement of
       * retention periods less than a day is not guaranteed. Such periods should
       * only be used for testing purposes. Any `nanos` value specified will be
       * rounded down to the nearest second.
       * </pre>
       *
       * <code>.google.protobuf.Duration retention_duration = 4;</code>
       */
      public Builder clearRetentionDuration() {
        bitField0_ = (bitField0_ & ~0x00000004);
        retentionDuration_ = null;
        if (retentionDurationBuilder_ != null) {
          retentionDurationBuilder_.dispose();
          retentionDurationBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The duration that objects need to be retained. Retention duration must be
       * greater than zero and less than 100 years. Note that enforcement of
       * retention periods less than a day is not guaranteed. Such periods should
       * only be used for testing purposes. Any `nanos` value specified will be
       * rounded down to the nearest second.
       * </pre>
       *
       * <code>.google.protobuf.Duration retention_duration = 4;</code>
       */
      public com.google.protobuf.Duration.Builder getRetentionDurationBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getRetentionDurationFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The duration that objects need to be retained. Retention duration must be
       * greater than zero and less than 100 years. Note that enforcement of
       * retention periods less than a day is not guaranteed. Such periods should
       * only be used for testing purposes. Any `nanos` value specified will be
       * rounded down to the nearest second.
       * </pre>
       *
       * <code>.google.protobuf.Duration retention_duration = 4;</code>
       */
      public com.google.protobuf.DurationOrBuilder getRetentionDurationOrBuilder() {
        if (retentionDurationBuilder_ != null) {
          return retentionDurationBuilder_.getMessageOrBuilder();
        } else {
          return retentionDuration_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : retentionDuration_;
        }
      }
      /**
       *
       *
       * <pre>
       * The duration that objects need to be retained. Retention duration must be
       * greater than zero and less than 100 years. Note that enforcement of
       * retention periods less than a day is not guaranteed. Such periods should
       * only be used for testing purposes. Any `nanos` value specified will be
       * rounded down to the nearest second.
       * </pre>
       *
       * <code>.google.protobuf.Duration retention_duration = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          getRetentionDurationFieldBuilder() {
        if (retentionDurationBuilder_ == null) {
          retentionDurationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>(
                  getRetentionDuration(), getParentForChildren(), isClean());
          retentionDuration_ = null;
        }
        return retentionDurationBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storage.v2.Bucket.RetentionPolicy)
    }

    // @@protoc_insertion_point(class_scope:google.storage.v2.Bucket.RetentionPolicy)
    private static final com.google.storage.v2.Bucket.RetentionPolicy DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.storage.v2.Bucket.RetentionPolicy();
    }

    public static com.google.storage.v2.Bucket.RetentionPolicy getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<RetentionPolicy> PARSER =
        new com.google.protobuf.AbstractParser<RetentionPolicy>() {
          @java.lang.Override
          public RetentionPolicy parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<RetentionPolicy> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<RetentionPolicy> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storage.v2.Bucket.RetentionPolicy getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface SoftDeletePolicyOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storage.v2.Bucket.SoftDeletePolicy)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The period of time that soft-deleted objects in the bucket must be
     * retained and cannot be permanently deleted. The duration must be greater
     * than or equal to 7 days and less than 1 year.
     * </pre>
     *
     * <code>optional .google.protobuf.Duration retention_duration = 1;</code>
     *
     * @return Whether the retentionDuration field is set.
     */
    boolean hasRetentionDuration();
    /**
     *
     *
     * <pre>
     * The period of time that soft-deleted objects in the bucket must be
     * retained and cannot be permanently deleted. The duration must be greater
     * than or equal to 7 days and less than 1 year.
     * </pre>
     *
     * <code>optional .google.protobuf.Duration retention_duration = 1;</code>
     *
     * @return The retentionDuration.
     */
    com.google.protobuf.Duration getRetentionDuration();
    /**
     *
     *
     * <pre>
     * The period of time that soft-deleted objects in the bucket must be
     * retained and cannot be permanently deleted. The duration must be greater
     * than or equal to 7 days and less than 1 year.
     * </pre>
     *
     * <code>optional .google.protobuf.Duration retention_duration = 1;</code>
     */
    com.google.protobuf.DurationOrBuilder getRetentionDurationOrBuilder();

    /**
     *
     *
     * <pre>
     * Time from which the policy was effective. This is service-provided.
     * </pre>
     *
     * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
     *
     * @return Whether the effectiveTime field is set.
     */
    boolean hasEffectiveTime();
    /**
     *
     *
     * <pre>
     * Time from which the policy was effective. This is service-provided.
     * </pre>
     *
     * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
     *
     * @return The effectiveTime.
     */
    com.google.protobuf.Timestamp getEffectiveTime();
    /**
     *
     *
     * <pre>
     * Time from which the policy was effective. This is service-provided.
     * </pre>
     *
     * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
     */
    com.google.protobuf.TimestampOrBuilder getEffectiveTimeOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Soft delete policy properties of a bucket.
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.Bucket.SoftDeletePolicy}
   */
  public static final class SoftDeletePolicy extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storage.v2.Bucket.SoftDeletePolicy)
      SoftDeletePolicyOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SoftDeletePolicy.newBuilder() to construct.
    private SoftDeletePolicy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SoftDeletePolicy() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SoftDeletePolicy();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_SoftDeletePolicy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_SoftDeletePolicy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.Bucket.SoftDeletePolicy.class,
              com.google.storage.v2.Bucket.SoftDeletePolicy.Builder.class);
    }

    private int bitField0_;
    public static final int RETENTION_DURATION_FIELD_NUMBER = 1;
    private com.google.protobuf.Duration retentionDuration_;
    /**
     *
     *
     * <pre>
     * The period of time that soft-deleted objects in the bucket must be
     * retained and cannot be permanently deleted. The duration must be greater
     * than or equal to 7 days and less than 1 year.
     * </pre>
     *
     * <code>optional .google.protobuf.Duration retention_duration = 1;</code>
     *
     * @return Whether the retentionDuration field is set.
     */
    @java.lang.Override
    public boolean hasRetentionDuration() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The period of time that soft-deleted objects in the bucket must be
     * retained and cannot be permanently deleted. The duration must be greater
     * than or equal to 7 days and less than 1 year.
     * </pre>
     *
     * <code>optional .google.protobuf.Duration retention_duration = 1;</code>
     *
     * @return The retentionDuration.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getRetentionDuration() {
      return retentionDuration_ == null
          ? com.google.protobuf.Duration.getDefaultInstance()
          : retentionDuration_;
    }
    /**
     *
     *
     * <pre>
     * The period of time that soft-deleted objects in the bucket must be
     * retained and cannot be permanently deleted. The duration must be greater
     * than or equal to 7 days and less than 1 year.
     * </pre>
     *
     * <code>optional .google.protobuf.Duration retention_duration = 1;</code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getRetentionDurationOrBuilder() {
      return retentionDuration_ == null
          ? com.google.protobuf.Duration.getDefaultInstance()
          : retentionDuration_;
    }

    public static final int EFFECTIVE_TIME_FIELD_NUMBER = 2;
    private com.google.protobuf.Timestamp effectiveTime_;
    /**
     *
     *
     * <pre>
     * Time from which the policy was effective. This is service-provided.
     * </pre>
     *
     * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
     *
     * @return Whether the effectiveTime field is set.
     */
    @java.lang.Override
    public boolean hasEffectiveTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Time from which the policy was effective. This is service-provided.
     * </pre>
     *
     * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
     *
     * @return The effectiveTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getEffectiveTime() {
      return effectiveTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : effectiveTime_;
    }
    /**
     *
     *
     * <pre>
     * Time from which the policy was effective. This is service-provided.
     * </pre>
     *
     * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getEffectiveTimeOrBuilder() {
      return effectiveTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : effectiveTime_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getRetentionDuration());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(2, getEffectiveTime());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getRetentionDuration());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getEffectiveTime());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.storage.v2.Bucket.SoftDeletePolicy)) {
        return super.equals(obj);
      }
      com.google.storage.v2.Bucket.SoftDeletePolicy other =
          (com.google.storage.v2.Bucket.SoftDeletePolicy) obj;

      if (hasRetentionDuration() != other.hasRetentionDuration()) return false;
      if (hasRetentionDuration()) {
        if (!getRetentionDuration().equals(other.getRetentionDuration())) return false;
      }
      if (hasEffectiveTime() != other.hasEffectiveTime()) return false;
      if (hasEffectiveTime()) {
        if (!getEffectiveTime().equals(other.getEffectiveTime())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasRetentionDuration()) {
        hash = (37 * hash) + RETENTION_DURATION_FIELD_NUMBER;
        hash = (53 * hash) + getRetentionDuration().hashCode();
      }
      if (hasEffectiveTime()) {
        hash = (37 * hash) + EFFECTIVE_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getEffectiveTime().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storage.v2.Bucket.SoftDeletePolicy parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.SoftDeletePolicy parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.SoftDeletePolicy parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.SoftDeletePolicy parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.SoftDeletePolicy parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.SoftDeletePolicy parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.SoftDeletePolicy parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.SoftDeletePolicy parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.SoftDeletePolicy parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.SoftDeletePolicy parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.SoftDeletePolicy parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.SoftDeletePolicy parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.storage.v2.Bucket.SoftDeletePolicy prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Soft delete policy properties of a bucket.
     * </pre>
     *
     * Protobuf type {@code google.storage.v2.Bucket.SoftDeletePolicy}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storage.v2.Bucket.SoftDeletePolicy)
        com.google.storage.v2.Bucket.SoftDeletePolicyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_SoftDeletePolicy_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_SoftDeletePolicy_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storage.v2.Bucket.SoftDeletePolicy.class,
                com.google.storage.v2.Bucket.SoftDeletePolicy.Builder.class);
      }

      // Construct using com.google.storage.v2.Bucket.SoftDeletePolicy.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getRetentionDurationFieldBuilder();
          getEffectiveTimeFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        retentionDuration_ = null;
        if (retentionDurationBuilder_ != null) {
          retentionDurationBuilder_.dispose();
          retentionDurationBuilder_ = null;
        }
        effectiveTime_ = null;
        if (effectiveTimeBuilder_ != null) {
          effectiveTimeBuilder_.dispose();
          effectiveTimeBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_SoftDeletePolicy_descriptor;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.SoftDeletePolicy getDefaultInstanceForType() {
        return com.google.storage.v2.Bucket.SoftDeletePolicy.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.SoftDeletePolicy build() {
        com.google.storage.v2.Bucket.SoftDeletePolicy result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.SoftDeletePolicy buildPartial() {
        com.google.storage.v2.Bucket.SoftDeletePolicy result =
            new com.google.storage.v2.Bucket.SoftDeletePolicy(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.storage.v2.Bucket.SoftDeletePolicy result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.retentionDuration_ =
              retentionDurationBuilder_ == null
                  ? retentionDuration_
                  : retentionDurationBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.effectiveTime_ =
              effectiveTimeBuilder_ == null ? effectiveTime_ : effectiveTimeBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.storage.v2.Bucket.SoftDeletePolicy) {
          return mergeFrom((com.google.storage.v2.Bucket.SoftDeletePolicy) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.storage.v2.Bucket.SoftDeletePolicy other) {
        if (other == com.google.storage.v2.Bucket.SoftDeletePolicy.getDefaultInstance())
          return this;
        if (other.hasRetentionDuration()) {
          mergeRetentionDuration(other.getRetentionDuration());
        }
        if (other.hasEffectiveTime()) {
          mergeEffectiveTime(other.getEffectiveTime());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getRetentionDurationFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getEffectiveTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.Duration retentionDuration_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          retentionDurationBuilder_;
      /**
       *
       *
       * <pre>
       * The period of time that soft-deleted objects in the bucket must be
       * retained and cannot be permanently deleted. The duration must be greater
       * than or equal to 7 days and less than 1 year.
       * </pre>
       *
       * <code>optional .google.protobuf.Duration retention_duration = 1;</code>
       *
       * @return Whether the retentionDuration field is set.
       */
      public boolean hasRetentionDuration() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * The period of time that soft-deleted objects in the bucket must be
       * retained and cannot be permanently deleted. The duration must be greater
       * than or equal to 7 days and less than 1 year.
       * </pre>
       *
       * <code>optional .google.protobuf.Duration retention_duration = 1;</code>
       *
       * @return The retentionDuration.
       */
      public com.google.protobuf.Duration getRetentionDuration() {
        if (retentionDurationBuilder_ == null) {
          return retentionDuration_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : retentionDuration_;
        } else {
          return retentionDurationBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The period of time that soft-deleted objects in the bucket must be
       * retained and cannot be permanently deleted. The duration must be greater
       * than or equal to 7 days and less than 1 year.
       * </pre>
       *
       * <code>optional .google.protobuf.Duration retention_duration = 1;</code>
       */
      public Builder setRetentionDuration(com.google.protobuf.Duration value) {
        if (retentionDurationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          retentionDuration_ = value;
        } else {
          retentionDurationBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The period of time that soft-deleted objects in the bucket must be
       * retained and cannot be permanently deleted. The duration must be greater
       * than or equal to 7 days and less than 1 year.
       * </pre>
       *
       * <code>optional .google.protobuf.Duration retention_duration = 1;</code>
       */
      public Builder setRetentionDuration(com.google.protobuf.Duration.Builder builderForValue) {
        if (retentionDurationBuilder_ == null) {
          retentionDuration_ = builderForValue.build();
        } else {
          retentionDurationBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The period of time that soft-deleted objects in the bucket must be
       * retained and cannot be permanently deleted. The duration must be greater
       * than or equal to 7 days and less than 1 year.
       * </pre>
       *
       * <code>optional .google.protobuf.Duration retention_duration = 1;</code>
       */
      public Builder mergeRetentionDuration(com.google.protobuf.Duration value) {
        if (retentionDurationBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && retentionDuration_ != null
              && retentionDuration_ != com.google.protobuf.Duration.getDefaultInstance()) {
            getRetentionDurationBuilder().mergeFrom(value);
          } else {
            retentionDuration_ = value;
          }
        } else {
          retentionDurationBuilder_.mergeFrom(value);
        }
        if (retentionDuration_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The period of time that soft-deleted objects in the bucket must be
       * retained and cannot be permanently deleted. The duration must be greater
       * than or equal to 7 days and less than 1 year.
       * </pre>
       *
       * <code>optional .google.protobuf.Duration retention_duration = 1;</code>
       */
      public Builder clearRetentionDuration() {
        bitField0_ = (bitField0_ & ~0x00000001);
        retentionDuration_ = null;
        if (retentionDurationBuilder_ != null) {
          retentionDurationBuilder_.dispose();
          retentionDurationBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The period of time that soft-deleted objects in the bucket must be
       * retained and cannot be permanently deleted. The duration must be greater
       * than or equal to 7 days and less than 1 year.
       * </pre>
       *
       * <code>optional .google.protobuf.Duration retention_duration = 1;</code>
       */
      public com.google.protobuf.Duration.Builder getRetentionDurationBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getRetentionDurationFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The period of time that soft-deleted objects in the bucket must be
       * retained and cannot be permanently deleted. The duration must be greater
       * than or equal to 7 days and less than 1 year.
       * </pre>
       *
       * <code>optional .google.protobuf.Duration retention_duration = 1;</code>
       */
      public com.google.protobuf.DurationOrBuilder getRetentionDurationOrBuilder() {
        if (retentionDurationBuilder_ != null) {
          return retentionDurationBuilder_.getMessageOrBuilder();
        } else {
          return retentionDuration_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : retentionDuration_;
        }
      }
      /**
       *
       *
       * <pre>
       * The period of time that soft-deleted objects in the bucket must be
       * retained and cannot be permanently deleted. The duration must be greater
       * than or equal to 7 days and less than 1 year.
       * </pre>
       *
       * <code>optional .google.protobuf.Duration retention_duration = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          getRetentionDurationFieldBuilder() {
        if (retentionDurationBuilder_ == null) {
          retentionDurationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>(
                  getRetentionDuration(), getParentForChildren(), isClean());
          retentionDuration_ = null;
        }
        return retentionDurationBuilder_;
      }

      private com.google.protobuf.Timestamp effectiveTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          effectiveTimeBuilder_;
      /**
       *
       *
       * <pre>
       * Time from which the policy was effective. This is service-provided.
       * </pre>
       *
       * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
       *
       * @return Whether the effectiveTime field is set.
       */
      public boolean hasEffectiveTime() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Time from which the policy was effective. This is service-provided.
       * </pre>
       *
       * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
       *
       * @return The effectiveTime.
       */
      public com.google.protobuf.Timestamp getEffectiveTime() {
        if (effectiveTimeBuilder_ == null) {
          return effectiveTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : effectiveTime_;
        } else {
          return effectiveTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Time from which the policy was effective. This is service-provided.
       * </pre>
       *
       * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
       */
      public Builder setEffectiveTime(com.google.protobuf.Timestamp value) {
        if (effectiveTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          effectiveTime_ = value;
        } else {
          effectiveTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Time from which the policy was effective. This is service-provided.
       * </pre>
       *
       * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
       */
      public Builder setEffectiveTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (effectiveTimeBuilder_ == null) {
          effectiveTime_ = builderForValue.build();
        } else {
          effectiveTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Time from which the policy was effective. This is service-provided.
       * </pre>
       *
       * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
       */
      public Builder mergeEffectiveTime(com.google.protobuf.Timestamp value) {
        if (effectiveTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && effectiveTime_ != null
              && effectiveTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getEffectiveTimeBuilder().mergeFrom(value);
          } else {
            effectiveTime_ = value;
          }
        } else {
          effectiveTimeBuilder_.mergeFrom(value);
        }
        if (effectiveTime_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Time from which the policy was effective. This is service-provided.
       * </pre>
       *
       * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
       */
      public Builder clearEffectiveTime() {
        bitField0_ = (bitField0_ & ~0x00000002);
        effectiveTime_ = null;
        if (effectiveTimeBuilder_ != null) {
          effectiveTimeBuilder_.dispose();
          effectiveTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Time from which the policy was effective. This is service-provided.
       * </pre>
       *
       * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
       */
      public com.google.protobuf.Timestamp.Builder getEffectiveTimeBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getEffectiveTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Time from which the policy was effective. This is service-provided.
       * </pre>
       *
       * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getEffectiveTimeOrBuilder() {
        if (effectiveTimeBuilder_ != null) {
          return effectiveTimeBuilder_.getMessageOrBuilder();
        } else {
          return effectiveTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : effectiveTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * Time from which the policy was effective. This is service-provided.
       * </pre>
       *
       * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getEffectiveTimeFieldBuilder() {
        if (effectiveTimeBuilder_ == null) {
          effectiveTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getEffectiveTime(), getParentForChildren(), isClean());
          effectiveTime_ = null;
        }
        return effectiveTimeBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storage.v2.Bucket.SoftDeletePolicy)
    }

    // @@protoc_insertion_point(class_scope:google.storage.v2.Bucket.SoftDeletePolicy)
    private static final com.google.storage.v2.Bucket.SoftDeletePolicy DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.storage.v2.Bucket.SoftDeletePolicy();
    }

    public static com.google.storage.v2.Bucket.SoftDeletePolicy getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SoftDeletePolicy> PARSER =
        new com.google.protobuf.AbstractParser<SoftDeletePolicy>() {
          @java.lang.Override
          public SoftDeletePolicy parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SoftDeletePolicy> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SoftDeletePolicy> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storage.v2.Bucket.SoftDeletePolicy getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface VersioningOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storage.v2.Bucket.Versioning)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * While set to true, versioning is fully enabled for this bucket.
     * </pre>
     *
     * <code>bool enabled = 1;</code>
     *
     * @return The enabled.
     */
    boolean getEnabled();
  }
  /**
   *
   *
   * <pre>
   * Properties of a bucket related to versioning.
   * For more on Cloud Storage versioning, see
   * https://cloud.google.com/storage/docs/object-versioning.
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.Bucket.Versioning}
   */
  public static final class Versioning extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storage.v2.Bucket.Versioning)
      VersioningOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Versioning.newBuilder() to construct.
    private Versioning(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Versioning() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Versioning();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_Versioning_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_Versioning_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.Bucket.Versioning.class,
              com.google.storage.v2.Bucket.Versioning.Builder.class);
    }

    public static final int ENABLED_FIELD_NUMBER = 1;
    private boolean enabled_ = false;
    /**
     *
     *
     * <pre>
     * While set to true, versioning is fully enabled for this bucket.
     * </pre>
     *
     * <code>bool enabled = 1;</code>
     *
     * @return The enabled.
     */
    @java.lang.Override
    public boolean getEnabled() {
      return enabled_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (enabled_ != false) {
        output.writeBool(1, enabled_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (enabled_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, enabled_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.storage.v2.Bucket.Versioning)) {
        return super.equals(obj);
      }
      com.google.storage.v2.Bucket.Versioning other = (com.google.storage.v2.Bucket.Versioning) obj;

      if (getEnabled() != other.getEnabled()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ENABLED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnabled());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storage.v2.Bucket.Versioning parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Versioning parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Versioning parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Versioning parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Versioning parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Versioning parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Versioning parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Versioning parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Versioning parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Versioning parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Versioning parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Versioning parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.storage.v2.Bucket.Versioning prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Properties of a bucket related to versioning.
     * For more on Cloud Storage versioning, see
     * https://cloud.google.com/storage/docs/object-versioning.
     * </pre>
     *
     * Protobuf type {@code google.storage.v2.Bucket.Versioning}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storage.v2.Bucket.Versioning)
        com.google.storage.v2.Bucket.VersioningOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Versioning_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Versioning_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storage.v2.Bucket.Versioning.class,
                com.google.storage.v2.Bucket.Versioning.Builder.class);
      }

      // Construct using com.google.storage.v2.Bucket.Versioning.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        enabled_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Versioning_descriptor;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Versioning getDefaultInstanceForType() {
        return com.google.storage.v2.Bucket.Versioning.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Versioning build() {
        com.google.storage.v2.Bucket.Versioning result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Versioning buildPartial() {
        com.google.storage.v2.Bucket.Versioning result =
            new com.google.storage.v2.Bucket.Versioning(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.storage.v2.Bucket.Versioning result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.enabled_ = enabled_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.storage.v2.Bucket.Versioning) {
          return mergeFrom((com.google.storage.v2.Bucket.Versioning) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.storage.v2.Bucket.Versioning other) {
        if (other == com.google.storage.v2.Bucket.Versioning.getDefaultInstance()) return this;
        if (other.getEnabled() != false) {
          setEnabled(other.getEnabled());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  enabled_ = input.readBool();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private boolean enabled_;
      /**
       *
       *
       * <pre>
       * While set to true, versioning is fully enabled for this bucket.
       * </pre>
       *
       * <code>bool enabled = 1;</code>
       *
       * @return The enabled.
       */
      @java.lang.Override
      public boolean getEnabled() {
        return enabled_;
      }
      /**
       *
       *
       * <pre>
       * While set to true, versioning is fully enabled for this bucket.
       * </pre>
       *
       * <code>bool enabled = 1;</code>
       *
       * @param value The enabled to set.
       * @return This builder for chaining.
       */
      public Builder setEnabled(boolean value) {

        enabled_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * While set to true, versioning is fully enabled for this bucket.
       * </pre>
       *
       * <code>bool enabled = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEnabled() {
        bitField0_ = (bitField0_ & ~0x00000001);
        enabled_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storage.v2.Bucket.Versioning)
    }

    // @@protoc_insertion_point(class_scope:google.storage.v2.Bucket.Versioning)
    private static final com.google.storage.v2.Bucket.Versioning DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.storage.v2.Bucket.Versioning();
    }

    public static com.google.storage.v2.Bucket.Versioning getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Versioning> PARSER =
        new com.google.protobuf.AbstractParser<Versioning>() {
          @java.lang.Override
          public Versioning parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Versioning> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Versioning> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storage.v2.Bucket.Versioning getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface WebsiteOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storage.v2.Bucket.Website)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * If the requested object path is missing, the service will ensure the path
     * has a trailing '/', append this suffix, and attempt to retrieve the
     * resulting object. This allows the creation of `index.html`
     * objects to represent directory pages.
     * </pre>
     *
     * <code>string main_page_suffix = 1;</code>
     *
     * @return The mainPageSuffix.
     */
    java.lang.String getMainPageSuffix();
    /**
     *
     *
     * <pre>
     * If the requested object path is missing, the service will ensure the path
     * has a trailing '/', append this suffix, and attempt to retrieve the
     * resulting object. This allows the creation of `index.html`
     * objects to represent directory pages.
     * </pre>
     *
     * <code>string main_page_suffix = 1;</code>
     *
     * @return The bytes for mainPageSuffix.
     */
    com.google.protobuf.ByteString getMainPageSuffixBytes();

    /**
     *
     *
     * <pre>
     * If the requested object path is missing, and any
     * `mainPageSuffix` object is missing, if applicable, the service
     * will return the named object from this bucket as the content for a
     * [https://tools.ietf.org/html/rfc7231#section-6.5.4][404 Not Found]
     * result.
     * </pre>
     *
     * <code>string not_found_page = 2;</code>
     *
     * @return The notFoundPage.
     */
    java.lang.String getNotFoundPage();
    /**
     *
     *
     * <pre>
     * If the requested object path is missing, and any
     * `mainPageSuffix` object is missing, if applicable, the service
     * will return the named object from this bucket as the content for a
     * [https://tools.ietf.org/html/rfc7231#section-6.5.4][404 Not Found]
     * result.
     * </pre>
     *
     * <code>string not_found_page = 2;</code>
     *
     * @return The bytes for notFoundPage.
     */
    com.google.protobuf.ByteString getNotFoundPageBytes();
  }
  /**
   *
   *
   * <pre>
   * Properties of a bucket related to accessing the contents as a static
   * website. For more on hosting a static website via Cloud Storage, see
   * https://cloud.google.com/storage/docs/hosting-static-website.
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.Bucket.Website}
   */
  public static final class Website extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storage.v2.Bucket.Website)
      WebsiteOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Website.newBuilder() to construct.
    private Website(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Website() {
      mainPageSuffix_ = "";
      notFoundPage_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Website();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_Website_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_Website_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.Bucket.Website.class,
              com.google.storage.v2.Bucket.Website.Builder.class);
    }

    public static final int MAIN_PAGE_SUFFIX_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object mainPageSuffix_ = "";
    /**
     *
     *
     * <pre>
     * If the requested object path is missing, the service will ensure the path
     * has a trailing '/', append this suffix, and attempt to retrieve the
     * resulting object. This allows the creation of `index.html`
     * objects to represent directory pages.
     * </pre>
     *
     * <code>string main_page_suffix = 1;</code>
     *
     * @return The mainPageSuffix.
     */
    @java.lang.Override
    public java.lang.String getMainPageSuffix() {
      java.lang.Object ref = mainPageSuffix_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        mainPageSuffix_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * If the requested object path is missing, the service will ensure the path
     * has a trailing '/', append this suffix, and attempt to retrieve the
     * resulting object. This allows the creation of `index.html`
     * objects to represent directory pages.
     * </pre>
     *
     * <code>string main_page_suffix = 1;</code>
     *
     * @return The bytes for mainPageSuffix.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getMainPageSuffixBytes() {
      java.lang.Object ref = mainPageSuffix_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        mainPageSuffix_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int NOT_FOUND_PAGE_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object notFoundPage_ = "";
    /**
     *
     *
     * <pre>
     * If the requested object path is missing, and any
     * `mainPageSuffix` object is missing, if applicable, the service
     * will return the named object from this bucket as the content for a
     * [https://tools.ietf.org/html/rfc7231#section-6.5.4][404 Not Found]
     * result.
     * </pre>
     *
     * <code>string not_found_page = 2;</code>
     *
     * @return The notFoundPage.
     */
    @java.lang.Override
    public java.lang.String getNotFoundPage() {
      java.lang.Object ref = notFoundPage_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        notFoundPage_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * If the requested object path is missing, and any
     * `mainPageSuffix` object is missing, if applicable, the service
     * will return the named object from this bucket as the content for a
     * [https://tools.ietf.org/html/rfc7231#section-6.5.4][404 Not Found]
     * result.
     * </pre>
     *
     * <code>string not_found_page = 2;</code>
     *
     * @return The bytes for notFoundPage.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNotFoundPageBytes() {
      java.lang.Object ref = notFoundPage_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        notFoundPage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(mainPageSuffix_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, mainPageSuffix_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(notFoundPage_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, notFoundPage_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(mainPageSuffix_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, mainPageSuffix_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(notFoundPage_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, notFoundPage_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.storage.v2.Bucket.Website)) {
        return super.equals(obj);
      }
      com.google.storage.v2.Bucket.Website other = (com.google.storage.v2.Bucket.Website) obj;

      if (!getMainPageSuffix().equals(other.getMainPageSuffix())) return false;
      if (!getNotFoundPage().equals(other.getNotFoundPage())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + MAIN_PAGE_SUFFIX_FIELD_NUMBER;
      hash = (53 * hash) + getMainPageSuffix().hashCode();
      hash = (37 * hash) + NOT_FOUND_PAGE_FIELD_NUMBER;
      hash = (53 * hash) + getNotFoundPage().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storage.v2.Bucket.Website parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Website parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Website parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Website parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Website parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Website parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Website parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Website parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Website parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Website parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Website parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Website parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.storage.v2.Bucket.Website prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Properties of a bucket related to accessing the contents as a static
     * website. For more on hosting a static website via Cloud Storage, see
     * https://cloud.google.com/storage/docs/hosting-static-website.
     * </pre>
     *
     * Protobuf type {@code google.storage.v2.Bucket.Website}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storage.v2.Bucket.Website)
        com.google.storage.v2.Bucket.WebsiteOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Website_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Website_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storage.v2.Bucket.Website.class,
                com.google.storage.v2.Bucket.Website.Builder.class);
      }

      // Construct using com.google.storage.v2.Bucket.Website.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        mainPageSuffix_ = "";
        notFoundPage_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Website_descriptor;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Website getDefaultInstanceForType() {
        return com.google.storage.v2.Bucket.Website.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Website build() {
        com.google.storage.v2.Bucket.Website result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Website buildPartial() {
        com.google.storage.v2.Bucket.Website result =
            new com.google.storage.v2.Bucket.Website(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.storage.v2.Bucket.Website result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.mainPageSuffix_ = mainPageSuffix_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.notFoundPage_ = notFoundPage_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.storage.v2.Bucket.Website) {
          return mergeFrom((com.google.storage.v2.Bucket.Website) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.storage.v2.Bucket.Website other) {
        if (other == com.google.storage.v2.Bucket.Website.getDefaultInstance()) return this;
        if (!other.getMainPageSuffix().isEmpty()) {
          mainPageSuffix_ = other.mainPageSuffix_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getNotFoundPage().isEmpty()) {
          notFoundPage_ = other.notFoundPage_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  mainPageSuffix_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  notFoundPage_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object mainPageSuffix_ = "";
      /**
       *
       *
       * <pre>
       * If the requested object path is missing, the service will ensure the path
       * has a trailing '/', append this suffix, and attempt to retrieve the
       * resulting object. This allows the creation of `index.html`
       * objects to represent directory pages.
       * </pre>
       *
       * <code>string main_page_suffix = 1;</code>
       *
       * @return The mainPageSuffix.
       */
      public java.lang.String getMainPageSuffix() {
        java.lang.Object ref = mainPageSuffix_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          mainPageSuffix_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * If the requested object path is missing, the service will ensure the path
       * has a trailing '/', append this suffix, and attempt to retrieve the
       * resulting object. This allows the creation of `index.html`
       * objects to represent directory pages.
       * </pre>
       *
       * <code>string main_page_suffix = 1;</code>
       *
       * @return The bytes for mainPageSuffix.
       */
      public com.google.protobuf.ByteString getMainPageSuffixBytes() {
        java.lang.Object ref = mainPageSuffix_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          mainPageSuffix_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * If the requested object path is missing, the service will ensure the path
       * has a trailing '/', append this suffix, and attempt to retrieve the
       * resulting object. This allows the creation of `index.html`
       * objects to represent directory pages.
       * </pre>
       *
       * <code>string main_page_suffix = 1;</code>
       *
       * @param value The mainPageSuffix to set.
       * @return This builder for chaining.
       */
      public Builder setMainPageSuffix(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        mainPageSuffix_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If the requested object path is missing, the service will ensure the path
       * has a trailing '/', append this suffix, and attempt to retrieve the
       * resulting object. This allows the creation of `index.html`
       * objects to represent directory pages.
       * </pre>
       *
       * <code>string main_page_suffix = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMainPageSuffix() {
        mainPageSuffix_ = getDefaultInstance().getMainPageSuffix();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If the requested object path is missing, the service will ensure the path
       * has a trailing '/', append this suffix, and attempt to retrieve the
       * resulting object. This allows the creation of `index.html`
       * objects to represent directory pages.
       * </pre>
       *
       * <code>string main_page_suffix = 1;</code>
       *
       * @param value The bytes for mainPageSuffix to set.
       * @return This builder for chaining.
       */
      public Builder setMainPageSuffixBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        mainPageSuffix_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object notFoundPage_ = "";
      /**
       *
       *
       * <pre>
       * If the requested object path is missing, and any
       * `mainPageSuffix` object is missing, if applicable, the service
       * will return the named object from this bucket as the content for a
       * [https://tools.ietf.org/html/rfc7231#section-6.5.4][404 Not Found]
       * result.
       * </pre>
       *
       * <code>string not_found_page = 2;</code>
       *
       * @return The notFoundPage.
       */
      public java.lang.String getNotFoundPage() {
        java.lang.Object ref = notFoundPage_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          notFoundPage_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * If the requested object path is missing, and any
       * `mainPageSuffix` object is missing, if applicable, the service
       * will return the named object from this bucket as the content for a
       * [https://tools.ietf.org/html/rfc7231#section-6.5.4][404 Not Found]
       * result.
       * </pre>
       *
       * <code>string not_found_page = 2;</code>
       *
       * @return The bytes for notFoundPage.
       */
      public com.google.protobuf.ByteString getNotFoundPageBytes() {
        java.lang.Object ref = notFoundPage_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          notFoundPage_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * If the requested object path is missing, and any
       * `mainPageSuffix` object is missing, if applicable, the service
       * will return the named object from this bucket as the content for a
       * [https://tools.ietf.org/html/rfc7231#section-6.5.4][404 Not Found]
       * result.
       * </pre>
       *
       * <code>string not_found_page = 2;</code>
       *
       * @param value The notFoundPage to set.
       * @return This builder for chaining.
       */
      public Builder setNotFoundPage(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        notFoundPage_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If the requested object path is missing, and any
       * `mainPageSuffix` object is missing, if applicable, the service
       * will return the named object from this bucket as the content for a
       * [https://tools.ietf.org/html/rfc7231#section-6.5.4][404 Not Found]
       * result.
       * </pre>
       *
       * <code>string not_found_page = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearNotFoundPage() {
        notFoundPage_ = getDefaultInstance().getNotFoundPage();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If the requested object path is missing, and any
       * `mainPageSuffix` object is missing, if applicable, the service
       * will return the named object from this bucket as the content for a
       * [https://tools.ietf.org/html/rfc7231#section-6.5.4][404 Not Found]
       * result.
       * </pre>
       *
       * <code>string not_found_page = 2;</code>
       *
       * @param value The bytes for notFoundPage to set.
       * @return This builder for chaining.
       */
      public Builder setNotFoundPageBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        notFoundPage_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storage.v2.Bucket.Website)
    }

    // @@protoc_insertion_point(class_scope:google.storage.v2.Bucket.Website)
    private static final com.google.storage.v2.Bucket.Website DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.storage.v2.Bucket.Website();
    }

    public static com.google.storage.v2.Bucket.Website getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Website> PARSER =
        new com.google.protobuf.AbstractParser<Website>() {
          @java.lang.Override
          public Website parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Website> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Website> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storage.v2.Bucket.Website getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface CustomPlacementConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storage.v2.Bucket.CustomPlacementConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * List of locations to use for data placement.
     * </pre>
     *
     * <code>repeated string data_locations = 1;</code>
     *
     * @return A list containing the dataLocations.
     */
    java.util.List<java.lang.String> getDataLocationsList();
    /**
     *
     *
     * <pre>
     * List of locations to use for data placement.
     * </pre>
     *
     * <code>repeated string data_locations = 1;</code>
     *
     * @return The count of dataLocations.
     */
    int getDataLocationsCount();
    /**
     *
     *
     * <pre>
     * List of locations to use for data placement.
     * </pre>
     *
     * <code>repeated string data_locations = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The dataLocations at the given index.
     */
    java.lang.String getDataLocations(int index);
    /**
     *
     *
     * <pre>
     * List of locations to use for data placement.
     * </pre>
     *
     * <code>repeated string data_locations = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the dataLocations at the given index.
     */
    com.google.protobuf.ByteString getDataLocationsBytes(int index);
  }
  /**
   *
   *
   * <pre>
   * Configuration for Custom Dual Regions.  It should specify precisely two
   * eligible regions within the same Multiregion. More information on regions
   * may be found [https://cloud.google.com/storage/docs/locations][here].
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.Bucket.CustomPlacementConfig}
   */
  public static final class CustomPlacementConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storage.v2.Bucket.CustomPlacementConfig)
      CustomPlacementConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use CustomPlacementConfig.newBuilder() to construct.
    private CustomPlacementConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private CustomPlacementConfig() {
      dataLocations_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new CustomPlacementConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_CustomPlacementConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_CustomPlacementConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.Bucket.CustomPlacementConfig.class,
              com.google.storage.v2.Bucket.CustomPlacementConfig.Builder.class);
    }

    public static final int DATA_LOCATIONS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList dataLocations_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * List of locations to use for data placement.
     * </pre>
     *
     * <code>repeated string data_locations = 1;</code>
     *
     * @return A list containing the dataLocations.
     */
    public com.google.protobuf.ProtocolStringList getDataLocationsList() {
      return dataLocations_;
    }
    /**
     *
     *
     * <pre>
     * List of locations to use for data placement.
     * </pre>
     *
     * <code>repeated string data_locations = 1;</code>
     *
     * @return The count of dataLocations.
     */
    public int getDataLocationsCount() {
      return dataLocations_.size();
    }
    /**
     *
     *
     * <pre>
     * List of locations to use for data placement.
     * </pre>
     *
     * <code>repeated string data_locations = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The dataLocations at the given index.
     */
    public java.lang.String getDataLocations(int index) {
      return dataLocations_.get(index);
    }
    /**
     *
     *
     * <pre>
     * List of locations to use for data placement.
     * </pre>
     *
     * <code>repeated string data_locations = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the dataLocations at the given index.
     */
    public com.google.protobuf.ByteString getDataLocationsBytes(int index) {
      return dataLocations_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < dataLocations_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, dataLocations_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < dataLocations_.size(); i++) {
          dataSize += computeStringSizeNoTag(dataLocations_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getDataLocationsList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.storage.v2.Bucket.CustomPlacementConfig)) {
        return super.equals(obj);
      }
      com.google.storage.v2.Bucket.CustomPlacementConfig other =
          (com.google.storage.v2.Bucket.CustomPlacementConfig) obj;

      if (!getDataLocationsList().equals(other.getDataLocationsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getDataLocationsCount() > 0) {
        hash = (37 * hash) + DATA_LOCATIONS_FIELD_NUMBER;
        hash = (53 * hash) + getDataLocationsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storage.v2.Bucket.CustomPlacementConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.CustomPlacementConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.CustomPlacementConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.CustomPlacementConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.CustomPlacementConfig parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.CustomPlacementConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.CustomPlacementConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.CustomPlacementConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.CustomPlacementConfig parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.CustomPlacementConfig parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.CustomPlacementConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.CustomPlacementConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.storage.v2.Bucket.CustomPlacementConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Configuration for Custom Dual Regions.  It should specify precisely two
     * eligible regions within the same Multiregion. More information on regions
     * may be found [https://cloud.google.com/storage/docs/locations][here].
     * </pre>
     *
     * Protobuf type {@code google.storage.v2.Bucket.CustomPlacementConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storage.v2.Bucket.CustomPlacementConfig)
        com.google.storage.v2.Bucket.CustomPlacementConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_CustomPlacementConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_CustomPlacementConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storage.v2.Bucket.CustomPlacementConfig.class,
                com.google.storage.v2.Bucket.CustomPlacementConfig.Builder.class);
      }

      // Construct using com.google.storage.v2.Bucket.CustomPlacementConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        dataLocations_ = com.google.protobuf.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_CustomPlacementConfig_descriptor;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.CustomPlacementConfig getDefaultInstanceForType() {
        return com.google.storage.v2.Bucket.CustomPlacementConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.CustomPlacementConfig build() {
        com.google.storage.v2.Bucket.CustomPlacementConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.CustomPlacementConfig buildPartial() {
        com.google.storage.v2.Bucket.CustomPlacementConfig result =
            new com.google.storage.v2.Bucket.CustomPlacementConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.storage.v2.Bucket.CustomPlacementConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          dataLocations_.makeImmutable();
          result.dataLocations_ = dataLocations_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.storage.v2.Bucket.CustomPlacementConfig) {
          return mergeFrom((com.google.storage.v2.Bucket.CustomPlacementConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.storage.v2.Bucket.CustomPlacementConfig other) {
        if (other == com.google.storage.v2.Bucket.CustomPlacementConfig.getDefaultInstance())
          return this;
        if (!other.dataLocations_.isEmpty()) {
          if (dataLocations_.isEmpty()) {
            dataLocations_ = other.dataLocations_;
            bitField0_ |= 0x00000001;
          } else {
            ensureDataLocationsIsMutable();
            dataLocations_.addAll(other.dataLocations_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureDataLocationsIsMutable();
                  dataLocations_.add(s);
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.LazyStringArrayList dataLocations_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureDataLocationsIsMutable() {
        if (!dataLocations_.isModifiable()) {
          dataLocations_ = new com.google.protobuf.LazyStringArrayList(dataLocations_);
        }
        bitField0_ |= 0x00000001;
      }
      /**
       *
       *
       * <pre>
       * List of locations to use for data placement.
       * </pre>
       *
       * <code>repeated string data_locations = 1;</code>
       *
       * @return A list containing the dataLocations.
       */
      public com.google.protobuf.ProtocolStringList getDataLocationsList() {
        dataLocations_.makeImmutable();
        return dataLocations_;
      }
      /**
       *
       *
       * <pre>
       * List of locations to use for data placement.
       * </pre>
       *
       * <code>repeated string data_locations = 1;</code>
       *
       * @return The count of dataLocations.
       */
      public int getDataLocationsCount() {
        return dataLocations_.size();
      }
      /**
       *
       *
       * <pre>
       * List of locations to use for data placement.
       * </pre>
       *
       * <code>repeated string data_locations = 1;</code>
       *
       * @param index The index of the element to return.
       * @return The dataLocations at the given index.
       */
      public java.lang.String getDataLocations(int index) {
        return dataLocations_.get(index);
      }
      /**
       *
       *
       * <pre>
       * List of locations to use for data placement.
       * </pre>
       *
       * <code>repeated string data_locations = 1;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the dataLocations at the given index.
       */
      public com.google.protobuf.ByteString getDataLocationsBytes(int index) {
        return dataLocations_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * List of locations to use for data placement.
       * </pre>
       *
       * <code>repeated string data_locations = 1;</code>
       *
       * @param index The index to set the value at.
       * @param value The dataLocations to set.
       * @return This builder for chaining.
       */
      public Builder setDataLocations(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDataLocationsIsMutable();
        dataLocations_.set(index, value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of locations to use for data placement.
       * </pre>
       *
       * <code>repeated string data_locations = 1;</code>
       *
       * @param value The dataLocations to add.
       * @return This builder for chaining.
       */
      public Builder addDataLocations(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDataLocationsIsMutable();
        dataLocations_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of locations to use for data placement.
       * </pre>
       *
       * <code>repeated string data_locations = 1;</code>
       *
       * @param values The dataLocations to add.
       * @return This builder for chaining.
       */
      public Builder addAllDataLocations(java.lang.Iterable<java.lang.String> values) {
        ensureDataLocationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, dataLocations_);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of locations to use for data placement.
       * </pre>
       *
       * <code>repeated string data_locations = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDataLocations() {
        dataLocations_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of locations to use for data placement.
       * </pre>
       *
       * <code>repeated string data_locations = 1;</code>
       *
       * @param value The bytes of the dataLocations to add.
       * @return This builder for chaining.
       */
      public Builder addDataLocationsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureDataLocationsIsMutable();
        dataLocations_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storage.v2.Bucket.CustomPlacementConfig)
    }

    // @@protoc_insertion_point(class_scope:google.storage.v2.Bucket.CustomPlacementConfig)
    private static final com.google.storage.v2.Bucket.CustomPlacementConfig DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.storage.v2.Bucket.CustomPlacementConfig();
    }

    public static com.google.storage.v2.Bucket.CustomPlacementConfig getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CustomPlacementConfig> PARSER =
        new com.google.protobuf.AbstractParser<CustomPlacementConfig>() {
          @java.lang.Override
          public CustomPlacementConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<CustomPlacementConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CustomPlacementConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storage.v2.Bucket.CustomPlacementConfig getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface AutoclassOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storage.v2.Bucket.Autoclass)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Enables Autoclass.
     * </pre>
     *
     * <code>bool enabled = 1;</code>
     *
     * @return The enabled.
     */
    boolean getEnabled();

    /**
     *
     *
     * <pre>
     * Output only. Latest instant at which the `enabled` field was set to true
     * after being disabled/unconfigured or set to false after being enabled. If
     * Autoclass is enabled when the bucket is created, the toggle_time is set
     * to the bucket creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp toggle_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the toggleTime field is set.
     */
    boolean hasToggleTime();
    /**
     *
     *
     * <pre>
     * Output only. Latest instant at which the `enabled` field was set to true
     * after being disabled/unconfigured or set to false after being enabled. If
     * Autoclass is enabled when the bucket is created, the toggle_time is set
     * to the bucket creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp toggle_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The toggleTime.
     */
    com.google.protobuf.Timestamp getToggleTime();
    /**
     *
     *
     * <pre>
     * Output only. Latest instant at which the `enabled` field was set to true
     * after being disabled/unconfigured or set to false after being enabled. If
     * Autoclass is enabled when the bucket is created, the toggle_time is set
     * to the bucket creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp toggle_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.protobuf.TimestampOrBuilder getToggleTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * An object in an Autoclass bucket will eventually cool down to the
     * terminal storage class if there is no access to the object.
     * The only valid values are NEARLINE and ARCHIVE.
     * </pre>
     *
     * <code>optional string terminal_storage_class = 3;</code>
     *
     * @return Whether the terminalStorageClass field is set.
     */
    boolean hasTerminalStorageClass();
    /**
     *
     *
     * <pre>
     * An object in an Autoclass bucket will eventually cool down to the
     * terminal storage class if there is no access to the object.
     * The only valid values are NEARLINE and ARCHIVE.
     * </pre>
     *
     * <code>optional string terminal_storage_class = 3;</code>
     *
     * @return The terminalStorageClass.
     */
    java.lang.String getTerminalStorageClass();
    /**
     *
     *
     * <pre>
     * An object in an Autoclass bucket will eventually cool down to the
     * terminal storage class if there is no access to the object.
     * The only valid values are NEARLINE and ARCHIVE.
     * </pre>
     *
     * <code>optional string terminal_storage_class = 3;</code>
     *
     * @return The bytes for terminalStorageClass.
     */
    com.google.protobuf.ByteString getTerminalStorageClassBytes();

    /**
     *
     *
     * <pre>
     * Output only. Latest instant at which the autoclass terminal storage class
     * was updated.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Timestamp terminal_storage_class_update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the terminalStorageClassUpdateTime field is set.
     */
    boolean hasTerminalStorageClassUpdateTime();
    /**
     *
     *
     * <pre>
     * Output only. Latest instant at which the autoclass terminal storage class
     * was updated.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Timestamp terminal_storage_class_update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The terminalStorageClassUpdateTime.
     */
    com.google.protobuf.Timestamp getTerminalStorageClassUpdateTime();
    /**
     *
     *
     * <pre>
     * Output only. Latest instant at which the autoclass terminal storage class
     * was updated.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Timestamp terminal_storage_class_update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.protobuf.TimestampOrBuilder getTerminalStorageClassUpdateTimeOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Configuration for a bucket's Autoclass feature.
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.Bucket.Autoclass}
   */
  public static final class Autoclass extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storage.v2.Bucket.Autoclass)
      AutoclassOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Autoclass.newBuilder() to construct.
    private Autoclass(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Autoclass() {
      terminalStorageClass_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Autoclass();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_Autoclass_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_Autoclass_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.Bucket.Autoclass.class,
              com.google.storage.v2.Bucket.Autoclass.Builder.class);
    }

    private int bitField0_;
    public static final int ENABLED_FIELD_NUMBER = 1;
    private boolean enabled_ = false;
    /**
     *
     *
     * <pre>
     * Enables Autoclass.
     * </pre>
     *
     * <code>bool enabled = 1;</code>
     *
     * @return The enabled.
     */
    @java.lang.Override
    public boolean getEnabled() {
      return enabled_;
    }

    public static final int TOGGLE_TIME_FIELD_NUMBER = 2;
    private com.google.protobuf.Timestamp toggleTime_;
    /**
     *
     *
     * <pre>
     * Output only. Latest instant at which the `enabled` field was set to true
     * after being disabled/unconfigured or set to false after being enabled. If
     * Autoclass is enabled when the bucket is created, the toggle_time is set
     * to the bucket creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp toggle_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the toggleTime field is set.
     */
    @java.lang.Override
    public boolean hasToggleTime() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Latest instant at which the `enabled` field was set to true
     * after being disabled/unconfigured or set to false after being enabled. If
     * Autoclass is enabled when the bucket is created, the toggle_time is set
     * to the bucket creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp toggle_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The toggleTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getToggleTime() {
      return toggleTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : toggleTime_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Latest instant at which the `enabled` field was set to true
     * after being disabled/unconfigured or set to false after being enabled. If
     * Autoclass is enabled when the bucket is created, the toggle_time is set
     * to the bucket creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp toggle_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getToggleTimeOrBuilder() {
      return toggleTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : toggleTime_;
    }

    public static final int TERMINAL_STORAGE_CLASS_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object terminalStorageClass_ = "";
    /**
     *
     *
     * <pre>
     * An object in an Autoclass bucket will eventually cool down to the
     * terminal storage class if there is no access to the object.
     * The only valid values are NEARLINE and ARCHIVE.
     * </pre>
     *
     * <code>optional string terminal_storage_class = 3;</code>
     *
     * @return Whether the terminalStorageClass field is set.
     */
    @java.lang.Override
    public boolean hasTerminalStorageClass() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * An object in an Autoclass bucket will eventually cool down to the
     * terminal storage class if there is no access to the object.
     * The only valid values are NEARLINE and ARCHIVE.
     * </pre>
     *
     * <code>optional string terminal_storage_class = 3;</code>
     *
     * @return The terminalStorageClass.
     */
    @java.lang.Override
    public java.lang.String getTerminalStorageClass() {
      java.lang.Object ref = terminalStorageClass_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        terminalStorageClass_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * An object in an Autoclass bucket will eventually cool down to the
     * terminal storage class if there is no access to the object.
     * The only valid values are NEARLINE and ARCHIVE.
     * </pre>
     *
     * <code>optional string terminal_storage_class = 3;</code>
     *
     * @return The bytes for terminalStorageClass.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTerminalStorageClassBytes() {
      java.lang.Object ref = terminalStorageClass_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        terminalStorageClass_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TERMINAL_STORAGE_CLASS_UPDATE_TIME_FIELD_NUMBER = 4;
    private com.google.protobuf.Timestamp terminalStorageClassUpdateTime_;
    /**
     *
     *
     * <pre>
     * Output only. Latest instant at which the autoclass terminal storage class
     * was updated.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Timestamp terminal_storage_class_update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the terminalStorageClassUpdateTime field is set.
     */
    @java.lang.Override
    public boolean hasTerminalStorageClassUpdateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Latest instant at which the autoclass terminal storage class
     * was updated.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Timestamp terminal_storage_class_update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The terminalStorageClassUpdateTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getTerminalStorageClassUpdateTime() {
      return terminalStorageClassUpdateTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : terminalStorageClassUpdateTime_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Latest instant at which the autoclass terminal storage class
     * was updated.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Timestamp terminal_storage_class_update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getTerminalStorageClassUpdateTimeOrBuilder() {
      return terminalStorageClassUpdateTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : terminalStorageClassUpdateTime_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (enabled_ != false) {
        output.writeBool(1, enabled_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getToggleTime());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, terminalStorageClass_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeMessage(4, getTerminalStorageClassUpdateTime());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (enabled_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, enabled_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getToggleTime());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, terminalStorageClass_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                4, getTerminalStorageClassUpdateTime());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.storage.v2.Bucket.Autoclass)) {
        return super.equals(obj);
      }
      com.google.storage.v2.Bucket.Autoclass other = (com.google.storage.v2.Bucket.Autoclass) obj;

      if (getEnabled() != other.getEnabled()) return false;
      if (hasToggleTime() != other.hasToggleTime()) return false;
      if (hasToggleTime()) {
        if (!getToggleTime().equals(other.getToggleTime())) return false;
      }
      if (hasTerminalStorageClass() != other.hasTerminalStorageClass()) return false;
      if (hasTerminalStorageClass()) {
        if (!getTerminalStorageClass().equals(other.getTerminalStorageClass())) return false;
      }
      if (hasTerminalStorageClassUpdateTime() != other.hasTerminalStorageClassUpdateTime())
        return false;
      if (hasTerminalStorageClassUpdateTime()) {
        if (!getTerminalStorageClassUpdateTime().equals(other.getTerminalStorageClassUpdateTime()))
          return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ENABLED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnabled());
      if (hasToggleTime()) {
        hash = (37 * hash) + TOGGLE_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getToggleTime().hashCode();
      }
      if (hasTerminalStorageClass()) {
        hash = (37 * hash) + TERMINAL_STORAGE_CLASS_FIELD_NUMBER;
        hash = (53 * hash) + getTerminalStorageClass().hashCode();
      }
      if (hasTerminalStorageClassUpdateTime()) {
        hash = (37 * hash) + TERMINAL_STORAGE_CLASS_UPDATE_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getTerminalStorageClassUpdateTime().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storage.v2.Bucket.Autoclass parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Autoclass parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Autoclass parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Autoclass parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Autoclass parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Autoclass parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Autoclass parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Autoclass parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Autoclass parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Autoclass parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Autoclass parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Autoclass parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.storage.v2.Bucket.Autoclass prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Configuration for a bucket's Autoclass feature.
     * </pre>
     *
     * Protobuf type {@code google.storage.v2.Bucket.Autoclass}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storage.v2.Bucket.Autoclass)
        com.google.storage.v2.Bucket.AutoclassOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Autoclass_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Autoclass_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storage.v2.Bucket.Autoclass.class,
                com.google.storage.v2.Bucket.Autoclass.Builder.class);
      }

      // Construct using com.google.storage.v2.Bucket.Autoclass.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getToggleTimeFieldBuilder();
          getTerminalStorageClassUpdateTimeFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        enabled_ = false;
        toggleTime_ = null;
        if (toggleTimeBuilder_ != null) {
          toggleTimeBuilder_.dispose();
          toggleTimeBuilder_ = null;
        }
        terminalStorageClass_ = "";
        terminalStorageClassUpdateTime_ = null;
        if (terminalStorageClassUpdateTimeBuilder_ != null) {
          terminalStorageClassUpdateTimeBuilder_.dispose();
          terminalStorageClassUpdateTimeBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Autoclass_descriptor;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Autoclass getDefaultInstanceForType() {
        return com.google.storage.v2.Bucket.Autoclass.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Autoclass build() {
        com.google.storage.v2.Bucket.Autoclass result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Autoclass buildPartial() {
        com.google.storage.v2.Bucket.Autoclass result =
            new com.google.storage.v2.Bucket.Autoclass(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.storage.v2.Bucket.Autoclass result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.enabled_ = enabled_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.toggleTime_ =
              toggleTimeBuilder_ == null ? toggleTime_ : toggleTimeBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.terminalStorageClass_ = terminalStorageClass_;
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.terminalStorageClassUpdateTime_ =
              terminalStorageClassUpdateTimeBuilder_ == null
                  ? terminalStorageClassUpdateTime_
                  : terminalStorageClassUpdateTimeBuilder_.build();
          to_bitField0_ |= 0x00000004;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.storage.v2.Bucket.Autoclass) {
          return mergeFrom((com.google.storage.v2.Bucket.Autoclass) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.storage.v2.Bucket.Autoclass other) {
        if (other == com.google.storage.v2.Bucket.Autoclass.getDefaultInstance()) return this;
        if (other.getEnabled() != false) {
          setEnabled(other.getEnabled());
        }
        if (other.hasToggleTime()) {
          mergeToggleTime(other.getToggleTime());
        }
        if (other.hasTerminalStorageClass()) {
          terminalStorageClass_ = other.terminalStorageClass_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (other.hasTerminalStorageClassUpdateTime()) {
          mergeTerminalStorageClassUpdateTime(other.getTerminalStorageClassUpdateTime());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  enabled_ = input.readBool();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  input.readMessage(getToggleTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  terminalStorageClass_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  input.readMessage(
                      getTerminalStorageClassUpdateTimeFieldBuilder().getBuilder(),
                      extensionRegistry);
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private boolean enabled_;
      /**
       *
       *
       * <pre>
       * Enables Autoclass.
       * </pre>
       *
       * <code>bool enabled = 1;</code>
       *
       * @return The enabled.
       */
      @java.lang.Override
      public boolean getEnabled() {
        return enabled_;
      }
      /**
       *
       *
       * <pre>
       * Enables Autoclass.
       * </pre>
       *
       * <code>bool enabled = 1;</code>
       *
       * @param value The enabled to set.
       * @return This builder for chaining.
       */
      public Builder setEnabled(boolean value) {

        enabled_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Enables Autoclass.
       * </pre>
       *
       * <code>bool enabled = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEnabled() {
        bitField0_ = (bitField0_ & ~0x00000001);
        enabled_ = false;
        onChanged();
        return this;
      }

      private com.google.protobuf.Timestamp toggleTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          toggleTimeBuilder_;
      /**
       *
       *
       * <pre>
       * Output only. Latest instant at which the `enabled` field was set to true
       * after being disabled/unconfigured or set to false after being enabled. If
       * Autoclass is enabled when the bucket is created, the toggle_time is set
       * to the bucket creation time.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp toggle_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return Whether the toggleTime field is set.
       */
      public boolean hasToggleTime() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Output only. Latest instant at which the `enabled` field was set to true
       * after being disabled/unconfigured or set to false after being enabled. If
       * Autoclass is enabled when the bucket is created, the toggle_time is set
       * to the bucket creation time.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp toggle_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The toggleTime.
       */
      public com.google.protobuf.Timestamp getToggleTime() {
        if (toggleTimeBuilder_ == null) {
          return toggleTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : toggleTime_;
        } else {
          return toggleTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Latest instant at which the `enabled` field was set to true
       * after being disabled/unconfigured or set to false after being enabled. If
       * Autoclass is enabled when the bucket is created, the toggle_time is set
       * to the bucket creation time.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp toggle_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setToggleTime(com.google.protobuf.Timestamp value) {
        if (toggleTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          toggleTime_ = value;
        } else {
          toggleTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Latest instant at which the `enabled` field was set to true
       * after being disabled/unconfigured or set to false after being enabled. If
       * Autoclass is enabled when the bucket is created, the toggle_time is set
       * to the bucket creation time.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp toggle_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setToggleTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (toggleTimeBuilder_ == null) {
          toggleTime_ = builderForValue.build();
        } else {
          toggleTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Latest instant at which the `enabled` field was set to true
       * after being disabled/unconfigured or set to false after being enabled. If
       * Autoclass is enabled when the bucket is created, the toggle_time is set
       * to the bucket creation time.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp toggle_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder mergeToggleTime(com.google.protobuf.Timestamp value) {
        if (toggleTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && toggleTime_ != null
              && toggleTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getToggleTimeBuilder().mergeFrom(value);
          } else {
            toggleTime_ = value;
          }
        } else {
          toggleTimeBuilder_.mergeFrom(value);
        }
        if (toggleTime_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Latest instant at which the `enabled` field was set to true
       * after being disabled/unconfigured or set to false after being enabled. If
       * Autoclass is enabled when the bucket is created, the toggle_time is set
       * to the bucket creation time.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp toggle_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder clearToggleTime() {
        bitField0_ = (bitField0_ & ~0x00000002);
        toggleTime_ = null;
        if (toggleTimeBuilder_ != null) {
          toggleTimeBuilder_.dispose();
          toggleTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Latest instant at which the `enabled` field was set to true
       * after being disabled/unconfigured or set to false after being enabled. If
       * Autoclass is enabled when the bucket is created, the toggle_time is set
       * to the bucket creation time.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp toggle_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.protobuf.Timestamp.Builder getToggleTimeBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getToggleTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Output only. Latest instant at which the `enabled` field was set to true
       * after being disabled/unconfigured or set to false after being enabled. If
       * Autoclass is enabled when the bucket is created, the toggle_time is set
       * to the bucket creation time.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp toggle_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.protobuf.TimestampOrBuilder getToggleTimeOrBuilder() {
        if (toggleTimeBuilder_ != null) {
          return toggleTimeBuilder_.getMessageOrBuilder();
        } else {
          return toggleTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : toggleTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Latest instant at which the `enabled` field was set to true
       * after being disabled/unconfigured or set to false after being enabled. If
       * Autoclass is enabled when the bucket is created, the toggle_time is set
       * to the bucket creation time.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp toggle_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getToggleTimeFieldBuilder() {
        if (toggleTimeBuilder_ == null) {
          toggleTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getToggleTime(), getParentForChildren(), isClean());
          toggleTime_ = null;
        }
        return toggleTimeBuilder_;
      }

      private java.lang.Object terminalStorageClass_ = "";
      /**
       *
       *
       * <pre>
       * An object in an Autoclass bucket will eventually cool down to the
       * terminal storage class if there is no access to the object.
       * The only valid values are NEARLINE and ARCHIVE.
       * </pre>
       *
       * <code>optional string terminal_storage_class = 3;</code>
       *
       * @return Whether the terminalStorageClass field is set.
       */
      public boolean hasTerminalStorageClass() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * An object in an Autoclass bucket will eventually cool down to the
       * terminal storage class if there is no access to the object.
       * The only valid values are NEARLINE and ARCHIVE.
       * </pre>
       *
       * <code>optional string terminal_storage_class = 3;</code>
       *
       * @return The terminalStorageClass.
       */
      public java.lang.String getTerminalStorageClass() {
        java.lang.Object ref = terminalStorageClass_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          terminalStorageClass_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * An object in an Autoclass bucket will eventually cool down to the
       * terminal storage class if there is no access to the object.
       * The only valid values are NEARLINE and ARCHIVE.
       * </pre>
       *
       * <code>optional string terminal_storage_class = 3;</code>
       *
       * @return The bytes for terminalStorageClass.
       */
      public com.google.protobuf.ByteString getTerminalStorageClassBytes() {
        java.lang.Object ref = terminalStorageClass_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          terminalStorageClass_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * An object in an Autoclass bucket will eventually cool down to the
       * terminal storage class if there is no access to the object.
       * The only valid values are NEARLINE and ARCHIVE.
       * </pre>
       *
       * <code>optional string terminal_storage_class = 3;</code>
       *
       * @param value The terminalStorageClass to set.
       * @return This builder for chaining.
       */
      public Builder setTerminalStorageClass(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        terminalStorageClass_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * An object in an Autoclass bucket will eventually cool down to the
       * terminal storage class if there is no access to the object.
       * The only valid values are NEARLINE and ARCHIVE.
       * </pre>
       *
       * <code>optional string terminal_storage_class = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTerminalStorageClass() {
        terminalStorageClass_ = getDefaultInstance().getTerminalStorageClass();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * An object in an Autoclass bucket will eventually cool down to the
       * terminal storage class if there is no access to the object.
       * The only valid values are NEARLINE and ARCHIVE.
       * </pre>
       *
       * <code>optional string terminal_storage_class = 3;</code>
       *
       * @param value The bytes for terminalStorageClass to set.
       * @return This builder for chaining.
       */
      public Builder setTerminalStorageClassBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        terminalStorageClass_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private com.google.protobuf.Timestamp terminalStorageClassUpdateTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          terminalStorageClassUpdateTimeBuilder_;
      /**
       *
       *
       * <pre>
       * Output only. Latest instant at which the autoclass terminal storage class
       * was updated.
       * </pre>
       *
       * <code>
       * optional .google.protobuf.Timestamp terminal_storage_class_update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return Whether the terminalStorageClassUpdateTime field is set.
       */
      public boolean hasTerminalStorageClassUpdateTime() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       *
       *
       * <pre>
       * Output only. Latest instant at which the autoclass terminal storage class
       * was updated.
       * </pre>
       *
       * <code>
       * optional .google.protobuf.Timestamp terminal_storage_class_update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The terminalStorageClassUpdateTime.
       */
      public com.google.protobuf.Timestamp getTerminalStorageClassUpdateTime() {
        if (terminalStorageClassUpdateTimeBuilder_ == null) {
          return terminalStorageClassUpdateTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : terminalStorageClassUpdateTime_;
        } else {
          return terminalStorageClassUpdateTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Latest instant at which the autoclass terminal storage class
       * was updated.
       * </pre>
       *
       * <code>
       * optional .google.protobuf.Timestamp terminal_storage_class_update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setTerminalStorageClassUpdateTime(com.google.protobuf.Timestamp value) {
        if (terminalStorageClassUpdateTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          terminalStorageClassUpdateTime_ = value;
        } else {
          terminalStorageClassUpdateTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Latest instant at which the autoclass terminal storage class
       * was updated.
       * </pre>
       *
       * <code>
       * optional .google.protobuf.Timestamp terminal_storage_class_update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setTerminalStorageClassUpdateTime(
          com.google.protobuf.Timestamp.Builder builderForValue) {
        if (terminalStorageClassUpdateTimeBuilder_ == null) {
          terminalStorageClassUpdateTime_ = builderForValue.build();
        } else {
          terminalStorageClassUpdateTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Latest instant at which the autoclass terminal storage class
       * was updated.
       * </pre>
       *
       * <code>
       * optional .google.protobuf.Timestamp terminal_storage_class_update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder mergeTerminalStorageClassUpdateTime(com.google.protobuf.Timestamp value) {
        if (terminalStorageClassUpdateTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)
              && terminalStorageClassUpdateTime_ != null
              && terminalStorageClassUpdateTime_
                  != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getTerminalStorageClassUpdateTimeBuilder().mergeFrom(value);
          } else {
            terminalStorageClassUpdateTime_ = value;
          }
        } else {
          terminalStorageClassUpdateTimeBuilder_.mergeFrom(value);
        }
        if (terminalStorageClassUpdateTime_ != null) {
          bitField0_ |= 0x00000008;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Latest instant at which the autoclass terminal storage class
       * was updated.
       * </pre>
       *
       * <code>
       * optional .google.protobuf.Timestamp terminal_storage_class_update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder clearTerminalStorageClassUpdateTime() {
        bitField0_ = (bitField0_ & ~0x00000008);
        terminalStorageClassUpdateTime_ = null;
        if (terminalStorageClassUpdateTimeBuilder_ != null) {
          terminalStorageClassUpdateTimeBuilder_.dispose();
          terminalStorageClassUpdateTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Latest instant at which the autoclass terminal storage class
       * was updated.
       * </pre>
       *
       * <code>
       * optional .google.protobuf.Timestamp terminal_storage_class_update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.protobuf.Timestamp.Builder getTerminalStorageClassUpdateTimeBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getTerminalStorageClassUpdateTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Output only. Latest instant at which the autoclass terminal storage class
       * was updated.
       * </pre>
       *
       * <code>
       * optional .google.protobuf.Timestamp terminal_storage_class_update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.protobuf.TimestampOrBuilder getTerminalStorageClassUpdateTimeOrBuilder() {
        if (terminalStorageClassUpdateTimeBuilder_ != null) {
          return terminalStorageClassUpdateTimeBuilder_.getMessageOrBuilder();
        } else {
          return terminalStorageClassUpdateTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : terminalStorageClassUpdateTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Latest instant at which the autoclass terminal storage class
       * was updated.
       * </pre>
       *
       * <code>
       * optional .google.protobuf.Timestamp terminal_storage_class_update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getTerminalStorageClassUpdateTimeFieldBuilder() {
        if (terminalStorageClassUpdateTimeBuilder_ == null) {
          terminalStorageClassUpdateTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getTerminalStorageClassUpdateTime(), getParentForChildren(), isClean());
          terminalStorageClassUpdateTime_ = null;
        }
        return terminalStorageClassUpdateTimeBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storage.v2.Bucket.Autoclass)
    }

    // @@protoc_insertion_point(class_scope:google.storage.v2.Bucket.Autoclass)
    private static final com.google.storage.v2.Bucket.Autoclass DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.storage.v2.Bucket.Autoclass();
    }

    public static com.google.storage.v2.Bucket.Autoclass getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Autoclass> PARSER =
        new com.google.protobuf.AbstractParser<Autoclass>() {
          @java.lang.Override
          public Autoclass parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Autoclass> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Autoclass> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storage.v2.Bucket.Autoclass getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface HierarchicalNamespaceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storage.v2.Bucket.HierarchicalNamespace)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. Enables the hierarchical namespace feature.
     * </pre>
     *
     * <code>bool enabled = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The enabled.
     */
    boolean getEnabled();
  }
  /**
   *
   *
   * <pre>
   * Configuration for a bucket's hierarchical namespace feature.
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.Bucket.HierarchicalNamespace}
   */
  public static final class HierarchicalNamespace extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storage.v2.Bucket.HierarchicalNamespace)
      HierarchicalNamespaceOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use HierarchicalNamespace.newBuilder() to construct.
    private HierarchicalNamespace(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private HierarchicalNamespace() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new HierarchicalNamespace();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_HierarchicalNamespace_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_HierarchicalNamespace_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.Bucket.HierarchicalNamespace.class,
              com.google.storage.v2.Bucket.HierarchicalNamespace.Builder.class);
    }

    public static final int ENABLED_FIELD_NUMBER = 1;
    private boolean enabled_ = false;
    /**
     *
     *
     * <pre>
     * Optional. Enables the hierarchical namespace feature.
     * </pre>
     *
     * <code>bool enabled = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The enabled.
     */
    @java.lang.Override
    public boolean getEnabled() {
      return enabled_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (enabled_ != false) {
        output.writeBool(1, enabled_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (enabled_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, enabled_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.storage.v2.Bucket.HierarchicalNamespace)) {
        return super.equals(obj);
      }
      com.google.storage.v2.Bucket.HierarchicalNamespace other =
          (com.google.storage.v2.Bucket.HierarchicalNamespace) obj;

      if (getEnabled() != other.getEnabled()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ENABLED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnabled());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storage.v2.Bucket.HierarchicalNamespace parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.HierarchicalNamespace parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.HierarchicalNamespace parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.HierarchicalNamespace parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.HierarchicalNamespace parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.HierarchicalNamespace parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.HierarchicalNamespace parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.HierarchicalNamespace parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.HierarchicalNamespace parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.HierarchicalNamespace parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.HierarchicalNamespace parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.HierarchicalNamespace parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.storage.v2.Bucket.HierarchicalNamespace prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Configuration for a bucket's hierarchical namespace feature.
     * </pre>
     *
     * Protobuf type {@code google.storage.v2.Bucket.HierarchicalNamespace}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storage.v2.Bucket.HierarchicalNamespace)
        com.google.storage.v2.Bucket.HierarchicalNamespaceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_HierarchicalNamespace_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_HierarchicalNamespace_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storage.v2.Bucket.HierarchicalNamespace.class,
                com.google.storage.v2.Bucket.HierarchicalNamespace.Builder.class);
      }

      // Construct using com.google.storage.v2.Bucket.HierarchicalNamespace.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        enabled_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_HierarchicalNamespace_descriptor;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.HierarchicalNamespace getDefaultInstanceForType() {
        return com.google.storage.v2.Bucket.HierarchicalNamespace.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.HierarchicalNamespace build() {
        com.google.storage.v2.Bucket.HierarchicalNamespace result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.HierarchicalNamespace buildPartial() {
        com.google.storage.v2.Bucket.HierarchicalNamespace result =
            new com.google.storage.v2.Bucket.HierarchicalNamespace(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.storage.v2.Bucket.HierarchicalNamespace result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.enabled_ = enabled_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.storage.v2.Bucket.HierarchicalNamespace) {
          return mergeFrom((com.google.storage.v2.Bucket.HierarchicalNamespace) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.storage.v2.Bucket.HierarchicalNamespace other) {
        if (other == com.google.storage.v2.Bucket.HierarchicalNamespace.getDefaultInstance())
          return this;
        if (other.getEnabled() != false) {
          setEnabled(other.getEnabled());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  enabled_ = input.readBool();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private boolean enabled_;
      /**
       *
       *
       * <pre>
       * Optional. Enables the hierarchical namespace feature.
       * </pre>
       *
       * <code>bool enabled = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The enabled.
       */
      @java.lang.Override
      public boolean getEnabled() {
        return enabled_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Enables the hierarchical namespace feature.
       * </pre>
       *
       * <code>bool enabled = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The enabled to set.
       * @return This builder for chaining.
       */
      public Builder setEnabled(boolean value) {

        enabled_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Enables the hierarchical namespace feature.
       * </pre>
       *
       * <code>bool enabled = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEnabled() {
        bitField0_ = (bitField0_ & ~0x00000001);
        enabled_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storage.v2.Bucket.HierarchicalNamespace)
    }

    // @@protoc_insertion_point(class_scope:google.storage.v2.Bucket.HierarchicalNamespace)
    private static final com.google.storage.v2.Bucket.HierarchicalNamespace DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.storage.v2.Bucket.HierarchicalNamespace();
    }

    public static com.google.storage.v2.Bucket.HierarchicalNamespace getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<HierarchicalNamespace> PARSER =
        new com.google.protobuf.AbstractParser<HierarchicalNamespace>() {
          @java.lang.Override
          public HierarchicalNamespace parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<HierarchicalNamespace> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<HierarchicalNamespace> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storage.v2.Bucket.HierarchicalNamespace getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Immutable. The name of the bucket.
   * Format: `projects/{project}/buckets/{bucket}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. The name of the bucket.
   * Format: `projects/{project}/buckets/{bucket}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BUCKET_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object bucketId_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The user-chosen part of the bucket name. The `{bucket}`
   * portion of the `name` field. For globally unique buckets, this is equal to
   * the "bucket name" of other Cloud Storage APIs. Example: "pub".
   * </pre>
   *
   * <code>string bucket_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bucketId.
   */
  @java.lang.Override
  public java.lang.String getBucketId() {
    java.lang.Object ref = bucketId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      bucketId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The user-chosen part of the bucket name. The `{bucket}`
   * portion of the `name` field. For globally unique buckets, this is equal to
   * the "bucket name" of other Cloud Storage APIs. Example: "pub".
   * </pre>
   *
   * <code>string bucket_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for bucketId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBucketIdBytes() {
    java.lang.Object ref = bucketId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      bucketId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ETAG_FIELD_NUMBER = 29;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";
  /**
   *
   *
   * <pre>
   * The etag of the bucket.
   * If included in the metadata of an UpdateBucketRequest, the operation will
   * only be performed if the etag matches that of the bucket.
   * </pre>
   *
   * <code>string etag = 29;</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The etag of the bucket.
   * If included in the metadata of an UpdateBucketRequest, the operation will
   * only be performed if the etag matches that of the bucket.
   * </pre>
   *
   * <code>string etag = 29;</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PROJECT_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object project_ = "";
  /**
   *
   *
   * <pre>
   * Immutable. The project which owns this bucket, in the format of
   * "projects/{projectIdentifier}".
   * {projectIdentifier} can be the project ID or project number.
   * </pre>
   *
   * <code>
   * string project = 3 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The project.
   */
  @java.lang.Override
  public java.lang.String getProject() {
    java.lang.Object ref = project_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      project_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. The project which owns this bucket, in the format of
   * "projects/{projectIdentifier}".
   * {projectIdentifier} can be the project ID or project number.
   * </pre>
   *
   * <code>
   * string project = 3 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for project.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProjectBytes() {
    java.lang.Object ref = project_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      project_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int METAGENERATION_FIELD_NUMBER = 4;
  private long metageneration_ = 0L;
  /**
   *
   *
   * <pre>
   * Output only. The metadata generation of this bucket.
   * </pre>
   *
   * <code>int64 metageneration = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The metageneration.
   */
  @java.lang.Override
  public long getMetageneration() {
    return metageneration_;
  }

  public static final int LOCATION_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object location_ = "";
  /**
   *
   *
   * <pre>
   * Immutable. The location of the bucket. Object data for objects in the
   * bucket resides in physical storage within this region.  Defaults to `US`.
   * See the
   * [https://developers.google.com/storage/docs/concepts-techniques#specifyinglocations"][developer's
   * guide] for the authoritative list. Attempting to update this field after
   * the bucket is created will result in an error.
   * </pre>
   *
   * <code>string location = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The location.
   */
  @java.lang.Override
  public java.lang.String getLocation() {
    java.lang.Object ref = location_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      location_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. The location of the bucket. Object data for objects in the
   * bucket resides in physical storage within this region.  Defaults to `US`.
   * See the
   * [https://developers.google.com/storage/docs/concepts-techniques#specifyinglocations"][developer's
   * guide] for the authoritative list. Attempting to update this field after
   * the bucket is created will result in an error.
   * </pre>
   *
   * <code>string location = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for location.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLocationBytes() {
    java.lang.Object ref = location_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      location_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LOCATION_TYPE_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object locationType_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The location type of the bucket (region, dual-region,
   * multi-region, etc).
   * </pre>
   *
   * <code>string location_type = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The locationType.
   */
  @java.lang.Override
  public java.lang.String getLocationType() {
    java.lang.Object ref = locationType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      locationType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The location type of the bucket (region, dual-region,
   * multi-region, etc).
   * </pre>
   *
   * <code>string location_type = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for locationType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLocationTypeBytes() {
    java.lang.Object ref = locationType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      locationType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STORAGE_CLASS_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object storageClass_ = "";
  /**
   *
   *
   * <pre>
   * The bucket's default storage class, used whenever no storageClass is
   * specified for a newly-created object. This defines how objects in the
   * bucket are stored and determines the SLA and the cost of storage.
   * If this value is not specified when the bucket is created, it will default
   * to `STANDARD`. For more information, see
   * https://developers.google.com/storage/docs/storage-classes.
   * </pre>
   *
   * <code>string storage_class = 7;</code>
   *
   * @return The storageClass.
   */
  @java.lang.Override
  public java.lang.String getStorageClass() {
    java.lang.Object ref = storageClass_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      storageClass_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The bucket's default storage class, used whenever no storageClass is
   * specified for a newly-created object. This defines how objects in the
   * bucket are stored and determines the SLA and the cost of storage.
   * If this value is not specified when the bucket is created, it will default
   * to `STANDARD`. For more information, see
   * https://developers.google.com/storage/docs/storage-classes.
   * </pre>
   *
   * <code>string storage_class = 7;</code>
   *
   * @return The bytes for storageClass.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStorageClassBytes() {
    java.lang.Object ref = storageClass_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      storageClass_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RPO_FIELD_NUMBER = 27;

  @SuppressWarnings("serial")
  private volatile java.lang.Object rpo_ = "";
  /**
   *
   *
   * <pre>
   * The recovery point objective for cross-region replication of the bucket.
   * Applicable only for dual- and multi-region buckets. "DEFAULT" uses default
   * replication. "ASYNC_TURBO" enables turbo replication, valid for dual-region
   * buckets only. If rpo is not specified when the bucket is created, it
   * defaults to "DEFAULT". For more information, see
   * https://cloud.google.com/storage/docs/availability-durability#turbo-replication.
   * </pre>
   *
   * <code>string rpo = 27;</code>
   *
   * @return The rpo.
   */
  @java.lang.Override
  public java.lang.String getRpo() {
    java.lang.Object ref = rpo_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      rpo_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The recovery point objective for cross-region replication of the bucket.
   * Applicable only for dual- and multi-region buckets. "DEFAULT" uses default
   * replication. "ASYNC_TURBO" enables turbo replication, valid for dual-region
   * buckets only. If rpo is not specified when the bucket is created, it
   * defaults to "DEFAULT". For more information, see
   * https://cloud.google.com/storage/docs/availability-durability#turbo-replication.
   * </pre>
   *
   * <code>string rpo = 27;</code>
   *
   * @return The bytes for rpo.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRpoBytes() {
    java.lang.Object ref = rpo_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      rpo_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ACL_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private java.util.List<com.google.storage.v2.BucketAccessControl> acl_;
  /**
   *
   *
   * <pre>
   * Access controls on the bucket.
   * If iam_config.uniform_bucket_level_access is enabled on this bucket,
   * requests to set, read, or modify acl is an error.
   * </pre>
   *
   * <code>repeated .google.storage.v2.BucketAccessControl acl = 8;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.storage.v2.BucketAccessControl> getAclList() {
    return acl_;
  }
  /**
   *
   *
   * <pre>
   * Access controls on the bucket.
   * If iam_config.uniform_bucket_level_access is enabled on this bucket,
   * requests to set, read, or modify acl is an error.
   * </pre>
   *
   * <code>repeated .google.storage.v2.BucketAccessControl acl = 8;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.storage.v2.BucketAccessControlOrBuilder>
      getAclOrBuilderList() {
    return acl_;
  }
  /**
   *
   *
   * <pre>
   * Access controls on the bucket.
   * If iam_config.uniform_bucket_level_access is enabled on this bucket,
   * requests to set, read, or modify acl is an error.
   * </pre>
   *
   * <code>repeated .google.storage.v2.BucketAccessControl acl = 8;</code>
   */
  @java.lang.Override
  public int getAclCount() {
    return acl_.size();
  }
  /**
   *
   *
   * <pre>
   * Access controls on the bucket.
   * If iam_config.uniform_bucket_level_access is enabled on this bucket,
   * requests to set, read, or modify acl is an error.
   * </pre>
   *
   * <code>repeated .google.storage.v2.BucketAccessControl acl = 8;</code>
   */
  @java.lang.Override
  public com.google.storage.v2.BucketAccessControl getAcl(int index) {
    return acl_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Access controls on the bucket.
   * If iam_config.uniform_bucket_level_access is enabled on this bucket,
   * requests to set, read, or modify acl is an error.
   * </pre>
   *
   * <code>repeated .google.storage.v2.BucketAccessControl acl = 8;</code>
   */
  @java.lang.Override
  public com.google.storage.v2.BucketAccessControlOrBuilder getAclOrBuilder(int index) {
    return acl_.get(index);
  }

  public static final int DEFAULT_OBJECT_ACL_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private java.util.List<com.google.storage.v2.ObjectAccessControl> defaultObjectAcl_;
  /**
   *
   *
   * <pre>
   * Default access controls to apply to new objects when no ACL is provided.
   * If iam_config.uniform_bucket_level_access is enabled on this bucket,
   * requests to set, read, or modify acl is an error.
   * </pre>
   *
   * <code>repeated .google.storage.v2.ObjectAccessControl default_object_acl = 9;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.storage.v2.ObjectAccessControl> getDefaultObjectAclList() {
    return defaultObjectAcl_;
  }
  /**
   *
   *
   * <pre>
   * Default access controls to apply to new objects when no ACL is provided.
   * If iam_config.uniform_bucket_level_access is enabled on this bucket,
   * requests to set, read, or modify acl is an error.
   * </pre>
   *
   * <code>repeated .google.storage.v2.ObjectAccessControl default_object_acl = 9;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.storage.v2.ObjectAccessControlOrBuilder>
      getDefaultObjectAclOrBuilderList() {
    return defaultObjectAcl_;
  }
  /**
   *
   *
   * <pre>
   * Default access controls to apply to new objects when no ACL is provided.
   * If iam_config.uniform_bucket_level_access is enabled on this bucket,
   * requests to set, read, or modify acl is an error.
   * </pre>
   *
   * <code>repeated .google.storage.v2.ObjectAccessControl default_object_acl = 9;</code>
   */
  @java.lang.Override
  public int getDefaultObjectAclCount() {
    return defaultObjectAcl_.size();
  }
  /**
   *
   *
   * <pre>
   * Default access controls to apply to new objects when no ACL is provided.
   * If iam_config.uniform_bucket_level_access is enabled on this bucket,
   * requests to set, read, or modify acl is an error.
   * </pre>
   *
   * <code>repeated .google.storage.v2.ObjectAccessControl default_object_acl = 9;</code>
   */
  @java.lang.Override
  public com.google.storage.v2.ObjectAccessControl getDefaultObjectAcl(int index) {
    return defaultObjectAcl_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Default access controls to apply to new objects when no ACL is provided.
   * If iam_config.uniform_bucket_level_access is enabled on this bucket,
   * requests to set, read, or modify acl is an error.
   * </pre>
   *
   * <code>repeated .google.storage.v2.ObjectAccessControl default_object_acl = 9;</code>
   */
  @java.lang.Override
  public com.google.storage.v2.ObjectAccessControlOrBuilder getDefaultObjectAclOrBuilder(
      int index) {
    return defaultObjectAcl_.get(index);
  }

  public static final int LIFECYCLE_FIELD_NUMBER = 10;
  private com.google.storage.v2.Bucket.Lifecycle lifecycle_;
  /**
   *
   *
   * <pre>
   * The bucket's lifecycle config. See
   * [https://developers.google.com/storage/docs/lifecycle]Lifecycle Management]
   * for more information.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.Lifecycle lifecycle = 10;</code>
   *
   * @return Whether the lifecycle field is set.
   */
  @java.lang.Override
  public boolean hasLifecycle() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The bucket's lifecycle config. See
   * [https://developers.google.com/storage/docs/lifecycle]Lifecycle Management]
   * for more information.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.Lifecycle lifecycle = 10;</code>
   *
   * @return The lifecycle.
   */
  @java.lang.Override
  public com.google.storage.v2.Bucket.Lifecycle getLifecycle() {
    return lifecycle_ == null
        ? com.google.storage.v2.Bucket.Lifecycle.getDefaultInstance()
        : lifecycle_;
  }
  /**
   *
   *
   * <pre>
   * The bucket's lifecycle config. See
   * [https://developers.google.com/storage/docs/lifecycle]Lifecycle Management]
   * for more information.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.Lifecycle lifecycle = 10;</code>
   */
  @java.lang.Override
  public com.google.storage.v2.Bucket.LifecycleOrBuilder getLifecycleOrBuilder() {
    return lifecycle_ == null
        ? com.google.storage.v2.Bucket.Lifecycle.getDefaultInstance()
        : lifecycle_;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 11;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The creation time of the bucket.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The creation time of the bucket.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The creation time of the bucket.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int CORS_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private java.util.List<com.google.storage.v2.Bucket.Cors> cors_;
  /**
   *
   *
   * <pre>
   * The bucket's [https://www.w3.org/TR/cors/][Cross-Origin Resource Sharing]
   * (CORS) config.
   * </pre>
   *
   * <code>repeated .google.storage.v2.Bucket.Cors cors = 12;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.storage.v2.Bucket.Cors> getCorsList() {
    return cors_;
  }
  /**
   *
   *
   * <pre>
   * The bucket's [https://www.w3.org/TR/cors/][Cross-Origin Resource Sharing]
   * (CORS) config.
   * </pre>
   *
   * <code>repeated .google.storage.v2.Bucket.Cors cors = 12;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.storage.v2.Bucket.CorsOrBuilder>
      getCorsOrBuilderList() {
    return cors_;
  }
  /**
   *
   *
   * <pre>
   * The bucket's [https://www.w3.org/TR/cors/][Cross-Origin Resource Sharing]
   * (CORS) config.
   * </pre>
   *
   * <code>repeated .google.storage.v2.Bucket.Cors cors = 12;</code>
   */
  @java.lang.Override
  public int getCorsCount() {
    return cors_.size();
  }
  /**
   *
   *
   * <pre>
   * The bucket's [https://www.w3.org/TR/cors/][Cross-Origin Resource Sharing]
   * (CORS) config.
   * </pre>
   *
   * <code>repeated .google.storage.v2.Bucket.Cors cors = 12;</code>
   */
  @java.lang.Override
  public com.google.storage.v2.Bucket.Cors getCors(int index) {
    return cors_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The bucket's [https://www.w3.org/TR/cors/][Cross-Origin Resource Sharing]
   * (CORS) config.
   * </pre>
   *
   * <code>repeated .google.storage.v2.Bucket.Cors cors = 12;</code>
   */
  @java.lang.Override
  public com.google.storage.v2.Bucket.CorsOrBuilder getCorsOrBuilder(int index) {
    return cors_.get(index);
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 13;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The modification time of the bucket.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The modification time of the bucket.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The modification time of the bucket.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int DEFAULT_EVENT_BASED_HOLD_FIELD_NUMBER = 14;
  private boolean defaultEventBasedHold_ = false;
  /**
   *
   *
   * <pre>
   * The default value for event-based hold on newly created objects in this
   * bucket.  Event-based hold is a way to retain objects indefinitely until an
   * event occurs, signified by the
   * hold's release. After being released, such objects will be subject to
   * bucket-level retention (if any).  One sample use case of this flag is for
   * banks to hold loan documents for at least 3 years after loan is paid in
   * full. Here, bucket-level retention is 3 years and the event is loan being
   * paid in full. In this example, these objects will be held intact for any
   * number of years until the event has occurred (event-based hold on the
   * object is released) and then 3 more years after that. That means retention
   * duration of the objects begins from the moment event-based hold
   * transitioned from true to false.  Objects under event-based hold cannot be
   * deleted, overwritten or archived until the hold is removed.
   * </pre>
   *
   * <code>bool default_event_based_hold = 14;</code>
   *
   * @return The defaultEventBasedHold.
   */
  @java.lang.Override
  public boolean getDefaultEventBasedHold() {
    return defaultEventBasedHold_;
  }

  public static final int LABELS_FIELD_NUMBER = 15;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.storage.v2.StorageProto
                .internal_static_google_storage_v2_Bucket_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * User-provided labels, in key/value pairs.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 15;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * User-provided labels, in key/value pairs.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 15;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * User-provided labels, in key/value pairs.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 15;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * User-provided labels, in key/value pairs.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 15;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int WEBSITE_FIELD_NUMBER = 16;
  private com.google.storage.v2.Bucket.Website website_;
  /**
   *
   *
   * <pre>
   * The bucket's website config, controlling how the service behaves
   * when accessing bucket contents as a web site. See the
   * [https://cloud.google.com/storage/docs/static-website][Static Website
   * Examples] for more information.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.Website website = 16;</code>
   *
   * @return Whether the website field is set.
   */
  @java.lang.Override
  public boolean hasWebsite() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * The bucket's website config, controlling how the service behaves
   * when accessing bucket contents as a web site. See the
   * [https://cloud.google.com/storage/docs/static-website][Static Website
   * Examples] for more information.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.Website website = 16;</code>
   *
   * @return The website.
   */
  @java.lang.Override
  public com.google.storage.v2.Bucket.Website getWebsite() {
    return website_ == null ? com.google.storage.v2.Bucket.Website.getDefaultInstance() : website_;
  }
  /**
   *
   *
   * <pre>
   * The bucket's website config, controlling how the service behaves
   * when accessing bucket contents as a web site. See the
   * [https://cloud.google.com/storage/docs/static-website][Static Website
   * Examples] for more information.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.Website website = 16;</code>
   */
  @java.lang.Override
  public com.google.storage.v2.Bucket.WebsiteOrBuilder getWebsiteOrBuilder() {
    return website_ == null ? com.google.storage.v2.Bucket.Website.getDefaultInstance() : website_;
  }

  public static final int VERSIONING_FIELD_NUMBER = 17;
  private com.google.storage.v2.Bucket.Versioning versioning_;
  /**
   *
   *
   * <pre>
   * The bucket's versioning config.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.Versioning versioning = 17;</code>
   *
   * @return Whether the versioning field is set.
   */
  @java.lang.Override
  public boolean hasVersioning() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * The bucket's versioning config.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.Versioning versioning = 17;</code>
   *
   * @return The versioning.
   */
  @java.lang.Override
  public com.google.storage.v2.Bucket.Versioning getVersioning() {
    return versioning_ == null
        ? com.google.storage.v2.Bucket.Versioning.getDefaultInstance()
        : versioning_;
  }
  /**
   *
   *
   * <pre>
   * The bucket's versioning config.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.Versioning versioning = 17;</code>
   */
  @java.lang.Override
  public com.google.storage.v2.Bucket.VersioningOrBuilder getVersioningOrBuilder() {
    return versioning_ == null
        ? com.google.storage.v2.Bucket.Versioning.getDefaultInstance()
        : versioning_;
  }

  public static final int LOGGING_FIELD_NUMBER = 18;
  private com.google.storage.v2.Bucket.Logging logging_;
  /**
   *
   *
   * <pre>
   * The bucket's logging config, which defines the destination bucket
   * and name prefix (if any) for the current bucket's logs.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.Logging logging = 18;</code>
   *
   * @return Whether the logging field is set.
   */
  @java.lang.Override
  public boolean hasLogging() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * The bucket's logging config, which defines the destination bucket
   * and name prefix (if any) for the current bucket's logs.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.Logging logging = 18;</code>
   *
   * @return The logging.
   */
  @java.lang.Override
  public com.google.storage.v2.Bucket.Logging getLogging() {
    return logging_ == null ? com.google.storage.v2.Bucket.Logging.getDefaultInstance() : logging_;
  }
  /**
   *
   *
   * <pre>
   * The bucket's logging config, which defines the destination bucket
   * and name prefix (if any) for the current bucket's logs.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.Logging logging = 18;</code>
   */
  @java.lang.Override
  public com.google.storage.v2.Bucket.LoggingOrBuilder getLoggingOrBuilder() {
    return logging_ == null ? com.google.storage.v2.Bucket.Logging.getDefaultInstance() : logging_;
  }

  public static final int OWNER_FIELD_NUMBER = 19;
  private com.google.storage.v2.Owner owner_;
  /**
   *
   *
   * <pre>
   * Output only. The owner of the bucket. This is always the project team's
   * owner group.
   * </pre>
   *
   * <code>.google.storage.v2.Owner owner = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return Whether the owner field is set.
   */
  @java.lang.Override
  public boolean hasOwner() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The owner of the bucket. This is always the project team's
   * owner group.
   * </pre>
   *
   * <code>.google.storage.v2.Owner owner = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The owner.
   */
  @java.lang.Override
  public com.google.storage.v2.Owner getOwner() {
    return owner_ == null ? com.google.storage.v2.Owner.getDefaultInstance() : owner_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The owner of the bucket. This is always the project team's
   * owner group.
   * </pre>
   *
   * <code>.google.storage.v2.Owner owner = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.storage.v2.OwnerOrBuilder getOwnerOrBuilder() {
    return owner_ == null ? com.google.storage.v2.Owner.getDefaultInstance() : owner_;
  }

  public static final int ENCRYPTION_FIELD_NUMBER = 20;
  private com.google.storage.v2.Bucket.Encryption encryption_;
  /**
   *
   *
   * <pre>
   * Encryption config for a bucket.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.Encryption encryption = 20;</code>
   *
   * @return Whether the encryption field is set.
   */
  @java.lang.Override
  public boolean hasEncryption() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   * Encryption config for a bucket.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.Encryption encryption = 20;</code>
   *
   * @return The encryption.
   */
  @java.lang.Override
  public com.google.storage.v2.Bucket.Encryption getEncryption() {
    return encryption_ == null
        ? com.google.storage.v2.Bucket.Encryption.getDefaultInstance()
        : encryption_;
  }
  /**
   *
   *
   * <pre>
   * Encryption config for a bucket.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.Encryption encryption = 20;</code>
   */
  @java.lang.Override
  public com.google.storage.v2.Bucket.EncryptionOrBuilder getEncryptionOrBuilder() {
    return encryption_ == null
        ? com.google.storage.v2.Bucket.Encryption.getDefaultInstance()
        : encryption_;
  }

  public static final int BILLING_FIELD_NUMBER = 21;
  private com.google.storage.v2.Bucket.Billing billing_;
  /**
   *
   *
   * <pre>
   * The bucket's billing config.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.Billing billing = 21;</code>
   *
   * @return Whether the billing field is set.
   */
  @java.lang.Override
  public boolean hasBilling() {
    return ((bitField0_ & 0x00000100) != 0);
  }
  /**
   *
   *
   * <pre>
   * The bucket's billing config.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.Billing billing = 21;</code>
   *
   * @return The billing.
   */
  @java.lang.Override
  public com.google.storage.v2.Bucket.Billing getBilling() {
    return billing_ == null ? com.google.storage.v2.Bucket.Billing.getDefaultInstance() : billing_;
  }
  /**
   *
   *
   * <pre>
   * The bucket's billing config.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.Billing billing = 21;</code>
   */
  @java.lang.Override
  public com.google.storage.v2.Bucket.BillingOrBuilder getBillingOrBuilder() {
    return billing_ == null ? com.google.storage.v2.Bucket.Billing.getDefaultInstance() : billing_;
  }

  public static final int RETENTION_POLICY_FIELD_NUMBER = 22;
  private com.google.storage.v2.Bucket.RetentionPolicy retentionPolicy_;
  /**
   *
   *
   * <pre>
   * The bucket's retention policy. The retention policy enforces a minimum
   * retention time for all objects contained in the bucket, based on their
   * creation time. Any attempt to overwrite or delete objects younger than the
   * retention period will result in a PERMISSION_DENIED error.  An unlocked
   * retention policy can be modified or removed from the bucket via a
   * storage.buckets.update operation. A locked retention policy cannot be
   * removed or shortened in duration for the lifetime of the bucket.
   * Attempting to remove or decrease period of a locked retention policy will
   * result in a PERMISSION_DENIED error.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.RetentionPolicy retention_policy = 22;</code>
   *
   * @return Whether the retentionPolicy field is set.
   */
  @java.lang.Override
  public boolean hasRetentionPolicy() {
    return ((bitField0_ & 0x00000200) != 0);
  }
  /**
   *
   *
   * <pre>
   * The bucket's retention policy. The retention policy enforces a minimum
   * retention time for all objects contained in the bucket, based on their
   * creation time. Any attempt to overwrite or delete objects younger than the
   * retention period will result in a PERMISSION_DENIED error.  An unlocked
   * retention policy can be modified or removed from the bucket via a
   * storage.buckets.update operation. A locked retention policy cannot be
   * removed or shortened in duration for the lifetime of the bucket.
   * Attempting to remove or decrease period of a locked retention policy will
   * result in a PERMISSION_DENIED error.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.RetentionPolicy retention_policy = 22;</code>
   *
   * @return The retentionPolicy.
   */
  @java.lang.Override
  public com.google.storage.v2.Bucket.RetentionPolicy getRetentionPolicy() {
    return retentionPolicy_ == null
        ? com.google.storage.v2.Bucket.RetentionPolicy.getDefaultInstance()
        : retentionPolicy_;
  }
  /**
   *
   *
   * <pre>
   * The bucket's retention policy. The retention policy enforces a minimum
   * retention time for all objects contained in the bucket, based on their
   * creation time. Any attempt to overwrite or delete objects younger than the
   * retention period will result in a PERMISSION_DENIED error.  An unlocked
   * retention policy can be modified or removed from the bucket via a
   * storage.buckets.update operation. A locked retention policy cannot be
   * removed or shortened in duration for the lifetime of the bucket.
   * Attempting to remove or decrease period of a locked retention policy will
   * result in a PERMISSION_DENIED error.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.RetentionPolicy retention_policy = 22;</code>
   */
  @java.lang.Override
  public com.google.storage.v2.Bucket.RetentionPolicyOrBuilder getRetentionPolicyOrBuilder() {
    return retentionPolicy_ == null
        ? com.google.storage.v2.Bucket.RetentionPolicy.getDefaultInstance()
        : retentionPolicy_;
  }

  public static final int IAM_CONFIG_FIELD_NUMBER = 23;
  private com.google.storage.v2.Bucket.IamConfig iamConfig_;
  /**
   *
   *
   * <pre>
   * The bucket's IAM config.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.IamConfig iam_config = 23;</code>
   *
   * @return Whether the iamConfig field is set.
   */
  @java.lang.Override
  public boolean hasIamConfig() {
    return ((bitField0_ & 0x00000400) != 0);
  }
  /**
   *
   *
   * <pre>
   * The bucket's IAM config.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.IamConfig iam_config = 23;</code>
   *
   * @return The iamConfig.
   */
  @java.lang.Override
  public com.google.storage.v2.Bucket.IamConfig getIamConfig() {
    return iamConfig_ == null
        ? com.google.storage.v2.Bucket.IamConfig.getDefaultInstance()
        : iamConfig_;
  }
  /**
   *
   *
   * <pre>
   * The bucket's IAM config.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.IamConfig iam_config = 23;</code>
   */
  @java.lang.Override
  public com.google.storage.v2.Bucket.IamConfigOrBuilder getIamConfigOrBuilder() {
    return iamConfig_ == null
        ? com.google.storage.v2.Bucket.IamConfig.getDefaultInstance()
        : iamConfig_;
  }

  public static final int SATISFIES_PZS_FIELD_NUMBER = 25;
  private boolean satisfiesPzs_ = false;
  /**
   *
   *
   * <pre>
   * Reserved for future use.
   * </pre>
   *
   * <code>bool satisfies_pzs = 25;</code>
   *
   * @return The satisfiesPzs.
   */
  @java.lang.Override
  public boolean getSatisfiesPzs() {
    return satisfiesPzs_;
  }

  public static final int CUSTOM_PLACEMENT_CONFIG_FIELD_NUMBER = 26;
  private com.google.storage.v2.Bucket.CustomPlacementConfig customPlacementConfig_;
  /**
   *
   *
   * <pre>
   * Configuration that, if present, specifies the data placement for a
   * [https://cloud.google.com/storage/docs/use-dual-regions][Dual Region].
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.CustomPlacementConfig custom_placement_config = 26;</code>
   *
   * @return Whether the customPlacementConfig field is set.
   */
  @java.lang.Override
  public boolean hasCustomPlacementConfig() {
    return ((bitField0_ & 0x00000800) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configuration that, if present, specifies the data placement for a
   * [https://cloud.google.com/storage/docs/use-dual-regions][Dual Region].
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.CustomPlacementConfig custom_placement_config = 26;</code>
   *
   * @return The customPlacementConfig.
   */
  @java.lang.Override
  public com.google.storage.v2.Bucket.CustomPlacementConfig getCustomPlacementConfig() {
    return customPlacementConfig_ == null
        ? com.google.storage.v2.Bucket.CustomPlacementConfig.getDefaultInstance()
        : customPlacementConfig_;
  }
  /**
   *
   *
   * <pre>
   * Configuration that, if present, specifies the data placement for a
   * [https://cloud.google.com/storage/docs/use-dual-regions][Dual Region].
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.CustomPlacementConfig custom_placement_config = 26;</code>
   */
  @java.lang.Override
  public com.google.storage.v2.Bucket.CustomPlacementConfigOrBuilder
      getCustomPlacementConfigOrBuilder() {
    return customPlacementConfig_ == null
        ? com.google.storage.v2.Bucket.CustomPlacementConfig.getDefaultInstance()
        : customPlacementConfig_;
  }

  public static final int AUTOCLASS_FIELD_NUMBER = 28;
  private com.google.storage.v2.Bucket.Autoclass autoclass_;
  /**
   *
   *
   * <pre>
   * The bucket's Autoclass configuration. If there is no configuration, the
   * Autoclass feature will be disabled and have no effect on the bucket.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.Autoclass autoclass = 28;</code>
   *
   * @return Whether the autoclass field is set.
   */
  @java.lang.Override
  public boolean hasAutoclass() {
    return ((bitField0_ & 0x00001000) != 0);
  }
  /**
   *
   *
   * <pre>
   * The bucket's Autoclass configuration. If there is no configuration, the
   * Autoclass feature will be disabled and have no effect on the bucket.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.Autoclass autoclass = 28;</code>
   *
   * @return The autoclass.
   */
  @java.lang.Override
  public com.google.storage.v2.Bucket.Autoclass getAutoclass() {
    return autoclass_ == null
        ? com.google.storage.v2.Bucket.Autoclass.getDefaultInstance()
        : autoclass_;
  }
  /**
   *
   *
   * <pre>
   * The bucket's Autoclass configuration. If there is no configuration, the
   * Autoclass feature will be disabled and have no effect on the bucket.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.Autoclass autoclass = 28;</code>
   */
  @java.lang.Override
  public com.google.storage.v2.Bucket.AutoclassOrBuilder getAutoclassOrBuilder() {
    return autoclass_ == null
        ? com.google.storage.v2.Bucket.Autoclass.getDefaultInstance()
        : autoclass_;
  }

  public static final int HIERARCHICAL_NAMESPACE_FIELD_NUMBER = 32;
  private com.google.storage.v2.Bucket.HierarchicalNamespace hierarchicalNamespace_;
  /**
   *
   *
   * <pre>
   * Optional. The bucket's hierarchical namespace configuration. If there is no
   * configuration, the hierarchical namespace feature will be disabled and have
   * no effect on the bucket.
   * </pre>
   *
   * <code>
   * .google.storage.v2.Bucket.HierarchicalNamespace hierarchical_namespace = 32 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the hierarchicalNamespace field is set.
   */
  @java.lang.Override
  public boolean hasHierarchicalNamespace() {
    return ((bitField0_ & 0x00002000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. The bucket's hierarchical namespace configuration. If there is no
   * configuration, the hierarchical namespace feature will be disabled and have
   * no effect on the bucket.
   * </pre>
   *
   * <code>
   * .google.storage.v2.Bucket.HierarchicalNamespace hierarchical_namespace = 32 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The hierarchicalNamespace.
   */
  @java.lang.Override
  public com.google.storage.v2.Bucket.HierarchicalNamespace getHierarchicalNamespace() {
    return hierarchicalNamespace_ == null
        ? com.google.storage.v2.Bucket.HierarchicalNamespace.getDefaultInstance()
        : hierarchicalNamespace_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The bucket's hierarchical namespace configuration. If there is no
   * configuration, the hierarchical namespace feature will be disabled and have
   * no effect on the bucket.
   * </pre>
   *
   * <code>
   * .google.storage.v2.Bucket.HierarchicalNamespace hierarchical_namespace = 32 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.storage.v2.Bucket.HierarchicalNamespaceOrBuilder
      getHierarchicalNamespaceOrBuilder() {
    return hierarchicalNamespace_ == null
        ? com.google.storage.v2.Bucket.HierarchicalNamespace.getDefaultInstance()
        : hierarchicalNamespace_;
  }

  public static final int SOFT_DELETE_POLICY_FIELD_NUMBER = 31;
  private com.google.storage.v2.Bucket.SoftDeletePolicy softDeletePolicy_;
  /**
   *
   *
   * <pre>
   * Optional. The bucket's soft delete policy. The soft delete policy prevents
   * soft-deleted objects from being permanently deleted.
   * </pre>
   *
   * <code>
   * .google.storage.v2.Bucket.SoftDeletePolicy soft_delete_policy = 31 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the softDeletePolicy field is set.
   */
  @java.lang.Override
  public boolean hasSoftDeletePolicy() {
    return ((bitField0_ & 0x00004000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. The bucket's soft delete policy. The soft delete policy prevents
   * soft-deleted objects from being permanently deleted.
   * </pre>
   *
   * <code>
   * .google.storage.v2.Bucket.SoftDeletePolicy soft_delete_policy = 31 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The softDeletePolicy.
   */
  @java.lang.Override
  public com.google.storage.v2.Bucket.SoftDeletePolicy getSoftDeletePolicy() {
    return softDeletePolicy_ == null
        ? com.google.storage.v2.Bucket.SoftDeletePolicy.getDefaultInstance()
        : softDeletePolicy_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The bucket's soft delete policy. The soft delete policy prevents
   * soft-deleted objects from being permanently deleted.
   * </pre>
   *
   * <code>
   * .google.storage.v2.Bucket.SoftDeletePolicy soft_delete_policy = 31 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.storage.v2.Bucket.SoftDeletePolicyOrBuilder getSoftDeletePolicyOrBuilder() {
    return softDeletePolicy_ == null
        ? com.google.storage.v2.Bucket.SoftDeletePolicy.getDefaultInstance()
        : softDeletePolicy_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bucketId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, bucketId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(project_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, project_);
    }
    if (metageneration_ != 0L) {
      output.writeInt64(4, metageneration_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, location_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(locationType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, locationType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(storageClass_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, storageClass_);
    }
    for (int i = 0; i < acl_.size(); i++) {
      output.writeMessage(8, acl_.get(i));
    }
    for (int i = 0; i < defaultObjectAcl_.size(); i++) {
      output.writeMessage(9, defaultObjectAcl_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(10, getLifecycle());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(11, getCreateTime());
    }
    for (int i = 0; i < cors_.size(); i++) {
      output.writeMessage(12, cors_.get(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(13, getUpdateTime());
    }
    if (defaultEventBasedHold_ != false) {
      output.writeBool(14, defaultEventBasedHold_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 15);
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(16, getWebsite());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(17, getVersioning());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(18, getLogging());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(19, getOwner());
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeMessage(20, getEncryption());
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      output.writeMessage(21, getBilling());
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      output.writeMessage(22, getRetentionPolicy());
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      output.writeMessage(23, getIamConfig());
    }
    if (satisfiesPzs_ != false) {
      output.writeBool(25, satisfiesPzs_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      output.writeMessage(26, getCustomPlacementConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rpo_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 27, rpo_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      output.writeMessage(28, getAutoclass());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 29, etag_);
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      output.writeMessage(31, getSoftDeletePolicy());
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      output.writeMessage(32, getHierarchicalNamespace());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bucketId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, bucketId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(project_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, project_);
    }
    if (metageneration_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(4, metageneration_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, location_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(locationType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, locationType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(storageClass_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, storageClass_);
    }
    for (int i = 0; i < acl_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, acl_.get(i));
    }
    for (int i = 0; i < defaultObjectAcl_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, defaultObjectAcl_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getLifecycle());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getCreateTime());
    }
    for (int i = 0; i < cors_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, cors_.get(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, getUpdateTime());
    }
    if (defaultEventBasedHold_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(14, defaultEventBasedHold_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(15, labels__);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(16, getWebsite());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(17, getVersioning());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(18, getLogging());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(19, getOwner());
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(20, getEncryption());
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(21, getBilling());
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(22, getRetentionPolicy());
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(23, getIamConfig());
    }
    if (satisfiesPzs_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(25, satisfiesPzs_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(26, getCustomPlacementConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rpo_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(27, rpo_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(28, getAutoclass());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(29, etag_);
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(31, getSoftDeletePolicy());
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(32, getHierarchicalNamespace());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.storage.v2.Bucket)) {
      return super.equals(obj);
    }
    com.google.storage.v2.Bucket other = (com.google.storage.v2.Bucket) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getBucketId().equals(other.getBucketId())) return false;
    if (!getEtag().equals(other.getEtag())) return false;
    if (!getProject().equals(other.getProject())) return false;
    if (getMetageneration() != other.getMetageneration()) return false;
    if (!getLocation().equals(other.getLocation())) return false;
    if (!getLocationType().equals(other.getLocationType())) return false;
    if (!getStorageClass().equals(other.getStorageClass())) return false;
    if (!getRpo().equals(other.getRpo())) return false;
    if (!getAclList().equals(other.getAclList())) return false;
    if (!getDefaultObjectAclList().equals(other.getDefaultObjectAclList())) return false;
    if (hasLifecycle() != other.hasLifecycle()) return false;
    if (hasLifecycle()) {
      if (!getLifecycle().equals(other.getLifecycle())) return false;
    }
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (!getCorsList().equals(other.getCorsList())) return false;
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (getDefaultEventBasedHold() != other.getDefaultEventBasedHold()) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasWebsite() != other.hasWebsite()) return false;
    if (hasWebsite()) {
      if (!getWebsite().equals(other.getWebsite())) return false;
    }
    if (hasVersioning() != other.hasVersioning()) return false;
    if (hasVersioning()) {
      if (!getVersioning().equals(other.getVersioning())) return false;
    }
    if (hasLogging() != other.hasLogging()) return false;
    if (hasLogging()) {
      if (!getLogging().equals(other.getLogging())) return false;
    }
    if (hasOwner() != other.hasOwner()) return false;
    if (hasOwner()) {
      if (!getOwner().equals(other.getOwner())) return false;
    }
    if (hasEncryption() != other.hasEncryption()) return false;
    if (hasEncryption()) {
      if (!getEncryption().equals(other.getEncryption())) return false;
    }
    if (hasBilling() != other.hasBilling()) return false;
    if (hasBilling()) {
      if (!getBilling().equals(other.getBilling())) return false;
    }
    if (hasRetentionPolicy() != other.hasRetentionPolicy()) return false;
    if (hasRetentionPolicy()) {
      if (!getRetentionPolicy().equals(other.getRetentionPolicy())) return false;
    }
    if (hasIamConfig() != other.hasIamConfig()) return false;
    if (hasIamConfig()) {
      if (!getIamConfig().equals(other.getIamConfig())) return false;
    }
    if (getSatisfiesPzs() != other.getSatisfiesPzs()) return false;
    if (hasCustomPlacementConfig() != other.hasCustomPlacementConfig()) return false;
    if (hasCustomPlacementConfig()) {
      if (!getCustomPlacementConfig().equals(other.getCustomPlacementConfig())) return false;
    }
    if (hasAutoclass() != other.hasAutoclass()) return false;
    if (hasAutoclass()) {
      if (!getAutoclass().equals(other.getAutoclass())) return false;
    }
    if (hasHierarchicalNamespace() != other.hasHierarchicalNamespace()) return false;
    if (hasHierarchicalNamespace()) {
      if (!getHierarchicalNamespace().equals(other.getHierarchicalNamespace())) return false;
    }
    if (hasSoftDeletePolicy() != other.hasSoftDeletePolicy()) return false;
    if (hasSoftDeletePolicy()) {
      if (!getSoftDeletePolicy().equals(other.getSoftDeletePolicy())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + BUCKET_ID_FIELD_NUMBER;
    hash = (53 * hash) + getBucketId().hashCode();
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    hash = (37 * hash) + PROJECT_FIELD_NUMBER;
    hash = (53 * hash) + getProject().hashCode();
    hash = (37 * hash) + METAGENERATION_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getMetageneration());
    hash = (37 * hash) + LOCATION_FIELD_NUMBER;
    hash = (53 * hash) + getLocation().hashCode();
    hash = (37 * hash) + LOCATION_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getLocationType().hashCode();
    hash = (37 * hash) + STORAGE_CLASS_FIELD_NUMBER;
    hash = (53 * hash) + getStorageClass().hashCode();
    hash = (37 * hash) + RPO_FIELD_NUMBER;
    hash = (53 * hash) + getRpo().hashCode();
    if (getAclCount() > 0) {
      hash = (37 * hash) + ACL_FIELD_NUMBER;
      hash = (53 * hash) + getAclList().hashCode();
    }
    if (getDefaultObjectAclCount() > 0) {
      hash = (37 * hash) + DEFAULT_OBJECT_ACL_FIELD_NUMBER;
      hash = (53 * hash) + getDefaultObjectAclList().hashCode();
    }
    if (hasLifecycle()) {
      hash = (37 * hash) + LIFECYCLE_FIELD_NUMBER;
      hash = (53 * hash) + getLifecycle().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (getCorsCount() > 0) {
      hash = (37 * hash) + CORS_FIELD_NUMBER;
      hash = (53 * hash) + getCorsList().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + DEFAULT_EVENT_BASED_HOLD_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDefaultEventBasedHold());
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasWebsite()) {
      hash = (37 * hash) + WEBSITE_FIELD_NUMBER;
      hash = (53 * hash) + getWebsite().hashCode();
    }
    if (hasVersioning()) {
      hash = (37 * hash) + VERSIONING_FIELD_NUMBER;
      hash = (53 * hash) + getVersioning().hashCode();
    }
    if (hasLogging()) {
      hash = (37 * hash) + LOGGING_FIELD_NUMBER;
      hash = (53 * hash) + getLogging().hashCode();
    }
    if (hasOwner()) {
      hash = (37 * hash) + OWNER_FIELD_NUMBER;
      hash = (53 * hash) + getOwner().hashCode();
    }
    if (hasEncryption()) {
      hash = (37 * hash) + ENCRYPTION_FIELD_NUMBER;
      hash = (53 * hash) + getEncryption().hashCode();
    }
    if (hasBilling()) {
      hash = (37 * hash) + BILLING_FIELD_NUMBER;
      hash = (53 * hash) + getBilling().hashCode();
    }
    if (hasRetentionPolicy()) {
      hash = (37 * hash) + RETENTION_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getRetentionPolicy().hashCode();
    }
    if (hasIamConfig()) {
      hash = (37 * hash) + IAM_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getIamConfig().hashCode();
    }
    hash = (37 * hash) + SATISFIES_PZS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSatisfiesPzs());
    if (hasCustomPlacementConfig()) {
      hash = (37 * hash) + CUSTOM_PLACEMENT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getCustomPlacementConfig().hashCode();
    }
    if (hasAutoclass()) {
      hash = (37 * hash) + AUTOCLASS_FIELD_NUMBER;
      hash = (53 * hash) + getAutoclass().hashCode();
    }
    if (hasHierarchicalNamespace()) {
      hash = (37 * hash) + HIERARCHICAL_NAMESPACE_FIELD_NUMBER;
      hash = (53 * hash) + getHierarchicalNamespace().hashCode();
    }
    if (hasSoftDeletePolicy()) {
      hash = (37 * hash) + SOFT_DELETE_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getSoftDeletePolicy().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.storage.v2.Bucket parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.Bucket parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.Bucket parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.Bucket parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.Bucket parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.Bucket parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.Bucket parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.Bucket parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.storage.v2.Bucket parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.Bucket parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.storage.v2.Bucket parseFrom(com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.Bucket parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.storage.v2.Bucket prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A bucket.
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.Bucket}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.storage.v2.Bucket)
      com.google.storage.v2.BucketOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto.internal_static_google_storage_v2_Bucket_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 15:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 15:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.Bucket.class, com.google.storage.v2.Bucket.Builder.class);
    }

    // Construct using com.google.storage.v2.Bucket.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getAclFieldBuilder();
        getDefaultObjectAclFieldBuilder();
        getLifecycleFieldBuilder();
        getCreateTimeFieldBuilder();
        getCorsFieldBuilder();
        getUpdateTimeFieldBuilder();
        getWebsiteFieldBuilder();
        getVersioningFieldBuilder();
        getLoggingFieldBuilder();
        getOwnerFieldBuilder();
        getEncryptionFieldBuilder();
        getBillingFieldBuilder();
        getRetentionPolicyFieldBuilder();
        getIamConfigFieldBuilder();
        getCustomPlacementConfigFieldBuilder();
        getAutoclassFieldBuilder();
        getHierarchicalNamespaceFieldBuilder();
        getSoftDeletePolicyFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      bucketId_ = "";
      etag_ = "";
      project_ = "";
      metageneration_ = 0L;
      location_ = "";
      locationType_ = "";
      storageClass_ = "";
      rpo_ = "";
      if (aclBuilder_ == null) {
        acl_ = java.util.Collections.emptyList();
      } else {
        acl_ = null;
        aclBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000200);
      if (defaultObjectAclBuilder_ == null) {
        defaultObjectAcl_ = java.util.Collections.emptyList();
      } else {
        defaultObjectAcl_ = null;
        defaultObjectAclBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000400);
      lifecycle_ = null;
      if (lifecycleBuilder_ != null) {
        lifecycleBuilder_.dispose();
        lifecycleBuilder_ = null;
      }
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      if (corsBuilder_ == null) {
        cors_ = java.util.Collections.emptyList();
      } else {
        cors_ = null;
        corsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00002000);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      defaultEventBasedHold_ = false;
      internalGetMutableLabels().clear();
      website_ = null;
      if (websiteBuilder_ != null) {
        websiteBuilder_.dispose();
        websiteBuilder_ = null;
      }
      versioning_ = null;
      if (versioningBuilder_ != null) {
        versioningBuilder_.dispose();
        versioningBuilder_ = null;
      }
      logging_ = null;
      if (loggingBuilder_ != null) {
        loggingBuilder_.dispose();
        loggingBuilder_ = null;
      }
      owner_ = null;
      if (ownerBuilder_ != null) {
        ownerBuilder_.dispose();
        ownerBuilder_ = null;
      }
      encryption_ = null;
      if (encryptionBuilder_ != null) {
        encryptionBuilder_.dispose();
        encryptionBuilder_ = null;
      }
      billing_ = null;
      if (billingBuilder_ != null) {
        billingBuilder_.dispose();
        billingBuilder_ = null;
      }
      retentionPolicy_ = null;
      if (retentionPolicyBuilder_ != null) {
        retentionPolicyBuilder_.dispose();
        retentionPolicyBuilder_ = null;
      }
      iamConfig_ = null;
      if (iamConfigBuilder_ != null) {
        iamConfigBuilder_.dispose();
        iamConfigBuilder_ = null;
      }
      satisfiesPzs_ = false;
      customPlacementConfig_ = null;
      if (customPlacementConfigBuilder_ != null) {
        customPlacementConfigBuilder_.dispose();
        customPlacementConfigBuilder_ = null;
      }
      autoclass_ = null;
      if (autoclassBuilder_ != null) {
        autoclassBuilder_.dispose();
        autoclassBuilder_ = null;
      }
      hierarchicalNamespace_ = null;
      if (hierarchicalNamespaceBuilder_ != null) {
        hierarchicalNamespaceBuilder_.dispose();
        hierarchicalNamespaceBuilder_ = null;
      }
      softDeletePolicy_ = null;
      if (softDeletePolicyBuilder_ != null) {
        softDeletePolicyBuilder_.dispose();
        softDeletePolicyBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.storage.v2.StorageProto.internal_static_google_storage_v2_Bucket_descriptor;
    }

    @java.lang.Override
    public com.google.storage.v2.Bucket getDefaultInstanceForType() {
      return com.google.storage.v2.Bucket.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.storage.v2.Bucket build() {
      com.google.storage.v2.Bucket result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.storage.v2.Bucket buildPartial() {
      com.google.storage.v2.Bucket result = new com.google.storage.v2.Bucket(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.storage.v2.Bucket result) {
      if (aclBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)) {
          acl_ = java.util.Collections.unmodifiableList(acl_);
          bitField0_ = (bitField0_ & ~0x00000200);
        }
        result.acl_ = acl_;
      } else {
        result.acl_ = aclBuilder_.build();
      }
      if (defaultObjectAclBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)) {
          defaultObjectAcl_ = java.util.Collections.unmodifiableList(defaultObjectAcl_);
          bitField0_ = (bitField0_ & ~0x00000400);
        }
        result.defaultObjectAcl_ = defaultObjectAcl_;
      } else {
        result.defaultObjectAcl_ = defaultObjectAclBuilder_.build();
      }
      if (corsBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)) {
          cors_ = java.util.Collections.unmodifiableList(cors_);
          bitField0_ = (bitField0_ & ~0x00002000);
        }
        result.cors_ = cors_;
      } else {
        result.cors_ = corsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.storage.v2.Bucket result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.bucketId_ = bucketId_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.etag_ = etag_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.project_ = project_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.metageneration_ = metageneration_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.location_ = location_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.locationType_ = locationType_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.storageClass_ = storageClass_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.rpo_ = rpo_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.lifecycle_ = lifecycleBuilder_ == null ? lifecycle_ : lifecycleBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.defaultEventBasedHold_ = defaultEventBasedHold_;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.website_ = websiteBuilder_ == null ? website_ : websiteBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.versioning_ = versioningBuilder_ == null ? versioning_ : versioningBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.logging_ = loggingBuilder_ == null ? logging_ : loggingBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00100000) != 0)) {
        result.owner_ = ownerBuilder_ == null ? owner_ : ownerBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00200000) != 0)) {
        result.encryption_ = encryptionBuilder_ == null ? encryption_ : encryptionBuilder_.build();
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00400000) != 0)) {
        result.billing_ = billingBuilder_ == null ? billing_ : billingBuilder_.build();
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00800000) != 0)) {
        result.retentionPolicy_ =
            retentionPolicyBuilder_ == null ? retentionPolicy_ : retentionPolicyBuilder_.build();
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x01000000) != 0)) {
        result.iamConfig_ = iamConfigBuilder_ == null ? iamConfig_ : iamConfigBuilder_.build();
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x02000000) != 0)) {
        result.satisfiesPzs_ = satisfiesPzs_;
      }
      if (((from_bitField0_ & 0x04000000) != 0)) {
        result.customPlacementConfig_ =
            customPlacementConfigBuilder_ == null
                ? customPlacementConfig_
                : customPlacementConfigBuilder_.build();
        to_bitField0_ |= 0x00000800;
      }
      if (((from_bitField0_ & 0x08000000) != 0)) {
        result.autoclass_ = autoclassBuilder_ == null ? autoclass_ : autoclassBuilder_.build();
        to_bitField0_ |= 0x00001000;
      }
      if (((from_bitField0_ & 0x10000000) != 0)) {
        result.hierarchicalNamespace_ =
            hierarchicalNamespaceBuilder_ == null
                ? hierarchicalNamespace_
                : hierarchicalNamespaceBuilder_.build();
        to_bitField0_ |= 0x00002000;
      }
      if (((from_bitField0_ & 0x20000000) != 0)) {
        result.softDeletePolicy_ =
            softDeletePolicyBuilder_ == null ? softDeletePolicy_ : softDeletePolicyBuilder_.build();
        to_bitField0_ |= 0x00004000;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.storage.v2.Bucket) {
        return mergeFrom((com.google.storage.v2.Bucket) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.storage.v2.Bucket other) {
      if (other == com.google.storage.v2.Bucket.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getBucketId().isEmpty()) {
        bucketId_ = other.bucketId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getProject().isEmpty()) {
        project_ = other.project_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.getMetageneration() != 0L) {
        setMetageneration(other.getMetageneration());
      }
      if (!other.getLocation().isEmpty()) {
        location_ = other.location_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getLocationType().isEmpty()) {
        locationType_ = other.locationType_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (!other.getStorageClass().isEmpty()) {
        storageClass_ = other.storageClass_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (!other.getRpo().isEmpty()) {
        rpo_ = other.rpo_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (aclBuilder_ == null) {
        if (!other.acl_.isEmpty()) {
          if (acl_.isEmpty()) {
            acl_ = other.acl_;
            bitField0_ = (bitField0_ & ~0x00000200);
          } else {
            ensureAclIsMutable();
            acl_.addAll(other.acl_);
          }
          onChanged();
        }
      } else {
        if (!other.acl_.isEmpty()) {
          if (aclBuilder_.isEmpty()) {
            aclBuilder_.dispose();
            aclBuilder_ = null;
            acl_ = other.acl_;
            bitField0_ = (bitField0_ & ~0x00000200);
            aclBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAclFieldBuilder()
                    : null;
          } else {
            aclBuilder_.addAllMessages(other.acl_);
          }
        }
      }
      if (defaultObjectAclBuilder_ == null) {
        if (!other.defaultObjectAcl_.isEmpty()) {
          if (defaultObjectAcl_.isEmpty()) {
            defaultObjectAcl_ = other.defaultObjectAcl_;
            bitField0_ = (bitField0_ & ~0x00000400);
          } else {
            ensureDefaultObjectAclIsMutable();
            defaultObjectAcl_.addAll(other.defaultObjectAcl_);
          }
          onChanged();
        }
      } else {
        if (!other.defaultObjectAcl_.isEmpty()) {
          if (defaultObjectAclBuilder_.isEmpty()) {
            defaultObjectAclBuilder_.dispose();
            defaultObjectAclBuilder_ = null;
            defaultObjectAcl_ = other.defaultObjectAcl_;
            bitField0_ = (bitField0_ & ~0x00000400);
            defaultObjectAclBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getDefaultObjectAclFieldBuilder()
                    : null;
          } else {
            defaultObjectAclBuilder_.addAllMessages(other.defaultObjectAcl_);
          }
        }
      }
      if (other.hasLifecycle()) {
        mergeLifecycle(other.getLifecycle());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (corsBuilder_ == null) {
        if (!other.cors_.isEmpty()) {
          if (cors_.isEmpty()) {
            cors_ = other.cors_;
            bitField0_ = (bitField0_ & ~0x00002000);
          } else {
            ensureCorsIsMutable();
            cors_.addAll(other.cors_);
          }
          onChanged();
        }
      } else {
        if (!other.cors_.isEmpty()) {
          if (corsBuilder_.isEmpty()) {
            corsBuilder_.dispose();
            corsBuilder_ = null;
            cors_ = other.cors_;
            bitField0_ = (bitField0_ & ~0x00002000);
            corsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getCorsFieldBuilder()
                    : null;
          } else {
            corsBuilder_.addAllMessages(other.cors_);
          }
        }
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.getDefaultEventBasedHold() != false) {
        setDefaultEventBasedHold(other.getDefaultEventBasedHold());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00010000;
      if (other.hasWebsite()) {
        mergeWebsite(other.getWebsite());
      }
      if (other.hasVersioning()) {
        mergeVersioning(other.getVersioning());
      }
      if (other.hasLogging()) {
        mergeLogging(other.getLogging());
      }
      if (other.hasOwner()) {
        mergeOwner(other.getOwner());
      }
      if (other.hasEncryption()) {
        mergeEncryption(other.getEncryption());
      }
      if (other.hasBilling()) {
        mergeBilling(other.getBilling());
      }
      if (other.hasRetentionPolicy()) {
        mergeRetentionPolicy(other.getRetentionPolicy());
      }
      if (other.hasIamConfig()) {
        mergeIamConfig(other.getIamConfig());
      }
      if (other.getSatisfiesPzs() != false) {
        setSatisfiesPzs(other.getSatisfiesPzs());
      }
      if (other.hasCustomPlacementConfig()) {
        mergeCustomPlacementConfig(other.getCustomPlacementConfig());
      }
      if (other.hasAutoclass()) {
        mergeAutoclass(other.getAutoclass());
      }
      if (other.hasHierarchicalNamespace()) {
        mergeHierarchicalNamespace(other.getHierarchicalNamespace());
      }
      if (other.hasSoftDeletePolicy()) {
        mergeSoftDeletePolicy(other.getSoftDeletePolicy());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                bucketId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                project_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 26
            case 32:
              {
                metageneration_ = input.readInt64();
                bitField0_ |= 0x00000010;
                break;
              } // case 32
            case 42:
              {
                location_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 42
            case 50:
              {
                locationType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 50
            case 58:
              {
                storageClass_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 58
            case 66:
              {
                com.google.storage.v2.BucketAccessControl m =
                    input.readMessage(
                        com.google.storage.v2.BucketAccessControl.parser(), extensionRegistry);
                if (aclBuilder_ == null) {
                  ensureAclIsMutable();
                  acl_.add(m);
                } else {
                  aclBuilder_.addMessage(m);
                }
                break;
              } // case 66
            case 74:
              {
                com.google.storage.v2.ObjectAccessControl m =
                    input.readMessage(
                        com.google.storage.v2.ObjectAccessControl.parser(), extensionRegistry);
                if (defaultObjectAclBuilder_ == null) {
                  ensureDefaultObjectAclIsMutable();
                  defaultObjectAcl_.add(m);
                } else {
                  defaultObjectAclBuilder_.addMessage(m);
                }
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getLifecycleFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 82
            case 90:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00001000;
                break;
              } // case 90
            case 98:
              {
                com.google.storage.v2.Bucket.Cors m =
                    input.readMessage(
                        com.google.storage.v2.Bucket.Cors.parser(), extensionRegistry);
                if (corsBuilder_ == null) {
                  ensureCorsIsMutable();
                  cors_.add(m);
                } else {
                  corsBuilder_.addMessage(m);
                }
                break;
              } // case 98
            case 106:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00004000;
                break;
              } // case 106
            case 112:
              {
                defaultEventBasedHold_ = input.readBool();
                bitField0_ |= 0x00008000;
                break;
              } // case 112
            case 122:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00010000;
                break;
              } // case 122
            case 130:
              {
                input.readMessage(getWebsiteFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00020000;
                break;
              } // case 130
            case 138:
              {
                input.readMessage(getVersioningFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00040000;
                break;
              } // case 138
            case 146:
              {
                input.readMessage(getLoggingFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00080000;
                break;
              } // case 146
            case 154:
              {
                input.readMessage(getOwnerFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00100000;
                break;
              } // case 154
            case 162:
              {
                input.readMessage(getEncryptionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00200000;
                break;
              } // case 162
            case 170:
              {
                input.readMessage(getBillingFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00400000;
                break;
              } // case 170
            case 178:
              {
                input.readMessage(getRetentionPolicyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00800000;
                break;
              } // case 178
            case 186:
              {
                input.readMessage(getIamConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x01000000;
                break;
              } // case 186
            case 200:
              {
                satisfiesPzs_ = input.readBool();
                bitField0_ |= 0x02000000;
                break;
              } // case 200
            case 210:
              {
                input.readMessage(
                    getCustomPlacementConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x04000000;
                break;
              } // case 210
            case 218:
              {
                rpo_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 218
            case 226:
              {
                input.readMessage(getAutoclassFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x08000000;
                break;
              } // case 226
            case 234:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 234
            case 250:
              {
                input.readMessage(
                    getSoftDeletePolicyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x20000000;
                break;
              } // case 250
            case 258:
              {
                input.readMessage(
                    getHierarchicalNamespaceFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x10000000;
                break;
              } // case 258
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. The name of the bucket.
     * Format: `projects/{project}/buckets/{bucket}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The name of the bucket.
     * Format: `projects/{project}/buckets/{bucket}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The name of the bucket.
     * Format: `projects/{project}/buckets/{bucket}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The name of the bucket.
     * Format: `projects/{project}/buckets/{bucket}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The name of the bucket.
     * Format: `projects/{project}/buckets/{bucket}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object bucketId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The user-chosen part of the bucket name. The `{bucket}`
     * portion of the `name` field. For globally unique buckets, this is equal to
     * the "bucket name" of other Cloud Storage APIs. Example: "pub".
     * </pre>
     *
     * <code>string bucket_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bucketId.
     */
    public java.lang.String getBucketId() {
      java.lang.Object ref = bucketId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        bucketId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The user-chosen part of the bucket name. The `{bucket}`
     * portion of the `name` field. For globally unique buckets, this is equal to
     * the "bucket name" of other Cloud Storage APIs. Example: "pub".
     * </pre>
     *
     * <code>string bucket_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for bucketId.
     */
    public com.google.protobuf.ByteString getBucketIdBytes() {
      java.lang.Object ref = bucketId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        bucketId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The user-chosen part of the bucket name. The `{bucket}`
     * portion of the `name` field. For globally unique buckets, this is equal to
     * the "bucket name" of other Cloud Storage APIs. Example: "pub".
     * </pre>
     *
     * <code>string bucket_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bucketId to set.
     * @return This builder for chaining.
     */
    public Builder setBucketId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bucketId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The user-chosen part of the bucket name. The `{bucket}`
     * portion of the `name` field. For globally unique buckets, this is equal to
     * the "bucket name" of other Cloud Storage APIs. Example: "pub".
     * </pre>
     *
     * <code>string bucket_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBucketId() {
      bucketId_ = getDefaultInstance().getBucketId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The user-chosen part of the bucket name. The `{bucket}`
     * portion of the `name` field. For globally unique buckets, this is equal to
     * the "bucket name" of other Cloud Storage APIs. Example: "pub".
     * </pre>
     *
     * <code>string bucket_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for bucketId to set.
     * @return This builder for chaining.
     */
    public Builder setBucketIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      bucketId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object etag_ = "";
    /**
     *
     *
     * <pre>
     * The etag of the bucket.
     * If included in the metadata of an UpdateBucketRequest, the operation will
     * only be performed if the etag matches that of the bucket.
     * </pre>
     *
     * <code>string etag = 29;</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The etag of the bucket.
     * If included in the metadata of an UpdateBucketRequest, the operation will
     * only be performed if the etag matches that of the bucket.
     * </pre>
     *
     * <code>string etag = 29;</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The etag of the bucket.
     * If included in the metadata of an UpdateBucketRequest, the operation will
     * only be performed if the etag matches that of the bucket.
     * </pre>
     *
     * <code>string etag = 29;</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The etag of the bucket.
     * If included in the metadata of an UpdateBucketRequest, the operation will
     * only be performed if the etag matches that of the bucket.
     * </pre>
     *
     * <code>string etag = 29;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The etag of the bucket.
     * If included in the metadata of an UpdateBucketRequest, the operation will
     * only be performed if the etag matches that of the bucket.
     * </pre>
     *
     * <code>string etag = 29;</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object project_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. The project which owns this bucket, in the format of
     * "projects/{projectIdentifier}".
     * {projectIdentifier} can be the project ID or project number.
     * </pre>
     *
     * <code>
     * string project = 3 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The project.
     */
    public java.lang.String getProject() {
      java.lang.Object ref = project_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        project_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The project which owns this bucket, in the format of
     * "projects/{projectIdentifier}".
     * {projectIdentifier} can be the project ID or project number.
     * </pre>
     *
     * <code>
     * string project = 3 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for project.
     */
    public com.google.protobuf.ByteString getProjectBytes() {
      java.lang.Object ref = project_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        project_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The project which owns this bucket, in the format of
     * "projects/{projectIdentifier}".
     * {projectIdentifier} can be the project ID or project number.
     * </pre>
     *
     * <code>
     * string project = 3 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The project to set.
     * @return This builder for chaining.
     */
    public Builder setProject(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      project_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The project which owns this bucket, in the format of
     * "projects/{projectIdentifier}".
     * {projectIdentifier} can be the project ID or project number.
     * </pre>
     *
     * <code>
     * string project = 3 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProject() {
      project_ = getDefaultInstance().getProject();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The project which owns this bucket, in the format of
     * "projects/{projectIdentifier}".
     * {projectIdentifier} can be the project ID or project number.
     * </pre>
     *
     * <code>
     * string project = 3 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for project to set.
     * @return This builder for chaining.
     */
    public Builder setProjectBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      project_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private long metageneration_;
    /**
     *
     *
     * <pre>
     * Output only. The metadata generation of this bucket.
     * </pre>
     *
     * <code>int64 metageneration = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The metageneration.
     */
    @java.lang.Override
    public long getMetageneration() {
      return metageneration_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The metadata generation of this bucket.
     * </pre>
     *
     * <code>int64 metageneration = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The metageneration to set.
     * @return This builder for chaining.
     */
    public Builder setMetageneration(long value) {

      metageneration_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The metadata generation of this bucket.
     * </pre>
     *
     * <code>int64 metageneration = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMetageneration() {
      bitField0_ = (bitField0_ & ~0x00000010);
      metageneration_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object location_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. The location of the bucket. Object data for objects in the
     * bucket resides in physical storage within this region.  Defaults to `US`.
     * See the
     * [https://developers.google.com/storage/docs/concepts-techniques#specifyinglocations"][developer's
     * guide] for the authoritative list. Attempting to update this field after
     * the bucket is created will result in an error.
     * </pre>
     *
     * <code>string location = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The location.
     */
    public java.lang.String getLocation() {
      java.lang.Object ref = location_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        location_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The location of the bucket. Object data for objects in the
     * bucket resides in physical storage within this region.  Defaults to `US`.
     * See the
     * [https://developers.google.com/storage/docs/concepts-techniques#specifyinglocations"][developer's
     * guide] for the authoritative list. Attempting to update this field after
     * the bucket is created will result in an error.
     * </pre>
     *
     * <code>string location = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for location.
     */
    public com.google.protobuf.ByteString getLocationBytes() {
      java.lang.Object ref = location_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        location_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The location of the bucket. Object data for objects in the
     * bucket resides in physical storage within this region.  Defaults to `US`.
     * See the
     * [https://developers.google.com/storage/docs/concepts-techniques#specifyinglocations"][developer's
     * guide] for the authoritative list. Attempting to update this field after
     * the bucket is created will result in an error.
     * </pre>
     *
     * <code>string location = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The location to set.
     * @return This builder for chaining.
     */
    public Builder setLocation(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      location_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The location of the bucket. Object data for objects in the
     * bucket resides in physical storage within this region.  Defaults to `US`.
     * See the
     * [https://developers.google.com/storage/docs/concepts-techniques#specifyinglocations"][developer's
     * guide] for the authoritative list. Attempting to update this field after
     * the bucket is created will result in an error.
     * </pre>
     *
     * <code>string location = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLocation() {
      location_ = getDefaultInstance().getLocation();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The location of the bucket. Object data for objects in the
     * bucket resides in physical storage within this region.  Defaults to `US`.
     * See the
     * [https://developers.google.com/storage/docs/concepts-techniques#specifyinglocations"][developer's
     * guide] for the authoritative list. Attempting to update this field after
     * the bucket is created will result in an error.
     * </pre>
     *
     * <code>string location = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for location to set.
     * @return This builder for chaining.
     */
    public Builder setLocationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      location_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object locationType_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The location type of the bucket (region, dual-region,
     * multi-region, etc).
     * </pre>
     *
     * <code>string location_type = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The locationType.
     */
    public java.lang.String getLocationType() {
      java.lang.Object ref = locationType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        locationType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The location type of the bucket (region, dual-region,
     * multi-region, etc).
     * </pre>
     *
     * <code>string location_type = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for locationType.
     */
    public com.google.protobuf.ByteString getLocationTypeBytes() {
      java.lang.Object ref = locationType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        locationType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The location type of the bucket (region, dual-region,
     * multi-region, etc).
     * </pre>
     *
     * <code>string location_type = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The locationType to set.
     * @return This builder for chaining.
     */
    public Builder setLocationType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      locationType_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The location type of the bucket (region, dual-region,
     * multi-region, etc).
     * </pre>
     *
     * <code>string location_type = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLocationType() {
      locationType_ = getDefaultInstance().getLocationType();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The location type of the bucket (region, dual-region,
     * multi-region, etc).
     * </pre>
     *
     * <code>string location_type = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for locationType to set.
     * @return This builder for chaining.
     */
    public Builder setLocationTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      locationType_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object storageClass_ = "";
    /**
     *
     *
     * <pre>
     * The bucket's default storage class, used whenever no storageClass is
     * specified for a newly-created object. This defines how objects in the
     * bucket are stored and determines the SLA and the cost of storage.
     * If this value is not specified when the bucket is created, it will default
     * to `STANDARD`. For more information, see
     * https://developers.google.com/storage/docs/storage-classes.
     * </pre>
     *
     * <code>string storage_class = 7;</code>
     *
     * @return The storageClass.
     */
    public java.lang.String getStorageClass() {
      java.lang.Object ref = storageClass_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        storageClass_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The bucket's default storage class, used whenever no storageClass is
     * specified for a newly-created object. This defines how objects in the
     * bucket are stored and determines the SLA and the cost of storage.
     * If this value is not specified when the bucket is created, it will default
     * to `STANDARD`. For more information, see
     * https://developers.google.com/storage/docs/storage-classes.
     * </pre>
     *
     * <code>string storage_class = 7;</code>
     *
     * @return The bytes for storageClass.
     */
    public com.google.protobuf.ByteString getStorageClassBytes() {
      java.lang.Object ref = storageClass_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        storageClass_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The bucket's default storage class, used whenever no storageClass is
     * specified for a newly-created object. This defines how objects in the
     * bucket are stored and determines the SLA and the cost of storage.
     * If this value is not specified when the bucket is created, it will default
     * to `STANDARD`. For more information, see
     * https://developers.google.com/storage/docs/storage-classes.
     * </pre>
     *
     * <code>string storage_class = 7;</code>
     *
     * @param value The storageClass to set.
     * @return This builder for chaining.
     */
    public Builder setStorageClass(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      storageClass_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's default storage class, used whenever no storageClass is
     * specified for a newly-created object. This defines how objects in the
     * bucket are stored and determines the SLA and the cost of storage.
     * If this value is not specified when the bucket is created, it will default
     * to `STANDARD`. For more information, see
     * https://developers.google.com/storage/docs/storage-classes.
     * </pre>
     *
     * <code>string storage_class = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStorageClass() {
      storageClass_ = getDefaultInstance().getStorageClass();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's default storage class, used whenever no storageClass is
     * specified for a newly-created object. This defines how objects in the
     * bucket are stored and determines the SLA and the cost of storage.
     * If this value is not specified when the bucket is created, it will default
     * to `STANDARD`. For more information, see
     * https://developers.google.com/storage/docs/storage-classes.
     * </pre>
     *
     * <code>string storage_class = 7;</code>
     *
     * @param value The bytes for storageClass to set.
     * @return This builder for chaining.
     */
    public Builder setStorageClassBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      storageClass_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.lang.Object rpo_ = "";
    /**
     *
     *
     * <pre>
     * The recovery point objective for cross-region replication of the bucket.
     * Applicable only for dual- and multi-region buckets. "DEFAULT" uses default
     * replication. "ASYNC_TURBO" enables turbo replication, valid for dual-region
     * buckets only. If rpo is not specified when the bucket is created, it
     * defaults to "DEFAULT". For more information, see
     * https://cloud.google.com/storage/docs/availability-durability#turbo-replication.
     * </pre>
     *
     * <code>string rpo = 27;</code>
     *
     * @return The rpo.
     */
    public java.lang.String getRpo() {
      java.lang.Object ref = rpo_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        rpo_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The recovery point objective for cross-region replication of the bucket.
     * Applicable only for dual- and multi-region buckets. "DEFAULT" uses default
     * replication. "ASYNC_TURBO" enables turbo replication, valid for dual-region
     * buckets only. If rpo is not specified when the bucket is created, it
     * defaults to "DEFAULT". For more information, see
     * https://cloud.google.com/storage/docs/availability-durability#turbo-replication.
     * </pre>
     *
     * <code>string rpo = 27;</code>
     *
     * @return The bytes for rpo.
     */
    public com.google.protobuf.ByteString getRpoBytes() {
      java.lang.Object ref = rpo_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        rpo_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The recovery point objective for cross-region replication of the bucket.
     * Applicable only for dual- and multi-region buckets. "DEFAULT" uses default
     * replication. "ASYNC_TURBO" enables turbo replication, valid for dual-region
     * buckets only. If rpo is not specified when the bucket is created, it
     * defaults to "DEFAULT". For more information, see
     * https://cloud.google.com/storage/docs/availability-durability#turbo-replication.
     * </pre>
     *
     * <code>string rpo = 27;</code>
     *
     * @param value The rpo to set.
     * @return This builder for chaining.
     */
    public Builder setRpo(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      rpo_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The recovery point objective for cross-region replication of the bucket.
     * Applicable only for dual- and multi-region buckets. "DEFAULT" uses default
     * replication. "ASYNC_TURBO" enables turbo replication, valid for dual-region
     * buckets only. If rpo is not specified when the bucket is created, it
     * defaults to "DEFAULT". For more information, see
     * https://cloud.google.com/storage/docs/availability-durability#turbo-replication.
     * </pre>
     *
     * <code>string rpo = 27;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRpo() {
      rpo_ = getDefaultInstance().getRpo();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The recovery point objective for cross-region replication of the bucket.
     * Applicable only for dual- and multi-region buckets. "DEFAULT" uses default
     * replication. "ASYNC_TURBO" enables turbo replication, valid for dual-region
     * buckets only. If rpo is not specified when the bucket is created, it
     * defaults to "DEFAULT". For more information, see
     * https://cloud.google.com/storage/docs/availability-durability#turbo-replication.
     * </pre>
     *
     * <code>string rpo = 27;</code>
     *
     * @param value The bytes for rpo to set.
     * @return This builder for chaining.
     */
    public Builder setRpoBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      rpo_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private java.util.List<com.google.storage.v2.BucketAccessControl> acl_ =
        java.util.Collections.emptyList();

    private void ensureAclIsMutable() {
      if (!((bitField0_ & 0x00000200) != 0)) {
        acl_ = new java.util.ArrayList<com.google.storage.v2.BucketAccessControl>(acl_);
        bitField0_ |= 0x00000200;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.storage.v2.BucketAccessControl,
            com.google.storage.v2.BucketAccessControl.Builder,
            com.google.storage.v2.BucketAccessControlOrBuilder>
        aclBuilder_;

    /**
     *
     *
     * <pre>
     * Access controls on the bucket.
     * If iam_config.uniform_bucket_level_access is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.BucketAccessControl acl = 8;</code>
     */
    public java.util.List<com.google.storage.v2.BucketAccessControl> getAclList() {
      if (aclBuilder_ == null) {
        return java.util.Collections.unmodifiableList(acl_);
      } else {
        return aclBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Access controls on the bucket.
     * If iam_config.uniform_bucket_level_access is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.BucketAccessControl acl = 8;</code>
     */
    public int getAclCount() {
      if (aclBuilder_ == null) {
        return acl_.size();
      } else {
        return aclBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Access controls on the bucket.
     * If iam_config.uniform_bucket_level_access is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.BucketAccessControl acl = 8;</code>
     */
    public com.google.storage.v2.BucketAccessControl getAcl(int index) {
      if (aclBuilder_ == null) {
        return acl_.get(index);
      } else {
        return aclBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Access controls on the bucket.
     * If iam_config.uniform_bucket_level_access is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.BucketAccessControl acl = 8;</code>
     */
    public Builder setAcl(int index, com.google.storage.v2.BucketAccessControl value) {
      if (aclBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAclIsMutable();
        acl_.set(index, value);
        onChanged();
      } else {
        aclBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Access controls on the bucket.
     * If iam_config.uniform_bucket_level_access is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.BucketAccessControl acl = 8;</code>
     */
    public Builder setAcl(
        int index, com.google.storage.v2.BucketAccessControl.Builder builderForValue) {
      if (aclBuilder_ == null) {
        ensureAclIsMutable();
        acl_.set(index, builderForValue.build());
        onChanged();
      } else {
        aclBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Access controls on the bucket.
     * If iam_config.uniform_bucket_level_access is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.BucketAccessControl acl = 8;</code>
     */
    public Builder addAcl(com.google.storage.v2.BucketAccessControl value) {
      if (aclBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAclIsMutable();
        acl_.add(value);
        onChanged();
      } else {
        aclBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Access controls on the bucket.
     * If iam_config.uniform_bucket_level_access is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.BucketAccessControl acl = 8;</code>
     */
    public Builder addAcl(int index, com.google.storage.v2.BucketAccessControl value) {
      if (aclBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAclIsMutable();
        acl_.add(index, value);
        onChanged();
      } else {
        aclBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Access controls on the bucket.
     * If iam_config.uniform_bucket_level_access is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.BucketAccessControl acl = 8;</code>
     */
    public Builder addAcl(com.google.storage.v2.BucketAccessControl.Builder builderForValue) {
      if (aclBuilder_ == null) {
        ensureAclIsMutable();
        acl_.add(builderForValue.build());
        onChanged();
      } else {
        aclBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Access controls on the bucket.
     * If iam_config.uniform_bucket_level_access is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.BucketAccessControl acl = 8;</code>
     */
    public Builder addAcl(
        int index, com.google.storage.v2.BucketAccessControl.Builder builderForValue) {
      if (aclBuilder_ == null) {
        ensureAclIsMutable();
        acl_.add(index, builderForValue.build());
        onChanged();
      } else {
        aclBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Access controls on the bucket.
     * If iam_config.uniform_bucket_level_access is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.BucketAccessControl acl = 8;</code>
     */
    public Builder addAllAcl(
        java.lang.Iterable<? extends com.google.storage.v2.BucketAccessControl> values) {
      if (aclBuilder_ == null) {
        ensureAclIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, acl_);
        onChanged();
      } else {
        aclBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Access controls on the bucket.
     * If iam_config.uniform_bucket_level_access is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.BucketAccessControl acl = 8;</code>
     */
    public Builder clearAcl() {
      if (aclBuilder_ == null) {
        acl_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000200);
        onChanged();
      } else {
        aclBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Access controls on the bucket.
     * If iam_config.uniform_bucket_level_access is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.BucketAccessControl acl = 8;</code>
     */
    public Builder removeAcl(int index) {
      if (aclBuilder_ == null) {
        ensureAclIsMutable();
        acl_.remove(index);
        onChanged();
      } else {
        aclBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Access controls on the bucket.
     * If iam_config.uniform_bucket_level_access is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.BucketAccessControl acl = 8;</code>
     */
    public com.google.storage.v2.BucketAccessControl.Builder getAclBuilder(int index) {
      return getAclFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Access controls on the bucket.
     * If iam_config.uniform_bucket_level_access is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.BucketAccessControl acl = 8;</code>
     */
    public com.google.storage.v2.BucketAccessControlOrBuilder getAclOrBuilder(int index) {
      if (aclBuilder_ == null) {
        return acl_.get(index);
      } else {
        return aclBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Access controls on the bucket.
     * If iam_config.uniform_bucket_level_access is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.BucketAccessControl acl = 8;</code>
     */
    public java.util.List<? extends com.google.storage.v2.BucketAccessControlOrBuilder>
        getAclOrBuilderList() {
      if (aclBuilder_ != null) {
        return aclBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(acl_);
      }
    }
    /**
     *
     *
     * <pre>
     * Access controls on the bucket.
     * If iam_config.uniform_bucket_level_access is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.BucketAccessControl acl = 8;</code>
     */
    public com.google.storage.v2.BucketAccessControl.Builder addAclBuilder() {
      return getAclFieldBuilder()
          .addBuilder(com.google.storage.v2.BucketAccessControl.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Access controls on the bucket.
     * If iam_config.uniform_bucket_level_access is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.BucketAccessControl acl = 8;</code>
     */
    public com.google.storage.v2.BucketAccessControl.Builder addAclBuilder(int index) {
      return getAclFieldBuilder()
          .addBuilder(index, com.google.storage.v2.BucketAccessControl.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Access controls on the bucket.
     * If iam_config.uniform_bucket_level_access is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.BucketAccessControl acl = 8;</code>
     */
    public java.util.List<com.google.storage.v2.BucketAccessControl.Builder> getAclBuilderList() {
      return getAclFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.storage.v2.BucketAccessControl,
            com.google.storage.v2.BucketAccessControl.Builder,
            com.google.storage.v2.BucketAccessControlOrBuilder>
        getAclFieldBuilder() {
      if (aclBuilder_ == null) {
        aclBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.storage.v2.BucketAccessControl,
                com.google.storage.v2.BucketAccessControl.Builder,
                com.google.storage.v2.BucketAccessControlOrBuilder>(
                acl_, ((bitField0_ & 0x00000200) != 0), getParentForChildren(), isClean());
        acl_ = null;
      }
      return aclBuilder_;
    }

    private java.util.List<com.google.storage.v2.ObjectAccessControl> defaultObjectAcl_ =
        java.util.Collections.emptyList();

    private void ensureDefaultObjectAclIsMutable() {
      if (!((bitField0_ & 0x00000400) != 0)) {
        defaultObjectAcl_ =
            new java.util.ArrayList<com.google.storage.v2.ObjectAccessControl>(defaultObjectAcl_);
        bitField0_ |= 0x00000400;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.storage.v2.ObjectAccessControl,
            com.google.storage.v2.ObjectAccessControl.Builder,
            com.google.storage.v2.ObjectAccessControlOrBuilder>
        defaultObjectAclBuilder_;

    /**
     *
     *
     * <pre>
     * Default access controls to apply to new objects when no ACL is provided.
     * If iam_config.uniform_bucket_level_access is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ObjectAccessControl default_object_acl = 9;</code>
     */
    public java.util.List<com.google.storage.v2.ObjectAccessControl> getDefaultObjectAclList() {
      if (defaultObjectAclBuilder_ == null) {
        return java.util.Collections.unmodifiableList(defaultObjectAcl_);
      } else {
        return defaultObjectAclBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Default access controls to apply to new objects when no ACL is provided.
     * If iam_config.uniform_bucket_level_access is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ObjectAccessControl default_object_acl = 9;</code>
     */
    public int getDefaultObjectAclCount() {
      if (defaultObjectAclBuilder_ == null) {
        return defaultObjectAcl_.size();
      } else {
        return defaultObjectAclBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Default access controls to apply to new objects when no ACL is provided.
     * If iam_config.uniform_bucket_level_access is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ObjectAccessControl default_object_acl = 9;</code>
     */
    public com.google.storage.v2.ObjectAccessControl getDefaultObjectAcl(int index) {
      if (defaultObjectAclBuilder_ == null) {
        return defaultObjectAcl_.get(index);
      } else {
        return defaultObjectAclBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Default access controls to apply to new objects when no ACL is provided.
     * If iam_config.uniform_bucket_level_access is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ObjectAccessControl default_object_acl = 9;</code>
     */
    public Builder setDefaultObjectAcl(int index, com.google.storage.v2.ObjectAccessControl value) {
      if (defaultObjectAclBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDefaultObjectAclIsMutable();
        defaultObjectAcl_.set(index, value);
        onChanged();
      } else {
        defaultObjectAclBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Default access controls to apply to new objects when no ACL is provided.
     * If iam_config.uniform_bucket_level_access is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ObjectAccessControl default_object_acl = 9;</code>
     */
    public Builder setDefaultObjectAcl(
        int index, com.google.storage.v2.ObjectAccessControl.Builder builderForValue) {
      if (defaultObjectAclBuilder_ == null) {
        ensureDefaultObjectAclIsMutable();
        defaultObjectAcl_.set(index, builderForValue.build());
        onChanged();
      } else {
        defaultObjectAclBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Default access controls to apply to new objects when no ACL is provided.
     * If iam_config.uniform_bucket_level_access is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ObjectAccessControl default_object_acl = 9;</code>
     */
    public Builder addDefaultObjectAcl(com.google.storage.v2.ObjectAccessControl value) {
      if (defaultObjectAclBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDefaultObjectAclIsMutable();
        defaultObjectAcl_.add(value);
        onChanged();
      } else {
        defaultObjectAclBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Default access controls to apply to new objects when no ACL is provided.
     * If iam_config.uniform_bucket_level_access is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ObjectAccessControl default_object_acl = 9;</code>
     */
    public Builder addDefaultObjectAcl(int index, com.google.storage.v2.ObjectAccessControl value) {
      if (defaultObjectAclBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDefaultObjectAclIsMutable();
        defaultObjectAcl_.add(index, value);
        onChanged();
      } else {
        defaultObjectAclBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Default access controls to apply to new objects when no ACL is provided.
     * If iam_config.uniform_bucket_level_access is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ObjectAccessControl default_object_acl = 9;</code>
     */
    public Builder addDefaultObjectAcl(
        com.google.storage.v2.ObjectAccessControl.Builder builderForValue) {
      if (defaultObjectAclBuilder_ == null) {
        ensureDefaultObjectAclIsMutable();
        defaultObjectAcl_.add(builderForValue.build());
        onChanged();
      } else {
        defaultObjectAclBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Default access controls to apply to new objects when no ACL is provided.
     * If iam_config.uniform_bucket_level_access is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ObjectAccessControl default_object_acl = 9;</code>
     */
    public Builder addDefaultObjectAcl(
        int index, com.google.storage.v2.ObjectAccessControl.Builder builderForValue) {
      if (defaultObjectAclBuilder_ == null) {
        ensureDefaultObjectAclIsMutable();
        defaultObjectAcl_.add(index, builderForValue.build());
        onChanged();
      } else {
        defaultObjectAclBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Default access controls to apply to new objects when no ACL is provided.
     * If iam_config.uniform_bucket_level_access is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ObjectAccessControl default_object_acl = 9;</code>
     */
    public Builder addAllDefaultObjectAcl(
        java.lang.Iterable<? extends com.google.storage.v2.ObjectAccessControl> values) {
      if (defaultObjectAclBuilder_ == null) {
        ensureDefaultObjectAclIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, defaultObjectAcl_);
        onChanged();
      } else {
        defaultObjectAclBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Default access controls to apply to new objects when no ACL is provided.
     * If iam_config.uniform_bucket_level_access is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ObjectAccessControl default_object_acl = 9;</code>
     */
    public Builder clearDefaultObjectAcl() {
      if (defaultObjectAclBuilder_ == null) {
        defaultObjectAcl_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000400);
        onChanged();
      } else {
        defaultObjectAclBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Default access controls to apply to new objects when no ACL is provided.
     * If iam_config.uniform_bucket_level_access is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ObjectAccessControl default_object_acl = 9;</code>
     */
    public Builder removeDefaultObjectAcl(int index) {
      if (defaultObjectAclBuilder_ == null) {
        ensureDefaultObjectAclIsMutable();
        defaultObjectAcl_.remove(index);
        onChanged();
      } else {
        defaultObjectAclBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Default access controls to apply to new objects when no ACL is provided.
     * If iam_config.uniform_bucket_level_access is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ObjectAccessControl default_object_acl = 9;</code>
     */
    public com.google.storage.v2.ObjectAccessControl.Builder getDefaultObjectAclBuilder(int index) {
      return getDefaultObjectAclFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Default access controls to apply to new objects when no ACL is provided.
     * If iam_config.uniform_bucket_level_access is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ObjectAccessControl default_object_acl = 9;</code>
     */
    public com.google.storage.v2.ObjectAccessControlOrBuilder getDefaultObjectAclOrBuilder(
        int index) {
      if (defaultObjectAclBuilder_ == null) {
        return defaultObjectAcl_.get(index);
      } else {
        return defaultObjectAclBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Default access controls to apply to new objects when no ACL is provided.
     * If iam_config.uniform_bucket_level_access is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ObjectAccessControl default_object_acl = 9;</code>
     */
    public java.util.List<? extends com.google.storage.v2.ObjectAccessControlOrBuilder>
        getDefaultObjectAclOrBuilderList() {
      if (defaultObjectAclBuilder_ != null) {
        return defaultObjectAclBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(defaultObjectAcl_);
      }
    }
    /**
     *
     *
     * <pre>
     * Default access controls to apply to new objects when no ACL is provided.
     * If iam_config.uniform_bucket_level_access is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ObjectAccessControl default_object_acl = 9;</code>
     */
    public com.google.storage.v2.ObjectAccessControl.Builder addDefaultObjectAclBuilder() {
      return getDefaultObjectAclFieldBuilder()
          .addBuilder(com.google.storage.v2.ObjectAccessControl.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Default access controls to apply to new objects when no ACL is provided.
     * If iam_config.uniform_bucket_level_access is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ObjectAccessControl default_object_acl = 9;</code>
     */
    public com.google.storage.v2.ObjectAccessControl.Builder addDefaultObjectAclBuilder(int index) {
      return getDefaultObjectAclFieldBuilder()
          .addBuilder(index, com.google.storage.v2.ObjectAccessControl.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Default access controls to apply to new objects when no ACL is provided.
     * If iam_config.uniform_bucket_level_access is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ObjectAccessControl default_object_acl = 9;</code>
     */
    public java.util.List<com.google.storage.v2.ObjectAccessControl.Builder>
        getDefaultObjectAclBuilderList() {
      return getDefaultObjectAclFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.storage.v2.ObjectAccessControl,
            com.google.storage.v2.ObjectAccessControl.Builder,
            com.google.storage.v2.ObjectAccessControlOrBuilder>
        getDefaultObjectAclFieldBuilder() {
      if (defaultObjectAclBuilder_ == null) {
        defaultObjectAclBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.storage.v2.ObjectAccessControl,
                com.google.storage.v2.ObjectAccessControl.Builder,
                com.google.storage.v2.ObjectAccessControlOrBuilder>(
                defaultObjectAcl_,
                ((bitField0_ & 0x00000400) != 0),
                getParentForChildren(),
                isClean());
        defaultObjectAcl_ = null;
      }
      return defaultObjectAclBuilder_;
    }

    private com.google.storage.v2.Bucket.Lifecycle lifecycle_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Bucket.Lifecycle,
            com.google.storage.v2.Bucket.Lifecycle.Builder,
            com.google.storage.v2.Bucket.LifecycleOrBuilder>
        lifecycleBuilder_;
    /**
     *
     *
     * <pre>
     * The bucket's lifecycle config. See
     * [https://developers.google.com/storage/docs/lifecycle]Lifecycle Management]
     * for more information.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Lifecycle lifecycle = 10;</code>
     *
     * @return Whether the lifecycle field is set.
     */
    public boolean hasLifecycle() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * The bucket's lifecycle config. See
     * [https://developers.google.com/storage/docs/lifecycle]Lifecycle Management]
     * for more information.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Lifecycle lifecycle = 10;</code>
     *
     * @return The lifecycle.
     */
    public com.google.storage.v2.Bucket.Lifecycle getLifecycle() {
      if (lifecycleBuilder_ == null) {
        return lifecycle_ == null
            ? com.google.storage.v2.Bucket.Lifecycle.getDefaultInstance()
            : lifecycle_;
      } else {
        return lifecycleBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The bucket's lifecycle config. See
     * [https://developers.google.com/storage/docs/lifecycle]Lifecycle Management]
     * for more information.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Lifecycle lifecycle = 10;</code>
     */
    public Builder setLifecycle(com.google.storage.v2.Bucket.Lifecycle value) {
      if (lifecycleBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        lifecycle_ = value;
      } else {
        lifecycleBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's lifecycle config. See
     * [https://developers.google.com/storage/docs/lifecycle]Lifecycle Management]
     * for more information.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Lifecycle lifecycle = 10;</code>
     */
    public Builder setLifecycle(com.google.storage.v2.Bucket.Lifecycle.Builder builderForValue) {
      if (lifecycleBuilder_ == null) {
        lifecycle_ = builderForValue.build();
      } else {
        lifecycleBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's lifecycle config. See
     * [https://developers.google.com/storage/docs/lifecycle]Lifecycle Management]
     * for more information.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Lifecycle lifecycle = 10;</code>
     */
    public Builder mergeLifecycle(com.google.storage.v2.Bucket.Lifecycle value) {
      if (lifecycleBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && lifecycle_ != null
            && lifecycle_ != com.google.storage.v2.Bucket.Lifecycle.getDefaultInstance()) {
          getLifecycleBuilder().mergeFrom(value);
        } else {
          lifecycle_ = value;
        }
      } else {
        lifecycleBuilder_.mergeFrom(value);
      }
      if (lifecycle_ != null) {
        bitField0_ |= 0x00000800;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's lifecycle config. See
     * [https://developers.google.com/storage/docs/lifecycle]Lifecycle Management]
     * for more information.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Lifecycle lifecycle = 10;</code>
     */
    public Builder clearLifecycle() {
      bitField0_ = (bitField0_ & ~0x00000800);
      lifecycle_ = null;
      if (lifecycleBuilder_ != null) {
        lifecycleBuilder_.dispose();
        lifecycleBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's lifecycle config. See
     * [https://developers.google.com/storage/docs/lifecycle]Lifecycle Management]
     * for more information.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Lifecycle lifecycle = 10;</code>
     */
    public com.google.storage.v2.Bucket.Lifecycle.Builder getLifecycleBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getLifecycleFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The bucket's lifecycle config. See
     * [https://developers.google.com/storage/docs/lifecycle]Lifecycle Management]
     * for more information.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Lifecycle lifecycle = 10;</code>
     */
    public com.google.storage.v2.Bucket.LifecycleOrBuilder getLifecycleOrBuilder() {
      if (lifecycleBuilder_ != null) {
        return lifecycleBuilder_.getMessageOrBuilder();
      } else {
        return lifecycle_ == null
            ? com.google.storage.v2.Bucket.Lifecycle.getDefaultInstance()
            : lifecycle_;
      }
    }
    /**
     *
     *
     * <pre>
     * The bucket's lifecycle config. See
     * [https://developers.google.com/storage/docs/lifecycle]Lifecycle Management]
     * for more information.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Lifecycle lifecycle = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Bucket.Lifecycle,
            com.google.storage.v2.Bucket.Lifecycle.Builder,
            com.google.storage.v2.Bucket.LifecycleOrBuilder>
        getLifecycleFieldBuilder() {
      if (lifecycleBuilder_ == null) {
        lifecycleBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.Bucket.Lifecycle,
                com.google.storage.v2.Bucket.Lifecycle.Builder,
                com.google.storage.v2.Bucket.LifecycleOrBuilder>(
                getLifecycle(), getParentForChildren(), isClean());
        lifecycle_ = null;
      }
      return lifecycleBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The creation time of the bucket.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time of the bucket.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time of the bucket.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time of the bucket.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time of the bucket.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00001000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time of the bucket.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00001000);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time of the bucket.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00001000;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time of the bucket.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time of the bucket.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private java.util.List<com.google.storage.v2.Bucket.Cors> cors_ =
        java.util.Collections.emptyList();

    private void ensureCorsIsMutable() {
      if (!((bitField0_ & 0x00002000) != 0)) {
        cors_ = new java.util.ArrayList<com.google.storage.v2.Bucket.Cors>(cors_);
        bitField0_ |= 0x00002000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.storage.v2.Bucket.Cors,
            com.google.storage.v2.Bucket.Cors.Builder,
            com.google.storage.v2.Bucket.CorsOrBuilder>
        corsBuilder_;

    /**
     *
     *
     * <pre>
     * The bucket's [https://www.w3.org/TR/cors/][Cross-Origin Resource Sharing]
     * (CORS) config.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket.Cors cors = 12;</code>
     */
    public java.util.List<com.google.storage.v2.Bucket.Cors> getCorsList() {
      if (corsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(cors_);
      } else {
        return corsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The bucket's [https://www.w3.org/TR/cors/][Cross-Origin Resource Sharing]
     * (CORS) config.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket.Cors cors = 12;</code>
     */
    public int getCorsCount() {
      if (corsBuilder_ == null) {
        return cors_.size();
      } else {
        return corsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The bucket's [https://www.w3.org/TR/cors/][Cross-Origin Resource Sharing]
     * (CORS) config.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket.Cors cors = 12;</code>
     */
    public com.google.storage.v2.Bucket.Cors getCors(int index) {
      if (corsBuilder_ == null) {
        return cors_.get(index);
      } else {
        return corsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The bucket's [https://www.w3.org/TR/cors/][Cross-Origin Resource Sharing]
     * (CORS) config.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket.Cors cors = 12;</code>
     */
    public Builder setCors(int index, com.google.storage.v2.Bucket.Cors value) {
      if (corsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCorsIsMutable();
        cors_.set(index, value);
        onChanged();
      } else {
        corsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's [https://www.w3.org/TR/cors/][Cross-Origin Resource Sharing]
     * (CORS) config.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket.Cors cors = 12;</code>
     */
    public Builder setCors(int index, com.google.storage.v2.Bucket.Cors.Builder builderForValue) {
      if (corsBuilder_ == null) {
        ensureCorsIsMutable();
        cors_.set(index, builderForValue.build());
        onChanged();
      } else {
        corsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's [https://www.w3.org/TR/cors/][Cross-Origin Resource Sharing]
     * (CORS) config.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket.Cors cors = 12;</code>
     */
    public Builder addCors(com.google.storage.v2.Bucket.Cors value) {
      if (corsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCorsIsMutable();
        cors_.add(value);
        onChanged();
      } else {
        corsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's [https://www.w3.org/TR/cors/][Cross-Origin Resource Sharing]
     * (CORS) config.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket.Cors cors = 12;</code>
     */
    public Builder addCors(int index, com.google.storage.v2.Bucket.Cors value) {
      if (corsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCorsIsMutable();
        cors_.add(index, value);
        onChanged();
      } else {
        corsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's [https://www.w3.org/TR/cors/][Cross-Origin Resource Sharing]
     * (CORS) config.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket.Cors cors = 12;</code>
     */
    public Builder addCors(com.google.storage.v2.Bucket.Cors.Builder builderForValue) {
      if (corsBuilder_ == null) {
        ensureCorsIsMutable();
        cors_.add(builderForValue.build());
        onChanged();
      } else {
        corsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's [https://www.w3.org/TR/cors/][Cross-Origin Resource Sharing]
     * (CORS) config.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket.Cors cors = 12;</code>
     */
    public Builder addCors(int index, com.google.storage.v2.Bucket.Cors.Builder builderForValue) {
      if (corsBuilder_ == null) {
        ensureCorsIsMutable();
        cors_.add(index, builderForValue.build());
        onChanged();
      } else {
        corsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's [https://www.w3.org/TR/cors/][Cross-Origin Resource Sharing]
     * (CORS) config.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket.Cors cors = 12;</code>
     */
    public Builder addAllCors(
        java.lang.Iterable<? extends com.google.storage.v2.Bucket.Cors> values) {
      if (corsBuilder_ == null) {
        ensureCorsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, cors_);
        onChanged();
      } else {
        corsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's [https://www.w3.org/TR/cors/][Cross-Origin Resource Sharing]
     * (CORS) config.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket.Cors cors = 12;</code>
     */
    public Builder clearCors() {
      if (corsBuilder_ == null) {
        cors_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00002000);
        onChanged();
      } else {
        corsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's [https://www.w3.org/TR/cors/][Cross-Origin Resource Sharing]
     * (CORS) config.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket.Cors cors = 12;</code>
     */
    public Builder removeCors(int index) {
      if (corsBuilder_ == null) {
        ensureCorsIsMutable();
        cors_.remove(index);
        onChanged();
      } else {
        corsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's [https://www.w3.org/TR/cors/][Cross-Origin Resource Sharing]
     * (CORS) config.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket.Cors cors = 12;</code>
     */
    public com.google.storage.v2.Bucket.Cors.Builder getCorsBuilder(int index) {
      return getCorsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The bucket's [https://www.w3.org/TR/cors/][Cross-Origin Resource Sharing]
     * (CORS) config.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket.Cors cors = 12;</code>
     */
    public com.google.storage.v2.Bucket.CorsOrBuilder getCorsOrBuilder(int index) {
      if (corsBuilder_ == null) {
        return cors_.get(index);
      } else {
        return corsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The bucket's [https://www.w3.org/TR/cors/][Cross-Origin Resource Sharing]
     * (CORS) config.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket.Cors cors = 12;</code>
     */
    public java.util.List<? extends com.google.storage.v2.Bucket.CorsOrBuilder>
        getCorsOrBuilderList() {
      if (corsBuilder_ != null) {
        return corsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(cors_);
      }
    }
    /**
     *
     *
     * <pre>
     * The bucket's [https://www.w3.org/TR/cors/][Cross-Origin Resource Sharing]
     * (CORS) config.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket.Cors cors = 12;</code>
     */
    public com.google.storage.v2.Bucket.Cors.Builder addCorsBuilder() {
      return getCorsFieldBuilder()
          .addBuilder(com.google.storage.v2.Bucket.Cors.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The bucket's [https://www.w3.org/TR/cors/][Cross-Origin Resource Sharing]
     * (CORS) config.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket.Cors cors = 12;</code>
     */
    public com.google.storage.v2.Bucket.Cors.Builder addCorsBuilder(int index) {
      return getCorsFieldBuilder()
          .addBuilder(index, com.google.storage.v2.Bucket.Cors.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The bucket's [https://www.w3.org/TR/cors/][Cross-Origin Resource Sharing]
     * (CORS) config.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket.Cors cors = 12;</code>
     */
    public java.util.List<com.google.storage.v2.Bucket.Cors.Builder> getCorsBuilderList() {
      return getCorsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.storage.v2.Bucket.Cors,
            com.google.storage.v2.Bucket.Cors.Builder,
            com.google.storage.v2.Bucket.CorsOrBuilder>
        getCorsFieldBuilder() {
      if (corsBuilder_ == null) {
        corsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.storage.v2.Bucket.Cors,
                com.google.storage.v2.Bucket.Cors.Builder,
                com.google.storage.v2.Bucket.CorsOrBuilder>(
                cors_, ((bitField0_ & 0x00002000) != 0), getParentForChildren(), isClean());
        cors_ = null;
      }
      return corsBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The modification time of the bucket.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00004000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The modification time of the bucket.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The modification time of the bucket.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The modification time of the bucket.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The modification time of the bucket.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00004000) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00004000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The modification time of the bucket.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00004000);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The modification time of the bucket.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00004000;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The modification time of the bucket.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The modification time of the bucket.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private boolean defaultEventBasedHold_;
    /**
     *
     *
     * <pre>
     * The default value for event-based hold on newly created objects in this
     * bucket.  Event-based hold is a way to retain objects indefinitely until an
     * event occurs, signified by the
     * hold's release. After being released, such objects will be subject to
     * bucket-level retention (if any).  One sample use case of this flag is for
     * banks to hold loan documents for at least 3 years after loan is paid in
     * full. Here, bucket-level retention is 3 years and the event is loan being
     * paid in full. In this example, these objects will be held intact for any
     * number of years until the event has occurred (event-based hold on the
     * object is released) and then 3 more years after that. That means retention
     * duration of the objects begins from the moment event-based hold
     * transitioned from true to false.  Objects under event-based hold cannot be
     * deleted, overwritten or archived until the hold is removed.
     * </pre>
     *
     * <code>bool default_event_based_hold = 14;</code>
     *
     * @return The defaultEventBasedHold.
     */
    @java.lang.Override
    public boolean getDefaultEventBasedHold() {
      return defaultEventBasedHold_;
    }
    /**
     *
     *
     * <pre>
     * The default value for event-based hold on newly created objects in this
     * bucket.  Event-based hold is a way to retain objects indefinitely until an
     * event occurs, signified by the
     * hold's release. After being released, such objects will be subject to
     * bucket-level retention (if any).  One sample use case of this flag is for
     * banks to hold loan documents for at least 3 years after loan is paid in
     * full. Here, bucket-level retention is 3 years and the event is loan being
     * paid in full. In this example, these objects will be held intact for any
     * number of years until the event has occurred (event-based hold on the
     * object is released) and then 3 more years after that. That means retention
     * duration of the objects begins from the moment event-based hold
     * transitioned from true to false.  Objects under event-based hold cannot be
     * deleted, overwritten or archived until the hold is removed.
     * </pre>
     *
     * <code>bool default_event_based_hold = 14;</code>
     *
     * @param value The defaultEventBasedHold to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultEventBasedHold(boolean value) {

      defaultEventBasedHold_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The default value for event-based hold on newly created objects in this
     * bucket.  Event-based hold is a way to retain objects indefinitely until an
     * event occurs, signified by the
     * hold's release. After being released, such objects will be subject to
     * bucket-level retention (if any).  One sample use case of this flag is for
     * banks to hold loan documents for at least 3 years after loan is paid in
     * full. Here, bucket-level retention is 3 years and the event is loan being
     * paid in full. In this example, these objects will be held intact for any
     * number of years until the event has occurred (event-based hold on the
     * object is released) and then 3 more years after that. That means retention
     * duration of the objects begins from the moment event-based hold
     * transitioned from true to false.  Objects under event-based hold cannot be
     * deleted, overwritten or archived until the hold is removed.
     * </pre>
     *
     * <code>bool default_event_based_hold = 14;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDefaultEventBasedHold() {
      bitField0_ = (bitField0_ & ~0x00008000);
      defaultEventBasedHold_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * User-provided labels, in key/value pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 15;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * User-provided labels, in key/value pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 15;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * User-provided labels, in key/value pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 15;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * User-provided labels, in key/value pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 15;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00010000);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-provided labels, in key/value pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 15;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00010000;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * User-provided labels, in key/value pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 15;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00010000;
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-provided labels, in key/value pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 15;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00010000;
      return this;
    }

    private com.google.storage.v2.Bucket.Website website_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Bucket.Website,
            com.google.storage.v2.Bucket.Website.Builder,
            com.google.storage.v2.Bucket.WebsiteOrBuilder>
        websiteBuilder_;
    /**
     *
     *
     * <pre>
     * The bucket's website config, controlling how the service behaves
     * when accessing bucket contents as a web site. See the
     * [https://cloud.google.com/storage/docs/static-website][Static Website
     * Examples] for more information.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Website website = 16;</code>
     *
     * @return Whether the website field is set.
     */
    public boolean hasWebsite() {
      return ((bitField0_ & 0x00020000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The bucket's website config, controlling how the service behaves
     * when accessing bucket contents as a web site. See the
     * [https://cloud.google.com/storage/docs/static-website][Static Website
     * Examples] for more information.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Website website = 16;</code>
     *
     * @return The website.
     */
    public com.google.storage.v2.Bucket.Website getWebsite() {
      if (websiteBuilder_ == null) {
        return website_ == null
            ? com.google.storage.v2.Bucket.Website.getDefaultInstance()
            : website_;
      } else {
        return websiteBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The bucket's website config, controlling how the service behaves
     * when accessing bucket contents as a web site. See the
     * [https://cloud.google.com/storage/docs/static-website][Static Website
     * Examples] for more information.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Website website = 16;</code>
     */
    public Builder setWebsite(com.google.storage.v2.Bucket.Website value) {
      if (websiteBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        website_ = value;
      } else {
        websiteBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's website config, controlling how the service behaves
     * when accessing bucket contents as a web site. See the
     * [https://cloud.google.com/storage/docs/static-website][Static Website
     * Examples] for more information.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Website website = 16;</code>
     */
    public Builder setWebsite(com.google.storage.v2.Bucket.Website.Builder builderForValue) {
      if (websiteBuilder_ == null) {
        website_ = builderForValue.build();
      } else {
        websiteBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's website config, controlling how the service behaves
     * when accessing bucket contents as a web site. See the
     * [https://cloud.google.com/storage/docs/static-website][Static Website
     * Examples] for more information.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Website website = 16;</code>
     */
    public Builder mergeWebsite(com.google.storage.v2.Bucket.Website value) {
      if (websiteBuilder_ == null) {
        if (((bitField0_ & 0x00020000) != 0)
            && website_ != null
            && website_ != com.google.storage.v2.Bucket.Website.getDefaultInstance()) {
          getWebsiteBuilder().mergeFrom(value);
        } else {
          website_ = value;
        }
      } else {
        websiteBuilder_.mergeFrom(value);
      }
      if (website_ != null) {
        bitField0_ |= 0x00020000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's website config, controlling how the service behaves
     * when accessing bucket contents as a web site. See the
     * [https://cloud.google.com/storage/docs/static-website][Static Website
     * Examples] for more information.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Website website = 16;</code>
     */
    public Builder clearWebsite() {
      bitField0_ = (bitField0_ & ~0x00020000);
      website_ = null;
      if (websiteBuilder_ != null) {
        websiteBuilder_.dispose();
        websiteBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's website config, controlling how the service behaves
     * when accessing bucket contents as a web site. See the
     * [https://cloud.google.com/storage/docs/static-website][Static Website
     * Examples] for more information.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Website website = 16;</code>
     */
    public com.google.storage.v2.Bucket.Website.Builder getWebsiteBuilder() {
      bitField0_ |= 0x00020000;
      onChanged();
      return getWebsiteFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The bucket's website config, controlling how the service behaves
     * when accessing bucket contents as a web site. See the
     * [https://cloud.google.com/storage/docs/static-website][Static Website
     * Examples] for more information.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Website website = 16;</code>
     */
    public com.google.storage.v2.Bucket.WebsiteOrBuilder getWebsiteOrBuilder() {
      if (websiteBuilder_ != null) {
        return websiteBuilder_.getMessageOrBuilder();
      } else {
        return website_ == null
            ? com.google.storage.v2.Bucket.Website.getDefaultInstance()
            : website_;
      }
    }
    /**
     *
     *
     * <pre>
     * The bucket's website config, controlling how the service behaves
     * when accessing bucket contents as a web site. See the
     * [https://cloud.google.com/storage/docs/static-website][Static Website
     * Examples] for more information.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Website website = 16;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Bucket.Website,
            com.google.storage.v2.Bucket.Website.Builder,
            com.google.storage.v2.Bucket.WebsiteOrBuilder>
        getWebsiteFieldBuilder() {
      if (websiteBuilder_ == null) {
        websiteBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.Bucket.Website,
                com.google.storage.v2.Bucket.Website.Builder,
                com.google.storage.v2.Bucket.WebsiteOrBuilder>(
                getWebsite(), getParentForChildren(), isClean());
        website_ = null;
      }
      return websiteBuilder_;
    }

    private com.google.storage.v2.Bucket.Versioning versioning_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Bucket.Versioning,
            com.google.storage.v2.Bucket.Versioning.Builder,
            com.google.storage.v2.Bucket.VersioningOrBuilder>
        versioningBuilder_;
    /**
     *
     *
     * <pre>
     * The bucket's versioning config.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Versioning versioning = 17;</code>
     *
     * @return Whether the versioning field is set.
     */
    public boolean hasVersioning() {
      return ((bitField0_ & 0x00040000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The bucket's versioning config.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Versioning versioning = 17;</code>
     *
     * @return The versioning.
     */
    public com.google.storage.v2.Bucket.Versioning getVersioning() {
      if (versioningBuilder_ == null) {
        return versioning_ == null
            ? com.google.storage.v2.Bucket.Versioning.getDefaultInstance()
            : versioning_;
      } else {
        return versioningBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The bucket's versioning config.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Versioning versioning = 17;</code>
     */
    public Builder setVersioning(com.google.storage.v2.Bucket.Versioning value) {
      if (versioningBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        versioning_ = value;
      } else {
        versioningBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's versioning config.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Versioning versioning = 17;</code>
     */
    public Builder setVersioning(com.google.storage.v2.Bucket.Versioning.Builder builderForValue) {
      if (versioningBuilder_ == null) {
        versioning_ = builderForValue.build();
      } else {
        versioningBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's versioning config.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Versioning versioning = 17;</code>
     */
    public Builder mergeVersioning(com.google.storage.v2.Bucket.Versioning value) {
      if (versioningBuilder_ == null) {
        if (((bitField0_ & 0x00040000) != 0)
            && versioning_ != null
            && versioning_ != com.google.storage.v2.Bucket.Versioning.getDefaultInstance()) {
          getVersioningBuilder().mergeFrom(value);
        } else {
          versioning_ = value;
        }
      } else {
        versioningBuilder_.mergeFrom(value);
      }
      if (versioning_ != null) {
        bitField0_ |= 0x00040000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's versioning config.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Versioning versioning = 17;</code>
     */
    public Builder clearVersioning() {
      bitField0_ = (bitField0_ & ~0x00040000);
      versioning_ = null;
      if (versioningBuilder_ != null) {
        versioningBuilder_.dispose();
        versioningBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's versioning config.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Versioning versioning = 17;</code>
     */
    public com.google.storage.v2.Bucket.Versioning.Builder getVersioningBuilder() {
      bitField0_ |= 0x00040000;
      onChanged();
      return getVersioningFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The bucket's versioning config.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Versioning versioning = 17;</code>
     */
    public com.google.storage.v2.Bucket.VersioningOrBuilder getVersioningOrBuilder() {
      if (versioningBuilder_ != null) {
        return versioningBuilder_.getMessageOrBuilder();
      } else {
        return versioning_ == null
            ? com.google.storage.v2.Bucket.Versioning.getDefaultInstance()
            : versioning_;
      }
    }
    /**
     *
     *
     * <pre>
     * The bucket's versioning config.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Versioning versioning = 17;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Bucket.Versioning,
            com.google.storage.v2.Bucket.Versioning.Builder,
            com.google.storage.v2.Bucket.VersioningOrBuilder>
        getVersioningFieldBuilder() {
      if (versioningBuilder_ == null) {
        versioningBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.Bucket.Versioning,
                com.google.storage.v2.Bucket.Versioning.Builder,
                com.google.storage.v2.Bucket.VersioningOrBuilder>(
                getVersioning(), getParentForChildren(), isClean());
        versioning_ = null;
      }
      return versioningBuilder_;
    }

    private com.google.storage.v2.Bucket.Logging logging_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Bucket.Logging,
            com.google.storage.v2.Bucket.Logging.Builder,
            com.google.storage.v2.Bucket.LoggingOrBuilder>
        loggingBuilder_;
    /**
     *
     *
     * <pre>
     * The bucket's logging config, which defines the destination bucket
     * and name prefix (if any) for the current bucket's logs.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Logging logging = 18;</code>
     *
     * @return Whether the logging field is set.
     */
    public boolean hasLogging() {
      return ((bitField0_ & 0x00080000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The bucket's logging config, which defines the destination bucket
     * and name prefix (if any) for the current bucket's logs.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Logging logging = 18;</code>
     *
     * @return The logging.
     */
    public com.google.storage.v2.Bucket.Logging getLogging() {
      if (loggingBuilder_ == null) {
        return logging_ == null
            ? com.google.storage.v2.Bucket.Logging.getDefaultInstance()
            : logging_;
      } else {
        return loggingBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The bucket's logging config, which defines the destination bucket
     * and name prefix (if any) for the current bucket's logs.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Logging logging = 18;</code>
     */
    public Builder setLogging(com.google.storage.v2.Bucket.Logging value) {
      if (loggingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        logging_ = value;
      } else {
        loggingBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's logging config, which defines the destination bucket
     * and name prefix (if any) for the current bucket's logs.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Logging logging = 18;</code>
     */
    public Builder setLogging(com.google.storage.v2.Bucket.Logging.Builder builderForValue) {
      if (loggingBuilder_ == null) {
        logging_ = builderForValue.build();
      } else {
        loggingBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's logging config, which defines the destination bucket
     * and name prefix (if any) for the current bucket's logs.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Logging logging = 18;</code>
     */
    public Builder mergeLogging(com.google.storage.v2.Bucket.Logging value) {
      if (loggingBuilder_ == null) {
        if (((bitField0_ & 0x00080000) != 0)
            && logging_ != null
            && logging_ != com.google.storage.v2.Bucket.Logging.getDefaultInstance()) {
          getLoggingBuilder().mergeFrom(value);
        } else {
          logging_ = value;
        }
      } else {
        loggingBuilder_.mergeFrom(value);
      }
      if (logging_ != null) {
        bitField0_ |= 0x00080000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's logging config, which defines the destination bucket
     * and name prefix (if any) for the current bucket's logs.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Logging logging = 18;</code>
     */
    public Builder clearLogging() {
      bitField0_ = (bitField0_ & ~0x00080000);
      logging_ = null;
      if (loggingBuilder_ != null) {
        loggingBuilder_.dispose();
        loggingBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's logging config, which defines the destination bucket
     * and name prefix (if any) for the current bucket's logs.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Logging logging = 18;</code>
     */
    public com.google.storage.v2.Bucket.Logging.Builder getLoggingBuilder() {
      bitField0_ |= 0x00080000;
      onChanged();
      return getLoggingFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The bucket's logging config, which defines the destination bucket
     * and name prefix (if any) for the current bucket's logs.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Logging logging = 18;</code>
     */
    public com.google.storage.v2.Bucket.LoggingOrBuilder getLoggingOrBuilder() {
      if (loggingBuilder_ != null) {
        return loggingBuilder_.getMessageOrBuilder();
      } else {
        return logging_ == null
            ? com.google.storage.v2.Bucket.Logging.getDefaultInstance()
            : logging_;
      }
    }
    /**
     *
     *
     * <pre>
     * The bucket's logging config, which defines the destination bucket
     * and name prefix (if any) for the current bucket's logs.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Logging logging = 18;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Bucket.Logging,
            com.google.storage.v2.Bucket.Logging.Builder,
            com.google.storage.v2.Bucket.LoggingOrBuilder>
        getLoggingFieldBuilder() {
      if (loggingBuilder_ == null) {
        loggingBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.Bucket.Logging,
                com.google.storage.v2.Bucket.Logging.Builder,
                com.google.storage.v2.Bucket.LoggingOrBuilder>(
                getLogging(), getParentForChildren(), isClean());
        logging_ = null;
      }
      return loggingBuilder_;
    }

    private com.google.storage.v2.Owner owner_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Owner,
            com.google.storage.v2.Owner.Builder,
            com.google.storage.v2.OwnerOrBuilder>
        ownerBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The owner of the bucket. This is always the project team's
     * owner group.
     * </pre>
     *
     * <code>.google.storage.v2.Owner owner = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the owner field is set.
     */
    public boolean hasOwner() {
      return ((bitField0_ & 0x00100000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The owner of the bucket. This is always the project team's
     * owner group.
     * </pre>
     *
     * <code>.google.storage.v2.Owner owner = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The owner.
     */
    public com.google.storage.v2.Owner getOwner() {
      if (ownerBuilder_ == null) {
        return owner_ == null ? com.google.storage.v2.Owner.getDefaultInstance() : owner_;
      } else {
        return ownerBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The owner of the bucket. This is always the project team's
     * owner group.
     * </pre>
     *
     * <code>.google.storage.v2.Owner owner = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setOwner(com.google.storage.v2.Owner value) {
      if (ownerBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        owner_ = value;
      } else {
        ownerBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The owner of the bucket. This is always the project team's
     * owner group.
     * </pre>
     *
     * <code>.google.storage.v2.Owner owner = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setOwner(com.google.storage.v2.Owner.Builder builderForValue) {
      if (ownerBuilder_ == null) {
        owner_ = builderForValue.build();
      } else {
        ownerBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The owner of the bucket. This is always the project team's
     * owner group.
     * </pre>
     *
     * <code>.google.storage.v2.Owner owner = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeOwner(com.google.storage.v2.Owner value) {
      if (ownerBuilder_ == null) {
        if (((bitField0_ & 0x00100000) != 0)
            && owner_ != null
            && owner_ != com.google.storage.v2.Owner.getDefaultInstance()) {
          getOwnerBuilder().mergeFrom(value);
        } else {
          owner_ = value;
        }
      } else {
        ownerBuilder_.mergeFrom(value);
      }
      if (owner_ != null) {
        bitField0_ |= 0x00100000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The owner of the bucket. This is always the project team's
     * owner group.
     * </pre>
     *
     * <code>.google.storage.v2.Owner owner = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearOwner() {
      bitField0_ = (bitField0_ & ~0x00100000);
      owner_ = null;
      if (ownerBuilder_ != null) {
        ownerBuilder_.dispose();
        ownerBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The owner of the bucket. This is always the project team's
     * owner group.
     * </pre>
     *
     * <code>.google.storage.v2.Owner owner = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.storage.v2.Owner.Builder getOwnerBuilder() {
      bitField0_ |= 0x00100000;
      onChanged();
      return getOwnerFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The owner of the bucket. This is always the project team's
     * owner group.
     * </pre>
     *
     * <code>.google.storage.v2.Owner owner = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.storage.v2.OwnerOrBuilder getOwnerOrBuilder() {
      if (ownerBuilder_ != null) {
        return ownerBuilder_.getMessageOrBuilder();
      } else {
        return owner_ == null ? com.google.storage.v2.Owner.getDefaultInstance() : owner_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The owner of the bucket. This is always the project team's
     * owner group.
     * </pre>
     *
     * <code>.google.storage.v2.Owner owner = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Owner,
            com.google.storage.v2.Owner.Builder,
            com.google.storage.v2.OwnerOrBuilder>
        getOwnerFieldBuilder() {
      if (ownerBuilder_ == null) {
        ownerBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.Owner,
                com.google.storage.v2.Owner.Builder,
                com.google.storage.v2.OwnerOrBuilder>(
                getOwner(), getParentForChildren(), isClean());
        owner_ = null;
      }
      return ownerBuilder_;
    }

    private com.google.storage.v2.Bucket.Encryption encryption_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Bucket.Encryption,
            com.google.storage.v2.Bucket.Encryption.Builder,
            com.google.storage.v2.Bucket.EncryptionOrBuilder>
        encryptionBuilder_;
    /**
     *
     *
     * <pre>
     * Encryption config for a bucket.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Encryption encryption = 20;</code>
     *
     * @return Whether the encryption field is set.
     */
    public boolean hasEncryption() {
      return ((bitField0_ & 0x00200000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Encryption config for a bucket.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Encryption encryption = 20;</code>
     *
     * @return The encryption.
     */
    public com.google.storage.v2.Bucket.Encryption getEncryption() {
      if (encryptionBuilder_ == null) {
        return encryption_ == null
            ? com.google.storage.v2.Bucket.Encryption.getDefaultInstance()
            : encryption_;
      } else {
        return encryptionBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Encryption config for a bucket.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Encryption encryption = 20;</code>
     */
    public Builder setEncryption(com.google.storage.v2.Bucket.Encryption value) {
      if (encryptionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        encryption_ = value;
      } else {
        encryptionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Encryption config for a bucket.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Encryption encryption = 20;</code>
     */
    public Builder setEncryption(com.google.storage.v2.Bucket.Encryption.Builder builderForValue) {
      if (encryptionBuilder_ == null) {
        encryption_ = builderForValue.build();
      } else {
        encryptionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Encryption config for a bucket.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Encryption encryption = 20;</code>
     */
    public Builder mergeEncryption(com.google.storage.v2.Bucket.Encryption value) {
      if (encryptionBuilder_ == null) {
        if (((bitField0_ & 0x00200000) != 0)
            && encryption_ != null
            && encryption_ != com.google.storage.v2.Bucket.Encryption.getDefaultInstance()) {
          getEncryptionBuilder().mergeFrom(value);
        } else {
          encryption_ = value;
        }
      } else {
        encryptionBuilder_.mergeFrom(value);
      }
      if (encryption_ != null) {
        bitField0_ |= 0x00200000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Encryption config for a bucket.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Encryption encryption = 20;</code>
     */
    public Builder clearEncryption() {
      bitField0_ = (bitField0_ & ~0x00200000);
      encryption_ = null;
      if (encryptionBuilder_ != null) {
        encryptionBuilder_.dispose();
        encryptionBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Encryption config for a bucket.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Encryption encryption = 20;</code>
     */
    public com.google.storage.v2.Bucket.Encryption.Builder getEncryptionBuilder() {
      bitField0_ |= 0x00200000;
      onChanged();
      return getEncryptionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Encryption config for a bucket.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Encryption encryption = 20;</code>
     */
    public com.google.storage.v2.Bucket.EncryptionOrBuilder getEncryptionOrBuilder() {
      if (encryptionBuilder_ != null) {
        return encryptionBuilder_.getMessageOrBuilder();
      } else {
        return encryption_ == null
            ? com.google.storage.v2.Bucket.Encryption.getDefaultInstance()
            : encryption_;
      }
    }
    /**
     *
     *
     * <pre>
     * Encryption config for a bucket.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Encryption encryption = 20;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Bucket.Encryption,
            com.google.storage.v2.Bucket.Encryption.Builder,
            com.google.storage.v2.Bucket.EncryptionOrBuilder>
        getEncryptionFieldBuilder() {
      if (encryptionBuilder_ == null) {
        encryptionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.Bucket.Encryption,
                com.google.storage.v2.Bucket.Encryption.Builder,
                com.google.storage.v2.Bucket.EncryptionOrBuilder>(
                getEncryption(), getParentForChildren(), isClean());
        encryption_ = null;
      }
      return encryptionBuilder_;
    }

    private com.google.storage.v2.Bucket.Billing billing_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Bucket.Billing,
            com.google.storage.v2.Bucket.Billing.Builder,
            com.google.storage.v2.Bucket.BillingOrBuilder>
        billingBuilder_;
    /**
     *
     *
     * <pre>
     * The bucket's billing config.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Billing billing = 21;</code>
     *
     * @return Whether the billing field is set.
     */
    public boolean hasBilling() {
      return ((bitField0_ & 0x00400000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The bucket's billing config.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Billing billing = 21;</code>
     *
     * @return The billing.
     */
    public com.google.storage.v2.Bucket.Billing getBilling() {
      if (billingBuilder_ == null) {
        return billing_ == null
            ? com.google.storage.v2.Bucket.Billing.getDefaultInstance()
            : billing_;
      } else {
        return billingBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The bucket's billing config.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Billing billing = 21;</code>
     */
    public Builder setBilling(com.google.storage.v2.Bucket.Billing value) {
      if (billingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        billing_ = value;
      } else {
        billingBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's billing config.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Billing billing = 21;</code>
     */
    public Builder setBilling(com.google.storage.v2.Bucket.Billing.Builder builderForValue) {
      if (billingBuilder_ == null) {
        billing_ = builderForValue.build();
      } else {
        billingBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's billing config.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Billing billing = 21;</code>
     */
    public Builder mergeBilling(com.google.storage.v2.Bucket.Billing value) {
      if (billingBuilder_ == null) {
        if (((bitField0_ & 0x00400000) != 0)
            && billing_ != null
            && billing_ != com.google.storage.v2.Bucket.Billing.getDefaultInstance()) {
          getBillingBuilder().mergeFrom(value);
        } else {
          billing_ = value;
        }
      } else {
        billingBuilder_.mergeFrom(value);
      }
      if (billing_ != null) {
        bitField0_ |= 0x00400000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's billing config.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Billing billing = 21;</code>
     */
    public Builder clearBilling() {
      bitField0_ = (bitField0_ & ~0x00400000);
      billing_ = null;
      if (billingBuilder_ != null) {
        billingBuilder_.dispose();
        billingBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's billing config.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Billing billing = 21;</code>
     */
    public com.google.storage.v2.Bucket.Billing.Builder getBillingBuilder() {
      bitField0_ |= 0x00400000;
      onChanged();
      return getBillingFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The bucket's billing config.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Billing billing = 21;</code>
     */
    public com.google.storage.v2.Bucket.BillingOrBuilder getBillingOrBuilder() {
      if (billingBuilder_ != null) {
        return billingBuilder_.getMessageOrBuilder();
      } else {
        return billing_ == null
            ? com.google.storage.v2.Bucket.Billing.getDefaultInstance()
            : billing_;
      }
    }
    /**
     *
     *
     * <pre>
     * The bucket's billing config.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Billing billing = 21;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Bucket.Billing,
            com.google.storage.v2.Bucket.Billing.Builder,
            com.google.storage.v2.Bucket.BillingOrBuilder>
        getBillingFieldBuilder() {
      if (billingBuilder_ == null) {
        billingBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.Bucket.Billing,
                com.google.storage.v2.Bucket.Billing.Builder,
                com.google.storage.v2.Bucket.BillingOrBuilder>(
                getBilling(), getParentForChildren(), isClean());
        billing_ = null;
      }
      return billingBuilder_;
    }

    private com.google.storage.v2.Bucket.RetentionPolicy retentionPolicy_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Bucket.RetentionPolicy,
            com.google.storage.v2.Bucket.RetentionPolicy.Builder,
            com.google.storage.v2.Bucket.RetentionPolicyOrBuilder>
        retentionPolicyBuilder_;
    /**
     *
     *
     * <pre>
     * The bucket's retention policy. The retention policy enforces a minimum
     * retention time for all objects contained in the bucket, based on their
     * creation time. Any attempt to overwrite or delete objects younger than the
     * retention period will result in a PERMISSION_DENIED error.  An unlocked
     * retention policy can be modified or removed from the bucket via a
     * storage.buckets.update operation. A locked retention policy cannot be
     * removed or shortened in duration for the lifetime of the bucket.
     * Attempting to remove or decrease period of a locked retention policy will
     * result in a PERMISSION_DENIED error.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.RetentionPolicy retention_policy = 22;</code>
     *
     * @return Whether the retentionPolicy field is set.
     */
    public boolean hasRetentionPolicy() {
      return ((bitField0_ & 0x00800000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The bucket's retention policy. The retention policy enforces a minimum
     * retention time for all objects contained in the bucket, based on their
     * creation time. Any attempt to overwrite or delete objects younger than the
     * retention period will result in a PERMISSION_DENIED error.  An unlocked
     * retention policy can be modified or removed from the bucket via a
     * storage.buckets.update operation. A locked retention policy cannot be
     * removed or shortened in duration for the lifetime of the bucket.
     * Attempting to remove or decrease period of a locked retention policy will
     * result in a PERMISSION_DENIED error.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.RetentionPolicy retention_policy = 22;</code>
     *
     * @return The retentionPolicy.
     */
    public com.google.storage.v2.Bucket.RetentionPolicy getRetentionPolicy() {
      if (retentionPolicyBuilder_ == null) {
        return retentionPolicy_ == null
            ? com.google.storage.v2.Bucket.RetentionPolicy.getDefaultInstance()
            : retentionPolicy_;
      } else {
        return retentionPolicyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The bucket's retention policy. The retention policy enforces a minimum
     * retention time for all objects contained in the bucket, based on their
     * creation time. Any attempt to overwrite or delete objects younger than the
     * retention period will result in a PERMISSION_DENIED error.  An unlocked
     * retention policy can be modified or removed from the bucket via a
     * storage.buckets.update operation. A locked retention policy cannot be
     * removed or shortened in duration for the lifetime of the bucket.
     * Attempting to remove or decrease period of a locked retention policy will
     * result in a PERMISSION_DENIED error.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.RetentionPolicy retention_policy = 22;</code>
     */
    public Builder setRetentionPolicy(com.google.storage.v2.Bucket.RetentionPolicy value) {
      if (retentionPolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        retentionPolicy_ = value;
      } else {
        retentionPolicyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's retention policy. The retention policy enforces a minimum
     * retention time for all objects contained in the bucket, based on their
     * creation time. Any attempt to overwrite or delete objects younger than the
     * retention period will result in a PERMISSION_DENIED error.  An unlocked
     * retention policy can be modified or removed from the bucket via a
     * storage.buckets.update operation. A locked retention policy cannot be
     * removed or shortened in duration for the lifetime of the bucket.
     * Attempting to remove or decrease period of a locked retention policy will
     * result in a PERMISSION_DENIED error.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.RetentionPolicy retention_policy = 22;</code>
     */
    public Builder setRetentionPolicy(
        com.google.storage.v2.Bucket.RetentionPolicy.Builder builderForValue) {
      if (retentionPolicyBuilder_ == null) {
        retentionPolicy_ = builderForValue.build();
      } else {
        retentionPolicyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's retention policy. The retention policy enforces a minimum
     * retention time for all objects contained in the bucket, based on their
     * creation time. Any attempt to overwrite or delete objects younger than the
     * retention period will result in a PERMISSION_DENIED error.  An unlocked
     * retention policy can be modified or removed from the bucket via a
     * storage.buckets.update operation. A locked retention policy cannot be
     * removed or shortened in duration for the lifetime of the bucket.
     * Attempting to remove or decrease period of a locked retention policy will
     * result in a PERMISSION_DENIED error.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.RetentionPolicy retention_policy = 22;</code>
     */
    public Builder mergeRetentionPolicy(com.google.storage.v2.Bucket.RetentionPolicy value) {
      if (retentionPolicyBuilder_ == null) {
        if (((bitField0_ & 0x00800000) != 0)
            && retentionPolicy_ != null
            && retentionPolicy_
                != com.google.storage.v2.Bucket.RetentionPolicy.getDefaultInstance()) {
          getRetentionPolicyBuilder().mergeFrom(value);
        } else {
          retentionPolicy_ = value;
        }
      } else {
        retentionPolicyBuilder_.mergeFrom(value);
      }
      if (retentionPolicy_ != null) {
        bitField0_ |= 0x00800000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's retention policy. The retention policy enforces a minimum
     * retention time for all objects contained in the bucket, based on their
     * creation time. Any attempt to overwrite or delete objects younger than the
     * retention period will result in a PERMISSION_DENIED error.  An unlocked
     * retention policy can be modified or removed from the bucket via a
     * storage.buckets.update operation. A locked retention policy cannot be
     * removed or shortened in duration for the lifetime of the bucket.
     * Attempting to remove or decrease period of a locked retention policy will
     * result in a PERMISSION_DENIED error.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.RetentionPolicy retention_policy = 22;</code>
     */
    public Builder clearRetentionPolicy() {
      bitField0_ = (bitField0_ & ~0x00800000);
      retentionPolicy_ = null;
      if (retentionPolicyBuilder_ != null) {
        retentionPolicyBuilder_.dispose();
        retentionPolicyBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's retention policy. The retention policy enforces a minimum
     * retention time for all objects contained in the bucket, based on their
     * creation time. Any attempt to overwrite or delete objects younger than the
     * retention period will result in a PERMISSION_DENIED error.  An unlocked
     * retention policy can be modified or removed from the bucket via a
     * storage.buckets.update operation. A locked retention policy cannot be
     * removed or shortened in duration for the lifetime of the bucket.
     * Attempting to remove or decrease period of a locked retention policy will
     * result in a PERMISSION_DENIED error.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.RetentionPolicy retention_policy = 22;</code>
     */
    public com.google.storage.v2.Bucket.RetentionPolicy.Builder getRetentionPolicyBuilder() {
      bitField0_ |= 0x00800000;
      onChanged();
      return getRetentionPolicyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The bucket's retention policy. The retention policy enforces a minimum
     * retention time for all objects contained in the bucket, based on their
     * creation time. Any attempt to overwrite or delete objects younger than the
     * retention period will result in a PERMISSION_DENIED error.  An unlocked
     * retention policy can be modified or removed from the bucket via a
     * storage.buckets.update operation. A locked retention policy cannot be
     * removed or shortened in duration for the lifetime of the bucket.
     * Attempting to remove or decrease period of a locked retention policy will
     * result in a PERMISSION_DENIED error.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.RetentionPolicy retention_policy = 22;</code>
     */
    public com.google.storage.v2.Bucket.RetentionPolicyOrBuilder getRetentionPolicyOrBuilder() {
      if (retentionPolicyBuilder_ != null) {
        return retentionPolicyBuilder_.getMessageOrBuilder();
      } else {
        return retentionPolicy_ == null
            ? com.google.storage.v2.Bucket.RetentionPolicy.getDefaultInstance()
            : retentionPolicy_;
      }
    }
    /**
     *
     *
     * <pre>
     * The bucket's retention policy. The retention policy enforces a minimum
     * retention time for all objects contained in the bucket, based on their
     * creation time. Any attempt to overwrite or delete objects younger than the
     * retention period will result in a PERMISSION_DENIED error.  An unlocked
     * retention policy can be modified or removed from the bucket via a
     * storage.buckets.update operation. A locked retention policy cannot be
     * removed or shortened in duration for the lifetime of the bucket.
     * Attempting to remove or decrease period of a locked retention policy will
     * result in a PERMISSION_DENIED error.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.RetentionPolicy retention_policy = 22;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Bucket.RetentionPolicy,
            com.google.storage.v2.Bucket.RetentionPolicy.Builder,
            com.google.storage.v2.Bucket.RetentionPolicyOrBuilder>
        getRetentionPolicyFieldBuilder() {
      if (retentionPolicyBuilder_ == null) {
        retentionPolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.Bucket.RetentionPolicy,
                com.google.storage.v2.Bucket.RetentionPolicy.Builder,
                com.google.storage.v2.Bucket.RetentionPolicyOrBuilder>(
                getRetentionPolicy(), getParentForChildren(), isClean());
        retentionPolicy_ = null;
      }
      return retentionPolicyBuilder_;
    }

    private com.google.storage.v2.Bucket.IamConfig iamConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Bucket.IamConfig,
            com.google.storage.v2.Bucket.IamConfig.Builder,
            com.google.storage.v2.Bucket.IamConfigOrBuilder>
        iamConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The bucket's IAM config.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.IamConfig iam_config = 23;</code>
     *
     * @return Whether the iamConfig field is set.
     */
    public boolean hasIamConfig() {
      return ((bitField0_ & 0x01000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The bucket's IAM config.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.IamConfig iam_config = 23;</code>
     *
     * @return The iamConfig.
     */
    public com.google.storage.v2.Bucket.IamConfig getIamConfig() {
      if (iamConfigBuilder_ == null) {
        return iamConfig_ == null
            ? com.google.storage.v2.Bucket.IamConfig.getDefaultInstance()
            : iamConfig_;
      } else {
        return iamConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The bucket's IAM config.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.IamConfig iam_config = 23;</code>
     */
    public Builder setIamConfig(com.google.storage.v2.Bucket.IamConfig value) {
      if (iamConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        iamConfig_ = value;
      } else {
        iamConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x01000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's IAM config.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.IamConfig iam_config = 23;</code>
     */
    public Builder setIamConfig(com.google.storage.v2.Bucket.IamConfig.Builder builderForValue) {
      if (iamConfigBuilder_ == null) {
        iamConfig_ = builderForValue.build();
      } else {
        iamConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x01000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's IAM config.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.IamConfig iam_config = 23;</code>
     */
    public Builder mergeIamConfig(com.google.storage.v2.Bucket.IamConfig value) {
      if (iamConfigBuilder_ == null) {
        if (((bitField0_ & 0x01000000) != 0)
            && iamConfig_ != null
            && iamConfig_ != com.google.storage.v2.Bucket.IamConfig.getDefaultInstance()) {
          getIamConfigBuilder().mergeFrom(value);
        } else {
          iamConfig_ = value;
        }
      } else {
        iamConfigBuilder_.mergeFrom(value);
      }
      if (iamConfig_ != null) {
        bitField0_ |= 0x01000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's IAM config.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.IamConfig iam_config = 23;</code>
     */
    public Builder clearIamConfig() {
      bitField0_ = (bitField0_ & ~0x01000000);
      iamConfig_ = null;
      if (iamConfigBuilder_ != null) {
        iamConfigBuilder_.dispose();
        iamConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's IAM config.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.IamConfig iam_config = 23;</code>
     */
    public com.google.storage.v2.Bucket.IamConfig.Builder getIamConfigBuilder() {
      bitField0_ |= 0x01000000;
      onChanged();
      return getIamConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The bucket's IAM config.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.IamConfig iam_config = 23;</code>
     */
    public com.google.storage.v2.Bucket.IamConfigOrBuilder getIamConfigOrBuilder() {
      if (iamConfigBuilder_ != null) {
        return iamConfigBuilder_.getMessageOrBuilder();
      } else {
        return iamConfig_ == null
            ? com.google.storage.v2.Bucket.IamConfig.getDefaultInstance()
            : iamConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The bucket's IAM config.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.IamConfig iam_config = 23;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Bucket.IamConfig,
            com.google.storage.v2.Bucket.IamConfig.Builder,
            com.google.storage.v2.Bucket.IamConfigOrBuilder>
        getIamConfigFieldBuilder() {
      if (iamConfigBuilder_ == null) {
        iamConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.Bucket.IamConfig,
                com.google.storage.v2.Bucket.IamConfig.Builder,
                com.google.storage.v2.Bucket.IamConfigOrBuilder>(
                getIamConfig(), getParentForChildren(), isClean());
        iamConfig_ = null;
      }
      return iamConfigBuilder_;
    }

    private boolean satisfiesPzs_;
    /**
     *
     *
     * <pre>
     * Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzs = 25;</code>
     *
     * @return The satisfiesPzs.
     */
    @java.lang.Override
    public boolean getSatisfiesPzs() {
      return satisfiesPzs_;
    }
    /**
     *
     *
     * <pre>
     * Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzs = 25;</code>
     *
     * @param value The satisfiesPzs to set.
     * @return This builder for chaining.
     */
    public Builder setSatisfiesPzs(boolean value) {

      satisfiesPzs_ = value;
      bitField0_ |= 0x02000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzs = 25;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSatisfiesPzs() {
      bitField0_ = (bitField0_ & ~0x02000000);
      satisfiesPzs_ = false;
      onChanged();
      return this;
    }

    private com.google.storage.v2.Bucket.CustomPlacementConfig customPlacementConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Bucket.CustomPlacementConfig,
            com.google.storage.v2.Bucket.CustomPlacementConfig.Builder,
            com.google.storage.v2.Bucket.CustomPlacementConfigOrBuilder>
        customPlacementConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration that, if present, specifies the data placement for a
     * [https://cloud.google.com/storage/docs/use-dual-regions][Dual Region].
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.CustomPlacementConfig custom_placement_config = 26;</code>
     *
     * @return Whether the customPlacementConfig field is set.
     */
    public boolean hasCustomPlacementConfig() {
      return ((bitField0_ & 0x04000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration that, if present, specifies the data placement for a
     * [https://cloud.google.com/storage/docs/use-dual-regions][Dual Region].
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.CustomPlacementConfig custom_placement_config = 26;</code>
     *
     * @return The customPlacementConfig.
     */
    public com.google.storage.v2.Bucket.CustomPlacementConfig getCustomPlacementConfig() {
      if (customPlacementConfigBuilder_ == null) {
        return customPlacementConfig_ == null
            ? com.google.storage.v2.Bucket.CustomPlacementConfig.getDefaultInstance()
            : customPlacementConfig_;
      } else {
        return customPlacementConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration that, if present, specifies the data placement for a
     * [https://cloud.google.com/storage/docs/use-dual-regions][Dual Region].
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.CustomPlacementConfig custom_placement_config = 26;</code>
     */
    public Builder setCustomPlacementConfig(
        com.google.storage.v2.Bucket.CustomPlacementConfig value) {
      if (customPlacementConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        customPlacementConfig_ = value;
      } else {
        customPlacementConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x04000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration that, if present, specifies the data placement for a
     * [https://cloud.google.com/storage/docs/use-dual-regions][Dual Region].
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.CustomPlacementConfig custom_placement_config = 26;</code>
     */
    public Builder setCustomPlacementConfig(
        com.google.storage.v2.Bucket.CustomPlacementConfig.Builder builderForValue) {
      if (customPlacementConfigBuilder_ == null) {
        customPlacementConfig_ = builderForValue.build();
      } else {
        customPlacementConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x04000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration that, if present, specifies the data placement for a
     * [https://cloud.google.com/storage/docs/use-dual-regions][Dual Region].
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.CustomPlacementConfig custom_placement_config = 26;</code>
     */
    public Builder mergeCustomPlacementConfig(
        com.google.storage.v2.Bucket.CustomPlacementConfig value) {
      if (customPlacementConfigBuilder_ == null) {
        if (((bitField0_ & 0x04000000) != 0)
            && customPlacementConfig_ != null
            && customPlacementConfig_
                != com.google.storage.v2.Bucket.CustomPlacementConfig.getDefaultInstance()) {
          getCustomPlacementConfigBuilder().mergeFrom(value);
        } else {
          customPlacementConfig_ = value;
        }
      } else {
        customPlacementConfigBuilder_.mergeFrom(value);
      }
      if (customPlacementConfig_ != null) {
        bitField0_ |= 0x04000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration that, if present, specifies the data placement for a
     * [https://cloud.google.com/storage/docs/use-dual-regions][Dual Region].
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.CustomPlacementConfig custom_placement_config = 26;</code>
     */
    public Builder clearCustomPlacementConfig() {
      bitField0_ = (bitField0_ & ~0x04000000);
      customPlacementConfig_ = null;
      if (customPlacementConfigBuilder_ != null) {
        customPlacementConfigBuilder_.dispose();
        customPlacementConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration that, if present, specifies the data placement for a
     * [https://cloud.google.com/storage/docs/use-dual-regions][Dual Region].
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.CustomPlacementConfig custom_placement_config = 26;</code>
     */
    public com.google.storage.v2.Bucket.CustomPlacementConfig.Builder
        getCustomPlacementConfigBuilder() {
      bitField0_ |= 0x04000000;
      onChanged();
      return getCustomPlacementConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration that, if present, specifies the data placement for a
     * [https://cloud.google.com/storage/docs/use-dual-regions][Dual Region].
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.CustomPlacementConfig custom_placement_config = 26;</code>
     */
    public com.google.storage.v2.Bucket.CustomPlacementConfigOrBuilder
        getCustomPlacementConfigOrBuilder() {
      if (customPlacementConfigBuilder_ != null) {
        return customPlacementConfigBuilder_.getMessageOrBuilder();
      } else {
        return customPlacementConfig_ == null
            ? com.google.storage.v2.Bucket.CustomPlacementConfig.getDefaultInstance()
            : customPlacementConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration that, if present, specifies the data placement for a
     * [https://cloud.google.com/storage/docs/use-dual-regions][Dual Region].
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.CustomPlacementConfig custom_placement_config = 26;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Bucket.CustomPlacementConfig,
            com.google.storage.v2.Bucket.CustomPlacementConfig.Builder,
            com.google.storage.v2.Bucket.CustomPlacementConfigOrBuilder>
        getCustomPlacementConfigFieldBuilder() {
      if (customPlacementConfigBuilder_ == null) {
        customPlacementConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.Bucket.CustomPlacementConfig,
                com.google.storage.v2.Bucket.CustomPlacementConfig.Builder,
                com.google.storage.v2.Bucket.CustomPlacementConfigOrBuilder>(
                getCustomPlacementConfig(), getParentForChildren(), isClean());
        customPlacementConfig_ = null;
      }
      return customPlacementConfigBuilder_;
    }

    private com.google.storage.v2.Bucket.Autoclass autoclass_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Bucket.Autoclass,
            com.google.storage.v2.Bucket.Autoclass.Builder,
            com.google.storage.v2.Bucket.AutoclassOrBuilder>
        autoclassBuilder_;
    /**
     *
     *
     * <pre>
     * The bucket's Autoclass configuration. If there is no configuration, the
     * Autoclass feature will be disabled and have no effect on the bucket.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Autoclass autoclass = 28;</code>
     *
     * @return Whether the autoclass field is set.
     */
    public boolean hasAutoclass() {
      return ((bitField0_ & 0x08000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The bucket's Autoclass configuration. If there is no configuration, the
     * Autoclass feature will be disabled and have no effect on the bucket.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Autoclass autoclass = 28;</code>
     *
     * @return The autoclass.
     */
    public com.google.storage.v2.Bucket.Autoclass getAutoclass() {
      if (autoclassBuilder_ == null) {
        return autoclass_ == null
            ? com.google.storage.v2.Bucket.Autoclass.getDefaultInstance()
            : autoclass_;
      } else {
        return autoclassBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The bucket's Autoclass configuration. If there is no configuration, the
     * Autoclass feature will be disabled and have no effect on the bucket.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Autoclass autoclass = 28;</code>
     */
    public Builder setAutoclass(com.google.storage.v2.Bucket.Autoclass value) {
      if (autoclassBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        autoclass_ = value;
      } else {
        autoclassBuilder_.setMessage(value);
      }
      bitField0_ |= 0x08000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's Autoclass configuration. If there is no configuration, the
     * Autoclass feature will be disabled and have no effect on the bucket.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Autoclass autoclass = 28;</code>
     */
    public Builder setAutoclass(com.google.storage.v2.Bucket.Autoclass.Builder builderForValue) {
      if (autoclassBuilder_ == null) {
        autoclass_ = builderForValue.build();
      } else {
        autoclassBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x08000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's Autoclass configuration. If there is no configuration, the
     * Autoclass feature will be disabled and have no effect on the bucket.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Autoclass autoclass = 28;</code>
     */
    public Builder mergeAutoclass(com.google.storage.v2.Bucket.Autoclass value) {
      if (autoclassBuilder_ == null) {
        if (((bitField0_ & 0x08000000) != 0)
            && autoclass_ != null
            && autoclass_ != com.google.storage.v2.Bucket.Autoclass.getDefaultInstance()) {
          getAutoclassBuilder().mergeFrom(value);
        } else {
          autoclass_ = value;
        }
      } else {
        autoclassBuilder_.mergeFrom(value);
      }
      if (autoclass_ != null) {
        bitField0_ |= 0x08000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's Autoclass configuration. If there is no configuration, the
     * Autoclass feature will be disabled and have no effect on the bucket.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Autoclass autoclass = 28;</code>
     */
    public Builder clearAutoclass() {
      bitField0_ = (bitField0_ & ~0x08000000);
      autoclass_ = null;
      if (autoclassBuilder_ != null) {
        autoclassBuilder_.dispose();
        autoclassBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's Autoclass configuration. If there is no configuration, the
     * Autoclass feature will be disabled and have no effect on the bucket.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Autoclass autoclass = 28;</code>
     */
    public com.google.storage.v2.Bucket.Autoclass.Builder getAutoclassBuilder() {
      bitField0_ |= 0x08000000;
      onChanged();
      return getAutoclassFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The bucket's Autoclass configuration. If there is no configuration, the
     * Autoclass feature will be disabled and have no effect on the bucket.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Autoclass autoclass = 28;</code>
     */
    public com.google.storage.v2.Bucket.AutoclassOrBuilder getAutoclassOrBuilder() {
      if (autoclassBuilder_ != null) {
        return autoclassBuilder_.getMessageOrBuilder();
      } else {
        return autoclass_ == null
            ? com.google.storage.v2.Bucket.Autoclass.getDefaultInstance()
            : autoclass_;
      }
    }
    /**
     *
     *
     * <pre>
     * The bucket's Autoclass configuration. If there is no configuration, the
     * Autoclass feature will be disabled and have no effect on the bucket.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Autoclass autoclass = 28;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Bucket.Autoclass,
            com.google.storage.v2.Bucket.Autoclass.Builder,
            com.google.storage.v2.Bucket.AutoclassOrBuilder>
        getAutoclassFieldBuilder() {
      if (autoclassBuilder_ == null) {
        autoclassBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.Bucket.Autoclass,
                com.google.storage.v2.Bucket.Autoclass.Builder,
                com.google.storage.v2.Bucket.AutoclassOrBuilder>(
                getAutoclass(), getParentForChildren(), isClean());
        autoclass_ = null;
      }
      return autoclassBuilder_;
    }

    private com.google.storage.v2.Bucket.HierarchicalNamespace hierarchicalNamespace_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Bucket.HierarchicalNamespace,
            com.google.storage.v2.Bucket.HierarchicalNamespace.Builder,
            com.google.storage.v2.Bucket.HierarchicalNamespaceOrBuilder>
        hierarchicalNamespaceBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The bucket's hierarchical namespace configuration. If there is no
     * configuration, the hierarchical namespace feature will be disabled and have
     * no effect on the bucket.
     * </pre>
     *
     * <code>
     * .google.storage.v2.Bucket.HierarchicalNamespace hierarchical_namespace = 32 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the hierarchicalNamespace field is set.
     */
    public boolean hasHierarchicalNamespace() {
      return ((bitField0_ & 0x10000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The bucket's hierarchical namespace configuration. If there is no
     * configuration, the hierarchical namespace feature will be disabled and have
     * no effect on the bucket.
     * </pre>
     *
     * <code>
     * .google.storage.v2.Bucket.HierarchicalNamespace hierarchical_namespace = 32 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The hierarchicalNamespace.
     */
    public com.google.storage.v2.Bucket.HierarchicalNamespace getHierarchicalNamespace() {
      if (hierarchicalNamespaceBuilder_ == null) {
        return hierarchicalNamespace_ == null
            ? com.google.storage.v2.Bucket.HierarchicalNamespace.getDefaultInstance()
            : hierarchicalNamespace_;
      } else {
        return hierarchicalNamespaceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The bucket's hierarchical namespace configuration. If there is no
     * configuration, the hierarchical namespace feature will be disabled and have
     * no effect on the bucket.
     * </pre>
     *
     * <code>
     * .google.storage.v2.Bucket.HierarchicalNamespace hierarchical_namespace = 32 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setHierarchicalNamespace(
        com.google.storage.v2.Bucket.HierarchicalNamespace value) {
      if (hierarchicalNamespaceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        hierarchicalNamespace_ = value;
      } else {
        hierarchicalNamespaceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x10000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The bucket's hierarchical namespace configuration. If there is no
     * configuration, the hierarchical namespace feature will be disabled and have
     * no effect on the bucket.
     * </pre>
     *
     * <code>
     * .google.storage.v2.Bucket.HierarchicalNamespace hierarchical_namespace = 32 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setHierarchicalNamespace(
        com.google.storage.v2.Bucket.HierarchicalNamespace.Builder builderForValue) {
      if (hierarchicalNamespaceBuilder_ == null) {
        hierarchicalNamespace_ = builderForValue.build();
      } else {
        hierarchicalNamespaceBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x10000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The bucket's hierarchical namespace configuration. If there is no
     * configuration, the hierarchical namespace feature will be disabled and have
     * no effect on the bucket.
     * </pre>
     *
     * <code>
     * .google.storage.v2.Bucket.HierarchicalNamespace hierarchical_namespace = 32 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeHierarchicalNamespace(
        com.google.storage.v2.Bucket.HierarchicalNamespace value) {
      if (hierarchicalNamespaceBuilder_ == null) {
        if (((bitField0_ & 0x10000000) != 0)
            && hierarchicalNamespace_ != null
            && hierarchicalNamespace_
                != com.google.storage.v2.Bucket.HierarchicalNamespace.getDefaultInstance()) {
          getHierarchicalNamespaceBuilder().mergeFrom(value);
        } else {
          hierarchicalNamespace_ = value;
        }
      } else {
        hierarchicalNamespaceBuilder_.mergeFrom(value);
      }
      if (hierarchicalNamespace_ != null) {
        bitField0_ |= 0x10000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The bucket's hierarchical namespace configuration. If there is no
     * configuration, the hierarchical namespace feature will be disabled and have
     * no effect on the bucket.
     * </pre>
     *
     * <code>
     * .google.storage.v2.Bucket.HierarchicalNamespace hierarchical_namespace = 32 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearHierarchicalNamespace() {
      bitField0_ = (bitField0_ & ~0x10000000);
      hierarchicalNamespace_ = null;
      if (hierarchicalNamespaceBuilder_ != null) {
        hierarchicalNamespaceBuilder_.dispose();
        hierarchicalNamespaceBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The bucket's hierarchical namespace configuration. If there is no
     * configuration, the hierarchical namespace feature will be disabled and have
     * no effect on the bucket.
     * </pre>
     *
     * <code>
     * .google.storage.v2.Bucket.HierarchicalNamespace hierarchical_namespace = 32 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.storage.v2.Bucket.HierarchicalNamespace.Builder
        getHierarchicalNamespaceBuilder() {
      bitField0_ |= 0x10000000;
      onChanged();
      return getHierarchicalNamespaceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The bucket's hierarchical namespace configuration. If there is no
     * configuration, the hierarchical namespace feature will be disabled and have
     * no effect on the bucket.
     * </pre>
     *
     * <code>
     * .google.storage.v2.Bucket.HierarchicalNamespace hierarchical_namespace = 32 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.storage.v2.Bucket.HierarchicalNamespaceOrBuilder
        getHierarchicalNamespaceOrBuilder() {
      if (hierarchicalNamespaceBuilder_ != null) {
        return hierarchicalNamespaceBuilder_.getMessageOrBuilder();
      } else {
        return hierarchicalNamespace_ == null
            ? com.google.storage.v2.Bucket.HierarchicalNamespace.getDefaultInstance()
            : hierarchicalNamespace_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The bucket's hierarchical namespace configuration. If there is no
     * configuration, the hierarchical namespace feature will be disabled and have
     * no effect on the bucket.
     * </pre>
     *
     * <code>
     * .google.storage.v2.Bucket.HierarchicalNamespace hierarchical_namespace = 32 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Bucket.HierarchicalNamespace,
            com.google.storage.v2.Bucket.HierarchicalNamespace.Builder,
            com.google.storage.v2.Bucket.HierarchicalNamespaceOrBuilder>
        getHierarchicalNamespaceFieldBuilder() {
      if (hierarchicalNamespaceBuilder_ == null) {
        hierarchicalNamespaceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.Bucket.HierarchicalNamespace,
                com.google.storage.v2.Bucket.HierarchicalNamespace.Builder,
                com.google.storage.v2.Bucket.HierarchicalNamespaceOrBuilder>(
                getHierarchicalNamespace(), getParentForChildren(), isClean());
        hierarchicalNamespace_ = null;
      }
      return hierarchicalNamespaceBuilder_;
    }

    private com.google.storage.v2.Bucket.SoftDeletePolicy softDeletePolicy_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Bucket.SoftDeletePolicy,
            com.google.storage.v2.Bucket.SoftDeletePolicy.Builder,
            com.google.storage.v2.Bucket.SoftDeletePolicyOrBuilder>
        softDeletePolicyBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The bucket's soft delete policy. The soft delete policy prevents
     * soft-deleted objects from being permanently deleted.
     * </pre>
     *
     * <code>
     * .google.storage.v2.Bucket.SoftDeletePolicy soft_delete_policy = 31 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the softDeletePolicy field is set.
     */
    public boolean hasSoftDeletePolicy() {
      return ((bitField0_ & 0x20000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The bucket's soft delete policy. The soft delete policy prevents
     * soft-deleted objects from being permanently deleted.
     * </pre>
     *
     * <code>
     * .google.storage.v2.Bucket.SoftDeletePolicy soft_delete_policy = 31 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The softDeletePolicy.
     */
    public com.google.storage.v2.Bucket.SoftDeletePolicy getSoftDeletePolicy() {
      if (softDeletePolicyBuilder_ == null) {
        return softDeletePolicy_ == null
            ? com.google.storage.v2.Bucket.SoftDeletePolicy.getDefaultInstance()
            : softDeletePolicy_;
      } else {
        return softDeletePolicyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The bucket's soft delete policy. The soft delete policy prevents
     * soft-deleted objects from being permanently deleted.
     * </pre>
     *
     * <code>
     * .google.storage.v2.Bucket.SoftDeletePolicy soft_delete_policy = 31 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSoftDeletePolicy(com.google.storage.v2.Bucket.SoftDeletePolicy value) {
      if (softDeletePolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        softDeletePolicy_ = value;
      } else {
        softDeletePolicyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x20000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The bucket's soft delete policy. The soft delete policy prevents
     * soft-deleted objects from being permanently deleted.
     * </pre>
     *
     * <code>
     * .google.storage.v2.Bucket.SoftDeletePolicy soft_delete_policy = 31 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSoftDeletePolicy(
        com.google.storage.v2.Bucket.SoftDeletePolicy.Builder builderForValue) {
      if (softDeletePolicyBuilder_ == null) {
        softDeletePolicy_ = builderForValue.build();
      } else {
        softDeletePolicyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x20000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The bucket's soft delete policy. The soft delete policy prevents
     * soft-deleted objects from being permanently deleted.
     * </pre>
     *
     * <code>
     * .google.storage.v2.Bucket.SoftDeletePolicy soft_delete_policy = 31 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeSoftDeletePolicy(com.google.storage.v2.Bucket.SoftDeletePolicy value) {
      if (softDeletePolicyBuilder_ == null) {
        if (((bitField0_ & 0x20000000) != 0)
            && softDeletePolicy_ != null
            && softDeletePolicy_
                != com.google.storage.v2.Bucket.SoftDeletePolicy.getDefaultInstance()) {
          getSoftDeletePolicyBuilder().mergeFrom(value);
        } else {
          softDeletePolicy_ = value;
        }
      } else {
        softDeletePolicyBuilder_.mergeFrom(value);
      }
      if (softDeletePolicy_ != null) {
        bitField0_ |= 0x20000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The bucket's soft delete policy. The soft delete policy prevents
     * soft-deleted objects from being permanently deleted.
     * </pre>
     *
     * <code>
     * .google.storage.v2.Bucket.SoftDeletePolicy soft_delete_policy = 31 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSoftDeletePolicy() {
      bitField0_ = (bitField0_ & ~0x20000000);
      softDeletePolicy_ = null;
      if (softDeletePolicyBuilder_ != null) {
        softDeletePolicyBuilder_.dispose();
        softDeletePolicyBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The bucket's soft delete policy. The soft delete policy prevents
     * soft-deleted objects from being permanently deleted.
     * </pre>
     *
     * <code>
     * .google.storage.v2.Bucket.SoftDeletePolicy soft_delete_policy = 31 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.storage.v2.Bucket.SoftDeletePolicy.Builder getSoftDeletePolicyBuilder() {
      bitField0_ |= 0x20000000;
      onChanged();
      return getSoftDeletePolicyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The bucket's soft delete policy. The soft delete policy prevents
     * soft-deleted objects from being permanently deleted.
     * </pre>
     *
     * <code>
     * .google.storage.v2.Bucket.SoftDeletePolicy soft_delete_policy = 31 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.storage.v2.Bucket.SoftDeletePolicyOrBuilder getSoftDeletePolicyOrBuilder() {
      if (softDeletePolicyBuilder_ != null) {
        return softDeletePolicyBuilder_.getMessageOrBuilder();
      } else {
        return softDeletePolicy_ == null
            ? com.google.storage.v2.Bucket.SoftDeletePolicy.getDefaultInstance()
            : softDeletePolicy_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The bucket's soft delete policy. The soft delete policy prevents
     * soft-deleted objects from being permanently deleted.
     * </pre>
     *
     * <code>
     * .google.storage.v2.Bucket.SoftDeletePolicy soft_delete_policy = 31 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Bucket.SoftDeletePolicy,
            com.google.storage.v2.Bucket.SoftDeletePolicy.Builder,
            com.google.storage.v2.Bucket.SoftDeletePolicyOrBuilder>
        getSoftDeletePolicyFieldBuilder() {
      if (softDeletePolicyBuilder_ == null) {
        softDeletePolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.Bucket.SoftDeletePolicy,
                com.google.storage.v2.Bucket.SoftDeletePolicy.Builder,
                com.google.storage.v2.Bucket.SoftDeletePolicyOrBuilder>(
                getSoftDeletePolicy(), getParentForChildren(), isClean());
        softDeletePolicy_ = null;
      }
      return softDeletePolicyBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.storage.v2.Bucket)
  }

  // @@protoc_insertion_point(class_scope:google.storage.v2.Bucket)
  private static final com.google.storage.v2.Bucket DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.storage.v2.Bucket();
  }

  public static com.google.storage.v2.Bucket getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Bucket> PARSER =
      new com.google.protobuf.AbstractParser<Bucket>() {
        @java.lang.Override
        public Bucket parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Bucket> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Bucket> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.storage.v2.Bucket getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
