/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/storage/v2/storage.proto

package com.google.storage.v2;

/**
 *
 *
 * <pre>
 * Request for UpdateBucket method.
 * </pre>
 *
 * Protobuf type {@code google.storage.v2.UpdateBucketRequest}
 */
public final class UpdateBucketRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.storage.v2.UpdateBucketRequest)
    UpdateBucketRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use UpdateBucketRequest.newBuilder() to construct.
  private UpdateBucketRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private UpdateBucketRequest() {
    predefinedAcl_ = "";
    predefinedDefaultObjectAcl_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new UpdateBucketRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.storage.v2.StorageProto
        .internal_static_google_storage_v2_UpdateBucketRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.storage.v2.StorageProto
        .internal_static_google_storage_v2_UpdateBucketRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.storage.v2.UpdateBucketRequest.class,
            com.google.storage.v2.UpdateBucketRequest.Builder.class);
  }

  private int bitField0_;
  public static final int BUCKET_FIELD_NUMBER = 1;
  private com.google.storage.v2.Bucket bucket_;
  /**
   *
   *
   * <pre>
   * Required. The bucket to update.
   * The bucket's `name` field will be used to identify the bucket.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket bucket = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return Whether the bucket field is set.
   */
  @java.lang.Override
  public boolean hasBucket() {
    return bucket_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. The bucket to update.
   * The bucket's `name` field will be used to identify the bucket.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket bucket = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bucket.
   */
  @java.lang.Override
  public com.google.storage.v2.Bucket getBucket() {
    return bucket_ == null ? com.google.storage.v2.Bucket.getDefaultInstance() : bucket_;
  }
  /**
   *
   *
   * <pre>
   * Required. The bucket to update.
   * The bucket's `name` field will be used to identify the bucket.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket bucket = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   */
  @java.lang.Override
  public com.google.storage.v2.BucketOrBuilder getBucketOrBuilder() {
    return bucket_ == null ? com.google.storage.v2.Bucket.getDefaultInstance() : bucket_;
  }

  public static final int IF_METAGENERATION_MATCH_FIELD_NUMBER = 2;
  private long ifMetagenerationMatch_ = 0L;
  /**
   *
   *
   * <pre>
   * If set, will only modify the bucket if its metageneration matches this
   * value.
   * </pre>
   *
   * <code>optional int64 if_metageneration_match = 2;</code>
   *
   * @return Whether the ifMetagenerationMatch field is set.
   */
  @java.lang.Override
  public boolean hasIfMetagenerationMatch() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * If set, will only modify the bucket if its metageneration matches this
   * value.
   * </pre>
   *
   * <code>optional int64 if_metageneration_match = 2;</code>
   *
   * @return The ifMetagenerationMatch.
   */
  @java.lang.Override
  public long getIfMetagenerationMatch() {
    return ifMetagenerationMatch_;
  }

  public static final int IF_METAGENERATION_NOT_MATCH_FIELD_NUMBER = 3;
  private long ifMetagenerationNotMatch_ = 0L;
  /**
   *
   *
   * <pre>
   * If set, will only modify the bucket if its metageneration does not match
   * this value.
   * </pre>
   *
   * <code>optional int64 if_metageneration_not_match = 3;</code>
   *
   * @return Whether the ifMetagenerationNotMatch field is set.
   */
  @java.lang.Override
  public boolean hasIfMetagenerationNotMatch() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * If set, will only modify the bucket if its metageneration does not match
   * this value.
   * </pre>
   *
   * <code>optional int64 if_metageneration_not_match = 3;</code>
   *
   * @return The ifMetagenerationNotMatch.
   */
  @java.lang.Override
  public long getIfMetagenerationNotMatch() {
    return ifMetagenerationNotMatch_;
  }

  public static final int PREDEFINED_ACL_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object predefinedAcl_ = "";
  /**
   *
   *
   * <pre>
   * Apply a predefined set of access controls to this bucket.
   * Valid values are "authenticatedRead", "private", "projectPrivate",
   * "publicRead", or "publicReadWrite".
   * </pre>
   *
   * <code>string predefined_acl = 8;</code>
   *
   * @return The predefinedAcl.
   */
  @java.lang.Override
  public java.lang.String getPredefinedAcl() {
    java.lang.Object ref = predefinedAcl_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      predefinedAcl_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Apply a predefined set of access controls to this bucket.
   * Valid values are "authenticatedRead", "private", "projectPrivate",
   * "publicRead", or "publicReadWrite".
   * </pre>
   *
   * <code>string predefined_acl = 8;</code>
   *
   * @return The bytes for predefinedAcl.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPredefinedAclBytes() {
    java.lang.Object ref = predefinedAcl_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      predefinedAcl_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PREDEFINED_DEFAULT_OBJECT_ACL_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object predefinedDefaultObjectAcl_ = "";
  /**
   *
   *
   * <pre>
   * Apply a predefined set of default object access controls to this bucket.
   * Valid values are "authenticatedRead", "bucketOwnerFullControl",
   * "bucketOwnerRead", "private", "projectPrivate", or "publicRead".
   * </pre>
   *
   * <code>string predefined_default_object_acl = 9;</code>
   *
   * @return The predefinedDefaultObjectAcl.
   */
  @java.lang.Override
  public java.lang.String getPredefinedDefaultObjectAcl() {
    java.lang.Object ref = predefinedDefaultObjectAcl_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      predefinedDefaultObjectAcl_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Apply a predefined set of default object access controls to this bucket.
   * Valid values are "authenticatedRead", "bucketOwnerFullControl",
   * "bucketOwnerRead", "private", "projectPrivate", or "publicRead".
   * </pre>
   *
   * <code>string predefined_default_object_acl = 9;</code>
   *
   * @return The bytes for predefinedDefaultObjectAcl.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPredefinedDefaultObjectAclBytes() {
    java.lang.Object ref = predefinedDefaultObjectAcl_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      predefinedDefaultObjectAcl_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UPDATE_MASK_FIELD_NUMBER = 6;
  private com.google.protobuf.FieldMask updateMask_;
  /**
   *
   *
   * <pre>
   * Required. List of fields to be updated.
   * To specify ALL fields, equivalent to the JSON API's "update" function,
   * specify a single field with the value `*`. Note: not recommended. If a new
   * field is introduced at a later time, an older client updating with the `*`
   * may accidentally reset the new field's value.
   * Not specifying any fields is an error.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask update_mask = 6 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the updateMask field is set.
   */
  @java.lang.Override
  public boolean hasUpdateMask() {
    return updateMask_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. List of fields to be updated.
   * To specify ALL fields, equivalent to the JSON API's "update" function,
   * specify a single field with the value `*`. Note: not recommended. If a new
   * field is introduced at a later time, an older client updating with the `*`
   * may accidentally reset the new field's value.
   * Not specifying any fields is an error.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask update_mask = 6 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The updateMask.
   */
  @java.lang.Override
  public com.google.protobuf.FieldMask getUpdateMask() {
    return updateMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : updateMask_;
  }
  /**
   *
   *
   * <pre>
   * Required. List of fields to be updated.
   * To specify ALL fields, equivalent to the JSON API's "update" function,
   * specify a single field with the value `*`. Note: not recommended. If a new
   * field is introduced at a later time, an older client updating with the `*`
   * may accidentally reset the new field's value.
   * Not specifying any fields is an error.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask update_mask = 6 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.FieldMaskOrBuilder getUpdateMaskOrBuilder() {
    return updateMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : updateMask_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (bucket_ != null) {
      output.writeMessage(1, getBucket());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeInt64(2, ifMetagenerationMatch_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeInt64(3, ifMetagenerationNotMatch_);
    }
    if (updateMask_ != null) {
      output.writeMessage(6, getUpdateMask());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(predefinedAcl_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, predefinedAcl_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(predefinedDefaultObjectAcl_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, predefinedDefaultObjectAcl_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (bucket_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getBucket());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, ifMetagenerationMatch_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(3, ifMetagenerationNotMatch_);
    }
    if (updateMask_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getUpdateMask());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(predefinedAcl_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, predefinedAcl_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(predefinedDefaultObjectAcl_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(9, predefinedDefaultObjectAcl_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.storage.v2.UpdateBucketRequest)) {
      return super.equals(obj);
    }
    com.google.storage.v2.UpdateBucketRequest other =
        (com.google.storage.v2.UpdateBucketRequest) obj;

    if (hasBucket() != other.hasBucket()) return false;
    if (hasBucket()) {
      if (!getBucket().equals(other.getBucket())) return false;
    }
    if (hasIfMetagenerationMatch() != other.hasIfMetagenerationMatch()) return false;
    if (hasIfMetagenerationMatch()) {
      if (getIfMetagenerationMatch() != other.getIfMetagenerationMatch()) return false;
    }
    if (hasIfMetagenerationNotMatch() != other.hasIfMetagenerationNotMatch()) return false;
    if (hasIfMetagenerationNotMatch()) {
      if (getIfMetagenerationNotMatch() != other.getIfMetagenerationNotMatch()) return false;
    }
    if (!getPredefinedAcl().equals(other.getPredefinedAcl())) return false;
    if (!getPredefinedDefaultObjectAcl().equals(other.getPredefinedDefaultObjectAcl()))
      return false;
    if (hasUpdateMask() != other.hasUpdateMask()) return false;
    if (hasUpdateMask()) {
      if (!getUpdateMask().equals(other.getUpdateMask())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasBucket()) {
      hash = (37 * hash) + BUCKET_FIELD_NUMBER;
      hash = (53 * hash) + getBucket().hashCode();
    }
    if (hasIfMetagenerationMatch()) {
      hash = (37 * hash) + IF_METAGENERATION_MATCH_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getIfMetagenerationMatch());
    }
    if (hasIfMetagenerationNotMatch()) {
      hash = (37 * hash) + IF_METAGENERATION_NOT_MATCH_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getIfMetagenerationNotMatch());
    }
    hash = (37 * hash) + PREDEFINED_ACL_FIELD_NUMBER;
    hash = (53 * hash) + getPredefinedAcl().hashCode();
    hash = (37 * hash) + PREDEFINED_DEFAULT_OBJECT_ACL_FIELD_NUMBER;
    hash = (53 * hash) + getPredefinedDefaultObjectAcl().hashCode();
    if (hasUpdateMask()) {
      hash = (37 * hash) + UPDATE_MASK_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateMask().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.storage.v2.UpdateBucketRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.UpdateBucketRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.UpdateBucketRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.UpdateBucketRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.UpdateBucketRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.UpdateBucketRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.UpdateBucketRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.UpdateBucketRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.storage.v2.UpdateBucketRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.UpdateBucketRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.storage.v2.UpdateBucketRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.UpdateBucketRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.storage.v2.UpdateBucketRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request for UpdateBucket method.
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.UpdateBucketRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.storage.v2.UpdateBucketRequest)
      com.google.storage.v2.UpdateBucketRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_UpdateBucketRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_UpdateBucketRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.UpdateBucketRequest.class,
              com.google.storage.v2.UpdateBucketRequest.Builder.class);
    }

    // Construct using com.google.storage.v2.UpdateBucketRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      bucket_ = null;
      if (bucketBuilder_ != null) {
        bucketBuilder_.dispose();
        bucketBuilder_ = null;
      }
      ifMetagenerationMatch_ = 0L;
      ifMetagenerationNotMatch_ = 0L;
      predefinedAcl_ = "";
      predefinedDefaultObjectAcl_ = "";
      updateMask_ = null;
      if (updateMaskBuilder_ != null) {
        updateMaskBuilder_.dispose();
        updateMaskBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_UpdateBucketRequest_descriptor;
    }

    @java.lang.Override
    public com.google.storage.v2.UpdateBucketRequest getDefaultInstanceForType() {
      return com.google.storage.v2.UpdateBucketRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.storage.v2.UpdateBucketRequest build() {
      com.google.storage.v2.UpdateBucketRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.storage.v2.UpdateBucketRequest buildPartial() {
      com.google.storage.v2.UpdateBucketRequest result =
          new com.google.storage.v2.UpdateBucketRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.storage.v2.UpdateBucketRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.bucket_ = bucketBuilder_ == null ? bucket_ : bucketBuilder_.build();
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.ifMetagenerationMatch_ = ifMetagenerationMatch_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.ifMetagenerationNotMatch_ = ifMetagenerationNotMatch_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.predefinedAcl_ = predefinedAcl_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.predefinedDefaultObjectAcl_ = predefinedDefaultObjectAcl_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.updateMask_ = updateMaskBuilder_ == null ? updateMask_ : updateMaskBuilder_.build();
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.storage.v2.UpdateBucketRequest) {
        return mergeFrom((com.google.storage.v2.UpdateBucketRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.storage.v2.UpdateBucketRequest other) {
      if (other == com.google.storage.v2.UpdateBucketRequest.getDefaultInstance()) return this;
      if (other.hasBucket()) {
        mergeBucket(other.getBucket());
      }
      if (other.hasIfMetagenerationMatch()) {
        setIfMetagenerationMatch(other.getIfMetagenerationMatch());
      }
      if (other.hasIfMetagenerationNotMatch()) {
        setIfMetagenerationNotMatch(other.getIfMetagenerationNotMatch());
      }
      if (!other.getPredefinedAcl().isEmpty()) {
        predefinedAcl_ = other.predefinedAcl_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getPredefinedDefaultObjectAcl().isEmpty()) {
        predefinedDefaultObjectAcl_ = other.predefinedDefaultObjectAcl_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasUpdateMask()) {
        mergeUpdateMask(other.getUpdateMask());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getBucketFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                ifMetagenerationMatch_ = input.readInt64();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 24:
              {
                ifMetagenerationNotMatch_ = input.readInt64();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 50:
              {
                input.readMessage(getUpdateMaskFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 66:
              {
                predefinedAcl_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 66
            case 74:
              {
                predefinedDefaultObjectAcl_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 74
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.storage.v2.Bucket bucket_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Bucket,
            com.google.storage.v2.Bucket.Builder,
            com.google.storage.v2.BucketOrBuilder>
        bucketBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The bucket to update.
     * The bucket's `name` field will be used to identify the bucket.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket bucket = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return Whether the bucket field is set.
     */
    public boolean hasBucket() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The bucket to update.
     * The bucket's `name` field will be used to identify the bucket.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket bucket = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bucket.
     */
    public com.google.storage.v2.Bucket getBucket() {
      if (bucketBuilder_ == null) {
        return bucket_ == null ? com.google.storage.v2.Bucket.getDefaultInstance() : bucket_;
      } else {
        return bucketBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The bucket to update.
     * The bucket's `name` field will be used to identify the bucket.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket bucket = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder setBucket(com.google.storage.v2.Bucket value) {
      if (bucketBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        bucket_ = value;
      } else {
        bucketBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The bucket to update.
     * The bucket's `name` field will be used to identify the bucket.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket bucket = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder setBucket(com.google.storage.v2.Bucket.Builder builderForValue) {
      if (bucketBuilder_ == null) {
        bucket_ = builderForValue.build();
      } else {
        bucketBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The bucket to update.
     * The bucket's `name` field will be used to identify the bucket.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket bucket = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder mergeBucket(com.google.storage.v2.Bucket value) {
      if (bucketBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && bucket_ != null
            && bucket_ != com.google.storage.v2.Bucket.getDefaultInstance()) {
          getBucketBuilder().mergeFrom(value);
        } else {
          bucket_ = value;
        }
      } else {
        bucketBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The bucket to update.
     * The bucket's `name` field will be used to identify the bucket.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket bucket = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder clearBucket() {
      bitField0_ = (bitField0_ & ~0x00000001);
      bucket_ = null;
      if (bucketBuilder_ != null) {
        bucketBuilder_.dispose();
        bucketBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The bucket to update.
     * The bucket's `name` field will be used to identify the bucket.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket bucket = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public com.google.storage.v2.Bucket.Builder getBucketBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getBucketFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The bucket to update.
     * The bucket's `name` field will be used to identify the bucket.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket bucket = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public com.google.storage.v2.BucketOrBuilder getBucketOrBuilder() {
      if (bucketBuilder_ != null) {
        return bucketBuilder_.getMessageOrBuilder();
      } else {
        return bucket_ == null ? com.google.storage.v2.Bucket.getDefaultInstance() : bucket_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The bucket to update.
     * The bucket's `name` field will be used to identify the bucket.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket bucket = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Bucket,
            com.google.storage.v2.Bucket.Builder,
            com.google.storage.v2.BucketOrBuilder>
        getBucketFieldBuilder() {
      if (bucketBuilder_ == null) {
        bucketBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.Bucket,
                com.google.storage.v2.Bucket.Builder,
                com.google.storage.v2.BucketOrBuilder>(
                getBucket(), getParentForChildren(), isClean());
        bucket_ = null;
      }
      return bucketBuilder_;
    }

    private long ifMetagenerationMatch_;
    /**
     *
     *
     * <pre>
     * If set, will only modify the bucket if its metageneration matches this
     * value.
     * </pre>
     *
     * <code>optional int64 if_metageneration_match = 2;</code>
     *
     * @return Whether the ifMetagenerationMatch field is set.
     */
    @java.lang.Override
    public boolean hasIfMetagenerationMatch() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * If set, will only modify the bucket if its metageneration matches this
     * value.
     * </pre>
     *
     * <code>optional int64 if_metageneration_match = 2;</code>
     *
     * @return The ifMetagenerationMatch.
     */
    @java.lang.Override
    public long getIfMetagenerationMatch() {
      return ifMetagenerationMatch_;
    }
    /**
     *
     *
     * <pre>
     * If set, will only modify the bucket if its metageneration matches this
     * value.
     * </pre>
     *
     * <code>optional int64 if_metageneration_match = 2;</code>
     *
     * @param value The ifMetagenerationMatch to set.
     * @return This builder for chaining.
     */
    public Builder setIfMetagenerationMatch(long value) {

      ifMetagenerationMatch_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set, will only modify the bucket if its metageneration matches this
     * value.
     * </pre>
     *
     * <code>optional int64 if_metageneration_match = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIfMetagenerationMatch() {
      bitField0_ = (bitField0_ & ~0x00000002);
      ifMetagenerationMatch_ = 0L;
      onChanged();
      return this;
    }

    private long ifMetagenerationNotMatch_;
    /**
     *
     *
     * <pre>
     * If set, will only modify the bucket if its metageneration does not match
     * this value.
     * </pre>
     *
     * <code>optional int64 if_metageneration_not_match = 3;</code>
     *
     * @return Whether the ifMetagenerationNotMatch field is set.
     */
    @java.lang.Override
    public boolean hasIfMetagenerationNotMatch() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * If set, will only modify the bucket if its metageneration does not match
     * this value.
     * </pre>
     *
     * <code>optional int64 if_metageneration_not_match = 3;</code>
     *
     * @return The ifMetagenerationNotMatch.
     */
    @java.lang.Override
    public long getIfMetagenerationNotMatch() {
      return ifMetagenerationNotMatch_;
    }
    /**
     *
     *
     * <pre>
     * If set, will only modify the bucket if its metageneration does not match
     * this value.
     * </pre>
     *
     * <code>optional int64 if_metageneration_not_match = 3;</code>
     *
     * @param value The ifMetagenerationNotMatch to set.
     * @return This builder for chaining.
     */
    public Builder setIfMetagenerationNotMatch(long value) {

      ifMetagenerationNotMatch_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set, will only modify the bucket if its metageneration does not match
     * this value.
     * </pre>
     *
     * <code>optional int64 if_metageneration_not_match = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIfMetagenerationNotMatch() {
      bitField0_ = (bitField0_ & ~0x00000004);
      ifMetagenerationNotMatch_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object predefinedAcl_ = "";
    /**
     *
     *
     * <pre>
     * Apply a predefined set of access controls to this bucket.
     * Valid values are "authenticatedRead", "private", "projectPrivate",
     * "publicRead", or "publicReadWrite".
     * </pre>
     *
     * <code>string predefined_acl = 8;</code>
     *
     * @return The predefinedAcl.
     */
    public java.lang.String getPredefinedAcl() {
      java.lang.Object ref = predefinedAcl_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        predefinedAcl_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Apply a predefined set of access controls to this bucket.
     * Valid values are "authenticatedRead", "private", "projectPrivate",
     * "publicRead", or "publicReadWrite".
     * </pre>
     *
     * <code>string predefined_acl = 8;</code>
     *
     * @return The bytes for predefinedAcl.
     */
    public com.google.protobuf.ByteString getPredefinedAclBytes() {
      java.lang.Object ref = predefinedAcl_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        predefinedAcl_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Apply a predefined set of access controls to this bucket.
     * Valid values are "authenticatedRead", "private", "projectPrivate",
     * "publicRead", or "publicReadWrite".
     * </pre>
     *
     * <code>string predefined_acl = 8;</code>
     *
     * @param value The predefinedAcl to set.
     * @return This builder for chaining.
     */
    public Builder setPredefinedAcl(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      predefinedAcl_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Apply a predefined set of access controls to this bucket.
     * Valid values are "authenticatedRead", "private", "projectPrivate",
     * "publicRead", or "publicReadWrite".
     * </pre>
     *
     * <code>string predefined_acl = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPredefinedAcl() {
      predefinedAcl_ = getDefaultInstance().getPredefinedAcl();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Apply a predefined set of access controls to this bucket.
     * Valid values are "authenticatedRead", "private", "projectPrivate",
     * "publicRead", or "publicReadWrite".
     * </pre>
     *
     * <code>string predefined_acl = 8;</code>
     *
     * @param value The bytes for predefinedAcl to set.
     * @return This builder for chaining.
     */
    public Builder setPredefinedAclBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      predefinedAcl_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object predefinedDefaultObjectAcl_ = "";
    /**
     *
     *
     * <pre>
     * Apply a predefined set of default object access controls to this bucket.
     * Valid values are "authenticatedRead", "bucketOwnerFullControl",
     * "bucketOwnerRead", "private", "projectPrivate", or "publicRead".
     * </pre>
     *
     * <code>string predefined_default_object_acl = 9;</code>
     *
     * @return The predefinedDefaultObjectAcl.
     */
    public java.lang.String getPredefinedDefaultObjectAcl() {
      java.lang.Object ref = predefinedDefaultObjectAcl_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        predefinedDefaultObjectAcl_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Apply a predefined set of default object access controls to this bucket.
     * Valid values are "authenticatedRead", "bucketOwnerFullControl",
     * "bucketOwnerRead", "private", "projectPrivate", or "publicRead".
     * </pre>
     *
     * <code>string predefined_default_object_acl = 9;</code>
     *
     * @return The bytes for predefinedDefaultObjectAcl.
     */
    public com.google.protobuf.ByteString getPredefinedDefaultObjectAclBytes() {
      java.lang.Object ref = predefinedDefaultObjectAcl_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        predefinedDefaultObjectAcl_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Apply a predefined set of default object access controls to this bucket.
     * Valid values are "authenticatedRead", "bucketOwnerFullControl",
     * "bucketOwnerRead", "private", "projectPrivate", or "publicRead".
     * </pre>
     *
     * <code>string predefined_default_object_acl = 9;</code>
     *
     * @param value The predefinedDefaultObjectAcl to set.
     * @return This builder for chaining.
     */
    public Builder setPredefinedDefaultObjectAcl(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      predefinedDefaultObjectAcl_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Apply a predefined set of default object access controls to this bucket.
     * Valid values are "authenticatedRead", "bucketOwnerFullControl",
     * "bucketOwnerRead", "private", "projectPrivate", or "publicRead".
     * </pre>
     *
     * <code>string predefined_default_object_acl = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPredefinedDefaultObjectAcl() {
      predefinedDefaultObjectAcl_ = getDefaultInstance().getPredefinedDefaultObjectAcl();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Apply a predefined set of default object access controls to this bucket.
     * Valid values are "authenticatedRead", "bucketOwnerFullControl",
     * "bucketOwnerRead", "private", "projectPrivate", or "publicRead".
     * </pre>
     *
     * <code>string predefined_default_object_acl = 9;</code>
     *
     * @param value The bytes for predefinedDefaultObjectAcl to set.
     * @return This builder for chaining.
     */
    public Builder setPredefinedDefaultObjectAclBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      predefinedDefaultObjectAcl_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.protobuf.FieldMask updateMask_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        updateMaskBuilder_;
    /**
     *
     *
     * <pre>
     * Required. List of fields to be updated.
     * To specify ALL fields, equivalent to the JSON API's "update" function,
     * specify a single field with the value `*`. Note: not recommended. If a new
     * field is introduced at a later time, an older client updating with the `*`
     * may accidentally reset the new field's value.
     * Not specifying any fields is an error.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the updateMask field is set.
     */
    public boolean hasUpdateMask() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. List of fields to be updated.
     * To specify ALL fields, equivalent to the JSON API's "update" function,
     * specify a single field with the value `*`. Note: not recommended. If a new
     * field is introduced at a later time, an older client updating with the `*`
     * may accidentally reset the new field's value.
     * Not specifying any fields is an error.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The updateMask.
     */
    public com.google.protobuf.FieldMask getUpdateMask() {
      if (updateMaskBuilder_ == null) {
        return updateMask_ == null
            ? com.google.protobuf.FieldMask.getDefaultInstance()
            : updateMask_;
      } else {
        return updateMaskBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. List of fields to be updated.
     * To specify ALL fields, equivalent to the JSON API's "update" function,
     * specify a single field with the value `*`. Note: not recommended. If a new
     * field is introduced at a later time, an older client updating with the `*`
     * may accidentally reset the new field's value.
     * Not specifying any fields is an error.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setUpdateMask(com.google.protobuf.FieldMask value) {
      if (updateMaskBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateMask_ = value;
      } else {
        updateMaskBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. List of fields to be updated.
     * To specify ALL fields, equivalent to the JSON API's "update" function,
     * specify a single field with the value `*`. Note: not recommended. If a new
     * field is introduced at a later time, an older client updating with the `*`
     * may accidentally reset the new field's value.
     * Not specifying any fields is an error.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setUpdateMask(com.google.protobuf.FieldMask.Builder builderForValue) {
      if (updateMaskBuilder_ == null) {
        updateMask_ = builderForValue.build();
      } else {
        updateMaskBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. List of fields to be updated.
     * To specify ALL fields, equivalent to the JSON API's "update" function,
     * specify a single field with the value `*`. Note: not recommended. If a new
     * field is introduced at a later time, an older client updating with the `*`
     * may accidentally reset the new field's value.
     * Not specifying any fields is an error.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeUpdateMask(com.google.protobuf.FieldMask value) {
      if (updateMaskBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && updateMask_ != null
            && updateMask_ != com.google.protobuf.FieldMask.getDefaultInstance()) {
          getUpdateMaskBuilder().mergeFrom(value);
        } else {
          updateMask_ = value;
        }
      } else {
        updateMaskBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. List of fields to be updated.
     * To specify ALL fields, equivalent to the JSON API's "update" function,
     * specify a single field with the value `*`. Note: not recommended. If a new
     * field is introduced at a later time, an older client updating with the `*`
     * may accidentally reset the new field's value.
     * Not specifying any fields is an error.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearUpdateMask() {
      bitField0_ = (bitField0_ & ~0x00000020);
      updateMask_ = null;
      if (updateMaskBuilder_ != null) {
        updateMaskBuilder_.dispose();
        updateMaskBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. List of fields to be updated.
     * To specify ALL fields, equivalent to the JSON API's "update" function,
     * specify a single field with the value `*`. Note: not recommended. If a new
     * field is introduced at a later time, an older client updating with the `*`
     * may accidentally reset the new field's value.
     * Not specifying any fields is an error.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.protobuf.FieldMask.Builder getUpdateMaskBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getUpdateMaskFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. List of fields to be updated.
     * To specify ALL fields, equivalent to the JSON API's "update" function,
     * specify a single field with the value `*`. Note: not recommended. If a new
     * field is introduced at a later time, an older client updating with the `*`
     * may accidentally reset the new field's value.
     * Not specifying any fields is an error.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.protobuf.FieldMaskOrBuilder getUpdateMaskOrBuilder() {
      if (updateMaskBuilder_ != null) {
        return updateMaskBuilder_.getMessageOrBuilder();
      } else {
        return updateMask_ == null
            ? com.google.protobuf.FieldMask.getDefaultInstance()
            : updateMask_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. List of fields to be updated.
     * To specify ALL fields, equivalent to the JSON API's "update" function,
     * specify a single field with the value `*`. Note: not recommended. If a new
     * field is introduced at a later time, an older client updating with the `*`
     * may accidentally reset the new field's value.
     * Not specifying any fields is an error.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        getUpdateMaskFieldBuilder() {
      if (updateMaskBuilder_ == null) {
        updateMaskBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.FieldMask,
                com.google.protobuf.FieldMask.Builder,
                com.google.protobuf.FieldMaskOrBuilder>(
                getUpdateMask(), getParentForChildren(), isClean());
        updateMask_ = null;
      }
      return updateMaskBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.storage.v2.UpdateBucketRequest)
  }

  // @@protoc_insertion_point(class_scope:google.storage.v2.UpdateBucketRequest)
  private static final com.google.storage.v2.UpdateBucketRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.storage.v2.UpdateBucketRequest();
  }

  public static com.google.storage.v2.UpdateBucketRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<UpdateBucketRequest> PARSER =
      new com.google.protobuf.AbstractParser<UpdateBucketRequest>() {
        @java.lang.Override
        public UpdateBucketRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<UpdateBucketRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<UpdateBucketRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.storage.v2.UpdateBucketRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
