/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/storage/v2/storage.proto

package com.google.storage.v2;

/**
 *
 *
 * <pre>
 * An access-control entry.
 * </pre>
 *
 * Protobuf type {@code google.storage.v2.ObjectAccessControl}
 */
public final class ObjectAccessControl extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.storage.v2.ObjectAccessControl)
    ObjectAccessControlOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ObjectAccessControl.newBuilder() to construct.
  private ObjectAccessControl(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ObjectAccessControl() {
    role_ = "";
    id_ = "";
    entity_ = "";
    entityAlt_ = "";
    entityId_ = "";
    etag_ = "";
    email_ = "";
    domain_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ObjectAccessControl();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.storage.v2.StorageProto
        .internal_static_google_storage_v2_ObjectAccessControl_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.storage.v2.StorageProto
        .internal_static_google_storage_v2_ObjectAccessControl_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.storage.v2.ObjectAccessControl.class,
            com.google.storage.v2.ObjectAccessControl.Builder.class);
  }

  public static final int ROLE_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object role_ = "";
  /**
   *
   *
   * <pre>
   * The access permission for the entity.
   * </pre>
   *
   * <code>string role = 1;</code>
   *
   * @return The role.
   */
  @java.lang.Override
  public java.lang.String getRole() {
    java.lang.Object ref = role_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      role_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The access permission for the entity.
   * </pre>
   *
   * <code>string role = 1;</code>
   *
   * @return The bytes for role.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRoleBytes() {
    java.lang.Object ref = role_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      role_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object id_ = "";
  /**
   *
   *
   * <pre>
   * The ID of the access-control entry.
   * </pre>
   *
   * <code>string id = 2;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public java.lang.String getId() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      id_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The ID of the access-control entry.
   * </pre>
   *
   * <code>string id = 2;</code>
   *
   * @return The bytes for id.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIdBytes() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      id_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENTITY_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object entity_ = "";
  /**
   *
   *
   * <pre>
   * The entity holding the permission, in one of the following forms:
   * * `user-{userid}`
   * * `user-{email}`
   * * `group-{groupid}`
   * * `group-{email}`
   * * `domain-{domain}`
   * * `project-{team}-{projectnumber}`
   * * `project-{team}-{projectid}`
   * * `allUsers`
   * * `allAuthenticatedUsers`
   * Examples:
   * * The user `liz&#64;example.com` would be `user-liz&#64;example.com`.
   * * The group `example&#64;googlegroups.com` would be
   * `group-example&#64;googlegroups.com`.
   * * All members of the Google Apps for Business domain `example.com` would be
   * `domain-example.com`.
   * For project entities, `project-{team}-{projectnumber}` format will be
   * returned on response.
   * </pre>
   *
   * <code>string entity = 3;</code>
   *
   * @return The entity.
   */
  @java.lang.Override
  public java.lang.String getEntity() {
    java.lang.Object ref = entity_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      entity_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The entity holding the permission, in one of the following forms:
   * * `user-{userid}`
   * * `user-{email}`
   * * `group-{groupid}`
   * * `group-{email}`
   * * `domain-{domain}`
   * * `project-{team}-{projectnumber}`
   * * `project-{team}-{projectid}`
   * * `allUsers`
   * * `allAuthenticatedUsers`
   * Examples:
   * * The user `liz&#64;example.com` would be `user-liz&#64;example.com`.
   * * The group `example&#64;googlegroups.com` would be
   * `group-example&#64;googlegroups.com`.
   * * All members of the Google Apps for Business domain `example.com` would be
   * `domain-example.com`.
   * For project entities, `project-{team}-{projectnumber}` format will be
   * returned on response.
   * </pre>
   *
   * <code>string entity = 3;</code>
   *
   * @return The bytes for entity.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEntityBytes() {
    java.lang.Object ref = entity_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      entity_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENTITY_ALT_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object entityAlt_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The alternative entity format, if exists. For project
   * entities, `project-{team}-{projectid}` format will be returned on response.
   * </pre>
   *
   * <code>string entity_alt = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The entityAlt.
   */
  @java.lang.Override
  public java.lang.String getEntityAlt() {
    java.lang.Object ref = entityAlt_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      entityAlt_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The alternative entity format, if exists. For project
   * entities, `project-{team}-{projectid}` format will be returned on response.
   * </pre>
   *
   * <code>string entity_alt = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for entityAlt.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEntityAltBytes() {
    java.lang.Object ref = entityAlt_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      entityAlt_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENTITY_ID_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object entityId_ = "";
  /**
   *
   *
   * <pre>
   * The ID for the entity, if any.
   * </pre>
   *
   * <code>string entity_id = 4;</code>
   *
   * @return The entityId.
   */
  @java.lang.Override
  public java.lang.String getEntityId() {
    java.lang.Object ref = entityId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      entityId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The ID for the entity, if any.
   * </pre>
   *
   * <code>string entity_id = 4;</code>
   *
   * @return The bytes for entityId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEntityIdBytes() {
    java.lang.Object ref = entityId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      entityId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ETAG_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";
  /**
   *
   *
   * <pre>
   * The etag of the ObjectAccessControl.
   * If included in the metadata of an update or delete request message, the
   * operation will only be performed if the etag matches that of the live
   * object's ObjectAccessControl.
   * </pre>
   *
   * <code>string etag = 8;</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The etag of the ObjectAccessControl.
   * If included in the metadata of an update or delete request message, the
   * operation will only be performed if the etag matches that of the live
   * object's ObjectAccessControl.
   * </pre>
   *
   * <code>string etag = 8;</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EMAIL_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object email_ = "";
  /**
   *
   *
   * <pre>
   * The email address associated with the entity, if any.
   * </pre>
   *
   * <code>string email = 5;</code>
   *
   * @return The email.
   */
  @java.lang.Override
  public java.lang.String getEmail() {
    java.lang.Object ref = email_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      email_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The email address associated with the entity, if any.
   * </pre>
   *
   * <code>string email = 5;</code>
   *
   * @return The bytes for email.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEmailBytes() {
    java.lang.Object ref = email_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      email_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DOMAIN_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object domain_ = "";
  /**
   *
   *
   * <pre>
   * The domain associated with the entity, if any.
   * </pre>
   *
   * <code>string domain = 6;</code>
   *
   * @return The domain.
   */
  @java.lang.Override
  public java.lang.String getDomain() {
    java.lang.Object ref = domain_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      domain_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The domain associated with the entity, if any.
   * </pre>
   *
   * <code>string domain = 6;</code>
   *
   * @return The bytes for domain.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDomainBytes() {
    java.lang.Object ref = domain_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      domain_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PROJECT_TEAM_FIELD_NUMBER = 7;
  private com.google.storage.v2.ProjectTeam projectTeam_;
  /**
   *
   *
   * <pre>
   * The project team associated with the entity, if any.
   * </pre>
   *
   * <code>.google.storage.v2.ProjectTeam project_team = 7;</code>
   *
   * @return Whether the projectTeam field is set.
   */
  @java.lang.Override
  public boolean hasProjectTeam() {
    return projectTeam_ != null;
  }
  /**
   *
   *
   * <pre>
   * The project team associated with the entity, if any.
   * </pre>
   *
   * <code>.google.storage.v2.ProjectTeam project_team = 7;</code>
   *
   * @return The projectTeam.
   */
  @java.lang.Override
  public com.google.storage.v2.ProjectTeam getProjectTeam() {
    return projectTeam_ == null
        ? com.google.storage.v2.ProjectTeam.getDefaultInstance()
        : projectTeam_;
  }
  /**
   *
   *
   * <pre>
   * The project team associated with the entity, if any.
   * </pre>
   *
   * <code>.google.storage.v2.ProjectTeam project_team = 7;</code>
   */
  @java.lang.Override
  public com.google.storage.v2.ProjectTeamOrBuilder getProjectTeamOrBuilder() {
    return projectTeam_ == null
        ? com.google.storage.v2.ProjectTeam.getDefaultInstance()
        : projectTeam_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(role_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, role_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, id_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(entity_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, entity_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(entityId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, entityId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(email_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, email_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(domain_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, domain_);
    }
    if (projectTeam_ != null) {
      output.writeMessage(7, getProjectTeam());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, etag_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(entityAlt_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, entityAlt_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(role_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, role_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, id_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(entity_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, entity_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(entityId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, entityId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(email_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, email_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(domain_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, domain_);
    }
    if (projectTeam_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getProjectTeam());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, etag_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(entityAlt_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, entityAlt_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.storage.v2.ObjectAccessControl)) {
      return super.equals(obj);
    }
    com.google.storage.v2.ObjectAccessControl other =
        (com.google.storage.v2.ObjectAccessControl) obj;

    if (!getRole().equals(other.getRole())) return false;
    if (!getId().equals(other.getId())) return false;
    if (!getEntity().equals(other.getEntity())) return false;
    if (!getEntityAlt().equals(other.getEntityAlt())) return false;
    if (!getEntityId().equals(other.getEntityId())) return false;
    if (!getEtag().equals(other.getEtag())) return false;
    if (!getEmail().equals(other.getEmail())) return false;
    if (!getDomain().equals(other.getDomain())) return false;
    if (hasProjectTeam() != other.hasProjectTeam()) return false;
    if (hasProjectTeam()) {
      if (!getProjectTeam().equals(other.getProjectTeam())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ROLE_FIELD_NUMBER;
    hash = (53 * hash) + getRole().hashCode();
    hash = (37 * hash) + ID_FIELD_NUMBER;
    hash = (53 * hash) + getId().hashCode();
    hash = (37 * hash) + ENTITY_FIELD_NUMBER;
    hash = (53 * hash) + getEntity().hashCode();
    hash = (37 * hash) + ENTITY_ALT_FIELD_NUMBER;
    hash = (53 * hash) + getEntityAlt().hashCode();
    hash = (37 * hash) + ENTITY_ID_FIELD_NUMBER;
    hash = (53 * hash) + getEntityId().hashCode();
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    hash = (37 * hash) + EMAIL_FIELD_NUMBER;
    hash = (53 * hash) + getEmail().hashCode();
    hash = (37 * hash) + DOMAIN_FIELD_NUMBER;
    hash = (53 * hash) + getDomain().hashCode();
    if (hasProjectTeam()) {
      hash = (37 * hash) + PROJECT_TEAM_FIELD_NUMBER;
      hash = (53 * hash) + getProjectTeam().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.storage.v2.ObjectAccessControl parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.ObjectAccessControl parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.ObjectAccessControl parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.ObjectAccessControl parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.ObjectAccessControl parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.ObjectAccessControl parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.ObjectAccessControl parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.ObjectAccessControl parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.storage.v2.ObjectAccessControl parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.ObjectAccessControl parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.storage.v2.ObjectAccessControl parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.ObjectAccessControl parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.storage.v2.ObjectAccessControl prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * An access-control entry.
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.ObjectAccessControl}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.storage.v2.ObjectAccessControl)
      com.google.storage.v2.ObjectAccessControlOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_ObjectAccessControl_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_ObjectAccessControl_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.ObjectAccessControl.class,
              com.google.storage.v2.ObjectAccessControl.Builder.class);
    }

    // Construct using com.google.storage.v2.ObjectAccessControl.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      role_ = "";
      id_ = "";
      entity_ = "";
      entityAlt_ = "";
      entityId_ = "";
      etag_ = "";
      email_ = "";
      domain_ = "";
      projectTeam_ = null;
      if (projectTeamBuilder_ != null) {
        projectTeamBuilder_.dispose();
        projectTeamBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_ObjectAccessControl_descriptor;
    }

    @java.lang.Override
    public com.google.storage.v2.ObjectAccessControl getDefaultInstanceForType() {
      return com.google.storage.v2.ObjectAccessControl.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.storage.v2.ObjectAccessControl build() {
      com.google.storage.v2.ObjectAccessControl result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.storage.v2.ObjectAccessControl buildPartial() {
      com.google.storage.v2.ObjectAccessControl result =
          new com.google.storage.v2.ObjectAccessControl(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.storage.v2.ObjectAccessControl result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.role_ = role_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.id_ = id_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.entity_ = entity_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.entityAlt_ = entityAlt_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.entityId_ = entityId_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.etag_ = etag_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.email_ = email_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.domain_ = domain_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.projectTeam_ =
            projectTeamBuilder_ == null ? projectTeam_ : projectTeamBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.storage.v2.ObjectAccessControl) {
        return mergeFrom((com.google.storage.v2.ObjectAccessControl) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.storage.v2.ObjectAccessControl other) {
      if (other == com.google.storage.v2.ObjectAccessControl.getDefaultInstance()) return this;
      if (!other.getRole().isEmpty()) {
        role_ = other.role_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getId().isEmpty()) {
        id_ = other.id_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getEntity().isEmpty()) {
        entity_ = other.entity_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getEntityAlt().isEmpty()) {
        entityAlt_ = other.entityAlt_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getEntityId().isEmpty()) {
        entityId_ = other.entityId_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getEmail().isEmpty()) {
        email_ = other.email_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (!other.getDomain().isEmpty()) {
        domain_ = other.domain_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (other.hasProjectTeam()) {
        mergeProjectTeam(other.getProjectTeam());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                role_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                id_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                entity_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                entityId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 34
            case 42:
              {
                email_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 42
            case 50:
              {
                domain_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getProjectTeamFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 58
            case 66:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 66
            case 74:
              {
                entityAlt_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 74
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object role_ = "";
    /**
     *
     *
     * <pre>
     * The access permission for the entity.
     * </pre>
     *
     * <code>string role = 1;</code>
     *
     * @return The role.
     */
    public java.lang.String getRole() {
      java.lang.Object ref = role_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        role_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The access permission for the entity.
     * </pre>
     *
     * <code>string role = 1;</code>
     *
     * @return The bytes for role.
     */
    public com.google.protobuf.ByteString getRoleBytes() {
      java.lang.Object ref = role_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        role_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The access permission for the entity.
     * </pre>
     *
     * <code>string role = 1;</code>
     *
     * @param value The role to set.
     * @return This builder for chaining.
     */
    public Builder setRole(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      role_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The access permission for the entity.
     * </pre>
     *
     * <code>string role = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRole() {
      role_ = getDefaultInstance().getRole();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The access permission for the entity.
     * </pre>
     *
     * <code>string role = 1;</code>
     *
     * @param value The bytes for role to set.
     * @return This builder for chaining.
     */
    public Builder setRoleBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      role_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object id_ = "";
    /**
     *
     *
     * <pre>
     * The ID of the access-control entry.
     * </pre>
     *
     * <code>string id = 2;</code>
     *
     * @return The id.
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The ID of the access-control entry.
     * </pre>
     *
     * <code>string id = 2;</code>
     *
     * @return The bytes for id.
     */
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The ID of the access-control entry.
     * </pre>
     *
     * <code>string id = 2;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      id_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The ID of the access-control entry.
     * </pre>
     *
     * <code>string id = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      id_ = getDefaultInstance().getId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The ID of the access-control entry.
     * </pre>
     *
     * <code>string id = 2;</code>
     *
     * @param value The bytes for id to set.
     * @return This builder for chaining.
     */
    public Builder setIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      id_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object entity_ = "";
    /**
     *
     *
     * <pre>
     * The entity holding the permission, in one of the following forms:
     * * `user-{userid}`
     * * `user-{email}`
     * * `group-{groupid}`
     * * `group-{email}`
     * * `domain-{domain}`
     * * `project-{team}-{projectnumber}`
     * * `project-{team}-{projectid}`
     * * `allUsers`
     * * `allAuthenticatedUsers`
     * Examples:
     * * The user `liz&#64;example.com` would be `user-liz&#64;example.com`.
     * * The group `example&#64;googlegroups.com` would be
     * `group-example&#64;googlegroups.com`.
     * * All members of the Google Apps for Business domain `example.com` would be
     * `domain-example.com`.
     * For project entities, `project-{team}-{projectnumber}` format will be
     * returned on response.
     * </pre>
     *
     * <code>string entity = 3;</code>
     *
     * @return The entity.
     */
    public java.lang.String getEntity() {
      java.lang.Object ref = entity_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        entity_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The entity holding the permission, in one of the following forms:
     * * `user-{userid}`
     * * `user-{email}`
     * * `group-{groupid}`
     * * `group-{email}`
     * * `domain-{domain}`
     * * `project-{team}-{projectnumber}`
     * * `project-{team}-{projectid}`
     * * `allUsers`
     * * `allAuthenticatedUsers`
     * Examples:
     * * The user `liz&#64;example.com` would be `user-liz&#64;example.com`.
     * * The group `example&#64;googlegroups.com` would be
     * `group-example&#64;googlegroups.com`.
     * * All members of the Google Apps for Business domain `example.com` would be
     * `domain-example.com`.
     * For project entities, `project-{team}-{projectnumber}` format will be
     * returned on response.
     * </pre>
     *
     * <code>string entity = 3;</code>
     *
     * @return The bytes for entity.
     */
    public com.google.protobuf.ByteString getEntityBytes() {
      java.lang.Object ref = entity_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        entity_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The entity holding the permission, in one of the following forms:
     * * `user-{userid}`
     * * `user-{email}`
     * * `group-{groupid}`
     * * `group-{email}`
     * * `domain-{domain}`
     * * `project-{team}-{projectnumber}`
     * * `project-{team}-{projectid}`
     * * `allUsers`
     * * `allAuthenticatedUsers`
     * Examples:
     * * The user `liz&#64;example.com` would be `user-liz&#64;example.com`.
     * * The group `example&#64;googlegroups.com` would be
     * `group-example&#64;googlegroups.com`.
     * * All members of the Google Apps for Business domain `example.com` would be
     * `domain-example.com`.
     * For project entities, `project-{team}-{projectnumber}` format will be
     * returned on response.
     * </pre>
     *
     * <code>string entity = 3;</code>
     *
     * @param value The entity to set.
     * @return This builder for chaining.
     */
    public Builder setEntity(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      entity_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The entity holding the permission, in one of the following forms:
     * * `user-{userid}`
     * * `user-{email}`
     * * `group-{groupid}`
     * * `group-{email}`
     * * `domain-{domain}`
     * * `project-{team}-{projectnumber}`
     * * `project-{team}-{projectid}`
     * * `allUsers`
     * * `allAuthenticatedUsers`
     * Examples:
     * * The user `liz&#64;example.com` would be `user-liz&#64;example.com`.
     * * The group `example&#64;googlegroups.com` would be
     * `group-example&#64;googlegroups.com`.
     * * All members of the Google Apps for Business domain `example.com` would be
     * `domain-example.com`.
     * For project entities, `project-{team}-{projectnumber}` format will be
     * returned on response.
     * </pre>
     *
     * <code>string entity = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEntity() {
      entity_ = getDefaultInstance().getEntity();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The entity holding the permission, in one of the following forms:
     * * `user-{userid}`
     * * `user-{email}`
     * * `group-{groupid}`
     * * `group-{email}`
     * * `domain-{domain}`
     * * `project-{team}-{projectnumber}`
     * * `project-{team}-{projectid}`
     * * `allUsers`
     * * `allAuthenticatedUsers`
     * Examples:
     * * The user `liz&#64;example.com` would be `user-liz&#64;example.com`.
     * * The group `example&#64;googlegroups.com` would be
     * `group-example&#64;googlegroups.com`.
     * * All members of the Google Apps for Business domain `example.com` would be
     * `domain-example.com`.
     * For project entities, `project-{team}-{projectnumber}` format will be
     * returned on response.
     * </pre>
     *
     * <code>string entity = 3;</code>
     *
     * @param value The bytes for entity to set.
     * @return This builder for chaining.
     */
    public Builder setEntityBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      entity_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object entityAlt_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The alternative entity format, if exists. For project
     * entities, `project-{team}-{projectid}` format will be returned on response.
     * </pre>
     *
     * <code>string entity_alt = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The entityAlt.
     */
    public java.lang.String getEntityAlt() {
      java.lang.Object ref = entityAlt_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        entityAlt_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The alternative entity format, if exists. For project
     * entities, `project-{team}-{projectid}` format will be returned on response.
     * </pre>
     *
     * <code>string entity_alt = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for entityAlt.
     */
    public com.google.protobuf.ByteString getEntityAltBytes() {
      java.lang.Object ref = entityAlt_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        entityAlt_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The alternative entity format, if exists. For project
     * entities, `project-{team}-{projectid}` format will be returned on response.
     * </pre>
     *
     * <code>string entity_alt = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The entityAlt to set.
     * @return This builder for chaining.
     */
    public Builder setEntityAlt(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      entityAlt_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The alternative entity format, if exists. For project
     * entities, `project-{team}-{projectid}` format will be returned on response.
     * </pre>
     *
     * <code>string entity_alt = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEntityAlt() {
      entityAlt_ = getDefaultInstance().getEntityAlt();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The alternative entity format, if exists. For project
     * entities, `project-{team}-{projectid}` format will be returned on response.
     * </pre>
     *
     * <code>string entity_alt = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for entityAlt to set.
     * @return This builder for chaining.
     */
    public Builder setEntityAltBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      entityAlt_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object entityId_ = "";
    /**
     *
     *
     * <pre>
     * The ID for the entity, if any.
     * </pre>
     *
     * <code>string entity_id = 4;</code>
     *
     * @return The entityId.
     */
    public java.lang.String getEntityId() {
      java.lang.Object ref = entityId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        entityId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The ID for the entity, if any.
     * </pre>
     *
     * <code>string entity_id = 4;</code>
     *
     * @return The bytes for entityId.
     */
    public com.google.protobuf.ByteString getEntityIdBytes() {
      java.lang.Object ref = entityId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        entityId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The ID for the entity, if any.
     * </pre>
     *
     * <code>string entity_id = 4;</code>
     *
     * @param value The entityId to set.
     * @return This builder for chaining.
     */
    public Builder setEntityId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      entityId_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The ID for the entity, if any.
     * </pre>
     *
     * <code>string entity_id = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEntityId() {
      entityId_ = getDefaultInstance().getEntityId();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The ID for the entity, if any.
     * </pre>
     *
     * <code>string entity_id = 4;</code>
     *
     * @param value The bytes for entityId to set.
     * @return This builder for chaining.
     */
    public Builder setEntityIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      entityId_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object etag_ = "";
    /**
     *
     *
     * <pre>
     * The etag of the ObjectAccessControl.
     * If included in the metadata of an update or delete request message, the
     * operation will only be performed if the etag matches that of the live
     * object's ObjectAccessControl.
     * </pre>
     *
     * <code>string etag = 8;</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The etag of the ObjectAccessControl.
     * If included in the metadata of an update or delete request message, the
     * operation will only be performed if the etag matches that of the live
     * object's ObjectAccessControl.
     * </pre>
     *
     * <code>string etag = 8;</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The etag of the ObjectAccessControl.
     * If included in the metadata of an update or delete request message, the
     * operation will only be performed if the etag matches that of the live
     * object's ObjectAccessControl.
     * </pre>
     *
     * <code>string etag = 8;</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The etag of the ObjectAccessControl.
     * If included in the metadata of an update or delete request message, the
     * operation will only be performed if the etag matches that of the live
     * object's ObjectAccessControl.
     * </pre>
     *
     * <code>string etag = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The etag of the ObjectAccessControl.
     * If included in the metadata of an update or delete request message, the
     * operation will only be performed if the etag matches that of the live
     * object's ObjectAccessControl.
     * </pre>
     *
     * <code>string etag = 8;</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object email_ = "";
    /**
     *
     *
     * <pre>
     * The email address associated with the entity, if any.
     * </pre>
     *
     * <code>string email = 5;</code>
     *
     * @return The email.
     */
    public java.lang.String getEmail() {
      java.lang.Object ref = email_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        email_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The email address associated with the entity, if any.
     * </pre>
     *
     * <code>string email = 5;</code>
     *
     * @return The bytes for email.
     */
    public com.google.protobuf.ByteString getEmailBytes() {
      java.lang.Object ref = email_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        email_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The email address associated with the entity, if any.
     * </pre>
     *
     * <code>string email = 5;</code>
     *
     * @param value The email to set.
     * @return This builder for chaining.
     */
    public Builder setEmail(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      email_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The email address associated with the entity, if any.
     * </pre>
     *
     * <code>string email = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEmail() {
      email_ = getDefaultInstance().getEmail();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The email address associated with the entity, if any.
     * </pre>
     *
     * <code>string email = 5;</code>
     *
     * @param value The bytes for email to set.
     * @return This builder for chaining.
     */
    public Builder setEmailBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      email_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object domain_ = "";
    /**
     *
     *
     * <pre>
     * The domain associated with the entity, if any.
     * </pre>
     *
     * <code>string domain = 6;</code>
     *
     * @return The domain.
     */
    public java.lang.String getDomain() {
      java.lang.Object ref = domain_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        domain_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The domain associated with the entity, if any.
     * </pre>
     *
     * <code>string domain = 6;</code>
     *
     * @return The bytes for domain.
     */
    public com.google.protobuf.ByteString getDomainBytes() {
      java.lang.Object ref = domain_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        domain_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The domain associated with the entity, if any.
     * </pre>
     *
     * <code>string domain = 6;</code>
     *
     * @param value The domain to set.
     * @return This builder for chaining.
     */
    public Builder setDomain(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      domain_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The domain associated with the entity, if any.
     * </pre>
     *
     * <code>string domain = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDomain() {
      domain_ = getDefaultInstance().getDomain();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The domain associated with the entity, if any.
     * </pre>
     *
     * <code>string domain = 6;</code>
     *
     * @param value The bytes for domain to set.
     * @return This builder for chaining.
     */
    public Builder setDomainBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      domain_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private com.google.storage.v2.ProjectTeam projectTeam_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.ProjectTeam,
            com.google.storage.v2.ProjectTeam.Builder,
            com.google.storage.v2.ProjectTeamOrBuilder>
        projectTeamBuilder_;
    /**
     *
     *
     * <pre>
     * The project team associated with the entity, if any.
     * </pre>
     *
     * <code>.google.storage.v2.ProjectTeam project_team = 7;</code>
     *
     * @return Whether the projectTeam field is set.
     */
    public boolean hasProjectTeam() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * The project team associated with the entity, if any.
     * </pre>
     *
     * <code>.google.storage.v2.ProjectTeam project_team = 7;</code>
     *
     * @return The projectTeam.
     */
    public com.google.storage.v2.ProjectTeam getProjectTeam() {
      if (projectTeamBuilder_ == null) {
        return projectTeam_ == null
            ? com.google.storage.v2.ProjectTeam.getDefaultInstance()
            : projectTeam_;
      } else {
        return projectTeamBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The project team associated with the entity, if any.
     * </pre>
     *
     * <code>.google.storage.v2.ProjectTeam project_team = 7;</code>
     */
    public Builder setProjectTeam(com.google.storage.v2.ProjectTeam value) {
      if (projectTeamBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        projectTeam_ = value;
      } else {
        projectTeamBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The project team associated with the entity, if any.
     * </pre>
     *
     * <code>.google.storage.v2.ProjectTeam project_team = 7;</code>
     */
    public Builder setProjectTeam(com.google.storage.v2.ProjectTeam.Builder builderForValue) {
      if (projectTeamBuilder_ == null) {
        projectTeam_ = builderForValue.build();
      } else {
        projectTeamBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The project team associated with the entity, if any.
     * </pre>
     *
     * <code>.google.storage.v2.ProjectTeam project_team = 7;</code>
     */
    public Builder mergeProjectTeam(com.google.storage.v2.ProjectTeam value) {
      if (projectTeamBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && projectTeam_ != null
            && projectTeam_ != com.google.storage.v2.ProjectTeam.getDefaultInstance()) {
          getProjectTeamBuilder().mergeFrom(value);
        } else {
          projectTeam_ = value;
        }
      } else {
        projectTeamBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The project team associated with the entity, if any.
     * </pre>
     *
     * <code>.google.storage.v2.ProjectTeam project_team = 7;</code>
     */
    public Builder clearProjectTeam() {
      bitField0_ = (bitField0_ & ~0x00000100);
      projectTeam_ = null;
      if (projectTeamBuilder_ != null) {
        projectTeamBuilder_.dispose();
        projectTeamBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The project team associated with the entity, if any.
     * </pre>
     *
     * <code>.google.storage.v2.ProjectTeam project_team = 7;</code>
     */
    public com.google.storage.v2.ProjectTeam.Builder getProjectTeamBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getProjectTeamFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The project team associated with the entity, if any.
     * </pre>
     *
     * <code>.google.storage.v2.ProjectTeam project_team = 7;</code>
     */
    public com.google.storage.v2.ProjectTeamOrBuilder getProjectTeamOrBuilder() {
      if (projectTeamBuilder_ != null) {
        return projectTeamBuilder_.getMessageOrBuilder();
      } else {
        return projectTeam_ == null
            ? com.google.storage.v2.ProjectTeam.getDefaultInstance()
            : projectTeam_;
      }
    }
    /**
     *
     *
     * <pre>
     * The project team associated with the entity, if any.
     * </pre>
     *
     * <code>.google.storage.v2.ProjectTeam project_team = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.ProjectTeam,
            com.google.storage.v2.ProjectTeam.Builder,
            com.google.storage.v2.ProjectTeamOrBuilder>
        getProjectTeamFieldBuilder() {
      if (projectTeamBuilder_ == null) {
        projectTeamBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.ProjectTeam,
                com.google.storage.v2.ProjectTeam.Builder,
                com.google.storage.v2.ProjectTeamOrBuilder>(
                getProjectTeam(), getParentForChildren(), isClean());
        projectTeam_ = null;
      }
      return projectTeamBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.storage.v2.ObjectAccessControl)
  }

  // @@protoc_insertion_point(class_scope:google.storage.v2.ObjectAccessControl)
  private static final com.google.storage.v2.ObjectAccessControl DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.storage.v2.ObjectAccessControl();
  }

  public static com.google.storage.v2.ObjectAccessControl getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ObjectAccessControl> PARSER =
      new com.google.protobuf.AbstractParser<ObjectAccessControl>() {
        @java.lang.Override
        public ObjectAccessControl parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ObjectAccessControl> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ObjectAccessControl> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.storage.v2.ObjectAccessControl getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
