/*
 * Decompiled with CFR 0.152.
 */
package com.google.storage.control.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AnywhereCacheName
implements ResourceName {
    private static final PathTemplate PROJECT_BUCKET_ANYWHERE_CACHE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/buckets/{bucket}/anywhereCaches/{anywhere_cache}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String bucket;
    private final String anywhereCache;

    @Deprecated
    protected AnywhereCacheName() {
        this.project = null;
        this.bucket = null;
        this.anywhereCache = null;
    }

    private AnywhereCacheName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.bucket = (String)Preconditions.checkNotNull((Object)builder.getBucket());
        this.anywhereCache = (String)Preconditions.checkNotNull((Object)builder.getAnywhereCache());
    }

    public String getProject() {
        return this.project;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getAnywhereCache() {
        return this.anywhereCache;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AnywhereCacheName of(String project, String bucket, String anywhereCache) {
        return AnywhereCacheName.newBuilder().setProject(project).setBucket(bucket).setAnywhereCache(anywhereCache).build();
    }

    public static String format(String project, String bucket, String anywhereCache) {
        return AnywhereCacheName.newBuilder().setProject(project).setBucket(bucket).setAnywhereCache(anywhereCache).build().toString();
    }

    public static AnywhereCacheName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_BUCKET_ANYWHERE_CACHE.validatedMatch(formattedString, "AnywhereCacheName.parse: formattedString not in valid format");
        return AnywhereCacheName.of((String)matchMap.get("project"), (String)matchMap.get("bucket"), (String)matchMap.get("anywhere_cache"));
    }

    public static List<AnywhereCacheName> parseList(List<String> formattedStrings) {
        ArrayList<AnywhereCacheName> list = new ArrayList<AnywhereCacheName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AnywhereCacheName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AnywhereCacheName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AnywhereCacheName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_BUCKET_ANYWHERE_CACHE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AnywhereCacheName anywhereCacheName = this;
            synchronized (anywhereCacheName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.bucket != null) {
                        fieldMapBuilder.put((Object)"bucket", (Object)this.bucket);
                    }
                    if (this.anywhereCache != null) {
                        fieldMapBuilder.put((Object)"anywhere_cache", (Object)this.anywhereCache);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_BUCKET_ANYWHERE_CACHE.instantiate(new String[]{"project", this.project, "bucket", this.bucket, "anywhere_cache", this.anywhereCache});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AnywhereCacheName that = (AnywhereCacheName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.bucket, that.bucket) && Objects.equals(this.anywhereCache, that.anywhereCache);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.bucket);
        h *= 1000003;
        return h ^= Objects.hashCode(this.anywhereCache);
    }

    public static class Builder {
        private String project;
        private String bucket;
        private String anywhereCache;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getBucket() {
            return this.bucket;
        }

        public String getAnywhereCache() {
            return this.anywhereCache;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setBucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public Builder setAnywhereCache(String anywhereCache) {
            this.anywhereCache = anywhereCache;
            return this;
        }

        private Builder(AnywhereCacheName anywhereCacheName) {
            this.project = anywhereCacheName.project;
            this.bucket = anywhereCacheName.bucket;
            this.anywhereCache = anywhereCacheName.anywhereCache;
        }

        public AnywhereCacheName build() {
            return new AnywhereCacheName(this);
        }
    }
}

