/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/storage/control/v2/storage_control.proto

// Protobuf Java Version: 3.25.8
package com.google.storage.control.v2;

/**
 *
 *
 * <pre>
 * The `IntelligenceConfig` resource associated with your organization, folder,
 * or project.
 * </pre>
 *
 * Protobuf type {@code google.storage.control.v2.IntelligenceConfig}
 */
public final class IntelligenceConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.storage.control.v2.IntelligenceConfig)
    IntelligenceConfigOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use IntelligenceConfig.newBuilder() to construct.
  private IntelligenceConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private IntelligenceConfig() {
    name_ = "";
    editionConfig_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new IntelligenceConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.storage.control.v2.StorageControlProto
        .internal_static_google_storage_control_v2_IntelligenceConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.storage.control.v2.StorageControlProto
        .internal_static_google_storage_control_v2_IntelligenceConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.storage.control.v2.IntelligenceConfig.class,
            com.google.storage.control.v2.IntelligenceConfig.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The edition configuration of the `IntelligenceConfig` resource. This
   * signifies the edition used for configuring the `IntelligenceConfig`
   * resource and can only take the following values:
   * `EDITION_CONFIG_UNSPECIFIED`, `INHERIT`, `DISABLED`, `STANDARD` and
   * `TRIAL`.
   * </pre>
   *
   * Protobuf enum {@code google.storage.control.v2.IntelligenceConfig.EditionConfig}
   */
  public enum EditionConfig implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * This is an unknown edition of the resource.
     * </pre>
     *
     * <code>EDITION_CONFIG_UNSPECIFIED = 0;</code>
     */
    EDITION_CONFIG_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The inherited edition from the parent and filters. This is the default
     * edition when there is no `IntelligenceConfig` setup for a GCP resource.
     * </pre>
     *
     * <code>INHERIT = 1;</code>
     */
    INHERIT(1),
    /**
     *
     *
     * <pre>
     * The edition configuration is disabled for the `IntelligenceConfig`
     * resource and its children. Filters are not applicable.
     * </pre>
     *
     * <code>DISABLED = 2;</code>
     */
    DISABLED(2),
    /**
     *
     *
     * <pre>
     * The `IntelligenceConfig` resource is of STANDARD edition.
     * </pre>
     *
     * <code>STANDARD = 3;</code>
     */
    STANDARD(3),
    /**
     *
     *
     * <pre>
     * The `IntelligenceConfig` resource is available in `TRIAL` edition. During
     * the trial period, Cloud Storage does not charge for Storage Intelligence
     * usage. You can specify the buckets to include in the trial period by
     * using filters. At the end of the trial period, the `IntelligenceConfig`
     * resource is upgraded to `STANDARD` edition.
     * </pre>
     *
     * <code>TRIAL = 5;</code>
     */
    TRIAL(5),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * This is an unknown edition of the resource.
     * </pre>
     *
     * <code>EDITION_CONFIG_UNSPECIFIED = 0;</code>
     */
    public static final int EDITION_CONFIG_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * The inherited edition from the parent and filters. This is the default
     * edition when there is no `IntelligenceConfig` setup for a GCP resource.
     * </pre>
     *
     * <code>INHERIT = 1;</code>
     */
    public static final int INHERIT_VALUE = 1;

    /**
     *
     *
     * <pre>
     * The edition configuration is disabled for the `IntelligenceConfig`
     * resource and its children. Filters are not applicable.
     * </pre>
     *
     * <code>DISABLED = 2;</code>
     */
    public static final int DISABLED_VALUE = 2;

    /**
     *
     *
     * <pre>
     * The `IntelligenceConfig` resource is of STANDARD edition.
     * </pre>
     *
     * <code>STANDARD = 3;</code>
     */
    public static final int STANDARD_VALUE = 3;

    /**
     *
     *
     * <pre>
     * The `IntelligenceConfig` resource is available in `TRIAL` edition. During
     * the trial period, Cloud Storage does not charge for Storage Intelligence
     * usage. You can specify the buckets to include in the trial period by
     * using filters. At the end of the trial period, the `IntelligenceConfig`
     * resource is upgraded to `STANDARD` edition.
     * </pre>
     *
     * <code>TRIAL = 5;</code>
     */
    public static final int TRIAL_VALUE = 5;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static EditionConfig valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static EditionConfig forNumber(int value) {
      switch (value) {
        case 0:
          return EDITION_CONFIG_UNSPECIFIED;
        case 1:
          return INHERIT;
        case 2:
          return DISABLED;
        case 3:
          return STANDARD;
        case 5:
          return TRIAL;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<EditionConfig> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<EditionConfig> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<EditionConfig>() {
          public EditionConfig findValueByNumber(int number) {
            return EditionConfig.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.storage.control.v2.IntelligenceConfig.getDescriptor().getEnumTypes().get(0);
    }

    private static final EditionConfig[] VALUES = values();

    public static EditionConfig valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private EditionConfig(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.storage.control.v2.IntelligenceConfig.EditionConfig)
  }

  public interface FilterOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storage.control.v2.IntelligenceConfig.Filter)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Bucket locations to include.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations included_cloud_storage_locations = 1;
     * </code>
     *
     * @return Whether the includedCloudStorageLocations field is set.
     */
    boolean hasIncludedCloudStorageLocations();

    /**
     *
     *
     * <pre>
     * Bucket locations to include.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations included_cloud_storage_locations = 1;
     * </code>
     *
     * @return The includedCloudStorageLocations.
     */
    com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations
        getIncludedCloudStorageLocations();

    /**
     *
     *
     * <pre>
     * Bucket locations to include.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations included_cloud_storage_locations = 1;
     * </code>
     */
    com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocationsOrBuilder
        getIncludedCloudStorageLocationsOrBuilder();

    /**
     *
     *
     * <pre>
     * Bucket locations to exclude.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations excluded_cloud_storage_locations = 2;
     * </code>
     *
     * @return Whether the excludedCloudStorageLocations field is set.
     */
    boolean hasExcludedCloudStorageLocations();

    /**
     *
     *
     * <pre>
     * Bucket locations to exclude.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations excluded_cloud_storage_locations = 2;
     * </code>
     *
     * @return The excludedCloudStorageLocations.
     */
    com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations
        getExcludedCloudStorageLocations();

    /**
     *
     *
     * <pre>
     * Bucket locations to exclude.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations excluded_cloud_storage_locations = 2;
     * </code>
     */
    com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocationsOrBuilder
        getExcludedCloudStorageLocationsOrBuilder();

    /**
     *
     *
     * <pre>
     * Buckets to include.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets included_cloud_storage_buckets = 3;
     * </code>
     *
     * @return Whether the includedCloudStorageBuckets field is set.
     */
    boolean hasIncludedCloudStorageBuckets();

    /**
     *
     *
     * <pre>
     * Buckets to include.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets included_cloud_storage_buckets = 3;
     * </code>
     *
     * @return The includedCloudStorageBuckets.
     */
    com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets
        getIncludedCloudStorageBuckets();

    /**
     *
     *
     * <pre>
     * Buckets to include.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets included_cloud_storage_buckets = 3;
     * </code>
     */
    com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBucketsOrBuilder
        getIncludedCloudStorageBucketsOrBuilder();

    /**
     *
     *
     * <pre>
     * Buckets to exclude.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets excluded_cloud_storage_buckets = 4;
     * </code>
     *
     * @return Whether the excludedCloudStorageBuckets field is set.
     */
    boolean hasExcludedCloudStorageBuckets();

    /**
     *
     *
     * <pre>
     * Buckets to exclude.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets excluded_cloud_storage_buckets = 4;
     * </code>
     *
     * @return The excludedCloudStorageBuckets.
     */
    com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets
        getExcludedCloudStorageBuckets();

    /**
     *
     *
     * <pre>
     * Buckets to exclude.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets excluded_cloud_storage_buckets = 4;
     * </code>
     */
    com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBucketsOrBuilder
        getExcludedCloudStorageBucketsOrBuilder();

    com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocationsCase
        getCloudStorageLocationsCase();

    com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBucketsCase
        getCloudStorageBucketsCase();
  }

  /**
   *
   *
   * <pre>
   * Filter over location and bucket using include or exclude semantics.
   * Resources that match the include or exclude filter are exclusively included
   * or excluded from the Storage Intelligence plan.
   * </pre>
   *
   * Protobuf type {@code google.storage.control.v2.IntelligenceConfig.Filter}
   */
  public static final class Filter extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storage.control.v2.IntelligenceConfig.Filter)
      FilterOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use Filter.newBuilder() to construct.
    private Filter(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Filter() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Filter();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.control.v2.StorageControlProto
          .internal_static_google_storage_control_v2_IntelligenceConfig_Filter_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.control.v2.StorageControlProto
          .internal_static_google_storage_control_v2_IntelligenceConfig_Filter_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.control.v2.IntelligenceConfig.Filter.class,
              com.google.storage.control.v2.IntelligenceConfig.Filter.Builder.class);
    }

    public interface CloudStorageLocationsOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Optional. Bucket locations. Location can be any of the Cloud Storage
       * regions specified in lower case format. For example, `us-east1`,
       * `us-west1`.
       * </pre>
       *
       * <code>repeated string locations = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return A list containing the locations.
       */
      java.util.List<java.lang.String> getLocationsList();

      /**
       *
       *
       * <pre>
       * Optional. Bucket locations. Location can be any of the Cloud Storage
       * regions specified in lower case format. For example, `us-east1`,
       * `us-west1`.
       * </pre>
       *
       * <code>repeated string locations = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The count of locations.
       */
      int getLocationsCount();

      /**
       *
       *
       * <pre>
       * Optional. Bucket locations. Location can be any of the Cloud Storage
       * regions specified in lower case format. For example, `us-east1`,
       * `us-west1`.
       * </pre>
       *
       * <code>repeated string locations = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the element to return.
       * @return The locations at the given index.
       */
      java.lang.String getLocations(int index);

      /**
       *
       *
       * <pre>
       * Optional. Bucket locations. Location can be any of the Cloud Storage
       * regions specified in lower case format. For example, `us-east1`,
       * `us-west1`.
       * </pre>
       *
       * <code>repeated string locations = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the locations at the given index.
       */
      com.google.protobuf.ByteString getLocationsBytes(int index);
    }

    /**
     *
     *
     * <pre>
     * Collection of bucket locations.
     * </pre>
     *
     * Protobuf type {@code
     * google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations}
     */
    public static final class CloudStorageLocations extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations)
        CloudStorageLocationsOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use CloudStorageLocations.newBuilder() to construct.
      private CloudStorageLocations(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private CloudStorageLocations() {
        locations_ = com.google.protobuf.LazyStringArrayList.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new CloudStorageLocations();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storage.control.v2.StorageControlProto
            .internal_static_google_storage_control_v2_IntelligenceConfig_Filter_CloudStorageLocations_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storage.control.v2.StorageControlProto
            .internal_static_google_storage_control_v2_IntelligenceConfig_Filter_CloudStorageLocations_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations.class,
                com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations
                    .Builder.class);
      }

      public static final int LOCATIONS_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private com.google.protobuf.LazyStringArrayList locations_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      /**
       *
       *
       * <pre>
       * Optional. Bucket locations. Location can be any of the Cloud Storage
       * regions specified in lower case format. For example, `us-east1`,
       * `us-west1`.
       * </pre>
       *
       * <code>repeated string locations = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return A list containing the locations.
       */
      public com.google.protobuf.ProtocolStringList getLocationsList() {
        return locations_;
      }

      /**
       *
       *
       * <pre>
       * Optional. Bucket locations. Location can be any of the Cloud Storage
       * regions specified in lower case format. For example, `us-east1`,
       * `us-west1`.
       * </pre>
       *
       * <code>repeated string locations = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The count of locations.
       */
      public int getLocationsCount() {
        return locations_.size();
      }

      /**
       *
       *
       * <pre>
       * Optional. Bucket locations. Location can be any of the Cloud Storage
       * regions specified in lower case format. For example, `us-east1`,
       * `us-west1`.
       * </pre>
       *
       * <code>repeated string locations = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the element to return.
       * @return The locations at the given index.
       */
      public java.lang.String getLocations(int index) {
        return locations_.get(index);
      }

      /**
       *
       *
       * <pre>
       * Optional. Bucket locations. Location can be any of the Cloud Storage
       * regions specified in lower case format. For example, `us-east1`,
       * `us-west1`.
       * </pre>
       *
       * <code>repeated string locations = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the locations at the given index.
       */
      public com.google.protobuf.ByteString getLocationsBytes(int index) {
        return locations_.getByteString(index);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        for (int i = 0; i < locations_.size(); i++) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, locations_.getRaw(i));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        {
          int dataSize = 0;
          for (int i = 0; i < locations_.size(); i++) {
            dataSize += computeStringSizeNoTag(locations_.getRaw(i));
          }
          size += dataSize;
          size += 1 * getLocationsList().size();
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations)) {
          return super.equals(obj);
        }
        com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations other =
            (com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations) obj;

        if (!getLocationsList().equals(other.getLocationsList())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (getLocationsCount() > 0) {
          hash = (37 * hash) + LOCATIONS_FIELD_NUMBER;
          hash = (53 * hash) + getLocationsList().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Collection of bucket locations.
       * </pre>
       *
       * Protobuf type {@code
       * google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations)
          com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocationsOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.storage.control.v2.StorageControlProto
              .internal_static_google_storage_control_v2_IntelligenceConfig_Filter_CloudStorageLocations_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.storage.control.v2.StorageControlProto
              .internal_static_google_storage_control_v2_IntelligenceConfig_Filter_CloudStorageLocations_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations
                      .class,
                  com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations
                      .Builder.class);
        }

        // Construct using
        // com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          locations_ = com.google.protobuf.LazyStringArrayList.emptyList();
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.storage.control.v2.StorageControlProto
              .internal_static_google_storage_control_v2_IntelligenceConfig_Filter_CloudStorageLocations_descriptor;
        }

        @java.lang.Override
        public com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations
            getDefaultInstanceForType() {
          return com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations
            build() {
          com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations
            buildPartial() {
          com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations result =
              new com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations(
                  this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            locations_.makeImmutable();
            result.locations_ = locations_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations) {
            return mergeFrom(
                (com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations other) {
          if (other
              == com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations
                  .getDefaultInstance()) return this;
          if (!other.locations_.isEmpty()) {
            if (locations_.isEmpty()) {
              locations_ = other.locations_;
              bitField0_ |= 0x00000001;
            } else {
              ensureLocationsIsMutable();
              locations_.addAll(other.locations_);
            }
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    ensureLocationsIsMutable();
                    locations_.add(s);
                    break;
                  } // case 10
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private com.google.protobuf.LazyStringArrayList locations_ =
            com.google.protobuf.LazyStringArrayList.emptyList();

        private void ensureLocationsIsMutable() {
          if (!locations_.isModifiable()) {
            locations_ = new com.google.protobuf.LazyStringArrayList(locations_);
          }
          bitField0_ |= 0x00000001;
        }

        /**
         *
         *
         * <pre>
         * Optional. Bucket locations. Location can be any of the Cloud Storage
         * regions specified in lower case format. For example, `us-east1`,
         * `us-west1`.
         * </pre>
         *
         * <code>repeated string locations = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return A list containing the locations.
         */
        public com.google.protobuf.ProtocolStringList getLocationsList() {
          locations_.makeImmutable();
          return locations_;
        }

        /**
         *
         *
         * <pre>
         * Optional. Bucket locations. Location can be any of the Cloud Storage
         * regions specified in lower case format. For example, `us-east1`,
         * `us-west1`.
         * </pre>
         *
         * <code>repeated string locations = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The count of locations.
         */
        public int getLocationsCount() {
          return locations_.size();
        }

        /**
         *
         *
         * <pre>
         * Optional. Bucket locations. Location can be any of the Cloud Storage
         * regions specified in lower case format. For example, `us-east1`,
         * `us-west1`.
         * </pre>
         *
         * <code>repeated string locations = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param index The index of the element to return.
         * @return The locations at the given index.
         */
        public java.lang.String getLocations(int index) {
          return locations_.get(index);
        }

        /**
         *
         *
         * <pre>
         * Optional. Bucket locations. Location can be any of the Cloud Storage
         * regions specified in lower case format. For example, `us-east1`,
         * `us-west1`.
         * </pre>
         *
         * <code>repeated string locations = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the locations at the given index.
         */
        public com.google.protobuf.ByteString getLocationsBytes(int index) {
          return locations_.getByteString(index);
        }

        /**
         *
         *
         * <pre>
         * Optional. Bucket locations. Location can be any of the Cloud Storage
         * regions specified in lower case format. For example, `us-east1`,
         * `us-west1`.
         * </pre>
         *
         * <code>repeated string locations = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param index The index to set the value at.
         * @param value The locations to set.
         * @return This builder for chaining.
         */
        public Builder setLocations(int index, java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureLocationsIsMutable();
          locations_.set(index, value);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. Bucket locations. Location can be any of the Cloud Storage
         * regions specified in lower case format. For example, `us-east1`,
         * `us-west1`.
         * </pre>
         *
         * <code>repeated string locations = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The locations to add.
         * @return This builder for chaining.
         */
        public Builder addLocations(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureLocationsIsMutable();
          locations_.add(value);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. Bucket locations. Location can be any of the Cloud Storage
         * regions specified in lower case format. For example, `us-east1`,
         * `us-west1`.
         * </pre>
         *
         * <code>repeated string locations = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param values The locations to add.
         * @return This builder for chaining.
         */
        public Builder addAllLocations(java.lang.Iterable<java.lang.String> values) {
          ensureLocationsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, locations_);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. Bucket locations. Location can be any of the Cloud Storage
         * regions specified in lower case format. For example, `us-east1`,
         * `us-west1`.
         * </pre>
         *
         * <code>repeated string locations = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearLocations() {
          locations_ = com.google.protobuf.LazyStringArrayList.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          ;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. Bucket locations. Location can be any of the Cloud Storage
         * regions specified in lower case format. For example, `us-east1`,
         * `us-west1`.
         * </pre>
         *
         * <code>repeated string locations = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The bytes of the locations to add.
         * @return This builder for chaining.
         */
        public Builder addLocationsBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          ensureLocationsIsMutable();
          locations_.add(value);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations)
      }

      // @@protoc_insertion_point(class_scope:google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations)
      private static final com.google.storage.control.v2.IntelligenceConfig.Filter
              .CloudStorageLocations
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations();
      }

      public static com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<CloudStorageLocations> PARSER =
          new com.google.protobuf.AbstractParser<CloudStorageLocations>() {
            @java.lang.Override
            public CloudStorageLocations parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<CloudStorageLocations> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<CloudStorageLocations> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface CloudStorageBucketsOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Optional. A regex pattern for matching bucket names. Regex should
       * follow the syntax specified in
       * [google/re2](https://github.com/google/re2). For example,
       * `^sample_.*` matches all buckets of the form
       * `gs://sample_bucket-1`, `gs://sample_bucket-2`,
       * `gs://sample_bucket-n` but not `gs://test_sample_bucket`.
       * If you want to match a single bucket, say `gs://sample_bucket`,
       * use `sample_bucket`.
       * </pre>
       *
       * <code>repeated string bucket_id_regexes = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return A list containing the bucketIdRegexes.
       */
      java.util.List<java.lang.String> getBucketIdRegexesList();

      /**
       *
       *
       * <pre>
       * Optional. A regex pattern for matching bucket names. Regex should
       * follow the syntax specified in
       * [google/re2](https://github.com/google/re2). For example,
       * `^sample_.*` matches all buckets of the form
       * `gs://sample_bucket-1`, `gs://sample_bucket-2`,
       * `gs://sample_bucket-n` but not `gs://test_sample_bucket`.
       * If you want to match a single bucket, say `gs://sample_bucket`,
       * use `sample_bucket`.
       * </pre>
       *
       * <code>repeated string bucket_id_regexes = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The count of bucketIdRegexes.
       */
      int getBucketIdRegexesCount();

      /**
       *
       *
       * <pre>
       * Optional. A regex pattern for matching bucket names. Regex should
       * follow the syntax specified in
       * [google/re2](https://github.com/google/re2). For example,
       * `^sample_.*` matches all buckets of the form
       * `gs://sample_bucket-1`, `gs://sample_bucket-2`,
       * `gs://sample_bucket-n` but not `gs://test_sample_bucket`.
       * If you want to match a single bucket, say `gs://sample_bucket`,
       * use `sample_bucket`.
       * </pre>
       *
       * <code>repeated string bucket_id_regexes = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index of the element to return.
       * @return The bucketIdRegexes at the given index.
       */
      java.lang.String getBucketIdRegexes(int index);

      /**
       *
       *
       * <pre>
       * Optional. A regex pattern for matching bucket names. Regex should
       * follow the syntax specified in
       * [google/re2](https://github.com/google/re2). For example,
       * `^sample_.*` matches all buckets of the form
       * `gs://sample_bucket-1`, `gs://sample_bucket-2`,
       * `gs://sample_bucket-n` but not `gs://test_sample_bucket`.
       * If you want to match a single bucket, say `gs://sample_bucket`,
       * use `sample_bucket`.
       * </pre>
       *
       * <code>repeated string bucket_id_regexes = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the bucketIdRegexes at the given index.
       */
      com.google.protobuf.ByteString getBucketIdRegexesBytes(int index);
    }

    /**
     *
     *
     * <pre>
     * Collection of buckets.
     * </pre>
     *
     * Protobuf type {@code google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets}
     */
    public static final class CloudStorageBuckets extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets)
        CloudStorageBucketsOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use CloudStorageBuckets.newBuilder() to construct.
      private CloudStorageBuckets(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private CloudStorageBuckets() {
        bucketIdRegexes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new CloudStorageBuckets();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storage.control.v2.StorageControlProto
            .internal_static_google_storage_control_v2_IntelligenceConfig_Filter_CloudStorageBuckets_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storage.control.v2.StorageControlProto
            .internal_static_google_storage_control_v2_IntelligenceConfig_Filter_CloudStorageBuckets_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets.class,
                com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets.Builder
                    .class);
      }

      public static final int BUCKET_ID_REGEXES_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private com.google.protobuf.LazyStringArrayList bucketIdRegexes_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      /**
       *
       *
       * <pre>
       * Optional. A regex pattern for matching bucket names. Regex should
       * follow the syntax specified in
       * [google/re2](https://github.com/google/re2). For example,
       * `^sample_.*` matches all buckets of the form
       * `gs://sample_bucket-1`, `gs://sample_bucket-2`,
       * `gs://sample_bucket-n` but not `gs://test_sample_bucket`.
       * If you want to match a single bucket, say `gs://sample_bucket`,
       * use `sample_bucket`.
       * </pre>
       *
       * <code>repeated string bucket_id_regexes = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return A list containing the bucketIdRegexes.
       */
      public com.google.protobuf.ProtocolStringList getBucketIdRegexesList() {
        return bucketIdRegexes_;
      }

      /**
       *
       *
       * <pre>
       * Optional. A regex pattern for matching bucket names. Regex should
       * follow the syntax specified in
       * [google/re2](https://github.com/google/re2). For example,
       * `^sample_.*` matches all buckets of the form
       * `gs://sample_bucket-1`, `gs://sample_bucket-2`,
       * `gs://sample_bucket-n` but not `gs://test_sample_bucket`.
       * If you want to match a single bucket, say `gs://sample_bucket`,
       * use `sample_bucket`.
       * </pre>
       *
       * <code>repeated string bucket_id_regexes = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The count of bucketIdRegexes.
       */
      public int getBucketIdRegexesCount() {
        return bucketIdRegexes_.size();
      }

      /**
       *
       *
       * <pre>
       * Optional. A regex pattern for matching bucket names. Regex should
       * follow the syntax specified in
       * [google/re2](https://github.com/google/re2). For example,
       * `^sample_.*` matches all buckets of the form
       * `gs://sample_bucket-1`, `gs://sample_bucket-2`,
       * `gs://sample_bucket-n` but not `gs://test_sample_bucket`.
       * If you want to match a single bucket, say `gs://sample_bucket`,
       * use `sample_bucket`.
       * </pre>
       *
       * <code>repeated string bucket_id_regexes = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index of the element to return.
       * @return The bucketIdRegexes at the given index.
       */
      public java.lang.String getBucketIdRegexes(int index) {
        return bucketIdRegexes_.get(index);
      }

      /**
       *
       *
       * <pre>
       * Optional. A regex pattern for matching bucket names. Regex should
       * follow the syntax specified in
       * [google/re2](https://github.com/google/re2). For example,
       * `^sample_.*` matches all buckets of the form
       * `gs://sample_bucket-1`, `gs://sample_bucket-2`,
       * `gs://sample_bucket-n` but not `gs://test_sample_bucket`.
       * If you want to match a single bucket, say `gs://sample_bucket`,
       * use `sample_bucket`.
       * </pre>
       *
       * <code>repeated string bucket_id_regexes = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the bucketIdRegexes at the given index.
       */
      public com.google.protobuf.ByteString getBucketIdRegexesBytes(int index) {
        return bucketIdRegexes_.getByteString(index);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        for (int i = 0; i < bucketIdRegexes_.size(); i++) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, bucketIdRegexes_.getRaw(i));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        {
          int dataSize = 0;
          for (int i = 0; i < bucketIdRegexes_.size(); i++) {
            dataSize += computeStringSizeNoTag(bucketIdRegexes_.getRaw(i));
          }
          size += dataSize;
          size += 1 * getBucketIdRegexesList().size();
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets)) {
          return super.equals(obj);
        }
        com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets other =
            (com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets) obj;

        if (!getBucketIdRegexesList().equals(other.getBucketIdRegexesList())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (getBucketIdRegexesCount() > 0) {
          hash = (37 * hash) + BUCKET_ID_REGEXES_FIELD_NUMBER;
          hash = (53 * hash) + getBucketIdRegexesList().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Collection of buckets.
       * </pre>
       *
       * Protobuf type {@code
       * google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets)
          com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBucketsOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.storage.control.v2.StorageControlProto
              .internal_static_google_storage_control_v2_IntelligenceConfig_Filter_CloudStorageBuckets_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.storage.control.v2.StorageControlProto
              .internal_static_google_storage_control_v2_IntelligenceConfig_Filter_CloudStorageBuckets_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets.class,
                  com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets
                      .Builder.class);
        }

        // Construct using
        // com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          bucketIdRegexes_ = com.google.protobuf.LazyStringArrayList.emptyList();
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.storage.control.v2.StorageControlProto
              .internal_static_google_storage_control_v2_IntelligenceConfig_Filter_CloudStorageBuckets_descriptor;
        }

        @java.lang.Override
        public com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets
            getDefaultInstanceForType() {
          return com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets build() {
          com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets
            buildPartial() {
          com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets result =
              new com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            bucketIdRegexes_.makeImmutable();
            result.bucketIdRegexes_ = bucketIdRegexes_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets) {
            return mergeFrom(
                (com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets other) {
          if (other
              == com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets
                  .getDefaultInstance()) return this;
          if (!other.bucketIdRegexes_.isEmpty()) {
            if (bucketIdRegexes_.isEmpty()) {
              bucketIdRegexes_ = other.bucketIdRegexes_;
              bitField0_ |= 0x00000001;
            } else {
              ensureBucketIdRegexesIsMutable();
              bucketIdRegexes_.addAll(other.bucketIdRegexes_);
            }
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    ensureBucketIdRegexesIsMutable();
                    bucketIdRegexes_.add(s);
                    break;
                  } // case 10
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private com.google.protobuf.LazyStringArrayList bucketIdRegexes_ =
            com.google.protobuf.LazyStringArrayList.emptyList();

        private void ensureBucketIdRegexesIsMutable() {
          if (!bucketIdRegexes_.isModifiable()) {
            bucketIdRegexes_ = new com.google.protobuf.LazyStringArrayList(bucketIdRegexes_);
          }
          bitField0_ |= 0x00000001;
        }

        /**
         *
         *
         * <pre>
         * Optional. A regex pattern for matching bucket names. Regex should
         * follow the syntax specified in
         * [google/re2](https://github.com/google/re2). For example,
         * `^sample_.*` matches all buckets of the form
         * `gs://sample_bucket-1`, `gs://sample_bucket-2`,
         * `gs://sample_bucket-n` but not `gs://test_sample_bucket`.
         * If you want to match a single bucket, say `gs://sample_bucket`,
         * use `sample_bucket`.
         * </pre>
         *
         * <code>repeated string bucket_id_regexes = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return A list containing the bucketIdRegexes.
         */
        public com.google.protobuf.ProtocolStringList getBucketIdRegexesList() {
          bucketIdRegexes_.makeImmutable();
          return bucketIdRegexes_;
        }

        /**
         *
         *
         * <pre>
         * Optional. A regex pattern for matching bucket names. Regex should
         * follow the syntax specified in
         * [google/re2](https://github.com/google/re2). For example,
         * `^sample_.*` matches all buckets of the form
         * `gs://sample_bucket-1`, `gs://sample_bucket-2`,
         * `gs://sample_bucket-n` but not `gs://test_sample_bucket`.
         * If you want to match a single bucket, say `gs://sample_bucket`,
         * use `sample_bucket`.
         * </pre>
         *
         * <code>repeated string bucket_id_regexes = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The count of bucketIdRegexes.
         */
        public int getBucketIdRegexesCount() {
          return bucketIdRegexes_.size();
        }

        /**
         *
         *
         * <pre>
         * Optional. A regex pattern for matching bucket names. Regex should
         * follow the syntax specified in
         * [google/re2](https://github.com/google/re2). For example,
         * `^sample_.*` matches all buckets of the form
         * `gs://sample_bucket-1`, `gs://sample_bucket-2`,
         * `gs://sample_bucket-n` but not `gs://test_sample_bucket`.
         * If you want to match a single bucket, say `gs://sample_bucket`,
         * use `sample_bucket`.
         * </pre>
         *
         * <code>repeated string bucket_id_regexes = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param index The index of the element to return.
         * @return The bucketIdRegexes at the given index.
         */
        public java.lang.String getBucketIdRegexes(int index) {
          return bucketIdRegexes_.get(index);
        }

        /**
         *
         *
         * <pre>
         * Optional. A regex pattern for matching bucket names. Regex should
         * follow the syntax specified in
         * [google/re2](https://github.com/google/re2). For example,
         * `^sample_.*` matches all buckets of the form
         * `gs://sample_bucket-1`, `gs://sample_bucket-2`,
         * `gs://sample_bucket-n` but not `gs://test_sample_bucket`.
         * If you want to match a single bucket, say `gs://sample_bucket`,
         * use `sample_bucket`.
         * </pre>
         *
         * <code>repeated string bucket_id_regexes = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the bucketIdRegexes at the given index.
         */
        public com.google.protobuf.ByteString getBucketIdRegexesBytes(int index) {
          return bucketIdRegexes_.getByteString(index);
        }

        /**
         *
         *
         * <pre>
         * Optional. A regex pattern for matching bucket names. Regex should
         * follow the syntax specified in
         * [google/re2](https://github.com/google/re2). For example,
         * `^sample_.*` matches all buckets of the form
         * `gs://sample_bucket-1`, `gs://sample_bucket-2`,
         * `gs://sample_bucket-n` but not `gs://test_sample_bucket`.
         * If you want to match a single bucket, say `gs://sample_bucket`,
         * use `sample_bucket`.
         * </pre>
         *
         * <code>repeated string bucket_id_regexes = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param index The index to set the value at.
         * @param value The bucketIdRegexes to set.
         * @return This builder for chaining.
         */
        public Builder setBucketIdRegexes(int index, java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureBucketIdRegexesIsMutable();
          bucketIdRegexes_.set(index, value);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. A regex pattern for matching bucket names. Regex should
         * follow the syntax specified in
         * [google/re2](https://github.com/google/re2). For example,
         * `^sample_.*` matches all buckets of the form
         * `gs://sample_bucket-1`, `gs://sample_bucket-2`,
         * `gs://sample_bucket-n` but not `gs://test_sample_bucket`.
         * If you want to match a single bucket, say `gs://sample_bucket`,
         * use `sample_bucket`.
         * </pre>
         *
         * <code>repeated string bucket_id_regexes = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param value The bucketIdRegexes to add.
         * @return This builder for chaining.
         */
        public Builder addBucketIdRegexes(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureBucketIdRegexesIsMutable();
          bucketIdRegexes_.add(value);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. A regex pattern for matching bucket names. Regex should
         * follow the syntax specified in
         * [google/re2](https://github.com/google/re2). For example,
         * `^sample_.*` matches all buckets of the form
         * `gs://sample_bucket-1`, `gs://sample_bucket-2`,
         * `gs://sample_bucket-n` but not `gs://test_sample_bucket`.
         * If you want to match a single bucket, say `gs://sample_bucket`,
         * use `sample_bucket`.
         * </pre>
         *
         * <code>repeated string bucket_id_regexes = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param values The bucketIdRegexes to add.
         * @return This builder for chaining.
         */
        public Builder addAllBucketIdRegexes(java.lang.Iterable<java.lang.String> values) {
          ensureBucketIdRegexesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, bucketIdRegexes_);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. A regex pattern for matching bucket names. Regex should
         * follow the syntax specified in
         * [google/re2](https://github.com/google/re2). For example,
         * `^sample_.*` matches all buckets of the form
         * `gs://sample_bucket-1`, `gs://sample_bucket-2`,
         * `gs://sample_bucket-n` but not `gs://test_sample_bucket`.
         * If you want to match a single bucket, say `gs://sample_bucket`,
         * use `sample_bucket`.
         * </pre>
         *
         * <code>repeated string bucket_id_regexes = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearBucketIdRegexes() {
          bucketIdRegexes_ = com.google.protobuf.LazyStringArrayList.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          ;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. A regex pattern for matching bucket names. Regex should
         * follow the syntax specified in
         * [google/re2](https://github.com/google/re2). For example,
         * `^sample_.*` matches all buckets of the form
         * `gs://sample_bucket-1`, `gs://sample_bucket-2`,
         * `gs://sample_bucket-n` but not `gs://test_sample_bucket`.
         * If you want to match a single bucket, say `gs://sample_bucket`,
         * use `sample_bucket`.
         * </pre>
         *
         * <code>repeated string bucket_id_regexes = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param value The bytes of the bucketIdRegexes to add.
         * @return This builder for chaining.
         */
        public Builder addBucketIdRegexesBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          ensureBucketIdRegexesIsMutable();
          bucketIdRegexes_.add(value);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets)
      }

      // @@protoc_insertion_point(class_scope:google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets)
      private static final com.google.storage.control.v2.IntelligenceConfig.Filter
              .CloudStorageBuckets
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets();
      }

      public static com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<CloudStorageBuckets> PARSER =
          new com.google.protobuf.AbstractParser<CloudStorageBuckets>() {
            @java.lang.Override
            public CloudStorageBuckets parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<CloudStorageBuckets> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<CloudStorageBuckets> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int cloudStorageLocationsCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object cloudStorageLocations_;

    public enum CloudStorageLocationsCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      INCLUDED_CLOUD_STORAGE_LOCATIONS(1),
      EXCLUDED_CLOUD_STORAGE_LOCATIONS(2),
      CLOUDSTORAGELOCATIONS_NOT_SET(0);
      private final int value;

      private CloudStorageLocationsCase(int value) {
        this.value = value;
      }

      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static CloudStorageLocationsCase valueOf(int value) {
        return forNumber(value);
      }

      public static CloudStorageLocationsCase forNumber(int value) {
        switch (value) {
          case 1:
            return INCLUDED_CLOUD_STORAGE_LOCATIONS;
          case 2:
            return EXCLUDED_CLOUD_STORAGE_LOCATIONS;
          case 0:
            return CLOUDSTORAGELOCATIONS_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public CloudStorageLocationsCase getCloudStorageLocationsCase() {
      return CloudStorageLocationsCase.forNumber(cloudStorageLocationsCase_);
    }

    private int cloudStorageBucketsCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object cloudStorageBuckets_;

    public enum CloudStorageBucketsCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      INCLUDED_CLOUD_STORAGE_BUCKETS(3),
      EXCLUDED_CLOUD_STORAGE_BUCKETS(4),
      CLOUDSTORAGEBUCKETS_NOT_SET(0);
      private final int value;

      private CloudStorageBucketsCase(int value) {
        this.value = value;
      }

      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static CloudStorageBucketsCase valueOf(int value) {
        return forNumber(value);
      }

      public static CloudStorageBucketsCase forNumber(int value) {
        switch (value) {
          case 3:
            return INCLUDED_CLOUD_STORAGE_BUCKETS;
          case 4:
            return EXCLUDED_CLOUD_STORAGE_BUCKETS;
          case 0:
            return CLOUDSTORAGEBUCKETS_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public CloudStorageBucketsCase getCloudStorageBucketsCase() {
      return CloudStorageBucketsCase.forNumber(cloudStorageBucketsCase_);
    }

    public static final int INCLUDED_CLOUD_STORAGE_LOCATIONS_FIELD_NUMBER = 1;

    /**
     *
     *
     * <pre>
     * Bucket locations to include.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations included_cloud_storage_locations = 1;
     * </code>
     *
     * @return Whether the includedCloudStorageLocations field is set.
     */
    @java.lang.Override
    public boolean hasIncludedCloudStorageLocations() {
      return cloudStorageLocationsCase_ == 1;
    }

    /**
     *
     *
     * <pre>
     * Bucket locations to include.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations included_cloud_storage_locations = 1;
     * </code>
     *
     * @return The includedCloudStorageLocations.
     */
    @java.lang.Override
    public com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations
        getIncludedCloudStorageLocations() {
      if (cloudStorageLocationsCase_ == 1) {
        return (com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations)
            cloudStorageLocations_;
      }
      return com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations
          .getDefaultInstance();
    }

    /**
     *
     *
     * <pre>
     * Bucket locations to include.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations included_cloud_storage_locations = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocationsOrBuilder
        getIncludedCloudStorageLocationsOrBuilder() {
      if (cloudStorageLocationsCase_ == 1) {
        return (com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations)
            cloudStorageLocations_;
      }
      return com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations
          .getDefaultInstance();
    }

    public static final int EXCLUDED_CLOUD_STORAGE_LOCATIONS_FIELD_NUMBER = 2;

    /**
     *
     *
     * <pre>
     * Bucket locations to exclude.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations excluded_cloud_storage_locations = 2;
     * </code>
     *
     * @return Whether the excludedCloudStorageLocations field is set.
     */
    @java.lang.Override
    public boolean hasExcludedCloudStorageLocations() {
      return cloudStorageLocationsCase_ == 2;
    }

    /**
     *
     *
     * <pre>
     * Bucket locations to exclude.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations excluded_cloud_storage_locations = 2;
     * </code>
     *
     * @return The excludedCloudStorageLocations.
     */
    @java.lang.Override
    public com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations
        getExcludedCloudStorageLocations() {
      if (cloudStorageLocationsCase_ == 2) {
        return (com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations)
            cloudStorageLocations_;
      }
      return com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations
          .getDefaultInstance();
    }

    /**
     *
     *
     * <pre>
     * Bucket locations to exclude.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations excluded_cloud_storage_locations = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocationsOrBuilder
        getExcludedCloudStorageLocationsOrBuilder() {
      if (cloudStorageLocationsCase_ == 2) {
        return (com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations)
            cloudStorageLocations_;
      }
      return com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations
          .getDefaultInstance();
    }

    public static final int INCLUDED_CLOUD_STORAGE_BUCKETS_FIELD_NUMBER = 3;

    /**
     *
     *
     * <pre>
     * Buckets to include.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets included_cloud_storage_buckets = 3;
     * </code>
     *
     * @return Whether the includedCloudStorageBuckets field is set.
     */
    @java.lang.Override
    public boolean hasIncludedCloudStorageBuckets() {
      return cloudStorageBucketsCase_ == 3;
    }

    /**
     *
     *
     * <pre>
     * Buckets to include.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets included_cloud_storage_buckets = 3;
     * </code>
     *
     * @return The includedCloudStorageBuckets.
     */
    @java.lang.Override
    public com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets
        getIncludedCloudStorageBuckets() {
      if (cloudStorageBucketsCase_ == 3) {
        return (com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets)
            cloudStorageBuckets_;
      }
      return com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets
          .getDefaultInstance();
    }

    /**
     *
     *
     * <pre>
     * Buckets to include.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets included_cloud_storage_buckets = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBucketsOrBuilder
        getIncludedCloudStorageBucketsOrBuilder() {
      if (cloudStorageBucketsCase_ == 3) {
        return (com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets)
            cloudStorageBuckets_;
      }
      return com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets
          .getDefaultInstance();
    }

    public static final int EXCLUDED_CLOUD_STORAGE_BUCKETS_FIELD_NUMBER = 4;

    /**
     *
     *
     * <pre>
     * Buckets to exclude.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets excluded_cloud_storage_buckets = 4;
     * </code>
     *
     * @return Whether the excludedCloudStorageBuckets field is set.
     */
    @java.lang.Override
    public boolean hasExcludedCloudStorageBuckets() {
      return cloudStorageBucketsCase_ == 4;
    }

    /**
     *
     *
     * <pre>
     * Buckets to exclude.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets excluded_cloud_storage_buckets = 4;
     * </code>
     *
     * @return The excludedCloudStorageBuckets.
     */
    @java.lang.Override
    public com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets
        getExcludedCloudStorageBuckets() {
      if (cloudStorageBucketsCase_ == 4) {
        return (com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets)
            cloudStorageBuckets_;
      }
      return com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets
          .getDefaultInstance();
    }

    /**
     *
     *
     * <pre>
     * Buckets to exclude.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets excluded_cloud_storage_buckets = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBucketsOrBuilder
        getExcludedCloudStorageBucketsOrBuilder() {
      if (cloudStorageBucketsCase_ == 4) {
        return (com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets)
            cloudStorageBuckets_;
      }
      return com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets
          .getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (cloudStorageLocationsCase_ == 1) {
        output.writeMessage(
            1,
            (com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations)
                cloudStorageLocations_);
      }
      if (cloudStorageLocationsCase_ == 2) {
        output.writeMessage(
            2,
            (com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations)
                cloudStorageLocations_);
      }
      if (cloudStorageBucketsCase_ == 3) {
        output.writeMessage(
            3,
            (com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets)
                cloudStorageBuckets_);
      }
      if (cloudStorageBucketsCase_ == 4) {
        output.writeMessage(
            4,
            (com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets)
                cloudStorageBuckets_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (cloudStorageLocationsCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1,
                (com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations)
                    cloudStorageLocations_);
      }
      if (cloudStorageLocationsCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2,
                (com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations)
                    cloudStorageLocations_);
      }
      if (cloudStorageBucketsCase_ == 3) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                3,
                (com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets)
                    cloudStorageBuckets_);
      }
      if (cloudStorageBucketsCase_ == 4) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                4,
                (com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets)
                    cloudStorageBuckets_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.storage.control.v2.IntelligenceConfig.Filter)) {
        return super.equals(obj);
      }
      com.google.storage.control.v2.IntelligenceConfig.Filter other =
          (com.google.storage.control.v2.IntelligenceConfig.Filter) obj;

      if (!getCloudStorageLocationsCase().equals(other.getCloudStorageLocationsCase()))
        return false;
      switch (cloudStorageLocationsCase_) {
        case 1:
          if (!getIncludedCloudStorageLocations().equals(other.getIncludedCloudStorageLocations()))
            return false;
          break;
        case 2:
          if (!getExcludedCloudStorageLocations().equals(other.getExcludedCloudStorageLocations()))
            return false;
          break;
        case 0:
        default:
      }
      if (!getCloudStorageBucketsCase().equals(other.getCloudStorageBucketsCase())) return false;
      switch (cloudStorageBucketsCase_) {
        case 3:
          if (!getIncludedCloudStorageBuckets().equals(other.getIncludedCloudStorageBuckets()))
            return false;
          break;
        case 4:
          if (!getExcludedCloudStorageBuckets().equals(other.getExcludedCloudStorageBuckets()))
            return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (cloudStorageLocationsCase_) {
        case 1:
          hash = (37 * hash) + INCLUDED_CLOUD_STORAGE_LOCATIONS_FIELD_NUMBER;
          hash = (53 * hash) + getIncludedCloudStorageLocations().hashCode();
          break;
        case 2:
          hash = (37 * hash) + EXCLUDED_CLOUD_STORAGE_LOCATIONS_FIELD_NUMBER;
          hash = (53 * hash) + getExcludedCloudStorageLocations().hashCode();
          break;
        case 0:
        default:
      }
      switch (cloudStorageBucketsCase_) {
        case 3:
          hash = (37 * hash) + INCLUDED_CLOUD_STORAGE_BUCKETS_FIELD_NUMBER;
          hash = (53 * hash) + getIncludedCloudStorageBuckets().hashCode();
          break;
        case 4:
          hash = (37 * hash) + EXCLUDED_CLOUD_STORAGE_BUCKETS_FIELD_NUMBER;
          hash = (53 * hash) + getExcludedCloudStorageBuckets().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storage.control.v2.IntelligenceConfig.Filter parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.control.v2.IntelligenceConfig.Filter parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.control.v2.IntelligenceConfig.Filter parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.control.v2.IntelligenceConfig.Filter parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.control.v2.IntelligenceConfig.Filter parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.control.v2.IntelligenceConfig.Filter parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.control.v2.IntelligenceConfig.Filter parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.control.v2.IntelligenceConfig.Filter parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.control.v2.IntelligenceConfig.Filter parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storage.control.v2.IntelligenceConfig.Filter parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.control.v2.IntelligenceConfig.Filter parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.control.v2.IntelligenceConfig.Filter parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.storage.control.v2.IntelligenceConfig.Filter prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Filter over location and bucket using include or exclude semantics.
     * Resources that match the include or exclude filter are exclusively included
     * or excluded from the Storage Intelligence plan.
     * </pre>
     *
     * Protobuf type {@code google.storage.control.v2.IntelligenceConfig.Filter}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storage.control.v2.IntelligenceConfig.Filter)
        com.google.storage.control.v2.IntelligenceConfig.FilterOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storage.control.v2.StorageControlProto
            .internal_static_google_storage_control_v2_IntelligenceConfig_Filter_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storage.control.v2.StorageControlProto
            .internal_static_google_storage_control_v2_IntelligenceConfig_Filter_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storage.control.v2.IntelligenceConfig.Filter.class,
                com.google.storage.control.v2.IntelligenceConfig.Filter.Builder.class);
      }

      // Construct using com.google.storage.control.v2.IntelligenceConfig.Filter.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (includedCloudStorageLocationsBuilder_ != null) {
          includedCloudStorageLocationsBuilder_.clear();
        }
        if (excludedCloudStorageLocationsBuilder_ != null) {
          excludedCloudStorageLocationsBuilder_.clear();
        }
        if (includedCloudStorageBucketsBuilder_ != null) {
          includedCloudStorageBucketsBuilder_.clear();
        }
        if (excludedCloudStorageBucketsBuilder_ != null) {
          excludedCloudStorageBucketsBuilder_.clear();
        }
        cloudStorageLocationsCase_ = 0;
        cloudStorageLocations_ = null;
        cloudStorageBucketsCase_ = 0;
        cloudStorageBuckets_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storage.control.v2.StorageControlProto
            .internal_static_google_storage_control_v2_IntelligenceConfig_Filter_descriptor;
      }

      @java.lang.Override
      public com.google.storage.control.v2.IntelligenceConfig.Filter getDefaultInstanceForType() {
        return com.google.storage.control.v2.IntelligenceConfig.Filter.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storage.control.v2.IntelligenceConfig.Filter build() {
        com.google.storage.control.v2.IntelligenceConfig.Filter result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storage.control.v2.IntelligenceConfig.Filter buildPartial() {
        com.google.storage.control.v2.IntelligenceConfig.Filter result =
            new com.google.storage.control.v2.IntelligenceConfig.Filter(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.storage.control.v2.IntelligenceConfig.Filter result) {
        int from_bitField0_ = bitField0_;
      }

      private void buildPartialOneofs(
          com.google.storage.control.v2.IntelligenceConfig.Filter result) {
        result.cloudStorageLocationsCase_ = cloudStorageLocationsCase_;
        result.cloudStorageLocations_ = this.cloudStorageLocations_;
        if (cloudStorageLocationsCase_ == 1 && includedCloudStorageLocationsBuilder_ != null) {
          result.cloudStorageLocations_ = includedCloudStorageLocationsBuilder_.build();
        }
        if (cloudStorageLocationsCase_ == 2 && excludedCloudStorageLocationsBuilder_ != null) {
          result.cloudStorageLocations_ = excludedCloudStorageLocationsBuilder_.build();
        }
        result.cloudStorageBucketsCase_ = cloudStorageBucketsCase_;
        result.cloudStorageBuckets_ = this.cloudStorageBuckets_;
        if (cloudStorageBucketsCase_ == 3 && includedCloudStorageBucketsBuilder_ != null) {
          result.cloudStorageBuckets_ = includedCloudStorageBucketsBuilder_.build();
        }
        if (cloudStorageBucketsCase_ == 4 && excludedCloudStorageBucketsBuilder_ != null) {
          result.cloudStorageBuckets_ = excludedCloudStorageBucketsBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.storage.control.v2.IntelligenceConfig.Filter) {
          return mergeFrom((com.google.storage.control.v2.IntelligenceConfig.Filter) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.storage.control.v2.IntelligenceConfig.Filter other) {
        if (other == com.google.storage.control.v2.IntelligenceConfig.Filter.getDefaultInstance())
          return this;
        switch (other.getCloudStorageLocationsCase()) {
          case INCLUDED_CLOUD_STORAGE_LOCATIONS:
            {
              mergeIncludedCloudStorageLocations(other.getIncludedCloudStorageLocations());
              break;
            }
          case EXCLUDED_CLOUD_STORAGE_LOCATIONS:
            {
              mergeExcludedCloudStorageLocations(other.getExcludedCloudStorageLocations());
              break;
            }
          case CLOUDSTORAGELOCATIONS_NOT_SET:
            {
              break;
            }
        }
        switch (other.getCloudStorageBucketsCase()) {
          case INCLUDED_CLOUD_STORAGE_BUCKETS:
            {
              mergeIncludedCloudStorageBuckets(other.getIncludedCloudStorageBuckets());
              break;
            }
          case EXCLUDED_CLOUD_STORAGE_BUCKETS:
            {
              mergeExcludedCloudStorageBuckets(other.getExcludedCloudStorageBuckets());
              break;
            }
          case CLOUDSTORAGEBUCKETS_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getIncludedCloudStorageLocationsFieldBuilder().getBuilder(),
                      extensionRegistry);
                  cloudStorageLocationsCase_ = 1;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(
                      getExcludedCloudStorageLocationsFieldBuilder().getBuilder(),
                      extensionRegistry);
                  cloudStorageLocationsCase_ = 2;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(
                      getIncludedCloudStorageBucketsFieldBuilder().getBuilder(), extensionRegistry);
                  cloudStorageBucketsCase_ = 3;
                  break;
                } // case 26
              case 34:
                {
                  input.readMessage(
                      getExcludedCloudStorageBucketsFieldBuilder().getBuilder(), extensionRegistry);
                  cloudStorageBucketsCase_ = 4;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int cloudStorageLocationsCase_ = 0;
      private java.lang.Object cloudStorageLocations_;

      public CloudStorageLocationsCase getCloudStorageLocationsCase() {
        return CloudStorageLocationsCase.forNumber(cloudStorageLocationsCase_);
      }

      public Builder clearCloudStorageLocations() {
        cloudStorageLocationsCase_ = 0;
        cloudStorageLocations_ = null;
        onChanged();
        return this;
      }

      private int cloudStorageBucketsCase_ = 0;
      private java.lang.Object cloudStorageBuckets_;

      public CloudStorageBucketsCase getCloudStorageBucketsCase() {
        return CloudStorageBucketsCase.forNumber(cloudStorageBucketsCase_);
      }

      public Builder clearCloudStorageBuckets() {
        cloudStorageBucketsCase_ = 0;
        cloudStorageBuckets_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations,
              com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations.Builder,
              com.google.storage.control.v2.IntelligenceConfig.Filter
                  .CloudStorageLocationsOrBuilder>
          includedCloudStorageLocationsBuilder_;

      /**
       *
       *
       * <pre>
       * Bucket locations to include.
       * </pre>
       *
       * <code>
       * .google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations included_cloud_storage_locations = 1;
       * </code>
       *
       * @return Whether the includedCloudStorageLocations field is set.
       */
      @java.lang.Override
      public boolean hasIncludedCloudStorageLocations() {
        return cloudStorageLocationsCase_ == 1;
      }

      /**
       *
       *
       * <pre>
       * Bucket locations to include.
       * </pre>
       *
       * <code>
       * .google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations included_cloud_storage_locations = 1;
       * </code>
       *
       * @return The includedCloudStorageLocations.
       */
      @java.lang.Override
      public com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations
          getIncludedCloudStorageLocations() {
        if (includedCloudStorageLocationsBuilder_ == null) {
          if (cloudStorageLocationsCase_ == 1) {
            return (com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations)
                cloudStorageLocations_;
          }
          return com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations
              .getDefaultInstance();
        } else {
          if (cloudStorageLocationsCase_ == 1) {
            return includedCloudStorageLocationsBuilder_.getMessage();
          }
          return com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Bucket locations to include.
       * </pre>
       *
       * <code>
       * .google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations included_cloud_storage_locations = 1;
       * </code>
       */
      public Builder setIncludedCloudStorageLocations(
          com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations value) {
        if (includedCloudStorageLocationsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          cloudStorageLocations_ = value;
          onChanged();
        } else {
          includedCloudStorageLocationsBuilder_.setMessage(value);
        }
        cloudStorageLocationsCase_ = 1;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Bucket locations to include.
       * </pre>
       *
       * <code>
       * .google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations included_cloud_storage_locations = 1;
       * </code>
       */
      public Builder setIncludedCloudStorageLocations(
          com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations.Builder
              builderForValue) {
        if (includedCloudStorageLocationsBuilder_ == null) {
          cloudStorageLocations_ = builderForValue.build();
          onChanged();
        } else {
          includedCloudStorageLocationsBuilder_.setMessage(builderForValue.build());
        }
        cloudStorageLocationsCase_ = 1;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Bucket locations to include.
       * </pre>
       *
       * <code>
       * .google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations included_cloud_storage_locations = 1;
       * </code>
       */
      public Builder mergeIncludedCloudStorageLocations(
          com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations value) {
        if (includedCloudStorageLocationsBuilder_ == null) {
          if (cloudStorageLocationsCase_ == 1
              && cloudStorageLocations_
                  != com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations
                      .getDefaultInstance()) {
            cloudStorageLocations_ =
                com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations
                    .newBuilder(
                        (com.google.storage.control.v2.IntelligenceConfig.Filter
                                .CloudStorageLocations)
                            cloudStorageLocations_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            cloudStorageLocations_ = value;
          }
          onChanged();
        } else {
          if (cloudStorageLocationsCase_ == 1) {
            includedCloudStorageLocationsBuilder_.mergeFrom(value);
          } else {
            includedCloudStorageLocationsBuilder_.setMessage(value);
          }
        }
        cloudStorageLocationsCase_ = 1;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Bucket locations to include.
       * </pre>
       *
       * <code>
       * .google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations included_cloud_storage_locations = 1;
       * </code>
       */
      public Builder clearIncludedCloudStorageLocations() {
        if (includedCloudStorageLocationsBuilder_ == null) {
          if (cloudStorageLocationsCase_ == 1) {
            cloudStorageLocationsCase_ = 0;
            cloudStorageLocations_ = null;
            onChanged();
          }
        } else {
          if (cloudStorageLocationsCase_ == 1) {
            cloudStorageLocationsCase_ = 0;
            cloudStorageLocations_ = null;
          }
          includedCloudStorageLocationsBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Bucket locations to include.
       * </pre>
       *
       * <code>
       * .google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations included_cloud_storage_locations = 1;
       * </code>
       */
      public com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations.Builder
          getIncludedCloudStorageLocationsBuilder() {
        return getIncludedCloudStorageLocationsFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Bucket locations to include.
       * </pre>
       *
       * <code>
       * .google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations included_cloud_storage_locations = 1;
       * </code>
       */
      @java.lang.Override
      public com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocationsOrBuilder
          getIncludedCloudStorageLocationsOrBuilder() {
        if ((cloudStorageLocationsCase_ == 1) && (includedCloudStorageLocationsBuilder_ != null)) {
          return includedCloudStorageLocationsBuilder_.getMessageOrBuilder();
        } else {
          if (cloudStorageLocationsCase_ == 1) {
            return (com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations)
                cloudStorageLocations_;
          }
          return com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Bucket locations to include.
       * </pre>
       *
       * <code>
       * .google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations included_cloud_storage_locations = 1;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations,
              com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations.Builder,
              com.google.storage.control.v2.IntelligenceConfig.Filter
                  .CloudStorageLocationsOrBuilder>
          getIncludedCloudStorageLocationsFieldBuilder() {
        if (includedCloudStorageLocationsBuilder_ == null) {
          if (!(cloudStorageLocationsCase_ == 1)) {
            cloudStorageLocations_ =
                com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations
                    .getDefaultInstance();
          }
          includedCloudStorageLocationsBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations,
                  com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations
                      .Builder,
                  com.google.storage.control.v2.IntelligenceConfig.Filter
                      .CloudStorageLocationsOrBuilder>(
                  (com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations)
                      cloudStorageLocations_,
                  getParentForChildren(),
                  isClean());
          cloudStorageLocations_ = null;
        }
        cloudStorageLocationsCase_ = 1;
        onChanged();
        return includedCloudStorageLocationsBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations,
              com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations.Builder,
              com.google.storage.control.v2.IntelligenceConfig.Filter
                  .CloudStorageLocationsOrBuilder>
          excludedCloudStorageLocationsBuilder_;

      /**
       *
       *
       * <pre>
       * Bucket locations to exclude.
       * </pre>
       *
       * <code>
       * .google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations excluded_cloud_storage_locations = 2;
       * </code>
       *
       * @return Whether the excludedCloudStorageLocations field is set.
       */
      @java.lang.Override
      public boolean hasExcludedCloudStorageLocations() {
        return cloudStorageLocationsCase_ == 2;
      }

      /**
       *
       *
       * <pre>
       * Bucket locations to exclude.
       * </pre>
       *
       * <code>
       * .google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations excluded_cloud_storage_locations = 2;
       * </code>
       *
       * @return The excludedCloudStorageLocations.
       */
      @java.lang.Override
      public com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations
          getExcludedCloudStorageLocations() {
        if (excludedCloudStorageLocationsBuilder_ == null) {
          if (cloudStorageLocationsCase_ == 2) {
            return (com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations)
                cloudStorageLocations_;
          }
          return com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations
              .getDefaultInstance();
        } else {
          if (cloudStorageLocationsCase_ == 2) {
            return excludedCloudStorageLocationsBuilder_.getMessage();
          }
          return com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Bucket locations to exclude.
       * </pre>
       *
       * <code>
       * .google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations excluded_cloud_storage_locations = 2;
       * </code>
       */
      public Builder setExcludedCloudStorageLocations(
          com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations value) {
        if (excludedCloudStorageLocationsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          cloudStorageLocations_ = value;
          onChanged();
        } else {
          excludedCloudStorageLocationsBuilder_.setMessage(value);
        }
        cloudStorageLocationsCase_ = 2;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Bucket locations to exclude.
       * </pre>
       *
       * <code>
       * .google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations excluded_cloud_storage_locations = 2;
       * </code>
       */
      public Builder setExcludedCloudStorageLocations(
          com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations.Builder
              builderForValue) {
        if (excludedCloudStorageLocationsBuilder_ == null) {
          cloudStorageLocations_ = builderForValue.build();
          onChanged();
        } else {
          excludedCloudStorageLocationsBuilder_.setMessage(builderForValue.build());
        }
        cloudStorageLocationsCase_ = 2;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Bucket locations to exclude.
       * </pre>
       *
       * <code>
       * .google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations excluded_cloud_storage_locations = 2;
       * </code>
       */
      public Builder mergeExcludedCloudStorageLocations(
          com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations value) {
        if (excludedCloudStorageLocationsBuilder_ == null) {
          if (cloudStorageLocationsCase_ == 2
              && cloudStorageLocations_
                  != com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations
                      .getDefaultInstance()) {
            cloudStorageLocations_ =
                com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations
                    .newBuilder(
                        (com.google.storage.control.v2.IntelligenceConfig.Filter
                                .CloudStorageLocations)
                            cloudStorageLocations_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            cloudStorageLocations_ = value;
          }
          onChanged();
        } else {
          if (cloudStorageLocationsCase_ == 2) {
            excludedCloudStorageLocationsBuilder_.mergeFrom(value);
          } else {
            excludedCloudStorageLocationsBuilder_.setMessage(value);
          }
        }
        cloudStorageLocationsCase_ = 2;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Bucket locations to exclude.
       * </pre>
       *
       * <code>
       * .google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations excluded_cloud_storage_locations = 2;
       * </code>
       */
      public Builder clearExcludedCloudStorageLocations() {
        if (excludedCloudStorageLocationsBuilder_ == null) {
          if (cloudStorageLocationsCase_ == 2) {
            cloudStorageLocationsCase_ = 0;
            cloudStorageLocations_ = null;
            onChanged();
          }
        } else {
          if (cloudStorageLocationsCase_ == 2) {
            cloudStorageLocationsCase_ = 0;
            cloudStorageLocations_ = null;
          }
          excludedCloudStorageLocationsBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Bucket locations to exclude.
       * </pre>
       *
       * <code>
       * .google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations excluded_cloud_storage_locations = 2;
       * </code>
       */
      public com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations.Builder
          getExcludedCloudStorageLocationsBuilder() {
        return getExcludedCloudStorageLocationsFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Bucket locations to exclude.
       * </pre>
       *
       * <code>
       * .google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations excluded_cloud_storage_locations = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocationsOrBuilder
          getExcludedCloudStorageLocationsOrBuilder() {
        if ((cloudStorageLocationsCase_ == 2) && (excludedCloudStorageLocationsBuilder_ != null)) {
          return excludedCloudStorageLocationsBuilder_.getMessageOrBuilder();
        } else {
          if (cloudStorageLocationsCase_ == 2) {
            return (com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations)
                cloudStorageLocations_;
          }
          return com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Bucket locations to exclude.
       * </pre>
       *
       * <code>
       * .google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations excluded_cloud_storage_locations = 2;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations,
              com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations.Builder,
              com.google.storage.control.v2.IntelligenceConfig.Filter
                  .CloudStorageLocationsOrBuilder>
          getExcludedCloudStorageLocationsFieldBuilder() {
        if (excludedCloudStorageLocationsBuilder_ == null) {
          if (!(cloudStorageLocationsCase_ == 2)) {
            cloudStorageLocations_ =
                com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations
                    .getDefaultInstance();
          }
          excludedCloudStorageLocationsBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations,
                  com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations
                      .Builder,
                  com.google.storage.control.v2.IntelligenceConfig.Filter
                      .CloudStorageLocationsOrBuilder>(
                  (com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageLocations)
                      cloudStorageLocations_,
                  getParentForChildren(),
                  isClean());
          cloudStorageLocations_ = null;
        }
        cloudStorageLocationsCase_ = 2;
        onChanged();
        return excludedCloudStorageLocationsBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets,
              com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets.Builder,
              com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBucketsOrBuilder>
          includedCloudStorageBucketsBuilder_;

      /**
       *
       *
       * <pre>
       * Buckets to include.
       * </pre>
       *
       * <code>
       * .google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets included_cloud_storage_buckets = 3;
       * </code>
       *
       * @return Whether the includedCloudStorageBuckets field is set.
       */
      @java.lang.Override
      public boolean hasIncludedCloudStorageBuckets() {
        return cloudStorageBucketsCase_ == 3;
      }

      /**
       *
       *
       * <pre>
       * Buckets to include.
       * </pre>
       *
       * <code>
       * .google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets included_cloud_storage_buckets = 3;
       * </code>
       *
       * @return The includedCloudStorageBuckets.
       */
      @java.lang.Override
      public com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets
          getIncludedCloudStorageBuckets() {
        if (includedCloudStorageBucketsBuilder_ == null) {
          if (cloudStorageBucketsCase_ == 3) {
            return (com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets)
                cloudStorageBuckets_;
          }
          return com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets
              .getDefaultInstance();
        } else {
          if (cloudStorageBucketsCase_ == 3) {
            return includedCloudStorageBucketsBuilder_.getMessage();
          }
          return com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Buckets to include.
       * </pre>
       *
       * <code>
       * .google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets included_cloud_storage_buckets = 3;
       * </code>
       */
      public Builder setIncludedCloudStorageBuckets(
          com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets value) {
        if (includedCloudStorageBucketsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          cloudStorageBuckets_ = value;
          onChanged();
        } else {
          includedCloudStorageBucketsBuilder_.setMessage(value);
        }
        cloudStorageBucketsCase_ = 3;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Buckets to include.
       * </pre>
       *
       * <code>
       * .google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets included_cloud_storage_buckets = 3;
       * </code>
       */
      public Builder setIncludedCloudStorageBuckets(
          com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets.Builder
              builderForValue) {
        if (includedCloudStorageBucketsBuilder_ == null) {
          cloudStorageBuckets_ = builderForValue.build();
          onChanged();
        } else {
          includedCloudStorageBucketsBuilder_.setMessage(builderForValue.build());
        }
        cloudStorageBucketsCase_ = 3;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Buckets to include.
       * </pre>
       *
       * <code>
       * .google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets included_cloud_storage_buckets = 3;
       * </code>
       */
      public Builder mergeIncludedCloudStorageBuckets(
          com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets value) {
        if (includedCloudStorageBucketsBuilder_ == null) {
          if (cloudStorageBucketsCase_ == 3
              && cloudStorageBuckets_
                  != com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets
                      .getDefaultInstance()) {
            cloudStorageBuckets_ =
                com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets
                    .newBuilder(
                        (com.google.storage.control.v2.IntelligenceConfig.Filter
                                .CloudStorageBuckets)
                            cloudStorageBuckets_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            cloudStorageBuckets_ = value;
          }
          onChanged();
        } else {
          if (cloudStorageBucketsCase_ == 3) {
            includedCloudStorageBucketsBuilder_.mergeFrom(value);
          } else {
            includedCloudStorageBucketsBuilder_.setMessage(value);
          }
        }
        cloudStorageBucketsCase_ = 3;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Buckets to include.
       * </pre>
       *
       * <code>
       * .google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets included_cloud_storage_buckets = 3;
       * </code>
       */
      public Builder clearIncludedCloudStorageBuckets() {
        if (includedCloudStorageBucketsBuilder_ == null) {
          if (cloudStorageBucketsCase_ == 3) {
            cloudStorageBucketsCase_ = 0;
            cloudStorageBuckets_ = null;
            onChanged();
          }
        } else {
          if (cloudStorageBucketsCase_ == 3) {
            cloudStorageBucketsCase_ = 0;
            cloudStorageBuckets_ = null;
          }
          includedCloudStorageBucketsBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Buckets to include.
       * </pre>
       *
       * <code>
       * .google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets included_cloud_storage_buckets = 3;
       * </code>
       */
      public com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets.Builder
          getIncludedCloudStorageBucketsBuilder() {
        return getIncludedCloudStorageBucketsFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Buckets to include.
       * </pre>
       *
       * <code>
       * .google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets included_cloud_storage_buckets = 3;
       * </code>
       */
      @java.lang.Override
      public com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBucketsOrBuilder
          getIncludedCloudStorageBucketsOrBuilder() {
        if ((cloudStorageBucketsCase_ == 3) && (includedCloudStorageBucketsBuilder_ != null)) {
          return includedCloudStorageBucketsBuilder_.getMessageOrBuilder();
        } else {
          if (cloudStorageBucketsCase_ == 3) {
            return (com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets)
                cloudStorageBuckets_;
          }
          return com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Buckets to include.
       * </pre>
       *
       * <code>
       * .google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets included_cloud_storage_buckets = 3;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets,
              com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets.Builder,
              com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBucketsOrBuilder>
          getIncludedCloudStorageBucketsFieldBuilder() {
        if (includedCloudStorageBucketsBuilder_ == null) {
          if (!(cloudStorageBucketsCase_ == 3)) {
            cloudStorageBuckets_ =
                com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets
                    .getDefaultInstance();
          }
          includedCloudStorageBucketsBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets,
                  com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets
                      .Builder,
                  com.google.storage.control.v2.IntelligenceConfig.Filter
                      .CloudStorageBucketsOrBuilder>(
                  (com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets)
                      cloudStorageBuckets_,
                  getParentForChildren(),
                  isClean());
          cloudStorageBuckets_ = null;
        }
        cloudStorageBucketsCase_ = 3;
        onChanged();
        return includedCloudStorageBucketsBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets,
              com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets.Builder,
              com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBucketsOrBuilder>
          excludedCloudStorageBucketsBuilder_;

      /**
       *
       *
       * <pre>
       * Buckets to exclude.
       * </pre>
       *
       * <code>
       * .google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets excluded_cloud_storage_buckets = 4;
       * </code>
       *
       * @return Whether the excludedCloudStorageBuckets field is set.
       */
      @java.lang.Override
      public boolean hasExcludedCloudStorageBuckets() {
        return cloudStorageBucketsCase_ == 4;
      }

      /**
       *
       *
       * <pre>
       * Buckets to exclude.
       * </pre>
       *
       * <code>
       * .google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets excluded_cloud_storage_buckets = 4;
       * </code>
       *
       * @return The excludedCloudStorageBuckets.
       */
      @java.lang.Override
      public com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets
          getExcludedCloudStorageBuckets() {
        if (excludedCloudStorageBucketsBuilder_ == null) {
          if (cloudStorageBucketsCase_ == 4) {
            return (com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets)
                cloudStorageBuckets_;
          }
          return com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets
              .getDefaultInstance();
        } else {
          if (cloudStorageBucketsCase_ == 4) {
            return excludedCloudStorageBucketsBuilder_.getMessage();
          }
          return com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Buckets to exclude.
       * </pre>
       *
       * <code>
       * .google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets excluded_cloud_storage_buckets = 4;
       * </code>
       */
      public Builder setExcludedCloudStorageBuckets(
          com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets value) {
        if (excludedCloudStorageBucketsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          cloudStorageBuckets_ = value;
          onChanged();
        } else {
          excludedCloudStorageBucketsBuilder_.setMessage(value);
        }
        cloudStorageBucketsCase_ = 4;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Buckets to exclude.
       * </pre>
       *
       * <code>
       * .google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets excluded_cloud_storage_buckets = 4;
       * </code>
       */
      public Builder setExcludedCloudStorageBuckets(
          com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets.Builder
              builderForValue) {
        if (excludedCloudStorageBucketsBuilder_ == null) {
          cloudStorageBuckets_ = builderForValue.build();
          onChanged();
        } else {
          excludedCloudStorageBucketsBuilder_.setMessage(builderForValue.build());
        }
        cloudStorageBucketsCase_ = 4;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Buckets to exclude.
       * </pre>
       *
       * <code>
       * .google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets excluded_cloud_storage_buckets = 4;
       * </code>
       */
      public Builder mergeExcludedCloudStorageBuckets(
          com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets value) {
        if (excludedCloudStorageBucketsBuilder_ == null) {
          if (cloudStorageBucketsCase_ == 4
              && cloudStorageBuckets_
                  != com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets
                      .getDefaultInstance()) {
            cloudStorageBuckets_ =
                com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets
                    .newBuilder(
                        (com.google.storage.control.v2.IntelligenceConfig.Filter
                                .CloudStorageBuckets)
                            cloudStorageBuckets_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            cloudStorageBuckets_ = value;
          }
          onChanged();
        } else {
          if (cloudStorageBucketsCase_ == 4) {
            excludedCloudStorageBucketsBuilder_.mergeFrom(value);
          } else {
            excludedCloudStorageBucketsBuilder_.setMessage(value);
          }
        }
        cloudStorageBucketsCase_ = 4;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Buckets to exclude.
       * </pre>
       *
       * <code>
       * .google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets excluded_cloud_storage_buckets = 4;
       * </code>
       */
      public Builder clearExcludedCloudStorageBuckets() {
        if (excludedCloudStorageBucketsBuilder_ == null) {
          if (cloudStorageBucketsCase_ == 4) {
            cloudStorageBucketsCase_ = 0;
            cloudStorageBuckets_ = null;
            onChanged();
          }
        } else {
          if (cloudStorageBucketsCase_ == 4) {
            cloudStorageBucketsCase_ = 0;
            cloudStorageBuckets_ = null;
          }
          excludedCloudStorageBucketsBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Buckets to exclude.
       * </pre>
       *
       * <code>
       * .google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets excluded_cloud_storage_buckets = 4;
       * </code>
       */
      public com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets.Builder
          getExcludedCloudStorageBucketsBuilder() {
        return getExcludedCloudStorageBucketsFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Buckets to exclude.
       * </pre>
       *
       * <code>
       * .google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets excluded_cloud_storage_buckets = 4;
       * </code>
       */
      @java.lang.Override
      public com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBucketsOrBuilder
          getExcludedCloudStorageBucketsOrBuilder() {
        if ((cloudStorageBucketsCase_ == 4) && (excludedCloudStorageBucketsBuilder_ != null)) {
          return excludedCloudStorageBucketsBuilder_.getMessageOrBuilder();
        } else {
          if (cloudStorageBucketsCase_ == 4) {
            return (com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets)
                cloudStorageBuckets_;
          }
          return com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Buckets to exclude.
       * </pre>
       *
       * <code>
       * .google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets excluded_cloud_storage_buckets = 4;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets,
              com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets.Builder,
              com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBucketsOrBuilder>
          getExcludedCloudStorageBucketsFieldBuilder() {
        if (excludedCloudStorageBucketsBuilder_ == null) {
          if (!(cloudStorageBucketsCase_ == 4)) {
            cloudStorageBuckets_ =
                com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets
                    .getDefaultInstance();
          }
          excludedCloudStorageBucketsBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets,
                  com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets
                      .Builder,
                  com.google.storage.control.v2.IntelligenceConfig.Filter
                      .CloudStorageBucketsOrBuilder>(
                  (com.google.storage.control.v2.IntelligenceConfig.Filter.CloudStorageBuckets)
                      cloudStorageBuckets_,
                  getParentForChildren(),
                  isClean());
          cloudStorageBuckets_ = null;
        }
        cloudStorageBucketsCase_ = 4;
        onChanged();
        return excludedCloudStorageBucketsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storage.control.v2.IntelligenceConfig.Filter)
    }

    // @@protoc_insertion_point(class_scope:google.storage.control.v2.IntelligenceConfig.Filter)
    private static final com.google.storage.control.v2.IntelligenceConfig.Filter DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.storage.control.v2.IntelligenceConfig.Filter();
    }

    public static com.google.storage.control.v2.IntelligenceConfig.Filter getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Filter> PARSER =
        new com.google.protobuf.AbstractParser<Filter>() {
          @java.lang.Override
          public Filter parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Filter> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Filter> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storage.control.v2.IntelligenceConfig.Filter getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface EffectiveIntelligenceConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. The `IntelligenceConfig` edition that is applicable for the
     * resource.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig.EffectiveEdition effective_edition = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for effectiveEdition.
     */
    int getEffectiveEditionValue();

    /**
     *
     *
     * <pre>
     * Output only. The `IntelligenceConfig` edition that is applicable for the
     * resource.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig.EffectiveEdition effective_edition = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The effectiveEdition.
     */
    com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig.EffectiveEdition
        getEffectiveEdition();

    /**
     *
     *
     * <pre>
     * Output only. The `IntelligenceConfig` resource that is applied for the
     * target resource. Format:
     * `{organizations|folders|projects}/{id}/locations/{location}/intelligenceConfig`
     * </pre>
     *
     * <code>string intelligence_config = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The intelligenceConfig.
     */
    java.lang.String getIntelligenceConfig();

    /**
     *
     *
     * <pre>
     * Output only. The `IntelligenceConfig` resource that is applied for the
     * target resource. Format:
     * `{organizations|folders|projects}/{id}/locations/{location}/intelligenceConfig`
     * </pre>
     *
     * <code>string intelligence_config = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for intelligenceConfig.
     */
    com.google.protobuf.ByteString getIntelligenceConfigBytes();
  }

  /**
   *
   *
   * <pre>
   * The effective `IntelligenceConfig` for the resource.
   * </pre>
   *
   * Protobuf type {@code google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig}
   */
  public static final class EffectiveIntelligenceConfig
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig)
      EffectiveIntelligenceConfigOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use EffectiveIntelligenceConfig.newBuilder() to construct.
    private EffectiveIntelligenceConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private EffectiveIntelligenceConfig() {
      effectiveEdition_ = 0;
      intelligenceConfig_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new EffectiveIntelligenceConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.control.v2.StorageControlProto
          .internal_static_google_storage_control_v2_IntelligenceConfig_EffectiveIntelligenceConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.control.v2.StorageControlProto
          .internal_static_google_storage_control_v2_IntelligenceConfig_EffectiveIntelligenceConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig.class,
              com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig.Builder
                  .class);
    }

    /**
     *
     *
     * <pre>
     * The effective edition of the `IntelligenceConfig` resource.
     * </pre>
     *
     * Protobuf enum {@code
     * google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig.EffectiveEdition}
     */
    public enum EffectiveEdition implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * This is an unknown edition of the resource.
       * </pre>
       *
       * <code>EFFECTIVE_EDITION_UNSPECIFIED = 0;</code>
       */
      EFFECTIVE_EDITION_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * No edition.
       * </pre>
       *
       * <code>NONE = 1;</code>
       */
      NONE(1),
      /**
       *
       *
       * <pre>
       * The `IntelligenceConfig` resource is of STANDARD edition.
       * </pre>
       *
       * <code>STANDARD = 2;</code>
       */
      STANDARD(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * This is an unknown edition of the resource.
       * </pre>
       *
       * <code>EFFECTIVE_EDITION_UNSPECIFIED = 0;</code>
       */
      public static final int EFFECTIVE_EDITION_UNSPECIFIED_VALUE = 0;

      /**
       *
       *
       * <pre>
       * No edition.
       * </pre>
       *
       * <code>NONE = 1;</code>
       */
      public static final int NONE_VALUE = 1;

      /**
       *
       *
       * <pre>
       * The `IntelligenceConfig` resource is of STANDARD edition.
       * </pre>
       *
       * <code>STANDARD = 2;</code>
       */
      public static final int STANDARD_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static EffectiveEdition valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static EffectiveEdition forNumber(int value) {
        switch (value) {
          case 0:
            return EFFECTIVE_EDITION_UNSPECIFIED;
          case 1:
            return NONE;
          case 2:
            return STANDARD;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<EffectiveEdition>
          internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<EffectiveEdition>
          internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<EffectiveEdition>() {
                public EffectiveEdition findValueByNumber(int number) {
                  return EffectiveEdition.forNumber(number);
                }
              };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig
            .getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final EffectiveEdition[] VALUES = values();

      public static EffectiveEdition valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private EffectiveEdition(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig.EffectiveEdition)
    }

    public static final int EFFECTIVE_EDITION_FIELD_NUMBER = 1;
    private int effectiveEdition_ = 0;

    /**
     *
     *
     * <pre>
     * Output only. The `IntelligenceConfig` edition that is applicable for the
     * resource.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig.EffectiveEdition effective_edition = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for effectiveEdition.
     */
    @java.lang.Override
    public int getEffectiveEditionValue() {
      return effectiveEdition_;
    }

    /**
     *
     *
     * <pre>
     * Output only. The `IntelligenceConfig` edition that is applicable for the
     * resource.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig.EffectiveEdition effective_edition = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The effectiveEdition.
     */
    @java.lang.Override
    public com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig
            .EffectiveEdition
        getEffectiveEdition() {
      com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig.EffectiveEdition
          result =
              com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig
                  .EffectiveEdition.forNumber(effectiveEdition_);
      return result == null
          ? com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig
              .EffectiveEdition.UNRECOGNIZED
          : result;
    }

    public static final int INTELLIGENCE_CONFIG_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object intelligenceConfig_ = "";

    /**
     *
     *
     * <pre>
     * Output only. The `IntelligenceConfig` resource that is applied for the
     * target resource. Format:
     * `{organizations|folders|projects}/{id}/locations/{location}/intelligenceConfig`
     * </pre>
     *
     * <code>string intelligence_config = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The intelligenceConfig.
     */
    @java.lang.Override
    public java.lang.String getIntelligenceConfig() {
      java.lang.Object ref = intelligenceConfig_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        intelligenceConfig_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The `IntelligenceConfig` resource that is applied for the
     * target resource. Format:
     * `{organizations|folders|projects}/{id}/locations/{location}/intelligenceConfig`
     * </pre>
     *
     * <code>string intelligence_config = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for intelligenceConfig.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getIntelligenceConfigBytes() {
      java.lang.Object ref = intelligenceConfig_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        intelligenceConfig_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (effectiveEdition_
          != com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig
              .EffectiveEdition.EFFECTIVE_EDITION_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, effectiveEdition_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(intelligenceConfig_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, intelligenceConfig_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (effectiveEdition_
          != com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig
              .EffectiveEdition.EFFECTIVE_EDITION_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, effectiveEdition_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(intelligenceConfig_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, intelligenceConfig_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig)) {
        return super.equals(obj);
      }
      com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig other =
          (com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig) obj;

      if (effectiveEdition_ != other.effectiveEdition_) return false;
      if (!getIntelligenceConfig().equals(other.getIntelligenceConfig())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + EFFECTIVE_EDITION_FIELD_NUMBER;
      hash = (53 * hash) + effectiveEdition_;
      hash = (37 * hash) + INTELLIGENCE_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getIntelligenceConfig().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * The effective `IntelligenceConfig` for the resource.
     * </pre>
     *
     * Protobuf type {@code
     * google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig)
        com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storage.control.v2.StorageControlProto
            .internal_static_google_storage_control_v2_IntelligenceConfig_EffectiveIntelligenceConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storage.control.v2.StorageControlProto
            .internal_static_google_storage_control_v2_IntelligenceConfig_EffectiveIntelligenceConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig.class,
                com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig.Builder
                    .class);
      }

      // Construct using
      // com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        effectiveEdition_ = 0;
        intelligenceConfig_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storage.control.v2.StorageControlProto
            .internal_static_google_storage_control_v2_IntelligenceConfig_EffectiveIntelligenceConfig_descriptor;
      }

      @java.lang.Override
      public com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig
          getDefaultInstanceForType() {
        return com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig build() {
        com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig
          buildPartial() {
        com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig result =
            new com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.effectiveEdition_ = effectiveEdition_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.intelligenceConfig_ = intelligenceConfig_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig) {
          return mergeFrom(
              (com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig other) {
        if (other
            == com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig
                .getDefaultInstance()) return this;
        if (other.effectiveEdition_ != 0) {
          setEffectiveEditionValue(other.getEffectiveEditionValue());
        }
        if (!other.getIntelligenceConfig().isEmpty()) {
          intelligenceConfig_ = other.intelligenceConfig_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  effectiveEdition_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  intelligenceConfig_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int effectiveEdition_ = 0;

      /**
       *
       *
       * <pre>
       * Output only. The `IntelligenceConfig` edition that is applicable for the
       * resource.
       * </pre>
       *
       * <code>
       * .google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig.EffectiveEdition effective_edition = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The enum numeric value on the wire for effectiveEdition.
       */
      @java.lang.Override
      public int getEffectiveEditionValue() {
        return effectiveEdition_;
      }

      /**
       *
       *
       * <pre>
       * Output only. The `IntelligenceConfig` edition that is applicable for the
       * resource.
       * </pre>
       *
       * <code>
       * .google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig.EffectiveEdition effective_edition = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The enum numeric value on the wire for effectiveEdition to set.
       * @return This builder for chaining.
       */
      public Builder setEffectiveEditionValue(int value) {
        effectiveEdition_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The `IntelligenceConfig` edition that is applicable for the
       * resource.
       * </pre>
       *
       * <code>
       * .google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig.EffectiveEdition effective_edition = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The effectiveEdition.
       */
      @java.lang.Override
      public com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig
              .EffectiveEdition
          getEffectiveEdition() {
        com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig
                .EffectiveEdition
            result =
                com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig
                    .EffectiveEdition.forNumber(effectiveEdition_);
        return result == null
            ? com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig
                .EffectiveEdition.UNRECOGNIZED
            : result;
      }

      /**
       *
       *
       * <pre>
       * Output only. The `IntelligenceConfig` edition that is applicable for the
       * resource.
       * </pre>
       *
       * <code>
       * .google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig.EffectiveEdition effective_edition = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The effectiveEdition to set.
       * @return This builder for chaining.
       */
      public Builder setEffectiveEdition(
          com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig
                  .EffectiveEdition
              value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        effectiveEdition_ = value.getNumber();
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The `IntelligenceConfig` edition that is applicable for the
       * resource.
       * </pre>
       *
       * <code>
       * .google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig.EffectiveEdition effective_edition = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEffectiveEdition() {
        bitField0_ = (bitField0_ & ~0x00000001);
        effectiveEdition_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object intelligenceConfig_ = "";

      /**
       *
       *
       * <pre>
       * Output only. The `IntelligenceConfig` resource that is applied for the
       * target resource. Format:
       * `{organizations|folders|projects}/{id}/locations/{location}/intelligenceConfig`
       * </pre>
       *
       * <code>string intelligence_config = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The intelligenceConfig.
       */
      public java.lang.String getIntelligenceConfig() {
        java.lang.Object ref = intelligenceConfig_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          intelligenceConfig_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. The `IntelligenceConfig` resource that is applied for the
       * target resource. Format:
       * `{organizations|folders|projects}/{id}/locations/{location}/intelligenceConfig`
       * </pre>
       *
       * <code>string intelligence_config = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for intelligenceConfig.
       */
      public com.google.protobuf.ByteString getIntelligenceConfigBytes() {
        java.lang.Object ref = intelligenceConfig_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          intelligenceConfig_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. The `IntelligenceConfig` resource that is applied for the
       * target resource. Format:
       * `{organizations|folders|projects}/{id}/locations/{location}/intelligenceConfig`
       * </pre>
       *
       * <code>string intelligence_config = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The intelligenceConfig to set.
       * @return This builder for chaining.
       */
      public Builder setIntelligenceConfig(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        intelligenceConfig_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The `IntelligenceConfig` resource that is applied for the
       * target resource. Format:
       * `{organizations|folders|projects}/{id}/locations/{location}/intelligenceConfig`
       * </pre>
       *
       * <code>string intelligence_config = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearIntelligenceConfig() {
        intelligenceConfig_ = getDefaultInstance().getIntelligenceConfig();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The `IntelligenceConfig` resource that is applied for the
       * target resource. Format:
       * `{organizations|folders|projects}/{id}/locations/{location}/intelligenceConfig`
       * </pre>
       *
       * <code>string intelligence_config = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for intelligenceConfig to set.
       * @return This builder for chaining.
       */
      public Builder setIntelligenceConfigBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        intelligenceConfig_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig)
    }

    // @@protoc_insertion_point(class_scope:google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig)
    private static final com.google.storage.control.v2.IntelligenceConfig
            .EffectiveIntelligenceConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig();
    }

    public static com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<EffectiveIntelligenceConfig> PARSER =
        new com.google.protobuf.AbstractParser<EffectiveIntelligenceConfig>() {
          @java.lang.Override
          public EffectiveIntelligenceConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<EffectiveIntelligenceConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<EffectiveIntelligenceConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface TrialConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storage.control.v2.IntelligenceConfig.TrialConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. The time at which the trial expires.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the expireTime field is set.
     */
    boolean hasExpireTime();

    /**
     *
     *
     * <pre>
     * Output only. The time at which the trial expires.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The expireTime.
     */
    com.google.protobuf.Timestamp getExpireTime();

    /**
     *
     *
     * <pre>
     * Output only. The time at which the trial expires.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder();
  }

  /**
   *
   *
   * <pre>
   * The trial configuration of the `IntelligenceConfig` resource.
   * </pre>
   *
   * Protobuf type {@code google.storage.control.v2.IntelligenceConfig.TrialConfig}
   */
  public static final class TrialConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storage.control.v2.IntelligenceConfig.TrialConfig)
      TrialConfigOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use TrialConfig.newBuilder() to construct.
    private TrialConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TrialConfig() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new TrialConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.control.v2.StorageControlProto
          .internal_static_google_storage_control_v2_IntelligenceConfig_TrialConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.control.v2.StorageControlProto
          .internal_static_google_storage_control_v2_IntelligenceConfig_TrialConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.control.v2.IntelligenceConfig.TrialConfig.class,
              com.google.storage.control.v2.IntelligenceConfig.TrialConfig.Builder.class);
    }

    private int bitField0_;
    public static final int EXPIRE_TIME_FIELD_NUMBER = 3;
    private com.google.protobuf.Timestamp expireTime_;

    /**
     *
     *
     * <pre>
     * Output only. The time at which the trial expires.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the expireTime field is set.
     */
    @java.lang.Override
    public boolean hasExpireTime() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. The time at which the trial expires.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The expireTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getExpireTime() {
      return expireTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : expireTime_;
    }

    /**
     *
     *
     * <pre>
     * Output only. The time at which the trial expires.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder() {
      return expireTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : expireTime_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(3, getExpireTime());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getExpireTime());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.storage.control.v2.IntelligenceConfig.TrialConfig)) {
        return super.equals(obj);
      }
      com.google.storage.control.v2.IntelligenceConfig.TrialConfig other =
          (com.google.storage.control.v2.IntelligenceConfig.TrialConfig) obj;

      if (hasExpireTime() != other.hasExpireTime()) return false;
      if (hasExpireTime()) {
        if (!getExpireTime().equals(other.getExpireTime())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasExpireTime()) {
        hash = (37 * hash) + EXPIRE_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getExpireTime().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storage.control.v2.IntelligenceConfig.TrialConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.control.v2.IntelligenceConfig.TrialConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.control.v2.IntelligenceConfig.TrialConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.control.v2.IntelligenceConfig.TrialConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.control.v2.IntelligenceConfig.TrialConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.control.v2.IntelligenceConfig.TrialConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.control.v2.IntelligenceConfig.TrialConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.control.v2.IntelligenceConfig.TrialConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.control.v2.IntelligenceConfig.TrialConfig parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storage.control.v2.IntelligenceConfig.TrialConfig parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.control.v2.IntelligenceConfig.TrialConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.control.v2.IntelligenceConfig.TrialConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.storage.control.v2.IntelligenceConfig.TrialConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * The trial configuration of the `IntelligenceConfig` resource.
     * </pre>
     *
     * Protobuf type {@code google.storage.control.v2.IntelligenceConfig.TrialConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storage.control.v2.IntelligenceConfig.TrialConfig)
        com.google.storage.control.v2.IntelligenceConfig.TrialConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storage.control.v2.StorageControlProto
            .internal_static_google_storage_control_v2_IntelligenceConfig_TrialConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storage.control.v2.StorageControlProto
            .internal_static_google_storage_control_v2_IntelligenceConfig_TrialConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storage.control.v2.IntelligenceConfig.TrialConfig.class,
                com.google.storage.control.v2.IntelligenceConfig.TrialConfig.Builder.class);
      }

      // Construct using com.google.storage.control.v2.IntelligenceConfig.TrialConfig.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getExpireTimeFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        expireTime_ = null;
        if (expireTimeBuilder_ != null) {
          expireTimeBuilder_.dispose();
          expireTimeBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storage.control.v2.StorageControlProto
            .internal_static_google_storage_control_v2_IntelligenceConfig_TrialConfig_descriptor;
      }

      @java.lang.Override
      public com.google.storage.control.v2.IntelligenceConfig.TrialConfig
          getDefaultInstanceForType() {
        return com.google.storage.control.v2.IntelligenceConfig.TrialConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storage.control.v2.IntelligenceConfig.TrialConfig build() {
        com.google.storage.control.v2.IntelligenceConfig.TrialConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storage.control.v2.IntelligenceConfig.TrialConfig buildPartial() {
        com.google.storage.control.v2.IntelligenceConfig.TrialConfig result =
            new com.google.storage.control.v2.IntelligenceConfig.TrialConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.storage.control.v2.IntelligenceConfig.TrialConfig result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.expireTime_ =
              expireTimeBuilder_ == null ? expireTime_ : expireTimeBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.storage.control.v2.IntelligenceConfig.TrialConfig) {
          return mergeFrom((com.google.storage.control.v2.IntelligenceConfig.TrialConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.storage.control.v2.IntelligenceConfig.TrialConfig other) {
        if (other
            == com.google.storage.control.v2.IntelligenceConfig.TrialConfig.getDefaultInstance())
          return this;
        if (other.hasExpireTime()) {
          mergeExpireTime(other.getExpireTime());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 26:
                {
                  input.readMessage(getExpireTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.Timestamp expireTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          expireTimeBuilder_;

      /**
       *
       *
       * <pre>
       * Output only. The time at which the trial expires.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp expire_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return Whether the expireTime field is set.
       */
      public boolean hasExpireTime() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * Output only. The time at which the trial expires.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp expire_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The expireTime.
       */
      public com.google.protobuf.Timestamp getExpireTime() {
        if (expireTimeBuilder_ == null) {
          return expireTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : expireTime_;
        } else {
          return expireTimeBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. The time at which the trial expires.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp expire_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setExpireTime(com.google.protobuf.Timestamp value) {
        if (expireTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          expireTime_ = value;
        } else {
          expireTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The time at which the trial expires.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp expire_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setExpireTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (expireTimeBuilder_ == null) {
          expireTime_ = builderForValue.build();
        } else {
          expireTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The time at which the trial expires.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp expire_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder mergeExpireTime(com.google.protobuf.Timestamp value) {
        if (expireTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && expireTime_ != null
              && expireTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getExpireTimeBuilder().mergeFrom(value);
          } else {
            expireTime_ = value;
          }
        } else {
          expireTimeBuilder_.mergeFrom(value);
        }
        if (expireTime_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The time at which the trial expires.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp expire_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder clearExpireTime() {
        bitField0_ = (bitField0_ & ~0x00000001);
        expireTime_ = null;
        if (expireTimeBuilder_ != null) {
          expireTimeBuilder_.dispose();
          expireTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The time at which the trial expires.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp expire_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.protobuf.Timestamp.Builder getExpireTimeBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getExpireTimeFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Output only. The time at which the trial expires.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp expire_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder() {
        if (expireTimeBuilder_ != null) {
          return expireTimeBuilder_.getMessageOrBuilder();
        } else {
          return expireTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : expireTime_;
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. The time at which the trial expires.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp expire_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getExpireTimeFieldBuilder() {
        if (expireTimeBuilder_ == null) {
          expireTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getExpireTime(), getParentForChildren(), isClean());
          expireTime_ = null;
        }
        return expireTimeBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storage.control.v2.IntelligenceConfig.TrialConfig)
    }

    // @@protoc_insertion_point(class_scope:google.storage.control.v2.IntelligenceConfig.TrialConfig)
    private static final com.google.storage.control.v2.IntelligenceConfig.TrialConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.storage.control.v2.IntelligenceConfig.TrialConfig();
    }

    public static com.google.storage.control.v2.IntelligenceConfig.TrialConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TrialConfig> PARSER =
        new com.google.protobuf.AbstractParser<TrialConfig>() {
          @java.lang.Override
          public TrialConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<TrialConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TrialConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storage.control.v2.IntelligenceConfig.TrialConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Identifier. The name of the `IntelligenceConfig` resource associated with
   * your organization, folder, or project.
   *
   * The name format varies based on the GCP resource hierarchy as follows:
   *
   * * For project:
   * `projects/{project_number}/locations/global/intelligenceConfig`
   * * For organization:
   * `organizations/{org_id}/locations/global/intelligenceConfig`
   * * For folder: `folders/{folder_id}/locations/global/intelligenceConfig`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Identifier. The name of the `IntelligenceConfig` resource associated with
   * your organization, folder, or project.
   *
   * The name format varies based on the GCP resource hierarchy as follows:
   *
   * * For project:
   * `projects/{project_number}/locations/global/intelligenceConfig`
   * * For organization:
   * `organizations/{org_id}/locations/global/intelligenceConfig`
   * * For folder: `folders/{folder_id}/locations/global/intelligenceConfig`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EDITION_CONFIG_FIELD_NUMBER = 2;
  private int editionConfig_ = 0;

  /**
   *
   *
   * <pre>
   * Optional. The edition configuration of the `IntelligenceConfig` resource.
   * </pre>
   *
   * <code>
   * .google.storage.control.v2.IntelligenceConfig.EditionConfig edition_config = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for editionConfig.
   */
  @java.lang.Override
  public int getEditionConfigValue() {
    return editionConfig_;
  }

  /**
   *
   *
   * <pre>
   * Optional. The edition configuration of the `IntelligenceConfig` resource.
   * </pre>
   *
   * <code>
   * .google.storage.control.v2.IntelligenceConfig.EditionConfig edition_config = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The editionConfig.
   */
  @java.lang.Override
  public com.google.storage.control.v2.IntelligenceConfig.EditionConfig getEditionConfig() {
    com.google.storage.control.v2.IntelligenceConfig.EditionConfig result =
        com.google.storage.control.v2.IntelligenceConfig.EditionConfig.forNumber(editionConfig_);
    return result == null
        ? com.google.storage.control.v2.IntelligenceConfig.EditionConfig.UNRECOGNIZED
        : result;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp updateTime_;

  /**
   *
   *
   * <pre>
   * Output only. The time at which the `IntelligenceConfig` resource is last
   * updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. The time at which the `IntelligenceConfig` resource is last
   * updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The time at which the `IntelligenceConfig` resource is last
   * updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int FILTER_FIELD_NUMBER = 4;
  private com.google.storage.control.v2.IntelligenceConfig.Filter filter_;

  /**
   *
   *
   * <pre>
   * Optional. Filter over location and bucket.
   * </pre>
   *
   * <code>
   * .google.storage.control.v2.IntelligenceConfig.Filter filter = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the filter field is set.
   */
  @java.lang.Override
  public boolean hasFilter() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Filter over location and bucket.
   * </pre>
   *
   * <code>
   * .google.storage.control.v2.IntelligenceConfig.Filter filter = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The filter.
   */
  @java.lang.Override
  public com.google.storage.control.v2.IntelligenceConfig.Filter getFilter() {
    return filter_ == null
        ? com.google.storage.control.v2.IntelligenceConfig.Filter.getDefaultInstance()
        : filter_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Filter over location and bucket.
   * </pre>
   *
   * <code>
   * .google.storage.control.v2.IntelligenceConfig.Filter filter = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.storage.control.v2.IntelligenceConfig.FilterOrBuilder getFilterOrBuilder() {
    return filter_ == null
        ? com.google.storage.control.v2.IntelligenceConfig.Filter.getDefaultInstance()
        : filter_;
  }

  public static final int EFFECTIVE_INTELLIGENCE_CONFIG_FIELD_NUMBER = 5;
  private com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig
      effectiveIntelligenceConfig_;

  /**
   *
   *
   * <pre>
   * Output only. The `IntelligenceConfig` resource that is applicable for the
   * resource.
   * </pre>
   *
   * <code>
   * .google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig effective_intelligence_config = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the effectiveIntelligenceConfig field is set.
   */
  @java.lang.Override
  public boolean hasEffectiveIntelligenceConfig() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. The `IntelligenceConfig` resource that is applicable for the
   * resource.
   * </pre>
   *
   * <code>
   * .google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig effective_intelligence_config = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The effectiveIntelligenceConfig.
   */
  @java.lang.Override
  public com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig
      getEffectiveIntelligenceConfig() {
    return effectiveIntelligenceConfig_ == null
        ? com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig
            .getDefaultInstance()
        : effectiveIntelligenceConfig_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The `IntelligenceConfig` resource that is applicable for the
   * resource.
   * </pre>
   *
   * <code>
   * .google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig effective_intelligence_config = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfigOrBuilder
      getEffectiveIntelligenceConfigOrBuilder() {
    return effectiveIntelligenceConfig_ == null
        ? com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig
            .getDefaultInstance()
        : effectiveIntelligenceConfig_;
  }

  public static final int TRIAL_CONFIG_FIELD_NUMBER = 7;
  private com.google.storage.control.v2.IntelligenceConfig.TrialConfig trialConfig_;

  /**
   *
   *
   * <pre>
   * The trial configuration of the `IntelligenceConfig` resource.
   * </pre>
   *
   * <code>.google.storage.control.v2.IntelligenceConfig.TrialConfig trial_config = 7;</code>
   *
   * @return Whether the trialConfig field is set.
   */
  @java.lang.Override
  public boolean hasTrialConfig() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * The trial configuration of the `IntelligenceConfig` resource.
   * </pre>
   *
   * <code>.google.storage.control.v2.IntelligenceConfig.TrialConfig trial_config = 7;</code>
   *
   * @return The trialConfig.
   */
  @java.lang.Override
  public com.google.storage.control.v2.IntelligenceConfig.TrialConfig getTrialConfig() {
    return trialConfig_ == null
        ? com.google.storage.control.v2.IntelligenceConfig.TrialConfig.getDefaultInstance()
        : trialConfig_;
  }

  /**
   *
   *
   * <pre>
   * The trial configuration of the `IntelligenceConfig` resource.
   * </pre>
   *
   * <code>.google.storage.control.v2.IntelligenceConfig.TrialConfig trial_config = 7;</code>
   */
  @java.lang.Override
  public com.google.storage.control.v2.IntelligenceConfig.TrialConfigOrBuilder
      getTrialConfigOrBuilder() {
    return trialConfig_ == null
        ? com.google.storage.control.v2.IntelligenceConfig.TrialConfig.getDefaultInstance()
        : trialConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (editionConfig_
        != com.google.storage.control.v2.IntelligenceConfig.EditionConfig.EDITION_CONFIG_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, editionConfig_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getUpdateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getFilter());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(5, getEffectiveIntelligenceConfig());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(7, getTrialConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (editionConfig_
        != com.google.storage.control.v2.IntelligenceConfig.EditionConfig.EDITION_CONFIG_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, editionConfig_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getUpdateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getFilter());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, getEffectiveIntelligenceConfig());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getTrialConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.storage.control.v2.IntelligenceConfig)) {
      return super.equals(obj);
    }
    com.google.storage.control.v2.IntelligenceConfig other =
        (com.google.storage.control.v2.IntelligenceConfig) obj;

    if (!getName().equals(other.getName())) return false;
    if (editionConfig_ != other.editionConfig_) return false;
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (hasFilter() != other.hasFilter()) return false;
    if (hasFilter()) {
      if (!getFilter().equals(other.getFilter())) return false;
    }
    if (hasEffectiveIntelligenceConfig() != other.hasEffectiveIntelligenceConfig()) return false;
    if (hasEffectiveIntelligenceConfig()) {
      if (!getEffectiveIntelligenceConfig().equals(other.getEffectiveIntelligenceConfig()))
        return false;
    }
    if (hasTrialConfig() != other.hasTrialConfig()) return false;
    if (hasTrialConfig()) {
      if (!getTrialConfig().equals(other.getTrialConfig())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + EDITION_CONFIG_FIELD_NUMBER;
    hash = (53 * hash) + editionConfig_;
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (hasFilter()) {
      hash = (37 * hash) + FILTER_FIELD_NUMBER;
      hash = (53 * hash) + getFilter().hashCode();
    }
    if (hasEffectiveIntelligenceConfig()) {
      hash = (37 * hash) + EFFECTIVE_INTELLIGENCE_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getEffectiveIntelligenceConfig().hashCode();
    }
    if (hasTrialConfig()) {
      hash = (37 * hash) + TRIAL_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getTrialConfig().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.storage.control.v2.IntelligenceConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.control.v2.IntelligenceConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.control.v2.IntelligenceConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.control.v2.IntelligenceConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.control.v2.IntelligenceConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.control.v2.IntelligenceConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.control.v2.IntelligenceConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.storage.control.v2.IntelligenceConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.storage.control.v2.IntelligenceConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.storage.control.v2.IntelligenceConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.storage.control.v2.IntelligenceConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.storage.control.v2.IntelligenceConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.storage.control.v2.IntelligenceConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * The `IntelligenceConfig` resource associated with your organization, folder,
   * or project.
   * </pre>
   *
   * Protobuf type {@code google.storage.control.v2.IntelligenceConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.storage.control.v2.IntelligenceConfig)
      com.google.storage.control.v2.IntelligenceConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.control.v2.StorageControlProto
          .internal_static_google_storage_control_v2_IntelligenceConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.control.v2.StorageControlProto
          .internal_static_google_storage_control_v2_IntelligenceConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.control.v2.IntelligenceConfig.class,
              com.google.storage.control.v2.IntelligenceConfig.Builder.class);
    }

    // Construct using com.google.storage.control.v2.IntelligenceConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getUpdateTimeFieldBuilder();
        getFilterFieldBuilder();
        getEffectiveIntelligenceConfigFieldBuilder();
        getTrialConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      editionConfig_ = 0;
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      filter_ = null;
      if (filterBuilder_ != null) {
        filterBuilder_.dispose();
        filterBuilder_ = null;
      }
      effectiveIntelligenceConfig_ = null;
      if (effectiveIntelligenceConfigBuilder_ != null) {
        effectiveIntelligenceConfigBuilder_.dispose();
        effectiveIntelligenceConfigBuilder_ = null;
      }
      trialConfig_ = null;
      if (trialConfigBuilder_ != null) {
        trialConfigBuilder_.dispose();
        trialConfigBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.storage.control.v2.StorageControlProto
          .internal_static_google_storage_control_v2_IntelligenceConfig_descriptor;
    }

    @java.lang.Override
    public com.google.storage.control.v2.IntelligenceConfig getDefaultInstanceForType() {
      return com.google.storage.control.v2.IntelligenceConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.storage.control.v2.IntelligenceConfig build() {
      com.google.storage.control.v2.IntelligenceConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.storage.control.v2.IntelligenceConfig buildPartial() {
      com.google.storage.control.v2.IntelligenceConfig result =
          new com.google.storage.control.v2.IntelligenceConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.storage.control.v2.IntelligenceConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.editionConfig_ = editionConfig_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.filter_ = filterBuilder_ == null ? filter_ : filterBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.effectiveIntelligenceConfig_ =
            effectiveIntelligenceConfigBuilder_ == null
                ? effectiveIntelligenceConfig_
                : effectiveIntelligenceConfigBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.trialConfig_ =
            trialConfigBuilder_ == null ? trialConfig_ : trialConfigBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.storage.control.v2.IntelligenceConfig) {
        return mergeFrom((com.google.storage.control.v2.IntelligenceConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.storage.control.v2.IntelligenceConfig other) {
      if (other == com.google.storage.control.v2.IntelligenceConfig.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.editionConfig_ != 0) {
        setEditionConfigValue(other.getEditionConfigValue());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.hasFilter()) {
        mergeFilter(other.getFilter());
      }
      if (other.hasEffectiveIntelligenceConfig()) {
        mergeEffectiveIntelligenceConfig(other.getEffectiveIntelligenceConfig());
      }
      if (other.hasTrialConfig()) {
        mergeTrialConfig(other.getTrialConfig());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                editionConfig_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getFilterFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    getEffectiveIntelligenceConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 58:
              {
                input.readMessage(getTrialConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Identifier. The name of the `IntelligenceConfig` resource associated with
     * your organization, folder, or project.
     *
     * The name format varies based on the GCP resource hierarchy as follows:
     *
     * * For project:
     * `projects/{project_number}/locations/global/intelligenceConfig`
     * * For organization:
     * `organizations/{org_id}/locations/global/intelligenceConfig`
     * * For folder: `folders/{folder_id}/locations/global/intelligenceConfig`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Identifier. The name of the `IntelligenceConfig` resource associated with
     * your organization, folder, or project.
     *
     * The name format varies based on the GCP resource hierarchy as follows:
     *
     * * For project:
     * `projects/{project_number}/locations/global/intelligenceConfig`
     * * For organization:
     * `organizations/{org_id}/locations/global/intelligenceConfig`
     * * For folder: `folders/{folder_id}/locations/global/intelligenceConfig`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Identifier. The name of the `IntelligenceConfig` resource associated with
     * your organization, folder, or project.
     *
     * The name format varies based on the GCP resource hierarchy as follows:
     *
     * * For project:
     * `projects/{project_number}/locations/global/intelligenceConfig`
     * * For organization:
     * `organizations/{org_id}/locations/global/intelligenceConfig`
     * * For folder: `folders/{folder_id}/locations/global/intelligenceConfig`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Identifier. The name of the `IntelligenceConfig` resource associated with
     * your organization, folder, or project.
     *
     * The name format varies based on the GCP resource hierarchy as follows:
     *
     * * For project:
     * `projects/{project_number}/locations/global/intelligenceConfig`
     * * For organization:
     * `organizations/{org_id}/locations/global/intelligenceConfig`
     * * For folder: `folders/{folder_id}/locations/global/intelligenceConfig`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Identifier. The name of the `IntelligenceConfig` resource associated with
     * your organization, folder, or project.
     *
     * The name format varies based on the GCP resource hierarchy as follows:
     *
     * * For project:
     * `projects/{project_number}/locations/global/intelligenceConfig`
     * * For organization:
     * `organizations/{org_id}/locations/global/intelligenceConfig`
     * * For folder: `folders/{folder_id}/locations/global/intelligenceConfig`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int editionConfig_ = 0;

    /**
     *
     *
     * <pre>
     * Optional. The edition configuration of the `IntelligenceConfig` resource.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.IntelligenceConfig.EditionConfig edition_config = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for editionConfig.
     */
    @java.lang.Override
    public int getEditionConfigValue() {
      return editionConfig_;
    }

    /**
     *
     *
     * <pre>
     * Optional. The edition configuration of the `IntelligenceConfig` resource.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.IntelligenceConfig.EditionConfig edition_config = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for editionConfig to set.
     * @return This builder for chaining.
     */
    public Builder setEditionConfigValue(int value) {
      editionConfig_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The edition configuration of the `IntelligenceConfig` resource.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.IntelligenceConfig.EditionConfig edition_config = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The editionConfig.
     */
    @java.lang.Override
    public com.google.storage.control.v2.IntelligenceConfig.EditionConfig getEditionConfig() {
      com.google.storage.control.v2.IntelligenceConfig.EditionConfig result =
          com.google.storage.control.v2.IntelligenceConfig.EditionConfig.forNumber(editionConfig_);
      return result == null
          ? com.google.storage.control.v2.IntelligenceConfig.EditionConfig.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * Optional. The edition configuration of the `IntelligenceConfig` resource.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.IntelligenceConfig.EditionConfig edition_config = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The editionConfig to set.
     * @return This builder for chaining.
     */
    public Builder setEditionConfig(
        com.google.storage.control.v2.IntelligenceConfig.EditionConfig value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      editionConfig_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The edition configuration of the `IntelligenceConfig` resource.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.IntelligenceConfig.EditionConfig edition_config = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEditionConfig() {
      bitField0_ = (bitField0_ & ~0x00000002);
      editionConfig_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The time at which the `IntelligenceConfig` resource is last
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. The time at which the `IntelligenceConfig` resource is last
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The time at which the `IntelligenceConfig` resource is last
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The time at which the `IntelligenceConfig` resource is last
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The time at which the `IntelligenceConfig` resource is last
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The time at which the `IntelligenceConfig` resource is last
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The time at which the `IntelligenceConfig` resource is last
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. The time at which the `IntelligenceConfig` resource is last
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The time at which the `IntelligenceConfig` resource is last
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.storage.control.v2.IntelligenceConfig.Filter filter_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.control.v2.IntelligenceConfig.Filter,
            com.google.storage.control.v2.IntelligenceConfig.Filter.Builder,
            com.google.storage.control.v2.IntelligenceConfig.FilterOrBuilder>
        filterBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Filter over location and bucket.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.IntelligenceConfig.Filter filter = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the filter field is set.
     */
    public boolean hasFilter() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Filter over location and bucket.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.IntelligenceConfig.Filter filter = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The filter.
     */
    public com.google.storage.control.v2.IntelligenceConfig.Filter getFilter() {
      if (filterBuilder_ == null) {
        return filter_ == null
            ? com.google.storage.control.v2.IntelligenceConfig.Filter.getDefaultInstance()
            : filter_;
      } else {
        return filterBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Filter over location and bucket.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.IntelligenceConfig.Filter filter = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setFilter(com.google.storage.control.v2.IntelligenceConfig.Filter value) {
      if (filterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        filter_ = value;
      } else {
        filterBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Filter over location and bucket.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.IntelligenceConfig.Filter filter = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setFilter(
        com.google.storage.control.v2.IntelligenceConfig.Filter.Builder builderForValue) {
      if (filterBuilder_ == null) {
        filter_ = builderForValue.build();
      } else {
        filterBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Filter over location and bucket.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.IntelligenceConfig.Filter filter = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeFilter(com.google.storage.control.v2.IntelligenceConfig.Filter value) {
      if (filterBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && filter_ != null
            && filter_
                != com.google.storage.control.v2.IntelligenceConfig.Filter.getDefaultInstance()) {
          getFilterBuilder().mergeFrom(value);
        } else {
          filter_ = value;
        }
      } else {
        filterBuilder_.mergeFrom(value);
      }
      if (filter_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Filter over location and bucket.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.IntelligenceConfig.Filter filter = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearFilter() {
      bitField0_ = (bitField0_ & ~0x00000008);
      filter_ = null;
      if (filterBuilder_ != null) {
        filterBuilder_.dispose();
        filterBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Filter over location and bucket.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.IntelligenceConfig.Filter filter = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.storage.control.v2.IntelligenceConfig.Filter.Builder getFilterBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getFilterFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Filter over location and bucket.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.IntelligenceConfig.Filter filter = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.storage.control.v2.IntelligenceConfig.FilterOrBuilder getFilterOrBuilder() {
      if (filterBuilder_ != null) {
        return filterBuilder_.getMessageOrBuilder();
      } else {
        return filter_ == null
            ? com.google.storage.control.v2.IntelligenceConfig.Filter.getDefaultInstance()
            : filter_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Filter over location and bucket.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.IntelligenceConfig.Filter filter = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.control.v2.IntelligenceConfig.Filter,
            com.google.storage.control.v2.IntelligenceConfig.Filter.Builder,
            com.google.storage.control.v2.IntelligenceConfig.FilterOrBuilder>
        getFilterFieldBuilder() {
      if (filterBuilder_ == null) {
        filterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.control.v2.IntelligenceConfig.Filter,
                com.google.storage.control.v2.IntelligenceConfig.Filter.Builder,
                com.google.storage.control.v2.IntelligenceConfig.FilterOrBuilder>(
                getFilter(), getParentForChildren(), isClean());
        filter_ = null;
      }
      return filterBuilder_;
    }

    private com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig
        effectiveIntelligenceConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig,
            com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig.Builder,
            com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfigOrBuilder>
        effectiveIntelligenceConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The `IntelligenceConfig` resource that is applicable for the
     * resource.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig effective_intelligence_config = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the effectiveIntelligenceConfig field is set.
     */
    public boolean hasEffectiveIntelligenceConfig() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. The `IntelligenceConfig` resource that is applicable for the
     * resource.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig effective_intelligence_config = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The effectiveIntelligenceConfig.
     */
    public com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig
        getEffectiveIntelligenceConfig() {
      if (effectiveIntelligenceConfigBuilder_ == null) {
        return effectiveIntelligenceConfig_ == null
            ? com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig
                .getDefaultInstance()
            : effectiveIntelligenceConfig_;
      } else {
        return effectiveIntelligenceConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The `IntelligenceConfig` resource that is applicable for the
     * resource.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig effective_intelligence_config = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEffectiveIntelligenceConfig(
        com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig value) {
      if (effectiveIntelligenceConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        effectiveIntelligenceConfig_ = value;
      } else {
        effectiveIntelligenceConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The `IntelligenceConfig` resource that is applicable for the
     * resource.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig effective_intelligence_config = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEffectiveIntelligenceConfig(
        com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig.Builder
            builderForValue) {
      if (effectiveIntelligenceConfigBuilder_ == null) {
        effectiveIntelligenceConfig_ = builderForValue.build();
      } else {
        effectiveIntelligenceConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The `IntelligenceConfig` resource that is applicable for the
     * resource.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig effective_intelligence_config = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeEffectiveIntelligenceConfig(
        com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig value) {
      if (effectiveIntelligenceConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && effectiveIntelligenceConfig_ != null
            && effectiveIntelligenceConfig_
                != com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig
                    .getDefaultInstance()) {
          getEffectiveIntelligenceConfigBuilder().mergeFrom(value);
        } else {
          effectiveIntelligenceConfig_ = value;
        }
      } else {
        effectiveIntelligenceConfigBuilder_.mergeFrom(value);
      }
      if (effectiveIntelligenceConfig_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The `IntelligenceConfig` resource that is applicable for the
     * resource.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig effective_intelligence_config = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearEffectiveIntelligenceConfig() {
      bitField0_ = (bitField0_ & ~0x00000010);
      effectiveIntelligenceConfig_ = null;
      if (effectiveIntelligenceConfigBuilder_ != null) {
        effectiveIntelligenceConfigBuilder_.dispose();
        effectiveIntelligenceConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The `IntelligenceConfig` resource that is applicable for the
     * resource.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig effective_intelligence_config = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig.Builder
        getEffectiveIntelligenceConfigBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getEffectiveIntelligenceConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. The `IntelligenceConfig` resource that is applicable for the
     * resource.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig effective_intelligence_config = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfigOrBuilder
        getEffectiveIntelligenceConfigOrBuilder() {
      if (effectiveIntelligenceConfigBuilder_ != null) {
        return effectiveIntelligenceConfigBuilder_.getMessageOrBuilder();
      } else {
        return effectiveIntelligenceConfig_ == null
            ? com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig
                .getDefaultInstance()
            : effectiveIntelligenceConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The `IntelligenceConfig` resource that is applicable for the
     * resource.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig effective_intelligence_config = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig,
            com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig.Builder,
            com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfigOrBuilder>
        getEffectiveIntelligenceConfigFieldBuilder() {
      if (effectiveIntelligenceConfigBuilder_ == null) {
        effectiveIntelligenceConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig,
                com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig
                    .Builder,
                com.google.storage.control.v2.IntelligenceConfig
                    .EffectiveIntelligenceConfigOrBuilder>(
                getEffectiveIntelligenceConfig(), getParentForChildren(), isClean());
        effectiveIntelligenceConfig_ = null;
      }
      return effectiveIntelligenceConfigBuilder_;
    }

    private com.google.storage.control.v2.IntelligenceConfig.TrialConfig trialConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.control.v2.IntelligenceConfig.TrialConfig,
            com.google.storage.control.v2.IntelligenceConfig.TrialConfig.Builder,
            com.google.storage.control.v2.IntelligenceConfig.TrialConfigOrBuilder>
        trialConfigBuilder_;

    /**
     *
     *
     * <pre>
     * The trial configuration of the `IntelligenceConfig` resource.
     * </pre>
     *
     * <code>.google.storage.control.v2.IntelligenceConfig.TrialConfig trial_config = 7;</code>
     *
     * @return Whether the trialConfig field is set.
     */
    public boolean hasTrialConfig() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * The trial configuration of the `IntelligenceConfig` resource.
     * </pre>
     *
     * <code>.google.storage.control.v2.IntelligenceConfig.TrialConfig trial_config = 7;</code>
     *
     * @return The trialConfig.
     */
    public com.google.storage.control.v2.IntelligenceConfig.TrialConfig getTrialConfig() {
      if (trialConfigBuilder_ == null) {
        return trialConfig_ == null
            ? com.google.storage.control.v2.IntelligenceConfig.TrialConfig.getDefaultInstance()
            : trialConfig_;
      } else {
        return trialConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The trial configuration of the `IntelligenceConfig` resource.
     * </pre>
     *
     * <code>.google.storage.control.v2.IntelligenceConfig.TrialConfig trial_config = 7;</code>
     */
    public Builder setTrialConfig(
        com.google.storage.control.v2.IntelligenceConfig.TrialConfig value) {
      if (trialConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        trialConfig_ = value;
      } else {
        trialConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The trial configuration of the `IntelligenceConfig` resource.
     * </pre>
     *
     * <code>.google.storage.control.v2.IntelligenceConfig.TrialConfig trial_config = 7;</code>
     */
    public Builder setTrialConfig(
        com.google.storage.control.v2.IntelligenceConfig.TrialConfig.Builder builderForValue) {
      if (trialConfigBuilder_ == null) {
        trialConfig_ = builderForValue.build();
      } else {
        trialConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The trial configuration of the `IntelligenceConfig` resource.
     * </pre>
     *
     * <code>.google.storage.control.v2.IntelligenceConfig.TrialConfig trial_config = 7;</code>
     */
    public Builder mergeTrialConfig(
        com.google.storage.control.v2.IntelligenceConfig.TrialConfig value) {
      if (trialConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && trialConfig_ != null
            && trialConfig_
                != com.google.storage.control.v2.IntelligenceConfig.TrialConfig
                    .getDefaultInstance()) {
          getTrialConfigBuilder().mergeFrom(value);
        } else {
          trialConfig_ = value;
        }
      } else {
        trialConfigBuilder_.mergeFrom(value);
      }
      if (trialConfig_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The trial configuration of the `IntelligenceConfig` resource.
     * </pre>
     *
     * <code>.google.storage.control.v2.IntelligenceConfig.TrialConfig trial_config = 7;</code>
     */
    public Builder clearTrialConfig() {
      bitField0_ = (bitField0_ & ~0x00000020);
      trialConfig_ = null;
      if (trialConfigBuilder_ != null) {
        trialConfigBuilder_.dispose();
        trialConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The trial configuration of the `IntelligenceConfig` resource.
     * </pre>
     *
     * <code>.google.storage.control.v2.IntelligenceConfig.TrialConfig trial_config = 7;</code>
     */
    public com.google.storage.control.v2.IntelligenceConfig.TrialConfig.Builder
        getTrialConfigBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getTrialConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The trial configuration of the `IntelligenceConfig` resource.
     * </pre>
     *
     * <code>.google.storage.control.v2.IntelligenceConfig.TrialConfig trial_config = 7;</code>
     */
    public com.google.storage.control.v2.IntelligenceConfig.TrialConfigOrBuilder
        getTrialConfigOrBuilder() {
      if (trialConfigBuilder_ != null) {
        return trialConfigBuilder_.getMessageOrBuilder();
      } else {
        return trialConfig_ == null
            ? com.google.storage.control.v2.IntelligenceConfig.TrialConfig.getDefaultInstance()
            : trialConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * The trial configuration of the `IntelligenceConfig` resource.
     * </pre>
     *
     * <code>.google.storage.control.v2.IntelligenceConfig.TrialConfig trial_config = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.control.v2.IntelligenceConfig.TrialConfig,
            com.google.storage.control.v2.IntelligenceConfig.TrialConfig.Builder,
            com.google.storage.control.v2.IntelligenceConfig.TrialConfigOrBuilder>
        getTrialConfigFieldBuilder() {
      if (trialConfigBuilder_ == null) {
        trialConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.control.v2.IntelligenceConfig.TrialConfig,
                com.google.storage.control.v2.IntelligenceConfig.TrialConfig.Builder,
                com.google.storage.control.v2.IntelligenceConfig.TrialConfigOrBuilder>(
                getTrialConfig(), getParentForChildren(), isClean());
        trialConfig_ = null;
      }
      return trialConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.storage.control.v2.IntelligenceConfig)
  }

  // @@protoc_insertion_point(class_scope:google.storage.control.v2.IntelligenceConfig)
  private static final com.google.storage.control.v2.IntelligenceConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.storage.control.v2.IntelligenceConfig();
  }

  public static com.google.storage.control.v2.IntelligenceConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<IntelligenceConfig> PARSER =
      new com.google.protobuf.AbstractParser<IntelligenceConfig>() {
        @java.lang.Override
        public IntelligenceConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<IntelligenceConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<IntelligenceConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.storage.control.v2.IntelligenceConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
