/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/storage/control/v2/storage_control.proto

// Protobuf Java Version: 3.25.8
package com.google.storage.control.v2;

/**
 *
 *
 * <pre>
 * Request message for CreateFolder. This operation is only applicable to a
 * hierarchical namespace enabled bucket.
 * </pre>
 *
 * Protobuf type {@code google.storage.control.v2.CreateFolderRequest}
 */
public final class CreateFolderRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.storage.control.v2.CreateFolderRequest)
    CreateFolderRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use CreateFolderRequest.newBuilder() to construct.
  private CreateFolderRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CreateFolderRequest() {
    parent_ = "";
    folderId_ = "";
    requestId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CreateFolderRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.storage.control.v2.StorageControlProto
        .internal_static_google_storage_control_v2_CreateFolderRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.storage.control.v2.StorageControlProto
        .internal_static_google_storage_control_v2_CreateFolderRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.storage.control.v2.CreateFolderRequest.class,
            com.google.storage.control.v2.CreateFolderRequest.Builder.class);
  }

  private int bitField0_;
  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";

  /**
   *
   *
   * <pre>
   * Required. Name of the bucket in which the folder will reside. The bucket
   * must be a hierarchical namespace enabled bucket.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. Name of the bucket in which the folder will reside. The bucket
   * must be a hierarchical namespace enabled bucket.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FOLDER_FIELD_NUMBER = 2;
  private com.google.storage.control.v2.Folder folder_;

  /**
   *
   *
   * <pre>
   * Required. Properties of the new folder being created.
   * The bucket and name of the folder are specified in the parent and folder_id
   * fields, respectively. Populating those fields in `folder` will result in an
   * error.
   * </pre>
   *
   * <code>.google.storage.control.v2.Folder folder = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the folder field is set.
   */
  @java.lang.Override
  public boolean hasFolder() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Required. Properties of the new folder being created.
   * The bucket and name of the folder are specified in the parent and folder_id
   * fields, respectively. Populating those fields in `folder` will result in an
   * error.
   * </pre>
   *
   * <code>.google.storage.control.v2.Folder folder = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The folder.
   */
  @java.lang.Override
  public com.google.storage.control.v2.Folder getFolder() {
    return folder_ == null ? com.google.storage.control.v2.Folder.getDefaultInstance() : folder_;
  }

  /**
   *
   *
   * <pre>
   * Required. Properties of the new folder being created.
   * The bucket and name of the folder are specified in the parent and folder_id
   * fields, respectively. Populating those fields in `folder` will result in an
   * error.
   * </pre>
   *
   * <code>.google.storage.control.v2.Folder folder = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.storage.control.v2.FolderOrBuilder getFolderOrBuilder() {
    return folder_ == null ? com.google.storage.control.v2.Folder.getDefaultInstance() : folder_;
  }

  public static final int FOLDER_ID_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object folderId_ = "";

  /**
   *
   *
   * <pre>
   * Required. The full name of a folder, including all its parent folders.
   * Folders use single '/' characters as a delimiter.
   * The folder_id must end with a slash.
   * For example, the folder_id of "books/biographies/" would create a new
   * "biographies/" folder under the "books/" folder.
   * </pre>
   *
   * <code>string folder_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The folderId.
   */
  @java.lang.Override
  public java.lang.String getFolderId() {
    java.lang.Object ref = folderId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      folderId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The full name of a folder, including all its parent folders.
   * Folders use single '/' characters as a delimiter.
   * The folder_id must end with a slash.
   * For example, the folder_id of "books/biographies/" would create a new
   * "biographies/" folder under the "books/" folder.
   * </pre>
   *
   * <code>string folder_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for folderId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFolderIdBytes() {
    java.lang.Object ref = folderId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      folderId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RECURSIVE_FIELD_NUMBER = 4;
  private boolean recursive_ = false;

  /**
   *
   *
   * <pre>
   * Optional. If true, parent folder doesn't have to be present and all missing
   * ancestor folders will be created atomically.
   * </pre>
   *
   * <code>bool recursive = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The recursive.
   */
  @java.lang.Override
  public boolean getRecursive() {
    return recursive_;
  }

  public static final int REQUEST_ID_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object requestId_ = "";

  /**
   *
   *
   * <pre>
   * Optional. A unique identifier for this request. UUID is the recommended
   * format, but other formats are still accepted.
   * </pre>
   *
   * <code>
   * string request_id = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_info) = { ... }
   * </code>
   *
   * @return The requestId.
   */
  @java.lang.Override
  public java.lang.String getRequestId() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      requestId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. A unique identifier for this request. UUID is the recommended
   * format, but other formats are still accepted.
   * </pre>
   *
   * <code>
   * string request_id = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_info) = { ... }
   * </code>
   *
   * @return The bytes for requestId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRequestIdBytes() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      requestId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getFolder());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(folderId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, folderId_);
    }
    if (recursive_ != false) {
      output.writeBool(4, recursive_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, requestId_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getFolder());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(folderId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, folderId_);
    }
    if (recursive_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, recursive_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, requestId_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.storage.control.v2.CreateFolderRequest)) {
      return super.equals(obj);
    }
    com.google.storage.control.v2.CreateFolderRequest other =
        (com.google.storage.control.v2.CreateFolderRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (hasFolder() != other.hasFolder()) return false;
    if (hasFolder()) {
      if (!getFolder().equals(other.getFolder())) return false;
    }
    if (!getFolderId().equals(other.getFolderId())) return false;
    if (getRecursive() != other.getRecursive()) return false;
    if (!getRequestId().equals(other.getRequestId())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    if (hasFolder()) {
      hash = (37 * hash) + FOLDER_FIELD_NUMBER;
      hash = (53 * hash) + getFolder().hashCode();
    }
    hash = (37 * hash) + FOLDER_ID_FIELD_NUMBER;
    hash = (53 * hash) + getFolderId().hashCode();
    hash = (37 * hash) + RECURSIVE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getRecursive());
    hash = (37 * hash) + REQUEST_ID_FIELD_NUMBER;
    hash = (53 * hash) + getRequestId().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.storage.control.v2.CreateFolderRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.control.v2.CreateFolderRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.control.v2.CreateFolderRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.control.v2.CreateFolderRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.control.v2.CreateFolderRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.control.v2.CreateFolderRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.control.v2.CreateFolderRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.storage.control.v2.CreateFolderRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.storage.control.v2.CreateFolderRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.storage.control.v2.CreateFolderRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.storage.control.v2.CreateFolderRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.storage.control.v2.CreateFolderRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.storage.control.v2.CreateFolderRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Request message for CreateFolder. This operation is only applicable to a
   * hierarchical namespace enabled bucket.
   * </pre>
   *
   * Protobuf type {@code google.storage.control.v2.CreateFolderRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.storage.control.v2.CreateFolderRequest)
      com.google.storage.control.v2.CreateFolderRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.control.v2.StorageControlProto
          .internal_static_google_storage_control_v2_CreateFolderRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.control.v2.StorageControlProto
          .internal_static_google_storage_control_v2_CreateFolderRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.control.v2.CreateFolderRequest.class,
              com.google.storage.control.v2.CreateFolderRequest.Builder.class);
    }

    // Construct using com.google.storage.control.v2.CreateFolderRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getFolderFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      folder_ = null;
      if (folderBuilder_ != null) {
        folderBuilder_.dispose();
        folderBuilder_ = null;
      }
      folderId_ = "";
      recursive_ = false;
      requestId_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.storage.control.v2.StorageControlProto
          .internal_static_google_storage_control_v2_CreateFolderRequest_descriptor;
    }

    @java.lang.Override
    public com.google.storage.control.v2.CreateFolderRequest getDefaultInstanceForType() {
      return com.google.storage.control.v2.CreateFolderRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.storage.control.v2.CreateFolderRequest build() {
      com.google.storage.control.v2.CreateFolderRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.storage.control.v2.CreateFolderRequest buildPartial() {
      com.google.storage.control.v2.CreateFolderRequest result =
          new com.google.storage.control.v2.CreateFolderRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.storage.control.v2.CreateFolderRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.folder_ = folderBuilder_ == null ? folder_ : folderBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.folderId_ = folderId_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.recursive_ = recursive_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.requestId_ = requestId_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.storage.control.v2.CreateFolderRequest) {
        return mergeFrom((com.google.storage.control.v2.CreateFolderRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.storage.control.v2.CreateFolderRequest other) {
      if (other == com.google.storage.control.v2.CreateFolderRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasFolder()) {
        mergeFolder(other.getFolder());
      }
      if (!other.getFolderId().isEmpty()) {
        folderId_ = other.folderId_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.getRecursive() != false) {
        setRecursive(other.getRecursive());
      }
      if (!other.getRequestId().isEmpty()) {
        requestId_ = other.requestId_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getFolderFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                folderId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                recursive_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 42:
              {
                requestId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";

    /**
     *
     *
     * <pre>
     * Required. Name of the bucket in which the folder will reside. The bucket
     * must be a hierarchical namespace enabled bucket.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Name of the bucket in which the folder will reside. The bucket
     * must be a hierarchical namespace enabled bucket.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Name of the bucket in which the folder will reside. The bucket
     * must be a hierarchical namespace enabled bucket.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Name of the bucket in which the folder will reside. The bucket
     * must be a hierarchical namespace enabled bucket.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Name of the bucket in which the folder will reside. The bucket
     * must be a hierarchical namespace enabled bucket.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.storage.control.v2.Folder folder_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.control.v2.Folder,
            com.google.storage.control.v2.Folder.Builder,
            com.google.storage.control.v2.FolderOrBuilder>
        folderBuilder_;

    /**
     *
     *
     * <pre>
     * Required. Properties of the new folder being created.
     * The bucket and name of the folder are specified in the parent and folder_id
     * fields, respectively. Populating those fields in `folder` will result in an
     * error.
     * </pre>
     *
     * <code>.google.storage.control.v2.Folder folder = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the folder field is set.
     */
    public boolean hasFolder() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Required. Properties of the new folder being created.
     * The bucket and name of the folder are specified in the parent and folder_id
     * fields, respectively. Populating those fields in `folder` will result in an
     * error.
     * </pre>
     *
     * <code>.google.storage.control.v2.Folder folder = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The folder.
     */
    public com.google.storage.control.v2.Folder getFolder() {
      if (folderBuilder_ == null) {
        return folder_ == null
            ? com.google.storage.control.v2.Folder.getDefaultInstance()
            : folder_;
      } else {
        return folderBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Properties of the new folder being created.
     * The bucket and name of the folder are specified in the parent and folder_id
     * fields, respectively. Populating those fields in `folder` will result in an
     * error.
     * </pre>
     *
     * <code>.google.storage.control.v2.Folder folder = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setFolder(com.google.storage.control.v2.Folder value) {
      if (folderBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        folder_ = value;
      } else {
        folderBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Properties of the new folder being created.
     * The bucket and name of the folder are specified in the parent and folder_id
     * fields, respectively. Populating those fields in `folder` will result in an
     * error.
     * </pre>
     *
     * <code>.google.storage.control.v2.Folder folder = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setFolder(com.google.storage.control.v2.Folder.Builder builderForValue) {
      if (folderBuilder_ == null) {
        folder_ = builderForValue.build();
      } else {
        folderBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Properties of the new folder being created.
     * The bucket and name of the folder are specified in the parent and folder_id
     * fields, respectively. Populating those fields in `folder` will result in an
     * error.
     * </pre>
     *
     * <code>.google.storage.control.v2.Folder folder = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeFolder(com.google.storage.control.v2.Folder value) {
      if (folderBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && folder_ != null
            && folder_ != com.google.storage.control.v2.Folder.getDefaultInstance()) {
          getFolderBuilder().mergeFrom(value);
        } else {
          folder_ = value;
        }
      } else {
        folderBuilder_.mergeFrom(value);
      }
      if (folder_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Properties of the new folder being created.
     * The bucket and name of the folder are specified in the parent and folder_id
     * fields, respectively. Populating those fields in `folder` will result in an
     * error.
     * </pre>
     *
     * <code>.google.storage.control.v2.Folder folder = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearFolder() {
      bitField0_ = (bitField0_ & ~0x00000002);
      folder_ = null;
      if (folderBuilder_ != null) {
        folderBuilder_.dispose();
        folderBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Properties of the new folder being created.
     * The bucket and name of the folder are specified in the parent and folder_id
     * fields, respectively. Populating those fields in `folder` will result in an
     * error.
     * </pre>
     *
     * <code>.google.storage.control.v2.Folder folder = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.storage.control.v2.Folder.Builder getFolderBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getFolderFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Required. Properties of the new folder being created.
     * The bucket and name of the folder are specified in the parent and folder_id
     * fields, respectively. Populating those fields in `folder` will result in an
     * error.
     * </pre>
     *
     * <code>.google.storage.control.v2.Folder folder = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.storage.control.v2.FolderOrBuilder getFolderOrBuilder() {
      if (folderBuilder_ != null) {
        return folderBuilder_.getMessageOrBuilder();
      } else {
        return folder_ == null
            ? com.google.storage.control.v2.Folder.getDefaultInstance()
            : folder_;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Properties of the new folder being created.
     * The bucket and name of the folder are specified in the parent and folder_id
     * fields, respectively. Populating those fields in `folder` will result in an
     * error.
     * </pre>
     *
     * <code>.google.storage.control.v2.Folder folder = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.control.v2.Folder,
            com.google.storage.control.v2.Folder.Builder,
            com.google.storage.control.v2.FolderOrBuilder>
        getFolderFieldBuilder() {
      if (folderBuilder_ == null) {
        folderBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.control.v2.Folder,
                com.google.storage.control.v2.Folder.Builder,
                com.google.storage.control.v2.FolderOrBuilder>(
                getFolder(), getParentForChildren(), isClean());
        folder_ = null;
      }
      return folderBuilder_;
    }

    private java.lang.Object folderId_ = "";

    /**
     *
     *
     * <pre>
     * Required. The full name of a folder, including all its parent folders.
     * Folders use single '/' characters as a delimiter.
     * The folder_id must end with a slash.
     * For example, the folder_id of "books/biographies/" would create a new
     * "biographies/" folder under the "books/" folder.
     * </pre>
     *
     * <code>string folder_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The folderId.
     */
    public java.lang.String getFolderId() {
      java.lang.Object ref = folderId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        folderId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The full name of a folder, including all its parent folders.
     * Folders use single '/' characters as a delimiter.
     * The folder_id must end with a slash.
     * For example, the folder_id of "books/biographies/" would create a new
     * "biographies/" folder under the "books/" folder.
     * </pre>
     *
     * <code>string folder_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for folderId.
     */
    public com.google.protobuf.ByteString getFolderIdBytes() {
      java.lang.Object ref = folderId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        folderId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The full name of a folder, including all its parent folders.
     * Folders use single '/' characters as a delimiter.
     * The folder_id must end with a slash.
     * For example, the folder_id of "books/biographies/" would create a new
     * "biographies/" folder under the "books/" folder.
     * </pre>
     *
     * <code>string folder_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The folderId to set.
     * @return This builder for chaining.
     */
    public Builder setFolderId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      folderId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The full name of a folder, including all its parent folders.
     * Folders use single '/' characters as a delimiter.
     * The folder_id must end with a slash.
     * For example, the folder_id of "books/biographies/" would create a new
     * "biographies/" folder under the "books/" folder.
     * </pre>
     *
     * <code>string folder_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFolderId() {
      folderId_ = getDefaultInstance().getFolderId();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The full name of a folder, including all its parent folders.
     * Folders use single '/' characters as a delimiter.
     * The folder_id must end with a slash.
     * For example, the folder_id of "books/biographies/" would create a new
     * "biographies/" folder under the "books/" folder.
     * </pre>
     *
     * <code>string folder_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for folderId to set.
     * @return This builder for chaining.
     */
    public Builder setFolderIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      folderId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private boolean recursive_;

    /**
     *
     *
     * <pre>
     * Optional. If true, parent folder doesn't have to be present and all missing
     * ancestor folders will be created atomically.
     * </pre>
     *
     * <code>bool recursive = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The recursive.
     */
    @java.lang.Override
    public boolean getRecursive() {
      return recursive_;
    }

    /**
     *
     *
     * <pre>
     * Optional. If true, parent folder doesn't have to be present and all missing
     * ancestor folders will be created atomically.
     * </pre>
     *
     * <code>bool recursive = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The recursive to set.
     * @return This builder for chaining.
     */
    public Builder setRecursive(boolean value) {

      recursive_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If true, parent folder doesn't have to be present and all missing
     * ancestor folders will be created atomically.
     * </pre>
     *
     * <code>bool recursive = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRecursive() {
      bitField0_ = (bitField0_ & ~0x00000008);
      recursive_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object requestId_ = "";

    /**
     *
     *
     * <pre>
     * Optional. A unique identifier for this request. UUID is the recommended
     * format, but other formats are still accepted.
     * </pre>
     *
     * <code>
     * string request_id = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_info) = { ... }
     * </code>
     *
     * @return The requestId.
     */
    public java.lang.String getRequestId() {
      java.lang.Object ref = requestId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        requestId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A unique identifier for this request. UUID is the recommended
     * format, but other formats are still accepted.
     * </pre>
     *
     * <code>
     * string request_id = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_info) = { ... }
     * </code>
     *
     * @return The bytes for requestId.
     */
    public com.google.protobuf.ByteString getRequestIdBytes() {
      java.lang.Object ref = requestId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        requestId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A unique identifier for this request. UUID is the recommended
     * format, but other formats are still accepted.
     * </pre>
     *
     * <code>
     * string request_id = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_info) = { ... }
     * </code>
     *
     * @param value The requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      requestId_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A unique identifier for this request. UUID is the recommended
     * format, but other formats are still accepted.
     * </pre>
     *
     * <code>
     * string request_id = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_info) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequestId() {
      requestId_ = getDefaultInstance().getRequestId();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A unique identifier for this request. UUID is the recommended
     * format, but other formats are still accepted.
     * </pre>
     *
     * <code>
     * string request_id = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_info) = { ... }
     * </code>
     *
     * @param value The bytes for requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      requestId_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.storage.control.v2.CreateFolderRequest)
  }

  // @@protoc_insertion_point(class_scope:google.storage.control.v2.CreateFolderRequest)
  private static final com.google.storage.control.v2.CreateFolderRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.storage.control.v2.CreateFolderRequest();
  }

  public static com.google.storage.control.v2.CreateFolderRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CreateFolderRequest> PARSER =
      new com.google.protobuf.AbstractParser<CreateFolderRequest>() {
        @java.lang.Override
        public CreateFolderRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CreateFolderRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CreateFolderRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.storage.control.v2.CreateFolderRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
