/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/storage/control/v2/storage_control.proto

// Protobuf Java Version: 3.25.8
package com.google.storage.control.v2;

/**
 *
 *
 * <pre>
 * Message returned in the metadata field of the Operation resource for
 * CreateAnywhereCache operations.
 * </pre>
 *
 * Protobuf type {@code google.storage.control.v2.CreateAnywhereCacheMetadata}
 */
public final class CreateAnywhereCacheMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.storage.control.v2.CreateAnywhereCacheMetadata)
    CreateAnywhereCacheMetadataOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use CreateAnywhereCacheMetadata.newBuilder() to construct.
  private CreateAnywhereCacheMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CreateAnywhereCacheMetadata() {
    anywhereCacheId_ = "";
    zone_ = "";
    admissionPolicy_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CreateAnywhereCacheMetadata();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.storage.control.v2.StorageControlProto
        .internal_static_google_storage_control_v2_CreateAnywhereCacheMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.storage.control.v2.StorageControlProto
        .internal_static_google_storage_control_v2_CreateAnywhereCacheMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.storage.control.v2.CreateAnywhereCacheMetadata.class,
            com.google.storage.control.v2.CreateAnywhereCacheMetadata.Builder.class);
  }

  private int bitField0_;
  public static final int COMMON_METADATA_FIELD_NUMBER = 1;
  private com.google.storage.control.v2.CommonLongRunningOperationMetadata commonMetadata_;

  /**
   *
   *
   * <pre>
   * Generic metadata for the long running operation.
   * </pre>
   *
   * <code>.google.storage.control.v2.CommonLongRunningOperationMetadata common_metadata = 1;</code>
   *
   * @return Whether the commonMetadata field is set.
   */
  @java.lang.Override
  public boolean hasCommonMetadata() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Generic metadata for the long running operation.
   * </pre>
   *
   * <code>.google.storage.control.v2.CommonLongRunningOperationMetadata common_metadata = 1;</code>
   *
   * @return The commonMetadata.
   */
  @java.lang.Override
  public com.google.storage.control.v2.CommonLongRunningOperationMetadata getCommonMetadata() {
    return commonMetadata_ == null
        ? com.google.storage.control.v2.CommonLongRunningOperationMetadata.getDefaultInstance()
        : commonMetadata_;
  }

  /**
   *
   *
   * <pre>
   * Generic metadata for the long running operation.
   * </pre>
   *
   * <code>.google.storage.control.v2.CommonLongRunningOperationMetadata common_metadata = 1;</code>
   */
  @java.lang.Override
  public com.google.storage.control.v2.CommonLongRunningOperationMetadataOrBuilder
      getCommonMetadataOrBuilder() {
    return commonMetadata_ == null
        ? com.google.storage.control.v2.CommonLongRunningOperationMetadata.getDefaultInstance()
        : commonMetadata_;
  }

  public static final int ANYWHERE_CACHE_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object anywhereCacheId_ = "";

  /**
   *
   *
   * <pre>
   * Anywhere Cache ID.
   * </pre>
   *
   * <code>optional string anywhere_cache_id = 2;</code>
   *
   * @return Whether the anywhereCacheId field is set.
   */
  @java.lang.Override
  public boolean hasAnywhereCacheId() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Anywhere Cache ID.
   * </pre>
   *
   * <code>optional string anywhere_cache_id = 2;</code>
   *
   * @return The anywhereCacheId.
   */
  @java.lang.Override
  public java.lang.String getAnywhereCacheId() {
    java.lang.Object ref = anywhereCacheId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      anywhereCacheId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Anywhere Cache ID.
   * </pre>
   *
   * <code>optional string anywhere_cache_id = 2;</code>
   *
   * @return The bytes for anywhereCacheId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAnywhereCacheIdBytes() {
    java.lang.Object ref = anywhereCacheId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      anywhereCacheId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ZONE_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object zone_ = "";

  /**
   *
   *
   * <pre>
   * The zone in which the cache instance is running. For example,
   * us-central1-a.
   * </pre>
   *
   * <code>optional string zone = 6;</code>
   *
   * @return Whether the zone field is set.
   */
  @java.lang.Override
  public boolean hasZone() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * The zone in which the cache instance is running. For example,
   * us-central1-a.
   * </pre>
   *
   * <code>optional string zone = 6;</code>
   *
   * @return The zone.
   */
  @java.lang.Override
  public java.lang.String getZone() {
    java.lang.Object ref = zone_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      zone_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The zone in which the cache instance is running. For example,
   * us-central1-a.
   * </pre>
   *
   * <code>optional string zone = 6;</code>
   *
   * @return The bytes for zone.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getZoneBytes() {
    java.lang.Object ref = zone_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      zone_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TTL_FIELD_NUMBER = 3;
  private com.google.protobuf.Duration ttl_;

  /**
   *
   *
   * <pre>
   * Anywhere Cache entry's TTL. A cache-level config that is applied to all new
   * cache entries on admission. Default ttl value (24hrs) is applied if not
   * specified in the create request.
   * </pre>
   *
   * <code>optional .google.protobuf.Duration ttl = 3;</code>
   *
   * @return Whether the ttl field is set.
   */
  @java.lang.Override
  public boolean hasTtl() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Anywhere Cache entry's TTL. A cache-level config that is applied to all new
   * cache entries on admission. Default ttl value (24hrs) is applied if not
   * specified in the create request.
   * </pre>
   *
   * <code>optional .google.protobuf.Duration ttl = 3;</code>
   *
   * @return The ttl.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getTtl() {
    return ttl_ == null ? com.google.protobuf.Duration.getDefaultInstance() : ttl_;
  }

  /**
   *
   *
   * <pre>
   * Anywhere Cache entry's TTL. A cache-level config that is applied to all new
   * cache entries on admission. Default ttl value (24hrs) is applied if not
   * specified in the create request.
   * </pre>
   *
   * <code>optional .google.protobuf.Duration ttl = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getTtlOrBuilder() {
    return ttl_ == null ? com.google.protobuf.Duration.getDefaultInstance() : ttl_;
  }

  public static final int ADMISSION_POLICY_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object admissionPolicy_ = "";

  /**
   *
   *
   * <pre>
   * Anywhere Cache entry Admission Policy in kebab-case (e.g.,
   * "admit-on-first-miss"). Default admission policy (admit-on-first-miss) is
   * applied if not specified in the create request.
   * </pre>
   *
   * <code>optional string admission_policy = 5;</code>
   *
   * @return Whether the admissionPolicy field is set.
   */
  @java.lang.Override
  public boolean hasAdmissionPolicy() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * Anywhere Cache entry Admission Policy in kebab-case (e.g.,
   * "admit-on-first-miss"). Default admission policy (admit-on-first-miss) is
   * applied if not specified in the create request.
   * </pre>
   *
   * <code>optional string admission_policy = 5;</code>
   *
   * @return The admissionPolicy.
   */
  @java.lang.Override
  public java.lang.String getAdmissionPolicy() {
    java.lang.Object ref = admissionPolicy_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      admissionPolicy_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Anywhere Cache entry Admission Policy in kebab-case (e.g.,
   * "admit-on-first-miss"). Default admission policy (admit-on-first-miss) is
   * applied if not specified in the create request.
   * </pre>
   *
   * <code>optional string admission_policy = 5;</code>
   *
   * @return The bytes for admissionPolicy.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAdmissionPolicyBytes() {
    java.lang.Object ref = admissionPolicy_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      admissionPolicy_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getCommonMetadata());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, anywhereCacheId_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(3, getTtl());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, admissionPolicy_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, zone_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getCommonMetadata());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, anywhereCacheId_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getTtl());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, admissionPolicy_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, zone_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.storage.control.v2.CreateAnywhereCacheMetadata)) {
      return super.equals(obj);
    }
    com.google.storage.control.v2.CreateAnywhereCacheMetadata other =
        (com.google.storage.control.v2.CreateAnywhereCacheMetadata) obj;

    if (hasCommonMetadata() != other.hasCommonMetadata()) return false;
    if (hasCommonMetadata()) {
      if (!getCommonMetadata().equals(other.getCommonMetadata())) return false;
    }
    if (hasAnywhereCacheId() != other.hasAnywhereCacheId()) return false;
    if (hasAnywhereCacheId()) {
      if (!getAnywhereCacheId().equals(other.getAnywhereCacheId())) return false;
    }
    if (hasZone() != other.hasZone()) return false;
    if (hasZone()) {
      if (!getZone().equals(other.getZone())) return false;
    }
    if (hasTtl() != other.hasTtl()) return false;
    if (hasTtl()) {
      if (!getTtl().equals(other.getTtl())) return false;
    }
    if (hasAdmissionPolicy() != other.hasAdmissionPolicy()) return false;
    if (hasAdmissionPolicy()) {
      if (!getAdmissionPolicy().equals(other.getAdmissionPolicy())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasCommonMetadata()) {
      hash = (37 * hash) + COMMON_METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getCommonMetadata().hashCode();
    }
    if (hasAnywhereCacheId()) {
      hash = (37 * hash) + ANYWHERE_CACHE_ID_FIELD_NUMBER;
      hash = (53 * hash) + getAnywhereCacheId().hashCode();
    }
    if (hasZone()) {
      hash = (37 * hash) + ZONE_FIELD_NUMBER;
      hash = (53 * hash) + getZone().hashCode();
    }
    if (hasTtl()) {
      hash = (37 * hash) + TTL_FIELD_NUMBER;
      hash = (53 * hash) + getTtl().hashCode();
    }
    if (hasAdmissionPolicy()) {
      hash = (37 * hash) + ADMISSION_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getAdmissionPolicy().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.storage.control.v2.CreateAnywhereCacheMetadata parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.control.v2.CreateAnywhereCacheMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.control.v2.CreateAnywhereCacheMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.control.v2.CreateAnywhereCacheMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.control.v2.CreateAnywhereCacheMetadata parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.control.v2.CreateAnywhereCacheMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.control.v2.CreateAnywhereCacheMetadata parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.storage.control.v2.CreateAnywhereCacheMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.storage.control.v2.CreateAnywhereCacheMetadata parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.storage.control.v2.CreateAnywhereCacheMetadata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.storage.control.v2.CreateAnywhereCacheMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.storage.control.v2.CreateAnywhereCacheMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.storage.control.v2.CreateAnywhereCacheMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Message returned in the metadata field of the Operation resource for
   * CreateAnywhereCache operations.
   * </pre>
   *
   * Protobuf type {@code google.storage.control.v2.CreateAnywhereCacheMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.storage.control.v2.CreateAnywhereCacheMetadata)
      com.google.storage.control.v2.CreateAnywhereCacheMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.control.v2.StorageControlProto
          .internal_static_google_storage_control_v2_CreateAnywhereCacheMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.control.v2.StorageControlProto
          .internal_static_google_storage_control_v2_CreateAnywhereCacheMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.control.v2.CreateAnywhereCacheMetadata.class,
              com.google.storage.control.v2.CreateAnywhereCacheMetadata.Builder.class);
    }

    // Construct using com.google.storage.control.v2.CreateAnywhereCacheMetadata.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCommonMetadataFieldBuilder();
        getTtlFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      commonMetadata_ = null;
      if (commonMetadataBuilder_ != null) {
        commonMetadataBuilder_.dispose();
        commonMetadataBuilder_ = null;
      }
      anywhereCacheId_ = "";
      zone_ = "";
      ttl_ = null;
      if (ttlBuilder_ != null) {
        ttlBuilder_.dispose();
        ttlBuilder_ = null;
      }
      admissionPolicy_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.storage.control.v2.StorageControlProto
          .internal_static_google_storage_control_v2_CreateAnywhereCacheMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.storage.control.v2.CreateAnywhereCacheMetadata getDefaultInstanceForType() {
      return com.google.storage.control.v2.CreateAnywhereCacheMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.storage.control.v2.CreateAnywhereCacheMetadata build() {
      com.google.storage.control.v2.CreateAnywhereCacheMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.storage.control.v2.CreateAnywhereCacheMetadata buildPartial() {
      com.google.storage.control.v2.CreateAnywhereCacheMetadata result =
          new com.google.storage.control.v2.CreateAnywhereCacheMetadata(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.storage.control.v2.CreateAnywhereCacheMetadata result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.commonMetadata_ =
            commonMetadataBuilder_ == null ? commonMetadata_ : commonMetadataBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.anywhereCacheId_ = anywhereCacheId_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.zone_ = zone_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.ttl_ = ttlBuilder_ == null ? ttl_ : ttlBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.admissionPolicy_ = admissionPolicy_;
        to_bitField0_ |= 0x00000010;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.storage.control.v2.CreateAnywhereCacheMetadata) {
        return mergeFrom((com.google.storage.control.v2.CreateAnywhereCacheMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.storage.control.v2.CreateAnywhereCacheMetadata other) {
      if (other == com.google.storage.control.v2.CreateAnywhereCacheMetadata.getDefaultInstance())
        return this;
      if (other.hasCommonMetadata()) {
        mergeCommonMetadata(other.getCommonMetadata());
      }
      if (other.hasAnywhereCacheId()) {
        anywhereCacheId_ = other.anywhereCacheId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasZone()) {
        zone_ = other.zone_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasTtl()) {
        mergeTtl(other.getTtl());
      }
      if (other.hasAdmissionPolicy()) {
        admissionPolicy_ = other.admissionPolicy_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getCommonMetadataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                anywhereCacheId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getTtlFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 26
            case 42:
              {
                admissionPolicy_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                zone_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.storage.control.v2.CommonLongRunningOperationMetadata commonMetadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.control.v2.CommonLongRunningOperationMetadata,
            com.google.storage.control.v2.CommonLongRunningOperationMetadata.Builder,
            com.google.storage.control.v2.CommonLongRunningOperationMetadataOrBuilder>
        commonMetadataBuilder_;

    /**
     *
     *
     * <pre>
     * Generic metadata for the long running operation.
     * </pre>
     *
     * <code>.google.storage.control.v2.CommonLongRunningOperationMetadata common_metadata = 1;
     * </code>
     *
     * @return Whether the commonMetadata field is set.
     */
    public boolean hasCommonMetadata() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Generic metadata for the long running operation.
     * </pre>
     *
     * <code>.google.storage.control.v2.CommonLongRunningOperationMetadata common_metadata = 1;
     * </code>
     *
     * @return The commonMetadata.
     */
    public com.google.storage.control.v2.CommonLongRunningOperationMetadata getCommonMetadata() {
      if (commonMetadataBuilder_ == null) {
        return commonMetadata_ == null
            ? com.google.storage.control.v2.CommonLongRunningOperationMetadata.getDefaultInstance()
            : commonMetadata_;
      } else {
        return commonMetadataBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Generic metadata for the long running operation.
     * </pre>
     *
     * <code>.google.storage.control.v2.CommonLongRunningOperationMetadata common_metadata = 1;
     * </code>
     */
    public Builder setCommonMetadata(
        com.google.storage.control.v2.CommonLongRunningOperationMetadata value) {
      if (commonMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        commonMetadata_ = value;
      } else {
        commonMetadataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Generic metadata for the long running operation.
     * </pre>
     *
     * <code>.google.storage.control.v2.CommonLongRunningOperationMetadata common_metadata = 1;
     * </code>
     */
    public Builder setCommonMetadata(
        com.google.storage.control.v2.CommonLongRunningOperationMetadata.Builder builderForValue) {
      if (commonMetadataBuilder_ == null) {
        commonMetadata_ = builderForValue.build();
      } else {
        commonMetadataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Generic metadata for the long running operation.
     * </pre>
     *
     * <code>.google.storage.control.v2.CommonLongRunningOperationMetadata common_metadata = 1;
     * </code>
     */
    public Builder mergeCommonMetadata(
        com.google.storage.control.v2.CommonLongRunningOperationMetadata value) {
      if (commonMetadataBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && commonMetadata_ != null
            && commonMetadata_
                != com.google.storage.control.v2.CommonLongRunningOperationMetadata
                    .getDefaultInstance()) {
          getCommonMetadataBuilder().mergeFrom(value);
        } else {
          commonMetadata_ = value;
        }
      } else {
        commonMetadataBuilder_.mergeFrom(value);
      }
      if (commonMetadata_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Generic metadata for the long running operation.
     * </pre>
     *
     * <code>.google.storage.control.v2.CommonLongRunningOperationMetadata common_metadata = 1;
     * </code>
     */
    public Builder clearCommonMetadata() {
      bitField0_ = (bitField0_ & ~0x00000001);
      commonMetadata_ = null;
      if (commonMetadataBuilder_ != null) {
        commonMetadataBuilder_.dispose();
        commonMetadataBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Generic metadata for the long running operation.
     * </pre>
     *
     * <code>.google.storage.control.v2.CommonLongRunningOperationMetadata common_metadata = 1;
     * </code>
     */
    public com.google.storage.control.v2.CommonLongRunningOperationMetadata.Builder
        getCommonMetadataBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getCommonMetadataFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Generic metadata for the long running operation.
     * </pre>
     *
     * <code>.google.storage.control.v2.CommonLongRunningOperationMetadata common_metadata = 1;
     * </code>
     */
    public com.google.storage.control.v2.CommonLongRunningOperationMetadataOrBuilder
        getCommonMetadataOrBuilder() {
      if (commonMetadataBuilder_ != null) {
        return commonMetadataBuilder_.getMessageOrBuilder();
      } else {
        return commonMetadata_ == null
            ? com.google.storage.control.v2.CommonLongRunningOperationMetadata.getDefaultInstance()
            : commonMetadata_;
      }
    }

    /**
     *
     *
     * <pre>
     * Generic metadata for the long running operation.
     * </pre>
     *
     * <code>.google.storage.control.v2.CommonLongRunningOperationMetadata common_metadata = 1;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.control.v2.CommonLongRunningOperationMetadata,
            com.google.storage.control.v2.CommonLongRunningOperationMetadata.Builder,
            com.google.storage.control.v2.CommonLongRunningOperationMetadataOrBuilder>
        getCommonMetadataFieldBuilder() {
      if (commonMetadataBuilder_ == null) {
        commonMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.control.v2.CommonLongRunningOperationMetadata,
                com.google.storage.control.v2.CommonLongRunningOperationMetadata.Builder,
                com.google.storage.control.v2.CommonLongRunningOperationMetadataOrBuilder>(
                getCommonMetadata(), getParentForChildren(), isClean());
        commonMetadata_ = null;
      }
      return commonMetadataBuilder_;
    }

    private java.lang.Object anywhereCacheId_ = "";

    /**
     *
     *
     * <pre>
     * Anywhere Cache ID.
     * </pre>
     *
     * <code>optional string anywhere_cache_id = 2;</code>
     *
     * @return Whether the anywhereCacheId field is set.
     */
    public boolean hasAnywhereCacheId() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Anywhere Cache ID.
     * </pre>
     *
     * <code>optional string anywhere_cache_id = 2;</code>
     *
     * @return The anywhereCacheId.
     */
    public java.lang.String getAnywhereCacheId() {
      java.lang.Object ref = anywhereCacheId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        anywhereCacheId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Anywhere Cache ID.
     * </pre>
     *
     * <code>optional string anywhere_cache_id = 2;</code>
     *
     * @return The bytes for anywhereCacheId.
     */
    public com.google.protobuf.ByteString getAnywhereCacheIdBytes() {
      java.lang.Object ref = anywhereCacheId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        anywhereCacheId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Anywhere Cache ID.
     * </pre>
     *
     * <code>optional string anywhere_cache_id = 2;</code>
     *
     * @param value The anywhereCacheId to set.
     * @return This builder for chaining.
     */
    public Builder setAnywhereCacheId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      anywhereCacheId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Anywhere Cache ID.
     * </pre>
     *
     * <code>optional string anywhere_cache_id = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAnywhereCacheId() {
      anywhereCacheId_ = getDefaultInstance().getAnywhereCacheId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Anywhere Cache ID.
     * </pre>
     *
     * <code>optional string anywhere_cache_id = 2;</code>
     *
     * @param value The bytes for anywhereCacheId to set.
     * @return This builder for chaining.
     */
    public Builder setAnywhereCacheIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      anywhereCacheId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object zone_ = "";

    /**
     *
     *
     * <pre>
     * The zone in which the cache instance is running. For example,
     * us-central1-a.
     * </pre>
     *
     * <code>optional string zone = 6;</code>
     *
     * @return Whether the zone field is set.
     */
    public boolean hasZone() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * The zone in which the cache instance is running. For example,
     * us-central1-a.
     * </pre>
     *
     * <code>optional string zone = 6;</code>
     *
     * @return The zone.
     */
    public java.lang.String getZone() {
      java.lang.Object ref = zone_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        zone_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The zone in which the cache instance is running. For example,
     * us-central1-a.
     * </pre>
     *
     * <code>optional string zone = 6;</code>
     *
     * @return The bytes for zone.
     */
    public com.google.protobuf.ByteString getZoneBytes() {
      java.lang.Object ref = zone_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        zone_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The zone in which the cache instance is running. For example,
     * us-central1-a.
     * </pre>
     *
     * <code>optional string zone = 6;</code>
     *
     * @param value The zone to set.
     * @return This builder for chaining.
     */
    public Builder setZone(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      zone_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The zone in which the cache instance is running. For example,
     * us-central1-a.
     * </pre>
     *
     * <code>optional string zone = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearZone() {
      zone_ = getDefaultInstance().getZone();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The zone in which the cache instance is running. For example,
     * us-central1-a.
     * </pre>
     *
     * <code>optional string zone = 6;</code>
     *
     * @param value The bytes for zone to set.
     * @return This builder for chaining.
     */
    public Builder setZoneBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      zone_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.Duration ttl_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        ttlBuilder_;

    /**
     *
     *
     * <pre>
     * Anywhere Cache entry's TTL. A cache-level config that is applied to all new
     * cache entries on admission. Default ttl value (24hrs) is applied if not
     * specified in the create request.
     * </pre>
     *
     * <code>optional .google.protobuf.Duration ttl = 3;</code>
     *
     * @return Whether the ttl field is set.
     */
    public boolean hasTtl() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Anywhere Cache entry's TTL. A cache-level config that is applied to all new
     * cache entries on admission. Default ttl value (24hrs) is applied if not
     * specified in the create request.
     * </pre>
     *
     * <code>optional .google.protobuf.Duration ttl = 3;</code>
     *
     * @return The ttl.
     */
    public com.google.protobuf.Duration getTtl() {
      if (ttlBuilder_ == null) {
        return ttl_ == null ? com.google.protobuf.Duration.getDefaultInstance() : ttl_;
      } else {
        return ttlBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Anywhere Cache entry's TTL. A cache-level config that is applied to all new
     * cache entries on admission. Default ttl value (24hrs) is applied if not
     * specified in the create request.
     * </pre>
     *
     * <code>optional .google.protobuf.Duration ttl = 3;</code>
     */
    public Builder setTtl(com.google.protobuf.Duration value) {
      if (ttlBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ttl_ = value;
      } else {
        ttlBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Anywhere Cache entry's TTL. A cache-level config that is applied to all new
     * cache entries on admission. Default ttl value (24hrs) is applied if not
     * specified in the create request.
     * </pre>
     *
     * <code>optional .google.protobuf.Duration ttl = 3;</code>
     */
    public Builder setTtl(com.google.protobuf.Duration.Builder builderForValue) {
      if (ttlBuilder_ == null) {
        ttl_ = builderForValue.build();
      } else {
        ttlBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Anywhere Cache entry's TTL. A cache-level config that is applied to all new
     * cache entries on admission. Default ttl value (24hrs) is applied if not
     * specified in the create request.
     * </pre>
     *
     * <code>optional .google.protobuf.Duration ttl = 3;</code>
     */
    public Builder mergeTtl(com.google.protobuf.Duration value) {
      if (ttlBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && ttl_ != null
            && ttl_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getTtlBuilder().mergeFrom(value);
        } else {
          ttl_ = value;
        }
      } else {
        ttlBuilder_.mergeFrom(value);
      }
      if (ttl_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Anywhere Cache entry's TTL. A cache-level config that is applied to all new
     * cache entries on admission. Default ttl value (24hrs) is applied if not
     * specified in the create request.
     * </pre>
     *
     * <code>optional .google.protobuf.Duration ttl = 3;</code>
     */
    public Builder clearTtl() {
      bitField0_ = (bitField0_ & ~0x00000008);
      ttl_ = null;
      if (ttlBuilder_ != null) {
        ttlBuilder_.dispose();
        ttlBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Anywhere Cache entry's TTL. A cache-level config that is applied to all new
     * cache entries on admission. Default ttl value (24hrs) is applied if not
     * specified in the create request.
     * </pre>
     *
     * <code>optional .google.protobuf.Duration ttl = 3;</code>
     */
    public com.google.protobuf.Duration.Builder getTtlBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getTtlFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Anywhere Cache entry's TTL. A cache-level config that is applied to all new
     * cache entries on admission. Default ttl value (24hrs) is applied if not
     * specified in the create request.
     * </pre>
     *
     * <code>optional .google.protobuf.Duration ttl = 3;</code>
     */
    public com.google.protobuf.DurationOrBuilder getTtlOrBuilder() {
      if (ttlBuilder_ != null) {
        return ttlBuilder_.getMessageOrBuilder();
      } else {
        return ttl_ == null ? com.google.protobuf.Duration.getDefaultInstance() : ttl_;
      }
    }

    /**
     *
     *
     * <pre>
     * Anywhere Cache entry's TTL. A cache-level config that is applied to all new
     * cache entries on admission. Default ttl value (24hrs) is applied if not
     * specified in the create request.
     * </pre>
     *
     * <code>optional .google.protobuf.Duration ttl = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getTtlFieldBuilder() {
      if (ttlBuilder_ == null) {
        ttlBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(getTtl(), getParentForChildren(), isClean());
        ttl_ = null;
      }
      return ttlBuilder_;
    }

    private java.lang.Object admissionPolicy_ = "";

    /**
     *
     *
     * <pre>
     * Anywhere Cache entry Admission Policy in kebab-case (e.g.,
     * "admit-on-first-miss"). Default admission policy (admit-on-first-miss) is
     * applied if not specified in the create request.
     * </pre>
     *
     * <code>optional string admission_policy = 5;</code>
     *
     * @return Whether the admissionPolicy field is set.
     */
    public boolean hasAdmissionPolicy() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * Anywhere Cache entry Admission Policy in kebab-case (e.g.,
     * "admit-on-first-miss"). Default admission policy (admit-on-first-miss) is
     * applied if not specified in the create request.
     * </pre>
     *
     * <code>optional string admission_policy = 5;</code>
     *
     * @return The admissionPolicy.
     */
    public java.lang.String getAdmissionPolicy() {
      java.lang.Object ref = admissionPolicy_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        admissionPolicy_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Anywhere Cache entry Admission Policy in kebab-case (e.g.,
     * "admit-on-first-miss"). Default admission policy (admit-on-first-miss) is
     * applied if not specified in the create request.
     * </pre>
     *
     * <code>optional string admission_policy = 5;</code>
     *
     * @return The bytes for admissionPolicy.
     */
    public com.google.protobuf.ByteString getAdmissionPolicyBytes() {
      java.lang.Object ref = admissionPolicy_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        admissionPolicy_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Anywhere Cache entry Admission Policy in kebab-case (e.g.,
     * "admit-on-first-miss"). Default admission policy (admit-on-first-miss) is
     * applied if not specified in the create request.
     * </pre>
     *
     * <code>optional string admission_policy = 5;</code>
     *
     * @param value The admissionPolicy to set.
     * @return This builder for chaining.
     */
    public Builder setAdmissionPolicy(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      admissionPolicy_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Anywhere Cache entry Admission Policy in kebab-case (e.g.,
     * "admit-on-first-miss"). Default admission policy (admit-on-first-miss) is
     * applied if not specified in the create request.
     * </pre>
     *
     * <code>optional string admission_policy = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAdmissionPolicy() {
      admissionPolicy_ = getDefaultInstance().getAdmissionPolicy();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Anywhere Cache entry Admission Policy in kebab-case (e.g.,
     * "admit-on-first-miss"). Default admission policy (admit-on-first-miss) is
     * applied if not specified in the create request.
     * </pre>
     *
     * <code>optional string admission_policy = 5;</code>
     *
     * @param value The bytes for admissionPolicy to set.
     * @return This builder for chaining.
     */
    public Builder setAdmissionPolicyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      admissionPolicy_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.storage.control.v2.CreateAnywhereCacheMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.storage.control.v2.CreateAnywhereCacheMetadata)
  private static final com.google.storage.control.v2.CreateAnywhereCacheMetadata DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.storage.control.v2.CreateAnywhereCacheMetadata();
  }

  public static com.google.storage.control.v2.CreateAnywhereCacheMetadata getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CreateAnywhereCacheMetadata> PARSER =
      new com.google.protobuf.AbstractParser<CreateAnywhereCacheMetadata>() {
        @java.lang.Override
        public CreateAnywhereCacheMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CreateAnywhereCacheMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CreateAnywhereCacheMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.storage.control.v2.CreateAnywhereCacheMetadata getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
