/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.speech.v1p1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CustomClassName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CUSTOM_CLASS = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/customClasses/{custom_class}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String customClass;

    @Deprecated
    protected CustomClassName() {
        this.project = null;
        this.location = null;
        this.customClass = null;
    }

    private CustomClassName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.customClass = (String)Preconditions.checkNotNull((Object)builder.getCustomClass());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCustomClass() {
        return this.customClass;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CustomClassName of(String project, String location, String customClass) {
        return CustomClassName.newBuilder().setProject(project).setLocation(location).setCustomClass(customClass).build();
    }

    public static String format(String project, String location, String customClass) {
        return CustomClassName.newBuilder().setProject(project).setLocation(location).setCustomClass(customClass).build().toString();
    }

    public static CustomClassName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_CUSTOM_CLASS.validatedMatch(formattedString, "CustomClassName.parse: formattedString not in valid format");
        return CustomClassName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("custom_class"));
    }

    public static List<CustomClassName> parseList(List<String> formattedStrings) {
        ArrayList<CustomClassName> list = new ArrayList<CustomClassName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CustomClassName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CustomClassName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CustomClassName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CUSTOM_CLASS.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CustomClassName customClassName = this;
            synchronized (customClassName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.customClass != null) {
                        fieldMapBuilder.put((Object)"custom_class", (Object)this.customClass);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_CUSTOM_CLASS.instantiate(new String[]{"project", this.project, "location", this.location, "custom_class", this.customClass});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CustomClassName that = (CustomClassName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.customClass, that.customClass);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.customClass);
    }

    public static class Builder {
        private String project;
        private String location;
        private String customClass;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCustomClass() {
            return this.customClass;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCustomClass(String customClass) {
            this.customClass = customClass;
            return this;
        }

        private Builder(CustomClassName customClassName) {
            this.project = customClassName.project;
            this.location = customClassName.location;
            this.customClass = customClassName.customClass;
        }

        public CustomClassName build() {
            return new CustomClassName(this);
        }
    }
}

