/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/speech/v1/cloud_speech.proto

package com.google.cloud.speech.v1;

/**
 *
 *
 * <pre>
 * Provides information to the recognizer that specifies how to process the
 * request.
 * </pre>
 *
 * Protobuf type {@code google.cloud.speech.v1.RecognitionConfig}
 */
public final class RecognitionConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.speech.v1.RecognitionConfig)
    RecognitionConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RecognitionConfig.newBuilder() to construct.
  private RecognitionConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RecognitionConfig() {
    encoding_ = 0;
    languageCode_ = "";
    speechContexts_ = java.util.Collections.emptyList();
    model_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RecognitionConfig();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private RecognitionConfig(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 8:
            {
              int rawValue = input.readEnum();

              encoding_ = rawValue;
              break;
            }
          case 16:
            {
              sampleRateHertz_ = input.readInt32();
              break;
            }
          case 26:
            {
              java.lang.String s = input.readStringRequireUtf8();

              languageCode_ = s;
              break;
            }
          case 32:
            {
              maxAlternatives_ = input.readInt32();
              break;
            }
          case 40:
            {
              profanityFilter_ = input.readBool();
              break;
            }
          case 50:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                speechContexts_ =
                    new java.util.ArrayList<com.google.cloud.speech.v1.SpeechContext>();
                mutable_bitField0_ |= 0x00000001;
              }
              speechContexts_.add(
                  input.readMessage(
                      com.google.cloud.speech.v1.SpeechContext.parser(), extensionRegistry));
              break;
            }
          case 56:
            {
              audioChannelCount_ = input.readInt32();
              break;
            }
          case 64:
            {
              enableWordTimeOffsets_ = input.readBool();
              break;
            }
          case 74:
            {
              com.google.cloud.speech.v1.RecognitionMetadata.Builder subBuilder = null;
              if (metadata_ != null) {
                subBuilder = metadata_.toBuilder();
              }
              metadata_ =
                  input.readMessage(
                      com.google.cloud.speech.v1.RecognitionMetadata.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(metadata_);
                metadata_ = subBuilder.buildPartial();
              }

              break;
            }
          case 88:
            {
              enableAutomaticPunctuation_ = input.readBool();
              break;
            }
          case 96:
            {
              enableSeparateRecognitionPerChannel_ = input.readBool();
              break;
            }
          case 106:
            {
              java.lang.String s = input.readStringRequireUtf8();

              model_ = s;
              break;
            }
          case 112:
            {
              useEnhanced_ = input.readBool();
              break;
            }
          case 154:
            {
              com.google.cloud.speech.v1.SpeakerDiarizationConfig.Builder subBuilder = null;
              if (diarizationConfig_ != null) {
                subBuilder = diarizationConfig_.toBuilder();
              }
              diarizationConfig_ =
                  input.readMessage(
                      com.google.cloud.speech.v1.SpeakerDiarizationConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(diarizationConfig_);
                diarizationConfig_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        speechContexts_ = java.util.Collections.unmodifiableList(speechContexts_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.speech.v1.SpeechProto
        .internal_static_google_cloud_speech_v1_RecognitionConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.speech.v1.SpeechProto
        .internal_static_google_cloud_speech_v1_RecognitionConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.speech.v1.RecognitionConfig.class,
            com.google.cloud.speech.v1.RecognitionConfig.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The encoding of the audio data sent in the request.
   * All encodings support only 1 channel (mono) audio, unless the
   * `audio_channel_count` and `enable_separate_recognition_per_channel` fields
   * are set.
   * For best results, the audio source should be captured and transmitted using
   * a lossless encoding (`FLAC` or `LINEAR16`). The accuracy of the speech
   * recognition can be reduced if lossy codecs are used to capture or transmit
   * audio, particularly if background noise is present. Lossy codecs include
   * `MULAW`, `AMR`, `AMR_WB`, `OGG_OPUS`, `SPEEX_WITH_HEADER_BYTE`, and `MP3`.
   * The `FLAC` and `WAV` audio file formats include a header that describes the
   * included audio content. You can request recognition for `WAV` files that
   * contain either `LINEAR16` or `MULAW` encoded audio.
   * If you send `FLAC` or `WAV` audio file format in
   * your request, you do not need to specify an `AudioEncoding`; the audio
   * encoding format is determined from the file header. If you specify
   * an `AudioEncoding` when you send  send `FLAC` or `WAV` audio, the
   * encoding configuration must match the encoding described in the audio
   * header; otherwise the request returns an
   * [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT] error code.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.speech.v1.RecognitionConfig.AudioEncoding}
   */
  public enum AudioEncoding implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not specified.
     * </pre>
     *
     * <code>ENCODING_UNSPECIFIED = 0;</code>
     */
    ENCODING_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Uncompressed 16-bit signed little-endian samples (Linear PCM).
     * </pre>
     *
     * <code>LINEAR16 = 1;</code>
     */
    LINEAR16(1),
    /**
     *
     *
     * <pre>
     * `FLAC` (Free Lossless Audio
     * Codec) is the recommended encoding because it is
     * lossless--therefore recognition is not compromised--and
     * requires only about half the bandwidth of `LINEAR16`. `FLAC` stream
     * encoding supports 16-bit and 24-bit samples, however, not all fields in
     * `STREAMINFO` are supported.
     * </pre>
     *
     * <code>FLAC = 2;</code>
     */
    FLAC(2),
    /**
     *
     *
     * <pre>
     * 8-bit samples that compand 14-bit audio samples using G.711 PCMU/mu-law.
     * </pre>
     *
     * <code>MULAW = 3;</code>
     */
    MULAW(3),
    /**
     *
     *
     * <pre>
     * Adaptive Multi-Rate Narrowband codec. `sample_rate_hertz` must be 8000.
     * </pre>
     *
     * <code>AMR = 4;</code>
     */
    AMR(4),
    /**
     *
     *
     * <pre>
     * Adaptive Multi-Rate Wideband codec. `sample_rate_hertz` must be 16000.
     * </pre>
     *
     * <code>AMR_WB = 5;</code>
     */
    AMR_WB(5),
    /**
     *
     *
     * <pre>
     * Opus encoded audio frames in Ogg container
     * ([OggOpus](https://wiki.xiph.org/OggOpus)).
     * `sample_rate_hertz` must be one of 8000, 12000, 16000, 24000, or 48000.
     * </pre>
     *
     * <code>OGG_OPUS = 6;</code>
     */
    OGG_OPUS(6),
    /**
     *
     *
     * <pre>
     * Although the use of lossy encodings is not recommended, if a very low
     * bitrate encoding is required, `OGG_OPUS` is highly preferred over
     * Speex encoding. The [Speex](https://speex.org/)  encoding supported by
     * Cloud Speech API has a header byte in each block, as in MIME type
     * `audio/x-speex-with-header-byte`.
     * It is a variant of the RTP Speex encoding defined in
     * [RFC 5574](https://tools.ietf.org/html/rfc5574).
     * The stream is a sequence of blocks, one block per RTP packet. Each block
     * starts with a byte containing the length of the block, in bytes, followed
     * by one or more frames of Speex data, padded to an integral number of
     * bytes (octets) as specified in RFC 5574. In other words, each RTP header
     * is replaced with a single byte containing the block length. Only Speex
     * wideband is supported. `sample_rate_hertz` must be 16000.
     * </pre>
     *
     * <code>SPEEX_WITH_HEADER_BYTE = 7;</code>
     */
    SPEEX_WITH_HEADER_BYTE(7),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not specified.
     * </pre>
     *
     * <code>ENCODING_UNSPECIFIED = 0;</code>
     */
    public static final int ENCODING_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Uncompressed 16-bit signed little-endian samples (Linear PCM).
     * </pre>
     *
     * <code>LINEAR16 = 1;</code>
     */
    public static final int LINEAR16_VALUE = 1;
    /**
     *
     *
     * <pre>
     * `FLAC` (Free Lossless Audio
     * Codec) is the recommended encoding because it is
     * lossless--therefore recognition is not compromised--and
     * requires only about half the bandwidth of `LINEAR16`. `FLAC` stream
     * encoding supports 16-bit and 24-bit samples, however, not all fields in
     * `STREAMINFO` are supported.
     * </pre>
     *
     * <code>FLAC = 2;</code>
     */
    public static final int FLAC_VALUE = 2;
    /**
     *
     *
     * <pre>
     * 8-bit samples that compand 14-bit audio samples using G.711 PCMU/mu-law.
     * </pre>
     *
     * <code>MULAW = 3;</code>
     */
    public static final int MULAW_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Adaptive Multi-Rate Narrowband codec. `sample_rate_hertz` must be 8000.
     * </pre>
     *
     * <code>AMR = 4;</code>
     */
    public static final int AMR_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Adaptive Multi-Rate Wideband codec. `sample_rate_hertz` must be 16000.
     * </pre>
     *
     * <code>AMR_WB = 5;</code>
     */
    public static final int AMR_WB_VALUE = 5;
    /**
     *
     *
     * <pre>
     * Opus encoded audio frames in Ogg container
     * ([OggOpus](https://wiki.xiph.org/OggOpus)).
     * `sample_rate_hertz` must be one of 8000, 12000, 16000, 24000, or 48000.
     * </pre>
     *
     * <code>OGG_OPUS = 6;</code>
     */
    public static final int OGG_OPUS_VALUE = 6;
    /**
     *
     *
     * <pre>
     * Although the use of lossy encodings is not recommended, if a very low
     * bitrate encoding is required, `OGG_OPUS` is highly preferred over
     * Speex encoding. The [Speex](https://speex.org/)  encoding supported by
     * Cloud Speech API has a header byte in each block, as in MIME type
     * `audio/x-speex-with-header-byte`.
     * It is a variant of the RTP Speex encoding defined in
     * [RFC 5574](https://tools.ietf.org/html/rfc5574).
     * The stream is a sequence of blocks, one block per RTP packet. Each block
     * starts with a byte containing the length of the block, in bytes, followed
     * by one or more frames of Speex data, padded to an integral number of
     * bytes (octets) as specified in RFC 5574. In other words, each RTP header
     * is replaced with a single byte containing the block length. Only Speex
     * wideband is supported. `sample_rate_hertz` must be 16000.
     * </pre>
     *
     * <code>SPEEX_WITH_HEADER_BYTE = 7;</code>
     */
    public static final int SPEEX_WITH_HEADER_BYTE_VALUE = 7;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AudioEncoding valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static AudioEncoding forNumber(int value) {
      switch (value) {
        case 0:
          return ENCODING_UNSPECIFIED;
        case 1:
          return LINEAR16;
        case 2:
          return FLAC;
        case 3:
          return MULAW;
        case 4:
          return AMR;
        case 5:
          return AMR_WB;
        case 6:
          return OGG_OPUS;
        case 7:
          return SPEEX_WITH_HEADER_BYTE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<AudioEncoding> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<AudioEncoding> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<AudioEncoding>() {
          public AudioEncoding findValueByNumber(int number) {
            return AudioEncoding.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.speech.v1.RecognitionConfig.getDescriptor().getEnumTypes().get(0);
    }

    private static final AudioEncoding[] VALUES = values();

    public static AudioEncoding valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private AudioEncoding(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.speech.v1.RecognitionConfig.AudioEncoding)
  }

  public static final int ENCODING_FIELD_NUMBER = 1;
  private int encoding_;
  /**
   *
   *
   * <pre>
   * Encoding of audio data sent in all `RecognitionAudio` messages.
   * This field is optional for `FLAC` and `WAV` audio files and required
   * for all other audio formats. For details, see [AudioEncoding][google.cloud.speech.v1.RecognitionConfig.AudioEncoding].
   * </pre>
   *
   * <code>.google.cloud.speech.v1.RecognitionConfig.AudioEncoding encoding = 1;</code>
   *
   * @return The enum numeric value on the wire for encoding.
   */
  public int getEncodingValue() {
    return encoding_;
  }
  /**
   *
   *
   * <pre>
   * Encoding of audio data sent in all `RecognitionAudio` messages.
   * This field is optional for `FLAC` and `WAV` audio files and required
   * for all other audio formats. For details, see [AudioEncoding][google.cloud.speech.v1.RecognitionConfig.AudioEncoding].
   * </pre>
   *
   * <code>.google.cloud.speech.v1.RecognitionConfig.AudioEncoding encoding = 1;</code>
   *
   * @return The encoding.
   */
  public com.google.cloud.speech.v1.RecognitionConfig.AudioEncoding getEncoding() {
    @SuppressWarnings("deprecation")
    com.google.cloud.speech.v1.RecognitionConfig.AudioEncoding result =
        com.google.cloud.speech.v1.RecognitionConfig.AudioEncoding.valueOf(encoding_);
    return result == null
        ? com.google.cloud.speech.v1.RecognitionConfig.AudioEncoding.UNRECOGNIZED
        : result;
  }

  public static final int SAMPLE_RATE_HERTZ_FIELD_NUMBER = 2;
  private int sampleRateHertz_;
  /**
   *
   *
   * <pre>
   * Sample rate in Hertz of the audio data sent in all
   * `RecognitionAudio` messages. Valid values are: 8000-48000.
   * 16000 is optimal. For best results, set the sampling rate of the audio
   * source to 16000 Hz. If that's not possible, use the native sample rate of
   * the audio source (instead of re-sampling).
   * This field is optional for FLAC and WAV audio files, but is
   * required for all other audio formats. For details, see [AudioEncoding][google.cloud.speech.v1.RecognitionConfig.AudioEncoding].
   * </pre>
   *
   * <code>int32 sample_rate_hertz = 2;</code>
   *
   * @return The sampleRateHertz.
   */
  public int getSampleRateHertz() {
    return sampleRateHertz_;
  }

  public static final int AUDIO_CHANNEL_COUNT_FIELD_NUMBER = 7;
  private int audioChannelCount_;
  /**
   *
   *
   * <pre>
   * The number of channels in the input audio data.
   * ONLY set this for MULTI-CHANNEL recognition.
   * Valid values for LINEAR16 and FLAC are `1`-`8`.
   * Valid values for OGG_OPUS are '1'-'254'.
   * Valid value for MULAW, AMR, AMR_WB and SPEEX_WITH_HEADER_BYTE is only `1`.
   * If `0` or omitted, defaults to one channel (mono).
   * Note: We only recognize the first channel by default.
   * To perform independent recognition on each channel set
   * `enable_separate_recognition_per_channel` to 'true'.
   * </pre>
   *
   * <code>int32 audio_channel_count = 7;</code>
   *
   * @return The audioChannelCount.
   */
  public int getAudioChannelCount() {
    return audioChannelCount_;
  }

  public static final int ENABLE_SEPARATE_RECOGNITION_PER_CHANNEL_FIELD_NUMBER = 12;
  private boolean enableSeparateRecognitionPerChannel_;
  /**
   *
   *
   * <pre>
   * This needs to be set to `true` explicitly and `audio_channel_count` &gt; 1
   * to get each channel recognized separately. The recognition result will
   * contain a `channel_tag` field to state which channel that result belongs
   * to. If this is not true, we will only recognize the first channel. The
   * request is billed cumulatively for all channels recognized:
   * `audio_channel_count` multiplied by the length of the audio.
   * </pre>
   *
   * <code>bool enable_separate_recognition_per_channel = 12;</code>
   *
   * @return The enableSeparateRecognitionPerChannel.
   */
  public boolean getEnableSeparateRecognitionPerChannel() {
    return enableSeparateRecognitionPerChannel_;
  }

  public static final int LANGUAGE_CODE_FIELD_NUMBER = 3;
  private volatile java.lang.Object languageCode_;
  /**
   *
   *
   * <pre>
   * Required. The language of the supplied audio as a
   * [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag.
   * Example: "en-US".
   * See [Language
   * Support](https://cloud.google.com/speech-to-text/docs/languages) for a list
   * of the currently supported language codes.
   * </pre>
   *
   * <code>string language_code = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The languageCode.
   */
  public java.lang.String getLanguageCode() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      languageCode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The language of the supplied audio as a
   * [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag.
   * Example: "en-US".
   * See [Language
   * Support](https://cloud.google.com/speech-to-text/docs/languages) for a list
   * of the currently supported language codes.
   * </pre>
   *
   * <code>string language_code = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for languageCode.
   */
  public com.google.protobuf.ByteString getLanguageCodeBytes() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      languageCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MAX_ALTERNATIVES_FIELD_NUMBER = 4;
  private int maxAlternatives_;
  /**
   *
   *
   * <pre>
   * Maximum number of recognition hypotheses to be returned.
   * Specifically, the maximum number of `SpeechRecognitionAlternative` messages
   * within each `SpeechRecognitionResult`.
   * The server may return fewer than `max_alternatives`.
   * Valid values are `0`-`30`. A value of `0` or `1` will return a maximum of
   * one. If omitted, will return a maximum of one.
   * </pre>
   *
   * <code>int32 max_alternatives = 4;</code>
   *
   * @return The maxAlternatives.
   */
  public int getMaxAlternatives() {
    return maxAlternatives_;
  }

  public static final int PROFANITY_FILTER_FIELD_NUMBER = 5;
  private boolean profanityFilter_;
  /**
   *
   *
   * <pre>
   * If set to `true`, the server will attempt to filter out
   * profanities, replacing all but the initial character in each filtered word
   * with asterisks, e.g. "f***". If set to `false` or omitted, profanities
   * won't be filtered out.
   * </pre>
   *
   * <code>bool profanity_filter = 5;</code>
   *
   * @return The profanityFilter.
   */
  public boolean getProfanityFilter() {
    return profanityFilter_;
  }

  public static final int SPEECH_CONTEXTS_FIELD_NUMBER = 6;
  private java.util.List<com.google.cloud.speech.v1.SpeechContext> speechContexts_;
  /**
   *
   *
   * <pre>
   * Array of [SpeechContext][google.cloud.speech.v1.SpeechContext].
   * A means to provide context to assist the speech recognition. For more
   * information, see
   * [speech
   * adaptation](https://cloud.google.com/speech-to-text/docs/context-strength).
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v1.SpeechContext speech_contexts = 6;</code>
   */
  public java.util.List<com.google.cloud.speech.v1.SpeechContext> getSpeechContextsList() {
    return speechContexts_;
  }
  /**
   *
   *
   * <pre>
   * Array of [SpeechContext][google.cloud.speech.v1.SpeechContext].
   * A means to provide context to assist the speech recognition. For more
   * information, see
   * [speech
   * adaptation](https://cloud.google.com/speech-to-text/docs/context-strength).
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v1.SpeechContext speech_contexts = 6;</code>
   */
  public java.util.List<? extends com.google.cloud.speech.v1.SpeechContextOrBuilder>
      getSpeechContextsOrBuilderList() {
    return speechContexts_;
  }
  /**
   *
   *
   * <pre>
   * Array of [SpeechContext][google.cloud.speech.v1.SpeechContext].
   * A means to provide context to assist the speech recognition. For more
   * information, see
   * [speech
   * adaptation](https://cloud.google.com/speech-to-text/docs/context-strength).
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v1.SpeechContext speech_contexts = 6;</code>
   */
  public int getSpeechContextsCount() {
    return speechContexts_.size();
  }
  /**
   *
   *
   * <pre>
   * Array of [SpeechContext][google.cloud.speech.v1.SpeechContext].
   * A means to provide context to assist the speech recognition. For more
   * information, see
   * [speech
   * adaptation](https://cloud.google.com/speech-to-text/docs/context-strength).
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v1.SpeechContext speech_contexts = 6;</code>
   */
  public com.google.cloud.speech.v1.SpeechContext getSpeechContexts(int index) {
    return speechContexts_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Array of [SpeechContext][google.cloud.speech.v1.SpeechContext].
   * A means to provide context to assist the speech recognition. For more
   * information, see
   * [speech
   * adaptation](https://cloud.google.com/speech-to-text/docs/context-strength).
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v1.SpeechContext speech_contexts = 6;</code>
   */
  public com.google.cloud.speech.v1.SpeechContextOrBuilder getSpeechContextsOrBuilder(int index) {
    return speechContexts_.get(index);
  }

  public static final int ENABLE_WORD_TIME_OFFSETS_FIELD_NUMBER = 8;
  private boolean enableWordTimeOffsets_;
  /**
   *
   *
   * <pre>
   * If `true`, the top result includes a list of words and
   * the start and end time offsets (timestamps) for those words. If
   * `false`, no word-level time offset information is returned. The default is
   * `false`.
   * </pre>
   *
   * <code>bool enable_word_time_offsets = 8;</code>
   *
   * @return The enableWordTimeOffsets.
   */
  public boolean getEnableWordTimeOffsets() {
    return enableWordTimeOffsets_;
  }

  public static final int ENABLE_AUTOMATIC_PUNCTUATION_FIELD_NUMBER = 11;
  private boolean enableAutomaticPunctuation_;
  /**
   *
   *
   * <pre>
   * If 'true', adds punctuation to recognition result hypotheses.
   * This feature is only available in select languages. Setting this for
   * requests in other languages has no effect at all.
   * The default 'false' value does not add punctuation to result hypotheses.
   * Note: This is currently offered as an experimental service, complimentary
   * to all users. In the future this may be exclusively available as a
   * premium feature.
   * </pre>
   *
   * <code>bool enable_automatic_punctuation = 11;</code>
   *
   * @return The enableAutomaticPunctuation.
   */
  public boolean getEnableAutomaticPunctuation() {
    return enableAutomaticPunctuation_;
  }

  public static final int DIARIZATION_CONFIG_FIELD_NUMBER = 19;
  private com.google.cloud.speech.v1.SpeakerDiarizationConfig diarizationConfig_;
  /**
   *
   *
   * <pre>
   * Config to enable speaker diarization and set additional
   * parameters to make diarization better suited for your application.
   * Note: When this is enabled, we send all the words from the beginning of the
   * audio for the top alternative in every consecutive STREAMING responses.
   * This is done in order to improve our speaker tags as our models learn to
   * identify the speakers in the conversation over time.
   * For non-streaming requests, the diarization results will be provided only
   * in the top alternative of the FINAL SpeechRecognitionResult.
   * </pre>
   *
   * <code>.google.cloud.speech.v1.SpeakerDiarizationConfig diarization_config = 19;</code>
   *
   * @return Whether the diarizationConfig field is set.
   */
  public boolean hasDiarizationConfig() {
    return diarizationConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Config to enable speaker diarization and set additional
   * parameters to make diarization better suited for your application.
   * Note: When this is enabled, we send all the words from the beginning of the
   * audio for the top alternative in every consecutive STREAMING responses.
   * This is done in order to improve our speaker tags as our models learn to
   * identify the speakers in the conversation over time.
   * For non-streaming requests, the diarization results will be provided only
   * in the top alternative of the FINAL SpeechRecognitionResult.
   * </pre>
   *
   * <code>.google.cloud.speech.v1.SpeakerDiarizationConfig diarization_config = 19;</code>
   *
   * @return The diarizationConfig.
   */
  public com.google.cloud.speech.v1.SpeakerDiarizationConfig getDiarizationConfig() {
    return diarizationConfig_ == null
        ? com.google.cloud.speech.v1.SpeakerDiarizationConfig.getDefaultInstance()
        : diarizationConfig_;
  }
  /**
   *
   *
   * <pre>
   * Config to enable speaker diarization and set additional
   * parameters to make diarization better suited for your application.
   * Note: When this is enabled, we send all the words from the beginning of the
   * audio for the top alternative in every consecutive STREAMING responses.
   * This is done in order to improve our speaker tags as our models learn to
   * identify the speakers in the conversation over time.
   * For non-streaming requests, the diarization results will be provided only
   * in the top alternative of the FINAL SpeechRecognitionResult.
   * </pre>
   *
   * <code>.google.cloud.speech.v1.SpeakerDiarizationConfig diarization_config = 19;</code>
   */
  public com.google.cloud.speech.v1.SpeakerDiarizationConfigOrBuilder
      getDiarizationConfigOrBuilder() {
    return getDiarizationConfig();
  }

  public static final int METADATA_FIELD_NUMBER = 9;
  private com.google.cloud.speech.v1.RecognitionMetadata metadata_;
  /**
   *
   *
   * <pre>
   * Metadata regarding this request.
   * </pre>
   *
   * <code>.google.cloud.speech.v1.RecognitionMetadata metadata = 9;</code>
   *
   * @return Whether the metadata field is set.
   */
  public boolean hasMetadata() {
    return metadata_ != null;
  }
  /**
   *
   *
   * <pre>
   * Metadata regarding this request.
   * </pre>
   *
   * <code>.google.cloud.speech.v1.RecognitionMetadata metadata = 9;</code>
   *
   * @return The metadata.
   */
  public com.google.cloud.speech.v1.RecognitionMetadata getMetadata() {
    return metadata_ == null
        ? com.google.cloud.speech.v1.RecognitionMetadata.getDefaultInstance()
        : metadata_;
  }
  /**
   *
   *
   * <pre>
   * Metadata regarding this request.
   * </pre>
   *
   * <code>.google.cloud.speech.v1.RecognitionMetadata metadata = 9;</code>
   */
  public com.google.cloud.speech.v1.RecognitionMetadataOrBuilder getMetadataOrBuilder() {
    return getMetadata();
  }

  public static final int MODEL_FIELD_NUMBER = 13;
  private volatile java.lang.Object model_;
  /**
   *
   *
   * <pre>
   * Which model to select for the given request. Select the model
   * best suited to your domain to get best results. If a model is not
   * explicitly specified, then we auto-select a model based on the parameters
   * in the RecognitionConfig.
   * &lt;table&gt;
   *   &lt;tr&gt;
   *     &lt;td&gt;&lt;b&gt;Model&lt;/b&gt;&lt;/td&gt;
   *     &lt;td&gt;&lt;b&gt;Description&lt;/b&gt;&lt;/td&gt;
   *   &lt;/tr&gt;
   *   &lt;tr&gt;
   *     &lt;td&gt;&lt;code&gt;command_and_search&lt;/code&gt;&lt;/td&gt;
   *     &lt;td&gt;Best for short queries such as voice commands or voice search.&lt;/td&gt;
   *   &lt;/tr&gt;
   *   &lt;tr&gt;
   *     &lt;td&gt;&lt;code&gt;phone_call&lt;/code&gt;&lt;/td&gt;
   *     &lt;td&gt;Best for audio that originated from a phone call (typically
   *     recorded at an 8khz sampling rate).&lt;/td&gt;
   *   &lt;/tr&gt;
   *   &lt;tr&gt;
   *     &lt;td&gt;&lt;code&gt;video&lt;/code&gt;&lt;/td&gt;
   *     &lt;td&gt;Best for audio that originated from from video or includes multiple
   *         speakers. Ideally the audio is recorded at a 16khz or greater
   *         sampling rate. This is a premium model that costs more than the
   *         standard rate.&lt;/td&gt;
   *   &lt;/tr&gt;
   *   &lt;tr&gt;
   *     &lt;td&gt;&lt;code&gt;default&lt;/code&gt;&lt;/td&gt;
   *     &lt;td&gt;Best for audio that is not one of the specific audio models.
   *         For example, long-form audio. Ideally the audio is high-fidelity,
   *         recorded at a 16khz or greater sampling rate.&lt;/td&gt;
   *   &lt;/tr&gt;
   * &lt;/table&gt;
   * </pre>
   *
   * <code>string model = 13;</code>
   *
   * @return The model.
   */
  public java.lang.String getModel() {
    java.lang.Object ref = model_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      model_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Which model to select for the given request. Select the model
   * best suited to your domain to get best results. If a model is not
   * explicitly specified, then we auto-select a model based on the parameters
   * in the RecognitionConfig.
   * &lt;table&gt;
   *   &lt;tr&gt;
   *     &lt;td&gt;&lt;b&gt;Model&lt;/b&gt;&lt;/td&gt;
   *     &lt;td&gt;&lt;b&gt;Description&lt;/b&gt;&lt;/td&gt;
   *   &lt;/tr&gt;
   *   &lt;tr&gt;
   *     &lt;td&gt;&lt;code&gt;command_and_search&lt;/code&gt;&lt;/td&gt;
   *     &lt;td&gt;Best for short queries such as voice commands or voice search.&lt;/td&gt;
   *   &lt;/tr&gt;
   *   &lt;tr&gt;
   *     &lt;td&gt;&lt;code&gt;phone_call&lt;/code&gt;&lt;/td&gt;
   *     &lt;td&gt;Best for audio that originated from a phone call (typically
   *     recorded at an 8khz sampling rate).&lt;/td&gt;
   *   &lt;/tr&gt;
   *   &lt;tr&gt;
   *     &lt;td&gt;&lt;code&gt;video&lt;/code&gt;&lt;/td&gt;
   *     &lt;td&gt;Best for audio that originated from from video or includes multiple
   *         speakers. Ideally the audio is recorded at a 16khz or greater
   *         sampling rate. This is a premium model that costs more than the
   *         standard rate.&lt;/td&gt;
   *   &lt;/tr&gt;
   *   &lt;tr&gt;
   *     &lt;td&gt;&lt;code&gt;default&lt;/code&gt;&lt;/td&gt;
   *     &lt;td&gt;Best for audio that is not one of the specific audio models.
   *         For example, long-form audio. Ideally the audio is high-fidelity,
   *         recorded at a 16khz or greater sampling rate.&lt;/td&gt;
   *   &lt;/tr&gt;
   * &lt;/table&gt;
   * </pre>
   *
   * <code>string model = 13;</code>
   *
   * @return The bytes for model.
   */
  public com.google.protobuf.ByteString getModelBytes() {
    java.lang.Object ref = model_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      model_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int USE_ENHANCED_FIELD_NUMBER = 14;
  private boolean useEnhanced_;
  /**
   *
   *
   * <pre>
   * Set to true to use an enhanced model for speech recognition.
   * If `use_enhanced` is set to true and the `model` field is not set, then
   * an appropriate enhanced model is chosen if an enhanced model exists for
   * the audio.
   * If `use_enhanced` is true and an enhanced version of the specified model
   * does not exist, then the speech is recognized using the standard version
   * of the specified model.
   * </pre>
   *
   * <code>bool use_enhanced = 14;</code>
   *
   * @return The useEnhanced.
   */
  public boolean getUseEnhanced() {
    return useEnhanced_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (encoding_
        != com.google.cloud.speech.v1.RecognitionConfig.AudioEncoding.ENCODING_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(1, encoding_);
    }
    if (sampleRateHertz_ != 0) {
      output.writeInt32(2, sampleRateHertz_);
    }
    if (!getLanguageCodeBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, languageCode_);
    }
    if (maxAlternatives_ != 0) {
      output.writeInt32(4, maxAlternatives_);
    }
    if (profanityFilter_ != false) {
      output.writeBool(5, profanityFilter_);
    }
    for (int i = 0; i < speechContexts_.size(); i++) {
      output.writeMessage(6, speechContexts_.get(i));
    }
    if (audioChannelCount_ != 0) {
      output.writeInt32(7, audioChannelCount_);
    }
    if (enableWordTimeOffsets_ != false) {
      output.writeBool(8, enableWordTimeOffsets_);
    }
    if (metadata_ != null) {
      output.writeMessage(9, getMetadata());
    }
    if (enableAutomaticPunctuation_ != false) {
      output.writeBool(11, enableAutomaticPunctuation_);
    }
    if (enableSeparateRecognitionPerChannel_ != false) {
      output.writeBool(12, enableSeparateRecognitionPerChannel_);
    }
    if (!getModelBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 13, model_);
    }
    if (useEnhanced_ != false) {
      output.writeBool(14, useEnhanced_);
    }
    if (diarizationConfig_ != null) {
      output.writeMessage(19, getDiarizationConfig());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (encoding_
        != com.google.cloud.speech.v1.RecognitionConfig.AudioEncoding.ENCODING_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, encoding_);
    }
    if (sampleRateHertz_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, sampleRateHertz_);
    }
    if (!getLanguageCodeBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, languageCode_);
    }
    if (maxAlternatives_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, maxAlternatives_);
    }
    if (profanityFilter_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, profanityFilter_);
    }
    for (int i = 0; i < speechContexts_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, speechContexts_.get(i));
    }
    if (audioChannelCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(7, audioChannelCount_);
    }
    if (enableWordTimeOffsets_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(8, enableWordTimeOffsets_);
    }
    if (metadata_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getMetadata());
    }
    if (enableAutomaticPunctuation_ != false) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(11, enableAutomaticPunctuation_);
    }
    if (enableSeparateRecognitionPerChannel_ != false) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(
              12, enableSeparateRecognitionPerChannel_);
    }
    if (!getModelBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(13, model_);
    }
    if (useEnhanced_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(14, useEnhanced_);
    }
    if (diarizationConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(19, getDiarizationConfig());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.speech.v1.RecognitionConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.speech.v1.RecognitionConfig other =
        (com.google.cloud.speech.v1.RecognitionConfig) obj;

    if (encoding_ != other.encoding_) return false;
    if (getSampleRateHertz() != other.getSampleRateHertz()) return false;
    if (getAudioChannelCount() != other.getAudioChannelCount()) return false;
    if (getEnableSeparateRecognitionPerChannel() != other.getEnableSeparateRecognitionPerChannel())
      return false;
    if (!getLanguageCode().equals(other.getLanguageCode())) return false;
    if (getMaxAlternatives() != other.getMaxAlternatives()) return false;
    if (getProfanityFilter() != other.getProfanityFilter()) return false;
    if (!getSpeechContextsList().equals(other.getSpeechContextsList())) return false;
    if (getEnableWordTimeOffsets() != other.getEnableWordTimeOffsets()) return false;
    if (getEnableAutomaticPunctuation() != other.getEnableAutomaticPunctuation()) return false;
    if (hasDiarizationConfig() != other.hasDiarizationConfig()) return false;
    if (hasDiarizationConfig()) {
      if (!getDiarizationConfig().equals(other.getDiarizationConfig())) return false;
    }
    if (hasMetadata() != other.hasMetadata()) return false;
    if (hasMetadata()) {
      if (!getMetadata().equals(other.getMetadata())) return false;
    }
    if (!getModel().equals(other.getModel())) return false;
    if (getUseEnhanced() != other.getUseEnhanced()) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ENCODING_FIELD_NUMBER;
    hash = (53 * hash) + encoding_;
    hash = (37 * hash) + SAMPLE_RATE_HERTZ_FIELD_NUMBER;
    hash = (53 * hash) + getSampleRateHertz();
    hash = (37 * hash) + AUDIO_CHANNEL_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getAudioChannelCount();
    hash = (37 * hash) + ENABLE_SEPARATE_RECOGNITION_PER_CHANNEL_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashBoolean(getEnableSeparateRecognitionPerChannel());
    hash = (37 * hash) + LANGUAGE_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getLanguageCode().hashCode();
    hash = (37 * hash) + MAX_ALTERNATIVES_FIELD_NUMBER;
    hash = (53 * hash) + getMaxAlternatives();
    hash = (37 * hash) + PROFANITY_FILTER_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getProfanityFilter());
    if (getSpeechContextsCount() > 0) {
      hash = (37 * hash) + SPEECH_CONTEXTS_FIELD_NUMBER;
      hash = (53 * hash) + getSpeechContextsList().hashCode();
    }
    hash = (37 * hash) + ENABLE_WORD_TIME_OFFSETS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableWordTimeOffsets());
    hash = (37 * hash) + ENABLE_AUTOMATIC_PUNCTUATION_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableAutomaticPunctuation());
    if (hasDiarizationConfig()) {
      hash = (37 * hash) + DIARIZATION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getDiarizationConfig().hashCode();
    }
    if (hasMetadata()) {
      hash = (37 * hash) + METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getMetadata().hashCode();
    }
    hash = (37 * hash) + MODEL_FIELD_NUMBER;
    hash = (53 * hash) + getModel().hashCode();
    hash = (37 * hash) + USE_ENHANCED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getUseEnhanced());
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.speech.v1.RecognitionConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.speech.v1.RecognitionConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.speech.v1.RecognitionConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.speech.v1.RecognitionConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.speech.v1.RecognitionConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.speech.v1.RecognitionConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.speech.v1.RecognitionConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.speech.v1.RecognitionConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.speech.v1.RecognitionConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.speech.v1.RecognitionConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.speech.v1.RecognitionConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.speech.v1.RecognitionConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.speech.v1.RecognitionConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Provides information to the recognizer that specifies how to process the
   * request.
   * </pre>
   *
   * Protobuf type {@code google.cloud.speech.v1.RecognitionConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.speech.v1.RecognitionConfig)
      com.google.cloud.speech.v1.RecognitionConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.speech.v1.SpeechProto
          .internal_static_google_cloud_speech_v1_RecognitionConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.speech.v1.SpeechProto
          .internal_static_google_cloud_speech_v1_RecognitionConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.speech.v1.RecognitionConfig.class,
              com.google.cloud.speech.v1.RecognitionConfig.Builder.class);
    }

    // Construct using com.google.cloud.speech.v1.RecognitionConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getSpeechContextsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      encoding_ = 0;

      sampleRateHertz_ = 0;

      audioChannelCount_ = 0;

      enableSeparateRecognitionPerChannel_ = false;

      languageCode_ = "";

      maxAlternatives_ = 0;

      profanityFilter_ = false;

      if (speechContextsBuilder_ == null) {
        speechContexts_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        speechContextsBuilder_.clear();
      }
      enableWordTimeOffsets_ = false;

      enableAutomaticPunctuation_ = false;

      if (diarizationConfigBuilder_ == null) {
        diarizationConfig_ = null;
      } else {
        diarizationConfig_ = null;
        diarizationConfigBuilder_ = null;
      }
      if (metadataBuilder_ == null) {
        metadata_ = null;
      } else {
        metadata_ = null;
        metadataBuilder_ = null;
      }
      model_ = "";

      useEnhanced_ = false;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.speech.v1.SpeechProto
          .internal_static_google_cloud_speech_v1_RecognitionConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.speech.v1.RecognitionConfig getDefaultInstanceForType() {
      return com.google.cloud.speech.v1.RecognitionConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.speech.v1.RecognitionConfig build() {
      com.google.cloud.speech.v1.RecognitionConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.speech.v1.RecognitionConfig buildPartial() {
      com.google.cloud.speech.v1.RecognitionConfig result =
          new com.google.cloud.speech.v1.RecognitionConfig(this);
      int from_bitField0_ = bitField0_;
      result.encoding_ = encoding_;
      result.sampleRateHertz_ = sampleRateHertz_;
      result.audioChannelCount_ = audioChannelCount_;
      result.enableSeparateRecognitionPerChannel_ = enableSeparateRecognitionPerChannel_;
      result.languageCode_ = languageCode_;
      result.maxAlternatives_ = maxAlternatives_;
      result.profanityFilter_ = profanityFilter_;
      if (speechContextsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          speechContexts_ = java.util.Collections.unmodifiableList(speechContexts_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.speechContexts_ = speechContexts_;
      } else {
        result.speechContexts_ = speechContextsBuilder_.build();
      }
      result.enableWordTimeOffsets_ = enableWordTimeOffsets_;
      result.enableAutomaticPunctuation_ = enableAutomaticPunctuation_;
      if (diarizationConfigBuilder_ == null) {
        result.diarizationConfig_ = diarizationConfig_;
      } else {
        result.diarizationConfig_ = diarizationConfigBuilder_.build();
      }
      if (metadataBuilder_ == null) {
        result.metadata_ = metadata_;
      } else {
        result.metadata_ = metadataBuilder_.build();
      }
      result.model_ = model_;
      result.useEnhanced_ = useEnhanced_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.speech.v1.RecognitionConfig) {
        return mergeFrom((com.google.cloud.speech.v1.RecognitionConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.speech.v1.RecognitionConfig other) {
      if (other == com.google.cloud.speech.v1.RecognitionConfig.getDefaultInstance()) return this;
      if (other.encoding_ != 0) {
        setEncodingValue(other.getEncodingValue());
      }
      if (other.getSampleRateHertz() != 0) {
        setSampleRateHertz(other.getSampleRateHertz());
      }
      if (other.getAudioChannelCount() != 0) {
        setAudioChannelCount(other.getAudioChannelCount());
      }
      if (other.getEnableSeparateRecognitionPerChannel() != false) {
        setEnableSeparateRecognitionPerChannel(other.getEnableSeparateRecognitionPerChannel());
      }
      if (!other.getLanguageCode().isEmpty()) {
        languageCode_ = other.languageCode_;
        onChanged();
      }
      if (other.getMaxAlternatives() != 0) {
        setMaxAlternatives(other.getMaxAlternatives());
      }
      if (other.getProfanityFilter() != false) {
        setProfanityFilter(other.getProfanityFilter());
      }
      if (speechContextsBuilder_ == null) {
        if (!other.speechContexts_.isEmpty()) {
          if (speechContexts_.isEmpty()) {
            speechContexts_ = other.speechContexts_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureSpeechContextsIsMutable();
            speechContexts_.addAll(other.speechContexts_);
          }
          onChanged();
        }
      } else {
        if (!other.speechContexts_.isEmpty()) {
          if (speechContextsBuilder_.isEmpty()) {
            speechContextsBuilder_.dispose();
            speechContextsBuilder_ = null;
            speechContexts_ = other.speechContexts_;
            bitField0_ = (bitField0_ & ~0x00000001);
            speechContextsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSpeechContextsFieldBuilder()
                    : null;
          } else {
            speechContextsBuilder_.addAllMessages(other.speechContexts_);
          }
        }
      }
      if (other.getEnableWordTimeOffsets() != false) {
        setEnableWordTimeOffsets(other.getEnableWordTimeOffsets());
      }
      if (other.getEnableAutomaticPunctuation() != false) {
        setEnableAutomaticPunctuation(other.getEnableAutomaticPunctuation());
      }
      if (other.hasDiarizationConfig()) {
        mergeDiarizationConfig(other.getDiarizationConfig());
      }
      if (other.hasMetadata()) {
        mergeMetadata(other.getMetadata());
      }
      if (!other.getModel().isEmpty()) {
        model_ = other.model_;
        onChanged();
      }
      if (other.getUseEnhanced() != false) {
        setUseEnhanced(other.getUseEnhanced());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.speech.v1.RecognitionConfig parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.speech.v1.RecognitionConfig) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private int encoding_ = 0;
    /**
     *
     *
     * <pre>
     * Encoding of audio data sent in all `RecognitionAudio` messages.
     * This field is optional for `FLAC` and `WAV` audio files and required
     * for all other audio formats. For details, see [AudioEncoding][google.cloud.speech.v1.RecognitionConfig.AudioEncoding].
     * </pre>
     *
     * <code>.google.cloud.speech.v1.RecognitionConfig.AudioEncoding encoding = 1;</code>
     *
     * @return The enum numeric value on the wire for encoding.
     */
    public int getEncodingValue() {
      return encoding_;
    }
    /**
     *
     *
     * <pre>
     * Encoding of audio data sent in all `RecognitionAudio` messages.
     * This field is optional for `FLAC` and `WAV` audio files and required
     * for all other audio formats. For details, see [AudioEncoding][google.cloud.speech.v1.RecognitionConfig.AudioEncoding].
     * </pre>
     *
     * <code>.google.cloud.speech.v1.RecognitionConfig.AudioEncoding encoding = 1;</code>
     *
     * @param value The enum numeric value on the wire for encoding to set.
     * @return This builder for chaining.
     */
    public Builder setEncodingValue(int value) {
      encoding_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Encoding of audio data sent in all `RecognitionAudio` messages.
     * This field is optional for `FLAC` and `WAV` audio files and required
     * for all other audio formats. For details, see [AudioEncoding][google.cloud.speech.v1.RecognitionConfig.AudioEncoding].
     * </pre>
     *
     * <code>.google.cloud.speech.v1.RecognitionConfig.AudioEncoding encoding = 1;</code>
     *
     * @return The encoding.
     */
    public com.google.cloud.speech.v1.RecognitionConfig.AudioEncoding getEncoding() {
      @SuppressWarnings("deprecation")
      com.google.cloud.speech.v1.RecognitionConfig.AudioEncoding result =
          com.google.cloud.speech.v1.RecognitionConfig.AudioEncoding.valueOf(encoding_);
      return result == null
          ? com.google.cloud.speech.v1.RecognitionConfig.AudioEncoding.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Encoding of audio data sent in all `RecognitionAudio` messages.
     * This field is optional for `FLAC` and `WAV` audio files and required
     * for all other audio formats. For details, see [AudioEncoding][google.cloud.speech.v1.RecognitionConfig.AudioEncoding].
     * </pre>
     *
     * <code>.google.cloud.speech.v1.RecognitionConfig.AudioEncoding encoding = 1;</code>
     *
     * @param value The encoding to set.
     * @return This builder for chaining.
     */
    public Builder setEncoding(com.google.cloud.speech.v1.RecognitionConfig.AudioEncoding value) {
      if (value == null) {
        throw new NullPointerException();
      }

      encoding_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Encoding of audio data sent in all `RecognitionAudio` messages.
     * This field is optional for `FLAC` and `WAV` audio files and required
     * for all other audio formats. For details, see [AudioEncoding][google.cloud.speech.v1.RecognitionConfig.AudioEncoding].
     * </pre>
     *
     * <code>.google.cloud.speech.v1.RecognitionConfig.AudioEncoding encoding = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEncoding() {

      encoding_ = 0;
      onChanged();
      return this;
    }

    private int sampleRateHertz_;
    /**
     *
     *
     * <pre>
     * Sample rate in Hertz of the audio data sent in all
     * `RecognitionAudio` messages. Valid values are: 8000-48000.
     * 16000 is optimal. For best results, set the sampling rate of the audio
     * source to 16000 Hz. If that's not possible, use the native sample rate of
     * the audio source (instead of re-sampling).
     * This field is optional for FLAC and WAV audio files, but is
     * required for all other audio formats. For details, see [AudioEncoding][google.cloud.speech.v1.RecognitionConfig.AudioEncoding].
     * </pre>
     *
     * <code>int32 sample_rate_hertz = 2;</code>
     *
     * @return The sampleRateHertz.
     */
    public int getSampleRateHertz() {
      return sampleRateHertz_;
    }
    /**
     *
     *
     * <pre>
     * Sample rate in Hertz of the audio data sent in all
     * `RecognitionAudio` messages. Valid values are: 8000-48000.
     * 16000 is optimal. For best results, set the sampling rate of the audio
     * source to 16000 Hz. If that's not possible, use the native sample rate of
     * the audio source (instead of re-sampling).
     * This field is optional for FLAC and WAV audio files, but is
     * required for all other audio formats. For details, see [AudioEncoding][google.cloud.speech.v1.RecognitionConfig.AudioEncoding].
     * </pre>
     *
     * <code>int32 sample_rate_hertz = 2;</code>
     *
     * @param value The sampleRateHertz to set.
     * @return This builder for chaining.
     */
    public Builder setSampleRateHertz(int value) {

      sampleRateHertz_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sample rate in Hertz of the audio data sent in all
     * `RecognitionAudio` messages. Valid values are: 8000-48000.
     * 16000 is optimal. For best results, set the sampling rate of the audio
     * source to 16000 Hz. If that's not possible, use the native sample rate of
     * the audio source (instead of re-sampling).
     * This field is optional for FLAC and WAV audio files, but is
     * required for all other audio formats. For details, see [AudioEncoding][google.cloud.speech.v1.RecognitionConfig.AudioEncoding].
     * </pre>
     *
     * <code>int32 sample_rate_hertz = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSampleRateHertz() {

      sampleRateHertz_ = 0;
      onChanged();
      return this;
    }

    private int audioChannelCount_;
    /**
     *
     *
     * <pre>
     * The number of channels in the input audio data.
     * ONLY set this for MULTI-CHANNEL recognition.
     * Valid values for LINEAR16 and FLAC are `1`-`8`.
     * Valid values for OGG_OPUS are '1'-'254'.
     * Valid value for MULAW, AMR, AMR_WB and SPEEX_WITH_HEADER_BYTE is only `1`.
     * If `0` or omitted, defaults to one channel (mono).
     * Note: We only recognize the first channel by default.
     * To perform independent recognition on each channel set
     * `enable_separate_recognition_per_channel` to 'true'.
     * </pre>
     *
     * <code>int32 audio_channel_count = 7;</code>
     *
     * @return The audioChannelCount.
     */
    public int getAudioChannelCount() {
      return audioChannelCount_;
    }
    /**
     *
     *
     * <pre>
     * The number of channels in the input audio data.
     * ONLY set this for MULTI-CHANNEL recognition.
     * Valid values for LINEAR16 and FLAC are `1`-`8`.
     * Valid values for OGG_OPUS are '1'-'254'.
     * Valid value for MULAW, AMR, AMR_WB and SPEEX_WITH_HEADER_BYTE is only `1`.
     * If `0` or omitted, defaults to one channel (mono).
     * Note: We only recognize the first channel by default.
     * To perform independent recognition on each channel set
     * `enable_separate_recognition_per_channel` to 'true'.
     * </pre>
     *
     * <code>int32 audio_channel_count = 7;</code>
     *
     * @param value The audioChannelCount to set.
     * @return This builder for chaining.
     */
    public Builder setAudioChannelCount(int value) {

      audioChannelCount_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of channels in the input audio data.
     * ONLY set this for MULTI-CHANNEL recognition.
     * Valid values for LINEAR16 and FLAC are `1`-`8`.
     * Valid values for OGG_OPUS are '1'-'254'.
     * Valid value for MULAW, AMR, AMR_WB and SPEEX_WITH_HEADER_BYTE is only `1`.
     * If `0` or omitted, defaults to one channel (mono).
     * Note: We only recognize the first channel by default.
     * To perform independent recognition on each channel set
     * `enable_separate_recognition_per_channel` to 'true'.
     * </pre>
     *
     * <code>int32 audio_channel_count = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAudioChannelCount() {

      audioChannelCount_ = 0;
      onChanged();
      return this;
    }

    private boolean enableSeparateRecognitionPerChannel_;
    /**
     *
     *
     * <pre>
     * This needs to be set to `true` explicitly and `audio_channel_count` &gt; 1
     * to get each channel recognized separately. The recognition result will
     * contain a `channel_tag` field to state which channel that result belongs
     * to. If this is not true, we will only recognize the first channel. The
     * request is billed cumulatively for all channels recognized:
     * `audio_channel_count` multiplied by the length of the audio.
     * </pre>
     *
     * <code>bool enable_separate_recognition_per_channel = 12;</code>
     *
     * @return The enableSeparateRecognitionPerChannel.
     */
    public boolean getEnableSeparateRecognitionPerChannel() {
      return enableSeparateRecognitionPerChannel_;
    }
    /**
     *
     *
     * <pre>
     * This needs to be set to `true` explicitly and `audio_channel_count` &gt; 1
     * to get each channel recognized separately. The recognition result will
     * contain a `channel_tag` field to state which channel that result belongs
     * to. If this is not true, we will only recognize the first channel. The
     * request is billed cumulatively for all channels recognized:
     * `audio_channel_count` multiplied by the length of the audio.
     * </pre>
     *
     * <code>bool enable_separate_recognition_per_channel = 12;</code>
     *
     * @param value The enableSeparateRecognitionPerChannel to set.
     * @return This builder for chaining.
     */
    public Builder setEnableSeparateRecognitionPerChannel(boolean value) {

      enableSeparateRecognitionPerChannel_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This needs to be set to `true` explicitly and `audio_channel_count` &gt; 1
     * to get each channel recognized separately. The recognition result will
     * contain a `channel_tag` field to state which channel that result belongs
     * to. If this is not true, we will only recognize the first channel. The
     * request is billed cumulatively for all channels recognized:
     * `audio_channel_count` multiplied by the length of the audio.
     * </pre>
     *
     * <code>bool enable_separate_recognition_per_channel = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableSeparateRecognitionPerChannel() {

      enableSeparateRecognitionPerChannel_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object languageCode_ = "";
    /**
     *
     *
     * <pre>
     * Required. The language of the supplied audio as a
     * [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag.
     * Example: "en-US".
     * See [Language
     * Support](https://cloud.google.com/speech-to-text/docs/languages) for a list
     * of the currently supported language codes.
     * </pre>
     *
     * <code>string language_code = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The languageCode.
     */
    public java.lang.String getLanguageCode() {
      java.lang.Object ref = languageCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        languageCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The language of the supplied audio as a
     * [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag.
     * Example: "en-US".
     * See [Language
     * Support](https://cloud.google.com/speech-to-text/docs/languages) for a list
     * of the currently supported language codes.
     * </pre>
     *
     * <code>string language_code = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for languageCode.
     */
    public com.google.protobuf.ByteString getLanguageCodeBytes() {
      java.lang.Object ref = languageCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        languageCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The language of the supplied audio as a
     * [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag.
     * Example: "en-US".
     * See [Language
     * Support](https://cloud.google.com/speech-to-text/docs/languages) for a list
     * of the currently supported language codes.
     * </pre>
     *
     * <code>string language_code = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      languageCode_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The language of the supplied audio as a
     * [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag.
     * Example: "en-US".
     * See [Language
     * Support](https://cloud.google.com/speech-to-text/docs/languages) for a list
     * of the currently supported language codes.
     * </pre>
     *
     * <code>string language_code = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLanguageCode() {

      languageCode_ = getDefaultInstance().getLanguageCode();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The language of the supplied audio as a
     * [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag.
     * Example: "en-US".
     * See [Language
     * Support](https://cloud.google.com/speech-to-text/docs/languages) for a list
     * of the currently supported language codes.
     * </pre>
     *
     * <code>string language_code = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      languageCode_ = value;
      onChanged();
      return this;
    }

    private int maxAlternatives_;
    /**
     *
     *
     * <pre>
     * Maximum number of recognition hypotheses to be returned.
     * Specifically, the maximum number of `SpeechRecognitionAlternative` messages
     * within each `SpeechRecognitionResult`.
     * The server may return fewer than `max_alternatives`.
     * Valid values are `0`-`30`. A value of `0` or `1` will return a maximum of
     * one. If omitted, will return a maximum of one.
     * </pre>
     *
     * <code>int32 max_alternatives = 4;</code>
     *
     * @return The maxAlternatives.
     */
    public int getMaxAlternatives() {
      return maxAlternatives_;
    }
    /**
     *
     *
     * <pre>
     * Maximum number of recognition hypotheses to be returned.
     * Specifically, the maximum number of `SpeechRecognitionAlternative` messages
     * within each `SpeechRecognitionResult`.
     * The server may return fewer than `max_alternatives`.
     * Valid values are `0`-`30`. A value of `0` or `1` will return a maximum of
     * one. If omitted, will return a maximum of one.
     * </pre>
     *
     * <code>int32 max_alternatives = 4;</code>
     *
     * @param value The maxAlternatives to set.
     * @return This builder for chaining.
     */
    public Builder setMaxAlternatives(int value) {

      maxAlternatives_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Maximum number of recognition hypotheses to be returned.
     * Specifically, the maximum number of `SpeechRecognitionAlternative` messages
     * within each `SpeechRecognitionResult`.
     * The server may return fewer than `max_alternatives`.
     * Valid values are `0`-`30`. A value of `0` or `1` will return a maximum of
     * one. If omitted, will return a maximum of one.
     * </pre>
     *
     * <code>int32 max_alternatives = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxAlternatives() {

      maxAlternatives_ = 0;
      onChanged();
      return this;
    }

    private boolean profanityFilter_;
    /**
     *
     *
     * <pre>
     * If set to `true`, the server will attempt to filter out
     * profanities, replacing all but the initial character in each filtered word
     * with asterisks, e.g. "f***". If set to `false` or omitted, profanities
     * won't be filtered out.
     * </pre>
     *
     * <code>bool profanity_filter = 5;</code>
     *
     * @return The profanityFilter.
     */
    public boolean getProfanityFilter() {
      return profanityFilter_;
    }
    /**
     *
     *
     * <pre>
     * If set to `true`, the server will attempt to filter out
     * profanities, replacing all but the initial character in each filtered word
     * with asterisks, e.g. "f***". If set to `false` or omitted, profanities
     * won't be filtered out.
     * </pre>
     *
     * <code>bool profanity_filter = 5;</code>
     *
     * @param value The profanityFilter to set.
     * @return This builder for chaining.
     */
    public Builder setProfanityFilter(boolean value) {

      profanityFilter_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set to `true`, the server will attempt to filter out
     * profanities, replacing all but the initial character in each filtered word
     * with asterisks, e.g. "f***". If set to `false` or omitted, profanities
     * won't be filtered out.
     * </pre>
     *
     * <code>bool profanity_filter = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProfanityFilter() {

      profanityFilter_ = false;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.speech.v1.SpeechContext> speechContexts_ =
        java.util.Collections.emptyList();

    private void ensureSpeechContextsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        speechContexts_ =
            new java.util.ArrayList<com.google.cloud.speech.v1.SpeechContext>(speechContexts_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.speech.v1.SpeechContext,
            com.google.cloud.speech.v1.SpeechContext.Builder,
            com.google.cloud.speech.v1.SpeechContextOrBuilder>
        speechContextsBuilder_;

    /**
     *
     *
     * <pre>
     * Array of [SpeechContext][google.cloud.speech.v1.SpeechContext].
     * A means to provide context to assist the speech recognition. For more
     * information, see
     * [speech
     * adaptation](https://cloud.google.com/speech-to-text/docs/context-strength).
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.SpeechContext speech_contexts = 6;</code>
     */
    public java.util.List<com.google.cloud.speech.v1.SpeechContext> getSpeechContextsList() {
      if (speechContextsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(speechContexts_);
      } else {
        return speechContextsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Array of [SpeechContext][google.cloud.speech.v1.SpeechContext].
     * A means to provide context to assist the speech recognition. For more
     * information, see
     * [speech
     * adaptation](https://cloud.google.com/speech-to-text/docs/context-strength).
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.SpeechContext speech_contexts = 6;</code>
     */
    public int getSpeechContextsCount() {
      if (speechContextsBuilder_ == null) {
        return speechContexts_.size();
      } else {
        return speechContextsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Array of [SpeechContext][google.cloud.speech.v1.SpeechContext].
     * A means to provide context to assist the speech recognition. For more
     * information, see
     * [speech
     * adaptation](https://cloud.google.com/speech-to-text/docs/context-strength).
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.SpeechContext speech_contexts = 6;</code>
     */
    public com.google.cloud.speech.v1.SpeechContext getSpeechContexts(int index) {
      if (speechContextsBuilder_ == null) {
        return speechContexts_.get(index);
      } else {
        return speechContextsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Array of [SpeechContext][google.cloud.speech.v1.SpeechContext].
     * A means to provide context to assist the speech recognition. For more
     * information, see
     * [speech
     * adaptation](https://cloud.google.com/speech-to-text/docs/context-strength).
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.SpeechContext speech_contexts = 6;</code>
     */
    public Builder setSpeechContexts(int index, com.google.cloud.speech.v1.SpeechContext value) {
      if (speechContextsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSpeechContextsIsMutable();
        speechContexts_.set(index, value);
        onChanged();
      } else {
        speechContextsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Array of [SpeechContext][google.cloud.speech.v1.SpeechContext].
     * A means to provide context to assist the speech recognition. For more
     * information, see
     * [speech
     * adaptation](https://cloud.google.com/speech-to-text/docs/context-strength).
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.SpeechContext speech_contexts = 6;</code>
     */
    public Builder setSpeechContexts(
        int index, com.google.cloud.speech.v1.SpeechContext.Builder builderForValue) {
      if (speechContextsBuilder_ == null) {
        ensureSpeechContextsIsMutable();
        speechContexts_.set(index, builderForValue.build());
        onChanged();
      } else {
        speechContextsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Array of [SpeechContext][google.cloud.speech.v1.SpeechContext].
     * A means to provide context to assist the speech recognition. For more
     * information, see
     * [speech
     * adaptation](https://cloud.google.com/speech-to-text/docs/context-strength).
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.SpeechContext speech_contexts = 6;</code>
     */
    public Builder addSpeechContexts(com.google.cloud.speech.v1.SpeechContext value) {
      if (speechContextsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSpeechContextsIsMutable();
        speechContexts_.add(value);
        onChanged();
      } else {
        speechContextsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Array of [SpeechContext][google.cloud.speech.v1.SpeechContext].
     * A means to provide context to assist the speech recognition. For more
     * information, see
     * [speech
     * adaptation](https://cloud.google.com/speech-to-text/docs/context-strength).
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.SpeechContext speech_contexts = 6;</code>
     */
    public Builder addSpeechContexts(int index, com.google.cloud.speech.v1.SpeechContext value) {
      if (speechContextsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSpeechContextsIsMutable();
        speechContexts_.add(index, value);
        onChanged();
      } else {
        speechContextsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Array of [SpeechContext][google.cloud.speech.v1.SpeechContext].
     * A means to provide context to assist the speech recognition. For more
     * information, see
     * [speech
     * adaptation](https://cloud.google.com/speech-to-text/docs/context-strength).
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.SpeechContext speech_contexts = 6;</code>
     */
    public Builder addSpeechContexts(
        com.google.cloud.speech.v1.SpeechContext.Builder builderForValue) {
      if (speechContextsBuilder_ == null) {
        ensureSpeechContextsIsMutable();
        speechContexts_.add(builderForValue.build());
        onChanged();
      } else {
        speechContextsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Array of [SpeechContext][google.cloud.speech.v1.SpeechContext].
     * A means to provide context to assist the speech recognition. For more
     * information, see
     * [speech
     * adaptation](https://cloud.google.com/speech-to-text/docs/context-strength).
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.SpeechContext speech_contexts = 6;</code>
     */
    public Builder addSpeechContexts(
        int index, com.google.cloud.speech.v1.SpeechContext.Builder builderForValue) {
      if (speechContextsBuilder_ == null) {
        ensureSpeechContextsIsMutable();
        speechContexts_.add(index, builderForValue.build());
        onChanged();
      } else {
        speechContextsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Array of [SpeechContext][google.cloud.speech.v1.SpeechContext].
     * A means to provide context to assist the speech recognition. For more
     * information, see
     * [speech
     * adaptation](https://cloud.google.com/speech-to-text/docs/context-strength).
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.SpeechContext speech_contexts = 6;</code>
     */
    public Builder addAllSpeechContexts(
        java.lang.Iterable<? extends com.google.cloud.speech.v1.SpeechContext> values) {
      if (speechContextsBuilder_ == null) {
        ensureSpeechContextsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, speechContexts_);
        onChanged();
      } else {
        speechContextsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Array of [SpeechContext][google.cloud.speech.v1.SpeechContext].
     * A means to provide context to assist the speech recognition. For more
     * information, see
     * [speech
     * adaptation](https://cloud.google.com/speech-to-text/docs/context-strength).
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.SpeechContext speech_contexts = 6;</code>
     */
    public Builder clearSpeechContexts() {
      if (speechContextsBuilder_ == null) {
        speechContexts_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        speechContextsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Array of [SpeechContext][google.cloud.speech.v1.SpeechContext].
     * A means to provide context to assist the speech recognition. For more
     * information, see
     * [speech
     * adaptation](https://cloud.google.com/speech-to-text/docs/context-strength).
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.SpeechContext speech_contexts = 6;</code>
     */
    public Builder removeSpeechContexts(int index) {
      if (speechContextsBuilder_ == null) {
        ensureSpeechContextsIsMutable();
        speechContexts_.remove(index);
        onChanged();
      } else {
        speechContextsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Array of [SpeechContext][google.cloud.speech.v1.SpeechContext].
     * A means to provide context to assist the speech recognition. For more
     * information, see
     * [speech
     * adaptation](https://cloud.google.com/speech-to-text/docs/context-strength).
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.SpeechContext speech_contexts = 6;</code>
     */
    public com.google.cloud.speech.v1.SpeechContext.Builder getSpeechContextsBuilder(int index) {
      return getSpeechContextsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Array of [SpeechContext][google.cloud.speech.v1.SpeechContext].
     * A means to provide context to assist the speech recognition. For more
     * information, see
     * [speech
     * adaptation](https://cloud.google.com/speech-to-text/docs/context-strength).
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.SpeechContext speech_contexts = 6;</code>
     */
    public com.google.cloud.speech.v1.SpeechContextOrBuilder getSpeechContextsOrBuilder(int index) {
      if (speechContextsBuilder_ == null) {
        return speechContexts_.get(index);
      } else {
        return speechContextsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Array of [SpeechContext][google.cloud.speech.v1.SpeechContext].
     * A means to provide context to assist the speech recognition. For more
     * information, see
     * [speech
     * adaptation](https://cloud.google.com/speech-to-text/docs/context-strength).
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.SpeechContext speech_contexts = 6;</code>
     */
    public java.util.List<? extends com.google.cloud.speech.v1.SpeechContextOrBuilder>
        getSpeechContextsOrBuilderList() {
      if (speechContextsBuilder_ != null) {
        return speechContextsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(speechContexts_);
      }
    }
    /**
     *
     *
     * <pre>
     * Array of [SpeechContext][google.cloud.speech.v1.SpeechContext].
     * A means to provide context to assist the speech recognition. For more
     * information, see
     * [speech
     * adaptation](https://cloud.google.com/speech-to-text/docs/context-strength).
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.SpeechContext speech_contexts = 6;</code>
     */
    public com.google.cloud.speech.v1.SpeechContext.Builder addSpeechContextsBuilder() {
      return getSpeechContextsFieldBuilder()
          .addBuilder(com.google.cloud.speech.v1.SpeechContext.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Array of [SpeechContext][google.cloud.speech.v1.SpeechContext].
     * A means to provide context to assist the speech recognition. For more
     * information, see
     * [speech
     * adaptation](https://cloud.google.com/speech-to-text/docs/context-strength).
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.SpeechContext speech_contexts = 6;</code>
     */
    public com.google.cloud.speech.v1.SpeechContext.Builder addSpeechContextsBuilder(int index) {
      return getSpeechContextsFieldBuilder()
          .addBuilder(index, com.google.cloud.speech.v1.SpeechContext.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Array of [SpeechContext][google.cloud.speech.v1.SpeechContext].
     * A means to provide context to assist the speech recognition. For more
     * information, see
     * [speech
     * adaptation](https://cloud.google.com/speech-to-text/docs/context-strength).
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.SpeechContext speech_contexts = 6;</code>
     */
    public java.util.List<com.google.cloud.speech.v1.SpeechContext.Builder>
        getSpeechContextsBuilderList() {
      return getSpeechContextsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.speech.v1.SpeechContext,
            com.google.cloud.speech.v1.SpeechContext.Builder,
            com.google.cloud.speech.v1.SpeechContextOrBuilder>
        getSpeechContextsFieldBuilder() {
      if (speechContextsBuilder_ == null) {
        speechContextsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.speech.v1.SpeechContext,
                com.google.cloud.speech.v1.SpeechContext.Builder,
                com.google.cloud.speech.v1.SpeechContextOrBuilder>(
                speechContexts_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        speechContexts_ = null;
      }
      return speechContextsBuilder_;
    }

    private boolean enableWordTimeOffsets_;
    /**
     *
     *
     * <pre>
     * If `true`, the top result includes a list of words and
     * the start and end time offsets (timestamps) for those words. If
     * `false`, no word-level time offset information is returned. The default is
     * `false`.
     * </pre>
     *
     * <code>bool enable_word_time_offsets = 8;</code>
     *
     * @return The enableWordTimeOffsets.
     */
    public boolean getEnableWordTimeOffsets() {
      return enableWordTimeOffsets_;
    }
    /**
     *
     *
     * <pre>
     * If `true`, the top result includes a list of words and
     * the start and end time offsets (timestamps) for those words. If
     * `false`, no word-level time offset information is returned. The default is
     * `false`.
     * </pre>
     *
     * <code>bool enable_word_time_offsets = 8;</code>
     *
     * @param value The enableWordTimeOffsets to set.
     * @return This builder for chaining.
     */
    public Builder setEnableWordTimeOffsets(boolean value) {

      enableWordTimeOffsets_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If `true`, the top result includes a list of words and
     * the start and end time offsets (timestamps) for those words. If
     * `false`, no word-level time offset information is returned. The default is
     * `false`.
     * </pre>
     *
     * <code>bool enable_word_time_offsets = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableWordTimeOffsets() {

      enableWordTimeOffsets_ = false;
      onChanged();
      return this;
    }

    private boolean enableAutomaticPunctuation_;
    /**
     *
     *
     * <pre>
     * If 'true', adds punctuation to recognition result hypotheses.
     * This feature is only available in select languages. Setting this for
     * requests in other languages has no effect at all.
     * The default 'false' value does not add punctuation to result hypotheses.
     * Note: This is currently offered as an experimental service, complimentary
     * to all users. In the future this may be exclusively available as a
     * premium feature.
     * </pre>
     *
     * <code>bool enable_automatic_punctuation = 11;</code>
     *
     * @return The enableAutomaticPunctuation.
     */
    public boolean getEnableAutomaticPunctuation() {
      return enableAutomaticPunctuation_;
    }
    /**
     *
     *
     * <pre>
     * If 'true', adds punctuation to recognition result hypotheses.
     * This feature is only available in select languages. Setting this for
     * requests in other languages has no effect at all.
     * The default 'false' value does not add punctuation to result hypotheses.
     * Note: This is currently offered as an experimental service, complimentary
     * to all users. In the future this may be exclusively available as a
     * premium feature.
     * </pre>
     *
     * <code>bool enable_automatic_punctuation = 11;</code>
     *
     * @param value The enableAutomaticPunctuation to set.
     * @return This builder for chaining.
     */
    public Builder setEnableAutomaticPunctuation(boolean value) {

      enableAutomaticPunctuation_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If 'true', adds punctuation to recognition result hypotheses.
     * This feature is only available in select languages. Setting this for
     * requests in other languages has no effect at all.
     * The default 'false' value does not add punctuation to result hypotheses.
     * Note: This is currently offered as an experimental service, complimentary
     * to all users. In the future this may be exclusively available as a
     * premium feature.
     * </pre>
     *
     * <code>bool enable_automatic_punctuation = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableAutomaticPunctuation() {

      enableAutomaticPunctuation_ = false;
      onChanged();
      return this;
    }

    private com.google.cloud.speech.v1.SpeakerDiarizationConfig diarizationConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v1.SpeakerDiarizationConfig,
            com.google.cloud.speech.v1.SpeakerDiarizationConfig.Builder,
            com.google.cloud.speech.v1.SpeakerDiarizationConfigOrBuilder>
        diarizationConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Config to enable speaker diarization and set additional
     * parameters to make diarization better suited for your application.
     * Note: When this is enabled, we send all the words from the beginning of the
     * audio for the top alternative in every consecutive STREAMING responses.
     * This is done in order to improve our speaker tags as our models learn to
     * identify the speakers in the conversation over time.
     * For non-streaming requests, the diarization results will be provided only
     * in the top alternative of the FINAL SpeechRecognitionResult.
     * </pre>
     *
     * <code>.google.cloud.speech.v1.SpeakerDiarizationConfig diarization_config = 19;</code>
     *
     * @return Whether the diarizationConfig field is set.
     */
    public boolean hasDiarizationConfig() {
      return diarizationConfigBuilder_ != null || diarizationConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Config to enable speaker diarization and set additional
     * parameters to make diarization better suited for your application.
     * Note: When this is enabled, we send all the words from the beginning of the
     * audio for the top alternative in every consecutive STREAMING responses.
     * This is done in order to improve our speaker tags as our models learn to
     * identify the speakers in the conversation over time.
     * For non-streaming requests, the diarization results will be provided only
     * in the top alternative of the FINAL SpeechRecognitionResult.
     * </pre>
     *
     * <code>.google.cloud.speech.v1.SpeakerDiarizationConfig diarization_config = 19;</code>
     *
     * @return The diarizationConfig.
     */
    public com.google.cloud.speech.v1.SpeakerDiarizationConfig getDiarizationConfig() {
      if (diarizationConfigBuilder_ == null) {
        return diarizationConfig_ == null
            ? com.google.cloud.speech.v1.SpeakerDiarizationConfig.getDefaultInstance()
            : diarizationConfig_;
      } else {
        return diarizationConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Config to enable speaker diarization and set additional
     * parameters to make diarization better suited for your application.
     * Note: When this is enabled, we send all the words from the beginning of the
     * audio for the top alternative in every consecutive STREAMING responses.
     * This is done in order to improve our speaker tags as our models learn to
     * identify the speakers in the conversation over time.
     * For non-streaming requests, the diarization results will be provided only
     * in the top alternative of the FINAL SpeechRecognitionResult.
     * </pre>
     *
     * <code>.google.cloud.speech.v1.SpeakerDiarizationConfig diarization_config = 19;</code>
     */
    public Builder setDiarizationConfig(com.google.cloud.speech.v1.SpeakerDiarizationConfig value) {
      if (diarizationConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        diarizationConfig_ = value;
        onChanged();
      } else {
        diarizationConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Config to enable speaker diarization and set additional
     * parameters to make diarization better suited for your application.
     * Note: When this is enabled, we send all the words from the beginning of the
     * audio for the top alternative in every consecutive STREAMING responses.
     * This is done in order to improve our speaker tags as our models learn to
     * identify the speakers in the conversation over time.
     * For non-streaming requests, the diarization results will be provided only
     * in the top alternative of the FINAL SpeechRecognitionResult.
     * </pre>
     *
     * <code>.google.cloud.speech.v1.SpeakerDiarizationConfig diarization_config = 19;</code>
     */
    public Builder setDiarizationConfig(
        com.google.cloud.speech.v1.SpeakerDiarizationConfig.Builder builderForValue) {
      if (diarizationConfigBuilder_ == null) {
        diarizationConfig_ = builderForValue.build();
        onChanged();
      } else {
        diarizationConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Config to enable speaker diarization and set additional
     * parameters to make diarization better suited for your application.
     * Note: When this is enabled, we send all the words from the beginning of the
     * audio for the top alternative in every consecutive STREAMING responses.
     * This is done in order to improve our speaker tags as our models learn to
     * identify the speakers in the conversation over time.
     * For non-streaming requests, the diarization results will be provided only
     * in the top alternative of the FINAL SpeechRecognitionResult.
     * </pre>
     *
     * <code>.google.cloud.speech.v1.SpeakerDiarizationConfig diarization_config = 19;</code>
     */
    public Builder mergeDiarizationConfig(
        com.google.cloud.speech.v1.SpeakerDiarizationConfig value) {
      if (diarizationConfigBuilder_ == null) {
        if (diarizationConfig_ != null) {
          diarizationConfig_ =
              com.google.cloud.speech.v1.SpeakerDiarizationConfig.newBuilder(diarizationConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          diarizationConfig_ = value;
        }
        onChanged();
      } else {
        diarizationConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Config to enable speaker diarization and set additional
     * parameters to make diarization better suited for your application.
     * Note: When this is enabled, we send all the words from the beginning of the
     * audio for the top alternative in every consecutive STREAMING responses.
     * This is done in order to improve our speaker tags as our models learn to
     * identify the speakers in the conversation over time.
     * For non-streaming requests, the diarization results will be provided only
     * in the top alternative of the FINAL SpeechRecognitionResult.
     * </pre>
     *
     * <code>.google.cloud.speech.v1.SpeakerDiarizationConfig diarization_config = 19;</code>
     */
    public Builder clearDiarizationConfig() {
      if (diarizationConfigBuilder_ == null) {
        diarizationConfig_ = null;
        onChanged();
      } else {
        diarizationConfig_ = null;
        diarizationConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Config to enable speaker diarization and set additional
     * parameters to make diarization better suited for your application.
     * Note: When this is enabled, we send all the words from the beginning of the
     * audio for the top alternative in every consecutive STREAMING responses.
     * This is done in order to improve our speaker tags as our models learn to
     * identify the speakers in the conversation over time.
     * For non-streaming requests, the diarization results will be provided only
     * in the top alternative of the FINAL SpeechRecognitionResult.
     * </pre>
     *
     * <code>.google.cloud.speech.v1.SpeakerDiarizationConfig diarization_config = 19;</code>
     */
    public com.google.cloud.speech.v1.SpeakerDiarizationConfig.Builder
        getDiarizationConfigBuilder() {

      onChanged();
      return getDiarizationConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Config to enable speaker diarization and set additional
     * parameters to make diarization better suited for your application.
     * Note: When this is enabled, we send all the words from the beginning of the
     * audio for the top alternative in every consecutive STREAMING responses.
     * This is done in order to improve our speaker tags as our models learn to
     * identify the speakers in the conversation over time.
     * For non-streaming requests, the diarization results will be provided only
     * in the top alternative of the FINAL SpeechRecognitionResult.
     * </pre>
     *
     * <code>.google.cloud.speech.v1.SpeakerDiarizationConfig diarization_config = 19;</code>
     */
    public com.google.cloud.speech.v1.SpeakerDiarizationConfigOrBuilder
        getDiarizationConfigOrBuilder() {
      if (diarizationConfigBuilder_ != null) {
        return diarizationConfigBuilder_.getMessageOrBuilder();
      } else {
        return diarizationConfig_ == null
            ? com.google.cloud.speech.v1.SpeakerDiarizationConfig.getDefaultInstance()
            : diarizationConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Config to enable speaker diarization and set additional
     * parameters to make diarization better suited for your application.
     * Note: When this is enabled, we send all the words from the beginning of the
     * audio for the top alternative in every consecutive STREAMING responses.
     * This is done in order to improve our speaker tags as our models learn to
     * identify the speakers in the conversation over time.
     * For non-streaming requests, the diarization results will be provided only
     * in the top alternative of the FINAL SpeechRecognitionResult.
     * </pre>
     *
     * <code>.google.cloud.speech.v1.SpeakerDiarizationConfig diarization_config = 19;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v1.SpeakerDiarizationConfig,
            com.google.cloud.speech.v1.SpeakerDiarizationConfig.Builder,
            com.google.cloud.speech.v1.SpeakerDiarizationConfigOrBuilder>
        getDiarizationConfigFieldBuilder() {
      if (diarizationConfigBuilder_ == null) {
        diarizationConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.speech.v1.SpeakerDiarizationConfig,
                com.google.cloud.speech.v1.SpeakerDiarizationConfig.Builder,
                com.google.cloud.speech.v1.SpeakerDiarizationConfigOrBuilder>(
                getDiarizationConfig(), getParentForChildren(), isClean());
        diarizationConfig_ = null;
      }
      return diarizationConfigBuilder_;
    }

    private com.google.cloud.speech.v1.RecognitionMetadata metadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v1.RecognitionMetadata,
            com.google.cloud.speech.v1.RecognitionMetadata.Builder,
            com.google.cloud.speech.v1.RecognitionMetadataOrBuilder>
        metadataBuilder_;
    /**
     *
     *
     * <pre>
     * Metadata regarding this request.
     * </pre>
     *
     * <code>.google.cloud.speech.v1.RecognitionMetadata metadata = 9;</code>
     *
     * @return Whether the metadata field is set.
     */
    public boolean hasMetadata() {
      return metadataBuilder_ != null || metadata_ != null;
    }
    /**
     *
     *
     * <pre>
     * Metadata regarding this request.
     * </pre>
     *
     * <code>.google.cloud.speech.v1.RecognitionMetadata metadata = 9;</code>
     *
     * @return The metadata.
     */
    public com.google.cloud.speech.v1.RecognitionMetadata getMetadata() {
      if (metadataBuilder_ == null) {
        return metadata_ == null
            ? com.google.cloud.speech.v1.RecognitionMetadata.getDefaultInstance()
            : metadata_;
      } else {
        return metadataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata regarding this request.
     * </pre>
     *
     * <code>.google.cloud.speech.v1.RecognitionMetadata metadata = 9;</code>
     */
    public Builder setMetadata(com.google.cloud.speech.v1.RecognitionMetadata value) {
      if (metadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metadata_ = value;
        onChanged();
      } else {
        metadataBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata regarding this request.
     * </pre>
     *
     * <code>.google.cloud.speech.v1.RecognitionMetadata metadata = 9;</code>
     */
    public Builder setMetadata(
        com.google.cloud.speech.v1.RecognitionMetadata.Builder builderForValue) {
      if (metadataBuilder_ == null) {
        metadata_ = builderForValue.build();
        onChanged();
      } else {
        metadataBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata regarding this request.
     * </pre>
     *
     * <code>.google.cloud.speech.v1.RecognitionMetadata metadata = 9;</code>
     */
    public Builder mergeMetadata(com.google.cloud.speech.v1.RecognitionMetadata value) {
      if (metadataBuilder_ == null) {
        if (metadata_ != null) {
          metadata_ =
              com.google.cloud.speech.v1.RecognitionMetadata.newBuilder(metadata_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metadata_ = value;
        }
        onChanged();
      } else {
        metadataBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata regarding this request.
     * </pre>
     *
     * <code>.google.cloud.speech.v1.RecognitionMetadata metadata = 9;</code>
     */
    public Builder clearMetadata() {
      if (metadataBuilder_ == null) {
        metadata_ = null;
        onChanged();
      } else {
        metadata_ = null;
        metadataBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata regarding this request.
     * </pre>
     *
     * <code>.google.cloud.speech.v1.RecognitionMetadata metadata = 9;</code>
     */
    public com.google.cloud.speech.v1.RecognitionMetadata.Builder getMetadataBuilder() {

      onChanged();
      return getMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Metadata regarding this request.
     * </pre>
     *
     * <code>.google.cloud.speech.v1.RecognitionMetadata metadata = 9;</code>
     */
    public com.google.cloud.speech.v1.RecognitionMetadataOrBuilder getMetadataOrBuilder() {
      if (metadataBuilder_ != null) {
        return metadataBuilder_.getMessageOrBuilder();
      } else {
        return metadata_ == null
            ? com.google.cloud.speech.v1.RecognitionMetadata.getDefaultInstance()
            : metadata_;
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata regarding this request.
     * </pre>
     *
     * <code>.google.cloud.speech.v1.RecognitionMetadata metadata = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v1.RecognitionMetadata,
            com.google.cloud.speech.v1.RecognitionMetadata.Builder,
            com.google.cloud.speech.v1.RecognitionMetadataOrBuilder>
        getMetadataFieldBuilder() {
      if (metadataBuilder_ == null) {
        metadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.speech.v1.RecognitionMetadata,
                com.google.cloud.speech.v1.RecognitionMetadata.Builder,
                com.google.cloud.speech.v1.RecognitionMetadataOrBuilder>(
                getMetadata(), getParentForChildren(), isClean());
        metadata_ = null;
      }
      return metadataBuilder_;
    }

    private java.lang.Object model_ = "";
    /**
     *
     *
     * <pre>
     * Which model to select for the given request. Select the model
     * best suited to your domain to get best results. If a model is not
     * explicitly specified, then we auto-select a model based on the parameters
     * in the RecognitionConfig.
     * &lt;table&gt;
     *   &lt;tr&gt;
     *     &lt;td&gt;&lt;b&gt;Model&lt;/b&gt;&lt;/td&gt;
     *     &lt;td&gt;&lt;b&gt;Description&lt;/b&gt;&lt;/td&gt;
     *   &lt;/tr&gt;
     *   &lt;tr&gt;
     *     &lt;td&gt;&lt;code&gt;command_and_search&lt;/code&gt;&lt;/td&gt;
     *     &lt;td&gt;Best for short queries such as voice commands or voice search.&lt;/td&gt;
     *   &lt;/tr&gt;
     *   &lt;tr&gt;
     *     &lt;td&gt;&lt;code&gt;phone_call&lt;/code&gt;&lt;/td&gt;
     *     &lt;td&gt;Best for audio that originated from a phone call (typically
     *     recorded at an 8khz sampling rate).&lt;/td&gt;
     *   &lt;/tr&gt;
     *   &lt;tr&gt;
     *     &lt;td&gt;&lt;code&gt;video&lt;/code&gt;&lt;/td&gt;
     *     &lt;td&gt;Best for audio that originated from from video or includes multiple
     *         speakers. Ideally the audio is recorded at a 16khz or greater
     *         sampling rate. This is a premium model that costs more than the
     *         standard rate.&lt;/td&gt;
     *   &lt;/tr&gt;
     *   &lt;tr&gt;
     *     &lt;td&gt;&lt;code&gt;default&lt;/code&gt;&lt;/td&gt;
     *     &lt;td&gt;Best for audio that is not one of the specific audio models.
     *         For example, long-form audio. Ideally the audio is high-fidelity,
     *         recorded at a 16khz or greater sampling rate.&lt;/td&gt;
     *   &lt;/tr&gt;
     * &lt;/table&gt;
     * </pre>
     *
     * <code>string model = 13;</code>
     *
     * @return The model.
     */
    public java.lang.String getModel() {
      java.lang.Object ref = model_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        model_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Which model to select for the given request. Select the model
     * best suited to your domain to get best results. If a model is not
     * explicitly specified, then we auto-select a model based on the parameters
     * in the RecognitionConfig.
     * &lt;table&gt;
     *   &lt;tr&gt;
     *     &lt;td&gt;&lt;b&gt;Model&lt;/b&gt;&lt;/td&gt;
     *     &lt;td&gt;&lt;b&gt;Description&lt;/b&gt;&lt;/td&gt;
     *   &lt;/tr&gt;
     *   &lt;tr&gt;
     *     &lt;td&gt;&lt;code&gt;command_and_search&lt;/code&gt;&lt;/td&gt;
     *     &lt;td&gt;Best for short queries such as voice commands or voice search.&lt;/td&gt;
     *   &lt;/tr&gt;
     *   &lt;tr&gt;
     *     &lt;td&gt;&lt;code&gt;phone_call&lt;/code&gt;&lt;/td&gt;
     *     &lt;td&gt;Best for audio that originated from a phone call (typically
     *     recorded at an 8khz sampling rate).&lt;/td&gt;
     *   &lt;/tr&gt;
     *   &lt;tr&gt;
     *     &lt;td&gt;&lt;code&gt;video&lt;/code&gt;&lt;/td&gt;
     *     &lt;td&gt;Best for audio that originated from from video or includes multiple
     *         speakers. Ideally the audio is recorded at a 16khz or greater
     *         sampling rate. This is a premium model that costs more than the
     *         standard rate.&lt;/td&gt;
     *   &lt;/tr&gt;
     *   &lt;tr&gt;
     *     &lt;td&gt;&lt;code&gt;default&lt;/code&gt;&lt;/td&gt;
     *     &lt;td&gt;Best for audio that is not one of the specific audio models.
     *         For example, long-form audio. Ideally the audio is high-fidelity,
     *         recorded at a 16khz or greater sampling rate.&lt;/td&gt;
     *   &lt;/tr&gt;
     * &lt;/table&gt;
     * </pre>
     *
     * <code>string model = 13;</code>
     *
     * @return The bytes for model.
     */
    public com.google.protobuf.ByteString getModelBytes() {
      java.lang.Object ref = model_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        model_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Which model to select for the given request. Select the model
     * best suited to your domain to get best results. If a model is not
     * explicitly specified, then we auto-select a model based on the parameters
     * in the RecognitionConfig.
     * &lt;table&gt;
     *   &lt;tr&gt;
     *     &lt;td&gt;&lt;b&gt;Model&lt;/b&gt;&lt;/td&gt;
     *     &lt;td&gt;&lt;b&gt;Description&lt;/b&gt;&lt;/td&gt;
     *   &lt;/tr&gt;
     *   &lt;tr&gt;
     *     &lt;td&gt;&lt;code&gt;command_and_search&lt;/code&gt;&lt;/td&gt;
     *     &lt;td&gt;Best for short queries such as voice commands or voice search.&lt;/td&gt;
     *   &lt;/tr&gt;
     *   &lt;tr&gt;
     *     &lt;td&gt;&lt;code&gt;phone_call&lt;/code&gt;&lt;/td&gt;
     *     &lt;td&gt;Best for audio that originated from a phone call (typically
     *     recorded at an 8khz sampling rate).&lt;/td&gt;
     *   &lt;/tr&gt;
     *   &lt;tr&gt;
     *     &lt;td&gt;&lt;code&gt;video&lt;/code&gt;&lt;/td&gt;
     *     &lt;td&gt;Best for audio that originated from from video or includes multiple
     *         speakers. Ideally the audio is recorded at a 16khz or greater
     *         sampling rate. This is a premium model that costs more than the
     *         standard rate.&lt;/td&gt;
     *   &lt;/tr&gt;
     *   &lt;tr&gt;
     *     &lt;td&gt;&lt;code&gt;default&lt;/code&gt;&lt;/td&gt;
     *     &lt;td&gt;Best for audio that is not one of the specific audio models.
     *         For example, long-form audio. Ideally the audio is high-fidelity,
     *         recorded at a 16khz or greater sampling rate.&lt;/td&gt;
     *   &lt;/tr&gt;
     * &lt;/table&gt;
     * </pre>
     *
     * <code>string model = 13;</code>
     *
     * @param value The model to set.
     * @return This builder for chaining.
     */
    public Builder setModel(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      model_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which model to select for the given request. Select the model
     * best suited to your domain to get best results. If a model is not
     * explicitly specified, then we auto-select a model based on the parameters
     * in the RecognitionConfig.
     * &lt;table&gt;
     *   &lt;tr&gt;
     *     &lt;td&gt;&lt;b&gt;Model&lt;/b&gt;&lt;/td&gt;
     *     &lt;td&gt;&lt;b&gt;Description&lt;/b&gt;&lt;/td&gt;
     *   &lt;/tr&gt;
     *   &lt;tr&gt;
     *     &lt;td&gt;&lt;code&gt;command_and_search&lt;/code&gt;&lt;/td&gt;
     *     &lt;td&gt;Best for short queries such as voice commands or voice search.&lt;/td&gt;
     *   &lt;/tr&gt;
     *   &lt;tr&gt;
     *     &lt;td&gt;&lt;code&gt;phone_call&lt;/code&gt;&lt;/td&gt;
     *     &lt;td&gt;Best for audio that originated from a phone call (typically
     *     recorded at an 8khz sampling rate).&lt;/td&gt;
     *   &lt;/tr&gt;
     *   &lt;tr&gt;
     *     &lt;td&gt;&lt;code&gt;video&lt;/code&gt;&lt;/td&gt;
     *     &lt;td&gt;Best for audio that originated from from video or includes multiple
     *         speakers. Ideally the audio is recorded at a 16khz or greater
     *         sampling rate. This is a premium model that costs more than the
     *         standard rate.&lt;/td&gt;
     *   &lt;/tr&gt;
     *   &lt;tr&gt;
     *     &lt;td&gt;&lt;code&gt;default&lt;/code&gt;&lt;/td&gt;
     *     &lt;td&gt;Best for audio that is not one of the specific audio models.
     *         For example, long-form audio. Ideally the audio is high-fidelity,
     *         recorded at a 16khz or greater sampling rate.&lt;/td&gt;
     *   &lt;/tr&gt;
     * &lt;/table&gt;
     * </pre>
     *
     * <code>string model = 13;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearModel() {

      model_ = getDefaultInstance().getModel();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which model to select for the given request. Select the model
     * best suited to your domain to get best results. If a model is not
     * explicitly specified, then we auto-select a model based on the parameters
     * in the RecognitionConfig.
     * &lt;table&gt;
     *   &lt;tr&gt;
     *     &lt;td&gt;&lt;b&gt;Model&lt;/b&gt;&lt;/td&gt;
     *     &lt;td&gt;&lt;b&gt;Description&lt;/b&gt;&lt;/td&gt;
     *   &lt;/tr&gt;
     *   &lt;tr&gt;
     *     &lt;td&gt;&lt;code&gt;command_and_search&lt;/code&gt;&lt;/td&gt;
     *     &lt;td&gt;Best for short queries such as voice commands or voice search.&lt;/td&gt;
     *   &lt;/tr&gt;
     *   &lt;tr&gt;
     *     &lt;td&gt;&lt;code&gt;phone_call&lt;/code&gt;&lt;/td&gt;
     *     &lt;td&gt;Best for audio that originated from a phone call (typically
     *     recorded at an 8khz sampling rate).&lt;/td&gt;
     *   &lt;/tr&gt;
     *   &lt;tr&gt;
     *     &lt;td&gt;&lt;code&gt;video&lt;/code&gt;&lt;/td&gt;
     *     &lt;td&gt;Best for audio that originated from from video or includes multiple
     *         speakers. Ideally the audio is recorded at a 16khz or greater
     *         sampling rate. This is a premium model that costs more than the
     *         standard rate.&lt;/td&gt;
     *   &lt;/tr&gt;
     *   &lt;tr&gt;
     *     &lt;td&gt;&lt;code&gt;default&lt;/code&gt;&lt;/td&gt;
     *     &lt;td&gt;Best for audio that is not one of the specific audio models.
     *         For example, long-form audio. Ideally the audio is high-fidelity,
     *         recorded at a 16khz or greater sampling rate.&lt;/td&gt;
     *   &lt;/tr&gt;
     * &lt;/table&gt;
     * </pre>
     *
     * <code>string model = 13;</code>
     *
     * @param value The bytes for model to set.
     * @return This builder for chaining.
     */
    public Builder setModelBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      model_ = value;
      onChanged();
      return this;
    }

    private boolean useEnhanced_;
    /**
     *
     *
     * <pre>
     * Set to true to use an enhanced model for speech recognition.
     * If `use_enhanced` is set to true and the `model` field is not set, then
     * an appropriate enhanced model is chosen if an enhanced model exists for
     * the audio.
     * If `use_enhanced` is true and an enhanced version of the specified model
     * does not exist, then the speech is recognized using the standard version
     * of the specified model.
     * </pre>
     *
     * <code>bool use_enhanced = 14;</code>
     *
     * @return The useEnhanced.
     */
    public boolean getUseEnhanced() {
      return useEnhanced_;
    }
    /**
     *
     *
     * <pre>
     * Set to true to use an enhanced model for speech recognition.
     * If `use_enhanced` is set to true and the `model` field is not set, then
     * an appropriate enhanced model is chosen if an enhanced model exists for
     * the audio.
     * If `use_enhanced` is true and an enhanced version of the specified model
     * does not exist, then the speech is recognized using the standard version
     * of the specified model.
     * </pre>
     *
     * <code>bool use_enhanced = 14;</code>
     *
     * @param value The useEnhanced to set.
     * @return This builder for chaining.
     */
    public Builder setUseEnhanced(boolean value) {

      useEnhanced_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set to true to use an enhanced model for speech recognition.
     * If `use_enhanced` is set to true and the `model` field is not set, then
     * an appropriate enhanced model is chosen if an enhanced model exists for
     * the audio.
     * If `use_enhanced` is true and an enhanced version of the specified model
     * does not exist, then the speech is recognized using the standard version
     * of the specified model.
     * </pre>
     *
     * <code>bool use_enhanced = 14;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUseEnhanced() {

      useEnhanced_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.speech.v1.RecognitionConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.speech.v1.RecognitionConfig)
  private static final com.google.cloud.speech.v1.RecognitionConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.speech.v1.RecognitionConfig();
  }

  public static com.google.cloud.speech.v1.RecognitionConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RecognitionConfig> PARSER =
      new com.google.protobuf.AbstractParser<RecognitionConfig>() {
        @java.lang.Override
        public RecognitionConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new RecognitionConfig(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<RecognitionConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RecognitionConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.speech.v1.RecognitionConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
