/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/v1/transaction.proto

// Protobuf Java Version: 3.25.8
package com.google.spanner.v1;

/**
 *
 *
 * <pre>
 * Options to use for transactions.
 * </pre>
 *
 * Protobuf type {@code google.spanner.v1.TransactionOptions}
 */
public final class TransactionOptions extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.v1.TransactionOptions)
    TransactionOptionsOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use TransactionOptions.newBuilder() to construct.
  private TransactionOptions(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TransactionOptions() {
    isolationLevel_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TransactionOptions();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.v1.TransactionProto
        .internal_static_google_spanner_v1_TransactionOptions_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.v1.TransactionProto
        .internal_static_google_spanner_v1_TransactionOptions_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.v1.TransactionOptions.class,
            com.google.spanner.v1.TransactionOptions.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * `IsolationLevel` is used when setting `isolation_level` for a transaction.
   * </pre>
   *
   * Protobuf enum {@code google.spanner.v1.TransactionOptions.IsolationLevel}
   */
  public enum IsolationLevel implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value.
     *
     * If the value is not specified, the `SERIALIZABLE` isolation level is
     * used.
     * </pre>
     *
     * <code>ISOLATION_LEVEL_UNSPECIFIED = 0;</code>
     */
    ISOLATION_LEVEL_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * All transactions appear as if they executed in a serial order, even if
     * some of the reads, writes, and other operations of distinct transactions
     * actually occurred in parallel. Spanner assigns commit timestamps that
     * reflect the order of committed transactions to implement this property.
     * Spanner offers a stronger guarantee than serializability called external
     * consistency. For further details, please refer to
     * https://cloud.google.com/spanner/docs/true-time-external-consistency#serializability.
     * </pre>
     *
     * <code>SERIALIZABLE = 1;</code>
     */
    SERIALIZABLE(1),
    /**
     *
     *
     * <pre>
     * All reads performed during the transaction observe a consistent snapshot
     * of the database, and the transaction is only successfully committed in
     * the absence of conflicts between its updates and any concurrent updates
     * that have occurred since that snapshot. Consequently, in contrast to
     * `SERIALIZABLE` transactions, only write-write conflicts are detected in
     * snapshot transactions.
     *
     * This isolation level does not support Read-only and Partitioned DML
     * transactions.
     *
     * When `REPEATABLE_READ` is specified on a read-write transaction, the
     * locking semantics default to `OPTIMISTIC`.
     * </pre>
     *
     * <code>REPEATABLE_READ = 2;</code>
     */
    REPEATABLE_READ(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value.
     *
     * If the value is not specified, the `SERIALIZABLE` isolation level is
     * used.
     * </pre>
     *
     * <code>ISOLATION_LEVEL_UNSPECIFIED = 0;</code>
     */
    public static final int ISOLATION_LEVEL_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * All transactions appear as if they executed in a serial order, even if
     * some of the reads, writes, and other operations of distinct transactions
     * actually occurred in parallel. Spanner assigns commit timestamps that
     * reflect the order of committed transactions to implement this property.
     * Spanner offers a stronger guarantee than serializability called external
     * consistency. For further details, please refer to
     * https://cloud.google.com/spanner/docs/true-time-external-consistency#serializability.
     * </pre>
     *
     * <code>SERIALIZABLE = 1;</code>
     */
    public static final int SERIALIZABLE_VALUE = 1;

    /**
     *
     *
     * <pre>
     * All reads performed during the transaction observe a consistent snapshot
     * of the database, and the transaction is only successfully committed in
     * the absence of conflicts between its updates and any concurrent updates
     * that have occurred since that snapshot. Consequently, in contrast to
     * `SERIALIZABLE` transactions, only write-write conflicts are detected in
     * snapshot transactions.
     *
     * This isolation level does not support Read-only and Partitioned DML
     * transactions.
     *
     * When `REPEATABLE_READ` is specified on a read-write transaction, the
     * locking semantics default to `OPTIMISTIC`.
     * </pre>
     *
     * <code>REPEATABLE_READ = 2;</code>
     */
    public static final int REPEATABLE_READ_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static IsolationLevel valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static IsolationLevel forNumber(int value) {
      switch (value) {
        case 0:
          return ISOLATION_LEVEL_UNSPECIFIED;
        case 1:
          return SERIALIZABLE;
        case 2:
          return REPEATABLE_READ;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<IsolationLevel> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<IsolationLevel> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<IsolationLevel>() {
          public IsolationLevel findValueByNumber(int number) {
            return IsolationLevel.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.spanner.v1.TransactionOptions.getDescriptor().getEnumTypes().get(0);
    }

    private static final IsolationLevel[] VALUES = values();

    public static IsolationLevel valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private IsolationLevel(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.spanner.v1.TransactionOptions.IsolationLevel)
  }

  public interface ReadWriteOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.spanner.v1.TransactionOptions.ReadWrite)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Read lock mode for the transaction.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.ReadWrite.ReadLockMode read_lock_mode = 1;</code>
     *
     * @return The enum numeric value on the wire for readLockMode.
     */
    int getReadLockModeValue();

    /**
     *
     *
     * <pre>
     * Read lock mode for the transaction.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.ReadWrite.ReadLockMode read_lock_mode = 1;</code>
     *
     * @return The readLockMode.
     */
    com.google.spanner.v1.TransactionOptions.ReadWrite.ReadLockMode getReadLockMode();

    /**
     *
     *
     * <pre>
     * Optional. Clients should pass the transaction ID of the previous
     * transaction attempt that was aborted if this transaction is being
     * executed on a multiplexed session.
     * </pre>
     *
     * <code>
     * bytes multiplexed_session_previous_transaction_id = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The multiplexedSessionPreviousTransactionId.
     */
    com.google.protobuf.ByteString getMultiplexedSessionPreviousTransactionId();
  }

  /**
   *
   *
   * <pre>
   * Message type to initiate a read-write transaction. Currently this
   * transaction type has no options.
   * </pre>
   *
   * Protobuf type {@code google.spanner.v1.TransactionOptions.ReadWrite}
   */
  public static final class ReadWrite extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.spanner.v1.TransactionOptions.ReadWrite)
      ReadWriteOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use ReadWrite.newBuilder() to construct.
    private ReadWrite(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ReadWrite() {
      readLockMode_ = 0;
      multiplexedSessionPreviousTransactionId_ = com.google.protobuf.ByteString.EMPTY;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ReadWrite();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.v1.TransactionProto
          .internal_static_google_spanner_v1_TransactionOptions_ReadWrite_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.v1.TransactionProto
          .internal_static_google_spanner_v1_TransactionOptions_ReadWrite_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.v1.TransactionOptions.ReadWrite.class,
              com.google.spanner.v1.TransactionOptions.ReadWrite.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * `ReadLockMode` is used to set the read lock mode for read-write
     * transactions.
     * </pre>
     *
     * Protobuf enum {@code google.spanner.v1.TransactionOptions.ReadWrite.ReadLockMode}
     */
    public enum ReadLockMode implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Default value.
       *
       * * If isolation level is
       *   [REPEATABLE_READ][google.spanner.v1.TransactionOptions.IsolationLevel.REPEATABLE_READ],
       *   then it is an error to specify `read_lock_mode`. Locking semantics
       *   default to `OPTIMISTIC`. No validation checks are done for reads,
       *   except to validate that the data that was served at the snapshot time
       *   is unchanged at commit time in the following cases:
       *     1. reads done as part of queries that use `SELECT FOR UPDATE`
       *     2. reads done as part of statements with a `LOCK_SCANNED_RANGES`
       *        hint
       *     3. reads done as part of DML statements
       * * At all other isolation levels, if `read_lock_mode` is the default
       *   value, then pessimistic read locks are used.
       * </pre>
       *
       * <code>READ_LOCK_MODE_UNSPECIFIED = 0;</code>
       */
      READ_LOCK_MODE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Pessimistic lock mode.
       *
       * Read locks are acquired immediately on read.
       * Semantics described only applies to
       * [SERIALIZABLE][google.spanner.v1.TransactionOptions.IsolationLevel.SERIALIZABLE]
       * isolation.
       * </pre>
       *
       * <code>PESSIMISTIC = 1;</code>
       */
      PESSIMISTIC(1),
      /**
       *
       *
       * <pre>
       * Optimistic lock mode.
       *
       * Locks for reads within the transaction are not acquired on read.
       * Instead the locks are acquired on a commit to validate that
       * read/queried data has not changed since the transaction started.
       * Semantics described only applies to
       * [SERIALIZABLE][google.spanner.v1.TransactionOptions.IsolationLevel.SERIALIZABLE]
       * isolation.
       * </pre>
       *
       * <code>OPTIMISTIC = 2;</code>
       */
      OPTIMISTIC(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Default value.
       *
       * * If isolation level is
       *   [REPEATABLE_READ][google.spanner.v1.TransactionOptions.IsolationLevel.REPEATABLE_READ],
       *   then it is an error to specify `read_lock_mode`. Locking semantics
       *   default to `OPTIMISTIC`. No validation checks are done for reads,
       *   except to validate that the data that was served at the snapshot time
       *   is unchanged at commit time in the following cases:
       *     1. reads done as part of queries that use `SELECT FOR UPDATE`
       *     2. reads done as part of statements with a `LOCK_SCANNED_RANGES`
       *        hint
       *     3. reads done as part of DML statements
       * * At all other isolation levels, if `read_lock_mode` is the default
       *   value, then pessimistic read locks are used.
       * </pre>
       *
       * <code>READ_LOCK_MODE_UNSPECIFIED = 0;</code>
       */
      public static final int READ_LOCK_MODE_UNSPECIFIED_VALUE = 0;

      /**
       *
       *
       * <pre>
       * Pessimistic lock mode.
       *
       * Read locks are acquired immediately on read.
       * Semantics described only applies to
       * [SERIALIZABLE][google.spanner.v1.TransactionOptions.IsolationLevel.SERIALIZABLE]
       * isolation.
       * </pre>
       *
       * <code>PESSIMISTIC = 1;</code>
       */
      public static final int PESSIMISTIC_VALUE = 1;

      /**
       *
       *
       * <pre>
       * Optimistic lock mode.
       *
       * Locks for reads within the transaction are not acquired on read.
       * Instead the locks are acquired on a commit to validate that
       * read/queried data has not changed since the transaction started.
       * Semantics described only applies to
       * [SERIALIZABLE][google.spanner.v1.TransactionOptions.IsolationLevel.SERIALIZABLE]
       * isolation.
       * </pre>
       *
       * <code>OPTIMISTIC = 2;</code>
       */
      public static final int OPTIMISTIC_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ReadLockMode valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static ReadLockMode forNumber(int value) {
        switch (value) {
          case 0:
            return READ_LOCK_MODE_UNSPECIFIED;
          case 1:
            return PESSIMISTIC;
          case 2:
            return OPTIMISTIC;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<ReadLockMode> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<ReadLockMode> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<ReadLockMode>() {
            public ReadLockMode findValueByNumber(int number) {
              return ReadLockMode.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.spanner.v1.TransactionOptions.ReadWrite.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final ReadLockMode[] VALUES = values();

      public static ReadLockMode valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private ReadLockMode(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.spanner.v1.TransactionOptions.ReadWrite.ReadLockMode)
    }

    public static final int READ_LOCK_MODE_FIELD_NUMBER = 1;
    private int readLockMode_ = 0;

    /**
     *
     *
     * <pre>
     * Read lock mode for the transaction.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.ReadWrite.ReadLockMode read_lock_mode = 1;</code>
     *
     * @return The enum numeric value on the wire for readLockMode.
     */
    @java.lang.Override
    public int getReadLockModeValue() {
      return readLockMode_;
    }

    /**
     *
     *
     * <pre>
     * Read lock mode for the transaction.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.ReadWrite.ReadLockMode read_lock_mode = 1;</code>
     *
     * @return The readLockMode.
     */
    @java.lang.Override
    public com.google.spanner.v1.TransactionOptions.ReadWrite.ReadLockMode getReadLockMode() {
      com.google.spanner.v1.TransactionOptions.ReadWrite.ReadLockMode result =
          com.google.spanner.v1.TransactionOptions.ReadWrite.ReadLockMode.forNumber(readLockMode_);
      return result == null
          ? com.google.spanner.v1.TransactionOptions.ReadWrite.ReadLockMode.UNRECOGNIZED
          : result;
    }

    public static final int MULTIPLEXED_SESSION_PREVIOUS_TRANSACTION_ID_FIELD_NUMBER = 2;
    private com.google.protobuf.ByteString multiplexedSessionPreviousTransactionId_ =
        com.google.protobuf.ByteString.EMPTY;

    /**
     *
     *
     * <pre>
     * Optional. Clients should pass the transaction ID of the previous
     * transaction attempt that was aborted if this transaction is being
     * executed on a multiplexed session.
     * </pre>
     *
     * <code>
     * bytes multiplexed_session_previous_transaction_id = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The multiplexedSessionPreviousTransactionId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getMultiplexedSessionPreviousTransactionId() {
      return multiplexedSessionPreviousTransactionId_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (readLockMode_
          != com.google.spanner.v1.TransactionOptions.ReadWrite.ReadLockMode
              .READ_LOCK_MODE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, readLockMode_);
      }
      if (!multiplexedSessionPreviousTransactionId_.isEmpty()) {
        output.writeBytes(2, multiplexedSessionPreviousTransactionId_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (readLockMode_
          != com.google.spanner.v1.TransactionOptions.ReadWrite.ReadLockMode
              .READ_LOCK_MODE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, readLockMode_);
      }
      if (!multiplexedSessionPreviousTransactionId_.isEmpty()) {
        size +=
            com.google.protobuf.CodedOutputStream.computeBytesSize(
                2, multiplexedSessionPreviousTransactionId_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.spanner.v1.TransactionOptions.ReadWrite)) {
        return super.equals(obj);
      }
      com.google.spanner.v1.TransactionOptions.ReadWrite other =
          (com.google.spanner.v1.TransactionOptions.ReadWrite) obj;

      if (readLockMode_ != other.readLockMode_) return false;
      if (!getMultiplexedSessionPreviousTransactionId()
          .equals(other.getMultiplexedSessionPreviousTransactionId())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + READ_LOCK_MODE_FIELD_NUMBER;
      hash = (53 * hash) + readLockMode_;
      hash = (37 * hash) + MULTIPLEXED_SESSION_PREVIOUS_TRANSACTION_ID_FIELD_NUMBER;
      hash = (53 * hash) + getMultiplexedSessionPreviousTransactionId().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.spanner.v1.TransactionOptions.ReadWrite parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.TransactionOptions.ReadWrite parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.TransactionOptions.ReadWrite parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.TransactionOptions.ReadWrite parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.TransactionOptions.ReadWrite parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.TransactionOptions.ReadWrite parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.TransactionOptions.ReadWrite parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.TransactionOptions.ReadWrite parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.spanner.v1.TransactionOptions.ReadWrite parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.TransactionOptions.ReadWrite parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.spanner.v1.TransactionOptions.ReadWrite parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.TransactionOptions.ReadWrite parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.spanner.v1.TransactionOptions.ReadWrite prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Message type to initiate a read-write transaction. Currently this
     * transaction type has no options.
     * </pre>
     *
     * Protobuf type {@code google.spanner.v1.TransactionOptions.ReadWrite}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.spanner.v1.TransactionOptions.ReadWrite)
        com.google.spanner.v1.TransactionOptions.ReadWriteOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.spanner.v1.TransactionProto
            .internal_static_google_spanner_v1_TransactionOptions_ReadWrite_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.spanner.v1.TransactionProto
            .internal_static_google_spanner_v1_TransactionOptions_ReadWrite_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.spanner.v1.TransactionOptions.ReadWrite.class,
                com.google.spanner.v1.TransactionOptions.ReadWrite.Builder.class);
      }

      // Construct using com.google.spanner.v1.TransactionOptions.ReadWrite.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        readLockMode_ = 0;
        multiplexedSessionPreviousTransactionId_ = com.google.protobuf.ByteString.EMPTY;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.spanner.v1.TransactionProto
            .internal_static_google_spanner_v1_TransactionOptions_ReadWrite_descriptor;
      }

      @java.lang.Override
      public com.google.spanner.v1.TransactionOptions.ReadWrite getDefaultInstanceForType() {
        return com.google.spanner.v1.TransactionOptions.ReadWrite.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.spanner.v1.TransactionOptions.ReadWrite build() {
        com.google.spanner.v1.TransactionOptions.ReadWrite result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.spanner.v1.TransactionOptions.ReadWrite buildPartial() {
        com.google.spanner.v1.TransactionOptions.ReadWrite result =
            new com.google.spanner.v1.TransactionOptions.ReadWrite(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.spanner.v1.TransactionOptions.ReadWrite result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.readLockMode_ = readLockMode_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.multiplexedSessionPreviousTransactionId_ =
              multiplexedSessionPreviousTransactionId_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.spanner.v1.TransactionOptions.ReadWrite) {
          return mergeFrom((com.google.spanner.v1.TransactionOptions.ReadWrite) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.spanner.v1.TransactionOptions.ReadWrite other) {
        if (other == com.google.spanner.v1.TransactionOptions.ReadWrite.getDefaultInstance())
          return this;
        if (other.readLockMode_ != 0) {
          setReadLockModeValue(other.getReadLockModeValue());
        }
        if (other.getMultiplexedSessionPreviousTransactionId()
            != com.google.protobuf.ByteString.EMPTY) {
          setMultiplexedSessionPreviousTransactionId(
              other.getMultiplexedSessionPreviousTransactionId());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  readLockMode_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  multiplexedSessionPreviousTransactionId_ = input.readBytes();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int readLockMode_ = 0;

      /**
       *
       *
       * <pre>
       * Read lock mode for the transaction.
       * </pre>
       *
       * <code>.google.spanner.v1.TransactionOptions.ReadWrite.ReadLockMode read_lock_mode = 1;
       * </code>
       *
       * @return The enum numeric value on the wire for readLockMode.
       */
      @java.lang.Override
      public int getReadLockModeValue() {
        return readLockMode_;
      }

      /**
       *
       *
       * <pre>
       * Read lock mode for the transaction.
       * </pre>
       *
       * <code>.google.spanner.v1.TransactionOptions.ReadWrite.ReadLockMode read_lock_mode = 1;
       * </code>
       *
       * @param value The enum numeric value on the wire for readLockMode to set.
       * @return This builder for chaining.
       */
      public Builder setReadLockModeValue(int value) {
        readLockMode_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Read lock mode for the transaction.
       * </pre>
       *
       * <code>.google.spanner.v1.TransactionOptions.ReadWrite.ReadLockMode read_lock_mode = 1;
       * </code>
       *
       * @return The readLockMode.
       */
      @java.lang.Override
      public com.google.spanner.v1.TransactionOptions.ReadWrite.ReadLockMode getReadLockMode() {
        com.google.spanner.v1.TransactionOptions.ReadWrite.ReadLockMode result =
            com.google.spanner.v1.TransactionOptions.ReadWrite.ReadLockMode.forNumber(
                readLockMode_);
        return result == null
            ? com.google.spanner.v1.TransactionOptions.ReadWrite.ReadLockMode.UNRECOGNIZED
            : result;
      }

      /**
       *
       *
       * <pre>
       * Read lock mode for the transaction.
       * </pre>
       *
       * <code>.google.spanner.v1.TransactionOptions.ReadWrite.ReadLockMode read_lock_mode = 1;
       * </code>
       *
       * @param value The readLockMode to set.
       * @return This builder for chaining.
       */
      public Builder setReadLockMode(
          com.google.spanner.v1.TransactionOptions.ReadWrite.ReadLockMode value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        readLockMode_ = value.getNumber();
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Read lock mode for the transaction.
       * </pre>
       *
       * <code>.google.spanner.v1.TransactionOptions.ReadWrite.ReadLockMode read_lock_mode = 1;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearReadLockMode() {
        bitField0_ = (bitField0_ & ~0x00000001);
        readLockMode_ = 0;
        onChanged();
        return this;
      }

      private com.google.protobuf.ByteString multiplexedSessionPreviousTransactionId_ =
          com.google.protobuf.ByteString.EMPTY;

      /**
       *
       *
       * <pre>
       * Optional. Clients should pass the transaction ID of the previous
       * transaction attempt that was aborted if this transaction is being
       * executed on a multiplexed session.
       * </pre>
       *
       * <code>
       * bytes multiplexed_session_previous_transaction_id = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The multiplexedSessionPreviousTransactionId.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getMultiplexedSessionPreviousTransactionId() {
        return multiplexedSessionPreviousTransactionId_;
      }

      /**
       *
       *
       * <pre>
       * Optional. Clients should pass the transaction ID of the previous
       * transaction attempt that was aborted if this transaction is being
       * executed on a multiplexed session.
       * </pre>
       *
       * <code>
       * bytes multiplexed_session_previous_transaction_id = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The multiplexedSessionPreviousTransactionId to set.
       * @return This builder for chaining.
       */
      public Builder setMultiplexedSessionPreviousTransactionId(
          com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        multiplexedSessionPreviousTransactionId_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Clients should pass the transaction ID of the previous
       * transaction attempt that was aborted if this transaction is being
       * executed on a multiplexed session.
       * </pre>
       *
       * <code>
       * bytes multiplexed_session_previous_transaction_id = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMultiplexedSessionPreviousTransactionId() {
        bitField0_ = (bitField0_ & ~0x00000002);
        multiplexedSessionPreviousTransactionId_ =
            getDefaultInstance().getMultiplexedSessionPreviousTransactionId();
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.spanner.v1.TransactionOptions.ReadWrite)
    }

    // @@protoc_insertion_point(class_scope:google.spanner.v1.TransactionOptions.ReadWrite)
    private static final com.google.spanner.v1.TransactionOptions.ReadWrite DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.spanner.v1.TransactionOptions.ReadWrite();
    }

    public static com.google.spanner.v1.TransactionOptions.ReadWrite getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ReadWrite> PARSER =
        new com.google.protobuf.AbstractParser<ReadWrite>() {
          @java.lang.Override
          public ReadWrite parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ReadWrite> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ReadWrite> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.spanner.v1.TransactionOptions.ReadWrite getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface PartitionedDmlOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.spanner.v1.TransactionOptions.PartitionedDml)
      com.google.protobuf.MessageOrBuilder {}

  /**
   *
   *
   * <pre>
   * Message type to initiate a Partitioned DML transaction.
   * </pre>
   *
   * Protobuf type {@code google.spanner.v1.TransactionOptions.PartitionedDml}
   */
  public static final class PartitionedDml extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.spanner.v1.TransactionOptions.PartitionedDml)
      PartitionedDmlOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use PartitionedDml.newBuilder() to construct.
    private PartitionedDml(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PartitionedDml() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PartitionedDml();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.v1.TransactionProto
          .internal_static_google_spanner_v1_TransactionOptions_PartitionedDml_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.v1.TransactionProto
          .internal_static_google_spanner_v1_TransactionOptions_PartitionedDml_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.v1.TransactionOptions.PartitionedDml.class,
              com.google.spanner.v1.TransactionOptions.PartitionedDml.Builder.class);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.spanner.v1.TransactionOptions.PartitionedDml)) {
        return super.equals(obj);
      }
      com.google.spanner.v1.TransactionOptions.PartitionedDml other =
          (com.google.spanner.v1.TransactionOptions.PartitionedDml) obj;

      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.spanner.v1.TransactionOptions.PartitionedDml parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.TransactionOptions.PartitionedDml parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.TransactionOptions.PartitionedDml parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.TransactionOptions.PartitionedDml parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.TransactionOptions.PartitionedDml parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.TransactionOptions.PartitionedDml parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.TransactionOptions.PartitionedDml parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.TransactionOptions.PartitionedDml parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.spanner.v1.TransactionOptions.PartitionedDml parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.TransactionOptions.PartitionedDml parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.spanner.v1.TransactionOptions.PartitionedDml parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.TransactionOptions.PartitionedDml parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.spanner.v1.TransactionOptions.PartitionedDml prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Message type to initiate a Partitioned DML transaction.
     * </pre>
     *
     * Protobuf type {@code google.spanner.v1.TransactionOptions.PartitionedDml}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.spanner.v1.TransactionOptions.PartitionedDml)
        com.google.spanner.v1.TransactionOptions.PartitionedDmlOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.spanner.v1.TransactionProto
            .internal_static_google_spanner_v1_TransactionOptions_PartitionedDml_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.spanner.v1.TransactionProto
            .internal_static_google_spanner_v1_TransactionOptions_PartitionedDml_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.spanner.v1.TransactionOptions.PartitionedDml.class,
                com.google.spanner.v1.TransactionOptions.PartitionedDml.Builder.class);
      }

      // Construct using com.google.spanner.v1.TransactionOptions.PartitionedDml.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.spanner.v1.TransactionProto
            .internal_static_google_spanner_v1_TransactionOptions_PartitionedDml_descriptor;
      }

      @java.lang.Override
      public com.google.spanner.v1.TransactionOptions.PartitionedDml getDefaultInstanceForType() {
        return com.google.spanner.v1.TransactionOptions.PartitionedDml.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.spanner.v1.TransactionOptions.PartitionedDml build() {
        com.google.spanner.v1.TransactionOptions.PartitionedDml result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.spanner.v1.TransactionOptions.PartitionedDml buildPartial() {
        com.google.spanner.v1.TransactionOptions.PartitionedDml result =
            new com.google.spanner.v1.TransactionOptions.PartitionedDml(this);
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.spanner.v1.TransactionOptions.PartitionedDml) {
          return mergeFrom((com.google.spanner.v1.TransactionOptions.PartitionedDml) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.spanner.v1.TransactionOptions.PartitionedDml other) {
        if (other == com.google.spanner.v1.TransactionOptions.PartitionedDml.getDefaultInstance())
          return this;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.spanner.v1.TransactionOptions.PartitionedDml)
    }

    // @@protoc_insertion_point(class_scope:google.spanner.v1.TransactionOptions.PartitionedDml)
    private static final com.google.spanner.v1.TransactionOptions.PartitionedDml DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.spanner.v1.TransactionOptions.PartitionedDml();
    }

    public static com.google.spanner.v1.TransactionOptions.PartitionedDml getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PartitionedDml> PARSER =
        new com.google.protobuf.AbstractParser<PartitionedDml>() {
          @java.lang.Override
          public PartitionedDml parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PartitionedDml> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PartitionedDml> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.spanner.v1.TransactionOptions.PartitionedDml getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ReadOnlyOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.spanner.v1.TransactionOptions.ReadOnly)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Read at a timestamp where all previously committed transactions
     * are visible.
     * </pre>
     *
     * <code>bool strong = 1;</code>
     *
     * @return Whether the strong field is set.
     */
    boolean hasStrong();

    /**
     *
     *
     * <pre>
     * Read at a timestamp where all previously committed transactions
     * are visible.
     * </pre>
     *
     * <code>bool strong = 1;</code>
     *
     * @return The strong.
     */
    boolean getStrong();

    /**
     *
     *
     * <pre>
     * Executes all reads at a timestamp &gt;= `min_read_timestamp`.
     *
     * This is useful for requesting fresher data than some previous
     * read, or data that is fresh enough to observe the effects of some
     * previously committed transaction whose timestamp is known.
     *
     * Note that this option can only be used in single-use transactions.
     *
     * A timestamp in RFC3339 UTC &#92;"Zulu&#92;" format, accurate to nanoseconds.
     * Example: `"2014-10-02T15:01:23.045123456Z"`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp min_read_timestamp = 2;</code>
     *
     * @return Whether the minReadTimestamp field is set.
     */
    boolean hasMinReadTimestamp();

    /**
     *
     *
     * <pre>
     * Executes all reads at a timestamp &gt;= `min_read_timestamp`.
     *
     * This is useful for requesting fresher data than some previous
     * read, or data that is fresh enough to observe the effects of some
     * previously committed transaction whose timestamp is known.
     *
     * Note that this option can only be used in single-use transactions.
     *
     * A timestamp in RFC3339 UTC &#92;"Zulu&#92;" format, accurate to nanoseconds.
     * Example: `"2014-10-02T15:01:23.045123456Z"`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp min_read_timestamp = 2;</code>
     *
     * @return The minReadTimestamp.
     */
    com.google.protobuf.Timestamp getMinReadTimestamp();

    /**
     *
     *
     * <pre>
     * Executes all reads at a timestamp &gt;= `min_read_timestamp`.
     *
     * This is useful for requesting fresher data than some previous
     * read, or data that is fresh enough to observe the effects of some
     * previously committed transaction whose timestamp is known.
     *
     * Note that this option can only be used in single-use transactions.
     *
     * A timestamp in RFC3339 UTC &#92;"Zulu&#92;" format, accurate to nanoseconds.
     * Example: `"2014-10-02T15:01:23.045123456Z"`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp min_read_timestamp = 2;</code>
     */
    com.google.protobuf.TimestampOrBuilder getMinReadTimestampOrBuilder();

    /**
     *
     *
     * <pre>
     * Read data at a timestamp &gt;= `NOW - max_staleness`
     * seconds. Guarantees that all writes that have committed more
     * than the specified number of seconds ago are visible. Because
     * Cloud Spanner chooses the exact timestamp, this mode works even if
     * the client's local clock is substantially skewed from Cloud Spanner
     * commit timestamps.
     *
     * Useful for reading the freshest data available at a nearby
     * replica, while bounding the possible staleness if the local
     * replica has fallen behind.
     *
     * Note that this option can only be used in single-use
     * transactions.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_staleness = 3;</code>
     *
     * @return Whether the maxStaleness field is set.
     */
    boolean hasMaxStaleness();

    /**
     *
     *
     * <pre>
     * Read data at a timestamp &gt;= `NOW - max_staleness`
     * seconds. Guarantees that all writes that have committed more
     * than the specified number of seconds ago are visible. Because
     * Cloud Spanner chooses the exact timestamp, this mode works even if
     * the client's local clock is substantially skewed from Cloud Spanner
     * commit timestamps.
     *
     * Useful for reading the freshest data available at a nearby
     * replica, while bounding the possible staleness if the local
     * replica has fallen behind.
     *
     * Note that this option can only be used in single-use
     * transactions.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_staleness = 3;</code>
     *
     * @return The maxStaleness.
     */
    com.google.protobuf.Duration getMaxStaleness();

    /**
     *
     *
     * <pre>
     * Read data at a timestamp &gt;= `NOW - max_staleness`
     * seconds. Guarantees that all writes that have committed more
     * than the specified number of seconds ago are visible. Because
     * Cloud Spanner chooses the exact timestamp, this mode works even if
     * the client's local clock is substantially skewed from Cloud Spanner
     * commit timestamps.
     *
     * Useful for reading the freshest data available at a nearby
     * replica, while bounding the possible staleness if the local
     * replica has fallen behind.
     *
     * Note that this option can only be used in single-use
     * transactions.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_staleness = 3;</code>
     */
    com.google.protobuf.DurationOrBuilder getMaxStalenessOrBuilder();

    /**
     *
     *
     * <pre>
     * Executes all reads at the given timestamp. Unlike other modes,
     * reads at a specific timestamp are repeatable; the same read at
     * the same timestamp always returns the same data. If the
     * timestamp is in the future, the read is blocked until the
     * specified timestamp, modulo the read's deadline.
     *
     * Useful for large scale consistent reads such as mapreduces, or
     * for coordinating many reads against a consistent snapshot of the
     * data.
     *
     * A timestamp in RFC3339 UTC &#92;"Zulu&#92;" format, accurate to nanoseconds.
     * Example: `"2014-10-02T15:01:23.045123456Z"`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_timestamp = 4;</code>
     *
     * @return Whether the readTimestamp field is set.
     */
    boolean hasReadTimestamp();

    /**
     *
     *
     * <pre>
     * Executes all reads at the given timestamp. Unlike other modes,
     * reads at a specific timestamp are repeatable; the same read at
     * the same timestamp always returns the same data. If the
     * timestamp is in the future, the read is blocked until the
     * specified timestamp, modulo the read's deadline.
     *
     * Useful for large scale consistent reads such as mapreduces, or
     * for coordinating many reads against a consistent snapshot of the
     * data.
     *
     * A timestamp in RFC3339 UTC &#92;"Zulu&#92;" format, accurate to nanoseconds.
     * Example: `"2014-10-02T15:01:23.045123456Z"`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_timestamp = 4;</code>
     *
     * @return The readTimestamp.
     */
    com.google.protobuf.Timestamp getReadTimestamp();

    /**
     *
     *
     * <pre>
     * Executes all reads at the given timestamp. Unlike other modes,
     * reads at a specific timestamp are repeatable; the same read at
     * the same timestamp always returns the same data. If the
     * timestamp is in the future, the read is blocked until the
     * specified timestamp, modulo the read's deadline.
     *
     * Useful for large scale consistent reads such as mapreduces, or
     * for coordinating many reads against a consistent snapshot of the
     * data.
     *
     * A timestamp in RFC3339 UTC &#92;"Zulu&#92;" format, accurate to nanoseconds.
     * Example: `"2014-10-02T15:01:23.045123456Z"`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_timestamp = 4;</code>
     */
    com.google.protobuf.TimestampOrBuilder getReadTimestampOrBuilder();

    /**
     *
     *
     * <pre>
     * Executes all reads at a timestamp that is `exact_staleness`
     * old. The timestamp is chosen soon after the read is started.
     *
     * Guarantees that all writes that have committed more than the
     * specified number of seconds ago are visible. Because Cloud Spanner
     * chooses the exact timestamp, this mode works even if the client's
     * local clock is substantially skewed from Cloud Spanner commit
     * timestamps.
     *
     * Useful for reading at nearby replicas without the distributed
     * timestamp negotiation overhead of `max_staleness`.
     * </pre>
     *
     * <code>.google.protobuf.Duration exact_staleness = 5;</code>
     *
     * @return Whether the exactStaleness field is set.
     */
    boolean hasExactStaleness();

    /**
     *
     *
     * <pre>
     * Executes all reads at a timestamp that is `exact_staleness`
     * old. The timestamp is chosen soon after the read is started.
     *
     * Guarantees that all writes that have committed more than the
     * specified number of seconds ago are visible. Because Cloud Spanner
     * chooses the exact timestamp, this mode works even if the client's
     * local clock is substantially skewed from Cloud Spanner commit
     * timestamps.
     *
     * Useful for reading at nearby replicas without the distributed
     * timestamp negotiation overhead of `max_staleness`.
     * </pre>
     *
     * <code>.google.protobuf.Duration exact_staleness = 5;</code>
     *
     * @return The exactStaleness.
     */
    com.google.protobuf.Duration getExactStaleness();

    /**
     *
     *
     * <pre>
     * Executes all reads at a timestamp that is `exact_staleness`
     * old. The timestamp is chosen soon after the read is started.
     *
     * Guarantees that all writes that have committed more than the
     * specified number of seconds ago are visible. Because Cloud Spanner
     * chooses the exact timestamp, this mode works even if the client's
     * local clock is substantially skewed from Cloud Spanner commit
     * timestamps.
     *
     * Useful for reading at nearby replicas without the distributed
     * timestamp negotiation overhead of `max_staleness`.
     * </pre>
     *
     * <code>.google.protobuf.Duration exact_staleness = 5;</code>
     */
    com.google.protobuf.DurationOrBuilder getExactStalenessOrBuilder();

    /**
     *
     *
     * <pre>
     * If true, the Cloud Spanner-selected read timestamp is included in
     * the [Transaction][google.spanner.v1.Transaction] message that describes
     * the transaction.
     * </pre>
     *
     * <code>bool return_read_timestamp = 6;</code>
     *
     * @return The returnReadTimestamp.
     */
    boolean getReturnReadTimestamp();

    com.google.spanner.v1.TransactionOptions.ReadOnly.TimestampBoundCase getTimestampBoundCase();
  }

  /**
   *
   *
   * <pre>
   * Message type to initiate a read-only transaction.
   * </pre>
   *
   * Protobuf type {@code google.spanner.v1.TransactionOptions.ReadOnly}
   */
  public static final class ReadOnly extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.spanner.v1.TransactionOptions.ReadOnly)
      ReadOnlyOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use ReadOnly.newBuilder() to construct.
    private ReadOnly(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ReadOnly() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ReadOnly();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.v1.TransactionProto
          .internal_static_google_spanner_v1_TransactionOptions_ReadOnly_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.v1.TransactionProto
          .internal_static_google_spanner_v1_TransactionOptions_ReadOnly_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.v1.TransactionOptions.ReadOnly.class,
              com.google.spanner.v1.TransactionOptions.ReadOnly.Builder.class);
    }

    private int timestampBoundCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object timestampBound_;

    public enum TimestampBoundCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      STRONG(1),
      MIN_READ_TIMESTAMP(2),
      MAX_STALENESS(3),
      READ_TIMESTAMP(4),
      EXACT_STALENESS(5),
      TIMESTAMPBOUND_NOT_SET(0);
      private final int value;

      private TimestampBoundCase(int value) {
        this.value = value;
      }

      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static TimestampBoundCase valueOf(int value) {
        return forNumber(value);
      }

      public static TimestampBoundCase forNumber(int value) {
        switch (value) {
          case 1:
            return STRONG;
          case 2:
            return MIN_READ_TIMESTAMP;
          case 3:
            return MAX_STALENESS;
          case 4:
            return READ_TIMESTAMP;
          case 5:
            return EXACT_STALENESS;
          case 0:
            return TIMESTAMPBOUND_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public TimestampBoundCase getTimestampBoundCase() {
      return TimestampBoundCase.forNumber(timestampBoundCase_);
    }

    public static final int STRONG_FIELD_NUMBER = 1;

    /**
     *
     *
     * <pre>
     * Read at a timestamp where all previously committed transactions
     * are visible.
     * </pre>
     *
     * <code>bool strong = 1;</code>
     *
     * @return Whether the strong field is set.
     */
    @java.lang.Override
    public boolean hasStrong() {
      return timestampBoundCase_ == 1;
    }

    /**
     *
     *
     * <pre>
     * Read at a timestamp where all previously committed transactions
     * are visible.
     * </pre>
     *
     * <code>bool strong = 1;</code>
     *
     * @return The strong.
     */
    @java.lang.Override
    public boolean getStrong() {
      if (timestampBoundCase_ == 1) {
        return (java.lang.Boolean) timestampBound_;
      }
      return false;
    }

    public static final int MIN_READ_TIMESTAMP_FIELD_NUMBER = 2;

    /**
     *
     *
     * <pre>
     * Executes all reads at a timestamp &gt;= `min_read_timestamp`.
     *
     * This is useful for requesting fresher data than some previous
     * read, or data that is fresh enough to observe the effects of some
     * previously committed transaction whose timestamp is known.
     *
     * Note that this option can only be used in single-use transactions.
     *
     * A timestamp in RFC3339 UTC &#92;"Zulu&#92;" format, accurate to nanoseconds.
     * Example: `"2014-10-02T15:01:23.045123456Z"`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp min_read_timestamp = 2;</code>
     *
     * @return Whether the minReadTimestamp field is set.
     */
    @java.lang.Override
    public boolean hasMinReadTimestamp() {
      return timestampBoundCase_ == 2;
    }

    /**
     *
     *
     * <pre>
     * Executes all reads at a timestamp &gt;= `min_read_timestamp`.
     *
     * This is useful for requesting fresher data than some previous
     * read, or data that is fresh enough to observe the effects of some
     * previously committed transaction whose timestamp is known.
     *
     * Note that this option can only be used in single-use transactions.
     *
     * A timestamp in RFC3339 UTC &#92;"Zulu&#92;" format, accurate to nanoseconds.
     * Example: `"2014-10-02T15:01:23.045123456Z"`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp min_read_timestamp = 2;</code>
     *
     * @return The minReadTimestamp.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getMinReadTimestamp() {
      if (timestampBoundCase_ == 2) {
        return (com.google.protobuf.Timestamp) timestampBound_;
      }
      return com.google.protobuf.Timestamp.getDefaultInstance();
    }

    /**
     *
     *
     * <pre>
     * Executes all reads at a timestamp &gt;= `min_read_timestamp`.
     *
     * This is useful for requesting fresher data than some previous
     * read, or data that is fresh enough to observe the effects of some
     * previously committed transaction whose timestamp is known.
     *
     * Note that this option can only be used in single-use transactions.
     *
     * A timestamp in RFC3339 UTC &#92;"Zulu&#92;" format, accurate to nanoseconds.
     * Example: `"2014-10-02T15:01:23.045123456Z"`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp min_read_timestamp = 2;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getMinReadTimestampOrBuilder() {
      if (timestampBoundCase_ == 2) {
        return (com.google.protobuf.Timestamp) timestampBound_;
      }
      return com.google.protobuf.Timestamp.getDefaultInstance();
    }

    public static final int MAX_STALENESS_FIELD_NUMBER = 3;

    /**
     *
     *
     * <pre>
     * Read data at a timestamp &gt;= `NOW - max_staleness`
     * seconds. Guarantees that all writes that have committed more
     * than the specified number of seconds ago are visible. Because
     * Cloud Spanner chooses the exact timestamp, this mode works even if
     * the client's local clock is substantially skewed from Cloud Spanner
     * commit timestamps.
     *
     * Useful for reading the freshest data available at a nearby
     * replica, while bounding the possible staleness if the local
     * replica has fallen behind.
     *
     * Note that this option can only be used in single-use
     * transactions.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_staleness = 3;</code>
     *
     * @return Whether the maxStaleness field is set.
     */
    @java.lang.Override
    public boolean hasMaxStaleness() {
      return timestampBoundCase_ == 3;
    }

    /**
     *
     *
     * <pre>
     * Read data at a timestamp &gt;= `NOW - max_staleness`
     * seconds. Guarantees that all writes that have committed more
     * than the specified number of seconds ago are visible. Because
     * Cloud Spanner chooses the exact timestamp, this mode works even if
     * the client's local clock is substantially skewed from Cloud Spanner
     * commit timestamps.
     *
     * Useful for reading the freshest data available at a nearby
     * replica, while bounding the possible staleness if the local
     * replica has fallen behind.
     *
     * Note that this option can only be used in single-use
     * transactions.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_staleness = 3;</code>
     *
     * @return The maxStaleness.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getMaxStaleness() {
      if (timestampBoundCase_ == 3) {
        return (com.google.protobuf.Duration) timestampBound_;
      }
      return com.google.protobuf.Duration.getDefaultInstance();
    }

    /**
     *
     *
     * <pre>
     * Read data at a timestamp &gt;= `NOW - max_staleness`
     * seconds. Guarantees that all writes that have committed more
     * than the specified number of seconds ago are visible. Because
     * Cloud Spanner chooses the exact timestamp, this mode works even if
     * the client's local clock is substantially skewed from Cloud Spanner
     * commit timestamps.
     *
     * Useful for reading the freshest data available at a nearby
     * replica, while bounding the possible staleness if the local
     * replica has fallen behind.
     *
     * Note that this option can only be used in single-use
     * transactions.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_staleness = 3;</code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getMaxStalenessOrBuilder() {
      if (timestampBoundCase_ == 3) {
        return (com.google.protobuf.Duration) timestampBound_;
      }
      return com.google.protobuf.Duration.getDefaultInstance();
    }

    public static final int READ_TIMESTAMP_FIELD_NUMBER = 4;

    /**
     *
     *
     * <pre>
     * Executes all reads at the given timestamp. Unlike other modes,
     * reads at a specific timestamp are repeatable; the same read at
     * the same timestamp always returns the same data. If the
     * timestamp is in the future, the read is blocked until the
     * specified timestamp, modulo the read's deadline.
     *
     * Useful for large scale consistent reads such as mapreduces, or
     * for coordinating many reads against a consistent snapshot of the
     * data.
     *
     * A timestamp in RFC3339 UTC &#92;"Zulu&#92;" format, accurate to nanoseconds.
     * Example: `"2014-10-02T15:01:23.045123456Z"`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_timestamp = 4;</code>
     *
     * @return Whether the readTimestamp field is set.
     */
    @java.lang.Override
    public boolean hasReadTimestamp() {
      return timestampBoundCase_ == 4;
    }

    /**
     *
     *
     * <pre>
     * Executes all reads at the given timestamp. Unlike other modes,
     * reads at a specific timestamp are repeatable; the same read at
     * the same timestamp always returns the same data. If the
     * timestamp is in the future, the read is blocked until the
     * specified timestamp, modulo the read's deadline.
     *
     * Useful for large scale consistent reads such as mapreduces, or
     * for coordinating many reads against a consistent snapshot of the
     * data.
     *
     * A timestamp in RFC3339 UTC &#92;"Zulu&#92;" format, accurate to nanoseconds.
     * Example: `"2014-10-02T15:01:23.045123456Z"`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_timestamp = 4;</code>
     *
     * @return The readTimestamp.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getReadTimestamp() {
      if (timestampBoundCase_ == 4) {
        return (com.google.protobuf.Timestamp) timestampBound_;
      }
      return com.google.protobuf.Timestamp.getDefaultInstance();
    }

    /**
     *
     *
     * <pre>
     * Executes all reads at the given timestamp. Unlike other modes,
     * reads at a specific timestamp are repeatable; the same read at
     * the same timestamp always returns the same data. If the
     * timestamp is in the future, the read is blocked until the
     * specified timestamp, modulo the read's deadline.
     *
     * Useful for large scale consistent reads such as mapreduces, or
     * for coordinating many reads against a consistent snapshot of the
     * data.
     *
     * A timestamp in RFC3339 UTC &#92;"Zulu&#92;" format, accurate to nanoseconds.
     * Example: `"2014-10-02T15:01:23.045123456Z"`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_timestamp = 4;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getReadTimestampOrBuilder() {
      if (timestampBoundCase_ == 4) {
        return (com.google.protobuf.Timestamp) timestampBound_;
      }
      return com.google.protobuf.Timestamp.getDefaultInstance();
    }

    public static final int EXACT_STALENESS_FIELD_NUMBER = 5;

    /**
     *
     *
     * <pre>
     * Executes all reads at a timestamp that is `exact_staleness`
     * old. The timestamp is chosen soon after the read is started.
     *
     * Guarantees that all writes that have committed more than the
     * specified number of seconds ago are visible. Because Cloud Spanner
     * chooses the exact timestamp, this mode works even if the client's
     * local clock is substantially skewed from Cloud Spanner commit
     * timestamps.
     *
     * Useful for reading at nearby replicas without the distributed
     * timestamp negotiation overhead of `max_staleness`.
     * </pre>
     *
     * <code>.google.protobuf.Duration exact_staleness = 5;</code>
     *
     * @return Whether the exactStaleness field is set.
     */
    @java.lang.Override
    public boolean hasExactStaleness() {
      return timestampBoundCase_ == 5;
    }

    /**
     *
     *
     * <pre>
     * Executes all reads at a timestamp that is `exact_staleness`
     * old. The timestamp is chosen soon after the read is started.
     *
     * Guarantees that all writes that have committed more than the
     * specified number of seconds ago are visible. Because Cloud Spanner
     * chooses the exact timestamp, this mode works even if the client's
     * local clock is substantially skewed from Cloud Spanner commit
     * timestamps.
     *
     * Useful for reading at nearby replicas without the distributed
     * timestamp negotiation overhead of `max_staleness`.
     * </pre>
     *
     * <code>.google.protobuf.Duration exact_staleness = 5;</code>
     *
     * @return The exactStaleness.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getExactStaleness() {
      if (timestampBoundCase_ == 5) {
        return (com.google.protobuf.Duration) timestampBound_;
      }
      return com.google.protobuf.Duration.getDefaultInstance();
    }

    /**
     *
     *
     * <pre>
     * Executes all reads at a timestamp that is `exact_staleness`
     * old. The timestamp is chosen soon after the read is started.
     *
     * Guarantees that all writes that have committed more than the
     * specified number of seconds ago are visible. Because Cloud Spanner
     * chooses the exact timestamp, this mode works even if the client's
     * local clock is substantially skewed from Cloud Spanner commit
     * timestamps.
     *
     * Useful for reading at nearby replicas without the distributed
     * timestamp negotiation overhead of `max_staleness`.
     * </pre>
     *
     * <code>.google.protobuf.Duration exact_staleness = 5;</code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getExactStalenessOrBuilder() {
      if (timestampBoundCase_ == 5) {
        return (com.google.protobuf.Duration) timestampBound_;
      }
      return com.google.protobuf.Duration.getDefaultInstance();
    }

    public static final int RETURN_READ_TIMESTAMP_FIELD_NUMBER = 6;
    private boolean returnReadTimestamp_ = false;

    /**
     *
     *
     * <pre>
     * If true, the Cloud Spanner-selected read timestamp is included in
     * the [Transaction][google.spanner.v1.Transaction] message that describes
     * the transaction.
     * </pre>
     *
     * <code>bool return_read_timestamp = 6;</code>
     *
     * @return The returnReadTimestamp.
     */
    @java.lang.Override
    public boolean getReturnReadTimestamp() {
      return returnReadTimestamp_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (timestampBoundCase_ == 1) {
        output.writeBool(1, (boolean) ((java.lang.Boolean) timestampBound_));
      }
      if (timestampBoundCase_ == 2) {
        output.writeMessage(2, (com.google.protobuf.Timestamp) timestampBound_);
      }
      if (timestampBoundCase_ == 3) {
        output.writeMessage(3, (com.google.protobuf.Duration) timestampBound_);
      }
      if (timestampBoundCase_ == 4) {
        output.writeMessage(4, (com.google.protobuf.Timestamp) timestampBound_);
      }
      if (timestampBoundCase_ == 5) {
        output.writeMessage(5, (com.google.protobuf.Duration) timestampBound_);
      }
      if (returnReadTimestamp_ != false) {
        output.writeBool(6, returnReadTimestamp_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (timestampBoundCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeBoolSize(
                1, (boolean) ((java.lang.Boolean) timestampBound_));
      }
      if (timestampBoundCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2, (com.google.protobuf.Timestamp) timestampBound_);
      }
      if (timestampBoundCase_ == 3) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                3, (com.google.protobuf.Duration) timestampBound_);
      }
      if (timestampBoundCase_ == 4) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                4, (com.google.protobuf.Timestamp) timestampBound_);
      }
      if (timestampBoundCase_ == 5) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                5, (com.google.protobuf.Duration) timestampBound_);
      }
      if (returnReadTimestamp_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(6, returnReadTimestamp_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.spanner.v1.TransactionOptions.ReadOnly)) {
        return super.equals(obj);
      }
      com.google.spanner.v1.TransactionOptions.ReadOnly other =
          (com.google.spanner.v1.TransactionOptions.ReadOnly) obj;

      if (getReturnReadTimestamp() != other.getReturnReadTimestamp()) return false;
      if (!getTimestampBoundCase().equals(other.getTimestampBoundCase())) return false;
      switch (timestampBoundCase_) {
        case 1:
          if (getStrong() != other.getStrong()) return false;
          break;
        case 2:
          if (!getMinReadTimestamp().equals(other.getMinReadTimestamp())) return false;
          break;
        case 3:
          if (!getMaxStaleness().equals(other.getMaxStaleness())) return false;
          break;
        case 4:
          if (!getReadTimestamp().equals(other.getReadTimestamp())) return false;
          break;
        case 5:
          if (!getExactStaleness().equals(other.getExactStaleness())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + RETURN_READ_TIMESTAMP_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getReturnReadTimestamp());
      switch (timestampBoundCase_) {
        case 1:
          hash = (37 * hash) + STRONG_FIELD_NUMBER;
          hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getStrong());
          break;
        case 2:
          hash = (37 * hash) + MIN_READ_TIMESTAMP_FIELD_NUMBER;
          hash = (53 * hash) + getMinReadTimestamp().hashCode();
          break;
        case 3:
          hash = (37 * hash) + MAX_STALENESS_FIELD_NUMBER;
          hash = (53 * hash) + getMaxStaleness().hashCode();
          break;
        case 4:
          hash = (37 * hash) + READ_TIMESTAMP_FIELD_NUMBER;
          hash = (53 * hash) + getReadTimestamp().hashCode();
          break;
        case 5:
          hash = (37 * hash) + EXACT_STALENESS_FIELD_NUMBER;
          hash = (53 * hash) + getExactStaleness().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.spanner.v1.TransactionOptions.ReadOnly parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.TransactionOptions.ReadOnly parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.TransactionOptions.ReadOnly parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.TransactionOptions.ReadOnly parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.TransactionOptions.ReadOnly parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.TransactionOptions.ReadOnly parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.TransactionOptions.ReadOnly parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.TransactionOptions.ReadOnly parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.spanner.v1.TransactionOptions.ReadOnly parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.TransactionOptions.ReadOnly parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.spanner.v1.TransactionOptions.ReadOnly parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.TransactionOptions.ReadOnly parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.spanner.v1.TransactionOptions.ReadOnly prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Message type to initiate a read-only transaction.
     * </pre>
     *
     * Protobuf type {@code google.spanner.v1.TransactionOptions.ReadOnly}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.spanner.v1.TransactionOptions.ReadOnly)
        com.google.spanner.v1.TransactionOptions.ReadOnlyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.spanner.v1.TransactionProto
            .internal_static_google_spanner_v1_TransactionOptions_ReadOnly_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.spanner.v1.TransactionProto
            .internal_static_google_spanner_v1_TransactionOptions_ReadOnly_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.spanner.v1.TransactionOptions.ReadOnly.class,
                com.google.spanner.v1.TransactionOptions.ReadOnly.Builder.class);
      }

      // Construct using com.google.spanner.v1.TransactionOptions.ReadOnly.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (minReadTimestampBuilder_ != null) {
          minReadTimestampBuilder_.clear();
        }
        if (maxStalenessBuilder_ != null) {
          maxStalenessBuilder_.clear();
        }
        if (readTimestampBuilder_ != null) {
          readTimestampBuilder_.clear();
        }
        if (exactStalenessBuilder_ != null) {
          exactStalenessBuilder_.clear();
        }
        returnReadTimestamp_ = false;
        timestampBoundCase_ = 0;
        timestampBound_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.spanner.v1.TransactionProto
            .internal_static_google_spanner_v1_TransactionOptions_ReadOnly_descriptor;
      }

      @java.lang.Override
      public com.google.spanner.v1.TransactionOptions.ReadOnly getDefaultInstanceForType() {
        return com.google.spanner.v1.TransactionOptions.ReadOnly.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.spanner.v1.TransactionOptions.ReadOnly build() {
        com.google.spanner.v1.TransactionOptions.ReadOnly result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.spanner.v1.TransactionOptions.ReadOnly buildPartial() {
        com.google.spanner.v1.TransactionOptions.ReadOnly result =
            new com.google.spanner.v1.TransactionOptions.ReadOnly(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.spanner.v1.TransactionOptions.ReadOnly result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.returnReadTimestamp_ = returnReadTimestamp_;
        }
      }

      private void buildPartialOneofs(com.google.spanner.v1.TransactionOptions.ReadOnly result) {
        result.timestampBoundCase_ = timestampBoundCase_;
        result.timestampBound_ = this.timestampBound_;
        if (timestampBoundCase_ == 2 && minReadTimestampBuilder_ != null) {
          result.timestampBound_ = minReadTimestampBuilder_.build();
        }
        if (timestampBoundCase_ == 3 && maxStalenessBuilder_ != null) {
          result.timestampBound_ = maxStalenessBuilder_.build();
        }
        if (timestampBoundCase_ == 4 && readTimestampBuilder_ != null) {
          result.timestampBound_ = readTimestampBuilder_.build();
        }
        if (timestampBoundCase_ == 5 && exactStalenessBuilder_ != null) {
          result.timestampBound_ = exactStalenessBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.spanner.v1.TransactionOptions.ReadOnly) {
          return mergeFrom((com.google.spanner.v1.TransactionOptions.ReadOnly) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.spanner.v1.TransactionOptions.ReadOnly other) {
        if (other == com.google.spanner.v1.TransactionOptions.ReadOnly.getDefaultInstance())
          return this;
        if (other.getReturnReadTimestamp() != false) {
          setReturnReadTimestamp(other.getReturnReadTimestamp());
        }
        switch (other.getTimestampBoundCase()) {
          case STRONG:
            {
              setStrong(other.getStrong());
              break;
            }
          case MIN_READ_TIMESTAMP:
            {
              mergeMinReadTimestamp(other.getMinReadTimestamp());
              break;
            }
          case MAX_STALENESS:
            {
              mergeMaxStaleness(other.getMaxStaleness());
              break;
            }
          case READ_TIMESTAMP:
            {
              mergeReadTimestamp(other.getReadTimestamp());
              break;
            }
          case EXACT_STALENESS:
            {
              mergeExactStaleness(other.getExactStaleness());
              break;
            }
          case TIMESTAMPBOUND_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  timestampBound_ = input.readBool();
                  timestampBoundCase_ = 1;
                  break;
                } // case 8
              case 18:
                {
                  input.readMessage(
                      getMinReadTimestampFieldBuilder().getBuilder(), extensionRegistry);
                  timestampBoundCase_ = 2;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(getMaxStalenessFieldBuilder().getBuilder(), extensionRegistry);
                  timestampBoundCase_ = 3;
                  break;
                } // case 26
              case 34:
                {
                  input.readMessage(getReadTimestampFieldBuilder().getBuilder(), extensionRegistry);
                  timestampBoundCase_ = 4;
                  break;
                } // case 34
              case 42:
                {
                  input.readMessage(
                      getExactStalenessFieldBuilder().getBuilder(), extensionRegistry);
                  timestampBoundCase_ = 5;
                  break;
                } // case 42
              case 48:
                {
                  returnReadTimestamp_ = input.readBool();
                  bitField0_ |= 0x00000020;
                  break;
                } // case 48
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int timestampBoundCase_ = 0;
      private java.lang.Object timestampBound_;

      public TimestampBoundCase getTimestampBoundCase() {
        return TimestampBoundCase.forNumber(timestampBoundCase_);
      }

      public Builder clearTimestampBound() {
        timestampBoundCase_ = 0;
        timestampBound_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      /**
       *
       *
       * <pre>
       * Read at a timestamp where all previously committed transactions
       * are visible.
       * </pre>
       *
       * <code>bool strong = 1;</code>
       *
       * @return Whether the strong field is set.
       */
      public boolean hasStrong() {
        return timestampBoundCase_ == 1;
      }

      /**
       *
       *
       * <pre>
       * Read at a timestamp where all previously committed transactions
       * are visible.
       * </pre>
       *
       * <code>bool strong = 1;</code>
       *
       * @return The strong.
       */
      public boolean getStrong() {
        if (timestampBoundCase_ == 1) {
          return (java.lang.Boolean) timestampBound_;
        }
        return false;
      }

      /**
       *
       *
       * <pre>
       * Read at a timestamp where all previously committed transactions
       * are visible.
       * </pre>
       *
       * <code>bool strong = 1;</code>
       *
       * @param value The strong to set.
       * @return This builder for chaining.
       */
      public Builder setStrong(boolean value) {

        timestampBoundCase_ = 1;
        timestampBound_ = value;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Read at a timestamp where all previously committed transactions
       * are visible.
       * </pre>
       *
       * <code>bool strong = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearStrong() {
        if (timestampBoundCase_ == 1) {
          timestampBoundCase_ = 0;
          timestampBound_ = null;
          onChanged();
        }
        return this;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          minReadTimestampBuilder_;

      /**
       *
       *
       * <pre>
       * Executes all reads at a timestamp &gt;= `min_read_timestamp`.
       *
       * This is useful for requesting fresher data than some previous
       * read, or data that is fresh enough to observe the effects of some
       * previously committed transaction whose timestamp is known.
       *
       * Note that this option can only be used in single-use transactions.
       *
       * A timestamp in RFC3339 UTC &#92;"Zulu&#92;" format, accurate to nanoseconds.
       * Example: `"2014-10-02T15:01:23.045123456Z"`.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp min_read_timestamp = 2;</code>
       *
       * @return Whether the minReadTimestamp field is set.
       */
      @java.lang.Override
      public boolean hasMinReadTimestamp() {
        return timestampBoundCase_ == 2;
      }

      /**
       *
       *
       * <pre>
       * Executes all reads at a timestamp &gt;= `min_read_timestamp`.
       *
       * This is useful for requesting fresher data than some previous
       * read, or data that is fresh enough to observe the effects of some
       * previously committed transaction whose timestamp is known.
       *
       * Note that this option can only be used in single-use transactions.
       *
       * A timestamp in RFC3339 UTC &#92;"Zulu&#92;" format, accurate to nanoseconds.
       * Example: `"2014-10-02T15:01:23.045123456Z"`.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp min_read_timestamp = 2;</code>
       *
       * @return The minReadTimestamp.
       */
      @java.lang.Override
      public com.google.protobuf.Timestamp getMinReadTimestamp() {
        if (minReadTimestampBuilder_ == null) {
          if (timestampBoundCase_ == 2) {
            return (com.google.protobuf.Timestamp) timestampBound_;
          }
          return com.google.protobuf.Timestamp.getDefaultInstance();
        } else {
          if (timestampBoundCase_ == 2) {
            return minReadTimestampBuilder_.getMessage();
          }
          return com.google.protobuf.Timestamp.getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Executes all reads at a timestamp &gt;= `min_read_timestamp`.
       *
       * This is useful for requesting fresher data than some previous
       * read, or data that is fresh enough to observe the effects of some
       * previously committed transaction whose timestamp is known.
       *
       * Note that this option can only be used in single-use transactions.
       *
       * A timestamp in RFC3339 UTC &#92;"Zulu&#92;" format, accurate to nanoseconds.
       * Example: `"2014-10-02T15:01:23.045123456Z"`.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp min_read_timestamp = 2;</code>
       */
      public Builder setMinReadTimestamp(com.google.protobuf.Timestamp value) {
        if (minReadTimestampBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          timestampBound_ = value;
          onChanged();
        } else {
          minReadTimestampBuilder_.setMessage(value);
        }
        timestampBoundCase_ = 2;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Executes all reads at a timestamp &gt;= `min_read_timestamp`.
       *
       * This is useful for requesting fresher data than some previous
       * read, or data that is fresh enough to observe the effects of some
       * previously committed transaction whose timestamp is known.
       *
       * Note that this option can only be used in single-use transactions.
       *
       * A timestamp in RFC3339 UTC &#92;"Zulu&#92;" format, accurate to nanoseconds.
       * Example: `"2014-10-02T15:01:23.045123456Z"`.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp min_read_timestamp = 2;</code>
       */
      public Builder setMinReadTimestamp(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (minReadTimestampBuilder_ == null) {
          timestampBound_ = builderForValue.build();
          onChanged();
        } else {
          minReadTimestampBuilder_.setMessage(builderForValue.build());
        }
        timestampBoundCase_ = 2;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Executes all reads at a timestamp &gt;= `min_read_timestamp`.
       *
       * This is useful for requesting fresher data than some previous
       * read, or data that is fresh enough to observe the effects of some
       * previously committed transaction whose timestamp is known.
       *
       * Note that this option can only be used in single-use transactions.
       *
       * A timestamp in RFC3339 UTC &#92;"Zulu&#92;" format, accurate to nanoseconds.
       * Example: `"2014-10-02T15:01:23.045123456Z"`.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp min_read_timestamp = 2;</code>
       */
      public Builder mergeMinReadTimestamp(com.google.protobuf.Timestamp value) {
        if (minReadTimestampBuilder_ == null) {
          if (timestampBoundCase_ == 2
              && timestampBound_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            timestampBound_ =
                com.google.protobuf.Timestamp.newBuilder(
                        (com.google.protobuf.Timestamp) timestampBound_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            timestampBound_ = value;
          }
          onChanged();
        } else {
          if (timestampBoundCase_ == 2) {
            minReadTimestampBuilder_.mergeFrom(value);
          } else {
            minReadTimestampBuilder_.setMessage(value);
          }
        }
        timestampBoundCase_ = 2;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Executes all reads at a timestamp &gt;= `min_read_timestamp`.
       *
       * This is useful for requesting fresher data than some previous
       * read, or data that is fresh enough to observe the effects of some
       * previously committed transaction whose timestamp is known.
       *
       * Note that this option can only be used in single-use transactions.
       *
       * A timestamp in RFC3339 UTC &#92;"Zulu&#92;" format, accurate to nanoseconds.
       * Example: `"2014-10-02T15:01:23.045123456Z"`.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp min_read_timestamp = 2;</code>
       */
      public Builder clearMinReadTimestamp() {
        if (minReadTimestampBuilder_ == null) {
          if (timestampBoundCase_ == 2) {
            timestampBoundCase_ = 0;
            timestampBound_ = null;
            onChanged();
          }
        } else {
          if (timestampBoundCase_ == 2) {
            timestampBoundCase_ = 0;
            timestampBound_ = null;
          }
          minReadTimestampBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Executes all reads at a timestamp &gt;= `min_read_timestamp`.
       *
       * This is useful for requesting fresher data than some previous
       * read, or data that is fresh enough to observe the effects of some
       * previously committed transaction whose timestamp is known.
       *
       * Note that this option can only be used in single-use transactions.
       *
       * A timestamp in RFC3339 UTC &#92;"Zulu&#92;" format, accurate to nanoseconds.
       * Example: `"2014-10-02T15:01:23.045123456Z"`.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp min_read_timestamp = 2;</code>
       */
      public com.google.protobuf.Timestamp.Builder getMinReadTimestampBuilder() {
        return getMinReadTimestampFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Executes all reads at a timestamp &gt;= `min_read_timestamp`.
       *
       * This is useful for requesting fresher data than some previous
       * read, or data that is fresh enough to observe the effects of some
       * previously committed transaction whose timestamp is known.
       *
       * Note that this option can only be used in single-use transactions.
       *
       * A timestamp in RFC3339 UTC &#92;"Zulu&#92;" format, accurate to nanoseconds.
       * Example: `"2014-10-02T15:01:23.045123456Z"`.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp min_read_timestamp = 2;</code>
       */
      @java.lang.Override
      public com.google.protobuf.TimestampOrBuilder getMinReadTimestampOrBuilder() {
        if ((timestampBoundCase_ == 2) && (minReadTimestampBuilder_ != null)) {
          return minReadTimestampBuilder_.getMessageOrBuilder();
        } else {
          if (timestampBoundCase_ == 2) {
            return (com.google.protobuf.Timestamp) timestampBound_;
          }
          return com.google.protobuf.Timestamp.getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Executes all reads at a timestamp &gt;= `min_read_timestamp`.
       *
       * This is useful for requesting fresher data than some previous
       * read, or data that is fresh enough to observe the effects of some
       * previously committed transaction whose timestamp is known.
       *
       * Note that this option can only be used in single-use transactions.
       *
       * A timestamp in RFC3339 UTC &#92;"Zulu&#92;" format, accurate to nanoseconds.
       * Example: `"2014-10-02T15:01:23.045123456Z"`.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp min_read_timestamp = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getMinReadTimestampFieldBuilder() {
        if (minReadTimestampBuilder_ == null) {
          if (!(timestampBoundCase_ == 2)) {
            timestampBound_ = com.google.protobuf.Timestamp.getDefaultInstance();
          }
          minReadTimestampBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  (com.google.protobuf.Timestamp) timestampBound_,
                  getParentForChildren(),
                  isClean());
          timestampBound_ = null;
        }
        timestampBoundCase_ = 2;
        onChanged();
        return minReadTimestampBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          maxStalenessBuilder_;

      /**
       *
       *
       * <pre>
       * Read data at a timestamp &gt;= `NOW - max_staleness`
       * seconds. Guarantees that all writes that have committed more
       * than the specified number of seconds ago are visible. Because
       * Cloud Spanner chooses the exact timestamp, this mode works even if
       * the client's local clock is substantially skewed from Cloud Spanner
       * commit timestamps.
       *
       * Useful for reading the freshest data available at a nearby
       * replica, while bounding the possible staleness if the local
       * replica has fallen behind.
       *
       * Note that this option can only be used in single-use
       * transactions.
       * </pre>
       *
       * <code>.google.protobuf.Duration max_staleness = 3;</code>
       *
       * @return Whether the maxStaleness field is set.
       */
      @java.lang.Override
      public boolean hasMaxStaleness() {
        return timestampBoundCase_ == 3;
      }

      /**
       *
       *
       * <pre>
       * Read data at a timestamp &gt;= `NOW - max_staleness`
       * seconds. Guarantees that all writes that have committed more
       * than the specified number of seconds ago are visible. Because
       * Cloud Spanner chooses the exact timestamp, this mode works even if
       * the client's local clock is substantially skewed from Cloud Spanner
       * commit timestamps.
       *
       * Useful for reading the freshest data available at a nearby
       * replica, while bounding the possible staleness if the local
       * replica has fallen behind.
       *
       * Note that this option can only be used in single-use
       * transactions.
       * </pre>
       *
       * <code>.google.protobuf.Duration max_staleness = 3;</code>
       *
       * @return The maxStaleness.
       */
      @java.lang.Override
      public com.google.protobuf.Duration getMaxStaleness() {
        if (maxStalenessBuilder_ == null) {
          if (timestampBoundCase_ == 3) {
            return (com.google.protobuf.Duration) timestampBound_;
          }
          return com.google.protobuf.Duration.getDefaultInstance();
        } else {
          if (timestampBoundCase_ == 3) {
            return maxStalenessBuilder_.getMessage();
          }
          return com.google.protobuf.Duration.getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Read data at a timestamp &gt;= `NOW - max_staleness`
       * seconds. Guarantees that all writes that have committed more
       * than the specified number of seconds ago are visible. Because
       * Cloud Spanner chooses the exact timestamp, this mode works even if
       * the client's local clock is substantially skewed from Cloud Spanner
       * commit timestamps.
       *
       * Useful for reading the freshest data available at a nearby
       * replica, while bounding the possible staleness if the local
       * replica has fallen behind.
       *
       * Note that this option can only be used in single-use
       * transactions.
       * </pre>
       *
       * <code>.google.protobuf.Duration max_staleness = 3;</code>
       */
      public Builder setMaxStaleness(com.google.protobuf.Duration value) {
        if (maxStalenessBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          timestampBound_ = value;
          onChanged();
        } else {
          maxStalenessBuilder_.setMessage(value);
        }
        timestampBoundCase_ = 3;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Read data at a timestamp &gt;= `NOW - max_staleness`
       * seconds. Guarantees that all writes that have committed more
       * than the specified number of seconds ago are visible. Because
       * Cloud Spanner chooses the exact timestamp, this mode works even if
       * the client's local clock is substantially skewed from Cloud Spanner
       * commit timestamps.
       *
       * Useful for reading the freshest data available at a nearby
       * replica, while bounding the possible staleness if the local
       * replica has fallen behind.
       *
       * Note that this option can only be used in single-use
       * transactions.
       * </pre>
       *
       * <code>.google.protobuf.Duration max_staleness = 3;</code>
       */
      public Builder setMaxStaleness(com.google.protobuf.Duration.Builder builderForValue) {
        if (maxStalenessBuilder_ == null) {
          timestampBound_ = builderForValue.build();
          onChanged();
        } else {
          maxStalenessBuilder_.setMessage(builderForValue.build());
        }
        timestampBoundCase_ = 3;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Read data at a timestamp &gt;= `NOW - max_staleness`
       * seconds. Guarantees that all writes that have committed more
       * than the specified number of seconds ago are visible. Because
       * Cloud Spanner chooses the exact timestamp, this mode works even if
       * the client's local clock is substantially skewed from Cloud Spanner
       * commit timestamps.
       *
       * Useful for reading the freshest data available at a nearby
       * replica, while bounding the possible staleness if the local
       * replica has fallen behind.
       *
       * Note that this option can only be used in single-use
       * transactions.
       * </pre>
       *
       * <code>.google.protobuf.Duration max_staleness = 3;</code>
       */
      public Builder mergeMaxStaleness(com.google.protobuf.Duration value) {
        if (maxStalenessBuilder_ == null) {
          if (timestampBoundCase_ == 3
              && timestampBound_ != com.google.protobuf.Duration.getDefaultInstance()) {
            timestampBound_ =
                com.google.protobuf.Duration.newBuilder(
                        (com.google.protobuf.Duration) timestampBound_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            timestampBound_ = value;
          }
          onChanged();
        } else {
          if (timestampBoundCase_ == 3) {
            maxStalenessBuilder_.mergeFrom(value);
          } else {
            maxStalenessBuilder_.setMessage(value);
          }
        }
        timestampBoundCase_ = 3;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Read data at a timestamp &gt;= `NOW - max_staleness`
       * seconds. Guarantees that all writes that have committed more
       * than the specified number of seconds ago are visible. Because
       * Cloud Spanner chooses the exact timestamp, this mode works even if
       * the client's local clock is substantially skewed from Cloud Spanner
       * commit timestamps.
       *
       * Useful for reading the freshest data available at a nearby
       * replica, while bounding the possible staleness if the local
       * replica has fallen behind.
       *
       * Note that this option can only be used in single-use
       * transactions.
       * </pre>
       *
       * <code>.google.protobuf.Duration max_staleness = 3;</code>
       */
      public Builder clearMaxStaleness() {
        if (maxStalenessBuilder_ == null) {
          if (timestampBoundCase_ == 3) {
            timestampBoundCase_ = 0;
            timestampBound_ = null;
            onChanged();
          }
        } else {
          if (timestampBoundCase_ == 3) {
            timestampBoundCase_ = 0;
            timestampBound_ = null;
          }
          maxStalenessBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Read data at a timestamp &gt;= `NOW - max_staleness`
       * seconds. Guarantees that all writes that have committed more
       * than the specified number of seconds ago are visible. Because
       * Cloud Spanner chooses the exact timestamp, this mode works even if
       * the client's local clock is substantially skewed from Cloud Spanner
       * commit timestamps.
       *
       * Useful for reading the freshest data available at a nearby
       * replica, while bounding the possible staleness if the local
       * replica has fallen behind.
       *
       * Note that this option can only be used in single-use
       * transactions.
       * </pre>
       *
       * <code>.google.protobuf.Duration max_staleness = 3;</code>
       */
      public com.google.protobuf.Duration.Builder getMaxStalenessBuilder() {
        return getMaxStalenessFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Read data at a timestamp &gt;= `NOW - max_staleness`
       * seconds. Guarantees that all writes that have committed more
       * than the specified number of seconds ago are visible. Because
       * Cloud Spanner chooses the exact timestamp, this mode works even if
       * the client's local clock is substantially skewed from Cloud Spanner
       * commit timestamps.
       *
       * Useful for reading the freshest data available at a nearby
       * replica, while bounding the possible staleness if the local
       * replica has fallen behind.
       *
       * Note that this option can only be used in single-use
       * transactions.
       * </pre>
       *
       * <code>.google.protobuf.Duration max_staleness = 3;</code>
       */
      @java.lang.Override
      public com.google.protobuf.DurationOrBuilder getMaxStalenessOrBuilder() {
        if ((timestampBoundCase_ == 3) && (maxStalenessBuilder_ != null)) {
          return maxStalenessBuilder_.getMessageOrBuilder();
        } else {
          if (timestampBoundCase_ == 3) {
            return (com.google.protobuf.Duration) timestampBound_;
          }
          return com.google.protobuf.Duration.getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Read data at a timestamp &gt;= `NOW - max_staleness`
       * seconds. Guarantees that all writes that have committed more
       * than the specified number of seconds ago are visible. Because
       * Cloud Spanner chooses the exact timestamp, this mode works even if
       * the client's local clock is substantially skewed from Cloud Spanner
       * commit timestamps.
       *
       * Useful for reading the freshest data available at a nearby
       * replica, while bounding the possible staleness if the local
       * replica has fallen behind.
       *
       * Note that this option can only be used in single-use
       * transactions.
       * </pre>
       *
       * <code>.google.protobuf.Duration max_staleness = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          getMaxStalenessFieldBuilder() {
        if (maxStalenessBuilder_ == null) {
          if (!(timestampBoundCase_ == 3)) {
            timestampBound_ = com.google.protobuf.Duration.getDefaultInstance();
          }
          maxStalenessBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>(
                  (com.google.protobuf.Duration) timestampBound_,
                  getParentForChildren(),
                  isClean());
          timestampBound_ = null;
        }
        timestampBoundCase_ = 3;
        onChanged();
        return maxStalenessBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          readTimestampBuilder_;

      /**
       *
       *
       * <pre>
       * Executes all reads at the given timestamp. Unlike other modes,
       * reads at a specific timestamp are repeatable; the same read at
       * the same timestamp always returns the same data. If the
       * timestamp is in the future, the read is blocked until the
       * specified timestamp, modulo the read's deadline.
       *
       * Useful for large scale consistent reads such as mapreduces, or
       * for coordinating many reads against a consistent snapshot of the
       * data.
       *
       * A timestamp in RFC3339 UTC &#92;"Zulu&#92;" format, accurate to nanoseconds.
       * Example: `"2014-10-02T15:01:23.045123456Z"`.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp read_timestamp = 4;</code>
       *
       * @return Whether the readTimestamp field is set.
       */
      @java.lang.Override
      public boolean hasReadTimestamp() {
        return timestampBoundCase_ == 4;
      }

      /**
       *
       *
       * <pre>
       * Executes all reads at the given timestamp. Unlike other modes,
       * reads at a specific timestamp are repeatable; the same read at
       * the same timestamp always returns the same data. If the
       * timestamp is in the future, the read is blocked until the
       * specified timestamp, modulo the read's deadline.
       *
       * Useful for large scale consistent reads such as mapreduces, or
       * for coordinating many reads against a consistent snapshot of the
       * data.
       *
       * A timestamp in RFC3339 UTC &#92;"Zulu&#92;" format, accurate to nanoseconds.
       * Example: `"2014-10-02T15:01:23.045123456Z"`.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp read_timestamp = 4;</code>
       *
       * @return The readTimestamp.
       */
      @java.lang.Override
      public com.google.protobuf.Timestamp getReadTimestamp() {
        if (readTimestampBuilder_ == null) {
          if (timestampBoundCase_ == 4) {
            return (com.google.protobuf.Timestamp) timestampBound_;
          }
          return com.google.protobuf.Timestamp.getDefaultInstance();
        } else {
          if (timestampBoundCase_ == 4) {
            return readTimestampBuilder_.getMessage();
          }
          return com.google.protobuf.Timestamp.getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Executes all reads at the given timestamp. Unlike other modes,
       * reads at a specific timestamp are repeatable; the same read at
       * the same timestamp always returns the same data. If the
       * timestamp is in the future, the read is blocked until the
       * specified timestamp, modulo the read's deadline.
       *
       * Useful for large scale consistent reads such as mapreduces, or
       * for coordinating many reads against a consistent snapshot of the
       * data.
       *
       * A timestamp in RFC3339 UTC &#92;"Zulu&#92;" format, accurate to nanoseconds.
       * Example: `"2014-10-02T15:01:23.045123456Z"`.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp read_timestamp = 4;</code>
       */
      public Builder setReadTimestamp(com.google.protobuf.Timestamp value) {
        if (readTimestampBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          timestampBound_ = value;
          onChanged();
        } else {
          readTimestampBuilder_.setMessage(value);
        }
        timestampBoundCase_ = 4;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Executes all reads at the given timestamp. Unlike other modes,
       * reads at a specific timestamp are repeatable; the same read at
       * the same timestamp always returns the same data. If the
       * timestamp is in the future, the read is blocked until the
       * specified timestamp, modulo the read's deadline.
       *
       * Useful for large scale consistent reads such as mapreduces, or
       * for coordinating many reads against a consistent snapshot of the
       * data.
       *
       * A timestamp in RFC3339 UTC &#92;"Zulu&#92;" format, accurate to nanoseconds.
       * Example: `"2014-10-02T15:01:23.045123456Z"`.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp read_timestamp = 4;</code>
       */
      public Builder setReadTimestamp(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (readTimestampBuilder_ == null) {
          timestampBound_ = builderForValue.build();
          onChanged();
        } else {
          readTimestampBuilder_.setMessage(builderForValue.build());
        }
        timestampBoundCase_ = 4;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Executes all reads at the given timestamp. Unlike other modes,
       * reads at a specific timestamp are repeatable; the same read at
       * the same timestamp always returns the same data. If the
       * timestamp is in the future, the read is blocked until the
       * specified timestamp, modulo the read's deadline.
       *
       * Useful for large scale consistent reads such as mapreduces, or
       * for coordinating many reads against a consistent snapshot of the
       * data.
       *
       * A timestamp in RFC3339 UTC &#92;"Zulu&#92;" format, accurate to nanoseconds.
       * Example: `"2014-10-02T15:01:23.045123456Z"`.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp read_timestamp = 4;</code>
       */
      public Builder mergeReadTimestamp(com.google.protobuf.Timestamp value) {
        if (readTimestampBuilder_ == null) {
          if (timestampBoundCase_ == 4
              && timestampBound_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            timestampBound_ =
                com.google.protobuf.Timestamp.newBuilder(
                        (com.google.protobuf.Timestamp) timestampBound_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            timestampBound_ = value;
          }
          onChanged();
        } else {
          if (timestampBoundCase_ == 4) {
            readTimestampBuilder_.mergeFrom(value);
          } else {
            readTimestampBuilder_.setMessage(value);
          }
        }
        timestampBoundCase_ = 4;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Executes all reads at the given timestamp. Unlike other modes,
       * reads at a specific timestamp are repeatable; the same read at
       * the same timestamp always returns the same data. If the
       * timestamp is in the future, the read is blocked until the
       * specified timestamp, modulo the read's deadline.
       *
       * Useful for large scale consistent reads such as mapreduces, or
       * for coordinating many reads against a consistent snapshot of the
       * data.
       *
       * A timestamp in RFC3339 UTC &#92;"Zulu&#92;" format, accurate to nanoseconds.
       * Example: `"2014-10-02T15:01:23.045123456Z"`.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp read_timestamp = 4;</code>
       */
      public Builder clearReadTimestamp() {
        if (readTimestampBuilder_ == null) {
          if (timestampBoundCase_ == 4) {
            timestampBoundCase_ = 0;
            timestampBound_ = null;
            onChanged();
          }
        } else {
          if (timestampBoundCase_ == 4) {
            timestampBoundCase_ = 0;
            timestampBound_ = null;
          }
          readTimestampBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Executes all reads at the given timestamp. Unlike other modes,
       * reads at a specific timestamp are repeatable; the same read at
       * the same timestamp always returns the same data. If the
       * timestamp is in the future, the read is blocked until the
       * specified timestamp, modulo the read's deadline.
       *
       * Useful for large scale consistent reads such as mapreduces, or
       * for coordinating many reads against a consistent snapshot of the
       * data.
       *
       * A timestamp in RFC3339 UTC &#92;"Zulu&#92;" format, accurate to nanoseconds.
       * Example: `"2014-10-02T15:01:23.045123456Z"`.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp read_timestamp = 4;</code>
       */
      public com.google.protobuf.Timestamp.Builder getReadTimestampBuilder() {
        return getReadTimestampFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Executes all reads at the given timestamp. Unlike other modes,
       * reads at a specific timestamp are repeatable; the same read at
       * the same timestamp always returns the same data. If the
       * timestamp is in the future, the read is blocked until the
       * specified timestamp, modulo the read's deadline.
       *
       * Useful for large scale consistent reads such as mapreduces, or
       * for coordinating many reads against a consistent snapshot of the
       * data.
       *
       * A timestamp in RFC3339 UTC &#92;"Zulu&#92;" format, accurate to nanoseconds.
       * Example: `"2014-10-02T15:01:23.045123456Z"`.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp read_timestamp = 4;</code>
       */
      @java.lang.Override
      public com.google.protobuf.TimestampOrBuilder getReadTimestampOrBuilder() {
        if ((timestampBoundCase_ == 4) && (readTimestampBuilder_ != null)) {
          return readTimestampBuilder_.getMessageOrBuilder();
        } else {
          if (timestampBoundCase_ == 4) {
            return (com.google.protobuf.Timestamp) timestampBound_;
          }
          return com.google.protobuf.Timestamp.getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Executes all reads at the given timestamp. Unlike other modes,
       * reads at a specific timestamp are repeatable; the same read at
       * the same timestamp always returns the same data. If the
       * timestamp is in the future, the read is blocked until the
       * specified timestamp, modulo the read's deadline.
       *
       * Useful for large scale consistent reads such as mapreduces, or
       * for coordinating many reads against a consistent snapshot of the
       * data.
       *
       * A timestamp in RFC3339 UTC &#92;"Zulu&#92;" format, accurate to nanoseconds.
       * Example: `"2014-10-02T15:01:23.045123456Z"`.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp read_timestamp = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getReadTimestampFieldBuilder() {
        if (readTimestampBuilder_ == null) {
          if (!(timestampBoundCase_ == 4)) {
            timestampBound_ = com.google.protobuf.Timestamp.getDefaultInstance();
          }
          readTimestampBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  (com.google.protobuf.Timestamp) timestampBound_,
                  getParentForChildren(),
                  isClean());
          timestampBound_ = null;
        }
        timestampBoundCase_ = 4;
        onChanged();
        return readTimestampBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          exactStalenessBuilder_;

      /**
       *
       *
       * <pre>
       * Executes all reads at a timestamp that is `exact_staleness`
       * old. The timestamp is chosen soon after the read is started.
       *
       * Guarantees that all writes that have committed more than the
       * specified number of seconds ago are visible. Because Cloud Spanner
       * chooses the exact timestamp, this mode works even if the client's
       * local clock is substantially skewed from Cloud Spanner commit
       * timestamps.
       *
       * Useful for reading at nearby replicas without the distributed
       * timestamp negotiation overhead of `max_staleness`.
       * </pre>
       *
       * <code>.google.protobuf.Duration exact_staleness = 5;</code>
       *
       * @return Whether the exactStaleness field is set.
       */
      @java.lang.Override
      public boolean hasExactStaleness() {
        return timestampBoundCase_ == 5;
      }

      /**
       *
       *
       * <pre>
       * Executes all reads at a timestamp that is `exact_staleness`
       * old. The timestamp is chosen soon after the read is started.
       *
       * Guarantees that all writes that have committed more than the
       * specified number of seconds ago are visible. Because Cloud Spanner
       * chooses the exact timestamp, this mode works even if the client's
       * local clock is substantially skewed from Cloud Spanner commit
       * timestamps.
       *
       * Useful for reading at nearby replicas without the distributed
       * timestamp negotiation overhead of `max_staleness`.
       * </pre>
       *
       * <code>.google.protobuf.Duration exact_staleness = 5;</code>
       *
       * @return The exactStaleness.
       */
      @java.lang.Override
      public com.google.protobuf.Duration getExactStaleness() {
        if (exactStalenessBuilder_ == null) {
          if (timestampBoundCase_ == 5) {
            return (com.google.protobuf.Duration) timestampBound_;
          }
          return com.google.protobuf.Duration.getDefaultInstance();
        } else {
          if (timestampBoundCase_ == 5) {
            return exactStalenessBuilder_.getMessage();
          }
          return com.google.protobuf.Duration.getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Executes all reads at a timestamp that is `exact_staleness`
       * old. The timestamp is chosen soon after the read is started.
       *
       * Guarantees that all writes that have committed more than the
       * specified number of seconds ago are visible. Because Cloud Spanner
       * chooses the exact timestamp, this mode works even if the client's
       * local clock is substantially skewed from Cloud Spanner commit
       * timestamps.
       *
       * Useful for reading at nearby replicas without the distributed
       * timestamp negotiation overhead of `max_staleness`.
       * </pre>
       *
       * <code>.google.protobuf.Duration exact_staleness = 5;</code>
       */
      public Builder setExactStaleness(com.google.protobuf.Duration value) {
        if (exactStalenessBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          timestampBound_ = value;
          onChanged();
        } else {
          exactStalenessBuilder_.setMessage(value);
        }
        timestampBoundCase_ = 5;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Executes all reads at a timestamp that is `exact_staleness`
       * old. The timestamp is chosen soon after the read is started.
       *
       * Guarantees that all writes that have committed more than the
       * specified number of seconds ago are visible. Because Cloud Spanner
       * chooses the exact timestamp, this mode works even if the client's
       * local clock is substantially skewed from Cloud Spanner commit
       * timestamps.
       *
       * Useful for reading at nearby replicas without the distributed
       * timestamp negotiation overhead of `max_staleness`.
       * </pre>
       *
       * <code>.google.protobuf.Duration exact_staleness = 5;</code>
       */
      public Builder setExactStaleness(com.google.protobuf.Duration.Builder builderForValue) {
        if (exactStalenessBuilder_ == null) {
          timestampBound_ = builderForValue.build();
          onChanged();
        } else {
          exactStalenessBuilder_.setMessage(builderForValue.build());
        }
        timestampBoundCase_ = 5;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Executes all reads at a timestamp that is `exact_staleness`
       * old. The timestamp is chosen soon after the read is started.
       *
       * Guarantees that all writes that have committed more than the
       * specified number of seconds ago are visible. Because Cloud Spanner
       * chooses the exact timestamp, this mode works even if the client's
       * local clock is substantially skewed from Cloud Spanner commit
       * timestamps.
       *
       * Useful for reading at nearby replicas without the distributed
       * timestamp negotiation overhead of `max_staleness`.
       * </pre>
       *
       * <code>.google.protobuf.Duration exact_staleness = 5;</code>
       */
      public Builder mergeExactStaleness(com.google.protobuf.Duration value) {
        if (exactStalenessBuilder_ == null) {
          if (timestampBoundCase_ == 5
              && timestampBound_ != com.google.protobuf.Duration.getDefaultInstance()) {
            timestampBound_ =
                com.google.protobuf.Duration.newBuilder(
                        (com.google.protobuf.Duration) timestampBound_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            timestampBound_ = value;
          }
          onChanged();
        } else {
          if (timestampBoundCase_ == 5) {
            exactStalenessBuilder_.mergeFrom(value);
          } else {
            exactStalenessBuilder_.setMessage(value);
          }
        }
        timestampBoundCase_ = 5;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Executes all reads at a timestamp that is `exact_staleness`
       * old. The timestamp is chosen soon after the read is started.
       *
       * Guarantees that all writes that have committed more than the
       * specified number of seconds ago are visible. Because Cloud Spanner
       * chooses the exact timestamp, this mode works even if the client's
       * local clock is substantially skewed from Cloud Spanner commit
       * timestamps.
       *
       * Useful for reading at nearby replicas without the distributed
       * timestamp negotiation overhead of `max_staleness`.
       * </pre>
       *
       * <code>.google.protobuf.Duration exact_staleness = 5;</code>
       */
      public Builder clearExactStaleness() {
        if (exactStalenessBuilder_ == null) {
          if (timestampBoundCase_ == 5) {
            timestampBoundCase_ = 0;
            timestampBound_ = null;
            onChanged();
          }
        } else {
          if (timestampBoundCase_ == 5) {
            timestampBoundCase_ = 0;
            timestampBound_ = null;
          }
          exactStalenessBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Executes all reads at a timestamp that is `exact_staleness`
       * old. The timestamp is chosen soon after the read is started.
       *
       * Guarantees that all writes that have committed more than the
       * specified number of seconds ago are visible. Because Cloud Spanner
       * chooses the exact timestamp, this mode works even if the client's
       * local clock is substantially skewed from Cloud Spanner commit
       * timestamps.
       *
       * Useful for reading at nearby replicas without the distributed
       * timestamp negotiation overhead of `max_staleness`.
       * </pre>
       *
       * <code>.google.protobuf.Duration exact_staleness = 5;</code>
       */
      public com.google.protobuf.Duration.Builder getExactStalenessBuilder() {
        return getExactStalenessFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Executes all reads at a timestamp that is `exact_staleness`
       * old. The timestamp is chosen soon after the read is started.
       *
       * Guarantees that all writes that have committed more than the
       * specified number of seconds ago are visible. Because Cloud Spanner
       * chooses the exact timestamp, this mode works even if the client's
       * local clock is substantially skewed from Cloud Spanner commit
       * timestamps.
       *
       * Useful for reading at nearby replicas without the distributed
       * timestamp negotiation overhead of `max_staleness`.
       * </pre>
       *
       * <code>.google.protobuf.Duration exact_staleness = 5;</code>
       */
      @java.lang.Override
      public com.google.protobuf.DurationOrBuilder getExactStalenessOrBuilder() {
        if ((timestampBoundCase_ == 5) && (exactStalenessBuilder_ != null)) {
          return exactStalenessBuilder_.getMessageOrBuilder();
        } else {
          if (timestampBoundCase_ == 5) {
            return (com.google.protobuf.Duration) timestampBound_;
          }
          return com.google.protobuf.Duration.getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Executes all reads at a timestamp that is `exact_staleness`
       * old. The timestamp is chosen soon after the read is started.
       *
       * Guarantees that all writes that have committed more than the
       * specified number of seconds ago are visible. Because Cloud Spanner
       * chooses the exact timestamp, this mode works even if the client's
       * local clock is substantially skewed from Cloud Spanner commit
       * timestamps.
       *
       * Useful for reading at nearby replicas without the distributed
       * timestamp negotiation overhead of `max_staleness`.
       * </pre>
       *
       * <code>.google.protobuf.Duration exact_staleness = 5;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          getExactStalenessFieldBuilder() {
        if (exactStalenessBuilder_ == null) {
          if (!(timestampBoundCase_ == 5)) {
            timestampBound_ = com.google.protobuf.Duration.getDefaultInstance();
          }
          exactStalenessBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>(
                  (com.google.protobuf.Duration) timestampBound_,
                  getParentForChildren(),
                  isClean());
          timestampBound_ = null;
        }
        timestampBoundCase_ = 5;
        onChanged();
        return exactStalenessBuilder_;
      }

      private boolean returnReadTimestamp_;

      /**
       *
       *
       * <pre>
       * If true, the Cloud Spanner-selected read timestamp is included in
       * the [Transaction][google.spanner.v1.Transaction] message that describes
       * the transaction.
       * </pre>
       *
       * <code>bool return_read_timestamp = 6;</code>
       *
       * @return The returnReadTimestamp.
       */
      @java.lang.Override
      public boolean getReturnReadTimestamp() {
        return returnReadTimestamp_;
      }

      /**
       *
       *
       * <pre>
       * If true, the Cloud Spanner-selected read timestamp is included in
       * the [Transaction][google.spanner.v1.Transaction] message that describes
       * the transaction.
       * </pre>
       *
       * <code>bool return_read_timestamp = 6;</code>
       *
       * @param value The returnReadTimestamp to set.
       * @return This builder for chaining.
       */
      public Builder setReturnReadTimestamp(boolean value) {

        returnReadTimestamp_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * If true, the Cloud Spanner-selected read timestamp is included in
       * the [Transaction][google.spanner.v1.Transaction] message that describes
       * the transaction.
       * </pre>
       *
       * <code>bool return_read_timestamp = 6;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearReturnReadTimestamp() {
        bitField0_ = (bitField0_ & ~0x00000020);
        returnReadTimestamp_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.spanner.v1.TransactionOptions.ReadOnly)
    }

    // @@protoc_insertion_point(class_scope:google.spanner.v1.TransactionOptions.ReadOnly)
    private static final com.google.spanner.v1.TransactionOptions.ReadOnly DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.spanner.v1.TransactionOptions.ReadOnly();
    }

    public static com.google.spanner.v1.TransactionOptions.ReadOnly getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ReadOnly> PARSER =
        new com.google.protobuf.AbstractParser<ReadOnly>() {
          @java.lang.Override
          public ReadOnly parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ReadOnly> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ReadOnly> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.spanner.v1.TransactionOptions.ReadOnly getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int modeCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object mode_;

  public enum ModeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    READ_WRITE(1),
    PARTITIONED_DML(3),
    READ_ONLY(2),
    MODE_NOT_SET(0);
    private final int value;

    private ModeCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ModeCase valueOf(int value) {
      return forNumber(value);
    }

    public static ModeCase forNumber(int value) {
      switch (value) {
        case 1:
          return READ_WRITE;
        case 3:
          return PARTITIONED_DML;
        case 2:
          return READ_ONLY;
        case 0:
          return MODE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ModeCase getModeCase() {
    return ModeCase.forNumber(modeCase_);
  }

  public static final int READ_WRITE_FIELD_NUMBER = 1;

  /**
   *
   *
   * <pre>
   * Transaction may write.
   *
   * Authorization to begin a read-write transaction requires
   * `spanner.databases.beginOrRollbackReadWriteTransaction` permission
   * on the `session` resource.
   * </pre>
   *
   * <code>.google.spanner.v1.TransactionOptions.ReadWrite read_write = 1;</code>
   *
   * @return Whether the readWrite field is set.
   */
  @java.lang.Override
  public boolean hasReadWrite() {
    return modeCase_ == 1;
  }

  /**
   *
   *
   * <pre>
   * Transaction may write.
   *
   * Authorization to begin a read-write transaction requires
   * `spanner.databases.beginOrRollbackReadWriteTransaction` permission
   * on the `session` resource.
   * </pre>
   *
   * <code>.google.spanner.v1.TransactionOptions.ReadWrite read_write = 1;</code>
   *
   * @return The readWrite.
   */
  @java.lang.Override
  public com.google.spanner.v1.TransactionOptions.ReadWrite getReadWrite() {
    if (modeCase_ == 1) {
      return (com.google.spanner.v1.TransactionOptions.ReadWrite) mode_;
    }
    return com.google.spanner.v1.TransactionOptions.ReadWrite.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Transaction may write.
   *
   * Authorization to begin a read-write transaction requires
   * `spanner.databases.beginOrRollbackReadWriteTransaction` permission
   * on the `session` resource.
   * </pre>
   *
   * <code>.google.spanner.v1.TransactionOptions.ReadWrite read_write = 1;</code>
   */
  @java.lang.Override
  public com.google.spanner.v1.TransactionOptions.ReadWriteOrBuilder getReadWriteOrBuilder() {
    if (modeCase_ == 1) {
      return (com.google.spanner.v1.TransactionOptions.ReadWrite) mode_;
    }
    return com.google.spanner.v1.TransactionOptions.ReadWrite.getDefaultInstance();
  }

  public static final int PARTITIONED_DML_FIELD_NUMBER = 3;

  /**
   *
   *
   * <pre>
   * Partitioned DML transaction.
   *
   * Authorization to begin a Partitioned DML transaction requires
   * `spanner.databases.beginPartitionedDmlTransaction` permission
   * on the `session` resource.
   * </pre>
   *
   * <code>.google.spanner.v1.TransactionOptions.PartitionedDml partitioned_dml = 3;</code>
   *
   * @return Whether the partitionedDml field is set.
   */
  @java.lang.Override
  public boolean hasPartitionedDml() {
    return modeCase_ == 3;
  }

  /**
   *
   *
   * <pre>
   * Partitioned DML transaction.
   *
   * Authorization to begin a Partitioned DML transaction requires
   * `spanner.databases.beginPartitionedDmlTransaction` permission
   * on the `session` resource.
   * </pre>
   *
   * <code>.google.spanner.v1.TransactionOptions.PartitionedDml partitioned_dml = 3;</code>
   *
   * @return The partitionedDml.
   */
  @java.lang.Override
  public com.google.spanner.v1.TransactionOptions.PartitionedDml getPartitionedDml() {
    if (modeCase_ == 3) {
      return (com.google.spanner.v1.TransactionOptions.PartitionedDml) mode_;
    }
    return com.google.spanner.v1.TransactionOptions.PartitionedDml.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Partitioned DML transaction.
   *
   * Authorization to begin a Partitioned DML transaction requires
   * `spanner.databases.beginPartitionedDmlTransaction` permission
   * on the `session` resource.
   * </pre>
   *
   * <code>.google.spanner.v1.TransactionOptions.PartitionedDml partitioned_dml = 3;</code>
   */
  @java.lang.Override
  public com.google.spanner.v1.TransactionOptions.PartitionedDmlOrBuilder
      getPartitionedDmlOrBuilder() {
    if (modeCase_ == 3) {
      return (com.google.spanner.v1.TransactionOptions.PartitionedDml) mode_;
    }
    return com.google.spanner.v1.TransactionOptions.PartitionedDml.getDefaultInstance();
  }

  public static final int READ_ONLY_FIELD_NUMBER = 2;

  /**
   *
   *
   * <pre>
   * Transaction does not write.
   *
   * Authorization to begin a read-only transaction requires
   * `spanner.databases.beginReadOnlyTransaction` permission
   * on the `session` resource.
   * </pre>
   *
   * <code>.google.spanner.v1.TransactionOptions.ReadOnly read_only = 2;</code>
   *
   * @return Whether the readOnly field is set.
   */
  @java.lang.Override
  public boolean hasReadOnly() {
    return modeCase_ == 2;
  }

  /**
   *
   *
   * <pre>
   * Transaction does not write.
   *
   * Authorization to begin a read-only transaction requires
   * `spanner.databases.beginReadOnlyTransaction` permission
   * on the `session` resource.
   * </pre>
   *
   * <code>.google.spanner.v1.TransactionOptions.ReadOnly read_only = 2;</code>
   *
   * @return The readOnly.
   */
  @java.lang.Override
  public com.google.spanner.v1.TransactionOptions.ReadOnly getReadOnly() {
    if (modeCase_ == 2) {
      return (com.google.spanner.v1.TransactionOptions.ReadOnly) mode_;
    }
    return com.google.spanner.v1.TransactionOptions.ReadOnly.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Transaction does not write.
   *
   * Authorization to begin a read-only transaction requires
   * `spanner.databases.beginReadOnlyTransaction` permission
   * on the `session` resource.
   * </pre>
   *
   * <code>.google.spanner.v1.TransactionOptions.ReadOnly read_only = 2;</code>
   */
  @java.lang.Override
  public com.google.spanner.v1.TransactionOptions.ReadOnlyOrBuilder getReadOnlyOrBuilder() {
    if (modeCase_ == 2) {
      return (com.google.spanner.v1.TransactionOptions.ReadOnly) mode_;
    }
    return com.google.spanner.v1.TransactionOptions.ReadOnly.getDefaultInstance();
  }

  public static final int EXCLUDE_TXN_FROM_CHANGE_STREAMS_FIELD_NUMBER = 5;
  private boolean excludeTxnFromChangeStreams_ = false;

  /**
   *
   *
   * <pre>
   * When `exclude_txn_from_change_streams` is set to `true`, it prevents read
   * or write transactions from being tracked in change streams.
   *
   * * If the DDL option `allow_txn_exclusion` is set to `true`, then the
   * updates
   *  made within this transaction aren't recorded in the change stream.
   *
   * * If you don't set the DDL option `allow_txn_exclusion` or if it's
   *  set to `false`, then the updates made within this transaction are
   *  recorded in the change stream.
   *
   * When `exclude_txn_from_change_streams` is set to `false` or not set,
   * modifications from this transaction are recorded in all change streams
   * that are tracking columns modified by these transactions.
   *
   * The `exclude_txn_from_change_streams` option can only be specified
   * for read-write or partitioned DML transactions, otherwise the API returns
   * an `INVALID_ARGUMENT` error.
   * </pre>
   *
   * <code>bool exclude_txn_from_change_streams = 5;</code>
   *
   * @return The excludeTxnFromChangeStreams.
   */
  @java.lang.Override
  public boolean getExcludeTxnFromChangeStreams() {
    return excludeTxnFromChangeStreams_;
  }

  public static final int ISOLATION_LEVEL_FIELD_NUMBER = 6;
  private int isolationLevel_ = 0;

  /**
   *
   *
   * <pre>
   * Isolation level for the transaction.
   * </pre>
   *
   * <code>.google.spanner.v1.TransactionOptions.IsolationLevel isolation_level = 6;</code>
   *
   * @return The enum numeric value on the wire for isolationLevel.
   */
  @java.lang.Override
  public int getIsolationLevelValue() {
    return isolationLevel_;
  }

  /**
   *
   *
   * <pre>
   * Isolation level for the transaction.
   * </pre>
   *
   * <code>.google.spanner.v1.TransactionOptions.IsolationLevel isolation_level = 6;</code>
   *
   * @return The isolationLevel.
   */
  @java.lang.Override
  public com.google.spanner.v1.TransactionOptions.IsolationLevel getIsolationLevel() {
    com.google.spanner.v1.TransactionOptions.IsolationLevel result =
        com.google.spanner.v1.TransactionOptions.IsolationLevel.forNumber(isolationLevel_);
    return result == null
        ? com.google.spanner.v1.TransactionOptions.IsolationLevel.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (modeCase_ == 1) {
      output.writeMessage(1, (com.google.spanner.v1.TransactionOptions.ReadWrite) mode_);
    }
    if (modeCase_ == 2) {
      output.writeMessage(2, (com.google.spanner.v1.TransactionOptions.ReadOnly) mode_);
    }
    if (modeCase_ == 3) {
      output.writeMessage(3, (com.google.spanner.v1.TransactionOptions.PartitionedDml) mode_);
    }
    if (excludeTxnFromChangeStreams_ != false) {
      output.writeBool(5, excludeTxnFromChangeStreams_);
    }
    if (isolationLevel_
        != com.google.spanner.v1.TransactionOptions.IsolationLevel.ISOLATION_LEVEL_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(6, isolationLevel_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (modeCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.spanner.v1.TransactionOptions.ReadWrite) mode_);
    }
    if (modeCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.spanner.v1.TransactionOptions.ReadOnly) mode_);
    }
    if (modeCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.spanner.v1.TransactionOptions.PartitionedDml) mode_);
    }
    if (excludeTxnFromChangeStreams_ != false) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(5, excludeTxnFromChangeStreams_);
    }
    if (isolationLevel_
        != com.google.spanner.v1.TransactionOptions.IsolationLevel.ISOLATION_LEVEL_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, isolationLevel_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.v1.TransactionOptions)) {
      return super.equals(obj);
    }
    com.google.spanner.v1.TransactionOptions other = (com.google.spanner.v1.TransactionOptions) obj;

    if (getExcludeTxnFromChangeStreams() != other.getExcludeTxnFromChangeStreams()) return false;
    if (isolationLevel_ != other.isolationLevel_) return false;
    if (!getModeCase().equals(other.getModeCase())) return false;
    switch (modeCase_) {
      case 1:
        if (!getReadWrite().equals(other.getReadWrite())) return false;
        break;
      case 3:
        if (!getPartitionedDml().equals(other.getPartitionedDml())) return false;
        break;
      case 2:
        if (!getReadOnly().equals(other.getReadOnly())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + EXCLUDE_TXN_FROM_CHANGE_STREAMS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getExcludeTxnFromChangeStreams());
    hash = (37 * hash) + ISOLATION_LEVEL_FIELD_NUMBER;
    hash = (53 * hash) + isolationLevel_;
    switch (modeCase_) {
      case 1:
        hash = (37 * hash) + READ_WRITE_FIELD_NUMBER;
        hash = (53 * hash) + getReadWrite().hashCode();
        break;
      case 3:
        hash = (37 * hash) + PARTITIONED_DML_FIELD_NUMBER;
        hash = (53 * hash) + getPartitionedDml().hashCode();
        break;
      case 2:
        hash = (37 * hash) + READ_ONLY_FIELD_NUMBER;
        hash = (53 * hash) + getReadOnly().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.v1.TransactionOptions parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.v1.TransactionOptions parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.v1.TransactionOptions parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.v1.TransactionOptions parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.v1.TransactionOptions parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.v1.TransactionOptions parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.v1.TransactionOptions parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.v1.TransactionOptions parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.v1.TransactionOptions parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.v1.TransactionOptions parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.v1.TransactionOptions parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.v1.TransactionOptions parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.spanner.v1.TransactionOptions prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Options to use for transactions.
   * </pre>
   *
   * Protobuf type {@code google.spanner.v1.TransactionOptions}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.v1.TransactionOptions)
      com.google.spanner.v1.TransactionOptionsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.v1.TransactionProto
          .internal_static_google_spanner_v1_TransactionOptions_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.v1.TransactionProto
          .internal_static_google_spanner_v1_TransactionOptions_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.v1.TransactionOptions.class,
              com.google.spanner.v1.TransactionOptions.Builder.class);
    }

    // Construct using com.google.spanner.v1.TransactionOptions.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (readWriteBuilder_ != null) {
        readWriteBuilder_.clear();
      }
      if (partitionedDmlBuilder_ != null) {
        partitionedDmlBuilder_.clear();
      }
      if (readOnlyBuilder_ != null) {
        readOnlyBuilder_.clear();
      }
      excludeTxnFromChangeStreams_ = false;
      isolationLevel_ = 0;
      modeCase_ = 0;
      mode_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.v1.TransactionProto
          .internal_static_google_spanner_v1_TransactionOptions_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.v1.TransactionOptions getDefaultInstanceForType() {
      return com.google.spanner.v1.TransactionOptions.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.v1.TransactionOptions build() {
      com.google.spanner.v1.TransactionOptions result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.v1.TransactionOptions buildPartial() {
      com.google.spanner.v1.TransactionOptions result =
          new com.google.spanner.v1.TransactionOptions(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.spanner.v1.TransactionOptions result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.excludeTxnFromChangeStreams_ = excludeTxnFromChangeStreams_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.isolationLevel_ = isolationLevel_;
      }
    }

    private void buildPartialOneofs(com.google.spanner.v1.TransactionOptions result) {
      result.modeCase_ = modeCase_;
      result.mode_ = this.mode_;
      if (modeCase_ == 1 && readWriteBuilder_ != null) {
        result.mode_ = readWriteBuilder_.build();
      }
      if (modeCase_ == 3 && partitionedDmlBuilder_ != null) {
        result.mode_ = partitionedDmlBuilder_.build();
      }
      if (modeCase_ == 2 && readOnlyBuilder_ != null) {
        result.mode_ = readOnlyBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.v1.TransactionOptions) {
        return mergeFrom((com.google.spanner.v1.TransactionOptions) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.v1.TransactionOptions other) {
      if (other == com.google.spanner.v1.TransactionOptions.getDefaultInstance()) return this;
      if (other.getExcludeTxnFromChangeStreams() != false) {
        setExcludeTxnFromChangeStreams(other.getExcludeTxnFromChangeStreams());
      }
      if (other.isolationLevel_ != 0) {
        setIsolationLevelValue(other.getIsolationLevelValue());
      }
      switch (other.getModeCase()) {
        case READ_WRITE:
          {
            mergeReadWrite(other.getReadWrite());
            break;
          }
        case PARTITIONED_DML:
          {
            mergePartitionedDml(other.getPartitionedDml());
            break;
          }
        case READ_ONLY:
          {
            mergeReadOnly(other.getReadOnly());
            break;
          }
        case MODE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getReadWriteFieldBuilder().getBuilder(), extensionRegistry);
                modeCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getReadOnlyFieldBuilder().getBuilder(), extensionRegistry);
                modeCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getPartitionedDmlFieldBuilder().getBuilder(), extensionRegistry);
                modeCase_ = 3;
                break;
              } // case 26
            case 40:
              {
                excludeTxnFromChangeStreams_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 40
            case 48:
              {
                isolationLevel_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 48
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int modeCase_ = 0;
    private java.lang.Object mode_;

    public ModeCase getModeCase() {
      return ModeCase.forNumber(modeCase_);
    }

    public Builder clearMode() {
      modeCase_ = 0;
      mode_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.TransactionOptions.ReadWrite,
            com.google.spanner.v1.TransactionOptions.ReadWrite.Builder,
            com.google.spanner.v1.TransactionOptions.ReadWriteOrBuilder>
        readWriteBuilder_;

    /**
     *
     *
     * <pre>
     * Transaction may write.
     *
     * Authorization to begin a read-write transaction requires
     * `spanner.databases.beginOrRollbackReadWriteTransaction` permission
     * on the `session` resource.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.ReadWrite read_write = 1;</code>
     *
     * @return Whether the readWrite field is set.
     */
    @java.lang.Override
    public boolean hasReadWrite() {
      return modeCase_ == 1;
    }

    /**
     *
     *
     * <pre>
     * Transaction may write.
     *
     * Authorization to begin a read-write transaction requires
     * `spanner.databases.beginOrRollbackReadWriteTransaction` permission
     * on the `session` resource.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.ReadWrite read_write = 1;</code>
     *
     * @return The readWrite.
     */
    @java.lang.Override
    public com.google.spanner.v1.TransactionOptions.ReadWrite getReadWrite() {
      if (readWriteBuilder_ == null) {
        if (modeCase_ == 1) {
          return (com.google.spanner.v1.TransactionOptions.ReadWrite) mode_;
        }
        return com.google.spanner.v1.TransactionOptions.ReadWrite.getDefaultInstance();
      } else {
        if (modeCase_ == 1) {
          return readWriteBuilder_.getMessage();
        }
        return com.google.spanner.v1.TransactionOptions.ReadWrite.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Transaction may write.
     *
     * Authorization to begin a read-write transaction requires
     * `spanner.databases.beginOrRollbackReadWriteTransaction` permission
     * on the `session` resource.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.ReadWrite read_write = 1;</code>
     */
    public Builder setReadWrite(com.google.spanner.v1.TransactionOptions.ReadWrite value) {
      if (readWriteBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        mode_ = value;
        onChanged();
      } else {
        readWriteBuilder_.setMessage(value);
      }
      modeCase_ = 1;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Transaction may write.
     *
     * Authorization to begin a read-write transaction requires
     * `spanner.databases.beginOrRollbackReadWriteTransaction` permission
     * on the `session` resource.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.ReadWrite read_write = 1;</code>
     */
    public Builder setReadWrite(
        com.google.spanner.v1.TransactionOptions.ReadWrite.Builder builderForValue) {
      if (readWriteBuilder_ == null) {
        mode_ = builderForValue.build();
        onChanged();
      } else {
        readWriteBuilder_.setMessage(builderForValue.build());
      }
      modeCase_ = 1;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Transaction may write.
     *
     * Authorization to begin a read-write transaction requires
     * `spanner.databases.beginOrRollbackReadWriteTransaction` permission
     * on the `session` resource.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.ReadWrite read_write = 1;</code>
     */
    public Builder mergeReadWrite(com.google.spanner.v1.TransactionOptions.ReadWrite value) {
      if (readWriteBuilder_ == null) {
        if (modeCase_ == 1
            && mode_ != com.google.spanner.v1.TransactionOptions.ReadWrite.getDefaultInstance()) {
          mode_ =
              com.google.spanner.v1.TransactionOptions.ReadWrite.newBuilder(
                      (com.google.spanner.v1.TransactionOptions.ReadWrite) mode_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          mode_ = value;
        }
        onChanged();
      } else {
        if (modeCase_ == 1) {
          readWriteBuilder_.mergeFrom(value);
        } else {
          readWriteBuilder_.setMessage(value);
        }
      }
      modeCase_ = 1;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Transaction may write.
     *
     * Authorization to begin a read-write transaction requires
     * `spanner.databases.beginOrRollbackReadWriteTransaction` permission
     * on the `session` resource.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.ReadWrite read_write = 1;</code>
     */
    public Builder clearReadWrite() {
      if (readWriteBuilder_ == null) {
        if (modeCase_ == 1) {
          modeCase_ = 0;
          mode_ = null;
          onChanged();
        }
      } else {
        if (modeCase_ == 1) {
          modeCase_ = 0;
          mode_ = null;
        }
        readWriteBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Transaction may write.
     *
     * Authorization to begin a read-write transaction requires
     * `spanner.databases.beginOrRollbackReadWriteTransaction` permission
     * on the `session` resource.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.ReadWrite read_write = 1;</code>
     */
    public com.google.spanner.v1.TransactionOptions.ReadWrite.Builder getReadWriteBuilder() {
      return getReadWriteFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Transaction may write.
     *
     * Authorization to begin a read-write transaction requires
     * `spanner.databases.beginOrRollbackReadWriteTransaction` permission
     * on the `session` resource.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.ReadWrite read_write = 1;</code>
     */
    @java.lang.Override
    public com.google.spanner.v1.TransactionOptions.ReadWriteOrBuilder getReadWriteOrBuilder() {
      if ((modeCase_ == 1) && (readWriteBuilder_ != null)) {
        return readWriteBuilder_.getMessageOrBuilder();
      } else {
        if (modeCase_ == 1) {
          return (com.google.spanner.v1.TransactionOptions.ReadWrite) mode_;
        }
        return com.google.spanner.v1.TransactionOptions.ReadWrite.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Transaction may write.
     *
     * Authorization to begin a read-write transaction requires
     * `spanner.databases.beginOrRollbackReadWriteTransaction` permission
     * on the `session` resource.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.ReadWrite read_write = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.TransactionOptions.ReadWrite,
            com.google.spanner.v1.TransactionOptions.ReadWrite.Builder,
            com.google.spanner.v1.TransactionOptions.ReadWriteOrBuilder>
        getReadWriteFieldBuilder() {
      if (readWriteBuilder_ == null) {
        if (!(modeCase_ == 1)) {
          mode_ = com.google.spanner.v1.TransactionOptions.ReadWrite.getDefaultInstance();
        }
        readWriteBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.v1.TransactionOptions.ReadWrite,
                com.google.spanner.v1.TransactionOptions.ReadWrite.Builder,
                com.google.spanner.v1.TransactionOptions.ReadWriteOrBuilder>(
                (com.google.spanner.v1.TransactionOptions.ReadWrite) mode_,
                getParentForChildren(),
                isClean());
        mode_ = null;
      }
      modeCase_ = 1;
      onChanged();
      return readWriteBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.TransactionOptions.PartitionedDml,
            com.google.spanner.v1.TransactionOptions.PartitionedDml.Builder,
            com.google.spanner.v1.TransactionOptions.PartitionedDmlOrBuilder>
        partitionedDmlBuilder_;

    /**
     *
     *
     * <pre>
     * Partitioned DML transaction.
     *
     * Authorization to begin a Partitioned DML transaction requires
     * `spanner.databases.beginPartitionedDmlTransaction` permission
     * on the `session` resource.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.PartitionedDml partitioned_dml = 3;</code>
     *
     * @return Whether the partitionedDml field is set.
     */
    @java.lang.Override
    public boolean hasPartitionedDml() {
      return modeCase_ == 3;
    }

    /**
     *
     *
     * <pre>
     * Partitioned DML transaction.
     *
     * Authorization to begin a Partitioned DML transaction requires
     * `spanner.databases.beginPartitionedDmlTransaction` permission
     * on the `session` resource.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.PartitionedDml partitioned_dml = 3;</code>
     *
     * @return The partitionedDml.
     */
    @java.lang.Override
    public com.google.spanner.v1.TransactionOptions.PartitionedDml getPartitionedDml() {
      if (partitionedDmlBuilder_ == null) {
        if (modeCase_ == 3) {
          return (com.google.spanner.v1.TransactionOptions.PartitionedDml) mode_;
        }
        return com.google.spanner.v1.TransactionOptions.PartitionedDml.getDefaultInstance();
      } else {
        if (modeCase_ == 3) {
          return partitionedDmlBuilder_.getMessage();
        }
        return com.google.spanner.v1.TransactionOptions.PartitionedDml.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Partitioned DML transaction.
     *
     * Authorization to begin a Partitioned DML transaction requires
     * `spanner.databases.beginPartitionedDmlTransaction` permission
     * on the `session` resource.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.PartitionedDml partitioned_dml = 3;</code>
     */
    public Builder setPartitionedDml(
        com.google.spanner.v1.TransactionOptions.PartitionedDml value) {
      if (partitionedDmlBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        mode_ = value;
        onChanged();
      } else {
        partitionedDmlBuilder_.setMessage(value);
      }
      modeCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Partitioned DML transaction.
     *
     * Authorization to begin a Partitioned DML transaction requires
     * `spanner.databases.beginPartitionedDmlTransaction` permission
     * on the `session` resource.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.PartitionedDml partitioned_dml = 3;</code>
     */
    public Builder setPartitionedDml(
        com.google.spanner.v1.TransactionOptions.PartitionedDml.Builder builderForValue) {
      if (partitionedDmlBuilder_ == null) {
        mode_ = builderForValue.build();
        onChanged();
      } else {
        partitionedDmlBuilder_.setMessage(builderForValue.build());
      }
      modeCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Partitioned DML transaction.
     *
     * Authorization to begin a Partitioned DML transaction requires
     * `spanner.databases.beginPartitionedDmlTransaction` permission
     * on the `session` resource.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.PartitionedDml partitioned_dml = 3;</code>
     */
    public Builder mergePartitionedDml(
        com.google.spanner.v1.TransactionOptions.PartitionedDml value) {
      if (partitionedDmlBuilder_ == null) {
        if (modeCase_ == 3
            && mode_
                != com.google.spanner.v1.TransactionOptions.PartitionedDml.getDefaultInstance()) {
          mode_ =
              com.google.spanner.v1.TransactionOptions.PartitionedDml.newBuilder(
                      (com.google.spanner.v1.TransactionOptions.PartitionedDml) mode_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          mode_ = value;
        }
        onChanged();
      } else {
        if (modeCase_ == 3) {
          partitionedDmlBuilder_.mergeFrom(value);
        } else {
          partitionedDmlBuilder_.setMessage(value);
        }
      }
      modeCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Partitioned DML transaction.
     *
     * Authorization to begin a Partitioned DML transaction requires
     * `spanner.databases.beginPartitionedDmlTransaction` permission
     * on the `session` resource.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.PartitionedDml partitioned_dml = 3;</code>
     */
    public Builder clearPartitionedDml() {
      if (partitionedDmlBuilder_ == null) {
        if (modeCase_ == 3) {
          modeCase_ = 0;
          mode_ = null;
          onChanged();
        }
      } else {
        if (modeCase_ == 3) {
          modeCase_ = 0;
          mode_ = null;
        }
        partitionedDmlBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Partitioned DML transaction.
     *
     * Authorization to begin a Partitioned DML transaction requires
     * `spanner.databases.beginPartitionedDmlTransaction` permission
     * on the `session` resource.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.PartitionedDml partitioned_dml = 3;</code>
     */
    public com.google.spanner.v1.TransactionOptions.PartitionedDml.Builder
        getPartitionedDmlBuilder() {
      return getPartitionedDmlFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Partitioned DML transaction.
     *
     * Authorization to begin a Partitioned DML transaction requires
     * `spanner.databases.beginPartitionedDmlTransaction` permission
     * on the `session` resource.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.PartitionedDml partitioned_dml = 3;</code>
     */
    @java.lang.Override
    public com.google.spanner.v1.TransactionOptions.PartitionedDmlOrBuilder
        getPartitionedDmlOrBuilder() {
      if ((modeCase_ == 3) && (partitionedDmlBuilder_ != null)) {
        return partitionedDmlBuilder_.getMessageOrBuilder();
      } else {
        if (modeCase_ == 3) {
          return (com.google.spanner.v1.TransactionOptions.PartitionedDml) mode_;
        }
        return com.google.spanner.v1.TransactionOptions.PartitionedDml.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Partitioned DML transaction.
     *
     * Authorization to begin a Partitioned DML transaction requires
     * `spanner.databases.beginPartitionedDmlTransaction` permission
     * on the `session` resource.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.PartitionedDml partitioned_dml = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.TransactionOptions.PartitionedDml,
            com.google.spanner.v1.TransactionOptions.PartitionedDml.Builder,
            com.google.spanner.v1.TransactionOptions.PartitionedDmlOrBuilder>
        getPartitionedDmlFieldBuilder() {
      if (partitionedDmlBuilder_ == null) {
        if (!(modeCase_ == 3)) {
          mode_ = com.google.spanner.v1.TransactionOptions.PartitionedDml.getDefaultInstance();
        }
        partitionedDmlBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.v1.TransactionOptions.PartitionedDml,
                com.google.spanner.v1.TransactionOptions.PartitionedDml.Builder,
                com.google.spanner.v1.TransactionOptions.PartitionedDmlOrBuilder>(
                (com.google.spanner.v1.TransactionOptions.PartitionedDml) mode_,
                getParentForChildren(),
                isClean());
        mode_ = null;
      }
      modeCase_ = 3;
      onChanged();
      return partitionedDmlBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.TransactionOptions.ReadOnly,
            com.google.spanner.v1.TransactionOptions.ReadOnly.Builder,
            com.google.spanner.v1.TransactionOptions.ReadOnlyOrBuilder>
        readOnlyBuilder_;

    /**
     *
     *
     * <pre>
     * Transaction does not write.
     *
     * Authorization to begin a read-only transaction requires
     * `spanner.databases.beginReadOnlyTransaction` permission
     * on the `session` resource.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.ReadOnly read_only = 2;</code>
     *
     * @return Whether the readOnly field is set.
     */
    @java.lang.Override
    public boolean hasReadOnly() {
      return modeCase_ == 2;
    }

    /**
     *
     *
     * <pre>
     * Transaction does not write.
     *
     * Authorization to begin a read-only transaction requires
     * `spanner.databases.beginReadOnlyTransaction` permission
     * on the `session` resource.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.ReadOnly read_only = 2;</code>
     *
     * @return The readOnly.
     */
    @java.lang.Override
    public com.google.spanner.v1.TransactionOptions.ReadOnly getReadOnly() {
      if (readOnlyBuilder_ == null) {
        if (modeCase_ == 2) {
          return (com.google.spanner.v1.TransactionOptions.ReadOnly) mode_;
        }
        return com.google.spanner.v1.TransactionOptions.ReadOnly.getDefaultInstance();
      } else {
        if (modeCase_ == 2) {
          return readOnlyBuilder_.getMessage();
        }
        return com.google.spanner.v1.TransactionOptions.ReadOnly.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Transaction does not write.
     *
     * Authorization to begin a read-only transaction requires
     * `spanner.databases.beginReadOnlyTransaction` permission
     * on the `session` resource.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.ReadOnly read_only = 2;</code>
     */
    public Builder setReadOnly(com.google.spanner.v1.TransactionOptions.ReadOnly value) {
      if (readOnlyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        mode_ = value;
        onChanged();
      } else {
        readOnlyBuilder_.setMessage(value);
      }
      modeCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Transaction does not write.
     *
     * Authorization to begin a read-only transaction requires
     * `spanner.databases.beginReadOnlyTransaction` permission
     * on the `session` resource.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.ReadOnly read_only = 2;</code>
     */
    public Builder setReadOnly(
        com.google.spanner.v1.TransactionOptions.ReadOnly.Builder builderForValue) {
      if (readOnlyBuilder_ == null) {
        mode_ = builderForValue.build();
        onChanged();
      } else {
        readOnlyBuilder_.setMessage(builderForValue.build());
      }
      modeCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Transaction does not write.
     *
     * Authorization to begin a read-only transaction requires
     * `spanner.databases.beginReadOnlyTransaction` permission
     * on the `session` resource.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.ReadOnly read_only = 2;</code>
     */
    public Builder mergeReadOnly(com.google.spanner.v1.TransactionOptions.ReadOnly value) {
      if (readOnlyBuilder_ == null) {
        if (modeCase_ == 2
            && mode_ != com.google.spanner.v1.TransactionOptions.ReadOnly.getDefaultInstance()) {
          mode_ =
              com.google.spanner.v1.TransactionOptions.ReadOnly.newBuilder(
                      (com.google.spanner.v1.TransactionOptions.ReadOnly) mode_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          mode_ = value;
        }
        onChanged();
      } else {
        if (modeCase_ == 2) {
          readOnlyBuilder_.mergeFrom(value);
        } else {
          readOnlyBuilder_.setMessage(value);
        }
      }
      modeCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Transaction does not write.
     *
     * Authorization to begin a read-only transaction requires
     * `spanner.databases.beginReadOnlyTransaction` permission
     * on the `session` resource.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.ReadOnly read_only = 2;</code>
     */
    public Builder clearReadOnly() {
      if (readOnlyBuilder_ == null) {
        if (modeCase_ == 2) {
          modeCase_ = 0;
          mode_ = null;
          onChanged();
        }
      } else {
        if (modeCase_ == 2) {
          modeCase_ = 0;
          mode_ = null;
        }
        readOnlyBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Transaction does not write.
     *
     * Authorization to begin a read-only transaction requires
     * `spanner.databases.beginReadOnlyTransaction` permission
     * on the `session` resource.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.ReadOnly read_only = 2;</code>
     */
    public com.google.spanner.v1.TransactionOptions.ReadOnly.Builder getReadOnlyBuilder() {
      return getReadOnlyFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Transaction does not write.
     *
     * Authorization to begin a read-only transaction requires
     * `spanner.databases.beginReadOnlyTransaction` permission
     * on the `session` resource.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.ReadOnly read_only = 2;</code>
     */
    @java.lang.Override
    public com.google.spanner.v1.TransactionOptions.ReadOnlyOrBuilder getReadOnlyOrBuilder() {
      if ((modeCase_ == 2) && (readOnlyBuilder_ != null)) {
        return readOnlyBuilder_.getMessageOrBuilder();
      } else {
        if (modeCase_ == 2) {
          return (com.google.spanner.v1.TransactionOptions.ReadOnly) mode_;
        }
        return com.google.spanner.v1.TransactionOptions.ReadOnly.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Transaction does not write.
     *
     * Authorization to begin a read-only transaction requires
     * `spanner.databases.beginReadOnlyTransaction` permission
     * on the `session` resource.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.ReadOnly read_only = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.TransactionOptions.ReadOnly,
            com.google.spanner.v1.TransactionOptions.ReadOnly.Builder,
            com.google.spanner.v1.TransactionOptions.ReadOnlyOrBuilder>
        getReadOnlyFieldBuilder() {
      if (readOnlyBuilder_ == null) {
        if (!(modeCase_ == 2)) {
          mode_ = com.google.spanner.v1.TransactionOptions.ReadOnly.getDefaultInstance();
        }
        readOnlyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.v1.TransactionOptions.ReadOnly,
                com.google.spanner.v1.TransactionOptions.ReadOnly.Builder,
                com.google.spanner.v1.TransactionOptions.ReadOnlyOrBuilder>(
                (com.google.spanner.v1.TransactionOptions.ReadOnly) mode_,
                getParentForChildren(),
                isClean());
        mode_ = null;
      }
      modeCase_ = 2;
      onChanged();
      return readOnlyBuilder_;
    }

    private boolean excludeTxnFromChangeStreams_;

    /**
     *
     *
     * <pre>
     * When `exclude_txn_from_change_streams` is set to `true`, it prevents read
     * or write transactions from being tracked in change streams.
     *
     * * If the DDL option `allow_txn_exclusion` is set to `true`, then the
     * updates
     *  made within this transaction aren't recorded in the change stream.
     *
     * * If you don't set the DDL option `allow_txn_exclusion` or if it's
     *  set to `false`, then the updates made within this transaction are
     *  recorded in the change stream.
     *
     * When `exclude_txn_from_change_streams` is set to `false` or not set,
     * modifications from this transaction are recorded in all change streams
     * that are tracking columns modified by these transactions.
     *
     * The `exclude_txn_from_change_streams` option can only be specified
     * for read-write or partitioned DML transactions, otherwise the API returns
     * an `INVALID_ARGUMENT` error.
     * </pre>
     *
     * <code>bool exclude_txn_from_change_streams = 5;</code>
     *
     * @return The excludeTxnFromChangeStreams.
     */
    @java.lang.Override
    public boolean getExcludeTxnFromChangeStreams() {
      return excludeTxnFromChangeStreams_;
    }

    /**
     *
     *
     * <pre>
     * When `exclude_txn_from_change_streams` is set to `true`, it prevents read
     * or write transactions from being tracked in change streams.
     *
     * * If the DDL option `allow_txn_exclusion` is set to `true`, then the
     * updates
     *  made within this transaction aren't recorded in the change stream.
     *
     * * If you don't set the DDL option `allow_txn_exclusion` or if it's
     *  set to `false`, then the updates made within this transaction are
     *  recorded in the change stream.
     *
     * When `exclude_txn_from_change_streams` is set to `false` or not set,
     * modifications from this transaction are recorded in all change streams
     * that are tracking columns modified by these transactions.
     *
     * The `exclude_txn_from_change_streams` option can only be specified
     * for read-write or partitioned DML transactions, otherwise the API returns
     * an `INVALID_ARGUMENT` error.
     * </pre>
     *
     * <code>bool exclude_txn_from_change_streams = 5;</code>
     *
     * @param value The excludeTxnFromChangeStreams to set.
     * @return This builder for chaining.
     */
    public Builder setExcludeTxnFromChangeStreams(boolean value) {

      excludeTxnFromChangeStreams_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * When `exclude_txn_from_change_streams` is set to `true`, it prevents read
     * or write transactions from being tracked in change streams.
     *
     * * If the DDL option `allow_txn_exclusion` is set to `true`, then the
     * updates
     *  made within this transaction aren't recorded in the change stream.
     *
     * * If you don't set the DDL option `allow_txn_exclusion` or if it's
     *  set to `false`, then the updates made within this transaction are
     *  recorded in the change stream.
     *
     * When `exclude_txn_from_change_streams` is set to `false` or not set,
     * modifications from this transaction are recorded in all change streams
     * that are tracking columns modified by these transactions.
     *
     * The `exclude_txn_from_change_streams` option can only be specified
     * for read-write or partitioned DML transactions, otherwise the API returns
     * an `INVALID_ARGUMENT` error.
     * </pre>
     *
     * <code>bool exclude_txn_from_change_streams = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExcludeTxnFromChangeStreams() {
      bitField0_ = (bitField0_ & ~0x00000008);
      excludeTxnFromChangeStreams_ = false;
      onChanged();
      return this;
    }

    private int isolationLevel_ = 0;

    /**
     *
     *
     * <pre>
     * Isolation level for the transaction.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.IsolationLevel isolation_level = 6;</code>
     *
     * @return The enum numeric value on the wire for isolationLevel.
     */
    @java.lang.Override
    public int getIsolationLevelValue() {
      return isolationLevel_;
    }

    /**
     *
     *
     * <pre>
     * Isolation level for the transaction.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.IsolationLevel isolation_level = 6;</code>
     *
     * @param value The enum numeric value on the wire for isolationLevel to set.
     * @return This builder for chaining.
     */
    public Builder setIsolationLevelValue(int value) {
      isolationLevel_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Isolation level for the transaction.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.IsolationLevel isolation_level = 6;</code>
     *
     * @return The isolationLevel.
     */
    @java.lang.Override
    public com.google.spanner.v1.TransactionOptions.IsolationLevel getIsolationLevel() {
      com.google.spanner.v1.TransactionOptions.IsolationLevel result =
          com.google.spanner.v1.TransactionOptions.IsolationLevel.forNumber(isolationLevel_);
      return result == null
          ? com.google.spanner.v1.TransactionOptions.IsolationLevel.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * Isolation level for the transaction.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.IsolationLevel isolation_level = 6;</code>
     *
     * @param value The isolationLevel to set.
     * @return This builder for chaining.
     */
    public Builder setIsolationLevel(
        com.google.spanner.v1.TransactionOptions.IsolationLevel value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      isolationLevel_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Isolation level for the transaction.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.IsolationLevel isolation_level = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIsolationLevel() {
      bitField0_ = (bitField0_ & ~0x00000010);
      isolationLevel_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.v1.TransactionOptions)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.v1.TransactionOptions)
  private static final com.google.spanner.v1.TransactionOptions DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.v1.TransactionOptions();
  }

  public static com.google.spanner.v1.TransactionOptions getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TransactionOptions> PARSER =
      new com.google.protobuf.AbstractParser<TransactionOptions>() {
        @java.lang.Override
        public TransactionOptions parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TransactionOptions> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TransactionOptions> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.v1.TransactionOptions getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
