/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/v1/transaction.proto

// Protobuf Java Version: 3.25.8
package com.google.spanner.v1;

/**
 *
 *
 * <pre>
 * When a read-write transaction is executed on a multiplexed session,
 * this precommit token is sent back to the client
 * as a part of the [Transaction][google.spanner.v1.Transaction] message in the
 * [BeginTransaction][google.spanner.v1.BeginTransactionRequest] response and
 * also as a part of the [ResultSet][google.spanner.v1.ResultSet] and
 * [PartialResultSet][google.spanner.v1.PartialResultSet] responses.
 * </pre>
 *
 * Protobuf type {@code google.spanner.v1.MultiplexedSessionPrecommitToken}
 */
public final class MultiplexedSessionPrecommitToken extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.v1.MultiplexedSessionPrecommitToken)
    MultiplexedSessionPrecommitTokenOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use MultiplexedSessionPrecommitToken.newBuilder() to construct.
  private MultiplexedSessionPrecommitToken(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private MultiplexedSessionPrecommitToken() {
    precommitToken_ = com.google.protobuf.ByteString.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new MultiplexedSessionPrecommitToken();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.v1.TransactionProto
        .internal_static_google_spanner_v1_MultiplexedSessionPrecommitToken_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.v1.TransactionProto
        .internal_static_google_spanner_v1_MultiplexedSessionPrecommitToken_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.v1.MultiplexedSessionPrecommitToken.class,
            com.google.spanner.v1.MultiplexedSessionPrecommitToken.Builder.class);
  }

  public static final int PRECOMMIT_TOKEN_FIELD_NUMBER = 1;
  private com.google.protobuf.ByteString precommitToken_ = com.google.protobuf.ByteString.EMPTY;

  /**
   *
   *
   * <pre>
   * Opaque precommit token.
   * </pre>
   *
   * <code>bytes precommit_token = 1;</code>
   *
   * @return The precommitToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPrecommitToken() {
    return precommitToken_;
  }

  public static final int SEQ_NUM_FIELD_NUMBER = 2;
  private int seqNum_ = 0;

  /**
   *
   *
   * <pre>
   * An incrementing seq number is generated on every precommit token
   * that is returned. Clients should remember the precommit token with the
   * highest sequence number from the current transaction attempt.
   * </pre>
   *
   * <code>int32 seq_num = 2;</code>
   *
   * @return The seqNum.
   */
  @java.lang.Override
  public int getSeqNum() {
    return seqNum_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!precommitToken_.isEmpty()) {
      output.writeBytes(1, precommitToken_);
    }
    if (seqNum_ != 0) {
      output.writeInt32(2, seqNum_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!precommitToken_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(1, precommitToken_);
    }
    if (seqNum_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, seqNum_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.v1.MultiplexedSessionPrecommitToken)) {
      return super.equals(obj);
    }
    com.google.spanner.v1.MultiplexedSessionPrecommitToken other =
        (com.google.spanner.v1.MultiplexedSessionPrecommitToken) obj;

    if (!getPrecommitToken().equals(other.getPrecommitToken())) return false;
    if (getSeqNum() != other.getSeqNum()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PRECOMMIT_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getPrecommitToken().hashCode();
    hash = (37 * hash) + SEQ_NUM_FIELD_NUMBER;
    hash = (53 * hash) + getSeqNum();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.v1.MultiplexedSessionPrecommitToken parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.v1.MultiplexedSessionPrecommitToken parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.v1.MultiplexedSessionPrecommitToken parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.v1.MultiplexedSessionPrecommitToken parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.v1.MultiplexedSessionPrecommitToken parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.v1.MultiplexedSessionPrecommitToken parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.v1.MultiplexedSessionPrecommitToken parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.v1.MultiplexedSessionPrecommitToken parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.v1.MultiplexedSessionPrecommitToken parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.v1.MultiplexedSessionPrecommitToken parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.v1.MultiplexedSessionPrecommitToken parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.v1.MultiplexedSessionPrecommitToken parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.spanner.v1.MultiplexedSessionPrecommitToken prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * When a read-write transaction is executed on a multiplexed session,
   * this precommit token is sent back to the client
   * as a part of the [Transaction][google.spanner.v1.Transaction] message in the
   * [BeginTransaction][google.spanner.v1.BeginTransactionRequest] response and
   * also as a part of the [ResultSet][google.spanner.v1.ResultSet] and
   * [PartialResultSet][google.spanner.v1.PartialResultSet] responses.
   * </pre>
   *
   * Protobuf type {@code google.spanner.v1.MultiplexedSessionPrecommitToken}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.v1.MultiplexedSessionPrecommitToken)
      com.google.spanner.v1.MultiplexedSessionPrecommitTokenOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.v1.TransactionProto
          .internal_static_google_spanner_v1_MultiplexedSessionPrecommitToken_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.v1.TransactionProto
          .internal_static_google_spanner_v1_MultiplexedSessionPrecommitToken_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.v1.MultiplexedSessionPrecommitToken.class,
              com.google.spanner.v1.MultiplexedSessionPrecommitToken.Builder.class);
    }

    // Construct using com.google.spanner.v1.MultiplexedSessionPrecommitToken.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      precommitToken_ = com.google.protobuf.ByteString.EMPTY;
      seqNum_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.v1.TransactionProto
          .internal_static_google_spanner_v1_MultiplexedSessionPrecommitToken_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.v1.MultiplexedSessionPrecommitToken getDefaultInstanceForType() {
      return com.google.spanner.v1.MultiplexedSessionPrecommitToken.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.v1.MultiplexedSessionPrecommitToken build() {
      com.google.spanner.v1.MultiplexedSessionPrecommitToken result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.v1.MultiplexedSessionPrecommitToken buildPartial() {
      com.google.spanner.v1.MultiplexedSessionPrecommitToken result =
          new com.google.spanner.v1.MultiplexedSessionPrecommitToken(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.spanner.v1.MultiplexedSessionPrecommitToken result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.precommitToken_ = precommitToken_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.seqNum_ = seqNum_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.v1.MultiplexedSessionPrecommitToken) {
        return mergeFrom((com.google.spanner.v1.MultiplexedSessionPrecommitToken) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.v1.MultiplexedSessionPrecommitToken other) {
      if (other == com.google.spanner.v1.MultiplexedSessionPrecommitToken.getDefaultInstance())
        return this;
      if (other.getPrecommitToken() != com.google.protobuf.ByteString.EMPTY) {
        setPrecommitToken(other.getPrecommitToken());
      }
      if (other.getSeqNum() != 0) {
        setSeqNum(other.getSeqNum());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                precommitToken_ = input.readBytes();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                seqNum_ = input.readInt32();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.ByteString precommitToken_ = com.google.protobuf.ByteString.EMPTY;

    /**
     *
     *
     * <pre>
     * Opaque precommit token.
     * </pre>
     *
     * <code>bytes precommit_token = 1;</code>
     *
     * @return The precommitToken.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPrecommitToken() {
      return precommitToken_;
    }

    /**
     *
     *
     * <pre>
     * Opaque precommit token.
     * </pre>
     *
     * <code>bytes precommit_token = 1;</code>
     *
     * @param value The precommitToken to set.
     * @return This builder for chaining.
     */
    public Builder setPrecommitToken(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      precommitToken_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Opaque precommit token.
     * </pre>
     *
     * <code>bytes precommit_token = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPrecommitToken() {
      bitField0_ = (bitField0_ & ~0x00000001);
      precommitToken_ = getDefaultInstance().getPrecommitToken();
      onChanged();
      return this;
    }

    private int seqNum_;

    /**
     *
     *
     * <pre>
     * An incrementing seq number is generated on every precommit token
     * that is returned. Clients should remember the precommit token with the
     * highest sequence number from the current transaction attempt.
     * </pre>
     *
     * <code>int32 seq_num = 2;</code>
     *
     * @return The seqNum.
     */
    @java.lang.Override
    public int getSeqNum() {
      return seqNum_;
    }

    /**
     *
     *
     * <pre>
     * An incrementing seq number is generated on every precommit token
     * that is returned. Clients should remember the precommit token with the
     * highest sequence number from the current transaction attempt.
     * </pre>
     *
     * <code>int32 seq_num = 2;</code>
     *
     * @param value The seqNum to set.
     * @return This builder for chaining.
     */
    public Builder setSeqNum(int value) {

      seqNum_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An incrementing seq number is generated on every precommit token
     * that is returned. Clients should remember the precommit token with the
     * highest sequence number from the current transaction attempt.
     * </pre>
     *
     * <code>int32 seq_num = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSeqNum() {
      bitField0_ = (bitField0_ & ~0x00000002);
      seqNum_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.v1.MultiplexedSessionPrecommitToken)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.v1.MultiplexedSessionPrecommitToken)
  private static final com.google.spanner.v1.MultiplexedSessionPrecommitToken DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.v1.MultiplexedSessionPrecommitToken();
  }

  public static com.google.spanner.v1.MultiplexedSessionPrecommitToken getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<MultiplexedSessionPrecommitToken> PARSER =
      new com.google.protobuf.AbstractParser<MultiplexedSessionPrecommitToken>() {
        @java.lang.Override
        public MultiplexedSessionPrecommitToken parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<MultiplexedSessionPrecommitToken> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<MultiplexedSessionPrecommitToken> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.v1.MultiplexedSessionPrecommitToken getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
