/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/v1/spanner.proto

// Protobuf Java Version: 3.25.8
package com.google.spanner.v1;

/**
 *
 *
 * <pre>
 * The request for [BatchWrite][google.spanner.v1.Spanner.BatchWrite].
 * </pre>
 *
 * Protobuf type {@code google.spanner.v1.BatchWriteRequest}
 */
public final class BatchWriteRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.v1.BatchWriteRequest)
    BatchWriteRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use BatchWriteRequest.newBuilder() to construct.
  private BatchWriteRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BatchWriteRequest() {
    session_ = "";
    mutationGroups_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BatchWriteRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.v1.SpannerProto
        .internal_static_google_spanner_v1_BatchWriteRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.v1.SpannerProto
        .internal_static_google_spanner_v1_BatchWriteRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.v1.BatchWriteRequest.class,
            com.google.spanner.v1.BatchWriteRequest.Builder.class);
  }

  public interface MutationGroupOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.spanner.v1.BatchWriteRequest.MutationGroup)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The mutations in this group.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.Mutation mutations = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    java.util.List<com.google.spanner.v1.Mutation> getMutationsList();

    /**
     *
     *
     * <pre>
     * Required. The mutations in this group.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.Mutation mutations = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.spanner.v1.Mutation getMutations(int index);

    /**
     *
     *
     * <pre>
     * Required. The mutations in this group.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.Mutation mutations = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    int getMutationsCount();

    /**
     *
     *
     * <pre>
     * Required. The mutations in this group.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.Mutation mutations = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    java.util.List<? extends com.google.spanner.v1.MutationOrBuilder> getMutationsOrBuilderList();

    /**
     *
     *
     * <pre>
     * Required. The mutations in this group.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.Mutation mutations = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.spanner.v1.MutationOrBuilder getMutationsOrBuilder(int index);
  }

  /**
   *
   *
   * <pre>
   * A group of mutations to be committed together. Related mutations should be
   * placed in a group. For example, two mutations inserting rows with the same
   * primary key prefix in both parent and child tables are related.
   * </pre>
   *
   * Protobuf type {@code google.spanner.v1.BatchWriteRequest.MutationGroup}
   */
  public static final class MutationGroup extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.spanner.v1.BatchWriteRequest.MutationGroup)
      MutationGroupOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use MutationGroup.newBuilder() to construct.
    private MutationGroup(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private MutationGroup() {
      mutations_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new MutationGroup();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.v1.SpannerProto
          .internal_static_google_spanner_v1_BatchWriteRequest_MutationGroup_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.v1.SpannerProto
          .internal_static_google_spanner_v1_BatchWriteRequest_MutationGroup_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.v1.BatchWriteRequest.MutationGroup.class,
              com.google.spanner.v1.BatchWriteRequest.MutationGroup.Builder.class);
    }

    public static final int MUTATIONS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<com.google.spanner.v1.Mutation> mutations_;

    /**
     *
     *
     * <pre>
     * Required. The mutations in this group.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.Mutation mutations = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.spanner.v1.Mutation> getMutationsList() {
      return mutations_;
    }

    /**
     *
     *
     * <pre>
     * Required. The mutations in this group.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.Mutation mutations = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.spanner.v1.MutationOrBuilder>
        getMutationsOrBuilderList() {
      return mutations_;
    }

    /**
     *
     *
     * <pre>
     * Required. The mutations in this group.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.Mutation mutations = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public int getMutationsCount() {
      return mutations_.size();
    }

    /**
     *
     *
     * <pre>
     * Required. The mutations in this group.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.Mutation mutations = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.spanner.v1.Mutation getMutations(int index) {
      return mutations_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Required. The mutations in this group.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.Mutation mutations = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.spanner.v1.MutationOrBuilder getMutationsOrBuilder(int index) {
      return mutations_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < mutations_.size(); i++) {
        output.writeMessage(1, mutations_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < mutations_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, mutations_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.spanner.v1.BatchWriteRequest.MutationGroup)) {
        return super.equals(obj);
      }
      com.google.spanner.v1.BatchWriteRequest.MutationGroup other =
          (com.google.spanner.v1.BatchWriteRequest.MutationGroup) obj;

      if (!getMutationsList().equals(other.getMutationsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getMutationsCount() > 0) {
        hash = (37 * hash) + MUTATIONS_FIELD_NUMBER;
        hash = (53 * hash) + getMutationsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.spanner.v1.BatchWriteRequest.MutationGroup parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.BatchWriteRequest.MutationGroup parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.BatchWriteRequest.MutationGroup parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.BatchWriteRequest.MutationGroup parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.BatchWriteRequest.MutationGroup parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.BatchWriteRequest.MutationGroup parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.BatchWriteRequest.MutationGroup parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.BatchWriteRequest.MutationGroup parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.spanner.v1.BatchWriteRequest.MutationGroup parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.BatchWriteRequest.MutationGroup parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.spanner.v1.BatchWriteRequest.MutationGroup parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.BatchWriteRequest.MutationGroup parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.spanner.v1.BatchWriteRequest.MutationGroup prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * A group of mutations to be committed together. Related mutations should be
     * placed in a group. For example, two mutations inserting rows with the same
     * primary key prefix in both parent and child tables are related.
     * </pre>
     *
     * Protobuf type {@code google.spanner.v1.BatchWriteRequest.MutationGroup}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.spanner.v1.BatchWriteRequest.MutationGroup)
        com.google.spanner.v1.BatchWriteRequest.MutationGroupOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.spanner.v1.SpannerProto
            .internal_static_google_spanner_v1_BatchWriteRequest_MutationGroup_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.spanner.v1.SpannerProto
            .internal_static_google_spanner_v1_BatchWriteRequest_MutationGroup_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.spanner.v1.BatchWriteRequest.MutationGroup.class,
                com.google.spanner.v1.BatchWriteRequest.MutationGroup.Builder.class);
      }

      // Construct using com.google.spanner.v1.BatchWriteRequest.MutationGroup.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (mutationsBuilder_ == null) {
          mutations_ = java.util.Collections.emptyList();
        } else {
          mutations_ = null;
          mutationsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.spanner.v1.SpannerProto
            .internal_static_google_spanner_v1_BatchWriteRequest_MutationGroup_descriptor;
      }

      @java.lang.Override
      public com.google.spanner.v1.BatchWriteRequest.MutationGroup getDefaultInstanceForType() {
        return com.google.spanner.v1.BatchWriteRequest.MutationGroup.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.spanner.v1.BatchWriteRequest.MutationGroup build() {
        com.google.spanner.v1.BatchWriteRequest.MutationGroup result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.spanner.v1.BatchWriteRequest.MutationGroup buildPartial() {
        com.google.spanner.v1.BatchWriteRequest.MutationGroup result =
            new com.google.spanner.v1.BatchWriteRequest.MutationGroup(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.spanner.v1.BatchWriteRequest.MutationGroup result) {
        if (mutationsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            mutations_ = java.util.Collections.unmodifiableList(mutations_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.mutations_ = mutations_;
        } else {
          result.mutations_ = mutationsBuilder_.build();
        }
      }

      private void buildPartial0(com.google.spanner.v1.BatchWriteRequest.MutationGroup result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.spanner.v1.BatchWriteRequest.MutationGroup) {
          return mergeFrom((com.google.spanner.v1.BatchWriteRequest.MutationGroup) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.spanner.v1.BatchWriteRequest.MutationGroup other) {
        if (other == com.google.spanner.v1.BatchWriteRequest.MutationGroup.getDefaultInstance())
          return this;
        if (mutationsBuilder_ == null) {
          if (!other.mutations_.isEmpty()) {
            if (mutations_.isEmpty()) {
              mutations_ = other.mutations_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureMutationsIsMutable();
              mutations_.addAll(other.mutations_);
            }
            onChanged();
          }
        } else {
          if (!other.mutations_.isEmpty()) {
            if (mutationsBuilder_.isEmpty()) {
              mutationsBuilder_.dispose();
              mutationsBuilder_ = null;
              mutations_ = other.mutations_;
              bitField0_ = (bitField0_ & ~0x00000001);
              mutationsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getMutationsFieldBuilder()
                      : null;
            } else {
              mutationsBuilder_.addAllMessages(other.mutations_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.spanner.v1.Mutation m =
                      input.readMessage(com.google.spanner.v1.Mutation.parser(), extensionRegistry);
                  if (mutationsBuilder_ == null) {
                    ensureMutationsIsMutable();
                    mutations_.add(m);
                  } else {
                    mutationsBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.spanner.v1.Mutation> mutations_ =
          java.util.Collections.emptyList();

      private void ensureMutationsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          mutations_ = new java.util.ArrayList<com.google.spanner.v1.Mutation>(mutations_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.spanner.v1.Mutation,
              com.google.spanner.v1.Mutation.Builder,
              com.google.spanner.v1.MutationOrBuilder>
          mutationsBuilder_;

      /**
       *
       *
       * <pre>
       * Required. The mutations in this group.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.Mutation mutations = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<com.google.spanner.v1.Mutation> getMutationsList() {
        if (mutationsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(mutations_);
        } else {
          return mutationsBuilder_.getMessageList();
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The mutations in this group.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.Mutation mutations = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public int getMutationsCount() {
        if (mutationsBuilder_ == null) {
          return mutations_.size();
        } else {
          return mutationsBuilder_.getCount();
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The mutations in this group.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.Mutation mutations = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.spanner.v1.Mutation getMutations(int index) {
        if (mutationsBuilder_ == null) {
          return mutations_.get(index);
        } else {
          return mutationsBuilder_.getMessage(index);
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The mutations in this group.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.Mutation mutations = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setMutations(int index, com.google.spanner.v1.Mutation value) {
        if (mutationsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureMutationsIsMutable();
          mutations_.set(index, value);
          onChanged();
        } else {
          mutationsBuilder_.setMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The mutations in this group.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.Mutation mutations = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setMutations(
          int index, com.google.spanner.v1.Mutation.Builder builderForValue) {
        if (mutationsBuilder_ == null) {
          ensureMutationsIsMutable();
          mutations_.set(index, builderForValue.build());
          onChanged();
        } else {
          mutationsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The mutations in this group.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.Mutation mutations = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addMutations(com.google.spanner.v1.Mutation value) {
        if (mutationsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureMutationsIsMutable();
          mutations_.add(value);
          onChanged();
        } else {
          mutationsBuilder_.addMessage(value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The mutations in this group.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.Mutation mutations = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addMutations(int index, com.google.spanner.v1.Mutation value) {
        if (mutationsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureMutationsIsMutable();
          mutations_.add(index, value);
          onChanged();
        } else {
          mutationsBuilder_.addMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The mutations in this group.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.Mutation mutations = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addMutations(com.google.spanner.v1.Mutation.Builder builderForValue) {
        if (mutationsBuilder_ == null) {
          ensureMutationsIsMutable();
          mutations_.add(builderForValue.build());
          onChanged();
        } else {
          mutationsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The mutations in this group.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.Mutation mutations = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addMutations(
          int index, com.google.spanner.v1.Mutation.Builder builderForValue) {
        if (mutationsBuilder_ == null) {
          ensureMutationsIsMutable();
          mutations_.add(index, builderForValue.build());
          onChanged();
        } else {
          mutationsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The mutations in this group.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.Mutation mutations = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addAllMutations(
          java.lang.Iterable<? extends com.google.spanner.v1.Mutation> values) {
        if (mutationsBuilder_ == null) {
          ensureMutationsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, mutations_);
          onChanged();
        } else {
          mutationsBuilder_.addAllMessages(values);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The mutations in this group.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.Mutation mutations = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearMutations() {
        if (mutationsBuilder_ == null) {
          mutations_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          mutationsBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The mutations in this group.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.Mutation mutations = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder removeMutations(int index) {
        if (mutationsBuilder_ == null) {
          ensureMutationsIsMutable();
          mutations_.remove(index);
          onChanged();
        } else {
          mutationsBuilder_.remove(index);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The mutations in this group.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.Mutation mutations = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.spanner.v1.Mutation.Builder getMutationsBuilder(int index) {
        return getMutationsFieldBuilder().getBuilder(index);
      }

      /**
       *
       *
       * <pre>
       * Required. The mutations in this group.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.Mutation mutations = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.spanner.v1.MutationOrBuilder getMutationsOrBuilder(int index) {
        if (mutationsBuilder_ == null) {
          return mutations_.get(index);
        } else {
          return mutationsBuilder_.getMessageOrBuilder(index);
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The mutations in this group.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.Mutation mutations = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<? extends com.google.spanner.v1.MutationOrBuilder>
          getMutationsOrBuilderList() {
        if (mutationsBuilder_ != null) {
          return mutationsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(mutations_);
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The mutations in this group.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.Mutation mutations = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.spanner.v1.Mutation.Builder addMutationsBuilder() {
        return getMutationsFieldBuilder()
            .addBuilder(com.google.spanner.v1.Mutation.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * Required. The mutations in this group.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.Mutation mutations = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.spanner.v1.Mutation.Builder addMutationsBuilder(int index) {
        return getMutationsFieldBuilder()
            .addBuilder(index, com.google.spanner.v1.Mutation.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * Required. The mutations in this group.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.Mutation mutations = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<com.google.spanner.v1.Mutation.Builder> getMutationsBuilderList() {
        return getMutationsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.spanner.v1.Mutation,
              com.google.spanner.v1.Mutation.Builder,
              com.google.spanner.v1.MutationOrBuilder>
          getMutationsFieldBuilder() {
        if (mutationsBuilder_ == null) {
          mutationsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.spanner.v1.Mutation,
                  com.google.spanner.v1.Mutation.Builder,
                  com.google.spanner.v1.MutationOrBuilder>(
                  mutations_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
          mutations_ = null;
        }
        return mutationsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.spanner.v1.BatchWriteRequest.MutationGroup)
    }

    // @@protoc_insertion_point(class_scope:google.spanner.v1.BatchWriteRequest.MutationGroup)
    private static final com.google.spanner.v1.BatchWriteRequest.MutationGroup DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.spanner.v1.BatchWriteRequest.MutationGroup();
    }

    public static com.google.spanner.v1.BatchWriteRequest.MutationGroup getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<MutationGroup> PARSER =
        new com.google.protobuf.AbstractParser<MutationGroup>() {
          @java.lang.Override
          public MutationGroup parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<MutationGroup> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<MutationGroup> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.spanner.v1.BatchWriteRequest.MutationGroup getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int SESSION_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object session_ = "";

  /**
   *
   *
   * <pre>
   * Required. The session in which the batch request is to be run.
   * </pre>
   *
   * <code>
   * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The session.
   */
  @java.lang.Override
  public java.lang.String getSession() {
    java.lang.Object ref = session_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      session_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The session in which the batch request is to be run.
   * </pre>
   *
   * <code>
   * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for session.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSessionBytes() {
    java.lang.Object ref = session_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      session_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REQUEST_OPTIONS_FIELD_NUMBER = 3;
  private com.google.spanner.v1.RequestOptions requestOptions_;

  /**
   *
   *
   * <pre>
   * Common options for this request.
   * </pre>
   *
   * <code>.google.spanner.v1.RequestOptions request_options = 3;</code>
   *
   * @return Whether the requestOptions field is set.
   */
  @java.lang.Override
  public boolean hasRequestOptions() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Common options for this request.
   * </pre>
   *
   * <code>.google.spanner.v1.RequestOptions request_options = 3;</code>
   *
   * @return The requestOptions.
   */
  @java.lang.Override
  public com.google.spanner.v1.RequestOptions getRequestOptions() {
    return requestOptions_ == null
        ? com.google.spanner.v1.RequestOptions.getDefaultInstance()
        : requestOptions_;
  }

  /**
   *
   *
   * <pre>
   * Common options for this request.
   * </pre>
   *
   * <code>.google.spanner.v1.RequestOptions request_options = 3;</code>
   */
  @java.lang.Override
  public com.google.spanner.v1.RequestOptionsOrBuilder getRequestOptionsOrBuilder() {
    return requestOptions_ == null
        ? com.google.spanner.v1.RequestOptions.getDefaultInstance()
        : requestOptions_;
  }

  public static final int MUTATION_GROUPS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.spanner.v1.BatchWriteRequest.MutationGroup> mutationGroups_;

  /**
   *
   *
   * <pre>
   * Required. The groups of mutations to be applied.
   * </pre>
   *
   * <code>
   * repeated .google.spanner.v1.BatchWriteRequest.MutationGroup mutation_groups = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.spanner.v1.BatchWriteRequest.MutationGroup>
      getMutationGroupsList() {
    return mutationGroups_;
  }

  /**
   *
   *
   * <pre>
   * Required. The groups of mutations to be applied.
   * </pre>
   *
   * <code>
   * repeated .google.spanner.v1.BatchWriteRequest.MutationGroup mutation_groups = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.spanner.v1.BatchWriteRequest.MutationGroupOrBuilder>
      getMutationGroupsOrBuilderList() {
    return mutationGroups_;
  }

  /**
   *
   *
   * <pre>
   * Required. The groups of mutations to be applied.
   * </pre>
   *
   * <code>
   * repeated .google.spanner.v1.BatchWriteRequest.MutationGroup mutation_groups = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getMutationGroupsCount() {
    return mutationGroups_.size();
  }

  /**
   *
   *
   * <pre>
   * Required. The groups of mutations to be applied.
   * </pre>
   *
   * <code>
   * repeated .google.spanner.v1.BatchWriteRequest.MutationGroup mutation_groups = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.spanner.v1.BatchWriteRequest.MutationGroup getMutationGroups(int index) {
    return mutationGroups_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Required. The groups of mutations to be applied.
   * </pre>
   *
   * <code>
   * repeated .google.spanner.v1.BatchWriteRequest.MutationGroup mutation_groups = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.spanner.v1.BatchWriteRequest.MutationGroupOrBuilder getMutationGroupsOrBuilder(
      int index) {
    return mutationGroups_.get(index);
  }

  public static final int EXCLUDE_TXN_FROM_CHANGE_STREAMS_FIELD_NUMBER = 5;
  private boolean excludeTxnFromChangeStreams_ = false;

  /**
   *
   *
   * <pre>
   * Optional. When `exclude_txn_from_change_streams` is set to `true`:
   *  * Mutations from all transactions in this batch write operation will not
   *  be recorded in change streams with DDL option `allow_txn_exclusion=true`
   *  that are tracking columns modified by these transactions.
   *  * Mutations from all transactions in this batch write operation will be
   *  recorded in change streams with DDL option `allow_txn_exclusion=false or
   *  not set` that are tracking columns modified by these transactions.
   *
   * When `exclude_txn_from_change_streams` is set to `false` or not set,
   * mutations from all transactions in this batch write operation will be
   * recorded in all change streams that are tracking columns modified by these
   * transactions.
   * </pre>
   *
   * <code>bool exclude_txn_from_change_streams = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The excludeTxnFromChangeStreams.
   */
  @java.lang.Override
  public boolean getExcludeTxnFromChangeStreams() {
    return excludeTxnFromChangeStreams_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(session_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, session_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getRequestOptions());
    }
    for (int i = 0; i < mutationGroups_.size(); i++) {
      output.writeMessage(4, mutationGroups_.get(i));
    }
    if (excludeTxnFromChangeStreams_ != false) {
      output.writeBool(5, excludeTxnFromChangeStreams_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(session_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, session_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getRequestOptions());
    }
    for (int i = 0; i < mutationGroups_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, mutationGroups_.get(i));
    }
    if (excludeTxnFromChangeStreams_ != false) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(5, excludeTxnFromChangeStreams_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.v1.BatchWriteRequest)) {
      return super.equals(obj);
    }
    com.google.spanner.v1.BatchWriteRequest other = (com.google.spanner.v1.BatchWriteRequest) obj;

    if (!getSession().equals(other.getSession())) return false;
    if (hasRequestOptions() != other.hasRequestOptions()) return false;
    if (hasRequestOptions()) {
      if (!getRequestOptions().equals(other.getRequestOptions())) return false;
    }
    if (!getMutationGroupsList().equals(other.getMutationGroupsList())) return false;
    if (getExcludeTxnFromChangeStreams() != other.getExcludeTxnFromChangeStreams()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SESSION_FIELD_NUMBER;
    hash = (53 * hash) + getSession().hashCode();
    if (hasRequestOptions()) {
      hash = (37 * hash) + REQUEST_OPTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getRequestOptions().hashCode();
    }
    if (getMutationGroupsCount() > 0) {
      hash = (37 * hash) + MUTATION_GROUPS_FIELD_NUMBER;
      hash = (53 * hash) + getMutationGroupsList().hashCode();
    }
    hash = (37 * hash) + EXCLUDE_TXN_FROM_CHANGE_STREAMS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getExcludeTxnFromChangeStreams());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.v1.BatchWriteRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.v1.BatchWriteRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.v1.BatchWriteRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.v1.BatchWriteRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.v1.BatchWriteRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.v1.BatchWriteRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.v1.BatchWriteRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.v1.BatchWriteRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.v1.BatchWriteRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.v1.BatchWriteRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.v1.BatchWriteRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.v1.BatchWriteRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.spanner.v1.BatchWriteRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * The request for [BatchWrite][google.spanner.v1.Spanner.BatchWrite].
   * </pre>
   *
   * Protobuf type {@code google.spanner.v1.BatchWriteRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.v1.BatchWriteRequest)
      com.google.spanner.v1.BatchWriteRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.v1.SpannerProto
          .internal_static_google_spanner_v1_BatchWriteRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.v1.SpannerProto
          .internal_static_google_spanner_v1_BatchWriteRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.v1.BatchWriteRequest.class,
              com.google.spanner.v1.BatchWriteRequest.Builder.class);
    }

    // Construct using com.google.spanner.v1.BatchWriteRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getRequestOptionsFieldBuilder();
        getMutationGroupsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      session_ = "";
      requestOptions_ = null;
      if (requestOptionsBuilder_ != null) {
        requestOptionsBuilder_.dispose();
        requestOptionsBuilder_ = null;
      }
      if (mutationGroupsBuilder_ == null) {
        mutationGroups_ = java.util.Collections.emptyList();
      } else {
        mutationGroups_ = null;
        mutationGroupsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      excludeTxnFromChangeStreams_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.v1.SpannerProto
          .internal_static_google_spanner_v1_BatchWriteRequest_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.v1.BatchWriteRequest getDefaultInstanceForType() {
      return com.google.spanner.v1.BatchWriteRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.v1.BatchWriteRequest build() {
      com.google.spanner.v1.BatchWriteRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.v1.BatchWriteRequest buildPartial() {
      com.google.spanner.v1.BatchWriteRequest result =
          new com.google.spanner.v1.BatchWriteRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.spanner.v1.BatchWriteRequest result) {
      if (mutationGroupsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          mutationGroups_ = java.util.Collections.unmodifiableList(mutationGroups_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.mutationGroups_ = mutationGroups_;
      } else {
        result.mutationGroups_ = mutationGroupsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.spanner.v1.BatchWriteRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.session_ = session_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.requestOptions_ =
            requestOptionsBuilder_ == null ? requestOptions_ : requestOptionsBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.excludeTxnFromChangeStreams_ = excludeTxnFromChangeStreams_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.v1.BatchWriteRequest) {
        return mergeFrom((com.google.spanner.v1.BatchWriteRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.v1.BatchWriteRequest other) {
      if (other == com.google.spanner.v1.BatchWriteRequest.getDefaultInstance()) return this;
      if (!other.getSession().isEmpty()) {
        session_ = other.session_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasRequestOptions()) {
        mergeRequestOptions(other.getRequestOptions());
      }
      if (mutationGroupsBuilder_ == null) {
        if (!other.mutationGroups_.isEmpty()) {
          if (mutationGroups_.isEmpty()) {
            mutationGroups_ = other.mutationGroups_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureMutationGroupsIsMutable();
            mutationGroups_.addAll(other.mutationGroups_);
          }
          onChanged();
        }
      } else {
        if (!other.mutationGroups_.isEmpty()) {
          if (mutationGroupsBuilder_.isEmpty()) {
            mutationGroupsBuilder_.dispose();
            mutationGroupsBuilder_ = null;
            mutationGroups_ = other.mutationGroups_;
            bitField0_ = (bitField0_ & ~0x00000004);
            mutationGroupsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getMutationGroupsFieldBuilder()
                    : null;
          } else {
            mutationGroupsBuilder_.addAllMessages(other.mutationGroups_);
          }
        }
      }
      if (other.getExcludeTxnFromChangeStreams() != false) {
        setExcludeTxnFromChangeStreams(other.getExcludeTxnFromChangeStreams());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                session_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 26:
              {
                input.readMessage(getRequestOptionsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 26
            case 34:
              {
                com.google.spanner.v1.BatchWriteRequest.MutationGroup m =
                    input.readMessage(
                        com.google.spanner.v1.BatchWriteRequest.MutationGroup.parser(),
                        extensionRegistry);
                if (mutationGroupsBuilder_ == null) {
                  ensureMutationGroupsIsMutable();
                  mutationGroups_.add(m);
                } else {
                  mutationGroupsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 40:
              {
                excludeTxnFromChangeStreams_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 40
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object session_ = "";

    /**
     *
     *
     * <pre>
     * Required. The session in which the batch request is to be run.
     * </pre>
     *
     * <code>
     * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The session.
     */
    public java.lang.String getSession() {
      java.lang.Object ref = session_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        session_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The session in which the batch request is to be run.
     * </pre>
     *
     * <code>
     * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for session.
     */
    public com.google.protobuf.ByteString getSessionBytes() {
      java.lang.Object ref = session_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        session_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The session in which the batch request is to be run.
     * </pre>
     *
     * <code>
     * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The session to set.
     * @return This builder for chaining.
     */
    public Builder setSession(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      session_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The session in which the batch request is to be run.
     * </pre>
     *
     * <code>
     * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSession() {
      session_ = getDefaultInstance().getSession();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The session in which the batch request is to be run.
     * </pre>
     *
     * <code>
     * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for session to set.
     * @return This builder for chaining.
     */
    public Builder setSessionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      session_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.spanner.v1.RequestOptions requestOptions_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.RequestOptions,
            com.google.spanner.v1.RequestOptions.Builder,
            com.google.spanner.v1.RequestOptionsOrBuilder>
        requestOptionsBuilder_;

    /**
     *
     *
     * <pre>
     * Common options for this request.
     * </pre>
     *
     * <code>.google.spanner.v1.RequestOptions request_options = 3;</code>
     *
     * @return Whether the requestOptions field is set.
     */
    public boolean hasRequestOptions() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Common options for this request.
     * </pre>
     *
     * <code>.google.spanner.v1.RequestOptions request_options = 3;</code>
     *
     * @return The requestOptions.
     */
    public com.google.spanner.v1.RequestOptions getRequestOptions() {
      if (requestOptionsBuilder_ == null) {
        return requestOptions_ == null
            ? com.google.spanner.v1.RequestOptions.getDefaultInstance()
            : requestOptions_;
      } else {
        return requestOptionsBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Common options for this request.
     * </pre>
     *
     * <code>.google.spanner.v1.RequestOptions request_options = 3;</code>
     */
    public Builder setRequestOptions(com.google.spanner.v1.RequestOptions value) {
      if (requestOptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        requestOptions_ = value;
      } else {
        requestOptionsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Common options for this request.
     * </pre>
     *
     * <code>.google.spanner.v1.RequestOptions request_options = 3;</code>
     */
    public Builder setRequestOptions(com.google.spanner.v1.RequestOptions.Builder builderForValue) {
      if (requestOptionsBuilder_ == null) {
        requestOptions_ = builderForValue.build();
      } else {
        requestOptionsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Common options for this request.
     * </pre>
     *
     * <code>.google.spanner.v1.RequestOptions request_options = 3;</code>
     */
    public Builder mergeRequestOptions(com.google.spanner.v1.RequestOptions value) {
      if (requestOptionsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && requestOptions_ != null
            && requestOptions_ != com.google.spanner.v1.RequestOptions.getDefaultInstance()) {
          getRequestOptionsBuilder().mergeFrom(value);
        } else {
          requestOptions_ = value;
        }
      } else {
        requestOptionsBuilder_.mergeFrom(value);
      }
      if (requestOptions_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Common options for this request.
     * </pre>
     *
     * <code>.google.spanner.v1.RequestOptions request_options = 3;</code>
     */
    public Builder clearRequestOptions() {
      bitField0_ = (bitField0_ & ~0x00000002);
      requestOptions_ = null;
      if (requestOptionsBuilder_ != null) {
        requestOptionsBuilder_.dispose();
        requestOptionsBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Common options for this request.
     * </pre>
     *
     * <code>.google.spanner.v1.RequestOptions request_options = 3;</code>
     */
    public com.google.spanner.v1.RequestOptions.Builder getRequestOptionsBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getRequestOptionsFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Common options for this request.
     * </pre>
     *
     * <code>.google.spanner.v1.RequestOptions request_options = 3;</code>
     */
    public com.google.spanner.v1.RequestOptionsOrBuilder getRequestOptionsOrBuilder() {
      if (requestOptionsBuilder_ != null) {
        return requestOptionsBuilder_.getMessageOrBuilder();
      } else {
        return requestOptions_ == null
            ? com.google.spanner.v1.RequestOptions.getDefaultInstance()
            : requestOptions_;
      }
    }

    /**
     *
     *
     * <pre>
     * Common options for this request.
     * </pre>
     *
     * <code>.google.spanner.v1.RequestOptions request_options = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.RequestOptions,
            com.google.spanner.v1.RequestOptions.Builder,
            com.google.spanner.v1.RequestOptionsOrBuilder>
        getRequestOptionsFieldBuilder() {
      if (requestOptionsBuilder_ == null) {
        requestOptionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.v1.RequestOptions,
                com.google.spanner.v1.RequestOptions.Builder,
                com.google.spanner.v1.RequestOptionsOrBuilder>(
                getRequestOptions(), getParentForChildren(), isClean());
        requestOptions_ = null;
      }
      return requestOptionsBuilder_;
    }

    private java.util.List<com.google.spanner.v1.BatchWriteRequest.MutationGroup> mutationGroups_ =
        java.util.Collections.emptyList();

    private void ensureMutationGroupsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        mutationGroups_ =
            new java.util.ArrayList<com.google.spanner.v1.BatchWriteRequest.MutationGroup>(
                mutationGroups_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.spanner.v1.BatchWriteRequest.MutationGroup,
            com.google.spanner.v1.BatchWriteRequest.MutationGroup.Builder,
            com.google.spanner.v1.BatchWriteRequest.MutationGroupOrBuilder>
        mutationGroupsBuilder_;

    /**
     *
     *
     * <pre>
     * Required. The groups of mutations to be applied.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.BatchWriteRequest.MutationGroup mutation_groups = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.spanner.v1.BatchWriteRequest.MutationGroup>
        getMutationGroupsList() {
      if (mutationGroupsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(mutationGroups_);
      } else {
        return mutationGroupsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The groups of mutations to be applied.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.BatchWriteRequest.MutationGroup mutation_groups = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getMutationGroupsCount() {
      if (mutationGroupsBuilder_ == null) {
        return mutationGroups_.size();
      } else {
        return mutationGroupsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The groups of mutations to be applied.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.BatchWriteRequest.MutationGroup mutation_groups = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.spanner.v1.BatchWriteRequest.MutationGroup getMutationGroups(int index) {
      if (mutationGroupsBuilder_ == null) {
        return mutationGroups_.get(index);
      } else {
        return mutationGroupsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The groups of mutations to be applied.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.BatchWriteRequest.MutationGroup mutation_groups = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setMutationGroups(
        int index, com.google.spanner.v1.BatchWriteRequest.MutationGroup value) {
      if (mutationGroupsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMutationGroupsIsMutable();
        mutationGroups_.set(index, value);
        onChanged();
      } else {
        mutationGroupsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The groups of mutations to be applied.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.BatchWriteRequest.MutationGroup mutation_groups = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setMutationGroups(
        int index, com.google.spanner.v1.BatchWriteRequest.MutationGroup.Builder builderForValue) {
      if (mutationGroupsBuilder_ == null) {
        ensureMutationGroupsIsMutable();
        mutationGroups_.set(index, builderForValue.build());
        onChanged();
      } else {
        mutationGroupsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The groups of mutations to be applied.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.BatchWriteRequest.MutationGroup mutation_groups = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addMutationGroups(com.google.spanner.v1.BatchWriteRequest.MutationGroup value) {
      if (mutationGroupsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMutationGroupsIsMutable();
        mutationGroups_.add(value);
        onChanged();
      } else {
        mutationGroupsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The groups of mutations to be applied.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.BatchWriteRequest.MutationGroup mutation_groups = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addMutationGroups(
        int index, com.google.spanner.v1.BatchWriteRequest.MutationGroup value) {
      if (mutationGroupsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMutationGroupsIsMutable();
        mutationGroups_.add(index, value);
        onChanged();
      } else {
        mutationGroupsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The groups of mutations to be applied.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.BatchWriteRequest.MutationGroup mutation_groups = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addMutationGroups(
        com.google.spanner.v1.BatchWriteRequest.MutationGroup.Builder builderForValue) {
      if (mutationGroupsBuilder_ == null) {
        ensureMutationGroupsIsMutable();
        mutationGroups_.add(builderForValue.build());
        onChanged();
      } else {
        mutationGroupsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The groups of mutations to be applied.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.BatchWriteRequest.MutationGroup mutation_groups = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addMutationGroups(
        int index, com.google.spanner.v1.BatchWriteRequest.MutationGroup.Builder builderForValue) {
      if (mutationGroupsBuilder_ == null) {
        ensureMutationGroupsIsMutable();
        mutationGroups_.add(index, builderForValue.build());
        onChanged();
      } else {
        mutationGroupsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The groups of mutations to be applied.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.BatchWriteRequest.MutationGroup mutation_groups = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllMutationGroups(
        java.lang.Iterable<? extends com.google.spanner.v1.BatchWriteRequest.MutationGroup>
            values) {
      if (mutationGroupsBuilder_ == null) {
        ensureMutationGroupsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, mutationGroups_);
        onChanged();
      } else {
        mutationGroupsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The groups of mutations to be applied.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.BatchWriteRequest.MutationGroup mutation_groups = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearMutationGroups() {
      if (mutationGroupsBuilder_ == null) {
        mutationGroups_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        mutationGroupsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The groups of mutations to be applied.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.BatchWriteRequest.MutationGroup mutation_groups = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeMutationGroups(int index) {
      if (mutationGroupsBuilder_ == null) {
        ensureMutationGroupsIsMutable();
        mutationGroups_.remove(index);
        onChanged();
      } else {
        mutationGroupsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The groups of mutations to be applied.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.BatchWriteRequest.MutationGroup mutation_groups = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.spanner.v1.BatchWriteRequest.MutationGroup.Builder getMutationGroupsBuilder(
        int index) {
      return getMutationGroupsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Required. The groups of mutations to be applied.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.BatchWriteRequest.MutationGroup mutation_groups = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.spanner.v1.BatchWriteRequest.MutationGroupOrBuilder
        getMutationGroupsOrBuilder(int index) {
      if (mutationGroupsBuilder_ == null) {
        return mutationGroups_.get(index);
      } else {
        return mutationGroupsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The groups of mutations to be applied.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.BatchWriteRequest.MutationGroup mutation_groups = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<? extends com.google.spanner.v1.BatchWriteRequest.MutationGroupOrBuilder>
        getMutationGroupsOrBuilderList() {
      if (mutationGroupsBuilder_ != null) {
        return mutationGroupsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(mutationGroups_);
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The groups of mutations to be applied.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.BatchWriteRequest.MutationGroup mutation_groups = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.spanner.v1.BatchWriteRequest.MutationGroup.Builder
        addMutationGroupsBuilder() {
      return getMutationGroupsFieldBuilder()
          .addBuilder(com.google.spanner.v1.BatchWriteRequest.MutationGroup.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Required. The groups of mutations to be applied.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.BatchWriteRequest.MutationGroup mutation_groups = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.spanner.v1.BatchWriteRequest.MutationGroup.Builder addMutationGroupsBuilder(
        int index) {
      return getMutationGroupsFieldBuilder()
          .addBuilder(
              index, com.google.spanner.v1.BatchWriteRequest.MutationGroup.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Required. The groups of mutations to be applied.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.BatchWriteRequest.MutationGroup mutation_groups = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.spanner.v1.BatchWriteRequest.MutationGroup.Builder>
        getMutationGroupsBuilderList() {
      return getMutationGroupsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.spanner.v1.BatchWriteRequest.MutationGroup,
            com.google.spanner.v1.BatchWriteRequest.MutationGroup.Builder,
            com.google.spanner.v1.BatchWriteRequest.MutationGroupOrBuilder>
        getMutationGroupsFieldBuilder() {
      if (mutationGroupsBuilder_ == null) {
        mutationGroupsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.spanner.v1.BatchWriteRequest.MutationGroup,
                com.google.spanner.v1.BatchWriteRequest.MutationGroup.Builder,
                com.google.spanner.v1.BatchWriteRequest.MutationGroupOrBuilder>(
                mutationGroups_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        mutationGroups_ = null;
      }
      return mutationGroupsBuilder_;
    }

    private boolean excludeTxnFromChangeStreams_;

    /**
     *
     *
     * <pre>
     * Optional. When `exclude_txn_from_change_streams` is set to `true`:
     *  * Mutations from all transactions in this batch write operation will not
     *  be recorded in change streams with DDL option `allow_txn_exclusion=true`
     *  that are tracking columns modified by these transactions.
     *  * Mutations from all transactions in this batch write operation will be
     *  recorded in change streams with DDL option `allow_txn_exclusion=false or
     *  not set` that are tracking columns modified by these transactions.
     *
     * When `exclude_txn_from_change_streams` is set to `false` or not set,
     * mutations from all transactions in this batch write operation will be
     * recorded in all change streams that are tracking columns modified by these
     * transactions.
     * </pre>
     *
     * <code>bool exclude_txn_from_change_streams = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The excludeTxnFromChangeStreams.
     */
    @java.lang.Override
    public boolean getExcludeTxnFromChangeStreams() {
      return excludeTxnFromChangeStreams_;
    }

    /**
     *
     *
     * <pre>
     * Optional. When `exclude_txn_from_change_streams` is set to `true`:
     *  * Mutations from all transactions in this batch write operation will not
     *  be recorded in change streams with DDL option `allow_txn_exclusion=true`
     *  that are tracking columns modified by these transactions.
     *  * Mutations from all transactions in this batch write operation will be
     *  recorded in change streams with DDL option `allow_txn_exclusion=false or
     *  not set` that are tracking columns modified by these transactions.
     *
     * When `exclude_txn_from_change_streams` is set to `false` or not set,
     * mutations from all transactions in this batch write operation will be
     * recorded in all change streams that are tracking columns modified by these
     * transactions.
     * </pre>
     *
     * <code>bool exclude_txn_from_change_streams = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The excludeTxnFromChangeStreams to set.
     * @return This builder for chaining.
     */
    public Builder setExcludeTxnFromChangeStreams(boolean value) {

      excludeTxnFromChangeStreams_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. When `exclude_txn_from_change_streams` is set to `true`:
     *  * Mutations from all transactions in this batch write operation will not
     *  be recorded in change streams with DDL option `allow_txn_exclusion=true`
     *  that are tracking columns modified by these transactions.
     *  * Mutations from all transactions in this batch write operation will be
     *  recorded in change streams with DDL option `allow_txn_exclusion=false or
     *  not set` that are tracking columns modified by these transactions.
     *
     * When `exclude_txn_from_change_streams` is set to `false` or not set,
     * mutations from all transactions in this batch write operation will be
     * recorded in all change streams that are tracking columns modified by these
     * transactions.
     * </pre>
     *
     * <code>bool exclude_txn_from_change_streams = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExcludeTxnFromChangeStreams() {
      bitField0_ = (bitField0_ & ~0x00000008);
      excludeTxnFromChangeStreams_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.v1.BatchWriteRequest)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.v1.BatchWriteRequest)
  private static final com.google.spanner.v1.BatchWriteRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.v1.BatchWriteRequest();
  }

  public static com.google.spanner.v1.BatchWriteRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BatchWriteRequest> PARSER =
      new com.google.protobuf.AbstractParser<BatchWriteRequest>() {
        @java.lang.Override
        public BatchWriteRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BatchWriteRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BatchWriteRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.v1.BatchWriteRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
