/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/executor/v1/cloud_executor.proto

// Protobuf Java Version: 3.25.4
package com.google.spanner.executor.v1;

/**
 *
 *
 * <pre>
 * ReadResult contains rows read.
 * </pre>
 *
 * Protobuf type {@code google.spanner.executor.v1.ReadResult}
 */
public final class ReadResult extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.executor.v1.ReadResult)
    ReadResultOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ReadResult.newBuilder() to construct.
  private ReadResult(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ReadResult() {
    table_ = "";
    index_ = "";
    row_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ReadResult();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.executor.v1.CloudExecutorProto
        .internal_static_google_spanner_executor_v1_ReadResult_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.executor.v1.CloudExecutorProto
        .internal_static_google_spanner_executor_v1_ReadResult_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.executor.v1.ReadResult.class,
            com.google.spanner.executor.v1.ReadResult.Builder.class);
  }

  private int bitField0_;
  public static final int TABLE_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object table_ = "";
  /**
   *
   *
   * <pre>
   * Table name.
   * </pre>
   *
   * <code>string table = 1;</code>
   *
   * @return The table.
   */
  @java.lang.Override
  public java.lang.String getTable() {
    java.lang.Object ref = table_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      table_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Table name.
   * </pre>
   *
   * <code>string table = 1;</code>
   *
   * @return The bytes for table.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTableBytes() {
    java.lang.Object ref = table_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      table_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INDEX_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object index_ = "";
  /**
   *
   *
   * <pre>
   * Index name, if read from an index.
   * </pre>
   *
   * <code>optional string index = 2;</code>
   *
   * @return Whether the index field is set.
   */
  @java.lang.Override
  public boolean hasIndex() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Index name, if read from an index.
   * </pre>
   *
   * <code>optional string index = 2;</code>
   *
   * @return The index.
   */
  @java.lang.Override
  public java.lang.String getIndex() {
    java.lang.Object ref = index_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      index_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Index name, if read from an index.
   * </pre>
   *
   * <code>optional string index = 2;</code>
   *
   * @return The bytes for index.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIndexBytes() {
    java.lang.Object ref = index_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      index_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REQUEST_INDEX_FIELD_NUMBER = 3;
  private int requestIndex_ = 0;
  /**
   *
   *
   * <pre>
   * Request index (multiread only).
   * </pre>
   *
   * <code>optional int32 request_index = 3;</code>
   *
   * @return Whether the requestIndex field is set.
   */
  @java.lang.Override
  public boolean hasRequestIndex() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Request index (multiread only).
   * </pre>
   *
   * <code>optional int32 request_index = 3;</code>
   *
   * @return The requestIndex.
   */
  @java.lang.Override
  public int getRequestIndex() {
    return requestIndex_;
  }

  public static final int ROW_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.spanner.executor.v1.ValueList> row_;
  /**
   *
   *
   * <pre>
   * Rows read. Each row is a struct with multiple fields, one for each column
   * in read result. All rows have the same type.
   * </pre>
   *
   * <code>repeated .google.spanner.executor.v1.ValueList row = 4;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.spanner.executor.v1.ValueList> getRowList() {
    return row_;
  }
  /**
   *
   *
   * <pre>
   * Rows read. Each row is a struct with multiple fields, one for each column
   * in read result. All rows have the same type.
   * </pre>
   *
   * <code>repeated .google.spanner.executor.v1.ValueList row = 4;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.spanner.executor.v1.ValueListOrBuilder>
      getRowOrBuilderList() {
    return row_;
  }
  /**
   *
   *
   * <pre>
   * Rows read. Each row is a struct with multiple fields, one for each column
   * in read result. All rows have the same type.
   * </pre>
   *
   * <code>repeated .google.spanner.executor.v1.ValueList row = 4;</code>
   */
  @java.lang.Override
  public int getRowCount() {
    return row_.size();
  }
  /**
   *
   *
   * <pre>
   * Rows read. Each row is a struct with multiple fields, one for each column
   * in read result. All rows have the same type.
   * </pre>
   *
   * <code>repeated .google.spanner.executor.v1.ValueList row = 4;</code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.ValueList getRow(int index) {
    return row_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Rows read. Each row is a struct with multiple fields, one for each column
   * in read result. All rows have the same type.
   * </pre>
   *
   * <code>repeated .google.spanner.executor.v1.ValueList row = 4;</code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.ValueListOrBuilder getRowOrBuilder(int index) {
    return row_.get(index);
  }

  public static final int ROW_TYPE_FIELD_NUMBER = 5;
  private com.google.spanner.v1.StructType rowType_;
  /**
   *
   *
   * <pre>
   * The type of rows read. It must be set if at least one row was read.
   * </pre>
   *
   * <code>optional .google.spanner.v1.StructType row_type = 5;</code>
   *
   * @return Whether the rowType field is set.
   */
  @java.lang.Override
  public boolean hasRowType() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * The type of rows read. It must be set if at least one row was read.
   * </pre>
   *
   * <code>optional .google.spanner.v1.StructType row_type = 5;</code>
   *
   * @return The rowType.
   */
  @java.lang.Override
  public com.google.spanner.v1.StructType getRowType() {
    return rowType_ == null ? com.google.spanner.v1.StructType.getDefaultInstance() : rowType_;
  }
  /**
   *
   *
   * <pre>
   * The type of rows read. It must be set if at least one row was read.
   * </pre>
   *
   * <code>optional .google.spanner.v1.StructType row_type = 5;</code>
   */
  @java.lang.Override
  public com.google.spanner.v1.StructTypeOrBuilder getRowTypeOrBuilder() {
    return rowType_ == null ? com.google.spanner.v1.StructType.getDefaultInstance() : rowType_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(table_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, table_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, index_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeInt32(3, requestIndex_);
    }
    for (int i = 0; i < row_.size(); i++) {
      output.writeMessage(4, row_.get(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(5, getRowType());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(table_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, table_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, index_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, requestIndex_);
    }
    for (int i = 0; i < row_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, row_.get(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getRowType());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.executor.v1.ReadResult)) {
      return super.equals(obj);
    }
    com.google.spanner.executor.v1.ReadResult other =
        (com.google.spanner.executor.v1.ReadResult) obj;

    if (!getTable().equals(other.getTable())) return false;
    if (hasIndex() != other.hasIndex()) return false;
    if (hasIndex()) {
      if (!getIndex().equals(other.getIndex())) return false;
    }
    if (hasRequestIndex() != other.hasRequestIndex()) return false;
    if (hasRequestIndex()) {
      if (getRequestIndex() != other.getRequestIndex()) return false;
    }
    if (!getRowList().equals(other.getRowList())) return false;
    if (hasRowType() != other.hasRowType()) return false;
    if (hasRowType()) {
      if (!getRowType().equals(other.getRowType())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TABLE_FIELD_NUMBER;
    hash = (53 * hash) + getTable().hashCode();
    if (hasIndex()) {
      hash = (37 * hash) + INDEX_FIELD_NUMBER;
      hash = (53 * hash) + getIndex().hashCode();
    }
    if (hasRequestIndex()) {
      hash = (37 * hash) + REQUEST_INDEX_FIELD_NUMBER;
      hash = (53 * hash) + getRequestIndex();
    }
    if (getRowCount() > 0) {
      hash = (37 * hash) + ROW_FIELD_NUMBER;
      hash = (53 * hash) + getRowList().hashCode();
    }
    if (hasRowType()) {
      hash = (37 * hash) + ROW_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getRowType().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.executor.v1.ReadResult parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.ReadResult parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.ReadResult parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.ReadResult parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.ReadResult parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.ReadResult parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.ReadResult parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.ReadResult parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.ReadResult parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.ReadResult parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.ReadResult parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.ReadResult parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.spanner.executor.v1.ReadResult prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * ReadResult contains rows read.
   * </pre>
   *
   * Protobuf type {@code google.spanner.executor.v1.ReadResult}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.executor.v1.ReadResult)
      com.google.spanner.executor.v1.ReadResultOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_ReadResult_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_ReadResult_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.executor.v1.ReadResult.class,
              com.google.spanner.executor.v1.ReadResult.Builder.class);
    }

    // Construct using com.google.spanner.executor.v1.ReadResult.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getRowFieldBuilder();
        getRowTypeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      table_ = "";
      index_ = "";
      requestIndex_ = 0;
      if (rowBuilder_ == null) {
        row_ = java.util.Collections.emptyList();
      } else {
        row_ = null;
        rowBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      rowType_ = null;
      if (rowTypeBuilder_ != null) {
        rowTypeBuilder_.dispose();
        rowTypeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_ReadResult_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.ReadResult getDefaultInstanceForType() {
      return com.google.spanner.executor.v1.ReadResult.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.ReadResult build() {
      com.google.spanner.executor.v1.ReadResult result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.ReadResult buildPartial() {
      com.google.spanner.executor.v1.ReadResult result =
          new com.google.spanner.executor.v1.ReadResult(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.spanner.executor.v1.ReadResult result) {
      if (rowBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          row_ = java.util.Collections.unmodifiableList(row_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.row_ = row_;
      } else {
        result.row_ = rowBuilder_.build();
      }
    }

    private void buildPartial0(com.google.spanner.executor.v1.ReadResult result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.table_ = table_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.index_ = index_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.requestIndex_ = requestIndex_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.rowType_ = rowTypeBuilder_ == null ? rowType_ : rowTypeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.executor.v1.ReadResult) {
        return mergeFrom((com.google.spanner.executor.v1.ReadResult) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.executor.v1.ReadResult other) {
      if (other == com.google.spanner.executor.v1.ReadResult.getDefaultInstance()) return this;
      if (!other.getTable().isEmpty()) {
        table_ = other.table_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasIndex()) {
        index_ = other.index_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasRequestIndex()) {
        setRequestIndex(other.getRequestIndex());
      }
      if (rowBuilder_ == null) {
        if (!other.row_.isEmpty()) {
          if (row_.isEmpty()) {
            row_ = other.row_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureRowIsMutable();
            row_.addAll(other.row_);
          }
          onChanged();
        }
      } else {
        if (!other.row_.isEmpty()) {
          if (rowBuilder_.isEmpty()) {
            rowBuilder_.dispose();
            rowBuilder_ = null;
            row_ = other.row_;
            bitField0_ = (bitField0_ & ~0x00000008);
            rowBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getRowFieldBuilder()
                    : null;
          } else {
            rowBuilder_.addAllMessages(other.row_);
          }
        }
      }
      if (other.hasRowType()) {
        mergeRowType(other.getRowType());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                table_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                index_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                requestIndex_ = input.readInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                com.google.spanner.executor.v1.ValueList m =
                    input.readMessage(
                        com.google.spanner.executor.v1.ValueList.parser(), extensionRegistry);
                if (rowBuilder_ == null) {
                  ensureRowIsMutable();
                  row_.add(m);
                } else {
                  rowBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getRowTypeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object table_ = "";
    /**
     *
     *
     * <pre>
     * Table name.
     * </pre>
     *
     * <code>string table = 1;</code>
     *
     * @return The table.
     */
    public java.lang.String getTable() {
      java.lang.Object ref = table_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        table_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Table name.
     * </pre>
     *
     * <code>string table = 1;</code>
     *
     * @return The bytes for table.
     */
    public com.google.protobuf.ByteString getTableBytes() {
      java.lang.Object ref = table_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        table_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Table name.
     * </pre>
     *
     * <code>string table = 1;</code>
     *
     * @param value The table to set.
     * @return This builder for chaining.
     */
    public Builder setTable(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      table_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Table name.
     * </pre>
     *
     * <code>string table = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTable() {
      table_ = getDefaultInstance().getTable();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Table name.
     * </pre>
     *
     * <code>string table = 1;</code>
     *
     * @param value The bytes for table to set.
     * @return This builder for chaining.
     */
    public Builder setTableBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      table_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object index_ = "";
    /**
     *
     *
     * <pre>
     * Index name, if read from an index.
     * </pre>
     *
     * <code>optional string index = 2;</code>
     *
     * @return Whether the index field is set.
     */
    public boolean hasIndex() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Index name, if read from an index.
     * </pre>
     *
     * <code>optional string index = 2;</code>
     *
     * @return The index.
     */
    public java.lang.String getIndex() {
      java.lang.Object ref = index_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        index_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Index name, if read from an index.
     * </pre>
     *
     * <code>optional string index = 2;</code>
     *
     * @return The bytes for index.
     */
    public com.google.protobuf.ByteString getIndexBytes() {
      java.lang.Object ref = index_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        index_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Index name, if read from an index.
     * </pre>
     *
     * <code>optional string index = 2;</code>
     *
     * @param value The index to set.
     * @return This builder for chaining.
     */
    public Builder setIndex(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      index_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Index name, if read from an index.
     * </pre>
     *
     * <code>optional string index = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIndex() {
      index_ = getDefaultInstance().getIndex();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Index name, if read from an index.
     * </pre>
     *
     * <code>optional string index = 2;</code>
     *
     * @param value The bytes for index to set.
     * @return This builder for chaining.
     */
    public Builder setIndexBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      index_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int requestIndex_;
    /**
     *
     *
     * <pre>
     * Request index (multiread only).
     * </pre>
     *
     * <code>optional int32 request_index = 3;</code>
     *
     * @return Whether the requestIndex field is set.
     */
    @java.lang.Override
    public boolean hasRequestIndex() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Request index (multiread only).
     * </pre>
     *
     * <code>optional int32 request_index = 3;</code>
     *
     * @return The requestIndex.
     */
    @java.lang.Override
    public int getRequestIndex() {
      return requestIndex_;
    }
    /**
     *
     *
     * <pre>
     * Request index (multiread only).
     * </pre>
     *
     * <code>optional int32 request_index = 3;</code>
     *
     * @param value The requestIndex to set.
     * @return This builder for chaining.
     */
    public Builder setRequestIndex(int value) {

      requestIndex_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Request index (multiread only).
     * </pre>
     *
     * <code>optional int32 request_index = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequestIndex() {
      bitField0_ = (bitField0_ & ~0x00000004);
      requestIndex_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.spanner.executor.v1.ValueList> row_ =
        java.util.Collections.emptyList();

    private void ensureRowIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        row_ = new java.util.ArrayList<com.google.spanner.executor.v1.ValueList>(row_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.spanner.executor.v1.ValueList,
            com.google.spanner.executor.v1.ValueList.Builder,
            com.google.spanner.executor.v1.ValueListOrBuilder>
        rowBuilder_;

    /**
     *
     *
     * <pre>
     * Rows read. Each row is a struct with multiple fields, one for each column
     * in read result. All rows have the same type.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.ValueList row = 4;</code>
     */
    public java.util.List<com.google.spanner.executor.v1.ValueList> getRowList() {
      if (rowBuilder_ == null) {
        return java.util.Collections.unmodifiableList(row_);
      } else {
        return rowBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Rows read. Each row is a struct with multiple fields, one for each column
     * in read result. All rows have the same type.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.ValueList row = 4;</code>
     */
    public int getRowCount() {
      if (rowBuilder_ == null) {
        return row_.size();
      } else {
        return rowBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Rows read. Each row is a struct with multiple fields, one for each column
     * in read result. All rows have the same type.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.ValueList row = 4;</code>
     */
    public com.google.spanner.executor.v1.ValueList getRow(int index) {
      if (rowBuilder_ == null) {
        return row_.get(index);
      } else {
        return rowBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Rows read. Each row is a struct with multiple fields, one for each column
     * in read result. All rows have the same type.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.ValueList row = 4;</code>
     */
    public Builder setRow(int index, com.google.spanner.executor.v1.ValueList value) {
      if (rowBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRowIsMutable();
        row_.set(index, value);
        onChanged();
      } else {
        rowBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rows read. Each row is a struct with multiple fields, one for each column
     * in read result. All rows have the same type.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.ValueList row = 4;</code>
     */
    public Builder setRow(
        int index, com.google.spanner.executor.v1.ValueList.Builder builderForValue) {
      if (rowBuilder_ == null) {
        ensureRowIsMutable();
        row_.set(index, builderForValue.build());
        onChanged();
      } else {
        rowBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rows read. Each row is a struct with multiple fields, one for each column
     * in read result. All rows have the same type.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.ValueList row = 4;</code>
     */
    public Builder addRow(com.google.spanner.executor.v1.ValueList value) {
      if (rowBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRowIsMutable();
        row_.add(value);
        onChanged();
      } else {
        rowBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rows read. Each row is a struct with multiple fields, one for each column
     * in read result. All rows have the same type.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.ValueList row = 4;</code>
     */
    public Builder addRow(int index, com.google.spanner.executor.v1.ValueList value) {
      if (rowBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRowIsMutable();
        row_.add(index, value);
        onChanged();
      } else {
        rowBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rows read. Each row is a struct with multiple fields, one for each column
     * in read result. All rows have the same type.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.ValueList row = 4;</code>
     */
    public Builder addRow(com.google.spanner.executor.v1.ValueList.Builder builderForValue) {
      if (rowBuilder_ == null) {
        ensureRowIsMutable();
        row_.add(builderForValue.build());
        onChanged();
      } else {
        rowBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rows read. Each row is a struct with multiple fields, one for each column
     * in read result. All rows have the same type.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.ValueList row = 4;</code>
     */
    public Builder addRow(
        int index, com.google.spanner.executor.v1.ValueList.Builder builderForValue) {
      if (rowBuilder_ == null) {
        ensureRowIsMutable();
        row_.add(index, builderForValue.build());
        onChanged();
      } else {
        rowBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rows read. Each row is a struct with multiple fields, one for each column
     * in read result. All rows have the same type.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.ValueList row = 4;</code>
     */
    public Builder addAllRow(
        java.lang.Iterable<? extends com.google.spanner.executor.v1.ValueList> values) {
      if (rowBuilder_ == null) {
        ensureRowIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, row_);
        onChanged();
      } else {
        rowBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rows read. Each row is a struct with multiple fields, one for each column
     * in read result. All rows have the same type.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.ValueList row = 4;</code>
     */
    public Builder clearRow() {
      if (rowBuilder_ == null) {
        row_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        rowBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rows read. Each row is a struct with multiple fields, one for each column
     * in read result. All rows have the same type.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.ValueList row = 4;</code>
     */
    public Builder removeRow(int index) {
      if (rowBuilder_ == null) {
        ensureRowIsMutable();
        row_.remove(index);
        onChanged();
      } else {
        rowBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rows read. Each row is a struct with multiple fields, one for each column
     * in read result. All rows have the same type.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.ValueList row = 4;</code>
     */
    public com.google.spanner.executor.v1.ValueList.Builder getRowBuilder(int index) {
      return getRowFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Rows read. Each row is a struct with multiple fields, one for each column
     * in read result. All rows have the same type.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.ValueList row = 4;</code>
     */
    public com.google.spanner.executor.v1.ValueListOrBuilder getRowOrBuilder(int index) {
      if (rowBuilder_ == null) {
        return row_.get(index);
      } else {
        return rowBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Rows read. Each row is a struct with multiple fields, one for each column
     * in read result. All rows have the same type.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.ValueList row = 4;</code>
     */
    public java.util.List<? extends com.google.spanner.executor.v1.ValueListOrBuilder>
        getRowOrBuilderList() {
      if (rowBuilder_ != null) {
        return rowBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(row_);
      }
    }
    /**
     *
     *
     * <pre>
     * Rows read. Each row is a struct with multiple fields, one for each column
     * in read result. All rows have the same type.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.ValueList row = 4;</code>
     */
    public com.google.spanner.executor.v1.ValueList.Builder addRowBuilder() {
      return getRowFieldBuilder()
          .addBuilder(com.google.spanner.executor.v1.ValueList.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Rows read. Each row is a struct with multiple fields, one for each column
     * in read result. All rows have the same type.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.ValueList row = 4;</code>
     */
    public com.google.spanner.executor.v1.ValueList.Builder addRowBuilder(int index) {
      return getRowFieldBuilder()
          .addBuilder(index, com.google.spanner.executor.v1.ValueList.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Rows read. Each row is a struct with multiple fields, one for each column
     * in read result. All rows have the same type.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.ValueList row = 4;</code>
     */
    public java.util.List<com.google.spanner.executor.v1.ValueList.Builder> getRowBuilderList() {
      return getRowFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.spanner.executor.v1.ValueList,
            com.google.spanner.executor.v1.ValueList.Builder,
            com.google.spanner.executor.v1.ValueListOrBuilder>
        getRowFieldBuilder() {
      if (rowBuilder_ == null) {
        rowBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.spanner.executor.v1.ValueList,
                com.google.spanner.executor.v1.ValueList.Builder,
                com.google.spanner.executor.v1.ValueListOrBuilder>(
                row_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
        row_ = null;
      }
      return rowBuilder_;
    }

    private com.google.spanner.v1.StructType rowType_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.StructType,
            com.google.spanner.v1.StructType.Builder,
            com.google.spanner.v1.StructTypeOrBuilder>
        rowTypeBuilder_;
    /**
     *
     *
     * <pre>
     * The type of rows read. It must be set if at least one row was read.
     * </pre>
     *
     * <code>optional .google.spanner.v1.StructType row_type = 5;</code>
     *
     * @return Whether the rowType field is set.
     */
    public boolean hasRowType() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * The type of rows read. It must be set if at least one row was read.
     * </pre>
     *
     * <code>optional .google.spanner.v1.StructType row_type = 5;</code>
     *
     * @return The rowType.
     */
    public com.google.spanner.v1.StructType getRowType() {
      if (rowTypeBuilder_ == null) {
        return rowType_ == null ? com.google.spanner.v1.StructType.getDefaultInstance() : rowType_;
      } else {
        return rowTypeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The type of rows read. It must be set if at least one row was read.
     * </pre>
     *
     * <code>optional .google.spanner.v1.StructType row_type = 5;</code>
     */
    public Builder setRowType(com.google.spanner.v1.StructType value) {
      if (rowTypeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        rowType_ = value;
      } else {
        rowTypeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of rows read. It must be set if at least one row was read.
     * </pre>
     *
     * <code>optional .google.spanner.v1.StructType row_type = 5;</code>
     */
    public Builder setRowType(com.google.spanner.v1.StructType.Builder builderForValue) {
      if (rowTypeBuilder_ == null) {
        rowType_ = builderForValue.build();
      } else {
        rowTypeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of rows read. It must be set if at least one row was read.
     * </pre>
     *
     * <code>optional .google.spanner.v1.StructType row_type = 5;</code>
     */
    public Builder mergeRowType(com.google.spanner.v1.StructType value) {
      if (rowTypeBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && rowType_ != null
            && rowType_ != com.google.spanner.v1.StructType.getDefaultInstance()) {
          getRowTypeBuilder().mergeFrom(value);
        } else {
          rowType_ = value;
        }
      } else {
        rowTypeBuilder_.mergeFrom(value);
      }
      if (rowType_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of rows read. It must be set if at least one row was read.
     * </pre>
     *
     * <code>optional .google.spanner.v1.StructType row_type = 5;</code>
     */
    public Builder clearRowType() {
      bitField0_ = (bitField0_ & ~0x00000010);
      rowType_ = null;
      if (rowTypeBuilder_ != null) {
        rowTypeBuilder_.dispose();
        rowTypeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of rows read. It must be set if at least one row was read.
     * </pre>
     *
     * <code>optional .google.spanner.v1.StructType row_type = 5;</code>
     */
    public com.google.spanner.v1.StructType.Builder getRowTypeBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getRowTypeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The type of rows read. It must be set if at least one row was read.
     * </pre>
     *
     * <code>optional .google.spanner.v1.StructType row_type = 5;</code>
     */
    public com.google.spanner.v1.StructTypeOrBuilder getRowTypeOrBuilder() {
      if (rowTypeBuilder_ != null) {
        return rowTypeBuilder_.getMessageOrBuilder();
      } else {
        return rowType_ == null ? com.google.spanner.v1.StructType.getDefaultInstance() : rowType_;
      }
    }
    /**
     *
     *
     * <pre>
     * The type of rows read. It must be set if at least one row was read.
     * </pre>
     *
     * <code>optional .google.spanner.v1.StructType row_type = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.StructType,
            com.google.spanner.v1.StructType.Builder,
            com.google.spanner.v1.StructTypeOrBuilder>
        getRowTypeFieldBuilder() {
      if (rowTypeBuilder_ == null) {
        rowTypeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.v1.StructType,
                com.google.spanner.v1.StructType.Builder,
                com.google.spanner.v1.StructTypeOrBuilder>(
                getRowType(), getParentForChildren(), isClean());
        rowType_ = null;
      }
      return rowTypeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.executor.v1.ReadResult)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.executor.v1.ReadResult)
  private static final com.google.spanner.executor.v1.ReadResult DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.executor.v1.ReadResult();
  }

  public static com.google.spanner.executor.v1.ReadResult getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ReadResult> PARSER =
      new com.google.protobuf.AbstractParser<ReadResult>() {
        @java.lang.Override
        public ReadResult parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ReadResult> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ReadResult> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.executor.v1.ReadResult getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
