/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/executor/v1/cloud_executor.proto

// Protobuf Java Version: 3.25.4
package com.google.spanner.executor.v1;

/**
 *
 *
 * <pre>
 * OperationResponse contains results returned by operation related actions.
 * </pre>
 *
 * Protobuf type {@code google.spanner.executor.v1.OperationResponse}
 */
public final class OperationResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.executor.v1.OperationResponse)
    OperationResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use OperationResponse.newBuilder() to construct.
  private OperationResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private OperationResponse() {
    listedOperations_ = java.util.Collections.emptyList();
    nextPageToken_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new OperationResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.executor.v1.CloudExecutorProto
        .internal_static_google_spanner_executor_v1_OperationResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.executor.v1.CloudExecutorProto
        .internal_static_google_spanner_executor_v1_OperationResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.executor.v1.OperationResponse.class,
            com.google.spanner.executor.v1.OperationResponse.Builder.class);
  }

  private int bitField0_;
  public static final int LISTED_OPERATIONS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.longrunning.Operation> listedOperations_;
  /**
   *
   *
   * <pre>
   * List of operations returned by ListOperationsAction.
   * </pre>
   *
   * <code>repeated .google.longrunning.Operation listed_operations = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.longrunning.Operation> getListedOperationsList() {
    return listedOperations_;
  }
  /**
   *
   *
   * <pre>
   * List of operations returned by ListOperationsAction.
   * </pre>
   *
   * <code>repeated .google.longrunning.Operation listed_operations = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.longrunning.OperationOrBuilder>
      getListedOperationsOrBuilderList() {
    return listedOperations_;
  }
  /**
   *
   *
   * <pre>
   * List of operations returned by ListOperationsAction.
   * </pre>
   *
   * <code>repeated .google.longrunning.Operation listed_operations = 1;</code>
   */
  @java.lang.Override
  public int getListedOperationsCount() {
    return listedOperations_.size();
  }
  /**
   *
   *
   * <pre>
   * List of operations returned by ListOperationsAction.
   * </pre>
   *
   * <code>repeated .google.longrunning.Operation listed_operations = 1;</code>
   */
  @java.lang.Override
  public com.google.longrunning.Operation getListedOperations(int index) {
    return listedOperations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of operations returned by ListOperationsAction.
   * </pre>
   *
   * <code>repeated .google.longrunning.Operation listed_operations = 1;</code>
   */
  @java.lang.Override
  public com.google.longrunning.OperationOrBuilder getListedOperationsOrBuilder(int index) {
    return listedOperations_.get(index);
  }

  public static final int NEXT_PAGE_TOKEN_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object nextPageToken_ = "";
  /**
   *
   *
   * <pre>
   * "next_page_token" can be sent in a subsequent list action
   * to fetch more of the matching data.
   * </pre>
   *
   * <code>string next_page_token = 2;</code>
   *
   * @return The nextPageToken.
   */
  @java.lang.Override
  public java.lang.String getNextPageToken() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nextPageToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * "next_page_token" can be sent in a subsequent list action
   * to fetch more of the matching data.
   * </pre>
   *
   * <code>string next_page_token = 2;</code>
   *
   * @return The bytes for nextPageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNextPageTokenBytes() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nextPageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OPERATION_FIELD_NUMBER = 3;
  private com.google.longrunning.Operation operation_;
  /**
   *
   *
   * <pre>
   * Operation returned by GetOperationAction.
   * </pre>
   *
   * <code>.google.longrunning.Operation operation = 3;</code>
   *
   * @return Whether the operation field is set.
   */
  @java.lang.Override
  public boolean hasOperation() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Operation returned by GetOperationAction.
   * </pre>
   *
   * <code>.google.longrunning.Operation operation = 3;</code>
   *
   * @return The operation.
   */
  @java.lang.Override
  public com.google.longrunning.Operation getOperation() {
    return operation_ == null ? com.google.longrunning.Operation.getDefaultInstance() : operation_;
  }
  /**
   *
   *
   * <pre>
   * Operation returned by GetOperationAction.
   * </pre>
   *
   * <code>.google.longrunning.Operation operation = 3;</code>
   */
  @java.lang.Override
  public com.google.longrunning.OperationOrBuilder getOperationOrBuilder() {
    return operation_ == null ? com.google.longrunning.Operation.getDefaultInstance() : operation_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < listedOperations_.size(); i++) {
      output.writeMessage(1, listedOperations_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, nextPageToken_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getOperation());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < listedOperations_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, listedOperations_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, nextPageToken_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getOperation());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.executor.v1.OperationResponse)) {
      return super.equals(obj);
    }
    com.google.spanner.executor.v1.OperationResponse other =
        (com.google.spanner.executor.v1.OperationResponse) obj;

    if (!getListedOperationsList().equals(other.getListedOperationsList())) return false;
    if (!getNextPageToken().equals(other.getNextPageToken())) return false;
    if (hasOperation() != other.hasOperation()) return false;
    if (hasOperation()) {
      if (!getOperation().equals(other.getOperation())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getListedOperationsCount() > 0) {
      hash = (37 * hash) + LISTED_OPERATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getListedOperationsList().hashCode();
    }
    hash = (37 * hash) + NEXT_PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getNextPageToken().hashCode();
    if (hasOperation()) {
      hash = (37 * hash) + OPERATION_FIELD_NUMBER;
      hash = (53 * hash) + getOperation().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.executor.v1.OperationResponse parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.OperationResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.OperationResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.OperationResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.OperationResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.OperationResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.OperationResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.OperationResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.OperationResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.OperationResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.OperationResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.OperationResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.spanner.executor.v1.OperationResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * OperationResponse contains results returned by operation related actions.
   * </pre>
   *
   * Protobuf type {@code google.spanner.executor.v1.OperationResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.executor.v1.OperationResponse)
      com.google.spanner.executor.v1.OperationResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_OperationResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_OperationResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.executor.v1.OperationResponse.class,
              com.google.spanner.executor.v1.OperationResponse.Builder.class);
    }

    // Construct using com.google.spanner.executor.v1.OperationResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getListedOperationsFieldBuilder();
        getOperationFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (listedOperationsBuilder_ == null) {
        listedOperations_ = java.util.Collections.emptyList();
      } else {
        listedOperations_ = null;
        listedOperationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      nextPageToken_ = "";
      operation_ = null;
      if (operationBuilder_ != null) {
        operationBuilder_.dispose();
        operationBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_OperationResponse_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.OperationResponse getDefaultInstanceForType() {
      return com.google.spanner.executor.v1.OperationResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.OperationResponse build() {
      com.google.spanner.executor.v1.OperationResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.OperationResponse buildPartial() {
      com.google.spanner.executor.v1.OperationResponse result =
          new com.google.spanner.executor.v1.OperationResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.spanner.executor.v1.OperationResponse result) {
      if (listedOperationsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          listedOperations_ = java.util.Collections.unmodifiableList(listedOperations_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.listedOperations_ = listedOperations_;
      } else {
        result.listedOperations_ = listedOperationsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.spanner.executor.v1.OperationResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.nextPageToken_ = nextPageToken_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.operation_ = operationBuilder_ == null ? operation_ : operationBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.executor.v1.OperationResponse) {
        return mergeFrom((com.google.spanner.executor.v1.OperationResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.executor.v1.OperationResponse other) {
      if (other == com.google.spanner.executor.v1.OperationResponse.getDefaultInstance())
        return this;
      if (listedOperationsBuilder_ == null) {
        if (!other.listedOperations_.isEmpty()) {
          if (listedOperations_.isEmpty()) {
            listedOperations_ = other.listedOperations_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureListedOperationsIsMutable();
            listedOperations_.addAll(other.listedOperations_);
          }
          onChanged();
        }
      } else {
        if (!other.listedOperations_.isEmpty()) {
          if (listedOperationsBuilder_.isEmpty()) {
            listedOperationsBuilder_.dispose();
            listedOperationsBuilder_ = null;
            listedOperations_ = other.listedOperations_;
            bitField0_ = (bitField0_ & ~0x00000001);
            listedOperationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getListedOperationsFieldBuilder()
                    : null;
          } else {
            listedOperationsBuilder_.addAllMessages(other.listedOperations_);
          }
        }
      }
      if (!other.getNextPageToken().isEmpty()) {
        nextPageToken_ = other.nextPageToken_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasOperation()) {
        mergeOperation(other.getOperation());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.longrunning.Operation m =
                    input.readMessage(com.google.longrunning.Operation.parser(), extensionRegistry);
                if (listedOperationsBuilder_ == null) {
                  ensureListedOperationsIsMutable();
                  listedOperations_.add(m);
                } else {
                  listedOperationsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                nextPageToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getOperationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.longrunning.Operation> listedOperations_ =
        java.util.Collections.emptyList();

    private void ensureListedOperationsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        listedOperations_ =
            new java.util.ArrayList<com.google.longrunning.Operation>(listedOperations_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.longrunning.Operation,
            com.google.longrunning.Operation.Builder,
            com.google.longrunning.OperationOrBuilder>
        listedOperationsBuilder_;

    /**
     *
     *
     * <pre>
     * List of operations returned by ListOperationsAction.
     * </pre>
     *
     * <code>repeated .google.longrunning.Operation listed_operations = 1;</code>
     */
    public java.util.List<com.google.longrunning.Operation> getListedOperationsList() {
      if (listedOperationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(listedOperations_);
      } else {
        return listedOperationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * List of operations returned by ListOperationsAction.
     * </pre>
     *
     * <code>repeated .google.longrunning.Operation listed_operations = 1;</code>
     */
    public int getListedOperationsCount() {
      if (listedOperationsBuilder_ == null) {
        return listedOperations_.size();
      } else {
        return listedOperationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * List of operations returned by ListOperationsAction.
     * </pre>
     *
     * <code>repeated .google.longrunning.Operation listed_operations = 1;</code>
     */
    public com.google.longrunning.Operation getListedOperations(int index) {
      if (listedOperationsBuilder_ == null) {
        return listedOperations_.get(index);
      } else {
        return listedOperationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of operations returned by ListOperationsAction.
     * </pre>
     *
     * <code>repeated .google.longrunning.Operation listed_operations = 1;</code>
     */
    public Builder setListedOperations(int index, com.google.longrunning.Operation value) {
      if (listedOperationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureListedOperationsIsMutable();
        listedOperations_.set(index, value);
        onChanged();
      } else {
        listedOperationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of operations returned by ListOperationsAction.
     * </pre>
     *
     * <code>repeated .google.longrunning.Operation listed_operations = 1;</code>
     */
    public Builder setListedOperations(
        int index, com.google.longrunning.Operation.Builder builderForValue) {
      if (listedOperationsBuilder_ == null) {
        ensureListedOperationsIsMutable();
        listedOperations_.set(index, builderForValue.build());
        onChanged();
      } else {
        listedOperationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of operations returned by ListOperationsAction.
     * </pre>
     *
     * <code>repeated .google.longrunning.Operation listed_operations = 1;</code>
     */
    public Builder addListedOperations(com.google.longrunning.Operation value) {
      if (listedOperationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureListedOperationsIsMutable();
        listedOperations_.add(value);
        onChanged();
      } else {
        listedOperationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of operations returned by ListOperationsAction.
     * </pre>
     *
     * <code>repeated .google.longrunning.Operation listed_operations = 1;</code>
     */
    public Builder addListedOperations(int index, com.google.longrunning.Operation value) {
      if (listedOperationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureListedOperationsIsMutable();
        listedOperations_.add(index, value);
        onChanged();
      } else {
        listedOperationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of operations returned by ListOperationsAction.
     * </pre>
     *
     * <code>repeated .google.longrunning.Operation listed_operations = 1;</code>
     */
    public Builder addListedOperations(com.google.longrunning.Operation.Builder builderForValue) {
      if (listedOperationsBuilder_ == null) {
        ensureListedOperationsIsMutable();
        listedOperations_.add(builderForValue.build());
        onChanged();
      } else {
        listedOperationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of operations returned by ListOperationsAction.
     * </pre>
     *
     * <code>repeated .google.longrunning.Operation listed_operations = 1;</code>
     */
    public Builder addListedOperations(
        int index, com.google.longrunning.Operation.Builder builderForValue) {
      if (listedOperationsBuilder_ == null) {
        ensureListedOperationsIsMutable();
        listedOperations_.add(index, builderForValue.build());
        onChanged();
      } else {
        listedOperationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of operations returned by ListOperationsAction.
     * </pre>
     *
     * <code>repeated .google.longrunning.Operation listed_operations = 1;</code>
     */
    public Builder addAllListedOperations(
        java.lang.Iterable<? extends com.google.longrunning.Operation> values) {
      if (listedOperationsBuilder_ == null) {
        ensureListedOperationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, listedOperations_);
        onChanged();
      } else {
        listedOperationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of operations returned by ListOperationsAction.
     * </pre>
     *
     * <code>repeated .google.longrunning.Operation listed_operations = 1;</code>
     */
    public Builder clearListedOperations() {
      if (listedOperationsBuilder_ == null) {
        listedOperations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        listedOperationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of operations returned by ListOperationsAction.
     * </pre>
     *
     * <code>repeated .google.longrunning.Operation listed_operations = 1;</code>
     */
    public Builder removeListedOperations(int index) {
      if (listedOperationsBuilder_ == null) {
        ensureListedOperationsIsMutable();
        listedOperations_.remove(index);
        onChanged();
      } else {
        listedOperationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of operations returned by ListOperationsAction.
     * </pre>
     *
     * <code>repeated .google.longrunning.Operation listed_operations = 1;</code>
     */
    public com.google.longrunning.Operation.Builder getListedOperationsBuilder(int index) {
      return getListedOperationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * List of operations returned by ListOperationsAction.
     * </pre>
     *
     * <code>repeated .google.longrunning.Operation listed_operations = 1;</code>
     */
    public com.google.longrunning.OperationOrBuilder getListedOperationsOrBuilder(int index) {
      if (listedOperationsBuilder_ == null) {
        return listedOperations_.get(index);
      } else {
        return listedOperationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of operations returned by ListOperationsAction.
     * </pre>
     *
     * <code>repeated .google.longrunning.Operation listed_operations = 1;</code>
     */
    public java.util.List<? extends com.google.longrunning.OperationOrBuilder>
        getListedOperationsOrBuilderList() {
      if (listedOperationsBuilder_ != null) {
        return listedOperationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(listedOperations_);
      }
    }
    /**
     *
     *
     * <pre>
     * List of operations returned by ListOperationsAction.
     * </pre>
     *
     * <code>repeated .google.longrunning.Operation listed_operations = 1;</code>
     */
    public com.google.longrunning.Operation.Builder addListedOperationsBuilder() {
      return getListedOperationsFieldBuilder()
          .addBuilder(com.google.longrunning.Operation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of operations returned by ListOperationsAction.
     * </pre>
     *
     * <code>repeated .google.longrunning.Operation listed_operations = 1;</code>
     */
    public com.google.longrunning.Operation.Builder addListedOperationsBuilder(int index) {
      return getListedOperationsFieldBuilder()
          .addBuilder(index, com.google.longrunning.Operation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of operations returned by ListOperationsAction.
     * </pre>
     *
     * <code>repeated .google.longrunning.Operation listed_operations = 1;</code>
     */
    public java.util.List<com.google.longrunning.Operation.Builder>
        getListedOperationsBuilderList() {
      return getListedOperationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.longrunning.Operation,
            com.google.longrunning.Operation.Builder,
            com.google.longrunning.OperationOrBuilder>
        getListedOperationsFieldBuilder() {
      if (listedOperationsBuilder_ == null) {
        listedOperationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.longrunning.Operation,
                com.google.longrunning.Operation.Builder,
                com.google.longrunning.OperationOrBuilder>(
                listedOperations_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        listedOperations_ = null;
      }
      return listedOperationsBuilder_;
    }

    private java.lang.Object nextPageToken_ = "";
    /**
     *
     *
     * <pre>
     * "next_page_token" can be sent in a subsequent list action
     * to fetch more of the matching data.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The nextPageToken.
     */
    public java.lang.String getNextPageToken() {
      java.lang.Object ref = nextPageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nextPageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * "next_page_token" can be sent in a subsequent list action
     * to fetch more of the matching data.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The bytes for nextPageToken.
     */
    public com.google.protobuf.ByteString getNextPageTokenBytes() {
      java.lang.Object ref = nextPageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nextPageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * "next_page_token" can be sent in a subsequent list action
     * to fetch more of the matching data.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @param value The nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      nextPageToken_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * "next_page_token" can be sent in a subsequent list action
     * to fetch more of the matching data.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNextPageToken() {
      nextPageToken_ = getDefaultInstance().getNextPageToken();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * "next_page_token" can be sent in a subsequent list action
     * to fetch more of the matching data.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @param value The bytes for nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      nextPageToken_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.longrunning.Operation operation_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.longrunning.Operation,
            com.google.longrunning.Operation.Builder,
            com.google.longrunning.OperationOrBuilder>
        operationBuilder_;
    /**
     *
     *
     * <pre>
     * Operation returned by GetOperationAction.
     * </pre>
     *
     * <code>.google.longrunning.Operation operation = 3;</code>
     *
     * @return Whether the operation field is set.
     */
    public boolean hasOperation() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Operation returned by GetOperationAction.
     * </pre>
     *
     * <code>.google.longrunning.Operation operation = 3;</code>
     *
     * @return The operation.
     */
    public com.google.longrunning.Operation getOperation() {
      if (operationBuilder_ == null) {
        return operation_ == null
            ? com.google.longrunning.Operation.getDefaultInstance()
            : operation_;
      } else {
        return operationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Operation returned by GetOperationAction.
     * </pre>
     *
     * <code>.google.longrunning.Operation operation = 3;</code>
     */
    public Builder setOperation(com.google.longrunning.Operation value) {
      if (operationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        operation_ = value;
      } else {
        operationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Operation returned by GetOperationAction.
     * </pre>
     *
     * <code>.google.longrunning.Operation operation = 3;</code>
     */
    public Builder setOperation(com.google.longrunning.Operation.Builder builderForValue) {
      if (operationBuilder_ == null) {
        operation_ = builderForValue.build();
      } else {
        operationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Operation returned by GetOperationAction.
     * </pre>
     *
     * <code>.google.longrunning.Operation operation = 3;</code>
     */
    public Builder mergeOperation(com.google.longrunning.Operation value) {
      if (operationBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && operation_ != null
            && operation_ != com.google.longrunning.Operation.getDefaultInstance()) {
          getOperationBuilder().mergeFrom(value);
        } else {
          operation_ = value;
        }
      } else {
        operationBuilder_.mergeFrom(value);
      }
      if (operation_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Operation returned by GetOperationAction.
     * </pre>
     *
     * <code>.google.longrunning.Operation operation = 3;</code>
     */
    public Builder clearOperation() {
      bitField0_ = (bitField0_ & ~0x00000004);
      operation_ = null;
      if (operationBuilder_ != null) {
        operationBuilder_.dispose();
        operationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Operation returned by GetOperationAction.
     * </pre>
     *
     * <code>.google.longrunning.Operation operation = 3;</code>
     */
    public com.google.longrunning.Operation.Builder getOperationBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getOperationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Operation returned by GetOperationAction.
     * </pre>
     *
     * <code>.google.longrunning.Operation operation = 3;</code>
     */
    public com.google.longrunning.OperationOrBuilder getOperationOrBuilder() {
      if (operationBuilder_ != null) {
        return operationBuilder_.getMessageOrBuilder();
      } else {
        return operation_ == null
            ? com.google.longrunning.Operation.getDefaultInstance()
            : operation_;
      }
    }
    /**
     *
     *
     * <pre>
     * Operation returned by GetOperationAction.
     * </pre>
     *
     * <code>.google.longrunning.Operation operation = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.longrunning.Operation,
            com.google.longrunning.Operation.Builder,
            com.google.longrunning.OperationOrBuilder>
        getOperationFieldBuilder() {
      if (operationBuilder_ == null) {
        operationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.longrunning.Operation,
                com.google.longrunning.Operation.Builder,
                com.google.longrunning.OperationOrBuilder>(
                getOperation(), getParentForChildren(), isClean());
        operation_ = null;
      }
      return operationBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.executor.v1.OperationResponse)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.executor.v1.OperationResponse)
  private static final com.google.spanner.executor.v1.OperationResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.executor.v1.OperationResponse();
  }

  public static com.google.spanner.executor.v1.OperationResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<OperationResponse> PARSER =
      new com.google.protobuf.AbstractParser<OperationResponse>() {
        @java.lang.Override
        public OperationResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<OperationResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<OperationResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.executor.v1.OperationResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
