/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/admin/instance/v1/spanner_instance_admin.proto

// Protobuf Java Version: 3.25.8
package com.google.spanner.admin.instance.v1;

/**
 *
 *
 * <pre>
 * Free instance specific metadata that is kept even after an instance has been
 * upgraded for tracking purposes.
 * </pre>
 *
 * Protobuf type {@code google.spanner.admin.instance.v1.FreeInstanceMetadata}
 */
public final class FreeInstanceMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.admin.instance.v1.FreeInstanceMetadata)
    FreeInstanceMetadataOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use FreeInstanceMetadata.newBuilder() to construct.
  private FreeInstanceMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private FreeInstanceMetadata() {
    expireBehavior_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new FreeInstanceMetadata();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
        .internal_static_google_spanner_admin_instance_v1_FreeInstanceMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
        .internal_static_google_spanner_admin_instance_v1_FreeInstanceMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.admin.instance.v1.FreeInstanceMetadata.class,
            com.google.spanner.admin.instance.v1.FreeInstanceMetadata.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Allows users to change behavior when a free instance expires.
   * </pre>
   *
   * Protobuf enum {@code google.spanner.admin.instance.v1.FreeInstanceMetadata.ExpireBehavior}
   */
  public enum ExpireBehavior implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not specified.
     * </pre>
     *
     * <code>EXPIRE_BEHAVIOR_UNSPECIFIED = 0;</code>
     */
    EXPIRE_BEHAVIOR_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * When the free instance expires, upgrade the instance to a provisioned
     * instance.
     * </pre>
     *
     * <code>FREE_TO_PROVISIONED = 1;</code>
     */
    FREE_TO_PROVISIONED(1),
    /**
     *
     *
     * <pre>
     * When the free instance expires, disable the instance, and delete it
     * after the grace period passes if it has not been upgraded.
     * </pre>
     *
     * <code>REMOVE_AFTER_GRACE_PERIOD = 2;</code>
     */
    REMOVE_AFTER_GRACE_PERIOD(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not specified.
     * </pre>
     *
     * <code>EXPIRE_BEHAVIOR_UNSPECIFIED = 0;</code>
     */
    public static final int EXPIRE_BEHAVIOR_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * When the free instance expires, upgrade the instance to a provisioned
     * instance.
     * </pre>
     *
     * <code>FREE_TO_PROVISIONED = 1;</code>
     */
    public static final int FREE_TO_PROVISIONED_VALUE = 1;

    /**
     *
     *
     * <pre>
     * When the free instance expires, disable the instance, and delete it
     * after the grace period passes if it has not been upgraded.
     * </pre>
     *
     * <code>REMOVE_AFTER_GRACE_PERIOD = 2;</code>
     */
    public static final int REMOVE_AFTER_GRACE_PERIOD_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ExpireBehavior valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ExpireBehavior forNumber(int value) {
      switch (value) {
        case 0:
          return EXPIRE_BEHAVIOR_UNSPECIFIED;
        case 1:
          return FREE_TO_PROVISIONED;
        case 2:
          return REMOVE_AFTER_GRACE_PERIOD;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ExpireBehavior> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ExpireBehavior> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ExpireBehavior>() {
          public ExpireBehavior findValueByNumber(int number) {
            return ExpireBehavior.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.spanner.admin.instance.v1.FreeInstanceMetadata.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final ExpireBehavior[] VALUES = values();

    public static ExpireBehavior valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ExpireBehavior(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.spanner.admin.instance.v1.FreeInstanceMetadata.ExpireBehavior)
  }

  private int bitField0_;
  public static final int EXPIRE_TIME_FIELD_NUMBER = 1;
  private com.google.protobuf.Timestamp expireTime_;

  /**
   *
   *
   * <pre>
   * Output only. Timestamp after which the instance will either be upgraded or
   * scheduled for deletion after a grace period. ExpireBehavior is used to
   * choose between upgrading or scheduling the free instance for deletion. This
   * timestamp is set during the creation of a free instance.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the expireTime field is set.
   */
  @java.lang.Override
  public boolean hasExpireTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Timestamp after which the instance will either be upgraded or
   * scheduled for deletion after a grace period. ExpireBehavior is used to
   * choose between upgrading or scheduling the free instance for deletion. This
   * timestamp is set during the creation of a free instance.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The expireTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getExpireTime() {
    return expireTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : expireTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Timestamp after which the instance will either be upgraded or
   * scheduled for deletion after a grace period. ExpireBehavior is used to
   * choose between upgrading or scheduling the free instance for deletion. This
   * timestamp is set during the creation of a free instance.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder() {
    return expireTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : expireTime_;
  }

  public static final int UPGRADE_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp upgradeTime_;

  /**
   *
   *
   * <pre>
   * Output only. If present, the timestamp at which the free instance was
   * upgraded to a provisioned instance.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp upgrade_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the upgradeTime field is set.
   */
  @java.lang.Override
  public boolean hasUpgradeTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. If present, the timestamp at which the free instance was
   * upgraded to a provisioned instance.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp upgrade_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The upgradeTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpgradeTime() {
    return upgradeTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : upgradeTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. If present, the timestamp at which the free instance was
   * upgraded to a provisioned instance.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp upgrade_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpgradeTimeOrBuilder() {
    return upgradeTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : upgradeTime_;
  }

  public static final int EXPIRE_BEHAVIOR_FIELD_NUMBER = 3;
  private int expireBehavior_ = 0;

  /**
   *
   *
   * <pre>
   * Specifies the expiration behavior of a free instance. The default of
   * ExpireBehavior is `REMOVE_AFTER_GRACE_PERIOD`. This can be modified during
   * or after creation, and before expiration.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.instance.v1.FreeInstanceMetadata.ExpireBehavior expire_behavior = 3;
   * </code>
   *
   * @return The enum numeric value on the wire for expireBehavior.
   */
  @java.lang.Override
  public int getExpireBehaviorValue() {
    return expireBehavior_;
  }

  /**
   *
   *
   * <pre>
   * Specifies the expiration behavior of a free instance. The default of
   * ExpireBehavior is `REMOVE_AFTER_GRACE_PERIOD`. This can be modified during
   * or after creation, and before expiration.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.instance.v1.FreeInstanceMetadata.ExpireBehavior expire_behavior = 3;
   * </code>
   *
   * @return The expireBehavior.
   */
  @java.lang.Override
  public com.google.spanner.admin.instance.v1.FreeInstanceMetadata.ExpireBehavior
      getExpireBehavior() {
    com.google.spanner.admin.instance.v1.FreeInstanceMetadata.ExpireBehavior result =
        com.google.spanner.admin.instance.v1.FreeInstanceMetadata.ExpireBehavior.forNumber(
            expireBehavior_);
    return result == null
        ? com.google.spanner.admin.instance.v1.FreeInstanceMetadata.ExpireBehavior.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getExpireTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getUpgradeTime());
    }
    if (expireBehavior_
        != com.google.spanner.admin.instance.v1.FreeInstanceMetadata.ExpireBehavior
            .EXPIRE_BEHAVIOR_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, expireBehavior_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getExpireTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getUpgradeTime());
    }
    if (expireBehavior_
        != com.google.spanner.admin.instance.v1.FreeInstanceMetadata.ExpireBehavior
            .EXPIRE_BEHAVIOR_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, expireBehavior_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.admin.instance.v1.FreeInstanceMetadata)) {
      return super.equals(obj);
    }
    com.google.spanner.admin.instance.v1.FreeInstanceMetadata other =
        (com.google.spanner.admin.instance.v1.FreeInstanceMetadata) obj;

    if (hasExpireTime() != other.hasExpireTime()) return false;
    if (hasExpireTime()) {
      if (!getExpireTime().equals(other.getExpireTime())) return false;
    }
    if (hasUpgradeTime() != other.hasUpgradeTime()) return false;
    if (hasUpgradeTime()) {
      if (!getUpgradeTime().equals(other.getUpgradeTime())) return false;
    }
    if (expireBehavior_ != other.expireBehavior_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasExpireTime()) {
      hash = (37 * hash) + EXPIRE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getExpireTime().hashCode();
    }
    if (hasUpgradeTime()) {
      hash = (37 * hash) + UPGRADE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpgradeTime().hashCode();
    }
    hash = (37 * hash) + EXPIRE_BEHAVIOR_FIELD_NUMBER;
    hash = (53 * hash) + expireBehavior_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.admin.instance.v1.FreeInstanceMetadata parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.instance.v1.FreeInstanceMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.instance.v1.FreeInstanceMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.instance.v1.FreeInstanceMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.instance.v1.FreeInstanceMetadata parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.instance.v1.FreeInstanceMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.instance.v1.FreeInstanceMetadata parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.instance.v1.FreeInstanceMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.admin.instance.v1.FreeInstanceMetadata parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.instance.v1.FreeInstanceMetadata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.admin.instance.v1.FreeInstanceMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.instance.v1.FreeInstanceMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.spanner.admin.instance.v1.FreeInstanceMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Free instance specific metadata that is kept even after an instance has been
   * upgraded for tracking purposes.
   * </pre>
   *
   * Protobuf type {@code google.spanner.admin.instance.v1.FreeInstanceMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.admin.instance.v1.FreeInstanceMetadata)
      com.google.spanner.admin.instance.v1.FreeInstanceMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
          .internal_static_google_spanner_admin_instance_v1_FreeInstanceMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
          .internal_static_google_spanner_admin_instance_v1_FreeInstanceMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.admin.instance.v1.FreeInstanceMetadata.class,
              com.google.spanner.admin.instance.v1.FreeInstanceMetadata.Builder.class);
    }

    // Construct using com.google.spanner.admin.instance.v1.FreeInstanceMetadata.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getExpireTimeFieldBuilder();
        getUpgradeTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      expireTime_ = null;
      if (expireTimeBuilder_ != null) {
        expireTimeBuilder_.dispose();
        expireTimeBuilder_ = null;
      }
      upgradeTime_ = null;
      if (upgradeTimeBuilder_ != null) {
        upgradeTimeBuilder_.dispose();
        upgradeTimeBuilder_ = null;
      }
      expireBehavior_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
          .internal_static_google_spanner_admin_instance_v1_FreeInstanceMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.admin.instance.v1.FreeInstanceMetadata getDefaultInstanceForType() {
      return com.google.spanner.admin.instance.v1.FreeInstanceMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.admin.instance.v1.FreeInstanceMetadata build() {
      com.google.spanner.admin.instance.v1.FreeInstanceMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.admin.instance.v1.FreeInstanceMetadata buildPartial() {
      com.google.spanner.admin.instance.v1.FreeInstanceMetadata result =
          new com.google.spanner.admin.instance.v1.FreeInstanceMetadata(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.spanner.admin.instance.v1.FreeInstanceMetadata result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.expireTime_ = expireTimeBuilder_ == null ? expireTime_ : expireTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.upgradeTime_ =
            upgradeTimeBuilder_ == null ? upgradeTime_ : upgradeTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.expireBehavior_ = expireBehavior_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.admin.instance.v1.FreeInstanceMetadata) {
        return mergeFrom((com.google.spanner.admin.instance.v1.FreeInstanceMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.admin.instance.v1.FreeInstanceMetadata other) {
      if (other == com.google.spanner.admin.instance.v1.FreeInstanceMetadata.getDefaultInstance())
        return this;
      if (other.hasExpireTime()) {
        mergeExpireTime(other.getExpireTime());
      }
      if (other.hasUpgradeTime()) {
        mergeUpgradeTime(other.getUpgradeTime());
      }
      if (other.expireBehavior_ != 0) {
        setExpireBehaviorValue(other.getExpireBehaviorValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getExpireTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getUpgradeTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                expireBehavior_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.Timestamp expireTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        expireTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Timestamp after which the instance will either be upgraded or
     * scheduled for deletion after a grace period. ExpireBehavior is used to
     * choose between upgrading or scheduling the free instance for deletion. This
     * timestamp is set during the creation of a free instance.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the expireTime field is set.
     */
    public boolean hasExpireTime() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp after which the instance will either be upgraded or
     * scheduled for deletion after a grace period. ExpireBehavior is used to
     * choose between upgrading or scheduling the free instance for deletion. This
     * timestamp is set during the creation of a free instance.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The expireTime.
     */
    public com.google.protobuf.Timestamp getExpireTime() {
      if (expireTimeBuilder_ == null) {
        return expireTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : expireTime_;
      } else {
        return expireTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp after which the instance will either be upgraded or
     * scheduled for deletion after a grace period. ExpireBehavior is used to
     * choose between upgrading or scheduling the free instance for deletion. This
     * timestamp is set during the creation of a free instance.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setExpireTime(com.google.protobuf.Timestamp value) {
      if (expireTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        expireTime_ = value;
      } else {
        expireTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp after which the instance will either be upgraded or
     * scheduled for deletion after a grace period. ExpireBehavior is used to
     * choose between upgrading or scheduling the free instance for deletion. This
     * timestamp is set during the creation of a free instance.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setExpireTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (expireTimeBuilder_ == null) {
        expireTime_ = builderForValue.build();
      } else {
        expireTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp after which the instance will either be upgraded or
     * scheduled for deletion after a grace period. ExpireBehavior is used to
     * choose between upgrading or scheduling the free instance for deletion. This
     * timestamp is set during the creation of a free instance.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeExpireTime(com.google.protobuf.Timestamp value) {
      if (expireTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && expireTime_ != null
            && expireTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getExpireTimeBuilder().mergeFrom(value);
        } else {
          expireTime_ = value;
        }
      } else {
        expireTimeBuilder_.mergeFrom(value);
      }
      if (expireTime_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp after which the instance will either be upgraded or
     * scheduled for deletion after a grace period. ExpireBehavior is used to
     * choose between upgrading or scheduling the free instance for deletion. This
     * timestamp is set during the creation of a free instance.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearExpireTime() {
      bitField0_ = (bitField0_ & ~0x00000001);
      expireTime_ = null;
      if (expireTimeBuilder_ != null) {
        expireTimeBuilder_.dispose();
        expireTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp after which the instance will either be upgraded or
     * scheduled for deletion after a grace period. ExpireBehavior is used to
     * choose between upgrading or scheduling the free instance for deletion. This
     * timestamp is set during the creation of a free instance.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getExpireTimeBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getExpireTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp after which the instance will either be upgraded or
     * scheduled for deletion after a grace period. ExpireBehavior is used to
     * choose between upgrading or scheduling the free instance for deletion. This
     * timestamp is set during the creation of a free instance.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder() {
      if (expireTimeBuilder_ != null) {
        return expireTimeBuilder_.getMessageOrBuilder();
      } else {
        return expireTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : expireTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp after which the instance will either be upgraded or
     * scheduled for deletion after a grace period. ExpireBehavior is used to
     * choose between upgrading or scheduling the free instance for deletion. This
     * timestamp is set during the creation of a free instance.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getExpireTimeFieldBuilder() {
      if (expireTimeBuilder_ == null) {
        expireTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getExpireTime(), getParentForChildren(), isClean());
        expireTime_ = null;
      }
      return expireTimeBuilder_;
    }

    private com.google.protobuf.Timestamp upgradeTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        upgradeTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. If present, the timestamp at which the free instance was
     * upgraded to a provisioned instance.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp upgrade_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the upgradeTime field is set.
     */
    public boolean hasUpgradeTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. If present, the timestamp at which the free instance was
     * upgraded to a provisioned instance.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp upgrade_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The upgradeTime.
     */
    public com.google.protobuf.Timestamp getUpgradeTime() {
      if (upgradeTimeBuilder_ == null) {
        return upgradeTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : upgradeTime_;
      } else {
        return upgradeTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. If present, the timestamp at which the free instance was
     * upgraded to a provisioned instance.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp upgrade_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpgradeTime(com.google.protobuf.Timestamp value) {
      if (upgradeTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        upgradeTime_ = value;
      } else {
        upgradeTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. If present, the timestamp at which the free instance was
     * upgraded to a provisioned instance.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp upgrade_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpgradeTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (upgradeTimeBuilder_ == null) {
        upgradeTime_ = builderForValue.build();
      } else {
        upgradeTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. If present, the timestamp at which the free instance was
     * upgraded to a provisioned instance.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp upgrade_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpgradeTime(com.google.protobuf.Timestamp value) {
      if (upgradeTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && upgradeTime_ != null
            && upgradeTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpgradeTimeBuilder().mergeFrom(value);
        } else {
          upgradeTime_ = value;
        }
      } else {
        upgradeTimeBuilder_.mergeFrom(value);
      }
      if (upgradeTime_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. If present, the timestamp at which the free instance was
     * upgraded to a provisioned instance.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp upgrade_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpgradeTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      upgradeTime_ = null;
      if (upgradeTimeBuilder_ != null) {
        upgradeTimeBuilder_.dispose();
        upgradeTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. If present, the timestamp at which the free instance was
     * upgraded to a provisioned instance.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp upgrade_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpgradeTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getUpgradeTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. If present, the timestamp at which the free instance was
     * upgraded to a provisioned instance.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp upgrade_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpgradeTimeOrBuilder() {
      if (upgradeTimeBuilder_ != null) {
        return upgradeTimeBuilder_.getMessageOrBuilder();
      } else {
        return upgradeTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : upgradeTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. If present, the timestamp at which the free instance was
     * upgraded to a provisioned instance.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp upgrade_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpgradeTimeFieldBuilder() {
      if (upgradeTimeBuilder_ == null) {
        upgradeTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpgradeTime(), getParentForChildren(), isClean());
        upgradeTime_ = null;
      }
      return upgradeTimeBuilder_;
    }

    private int expireBehavior_ = 0;

    /**
     *
     *
     * <pre>
     * Specifies the expiration behavior of a free instance. The default of
     * ExpireBehavior is `REMOVE_AFTER_GRACE_PERIOD`. This can be modified during
     * or after creation, and before expiration.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.FreeInstanceMetadata.ExpireBehavior expire_behavior = 3;
     * </code>
     *
     * @return The enum numeric value on the wire for expireBehavior.
     */
    @java.lang.Override
    public int getExpireBehaviorValue() {
      return expireBehavior_;
    }

    /**
     *
     *
     * <pre>
     * Specifies the expiration behavior of a free instance. The default of
     * ExpireBehavior is `REMOVE_AFTER_GRACE_PERIOD`. This can be modified during
     * or after creation, and before expiration.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.FreeInstanceMetadata.ExpireBehavior expire_behavior = 3;
     * </code>
     *
     * @param value The enum numeric value on the wire for expireBehavior to set.
     * @return This builder for chaining.
     */
    public Builder setExpireBehaviorValue(int value) {
      expireBehavior_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the expiration behavior of a free instance. The default of
     * ExpireBehavior is `REMOVE_AFTER_GRACE_PERIOD`. This can be modified during
     * or after creation, and before expiration.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.FreeInstanceMetadata.ExpireBehavior expire_behavior = 3;
     * </code>
     *
     * @return The expireBehavior.
     */
    @java.lang.Override
    public com.google.spanner.admin.instance.v1.FreeInstanceMetadata.ExpireBehavior
        getExpireBehavior() {
      com.google.spanner.admin.instance.v1.FreeInstanceMetadata.ExpireBehavior result =
          com.google.spanner.admin.instance.v1.FreeInstanceMetadata.ExpireBehavior.forNumber(
              expireBehavior_);
      return result == null
          ? com.google.spanner.admin.instance.v1.FreeInstanceMetadata.ExpireBehavior.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * Specifies the expiration behavior of a free instance. The default of
     * ExpireBehavior is `REMOVE_AFTER_GRACE_PERIOD`. This can be modified during
     * or after creation, and before expiration.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.FreeInstanceMetadata.ExpireBehavior expire_behavior = 3;
     * </code>
     *
     * @param value The expireBehavior to set.
     * @return This builder for chaining.
     */
    public Builder setExpireBehavior(
        com.google.spanner.admin.instance.v1.FreeInstanceMetadata.ExpireBehavior value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      expireBehavior_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the expiration behavior of a free instance. The default of
     * ExpireBehavior is `REMOVE_AFTER_GRACE_PERIOD`. This can be modified during
     * or after creation, and before expiration.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.FreeInstanceMetadata.ExpireBehavior expire_behavior = 3;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExpireBehavior() {
      bitField0_ = (bitField0_ & ~0x00000004);
      expireBehavior_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.admin.instance.v1.FreeInstanceMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.admin.instance.v1.FreeInstanceMetadata)
  private static final com.google.spanner.admin.instance.v1.FreeInstanceMetadata DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.admin.instance.v1.FreeInstanceMetadata();
  }

  public static com.google.spanner.admin.instance.v1.FreeInstanceMetadata getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<FreeInstanceMetadata> PARSER =
      new com.google.protobuf.AbstractParser<FreeInstanceMetadata>() {
        @java.lang.Override
        public FreeInstanceMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<FreeInstanceMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<FreeInstanceMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.admin.instance.v1.FreeInstanceMetadata getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
