/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/admin/database/v1/spanner_database_admin.proto

package com.google.spanner.admin.database.v1;

/**
 *
 *
 * <pre>
 * Metadata type for the operation returned by
 * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl].
 * </pre>
 *
 * Protobuf type {@code google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata}
 */
public final class UpdateDatabaseDdlMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata)
    UpdateDatabaseDdlMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use UpdateDatabaseDdlMetadata.newBuilder() to construct.
  private UpdateDatabaseDdlMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private UpdateDatabaseDdlMetadata() {
    database_ = "";
    statements_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    commitTimestamps_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new UpdateDatabaseDdlMetadata();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private UpdateDatabaseDdlMetadata(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              database_ = s;
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                statements_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000001;
              }
              statements_.add(s);
              break;
            }
          case 26:
            {
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                commitTimestamps_ = new java.util.ArrayList<com.google.protobuf.Timestamp>();
                mutable_bitField0_ |= 0x00000002;
              }
              commitTimestamps_.add(
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry));
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        statements_ = statements_.getUnmodifiableView();
      }
      if (((mutable_bitField0_ & 0x00000002) != 0)) {
        commitTimestamps_ = java.util.Collections.unmodifiableList(commitTimestamps_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto
        .internal_static_google_spanner_admin_database_v1_UpdateDatabaseDdlMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto
        .internal_static_google_spanner_admin_database_v1_UpdateDatabaseDdlMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata.class,
            com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata.Builder.class);
  }

  public static final int DATABASE_FIELD_NUMBER = 1;
  private volatile java.lang.Object database_;
  /**
   *
   *
   * <pre>
   * The database being modified.
   * </pre>
   *
   * <code>string database = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The database.
   */
  @java.lang.Override
  public java.lang.String getDatabase() {
    java.lang.Object ref = database_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      database_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The database being modified.
   * </pre>
   *
   * <code>string database = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for database.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDatabaseBytes() {
    java.lang.Object ref = database_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      database_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATEMENTS_FIELD_NUMBER = 2;
  private com.google.protobuf.LazyStringList statements_;
  /**
   *
   *
   * <pre>
   * For an update this list contains all the statements. For an
   * individual statement, this list contains only that statement.
   * </pre>
   *
   * <code>repeated string statements = 2;</code>
   *
   * @return A list containing the statements.
   */
  public com.google.protobuf.ProtocolStringList getStatementsList() {
    return statements_;
  }
  /**
   *
   *
   * <pre>
   * For an update this list contains all the statements. For an
   * individual statement, this list contains only that statement.
   * </pre>
   *
   * <code>repeated string statements = 2;</code>
   *
   * @return The count of statements.
   */
  public int getStatementsCount() {
    return statements_.size();
  }
  /**
   *
   *
   * <pre>
   * For an update this list contains all the statements. For an
   * individual statement, this list contains only that statement.
   * </pre>
   *
   * <code>repeated string statements = 2;</code>
   *
   * @param index The index of the element to return.
   * @return The statements at the given index.
   */
  public java.lang.String getStatements(int index) {
    return statements_.get(index);
  }
  /**
   *
   *
   * <pre>
   * For an update this list contains all the statements. For an
   * individual statement, this list contains only that statement.
   * </pre>
   *
   * <code>repeated string statements = 2;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the statements at the given index.
   */
  public com.google.protobuf.ByteString getStatementsBytes(int index) {
    return statements_.getByteString(index);
  }

  public static final int COMMIT_TIMESTAMPS_FIELD_NUMBER = 3;
  private java.util.List<com.google.protobuf.Timestamp> commitTimestamps_;
  /**
   *
   *
   * <pre>
   * Reports the commit timestamps of all statements that have
   * succeeded so far, where `commit_timestamps[i]` is the commit
   * timestamp for the statement `statements[i]`.
   * </pre>
   *
   * <code>repeated .google.protobuf.Timestamp commit_timestamps = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.protobuf.Timestamp> getCommitTimestampsList() {
    return commitTimestamps_;
  }
  /**
   *
   *
   * <pre>
   * Reports the commit timestamps of all statements that have
   * succeeded so far, where `commit_timestamps[i]` is the commit
   * timestamp for the statement `statements[i]`.
   * </pre>
   *
   * <code>repeated .google.protobuf.Timestamp commit_timestamps = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.protobuf.TimestampOrBuilder>
      getCommitTimestampsOrBuilderList() {
    return commitTimestamps_;
  }
  /**
   *
   *
   * <pre>
   * Reports the commit timestamps of all statements that have
   * succeeded so far, where `commit_timestamps[i]` is the commit
   * timestamp for the statement `statements[i]`.
   * </pre>
   *
   * <code>repeated .google.protobuf.Timestamp commit_timestamps = 3;</code>
   */
  @java.lang.Override
  public int getCommitTimestampsCount() {
    return commitTimestamps_.size();
  }
  /**
   *
   *
   * <pre>
   * Reports the commit timestamps of all statements that have
   * succeeded so far, where `commit_timestamps[i]` is the commit
   * timestamp for the statement `statements[i]`.
   * </pre>
   *
   * <code>repeated .google.protobuf.Timestamp commit_timestamps = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCommitTimestamps(int index) {
    return commitTimestamps_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Reports the commit timestamps of all statements that have
   * succeeded so far, where `commit_timestamps[i]` is the commit
   * timestamp for the statement `statements[i]`.
   * </pre>
   *
   * <code>repeated .google.protobuf.Timestamp commit_timestamps = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCommitTimestampsOrBuilder(int index) {
    return commitTimestamps_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getDatabaseBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, database_);
    }
    for (int i = 0; i < statements_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, statements_.getRaw(i));
    }
    for (int i = 0; i < commitTimestamps_.size(); i++) {
      output.writeMessage(3, commitTimestamps_.get(i));
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getDatabaseBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, database_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < statements_.size(); i++) {
        dataSize += computeStringSizeNoTag(statements_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getStatementsList().size();
    }
    for (int i = 0; i < commitTimestamps_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, commitTimestamps_.get(i));
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata)) {
      return super.equals(obj);
    }
    com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata other =
        (com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata) obj;

    if (!getDatabase().equals(other.getDatabase())) return false;
    if (!getStatementsList().equals(other.getStatementsList())) return false;
    if (!getCommitTimestampsList().equals(other.getCommitTimestampsList())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DATABASE_FIELD_NUMBER;
    hash = (53 * hash) + getDatabase().hashCode();
    if (getStatementsCount() > 0) {
      hash = (37 * hash) + STATEMENTS_FIELD_NUMBER;
      hash = (53 * hash) + getStatementsList().hashCode();
    }
    if (getCommitTimestampsCount() > 0) {
      hash = (37 * hash) + COMMIT_TIMESTAMPS_FIELD_NUMBER;
      hash = (53 * hash) + getCommitTimestampsList().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Metadata type for the operation returned by
   * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl].
   * </pre>
   *
   * Protobuf type {@code google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata)
      com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto
          .internal_static_google_spanner_admin_database_v1_UpdateDatabaseDdlMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto
          .internal_static_google_spanner_admin_database_v1_UpdateDatabaseDdlMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata.class,
              com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata.Builder.class);
    }

    // Construct using com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCommitTimestampsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      database_ = "";

      statements_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      if (commitTimestampsBuilder_ == null) {
        commitTimestamps_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
      } else {
        commitTimestampsBuilder_.clear();
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto
          .internal_static_google_spanner_admin_database_v1_UpdateDatabaseDdlMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata
        getDefaultInstanceForType() {
      return com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata build() {
      com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata buildPartial() {
      com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata result =
          new com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata(this);
      int from_bitField0_ = bitField0_;
      result.database_ = database_;
      if (((bitField0_ & 0x00000001) != 0)) {
        statements_ = statements_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.statements_ = statements_;
      if (commitTimestampsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          commitTimestamps_ = java.util.Collections.unmodifiableList(commitTimestamps_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.commitTimestamps_ = commitTimestamps_;
      } else {
        result.commitTimestamps_ = commitTimestampsBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata) {
        return mergeFrom((com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata other) {
      if (other
          == com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata.getDefaultInstance())
        return this;
      if (!other.getDatabase().isEmpty()) {
        database_ = other.database_;
        onChanged();
      }
      if (!other.statements_.isEmpty()) {
        if (statements_.isEmpty()) {
          statements_ = other.statements_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureStatementsIsMutable();
          statements_.addAll(other.statements_);
        }
        onChanged();
      }
      if (commitTimestampsBuilder_ == null) {
        if (!other.commitTimestamps_.isEmpty()) {
          if (commitTimestamps_.isEmpty()) {
            commitTimestamps_ = other.commitTimestamps_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureCommitTimestampsIsMutable();
            commitTimestamps_.addAll(other.commitTimestamps_);
          }
          onChanged();
        }
      } else {
        if (!other.commitTimestamps_.isEmpty()) {
          if (commitTimestampsBuilder_.isEmpty()) {
            commitTimestampsBuilder_.dispose();
            commitTimestampsBuilder_ = null;
            commitTimestamps_ = other.commitTimestamps_;
            bitField0_ = (bitField0_ & ~0x00000002);
            commitTimestampsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getCommitTimestampsFieldBuilder()
                    : null;
          } else {
            commitTimestampsBuilder_.addAllMessages(other.commitTimestamps_);
          }
        }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata)
                e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object database_ = "";
    /**
     *
     *
     * <pre>
     * The database being modified.
     * </pre>
     *
     * <code>string database = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The database.
     */
    public java.lang.String getDatabase() {
      java.lang.Object ref = database_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        database_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The database being modified.
     * </pre>
     *
     * <code>string database = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for database.
     */
    public com.google.protobuf.ByteString getDatabaseBytes() {
      java.lang.Object ref = database_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        database_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The database being modified.
     * </pre>
     *
     * <code>string database = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The database to set.
     * @return This builder for chaining.
     */
    public Builder setDatabase(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      database_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The database being modified.
     * </pre>
     *
     * <code>string database = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDatabase() {

      database_ = getDefaultInstance().getDatabase();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The database being modified.
     * </pre>
     *
     * <code>string database = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for database to set.
     * @return This builder for chaining.
     */
    public Builder setDatabaseBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      database_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList statements_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureStatementsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        statements_ = new com.google.protobuf.LazyStringArrayList(statements_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * For an update this list contains all the statements. For an
     * individual statement, this list contains only that statement.
     * </pre>
     *
     * <code>repeated string statements = 2;</code>
     *
     * @return A list containing the statements.
     */
    public com.google.protobuf.ProtocolStringList getStatementsList() {
      return statements_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * For an update this list contains all the statements. For an
     * individual statement, this list contains only that statement.
     * </pre>
     *
     * <code>repeated string statements = 2;</code>
     *
     * @return The count of statements.
     */
    public int getStatementsCount() {
      return statements_.size();
    }
    /**
     *
     *
     * <pre>
     * For an update this list contains all the statements. For an
     * individual statement, this list contains only that statement.
     * </pre>
     *
     * <code>repeated string statements = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The statements at the given index.
     */
    public java.lang.String getStatements(int index) {
      return statements_.get(index);
    }
    /**
     *
     *
     * <pre>
     * For an update this list contains all the statements. For an
     * individual statement, this list contains only that statement.
     * </pre>
     *
     * <code>repeated string statements = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the statements at the given index.
     */
    public com.google.protobuf.ByteString getStatementsBytes(int index) {
      return statements_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * For an update this list contains all the statements. For an
     * individual statement, this list contains only that statement.
     * </pre>
     *
     * <code>repeated string statements = 2;</code>
     *
     * @param index The index to set the value at.
     * @param value The statements to set.
     * @return This builder for chaining.
     */
    public Builder setStatements(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureStatementsIsMutable();
      statements_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * For an update this list contains all the statements. For an
     * individual statement, this list contains only that statement.
     * </pre>
     *
     * <code>repeated string statements = 2;</code>
     *
     * @param value The statements to add.
     * @return This builder for chaining.
     */
    public Builder addStatements(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureStatementsIsMutable();
      statements_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * For an update this list contains all the statements. For an
     * individual statement, this list contains only that statement.
     * </pre>
     *
     * <code>repeated string statements = 2;</code>
     *
     * @param values The statements to add.
     * @return This builder for chaining.
     */
    public Builder addAllStatements(java.lang.Iterable<java.lang.String> values) {
      ensureStatementsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, statements_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * For an update this list contains all the statements. For an
     * individual statement, this list contains only that statement.
     * </pre>
     *
     * <code>repeated string statements = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatements() {
      statements_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * For an update this list contains all the statements. For an
     * individual statement, this list contains only that statement.
     * </pre>
     *
     * <code>repeated string statements = 2;</code>
     *
     * @param value The bytes of the statements to add.
     * @return This builder for chaining.
     */
    public Builder addStatementsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureStatementsIsMutable();
      statements_.add(value);
      onChanged();
      return this;
    }

    private java.util.List<com.google.protobuf.Timestamp> commitTimestamps_ =
        java.util.Collections.emptyList();

    private void ensureCommitTimestampsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        commitTimestamps_ =
            new java.util.ArrayList<com.google.protobuf.Timestamp>(commitTimestamps_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        commitTimestampsBuilder_;

    /**
     *
     *
     * <pre>
     * Reports the commit timestamps of all statements that have
     * succeeded so far, where `commit_timestamps[i]` is the commit
     * timestamp for the statement `statements[i]`.
     * </pre>
     *
     * <code>repeated .google.protobuf.Timestamp commit_timestamps = 3;</code>
     */
    public java.util.List<com.google.protobuf.Timestamp> getCommitTimestampsList() {
      if (commitTimestampsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(commitTimestamps_);
      } else {
        return commitTimestampsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Reports the commit timestamps of all statements that have
     * succeeded so far, where `commit_timestamps[i]` is the commit
     * timestamp for the statement `statements[i]`.
     * </pre>
     *
     * <code>repeated .google.protobuf.Timestamp commit_timestamps = 3;</code>
     */
    public int getCommitTimestampsCount() {
      if (commitTimestampsBuilder_ == null) {
        return commitTimestamps_.size();
      } else {
        return commitTimestampsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Reports the commit timestamps of all statements that have
     * succeeded so far, where `commit_timestamps[i]` is the commit
     * timestamp for the statement `statements[i]`.
     * </pre>
     *
     * <code>repeated .google.protobuf.Timestamp commit_timestamps = 3;</code>
     */
    public com.google.protobuf.Timestamp getCommitTimestamps(int index) {
      if (commitTimestampsBuilder_ == null) {
        return commitTimestamps_.get(index);
      } else {
        return commitTimestampsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Reports the commit timestamps of all statements that have
     * succeeded so far, where `commit_timestamps[i]` is the commit
     * timestamp for the statement `statements[i]`.
     * </pre>
     *
     * <code>repeated .google.protobuf.Timestamp commit_timestamps = 3;</code>
     */
    public Builder setCommitTimestamps(int index, com.google.protobuf.Timestamp value) {
      if (commitTimestampsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCommitTimestampsIsMutable();
        commitTimestamps_.set(index, value);
        onChanged();
      } else {
        commitTimestampsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Reports the commit timestamps of all statements that have
     * succeeded so far, where `commit_timestamps[i]` is the commit
     * timestamp for the statement `statements[i]`.
     * </pre>
     *
     * <code>repeated .google.protobuf.Timestamp commit_timestamps = 3;</code>
     */
    public Builder setCommitTimestamps(
        int index, com.google.protobuf.Timestamp.Builder builderForValue) {
      if (commitTimestampsBuilder_ == null) {
        ensureCommitTimestampsIsMutable();
        commitTimestamps_.set(index, builderForValue.build());
        onChanged();
      } else {
        commitTimestampsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Reports the commit timestamps of all statements that have
     * succeeded so far, where `commit_timestamps[i]` is the commit
     * timestamp for the statement `statements[i]`.
     * </pre>
     *
     * <code>repeated .google.protobuf.Timestamp commit_timestamps = 3;</code>
     */
    public Builder addCommitTimestamps(com.google.protobuf.Timestamp value) {
      if (commitTimestampsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCommitTimestampsIsMutable();
        commitTimestamps_.add(value);
        onChanged();
      } else {
        commitTimestampsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Reports the commit timestamps of all statements that have
     * succeeded so far, where `commit_timestamps[i]` is the commit
     * timestamp for the statement `statements[i]`.
     * </pre>
     *
     * <code>repeated .google.protobuf.Timestamp commit_timestamps = 3;</code>
     */
    public Builder addCommitTimestamps(int index, com.google.protobuf.Timestamp value) {
      if (commitTimestampsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCommitTimestampsIsMutable();
        commitTimestamps_.add(index, value);
        onChanged();
      } else {
        commitTimestampsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Reports the commit timestamps of all statements that have
     * succeeded so far, where `commit_timestamps[i]` is the commit
     * timestamp for the statement `statements[i]`.
     * </pre>
     *
     * <code>repeated .google.protobuf.Timestamp commit_timestamps = 3;</code>
     */
    public Builder addCommitTimestamps(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (commitTimestampsBuilder_ == null) {
        ensureCommitTimestampsIsMutable();
        commitTimestamps_.add(builderForValue.build());
        onChanged();
      } else {
        commitTimestampsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Reports the commit timestamps of all statements that have
     * succeeded so far, where `commit_timestamps[i]` is the commit
     * timestamp for the statement `statements[i]`.
     * </pre>
     *
     * <code>repeated .google.protobuf.Timestamp commit_timestamps = 3;</code>
     */
    public Builder addCommitTimestamps(
        int index, com.google.protobuf.Timestamp.Builder builderForValue) {
      if (commitTimestampsBuilder_ == null) {
        ensureCommitTimestampsIsMutable();
        commitTimestamps_.add(index, builderForValue.build());
        onChanged();
      } else {
        commitTimestampsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Reports the commit timestamps of all statements that have
     * succeeded so far, where `commit_timestamps[i]` is the commit
     * timestamp for the statement `statements[i]`.
     * </pre>
     *
     * <code>repeated .google.protobuf.Timestamp commit_timestamps = 3;</code>
     */
    public Builder addAllCommitTimestamps(
        java.lang.Iterable<? extends com.google.protobuf.Timestamp> values) {
      if (commitTimestampsBuilder_ == null) {
        ensureCommitTimestampsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, commitTimestamps_);
        onChanged();
      } else {
        commitTimestampsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Reports the commit timestamps of all statements that have
     * succeeded so far, where `commit_timestamps[i]` is the commit
     * timestamp for the statement `statements[i]`.
     * </pre>
     *
     * <code>repeated .google.protobuf.Timestamp commit_timestamps = 3;</code>
     */
    public Builder clearCommitTimestamps() {
      if (commitTimestampsBuilder_ == null) {
        commitTimestamps_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        commitTimestampsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Reports the commit timestamps of all statements that have
     * succeeded so far, where `commit_timestamps[i]` is the commit
     * timestamp for the statement `statements[i]`.
     * </pre>
     *
     * <code>repeated .google.protobuf.Timestamp commit_timestamps = 3;</code>
     */
    public Builder removeCommitTimestamps(int index) {
      if (commitTimestampsBuilder_ == null) {
        ensureCommitTimestampsIsMutable();
        commitTimestamps_.remove(index);
        onChanged();
      } else {
        commitTimestampsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Reports the commit timestamps of all statements that have
     * succeeded so far, where `commit_timestamps[i]` is the commit
     * timestamp for the statement `statements[i]`.
     * </pre>
     *
     * <code>repeated .google.protobuf.Timestamp commit_timestamps = 3;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCommitTimestampsBuilder(int index) {
      return getCommitTimestampsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Reports the commit timestamps of all statements that have
     * succeeded so far, where `commit_timestamps[i]` is the commit
     * timestamp for the statement `statements[i]`.
     * </pre>
     *
     * <code>repeated .google.protobuf.Timestamp commit_timestamps = 3;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCommitTimestampsOrBuilder(int index) {
      if (commitTimestampsBuilder_ == null) {
        return commitTimestamps_.get(index);
      } else {
        return commitTimestampsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Reports the commit timestamps of all statements that have
     * succeeded so far, where `commit_timestamps[i]` is the commit
     * timestamp for the statement `statements[i]`.
     * </pre>
     *
     * <code>repeated .google.protobuf.Timestamp commit_timestamps = 3;</code>
     */
    public java.util.List<? extends com.google.protobuf.TimestampOrBuilder>
        getCommitTimestampsOrBuilderList() {
      if (commitTimestampsBuilder_ != null) {
        return commitTimestampsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(commitTimestamps_);
      }
    }
    /**
     *
     *
     * <pre>
     * Reports the commit timestamps of all statements that have
     * succeeded so far, where `commit_timestamps[i]` is the commit
     * timestamp for the statement `statements[i]`.
     * </pre>
     *
     * <code>repeated .google.protobuf.Timestamp commit_timestamps = 3;</code>
     */
    public com.google.protobuf.Timestamp.Builder addCommitTimestampsBuilder() {
      return getCommitTimestampsFieldBuilder()
          .addBuilder(com.google.protobuf.Timestamp.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Reports the commit timestamps of all statements that have
     * succeeded so far, where `commit_timestamps[i]` is the commit
     * timestamp for the statement `statements[i]`.
     * </pre>
     *
     * <code>repeated .google.protobuf.Timestamp commit_timestamps = 3;</code>
     */
    public com.google.protobuf.Timestamp.Builder addCommitTimestampsBuilder(int index) {
      return getCommitTimestampsFieldBuilder()
          .addBuilder(index, com.google.protobuf.Timestamp.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Reports the commit timestamps of all statements that have
     * succeeded so far, where `commit_timestamps[i]` is the commit
     * timestamp for the statement `statements[i]`.
     * </pre>
     *
     * <code>repeated .google.protobuf.Timestamp commit_timestamps = 3;</code>
     */
    public java.util.List<com.google.protobuf.Timestamp.Builder> getCommitTimestampsBuilderList() {
      return getCommitTimestampsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCommitTimestampsFieldBuilder() {
      if (commitTimestampsBuilder_ == null) {
        commitTimestampsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                commitTimestamps_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        commitTimestamps_ = null;
      }
      return commitTimestampsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata)
  private static final com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata();
  }

  public static com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<UpdateDatabaseDdlMetadata> PARSER =
      new com.google.protobuf.AbstractParser<UpdateDatabaseDdlMetadata>() {
        @java.lang.Override
        public UpdateDatabaseDdlMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new UpdateDatabaseDdlMetadata(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<UpdateDatabaseDdlMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<UpdateDatabaseDdlMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
