/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.servicedirectory.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class EndpointName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/namespaces/{namespace}/services/{service}/endpoints/{endpoint}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String namespace;
    private final String service;
    private final String endpoint;

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getService() {
        return this.service;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private EndpointName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.namespace = (String)Preconditions.checkNotNull((Object)builder.getNamespace());
        this.service = (String)Preconditions.checkNotNull((Object)builder.getService());
        this.endpoint = (String)Preconditions.checkNotNull((Object)builder.getEndpoint());
    }

    public static EndpointName of(String project, String location, String namespace, String service, String endpoint) {
        return EndpointName.newBuilder().setProject(project).setLocation(location).setNamespace(namespace).setService(service).setEndpoint(endpoint).build();
    }

    public static String format(String project, String location, String namespace, String service, String endpoint) {
        return EndpointName.newBuilder().setProject(project).setLocation(location).setNamespace(namespace).setService(service).setEndpoint(endpoint).build().toString();
    }

    public static EndpointName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "EndpointName.parse: formattedString not in valid format");
        return EndpointName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("namespace"), (String)matchMap.get("service"), (String)matchMap.get("endpoint"));
    }

    public static List<EndpointName> parseList(List<String> formattedStrings) {
        ArrayList<EndpointName> list = new ArrayList<EndpointName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(EndpointName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<EndpointName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (EndpointName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            EndpointName endpointName = this;
            synchronized (endpointName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"location", (Object)this.location);
                    fieldMapBuilder.put((Object)"namespace", (Object)this.namespace);
                    fieldMapBuilder.put((Object)"service", (Object)this.service);
                    fieldMapBuilder.put((Object)"endpoint", (Object)this.endpoint);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "location", this.location, "namespace", this.namespace, "service", this.service, "endpoint", this.endpoint});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof EndpointName) {
            EndpointName that = (EndpointName)o;
            return this.project.equals(that.project) && this.location.equals(that.location) && this.namespace.equals(that.namespace) && this.service.equals(that.service) && this.endpoint.equals(that.endpoint);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        h ^= this.namespace.hashCode();
        h *= 1000003;
        h ^= this.service.hashCode();
        h *= 1000003;
        return h ^= this.endpoint.hashCode();
    }

    public static class Builder {
        private String project;
        private String location;
        private String namespace;
        private String service;
        private String endpoint;

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getService() {
            return this.service;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setNamespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder setService(String service) {
            this.service = service;
            return this;
        }

        public Builder setEndpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        private Builder() {
        }

        private Builder(EndpointName endpointName) {
            this.project = endpointName.project;
            this.location = endpointName.location;
            this.namespace = endpointName.namespace;
            this.service = endpointName.service;
            this.endpoint = endpointName.endpoint;
        }

        public EndpointName build() {
            return new EndpointName(this);
        }
    }
}

