/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.servicedirectory.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class NamespaceName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/namespaces/{namespace}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String namespace;

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private NamespaceName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.namespace = (String)Preconditions.checkNotNull((Object)builder.getNamespace());
    }

    public static NamespaceName of(String project, String location, String namespace) {
        return NamespaceName.newBuilder().setProject(project).setLocation(location).setNamespace(namespace).build();
    }

    public static String format(String project, String location, String namespace) {
        return NamespaceName.newBuilder().setProject(project).setLocation(location).setNamespace(namespace).build().toString();
    }

    public static NamespaceName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "NamespaceName.parse: formattedString not in valid format");
        return NamespaceName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("namespace"));
    }

    public static List<NamespaceName> parseList(List<String> formattedStrings) {
        ArrayList<NamespaceName> list = new ArrayList<NamespaceName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(NamespaceName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<NamespaceName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (NamespaceName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            NamespaceName namespaceName = this;
            synchronized (namespaceName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"location", (Object)this.location);
                    fieldMapBuilder.put((Object)"namespace", (Object)this.namespace);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "location", this.location, "namespace", this.namespace});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof NamespaceName) {
            NamespaceName that = (NamespaceName)o;
            return this.project.equals(that.project) && this.location.equals(that.location) && this.namespace.equals(that.namespace);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        return h ^= this.namespace.hashCode();
    }

    public static class Builder {
        private String project;
        private String location;
        private String namespace;

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setNamespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        private Builder() {
        }

        private Builder(NamespaceName namespaceName) {
            this.project = namespaceName.project;
            this.location = namespaceName.location;
            this.namespace = namespaceName.namespace;
        }

        public NamespaceName build() {
            return new NamespaceName(this);
        }
    }
}

