/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/serviceusage/v1beta1/serviceusage.proto

// Protobuf Java Version: 3.25.8
package com.google.api.serviceusage.v1beta1;

/**
 *
 *
 * <pre>
 * Request message for ImportAdminOverrides
 * </pre>
 *
 * Protobuf type {@code google.api.serviceusage.v1beta1.ImportAdminOverridesRequest}
 */
public final class ImportAdminOverridesRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.api.serviceusage.v1beta1.ImportAdminOverridesRequest)
    ImportAdminOverridesRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use ImportAdminOverridesRequest.newBuilder() to construct.
  private ImportAdminOverridesRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ImportAdminOverridesRequest() {
    parent_ = "";
    forceOnly_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ImportAdminOverridesRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.api.serviceusage.v1beta1.ServiceUsageProto
        .internal_static_google_api_serviceusage_v1beta1_ImportAdminOverridesRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.api.serviceusage.v1beta1.ServiceUsageProto
        .internal_static_google_api_serviceusage_v1beta1_ImportAdminOverridesRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.api.serviceusage.v1beta1.ImportAdminOverridesRequest.class,
            com.google.api.serviceusage.v1beta1.ImportAdminOverridesRequest.Builder.class);
  }

  private int sourceCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object source_;

  public enum SourceCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    INLINE_SOURCE(2),
    SOURCE_NOT_SET(0);
    private final int value;

    private SourceCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SourceCase valueOf(int value) {
      return forNumber(value);
    }

    public static SourceCase forNumber(int value) {
      switch (value) {
        case 2:
          return INLINE_SOURCE;
        case 0:
          return SOURCE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SourceCase getSourceCase() {
    return SourceCase.forNumber(sourceCase_);
  }

  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";

  /**
   *
   *
   * <pre>
   * The resource name of the consumer.
   *
   * An example name would be:
   * `projects/123/services/compute.googleapis.com`
   * </pre>
   *
   * <code>string parent = 1;</code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The resource name of the consumer.
   *
   * An example name would be:
   * `projects/123/services/compute.googleapis.com`
   * </pre>
   *
   * <code>string parent = 1;</code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INLINE_SOURCE_FIELD_NUMBER = 2;

  /**
   *
   *
   * <pre>
   * The import data is specified in the request message itself
   * </pre>
   *
   * <code>.google.api.serviceusage.v1beta1.OverrideInlineSource inline_source = 2;</code>
   *
   * @return Whether the inlineSource field is set.
   */
  @java.lang.Override
  public boolean hasInlineSource() {
    return sourceCase_ == 2;
  }

  /**
   *
   *
   * <pre>
   * The import data is specified in the request message itself
   * </pre>
   *
   * <code>.google.api.serviceusage.v1beta1.OverrideInlineSource inline_source = 2;</code>
   *
   * @return The inlineSource.
   */
  @java.lang.Override
  public com.google.api.serviceusage.v1beta1.OverrideInlineSource getInlineSource() {
    if (sourceCase_ == 2) {
      return (com.google.api.serviceusage.v1beta1.OverrideInlineSource) source_;
    }
    return com.google.api.serviceusage.v1beta1.OverrideInlineSource.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * The import data is specified in the request message itself
   * </pre>
   *
   * <code>.google.api.serviceusage.v1beta1.OverrideInlineSource inline_source = 2;</code>
   */
  @java.lang.Override
  public com.google.api.serviceusage.v1beta1.OverrideInlineSourceOrBuilder
      getInlineSourceOrBuilder() {
    if (sourceCase_ == 2) {
      return (com.google.api.serviceusage.v1beta1.OverrideInlineSource) source_;
    }
    return com.google.api.serviceusage.v1beta1.OverrideInlineSource.getDefaultInstance();
  }

  public static final int FORCE_FIELD_NUMBER = 3;
  private boolean force_ = false;

  /**
   *
   *
   * <pre>
   * Whether to force the creation of the quota overrides.
   * Setting the force parameter to 'true' ignores all quota safety checks that
   * would fail the request. QuotaSafetyCheck lists all such validations.
   * </pre>
   *
   * <code>bool force = 3;</code>
   *
   * @return The force.
   */
  @java.lang.Override
  public boolean getForce() {
    return force_;
  }

  public static final int FORCE_ONLY_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> forceOnly_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.api.serviceusage.v1beta1.QuotaSafetyCheck>
      forceOnly_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.api.serviceusage.v1beta1.QuotaSafetyCheck>() {
            public com.google.api.serviceusage.v1beta1.QuotaSafetyCheck convert(
                java.lang.Integer from) {
              com.google.api.serviceusage.v1beta1.QuotaSafetyCheck result =
                  com.google.api.serviceusage.v1beta1.QuotaSafetyCheck.forNumber(from);
              return result == null
                  ? com.google.api.serviceusage.v1beta1.QuotaSafetyCheck.UNRECOGNIZED
                  : result;
            }
          };

  /**
   *
   *
   * <pre>
   * The list of quota safety checks to ignore before the override mutation.
   * Unlike 'force' field that ignores all the quota safety checks, the
   * 'force_only' field ignores only the specified checks; other checks are
   * still enforced. The 'force' and 'force_only' fields cannot both be set.
   * </pre>
   *
   * <code>repeated .google.api.serviceusage.v1beta1.QuotaSafetyCheck force_only = 4;</code>
   *
   * @return A list containing the forceOnly.
   */
  @java.lang.Override
  public java.util.List<com.google.api.serviceusage.v1beta1.QuotaSafetyCheck> getForceOnlyList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.api.serviceusage.v1beta1.QuotaSafetyCheck>(
        forceOnly_, forceOnly_converter_);
  }

  /**
   *
   *
   * <pre>
   * The list of quota safety checks to ignore before the override mutation.
   * Unlike 'force' field that ignores all the quota safety checks, the
   * 'force_only' field ignores only the specified checks; other checks are
   * still enforced. The 'force' and 'force_only' fields cannot both be set.
   * </pre>
   *
   * <code>repeated .google.api.serviceusage.v1beta1.QuotaSafetyCheck force_only = 4;</code>
   *
   * @return The count of forceOnly.
   */
  @java.lang.Override
  public int getForceOnlyCount() {
    return forceOnly_.size();
  }

  /**
   *
   *
   * <pre>
   * The list of quota safety checks to ignore before the override mutation.
   * Unlike 'force' field that ignores all the quota safety checks, the
   * 'force_only' field ignores only the specified checks; other checks are
   * still enforced. The 'force' and 'force_only' fields cannot both be set.
   * </pre>
   *
   * <code>repeated .google.api.serviceusage.v1beta1.QuotaSafetyCheck force_only = 4;</code>
   *
   * @param index The index of the element to return.
   * @return The forceOnly at the given index.
   */
  @java.lang.Override
  public com.google.api.serviceusage.v1beta1.QuotaSafetyCheck getForceOnly(int index) {
    return forceOnly_converter_.convert(forceOnly_.get(index));
  }

  /**
   *
   *
   * <pre>
   * The list of quota safety checks to ignore before the override mutation.
   * Unlike 'force' field that ignores all the quota safety checks, the
   * 'force_only' field ignores only the specified checks; other checks are
   * still enforced. The 'force' and 'force_only' fields cannot both be set.
   * </pre>
   *
   * <code>repeated .google.api.serviceusage.v1beta1.QuotaSafetyCheck force_only = 4;</code>
   *
   * @return A list containing the enum numeric values on the wire for forceOnly.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getForceOnlyValueList() {
    return forceOnly_;
  }

  /**
   *
   *
   * <pre>
   * The list of quota safety checks to ignore before the override mutation.
   * Unlike 'force' field that ignores all the quota safety checks, the
   * 'force_only' field ignores only the specified checks; other checks are
   * still enforced. The 'force' and 'force_only' fields cannot both be set.
   * </pre>
   *
   * <code>repeated .google.api.serviceusage.v1beta1.QuotaSafetyCheck force_only = 4;</code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of forceOnly at the given index.
   */
  @java.lang.Override
  public int getForceOnlyValue(int index) {
    return forceOnly_.get(index);
  }

  private int forceOnlyMemoizedSerializedSize;

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (sourceCase_ == 2) {
      output.writeMessage(2, (com.google.api.serviceusage.v1beta1.OverrideInlineSource) source_);
    }
    if (force_ != false) {
      output.writeBool(3, force_);
    }
    if (getForceOnlyList().size() > 0) {
      output.writeUInt32NoTag(34);
      output.writeUInt32NoTag(forceOnlyMemoizedSerializedSize);
    }
    for (int i = 0; i < forceOnly_.size(); i++) {
      output.writeEnumNoTag(forceOnly_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (sourceCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.api.serviceusage.v1beta1.OverrideInlineSource) source_);
    }
    if (force_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, force_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < forceOnly_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(forceOnly_.get(i));
      }
      size += dataSize;
      if (!getForceOnlyList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      forceOnlyMemoizedSerializedSize = dataSize;
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.api.serviceusage.v1beta1.ImportAdminOverridesRequest)) {
      return super.equals(obj);
    }
    com.google.api.serviceusage.v1beta1.ImportAdminOverridesRequest other =
        (com.google.api.serviceusage.v1beta1.ImportAdminOverridesRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (getForce() != other.getForce()) return false;
    if (!forceOnly_.equals(other.forceOnly_)) return false;
    if (!getSourceCase().equals(other.getSourceCase())) return false;
    switch (sourceCase_) {
      case 2:
        if (!getInlineSource().equals(other.getInlineSource())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + FORCE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getForce());
    if (getForceOnlyCount() > 0) {
      hash = (37 * hash) + FORCE_ONLY_FIELD_NUMBER;
      hash = (53 * hash) + forceOnly_.hashCode();
    }
    switch (sourceCase_) {
      case 2:
        hash = (37 * hash) + INLINE_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getInlineSource().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.api.serviceusage.v1beta1.ImportAdminOverridesRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.serviceusage.v1beta1.ImportAdminOverridesRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.serviceusage.v1beta1.ImportAdminOverridesRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.serviceusage.v1beta1.ImportAdminOverridesRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.serviceusage.v1beta1.ImportAdminOverridesRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.serviceusage.v1beta1.ImportAdminOverridesRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.serviceusage.v1beta1.ImportAdminOverridesRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.api.serviceusage.v1beta1.ImportAdminOverridesRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.serviceusage.v1beta1.ImportAdminOverridesRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.api.serviceusage.v1beta1.ImportAdminOverridesRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.serviceusage.v1beta1.ImportAdminOverridesRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.api.serviceusage.v1beta1.ImportAdminOverridesRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.api.serviceusage.v1beta1.ImportAdminOverridesRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Request message for ImportAdminOverrides
   * </pre>
   *
   * Protobuf type {@code google.api.serviceusage.v1beta1.ImportAdminOverridesRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.api.serviceusage.v1beta1.ImportAdminOverridesRequest)
      com.google.api.serviceusage.v1beta1.ImportAdminOverridesRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.api.serviceusage.v1beta1.ServiceUsageProto
          .internal_static_google_api_serviceusage_v1beta1_ImportAdminOverridesRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.serviceusage.v1beta1.ServiceUsageProto
          .internal_static_google_api_serviceusage_v1beta1_ImportAdminOverridesRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.api.serviceusage.v1beta1.ImportAdminOverridesRequest.class,
              com.google.api.serviceusage.v1beta1.ImportAdminOverridesRequest.Builder.class);
    }

    // Construct using com.google.api.serviceusage.v1beta1.ImportAdminOverridesRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      if (inlineSourceBuilder_ != null) {
        inlineSourceBuilder_.clear();
      }
      force_ = false;
      forceOnly_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      sourceCase_ = 0;
      source_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.api.serviceusage.v1beta1.ServiceUsageProto
          .internal_static_google_api_serviceusage_v1beta1_ImportAdminOverridesRequest_descriptor;
    }

    @java.lang.Override
    public com.google.api.serviceusage.v1beta1.ImportAdminOverridesRequest
        getDefaultInstanceForType() {
      return com.google.api.serviceusage.v1beta1.ImportAdminOverridesRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.api.serviceusage.v1beta1.ImportAdminOverridesRequest build() {
      com.google.api.serviceusage.v1beta1.ImportAdminOverridesRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.api.serviceusage.v1beta1.ImportAdminOverridesRequest buildPartial() {
      com.google.api.serviceusage.v1beta1.ImportAdminOverridesRequest result =
          new com.google.api.serviceusage.v1beta1.ImportAdminOverridesRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.api.serviceusage.v1beta1.ImportAdminOverridesRequest result) {
      if (((bitField0_ & 0x00000008) != 0)) {
        forceOnly_ = java.util.Collections.unmodifiableList(forceOnly_);
        bitField0_ = (bitField0_ & ~0x00000008);
      }
      result.forceOnly_ = forceOnly_;
    }

    private void buildPartial0(
        com.google.api.serviceusage.v1beta1.ImportAdminOverridesRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.force_ = force_;
      }
    }

    private void buildPartialOneofs(
        com.google.api.serviceusage.v1beta1.ImportAdminOverridesRequest result) {
      result.sourceCase_ = sourceCase_;
      result.source_ = this.source_;
      if (sourceCase_ == 2 && inlineSourceBuilder_ != null) {
        result.source_ = inlineSourceBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.api.serviceusage.v1beta1.ImportAdminOverridesRequest) {
        return mergeFrom((com.google.api.serviceusage.v1beta1.ImportAdminOverridesRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.api.serviceusage.v1beta1.ImportAdminOverridesRequest other) {
      if (other
          == com.google.api.serviceusage.v1beta1.ImportAdminOverridesRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.getForce() != false) {
        setForce(other.getForce());
      }
      if (!other.forceOnly_.isEmpty()) {
        if (forceOnly_.isEmpty()) {
          forceOnly_ = other.forceOnly_;
          bitField0_ = (bitField0_ & ~0x00000008);
        } else {
          ensureForceOnlyIsMutable();
          forceOnly_.addAll(other.forceOnly_);
        }
        onChanged();
      }
      switch (other.getSourceCase()) {
        case INLINE_SOURCE:
          {
            mergeInlineSource(other.getInlineSource());
            break;
          }
        case SOURCE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getInlineSourceFieldBuilder().getBuilder(), extensionRegistry);
                sourceCase_ = 2;
                break;
              } // case 18
            case 24:
              {
                force_ = input.readBool();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 32:
              {
                int tmpRaw = input.readEnum();
                ensureForceOnlyIsMutable();
                forceOnly_.add(tmpRaw);
                break;
              } // case 32
            case 34:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureForceOnlyIsMutable();
                  forceOnly_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int sourceCase_ = 0;
    private java.lang.Object source_;

    public SourceCase getSourceCase() {
      return SourceCase.forNumber(sourceCase_);
    }

    public Builder clearSource() {
      sourceCase_ = 0;
      source_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";

    /**
     *
     *
     * <pre>
     * The resource name of the consumer.
     *
     * An example name would be:
     * `projects/123/services/compute.googleapis.com`
     * </pre>
     *
     * <code>string parent = 1;</code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The resource name of the consumer.
     *
     * An example name would be:
     * `projects/123/services/compute.googleapis.com`
     * </pre>
     *
     * <code>string parent = 1;</code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The resource name of the consumer.
     *
     * An example name would be:
     * `projects/123/services/compute.googleapis.com`
     * </pre>
     *
     * <code>string parent = 1;</code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The resource name of the consumer.
     *
     * An example name would be:
     * `projects/123/services/compute.googleapis.com`
     * </pre>
     *
     * <code>string parent = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The resource name of the consumer.
     *
     * An example name would be:
     * `projects/123/services/compute.googleapis.com`
     * </pre>
     *
     * <code>string parent = 1;</code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.serviceusage.v1beta1.OverrideInlineSource,
            com.google.api.serviceusage.v1beta1.OverrideInlineSource.Builder,
            com.google.api.serviceusage.v1beta1.OverrideInlineSourceOrBuilder>
        inlineSourceBuilder_;

    /**
     *
     *
     * <pre>
     * The import data is specified in the request message itself
     * </pre>
     *
     * <code>.google.api.serviceusage.v1beta1.OverrideInlineSource inline_source = 2;</code>
     *
     * @return Whether the inlineSource field is set.
     */
    @java.lang.Override
    public boolean hasInlineSource() {
      return sourceCase_ == 2;
    }

    /**
     *
     *
     * <pre>
     * The import data is specified in the request message itself
     * </pre>
     *
     * <code>.google.api.serviceusage.v1beta1.OverrideInlineSource inline_source = 2;</code>
     *
     * @return The inlineSource.
     */
    @java.lang.Override
    public com.google.api.serviceusage.v1beta1.OverrideInlineSource getInlineSource() {
      if (inlineSourceBuilder_ == null) {
        if (sourceCase_ == 2) {
          return (com.google.api.serviceusage.v1beta1.OverrideInlineSource) source_;
        }
        return com.google.api.serviceusage.v1beta1.OverrideInlineSource.getDefaultInstance();
      } else {
        if (sourceCase_ == 2) {
          return inlineSourceBuilder_.getMessage();
        }
        return com.google.api.serviceusage.v1beta1.OverrideInlineSource.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The import data is specified in the request message itself
     * </pre>
     *
     * <code>.google.api.serviceusage.v1beta1.OverrideInlineSource inline_source = 2;</code>
     */
    public Builder setInlineSource(com.google.api.serviceusage.v1beta1.OverrideInlineSource value) {
      if (inlineSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        inlineSourceBuilder_.setMessage(value);
      }
      sourceCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The import data is specified in the request message itself
     * </pre>
     *
     * <code>.google.api.serviceusage.v1beta1.OverrideInlineSource inline_source = 2;</code>
     */
    public Builder setInlineSource(
        com.google.api.serviceusage.v1beta1.OverrideInlineSource.Builder builderForValue) {
      if (inlineSourceBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        inlineSourceBuilder_.setMessage(builderForValue.build());
      }
      sourceCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The import data is specified in the request message itself
     * </pre>
     *
     * <code>.google.api.serviceusage.v1beta1.OverrideInlineSource inline_source = 2;</code>
     */
    public Builder mergeInlineSource(
        com.google.api.serviceusage.v1beta1.OverrideInlineSource value) {
      if (inlineSourceBuilder_ == null) {
        if (sourceCase_ == 2
            && source_
                != com.google.api.serviceusage.v1beta1.OverrideInlineSource.getDefaultInstance()) {
          source_ =
              com.google.api.serviceusage.v1beta1.OverrideInlineSource.newBuilder(
                      (com.google.api.serviceusage.v1beta1.OverrideInlineSource) source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        if (sourceCase_ == 2) {
          inlineSourceBuilder_.mergeFrom(value);
        } else {
          inlineSourceBuilder_.setMessage(value);
        }
      }
      sourceCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The import data is specified in the request message itself
     * </pre>
     *
     * <code>.google.api.serviceusage.v1beta1.OverrideInlineSource inline_source = 2;</code>
     */
    public Builder clearInlineSource() {
      if (inlineSourceBuilder_ == null) {
        if (sourceCase_ == 2) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
      } else {
        if (sourceCase_ == 2) {
          sourceCase_ = 0;
          source_ = null;
        }
        inlineSourceBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The import data is specified in the request message itself
     * </pre>
     *
     * <code>.google.api.serviceusage.v1beta1.OverrideInlineSource inline_source = 2;</code>
     */
    public com.google.api.serviceusage.v1beta1.OverrideInlineSource.Builder
        getInlineSourceBuilder() {
      return getInlineSourceFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The import data is specified in the request message itself
     * </pre>
     *
     * <code>.google.api.serviceusage.v1beta1.OverrideInlineSource inline_source = 2;</code>
     */
    @java.lang.Override
    public com.google.api.serviceusage.v1beta1.OverrideInlineSourceOrBuilder
        getInlineSourceOrBuilder() {
      if ((sourceCase_ == 2) && (inlineSourceBuilder_ != null)) {
        return inlineSourceBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCase_ == 2) {
          return (com.google.api.serviceusage.v1beta1.OverrideInlineSource) source_;
        }
        return com.google.api.serviceusage.v1beta1.OverrideInlineSource.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The import data is specified in the request message itself
     * </pre>
     *
     * <code>.google.api.serviceusage.v1beta1.OverrideInlineSource inline_source = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.serviceusage.v1beta1.OverrideInlineSource,
            com.google.api.serviceusage.v1beta1.OverrideInlineSource.Builder,
            com.google.api.serviceusage.v1beta1.OverrideInlineSourceOrBuilder>
        getInlineSourceFieldBuilder() {
      if (inlineSourceBuilder_ == null) {
        if (!(sourceCase_ == 2)) {
          source_ = com.google.api.serviceusage.v1beta1.OverrideInlineSource.getDefaultInstance();
        }
        inlineSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.api.serviceusage.v1beta1.OverrideInlineSource,
                com.google.api.serviceusage.v1beta1.OverrideInlineSource.Builder,
                com.google.api.serviceusage.v1beta1.OverrideInlineSourceOrBuilder>(
                (com.google.api.serviceusage.v1beta1.OverrideInlineSource) source_,
                getParentForChildren(),
                isClean());
        source_ = null;
      }
      sourceCase_ = 2;
      onChanged();
      return inlineSourceBuilder_;
    }

    private boolean force_;

    /**
     *
     *
     * <pre>
     * Whether to force the creation of the quota overrides.
     * Setting the force parameter to 'true' ignores all quota safety checks that
     * would fail the request. QuotaSafetyCheck lists all such validations.
     * </pre>
     *
     * <code>bool force = 3;</code>
     *
     * @return The force.
     */
    @java.lang.Override
    public boolean getForce() {
      return force_;
    }

    /**
     *
     *
     * <pre>
     * Whether to force the creation of the quota overrides.
     * Setting the force parameter to 'true' ignores all quota safety checks that
     * would fail the request. QuotaSafetyCheck lists all such validations.
     * </pre>
     *
     * <code>bool force = 3;</code>
     *
     * @param value The force to set.
     * @return This builder for chaining.
     */
    public Builder setForce(boolean value) {

      force_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Whether to force the creation of the quota overrides.
     * Setting the force parameter to 'true' ignores all quota safety checks that
     * would fail the request. QuotaSafetyCheck lists all such validations.
     * </pre>
     *
     * <code>bool force = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearForce() {
      bitField0_ = (bitField0_ & ~0x00000004);
      force_ = false;
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Integer> forceOnly_ = java.util.Collections.emptyList();

    private void ensureForceOnlyIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        forceOnly_ = new java.util.ArrayList<java.lang.Integer>(forceOnly_);
        bitField0_ |= 0x00000008;
      }
    }

    /**
     *
     *
     * <pre>
     * The list of quota safety checks to ignore before the override mutation.
     * Unlike 'force' field that ignores all the quota safety checks, the
     * 'force_only' field ignores only the specified checks; other checks are
     * still enforced. The 'force' and 'force_only' fields cannot both be set.
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1beta1.QuotaSafetyCheck force_only = 4;</code>
     *
     * @return A list containing the forceOnly.
     */
    public java.util.List<com.google.api.serviceusage.v1beta1.QuotaSafetyCheck> getForceOnlyList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.api.serviceusage.v1beta1.QuotaSafetyCheck>(
          forceOnly_, forceOnly_converter_);
    }

    /**
     *
     *
     * <pre>
     * The list of quota safety checks to ignore before the override mutation.
     * Unlike 'force' field that ignores all the quota safety checks, the
     * 'force_only' field ignores only the specified checks; other checks are
     * still enforced. The 'force' and 'force_only' fields cannot both be set.
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1beta1.QuotaSafetyCheck force_only = 4;</code>
     *
     * @return The count of forceOnly.
     */
    public int getForceOnlyCount() {
      return forceOnly_.size();
    }

    /**
     *
     *
     * <pre>
     * The list of quota safety checks to ignore before the override mutation.
     * Unlike 'force' field that ignores all the quota safety checks, the
     * 'force_only' field ignores only the specified checks; other checks are
     * still enforced. The 'force' and 'force_only' fields cannot both be set.
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1beta1.QuotaSafetyCheck force_only = 4;</code>
     *
     * @param index The index of the element to return.
     * @return The forceOnly at the given index.
     */
    public com.google.api.serviceusage.v1beta1.QuotaSafetyCheck getForceOnly(int index) {
      return forceOnly_converter_.convert(forceOnly_.get(index));
    }

    /**
     *
     *
     * <pre>
     * The list of quota safety checks to ignore before the override mutation.
     * Unlike 'force' field that ignores all the quota safety checks, the
     * 'force_only' field ignores only the specified checks; other checks are
     * still enforced. The 'force' and 'force_only' fields cannot both be set.
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1beta1.QuotaSafetyCheck force_only = 4;</code>
     *
     * @param index The index to set the value at.
     * @param value The forceOnly to set.
     * @return This builder for chaining.
     */
    public Builder setForceOnly(
        int index, com.google.api.serviceusage.v1beta1.QuotaSafetyCheck value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureForceOnlyIsMutable();
      forceOnly_.set(index, value.getNumber());
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of quota safety checks to ignore before the override mutation.
     * Unlike 'force' field that ignores all the quota safety checks, the
     * 'force_only' field ignores only the specified checks; other checks are
     * still enforced. The 'force' and 'force_only' fields cannot both be set.
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1beta1.QuotaSafetyCheck force_only = 4;</code>
     *
     * @param value The forceOnly to add.
     * @return This builder for chaining.
     */
    public Builder addForceOnly(com.google.api.serviceusage.v1beta1.QuotaSafetyCheck value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureForceOnlyIsMutable();
      forceOnly_.add(value.getNumber());
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of quota safety checks to ignore before the override mutation.
     * Unlike 'force' field that ignores all the quota safety checks, the
     * 'force_only' field ignores only the specified checks; other checks are
     * still enforced. The 'force' and 'force_only' fields cannot both be set.
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1beta1.QuotaSafetyCheck force_only = 4;</code>
     *
     * @param values The forceOnly to add.
     * @return This builder for chaining.
     */
    public Builder addAllForceOnly(
        java.lang.Iterable<? extends com.google.api.serviceusage.v1beta1.QuotaSafetyCheck> values) {
      ensureForceOnlyIsMutable();
      for (com.google.api.serviceusage.v1beta1.QuotaSafetyCheck value : values) {
        forceOnly_.add(value.getNumber());
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of quota safety checks to ignore before the override mutation.
     * Unlike 'force' field that ignores all the quota safety checks, the
     * 'force_only' field ignores only the specified checks; other checks are
     * still enforced. The 'force' and 'force_only' fields cannot both be set.
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1beta1.QuotaSafetyCheck force_only = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearForceOnly() {
      forceOnly_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of quota safety checks to ignore before the override mutation.
     * Unlike 'force' field that ignores all the quota safety checks, the
     * 'force_only' field ignores only the specified checks; other checks are
     * still enforced. The 'force' and 'force_only' fields cannot both be set.
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1beta1.QuotaSafetyCheck force_only = 4;</code>
     *
     * @return A list containing the enum numeric values on the wire for forceOnly.
     */
    public java.util.List<java.lang.Integer> getForceOnlyValueList() {
      return java.util.Collections.unmodifiableList(forceOnly_);
    }

    /**
     *
     *
     * <pre>
     * The list of quota safety checks to ignore before the override mutation.
     * Unlike 'force' field that ignores all the quota safety checks, the
     * 'force_only' field ignores only the specified checks; other checks are
     * still enforced. The 'force' and 'force_only' fields cannot both be set.
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1beta1.QuotaSafetyCheck force_only = 4;</code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of forceOnly at the given index.
     */
    public int getForceOnlyValue(int index) {
      return forceOnly_.get(index);
    }

    /**
     *
     *
     * <pre>
     * The list of quota safety checks to ignore before the override mutation.
     * Unlike 'force' field that ignores all the quota safety checks, the
     * 'force_only' field ignores only the specified checks; other checks are
     * still enforced. The 'force' and 'force_only' fields cannot both be set.
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1beta1.QuotaSafetyCheck force_only = 4;</code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for forceOnly to set.
     * @return This builder for chaining.
     */
    public Builder setForceOnlyValue(int index, int value) {
      ensureForceOnlyIsMutable();
      forceOnly_.set(index, value);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of quota safety checks to ignore before the override mutation.
     * Unlike 'force' field that ignores all the quota safety checks, the
     * 'force_only' field ignores only the specified checks; other checks are
     * still enforced. The 'force' and 'force_only' fields cannot both be set.
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1beta1.QuotaSafetyCheck force_only = 4;</code>
     *
     * @param value The enum numeric value on the wire for forceOnly to add.
     * @return This builder for chaining.
     */
    public Builder addForceOnlyValue(int value) {
      ensureForceOnlyIsMutable();
      forceOnly_.add(value);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of quota safety checks to ignore before the override mutation.
     * Unlike 'force' field that ignores all the quota safety checks, the
     * 'force_only' field ignores only the specified checks; other checks are
     * still enforced. The 'force' and 'force_only' fields cannot both be set.
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1beta1.QuotaSafetyCheck force_only = 4;</code>
     *
     * @param values The enum numeric values on the wire for forceOnly to add.
     * @return This builder for chaining.
     */
    public Builder addAllForceOnlyValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureForceOnlyIsMutable();
      for (int value : values) {
        forceOnly_.add(value);
      }
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.api.serviceusage.v1beta1.ImportAdminOverridesRequest)
  }

  // @@protoc_insertion_point(class_scope:google.api.serviceusage.v1beta1.ImportAdminOverridesRequest)
  private static final com.google.api.serviceusage.v1beta1.ImportAdminOverridesRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.api.serviceusage.v1beta1.ImportAdminOverridesRequest();
  }

  public static com.google.api.serviceusage.v1beta1.ImportAdminOverridesRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ImportAdminOverridesRequest> PARSER =
      new com.google.protobuf.AbstractParser<ImportAdminOverridesRequest>() {
        @java.lang.Override
        public ImportAdminOverridesRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ImportAdminOverridesRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ImportAdminOverridesRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.api.serviceusage.v1beta1.ImportAdminOverridesRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
