/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/serviceusage/v1/serviceusage.proto

// Protobuf Java Version: 3.25.8
package com.google.api.serviceusage.v1;

/**
 *
 *
 * <pre>
 * Response message for the `BatchEnableServices` method.
 * This response message is assigned to the `response` field of the returned
 * Operation when that operation is done.
 * </pre>
 *
 * Protobuf type {@code google.api.serviceusage.v1.BatchEnableServicesResponse}
 */
public final class BatchEnableServicesResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.api.serviceusage.v1.BatchEnableServicesResponse)
    BatchEnableServicesResponseOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use BatchEnableServicesResponse.newBuilder() to construct.
  private BatchEnableServicesResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BatchEnableServicesResponse() {
    services_ = java.util.Collections.emptyList();
    failures_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BatchEnableServicesResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.api.serviceusage.v1.ServiceUsageProto
        .internal_static_google_api_serviceusage_v1_BatchEnableServicesResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.api.serviceusage.v1.ServiceUsageProto
        .internal_static_google_api_serviceusage_v1_BatchEnableServicesResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.api.serviceusage.v1.BatchEnableServicesResponse.class,
            com.google.api.serviceusage.v1.BatchEnableServicesResponse.Builder.class);
  }

  public interface EnableFailureOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The service id of a service that could not be enabled.
     * </pre>
     *
     * <code>string service_id = 1;</code>
     *
     * @return The serviceId.
     */
    java.lang.String getServiceId();

    /**
     *
     *
     * <pre>
     * The service id of a service that could not be enabled.
     * </pre>
     *
     * <code>string service_id = 1;</code>
     *
     * @return The bytes for serviceId.
     */
    com.google.protobuf.ByteString getServiceIdBytes();

    /**
     *
     *
     * <pre>
     * An error message describing why the service could not be enabled.
     * </pre>
     *
     * <code>string error_message = 2;</code>
     *
     * @return The errorMessage.
     */
    java.lang.String getErrorMessage();

    /**
     *
     *
     * <pre>
     * An error message describing why the service could not be enabled.
     * </pre>
     *
     * <code>string error_message = 2;</code>
     *
     * @return The bytes for errorMessage.
     */
    com.google.protobuf.ByteString getErrorMessageBytes();
  }

  /**
   *
   *
   * <pre>
   * Provides error messages for the failing services.
   * </pre>
   *
   * Protobuf type {@code google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure}
   */
  public static final class EnableFailure extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure)
      EnableFailureOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use EnableFailure.newBuilder() to construct.
    private EnableFailure(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private EnableFailure() {
      serviceId_ = "";
      errorMessage_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new EnableFailure();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.api.serviceusage.v1.ServiceUsageProto
          .internal_static_google_api_serviceusage_v1_BatchEnableServicesResponse_EnableFailure_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.serviceusage.v1.ServiceUsageProto
          .internal_static_google_api_serviceusage_v1_BatchEnableServicesResponse_EnableFailure_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure.class,
              com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure.Builder
                  .class);
    }

    public static final int SERVICE_ID_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object serviceId_ = "";

    /**
     *
     *
     * <pre>
     * The service id of a service that could not be enabled.
     * </pre>
     *
     * <code>string service_id = 1;</code>
     *
     * @return The serviceId.
     */
    @java.lang.Override
    public java.lang.String getServiceId() {
      java.lang.Object ref = serviceId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceId_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The service id of a service that could not be enabled.
     * </pre>
     *
     * <code>string service_id = 1;</code>
     *
     * @return The bytes for serviceId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getServiceIdBytes() {
      java.lang.Object ref = serviceId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ERROR_MESSAGE_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object errorMessage_ = "";

    /**
     *
     *
     * <pre>
     * An error message describing why the service could not be enabled.
     * </pre>
     *
     * <code>string error_message = 2;</code>
     *
     * @return The errorMessage.
     */
    @java.lang.Override
    public java.lang.String getErrorMessage() {
      java.lang.Object ref = errorMessage_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        errorMessage_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * An error message describing why the service could not be enabled.
     * </pre>
     *
     * <code>string error_message = 2;</code>
     *
     * @return The bytes for errorMessage.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getErrorMessageBytes() {
      java.lang.Object ref = errorMessage_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        errorMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, serviceId_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(errorMessage_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, errorMessage_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, serviceId_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(errorMessage_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, errorMessage_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure)) {
        return super.equals(obj);
      }
      com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure other =
          (com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure) obj;

      if (!getServiceId().equals(other.getServiceId())) return false;
      if (!getErrorMessage().equals(other.getErrorMessage())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SERVICE_ID_FIELD_NUMBER;
      hash = (53 * hash) + getServiceId().hashCode();
      hash = (37 * hash) + ERROR_MESSAGE_FIELD_NUMBER;
      hash = (53 * hash) + getErrorMessage().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Provides error messages for the failing services.
     * </pre>
     *
     * Protobuf type {@code google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure)
        com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailureOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.api.serviceusage.v1.ServiceUsageProto
            .internal_static_google_api_serviceusage_v1_BatchEnableServicesResponse_EnableFailure_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.api.serviceusage.v1.ServiceUsageProto
            .internal_static_google_api_serviceusage_v1_BatchEnableServicesResponse_EnableFailure_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure.class,
                com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure.Builder
                    .class);
      }

      // Construct using
      // com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        serviceId_ = "";
        errorMessage_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.api.serviceusage.v1.ServiceUsageProto
            .internal_static_google_api_serviceusage_v1_BatchEnableServicesResponse_EnableFailure_descriptor;
      }

      @java.lang.Override
      public com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure
          getDefaultInstanceForType() {
        return com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure build() {
        com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure
          buildPartial() {
        com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure result =
            new com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.serviceId_ = serviceId_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.errorMessage_ = errorMessage_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure) {
          return mergeFrom(
              (com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure other) {
        if (other
            == com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure
                .getDefaultInstance()) return this;
        if (!other.getServiceId().isEmpty()) {
          serviceId_ = other.serviceId_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getErrorMessage().isEmpty()) {
          errorMessage_ = other.errorMessage_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  serviceId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  errorMessage_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object serviceId_ = "";

      /**
       *
       *
       * <pre>
       * The service id of a service that could not be enabled.
       * </pre>
       *
       * <code>string service_id = 1;</code>
       *
       * @return The serviceId.
       */
      public java.lang.String getServiceId() {
        java.lang.Object ref = serviceId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          serviceId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The service id of a service that could not be enabled.
       * </pre>
       *
       * <code>string service_id = 1;</code>
       *
       * @return The bytes for serviceId.
       */
      public com.google.protobuf.ByteString getServiceIdBytes() {
        java.lang.Object ref = serviceId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          serviceId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The service id of a service that could not be enabled.
       * </pre>
       *
       * <code>string service_id = 1;</code>
       *
       * @param value The serviceId to set.
       * @return This builder for chaining.
       */
      public Builder setServiceId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        serviceId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The service id of a service that could not be enabled.
       * </pre>
       *
       * <code>string service_id = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearServiceId() {
        serviceId_ = getDefaultInstance().getServiceId();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The service id of a service that could not be enabled.
       * </pre>
       *
       * <code>string service_id = 1;</code>
       *
       * @param value The bytes for serviceId to set.
       * @return This builder for chaining.
       */
      public Builder setServiceIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        serviceId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object errorMessage_ = "";

      /**
       *
       *
       * <pre>
       * An error message describing why the service could not be enabled.
       * </pre>
       *
       * <code>string error_message = 2;</code>
       *
       * @return The errorMessage.
       */
      public java.lang.String getErrorMessage() {
        java.lang.Object ref = errorMessage_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          errorMessage_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * An error message describing why the service could not be enabled.
       * </pre>
       *
       * <code>string error_message = 2;</code>
       *
       * @return The bytes for errorMessage.
       */
      public com.google.protobuf.ByteString getErrorMessageBytes() {
        java.lang.Object ref = errorMessage_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          errorMessage_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * An error message describing why the service could not be enabled.
       * </pre>
       *
       * <code>string error_message = 2;</code>
       *
       * @param value The errorMessage to set.
       * @return This builder for chaining.
       */
      public Builder setErrorMessage(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        errorMessage_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * An error message describing why the service could not be enabled.
       * </pre>
       *
       * <code>string error_message = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearErrorMessage() {
        errorMessage_ = getDefaultInstance().getErrorMessage();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * An error message describing why the service could not be enabled.
       * </pre>
       *
       * <code>string error_message = 2;</code>
       *
       * @param value The bytes for errorMessage to set.
       * @return This builder for chaining.
       */
      public Builder setErrorMessageBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        errorMessage_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure)
    }

    // @@protoc_insertion_point(class_scope:google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure)
    private static final com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure();
    }

    public static com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<EnableFailure> PARSER =
        new com.google.protobuf.AbstractParser<EnableFailure>() {
          @java.lang.Override
          public EnableFailure parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<EnableFailure> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<EnableFailure> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int SERVICES_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.api.serviceusage.v1.Service> services_;

  /**
   *
   *
   * <pre>
   * The new state of the services after enabling.
   * </pre>
   *
   * <code>repeated .google.api.serviceusage.v1.Service services = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.api.serviceusage.v1.Service> getServicesList() {
    return services_;
  }

  /**
   *
   *
   * <pre>
   * The new state of the services after enabling.
   * </pre>
   *
   * <code>repeated .google.api.serviceusage.v1.Service services = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.api.serviceusage.v1.ServiceOrBuilder>
      getServicesOrBuilderList() {
    return services_;
  }

  /**
   *
   *
   * <pre>
   * The new state of the services after enabling.
   * </pre>
   *
   * <code>repeated .google.api.serviceusage.v1.Service services = 1;</code>
   */
  @java.lang.Override
  public int getServicesCount() {
    return services_.size();
  }

  /**
   *
   *
   * <pre>
   * The new state of the services after enabling.
   * </pre>
   *
   * <code>repeated .google.api.serviceusage.v1.Service services = 1;</code>
   */
  @java.lang.Override
  public com.google.api.serviceusage.v1.Service getServices(int index) {
    return services_.get(index);
  }

  /**
   *
   *
   * <pre>
   * The new state of the services after enabling.
   * </pre>
   *
   * <code>repeated .google.api.serviceusage.v1.Service services = 1;</code>
   */
  @java.lang.Override
  public com.google.api.serviceusage.v1.ServiceOrBuilder getServicesOrBuilder(int index) {
    return services_.get(index);
  }

  public static final int FAILURES_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure>
      failures_;

  /**
   *
   *
   * <pre>
   * If allow_partial_success is true, and one or more services could not be
   * enabled, this field contains the details about each failure.
   * </pre>
   *
   * <code>
   * repeated .google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure failures = 2;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure>
      getFailuresList() {
    return failures_;
  }

  /**
   *
   *
   * <pre>
   * If allow_partial_success is true, and one or more services could not be
   * enabled, this field contains the details about each failure.
   * </pre>
   *
   * <code>
   * repeated .google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure failures = 2;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailureOrBuilder>
      getFailuresOrBuilderList() {
    return failures_;
  }

  /**
   *
   *
   * <pre>
   * If allow_partial_success is true, and one or more services could not be
   * enabled, this field contains the details about each failure.
   * </pre>
   *
   * <code>
   * repeated .google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure failures = 2;
   * </code>
   */
  @java.lang.Override
  public int getFailuresCount() {
    return failures_.size();
  }

  /**
   *
   *
   * <pre>
   * If allow_partial_success is true, and one or more services could not be
   * enabled, this field contains the details about each failure.
   * </pre>
   *
   * <code>
   * repeated .google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure failures = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure getFailures(
      int index) {
    return failures_.get(index);
  }

  /**
   *
   *
   * <pre>
   * If allow_partial_success is true, and one or more services could not be
   * enabled, this field contains the details about each failure.
   * </pre>
   *
   * <code>
   * repeated .google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure failures = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailureOrBuilder
      getFailuresOrBuilder(int index) {
    return failures_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < services_.size(); i++) {
      output.writeMessage(1, services_.get(i));
    }
    for (int i = 0; i < failures_.size(); i++) {
      output.writeMessage(2, failures_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < services_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, services_.get(i));
    }
    for (int i = 0; i < failures_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, failures_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.api.serviceusage.v1.BatchEnableServicesResponse)) {
      return super.equals(obj);
    }
    com.google.api.serviceusage.v1.BatchEnableServicesResponse other =
        (com.google.api.serviceusage.v1.BatchEnableServicesResponse) obj;

    if (!getServicesList().equals(other.getServicesList())) return false;
    if (!getFailuresList().equals(other.getFailuresList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getServicesCount() > 0) {
      hash = (37 * hash) + SERVICES_FIELD_NUMBER;
      hash = (53 * hash) + getServicesList().hashCode();
    }
    if (getFailuresCount() > 0) {
      hash = (37 * hash) + FAILURES_FIELD_NUMBER;
      hash = (53 * hash) + getFailuresList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.api.serviceusage.v1.BatchEnableServicesResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.serviceusage.v1.BatchEnableServicesResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.serviceusage.v1.BatchEnableServicesResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.serviceusage.v1.BatchEnableServicesResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.serviceusage.v1.BatchEnableServicesResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.serviceusage.v1.BatchEnableServicesResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.serviceusage.v1.BatchEnableServicesResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.api.serviceusage.v1.BatchEnableServicesResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.serviceusage.v1.BatchEnableServicesResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.api.serviceusage.v1.BatchEnableServicesResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.serviceusage.v1.BatchEnableServicesResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.api.serviceusage.v1.BatchEnableServicesResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.api.serviceusage.v1.BatchEnableServicesResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Response message for the `BatchEnableServices` method.
   * This response message is assigned to the `response` field of the returned
   * Operation when that operation is done.
   * </pre>
   *
   * Protobuf type {@code google.api.serviceusage.v1.BatchEnableServicesResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.api.serviceusage.v1.BatchEnableServicesResponse)
      com.google.api.serviceusage.v1.BatchEnableServicesResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.api.serviceusage.v1.ServiceUsageProto
          .internal_static_google_api_serviceusage_v1_BatchEnableServicesResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.serviceusage.v1.ServiceUsageProto
          .internal_static_google_api_serviceusage_v1_BatchEnableServicesResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.api.serviceusage.v1.BatchEnableServicesResponse.class,
              com.google.api.serviceusage.v1.BatchEnableServicesResponse.Builder.class);
    }

    // Construct using com.google.api.serviceusage.v1.BatchEnableServicesResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (servicesBuilder_ == null) {
        services_ = java.util.Collections.emptyList();
      } else {
        services_ = null;
        servicesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      if (failuresBuilder_ == null) {
        failures_ = java.util.Collections.emptyList();
      } else {
        failures_ = null;
        failuresBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.api.serviceusage.v1.ServiceUsageProto
          .internal_static_google_api_serviceusage_v1_BatchEnableServicesResponse_descriptor;
    }

    @java.lang.Override
    public com.google.api.serviceusage.v1.BatchEnableServicesResponse getDefaultInstanceForType() {
      return com.google.api.serviceusage.v1.BatchEnableServicesResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.api.serviceusage.v1.BatchEnableServicesResponse build() {
      com.google.api.serviceusage.v1.BatchEnableServicesResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.api.serviceusage.v1.BatchEnableServicesResponse buildPartial() {
      com.google.api.serviceusage.v1.BatchEnableServicesResponse result =
          new com.google.api.serviceusage.v1.BatchEnableServicesResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.api.serviceusage.v1.BatchEnableServicesResponse result) {
      if (servicesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          services_ = java.util.Collections.unmodifiableList(services_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.services_ = services_;
      } else {
        result.services_ = servicesBuilder_.build();
      }
      if (failuresBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          failures_ = java.util.Collections.unmodifiableList(failures_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.failures_ = failures_;
      } else {
        result.failures_ = failuresBuilder_.build();
      }
    }

    private void buildPartial0(com.google.api.serviceusage.v1.BatchEnableServicesResponse result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.api.serviceusage.v1.BatchEnableServicesResponse) {
        return mergeFrom((com.google.api.serviceusage.v1.BatchEnableServicesResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.api.serviceusage.v1.BatchEnableServicesResponse other) {
      if (other == com.google.api.serviceusage.v1.BatchEnableServicesResponse.getDefaultInstance())
        return this;
      if (servicesBuilder_ == null) {
        if (!other.services_.isEmpty()) {
          if (services_.isEmpty()) {
            services_ = other.services_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureServicesIsMutable();
            services_.addAll(other.services_);
          }
          onChanged();
        }
      } else {
        if (!other.services_.isEmpty()) {
          if (servicesBuilder_.isEmpty()) {
            servicesBuilder_.dispose();
            servicesBuilder_ = null;
            services_ = other.services_;
            bitField0_ = (bitField0_ & ~0x00000001);
            servicesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getServicesFieldBuilder()
                    : null;
          } else {
            servicesBuilder_.addAllMessages(other.services_);
          }
        }
      }
      if (failuresBuilder_ == null) {
        if (!other.failures_.isEmpty()) {
          if (failures_.isEmpty()) {
            failures_ = other.failures_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureFailuresIsMutable();
            failures_.addAll(other.failures_);
          }
          onChanged();
        }
      } else {
        if (!other.failures_.isEmpty()) {
          if (failuresBuilder_.isEmpty()) {
            failuresBuilder_.dispose();
            failuresBuilder_ = null;
            failures_ = other.failures_;
            bitField0_ = (bitField0_ & ~0x00000002);
            failuresBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFailuresFieldBuilder()
                    : null;
          } else {
            failuresBuilder_.addAllMessages(other.failures_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.api.serviceusage.v1.Service m =
                    input.readMessage(
                        com.google.api.serviceusage.v1.Service.parser(), extensionRegistry);
                if (servicesBuilder_ == null) {
                  ensureServicesIsMutable();
                  services_.add(m);
                } else {
                  servicesBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure m =
                    input.readMessage(
                        com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure
                            .parser(),
                        extensionRegistry);
                if (failuresBuilder_ == null) {
                  ensureFailuresIsMutable();
                  failures_.add(m);
                } else {
                  failuresBuilder_.addMessage(m);
                }
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.api.serviceusage.v1.Service> services_ =
        java.util.Collections.emptyList();

    private void ensureServicesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        services_ = new java.util.ArrayList<com.google.api.serviceusage.v1.Service>(services_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.serviceusage.v1.Service,
            com.google.api.serviceusage.v1.Service.Builder,
            com.google.api.serviceusage.v1.ServiceOrBuilder>
        servicesBuilder_;

    /**
     *
     *
     * <pre>
     * The new state of the services after enabling.
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1.Service services = 1;</code>
     */
    public java.util.List<com.google.api.serviceusage.v1.Service> getServicesList() {
      if (servicesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(services_);
      } else {
        return servicesBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * The new state of the services after enabling.
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1.Service services = 1;</code>
     */
    public int getServicesCount() {
      if (servicesBuilder_ == null) {
        return services_.size();
      } else {
        return servicesBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * The new state of the services after enabling.
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1.Service services = 1;</code>
     */
    public com.google.api.serviceusage.v1.Service getServices(int index) {
      if (servicesBuilder_ == null) {
        return services_.get(index);
      } else {
        return servicesBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * The new state of the services after enabling.
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1.Service services = 1;</code>
     */
    public Builder setServices(int index, com.google.api.serviceusage.v1.Service value) {
      if (servicesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureServicesIsMutable();
        services_.set(index, value);
        onChanged();
      } else {
        servicesBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The new state of the services after enabling.
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1.Service services = 1;</code>
     */
    public Builder setServices(
        int index, com.google.api.serviceusage.v1.Service.Builder builderForValue) {
      if (servicesBuilder_ == null) {
        ensureServicesIsMutable();
        services_.set(index, builderForValue.build());
        onChanged();
      } else {
        servicesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The new state of the services after enabling.
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1.Service services = 1;</code>
     */
    public Builder addServices(com.google.api.serviceusage.v1.Service value) {
      if (servicesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureServicesIsMutable();
        services_.add(value);
        onChanged();
      } else {
        servicesBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The new state of the services after enabling.
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1.Service services = 1;</code>
     */
    public Builder addServices(int index, com.google.api.serviceusage.v1.Service value) {
      if (servicesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureServicesIsMutable();
        services_.add(index, value);
        onChanged();
      } else {
        servicesBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The new state of the services after enabling.
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1.Service services = 1;</code>
     */
    public Builder addServices(com.google.api.serviceusage.v1.Service.Builder builderForValue) {
      if (servicesBuilder_ == null) {
        ensureServicesIsMutable();
        services_.add(builderForValue.build());
        onChanged();
      } else {
        servicesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The new state of the services after enabling.
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1.Service services = 1;</code>
     */
    public Builder addServices(
        int index, com.google.api.serviceusage.v1.Service.Builder builderForValue) {
      if (servicesBuilder_ == null) {
        ensureServicesIsMutable();
        services_.add(index, builderForValue.build());
        onChanged();
      } else {
        servicesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The new state of the services after enabling.
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1.Service services = 1;</code>
     */
    public Builder addAllServices(
        java.lang.Iterable<? extends com.google.api.serviceusage.v1.Service> values) {
      if (servicesBuilder_ == null) {
        ensureServicesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, services_);
        onChanged();
      } else {
        servicesBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The new state of the services after enabling.
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1.Service services = 1;</code>
     */
    public Builder clearServices() {
      if (servicesBuilder_ == null) {
        services_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        servicesBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The new state of the services after enabling.
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1.Service services = 1;</code>
     */
    public Builder removeServices(int index) {
      if (servicesBuilder_ == null) {
        ensureServicesIsMutable();
        services_.remove(index);
        onChanged();
      } else {
        servicesBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The new state of the services after enabling.
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1.Service services = 1;</code>
     */
    public com.google.api.serviceusage.v1.Service.Builder getServicesBuilder(int index) {
      return getServicesFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * The new state of the services after enabling.
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1.Service services = 1;</code>
     */
    public com.google.api.serviceusage.v1.ServiceOrBuilder getServicesOrBuilder(int index) {
      if (servicesBuilder_ == null) {
        return services_.get(index);
      } else {
        return servicesBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * The new state of the services after enabling.
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1.Service services = 1;</code>
     */
    public java.util.List<? extends com.google.api.serviceusage.v1.ServiceOrBuilder>
        getServicesOrBuilderList() {
      if (servicesBuilder_ != null) {
        return servicesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(services_);
      }
    }

    /**
     *
     *
     * <pre>
     * The new state of the services after enabling.
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1.Service services = 1;</code>
     */
    public com.google.api.serviceusage.v1.Service.Builder addServicesBuilder() {
      return getServicesFieldBuilder()
          .addBuilder(com.google.api.serviceusage.v1.Service.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * The new state of the services after enabling.
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1.Service services = 1;</code>
     */
    public com.google.api.serviceusage.v1.Service.Builder addServicesBuilder(int index) {
      return getServicesFieldBuilder()
          .addBuilder(index, com.google.api.serviceusage.v1.Service.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * The new state of the services after enabling.
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1.Service services = 1;</code>
     */
    public java.util.List<com.google.api.serviceusage.v1.Service.Builder> getServicesBuilderList() {
      return getServicesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.serviceusage.v1.Service,
            com.google.api.serviceusage.v1.Service.Builder,
            com.google.api.serviceusage.v1.ServiceOrBuilder>
        getServicesFieldBuilder() {
      if (servicesBuilder_ == null) {
        servicesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.api.serviceusage.v1.Service,
                com.google.api.serviceusage.v1.Service.Builder,
                com.google.api.serviceusage.v1.ServiceOrBuilder>(
                services_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        services_ = null;
      }
      return servicesBuilder_;
    }

    private java.util.List<com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure>
        failures_ = java.util.Collections.emptyList();

    private void ensureFailuresIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        failures_ =
            new java.util.ArrayList<
                com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure>(
                failures_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure,
            com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure.Builder,
            com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailureOrBuilder>
        failuresBuilder_;

    /**
     *
     *
     * <pre>
     * If allow_partial_success is true, and one or more services could not be
     * enabled, this field contains the details about each failure.
     * </pre>
     *
     * <code>
     * repeated .google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure failures = 2;
     * </code>
     */
    public java.util.List<com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure>
        getFailuresList() {
      if (failuresBuilder_ == null) {
        return java.util.Collections.unmodifiableList(failures_);
      } else {
        return failuresBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * If allow_partial_success is true, and one or more services could not be
     * enabled, this field contains the details about each failure.
     * </pre>
     *
     * <code>
     * repeated .google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure failures = 2;
     * </code>
     */
    public int getFailuresCount() {
      if (failuresBuilder_ == null) {
        return failures_.size();
      } else {
        return failuresBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * If allow_partial_success is true, and one or more services could not be
     * enabled, this field contains the details about each failure.
     * </pre>
     *
     * <code>
     * repeated .google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure failures = 2;
     * </code>
     */
    public com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure getFailures(
        int index) {
      if (failuresBuilder_ == null) {
        return failures_.get(index);
      } else {
        return failuresBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * If allow_partial_success is true, and one or more services could not be
     * enabled, this field contains the details about each failure.
     * </pre>
     *
     * <code>
     * repeated .google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure failures = 2;
     * </code>
     */
    public Builder setFailures(
        int index, com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure value) {
      if (failuresBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFailuresIsMutable();
        failures_.set(index, value);
        onChanged();
      } else {
        failuresBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * If allow_partial_success is true, and one or more services could not be
     * enabled, this field contains the details about each failure.
     * </pre>
     *
     * <code>
     * repeated .google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure failures = 2;
     * </code>
     */
    public Builder setFailures(
        int index,
        com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure.Builder
            builderForValue) {
      if (failuresBuilder_ == null) {
        ensureFailuresIsMutable();
        failures_.set(index, builderForValue.build());
        onChanged();
      } else {
        failuresBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * If allow_partial_success is true, and one or more services could not be
     * enabled, this field contains the details about each failure.
     * </pre>
     *
     * <code>
     * repeated .google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure failures = 2;
     * </code>
     */
    public Builder addFailures(
        com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure value) {
      if (failuresBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFailuresIsMutable();
        failures_.add(value);
        onChanged();
      } else {
        failuresBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * If allow_partial_success is true, and one or more services could not be
     * enabled, this field contains the details about each failure.
     * </pre>
     *
     * <code>
     * repeated .google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure failures = 2;
     * </code>
     */
    public Builder addFailures(
        int index, com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure value) {
      if (failuresBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFailuresIsMutable();
        failures_.add(index, value);
        onChanged();
      } else {
        failuresBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * If allow_partial_success is true, and one or more services could not be
     * enabled, this field contains the details about each failure.
     * </pre>
     *
     * <code>
     * repeated .google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure failures = 2;
     * </code>
     */
    public Builder addFailures(
        com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure.Builder
            builderForValue) {
      if (failuresBuilder_ == null) {
        ensureFailuresIsMutable();
        failures_.add(builderForValue.build());
        onChanged();
      } else {
        failuresBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * If allow_partial_success is true, and one or more services could not be
     * enabled, this field contains the details about each failure.
     * </pre>
     *
     * <code>
     * repeated .google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure failures = 2;
     * </code>
     */
    public Builder addFailures(
        int index,
        com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure.Builder
            builderForValue) {
      if (failuresBuilder_ == null) {
        ensureFailuresIsMutable();
        failures_.add(index, builderForValue.build());
        onChanged();
      } else {
        failuresBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * If allow_partial_success is true, and one or more services could not be
     * enabled, this field contains the details about each failure.
     * </pre>
     *
     * <code>
     * repeated .google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure failures = 2;
     * </code>
     */
    public Builder addAllFailures(
        java.lang.Iterable<
                ? extends com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure>
            values) {
      if (failuresBuilder_ == null) {
        ensureFailuresIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, failures_);
        onChanged();
      } else {
        failuresBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * If allow_partial_success is true, and one or more services could not be
     * enabled, this field contains the details about each failure.
     * </pre>
     *
     * <code>
     * repeated .google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure failures = 2;
     * </code>
     */
    public Builder clearFailures() {
      if (failuresBuilder_ == null) {
        failures_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        failuresBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * If allow_partial_success is true, and one or more services could not be
     * enabled, this field contains the details about each failure.
     * </pre>
     *
     * <code>
     * repeated .google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure failures = 2;
     * </code>
     */
    public Builder removeFailures(int index) {
      if (failuresBuilder_ == null) {
        ensureFailuresIsMutable();
        failures_.remove(index);
        onChanged();
      } else {
        failuresBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * If allow_partial_success is true, and one or more services could not be
     * enabled, this field contains the details about each failure.
     * </pre>
     *
     * <code>
     * repeated .google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure failures = 2;
     * </code>
     */
    public com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure.Builder
        getFailuresBuilder(int index) {
      return getFailuresFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * If allow_partial_success is true, and one or more services could not be
     * enabled, this field contains the details about each failure.
     * </pre>
     *
     * <code>
     * repeated .google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure failures = 2;
     * </code>
     */
    public com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailureOrBuilder
        getFailuresOrBuilder(int index) {
      if (failuresBuilder_ == null) {
        return failures_.get(index);
      } else {
        return failuresBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * If allow_partial_success is true, and one or more services could not be
     * enabled, this field contains the details about each failure.
     * </pre>
     *
     * <code>
     * repeated .google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure failures = 2;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailureOrBuilder>
        getFailuresOrBuilderList() {
      if (failuresBuilder_ != null) {
        return failuresBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(failures_);
      }
    }

    /**
     *
     *
     * <pre>
     * If allow_partial_success is true, and one or more services could not be
     * enabled, this field contains the details about each failure.
     * </pre>
     *
     * <code>
     * repeated .google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure failures = 2;
     * </code>
     */
    public com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure.Builder
        addFailuresBuilder() {
      return getFailuresFieldBuilder()
          .addBuilder(
              com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * If allow_partial_success is true, and one or more services could not be
     * enabled, this field contains the details about each failure.
     * </pre>
     *
     * <code>
     * repeated .google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure failures = 2;
     * </code>
     */
    public com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure.Builder
        addFailuresBuilder(int index) {
      return getFailuresFieldBuilder()
          .addBuilder(
              index,
              com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * If allow_partial_success is true, and one or more services could not be
     * enabled, this field contains the details about each failure.
     * </pre>
     *
     * <code>
     * repeated .google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure failures = 2;
     * </code>
     */
    public java.util.List<
            com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure.Builder>
        getFailuresBuilderList() {
      return getFailuresFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure,
            com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure.Builder,
            com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailureOrBuilder>
        getFailuresFieldBuilder() {
      if (failuresBuilder_ == null) {
        failuresBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure,
                com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure.Builder,
                com.google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailureOrBuilder>(
                failures_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        failures_ = null;
      }
      return failuresBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.api.serviceusage.v1.BatchEnableServicesResponse)
  }

  // @@protoc_insertion_point(class_scope:google.api.serviceusage.v1.BatchEnableServicesResponse)
  private static final com.google.api.serviceusage.v1.BatchEnableServicesResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.api.serviceusage.v1.BatchEnableServicesResponse();
  }

  public static com.google.api.serviceusage.v1.BatchEnableServicesResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BatchEnableServicesResponse> PARSER =
      new com.google.protobuf.AbstractParser<BatchEnableServicesResponse>() {
        @java.lang.Override
        public BatchEnableServicesResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BatchEnableServicesResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BatchEnableServicesResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.api.serviceusage.v1.BatchEnableServicesResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
