/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.securityposture.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PostureDeploymentName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_LOCATION_POSTURE_DEPLOYMENT = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/locations/{location}/postureDeployments/{posture_deployment}");
    private volatile Map<String, String> fieldValuesMap;
    private final String organization;
    private final String location;
    private final String postureDeployment;

    @Deprecated
    protected PostureDeploymentName() {
        this.organization = null;
        this.location = null;
        this.postureDeployment = null;
    }

    private PostureDeploymentName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.postureDeployment = (String)Preconditions.checkNotNull((Object)builder.getPostureDeployment());
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getLocation() {
        return this.location;
    }

    public String getPostureDeployment() {
        return this.postureDeployment;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static PostureDeploymentName of(String organization, String location, String postureDeployment) {
        return PostureDeploymentName.newBuilder().setOrganization(organization).setLocation(location).setPostureDeployment(postureDeployment).build();
    }

    public static String format(String organization, String location, String postureDeployment) {
        return PostureDeploymentName.newBuilder().setOrganization(organization).setLocation(location).setPostureDeployment(postureDeployment).build().toString();
    }

    public static PostureDeploymentName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = ORGANIZATION_LOCATION_POSTURE_DEPLOYMENT.validatedMatch(formattedString, "PostureDeploymentName.parse: formattedString not in valid format");
        return PostureDeploymentName.of((String)matchMap.get("organization"), (String)matchMap.get("location"), (String)matchMap.get("posture_deployment"));
    }

    public static List<PostureDeploymentName> parseList(List<String> formattedStrings) {
        ArrayList<PostureDeploymentName> list = new ArrayList<PostureDeploymentName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(PostureDeploymentName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<PostureDeploymentName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (PostureDeploymentName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_LOCATION_POSTURE_DEPLOYMENT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            PostureDeploymentName postureDeploymentName = this;
            synchronized (postureDeploymentName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.postureDeployment != null) {
                        fieldMapBuilder.put((Object)"posture_deployment", (Object)this.postureDeployment);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return ORGANIZATION_LOCATION_POSTURE_DEPLOYMENT.instantiate(new String[]{"organization", this.organization, "location", this.location, "posture_deployment", this.postureDeployment});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            PostureDeploymentName that = (PostureDeploymentName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.location, that.location) && Objects.equals(this.postureDeployment, that.postureDeployment);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.postureDeployment);
    }

    public static class Builder {
        private String organization;
        private String location;
        private String postureDeployment;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public String getPostureDeployment() {
            return this.postureDeployment;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setPostureDeployment(String postureDeployment) {
            this.postureDeployment = postureDeployment;
            return this;
        }

        private Builder(PostureDeploymentName postureDeploymentName) {
            this.organization = postureDeploymentName.organization;
            this.location = postureDeploymentName.location;
            this.postureDeployment = postureDeploymentName.postureDeployment;
        }

        public PostureDeploymentName build() {
            return new PostureDeploymentName(this);
        }
    }
}

