/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.securitycentermanagement.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class EffectiveSecurityHealthAnalyticsCustomModuleName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_LOCATION_EFFECTIVE_SECURITY_HEALTH_ANALYTICS_CUSTOM_MODULE = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/locations/{location}/effectiveSecurityHealthAnalyticsCustomModules/{effective_security_health_analytics_custom_module}");
    private static final PathTemplate PROJECT_LOCATION_EFFECTIVE_SECURITY_HEALTH_ANALYTICS_CUSTOM_MODULE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/effectiveSecurityHealthAnalyticsCustomModules/{effective_security_health_analytics_custom_module}");
    private static final PathTemplate FOLDER_LOCATION_EFFECTIVE_SECURITY_HEALTH_ANALYTICS_CUSTOM_MODULE = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/locations/{location}/effectiveSecurityHealthAnalyticsCustomModules/{effective_security_health_analytics_custom_module}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String organization;
    private final String location;
    private final String effectiveSecurityHealthAnalyticsCustomModule;
    private final String project;
    private final String folder;

    @Deprecated
    protected EffectiveSecurityHealthAnalyticsCustomModuleName() {
        this.organization = null;
        this.location = null;
        this.effectiveSecurityHealthAnalyticsCustomModule = null;
        this.project = null;
        this.folder = null;
    }

    private EffectiveSecurityHealthAnalyticsCustomModuleName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.effectiveSecurityHealthAnalyticsCustomModule = (String)Preconditions.checkNotNull((Object)builder.getEffectiveSecurityHealthAnalyticsCustomModule());
        this.project = null;
        this.folder = null;
        this.pathTemplate = ORGANIZATION_LOCATION_EFFECTIVE_SECURITY_HEALTH_ANALYTICS_CUSTOM_MODULE;
    }

    private EffectiveSecurityHealthAnalyticsCustomModuleName(ProjectLocationEffectiveSecurityHealthAnalyticsCustomModuleBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.effectiveSecurityHealthAnalyticsCustomModule = (String)Preconditions.checkNotNull((Object)builder.getEffectiveSecurityHealthAnalyticsCustomModule());
        this.organization = null;
        this.folder = null;
        this.pathTemplate = PROJECT_LOCATION_EFFECTIVE_SECURITY_HEALTH_ANALYTICS_CUSTOM_MODULE;
    }

    private EffectiveSecurityHealthAnalyticsCustomModuleName(FolderLocationEffectiveSecurityHealthAnalyticsCustomModuleBuilder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.effectiveSecurityHealthAnalyticsCustomModule = (String)Preconditions.checkNotNull((Object)builder.getEffectiveSecurityHealthAnalyticsCustomModule());
        this.organization = null;
        this.project = null;
        this.pathTemplate = FOLDER_LOCATION_EFFECTIVE_SECURITY_HEALTH_ANALYTICS_CUSTOM_MODULE;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getLocation() {
        return this.location;
    }

    public String getEffectiveSecurityHealthAnalyticsCustomModule() {
        return this.effectiveSecurityHealthAnalyticsCustomModule;
    }

    public String getProject() {
        return this.project;
    }

    public String getFolder() {
        return this.folder;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newOrganizationLocationEffectiveSecurityHealthAnalyticsCustomModuleBuilder() {
        return new Builder();
    }

    public static ProjectLocationEffectiveSecurityHealthAnalyticsCustomModuleBuilder newProjectLocationEffectiveSecurityHealthAnalyticsCustomModuleBuilder() {
        return new ProjectLocationEffectiveSecurityHealthAnalyticsCustomModuleBuilder();
    }

    public static FolderLocationEffectiveSecurityHealthAnalyticsCustomModuleBuilder newFolderLocationEffectiveSecurityHealthAnalyticsCustomModuleBuilder() {
        return new FolderLocationEffectiveSecurityHealthAnalyticsCustomModuleBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static EffectiveSecurityHealthAnalyticsCustomModuleName of(String organization, String location, String effectiveSecurityHealthAnalyticsCustomModule) {
        return EffectiveSecurityHealthAnalyticsCustomModuleName.newBuilder().setOrganization(organization).setLocation(location).setEffectiveSecurityHealthAnalyticsCustomModule(effectiveSecurityHealthAnalyticsCustomModule).build();
    }

    public static EffectiveSecurityHealthAnalyticsCustomModuleName ofOrganizationLocationEffectiveSecurityHealthAnalyticsCustomModuleName(String organization, String location, String effectiveSecurityHealthAnalyticsCustomModule) {
        return EffectiveSecurityHealthAnalyticsCustomModuleName.newBuilder().setOrganization(organization).setLocation(location).setEffectiveSecurityHealthAnalyticsCustomModule(effectiveSecurityHealthAnalyticsCustomModule).build();
    }

    public static EffectiveSecurityHealthAnalyticsCustomModuleName ofProjectLocationEffectiveSecurityHealthAnalyticsCustomModuleName(String project, String location, String effectiveSecurityHealthAnalyticsCustomModule) {
        return EffectiveSecurityHealthAnalyticsCustomModuleName.newProjectLocationEffectiveSecurityHealthAnalyticsCustomModuleBuilder().setProject(project).setLocation(location).setEffectiveSecurityHealthAnalyticsCustomModule(effectiveSecurityHealthAnalyticsCustomModule).build();
    }

    public static EffectiveSecurityHealthAnalyticsCustomModuleName ofFolderLocationEffectiveSecurityHealthAnalyticsCustomModuleName(String folder, String location, String effectiveSecurityHealthAnalyticsCustomModule) {
        return EffectiveSecurityHealthAnalyticsCustomModuleName.newFolderLocationEffectiveSecurityHealthAnalyticsCustomModuleBuilder().setFolder(folder).setLocation(location).setEffectiveSecurityHealthAnalyticsCustomModule(effectiveSecurityHealthAnalyticsCustomModule).build();
    }

    public static String format(String organization, String location, String effectiveSecurityHealthAnalyticsCustomModule) {
        return EffectiveSecurityHealthAnalyticsCustomModuleName.newBuilder().setOrganization(organization).setLocation(location).setEffectiveSecurityHealthAnalyticsCustomModule(effectiveSecurityHealthAnalyticsCustomModule).build().toString();
    }

    public static String formatOrganizationLocationEffectiveSecurityHealthAnalyticsCustomModuleName(String organization, String location, String effectiveSecurityHealthAnalyticsCustomModule) {
        return EffectiveSecurityHealthAnalyticsCustomModuleName.newBuilder().setOrganization(organization).setLocation(location).setEffectiveSecurityHealthAnalyticsCustomModule(effectiveSecurityHealthAnalyticsCustomModule).build().toString();
    }

    public static String formatProjectLocationEffectiveSecurityHealthAnalyticsCustomModuleName(String project, String location, String effectiveSecurityHealthAnalyticsCustomModule) {
        return EffectiveSecurityHealthAnalyticsCustomModuleName.newProjectLocationEffectiveSecurityHealthAnalyticsCustomModuleBuilder().setProject(project).setLocation(location).setEffectiveSecurityHealthAnalyticsCustomModule(effectiveSecurityHealthAnalyticsCustomModule).build().toString();
    }

    public static String formatFolderLocationEffectiveSecurityHealthAnalyticsCustomModuleName(String folder, String location, String effectiveSecurityHealthAnalyticsCustomModule) {
        return EffectiveSecurityHealthAnalyticsCustomModuleName.newFolderLocationEffectiveSecurityHealthAnalyticsCustomModuleBuilder().setFolder(folder).setLocation(location).setEffectiveSecurityHealthAnalyticsCustomModule(effectiveSecurityHealthAnalyticsCustomModule).build().toString();
    }

    public static EffectiveSecurityHealthAnalyticsCustomModuleName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (ORGANIZATION_LOCATION_EFFECTIVE_SECURITY_HEALTH_ANALYTICS_CUSTOM_MODULE.matches(formattedString)) {
            Map matchMap = ORGANIZATION_LOCATION_EFFECTIVE_SECURITY_HEALTH_ANALYTICS_CUSTOM_MODULE.match(formattedString);
            return EffectiveSecurityHealthAnalyticsCustomModuleName.ofOrganizationLocationEffectiveSecurityHealthAnalyticsCustomModuleName((String)matchMap.get("organization"), (String)matchMap.get("location"), (String)matchMap.get("effective_security_health_analytics_custom_module"));
        }
        if (PROJECT_LOCATION_EFFECTIVE_SECURITY_HEALTH_ANALYTICS_CUSTOM_MODULE.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_EFFECTIVE_SECURITY_HEALTH_ANALYTICS_CUSTOM_MODULE.match(formattedString);
            return EffectiveSecurityHealthAnalyticsCustomModuleName.ofProjectLocationEffectiveSecurityHealthAnalyticsCustomModuleName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("effective_security_health_analytics_custom_module"));
        }
        if (FOLDER_LOCATION_EFFECTIVE_SECURITY_HEALTH_ANALYTICS_CUSTOM_MODULE.matches(formattedString)) {
            Map matchMap = FOLDER_LOCATION_EFFECTIVE_SECURITY_HEALTH_ANALYTICS_CUSTOM_MODULE.match(formattedString);
            return EffectiveSecurityHealthAnalyticsCustomModuleName.ofFolderLocationEffectiveSecurityHealthAnalyticsCustomModuleName((String)matchMap.get("folder"), (String)matchMap.get("location"), (String)matchMap.get("effective_security_health_analytics_custom_module"));
        }
        throw new ValidationException("EffectiveSecurityHealthAnalyticsCustomModuleName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<EffectiveSecurityHealthAnalyticsCustomModuleName> parseList(List<String> formattedStrings) {
        ArrayList<EffectiveSecurityHealthAnalyticsCustomModuleName> list = new ArrayList<EffectiveSecurityHealthAnalyticsCustomModuleName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(EffectiveSecurityHealthAnalyticsCustomModuleName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<EffectiveSecurityHealthAnalyticsCustomModuleName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (EffectiveSecurityHealthAnalyticsCustomModuleName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_LOCATION_EFFECTIVE_SECURITY_HEALTH_ANALYTICS_CUSTOM_MODULE.matches(formattedString) || PROJECT_LOCATION_EFFECTIVE_SECURITY_HEALTH_ANALYTICS_CUSTOM_MODULE.matches(formattedString) || FOLDER_LOCATION_EFFECTIVE_SECURITY_HEALTH_ANALYTICS_CUSTOM_MODULE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            EffectiveSecurityHealthAnalyticsCustomModuleName effectiveSecurityHealthAnalyticsCustomModuleName = this;
            synchronized (effectiveSecurityHealthAnalyticsCustomModuleName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.effectiveSecurityHealthAnalyticsCustomModule != null) {
                        fieldMapBuilder.put((Object)"effective_security_health_analytics_custom_module", (Object)this.effectiveSecurityHealthAnalyticsCustomModule);
                    }
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put((Object)"folder", (Object)this.folder);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            EffectiveSecurityHealthAnalyticsCustomModuleName that = (EffectiveSecurityHealthAnalyticsCustomModuleName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.location, that.location) && Objects.equals(this.effectiveSecurityHealthAnalyticsCustomModule, that.effectiveSecurityHealthAnalyticsCustomModule) && Objects.equals(this.project, that.project) && Objects.equals(this.folder, that.folder);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.effectiveSecurityHealthAnalyticsCustomModule);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        return h ^= Objects.hashCode(this.folder);
    }

    public static class FolderLocationEffectiveSecurityHealthAnalyticsCustomModuleBuilder {
        private String folder;
        private String location;
        private String effectiveSecurityHealthAnalyticsCustomModule;

        protected FolderLocationEffectiveSecurityHealthAnalyticsCustomModuleBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getLocation() {
            return this.location;
        }

        public String getEffectiveSecurityHealthAnalyticsCustomModule() {
            return this.effectiveSecurityHealthAnalyticsCustomModule;
        }

        public FolderLocationEffectiveSecurityHealthAnalyticsCustomModuleBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderLocationEffectiveSecurityHealthAnalyticsCustomModuleBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public FolderLocationEffectiveSecurityHealthAnalyticsCustomModuleBuilder setEffectiveSecurityHealthAnalyticsCustomModule(String effectiveSecurityHealthAnalyticsCustomModule) {
            this.effectiveSecurityHealthAnalyticsCustomModule = effectiveSecurityHealthAnalyticsCustomModule;
            return this;
        }

        public EffectiveSecurityHealthAnalyticsCustomModuleName build() {
            return new EffectiveSecurityHealthAnalyticsCustomModuleName(this);
        }
    }

    public static class ProjectLocationEffectiveSecurityHealthAnalyticsCustomModuleBuilder {
        private String project;
        private String location;
        private String effectiveSecurityHealthAnalyticsCustomModule;

        protected ProjectLocationEffectiveSecurityHealthAnalyticsCustomModuleBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getEffectiveSecurityHealthAnalyticsCustomModule() {
            return this.effectiveSecurityHealthAnalyticsCustomModule;
        }

        public ProjectLocationEffectiveSecurityHealthAnalyticsCustomModuleBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationEffectiveSecurityHealthAnalyticsCustomModuleBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationEffectiveSecurityHealthAnalyticsCustomModuleBuilder setEffectiveSecurityHealthAnalyticsCustomModule(String effectiveSecurityHealthAnalyticsCustomModule) {
            this.effectiveSecurityHealthAnalyticsCustomModule = effectiveSecurityHealthAnalyticsCustomModule;
            return this;
        }

        public EffectiveSecurityHealthAnalyticsCustomModuleName build() {
            return new EffectiveSecurityHealthAnalyticsCustomModuleName(this);
        }
    }

    public static class Builder {
        private String organization;
        private String location;
        private String effectiveSecurityHealthAnalyticsCustomModule;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public String getEffectiveSecurityHealthAnalyticsCustomModule() {
            return this.effectiveSecurityHealthAnalyticsCustomModule;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setEffectiveSecurityHealthAnalyticsCustomModule(String effectiveSecurityHealthAnalyticsCustomModule) {
            this.effectiveSecurityHealthAnalyticsCustomModule = effectiveSecurityHealthAnalyticsCustomModule;
            return this;
        }

        private Builder(EffectiveSecurityHealthAnalyticsCustomModuleName effectiveSecurityHealthAnalyticsCustomModuleName) {
            Preconditions.checkArgument((boolean)Objects.equals(effectiveSecurityHealthAnalyticsCustomModuleName.pathTemplate, ORGANIZATION_LOCATION_EFFECTIVE_SECURITY_HEALTH_ANALYTICS_CUSTOM_MODULE), (Object)"toBuilder is only supported when EffectiveSecurityHealthAnalyticsCustomModuleName has the pattern of organizations/{organization}/locations/{location}/effectiveSecurityHealthAnalyticsCustomModules/{effective_security_health_analytics_custom_module}");
            this.organization = effectiveSecurityHealthAnalyticsCustomModuleName.organization;
            this.location = effectiveSecurityHealthAnalyticsCustomModuleName.location;
            this.effectiveSecurityHealthAnalyticsCustomModule = effectiveSecurityHealthAnalyticsCustomModuleName.effectiveSecurityHealthAnalyticsCustomModule;
        }

        public EffectiveSecurityHealthAnalyticsCustomModuleName build() {
            return new EffectiveSecurityHealthAnalyticsCustomModuleName(this);
        }
    }
}

