/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.securitycentermanagement.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class EffectiveEventThreatDetectionCustomModuleName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_LOCATION_EFFECTIVE_EVENT_THREAT_DETECTION_CUSTOM_MODULE = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/locations/{location}/effectiveEventThreatDetectionCustomModules/{effective_event_threat_detection_custom_module}");
    private static final PathTemplate PROJECT_LOCATION_EFFECTIVE_EVENT_THREAT_DETECTION_CUSTOM_MODULE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/effectiveEventThreatDetectionCustomModules/{effective_event_threat_detection_custom_module}");
    private static final PathTemplate FOLDER_LOCATION_EFFECTIVE_EVENT_THREAT_DETECTION_CUSTOM_MODULE = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/locations/{location}/effectiveEventThreatDetectionCustomModules/{effective_event_threat_detection_custom_module}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String organization;
    private final String location;
    private final String effectiveEventThreatDetectionCustomModule;
    private final String project;
    private final String folder;

    @Deprecated
    protected EffectiveEventThreatDetectionCustomModuleName() {
        this.organization = null;
        this.location = null;
        this.effectiveEventThreatDetectionCustomModule = null;
        this.project = null;
        this.folder = null;
    }

    private EffectiveEventThreatDetectionCustomModuleName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.effectiveEventThreatDetectionCustomModule = (String)Preconditions.checkNotNull((Object)builder.getEffectiveEventThreatDetectionCustomModule());
        this.project = null;
        this.folder = null;
        this.pathTemplate = ORGANIZATION_LOCATION_EFFECTIVE_EVENT_THREAT_DETECTION_CUSTOM_MODULE;
    }

    private EffectiveEventThreatDetectionCustomModuleName(ProjectLocationEffectiveEventThreatDetectionCustomModuleBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.effectiveEventThreatDetectionCustomModule = (String)Preconditions.checkNotNull((Object)builder.getEffectiveEventThreatDetectionCustomModule());
        this.organization = null;
        this.folder = null;
        this.pathTemplate = PROJECT_LOCATION_EFFECTIVE_EVENT_THREAT_DETECTION_CUSTOM_MODULE;
    }

    private EffectiveEventThreatDetectionCustomModuleName(FolderLocationEffectiveEventThreatDetectionCustomModuleBuilder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.effectiveEventThreatDetectionCustomModule = (String)Preconditions.checkNotNull((Object)builder.getEffectiveEventThreatDetectionCustomModule());
        this.organization = null;
        this.project = null;
        this.pathTemplate = FOLDER_LOCATION_EFFECTIVE_EVENT_THREAT_DETECTION_CUSTOM_MODULE;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getLocation() {
        return this.location;
    }

    public String getEffectiveEventThreatDetectionCustomModule() {
        return this.effectiveEventThreatDetectionCustomModule;
    }

    public String getProject() {
        return this.project;
    }

    public String getFolder() {
        return this.folder;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newOrganizationLocationEffectiveEventThreatDetectionCustomModuleBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static ProjectLocationEffectiveEventThreatDetectionCustomModuleBuilder newProjectLocationEffectiveEventThreatDetectionCustomModuleBuilder() {
        return new ProjectLocationEffectiveEventThreatDetectionCustomModuleBuilder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static FolderLocationEffectiveEventThreatDetectionCustomModuleBuilder newFolderLocationEffectiveEventThreatDetectionCustomModuleBuilder() {
        return new FolderLocationEffectiveEventThreatDetectionCustomModuleBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static EffectiveEventThreatDetectionCustomModuleName of(String organization, String location, String effectiveEventThreatDetectionCustomModule) {
        return EffectiveEventThreatDetectionCustomModuleName.newBuilder().setOrganization(organization).setLocation(location).setEffectiveEventThreatDetectionCustomModule(effectiveEventThreatDetectionCustomModule).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static EffectiveEventThreatDetectionCustomModuleName ofOrganizationLocationEffectiveEventThreatDetectionCustomModuleName(String organization, String location, String effectiveEventThreatDetectionCustomModule) {
        return EffectiveEventThreatDetectionCustomModuleName.newBuilder().setOrganization(organization).setLocation(location).setEffectiveEventThreatDetectionCustomModule(effectiveEventThreatDetectionCustomModule).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static EffectiveEventThreatDetectionCustomModuleName ofProjectLocationEffectiveEventThreatDetectionCustomModuleName(String project, String location, String effectiveEventThreatDetectionCustomModule) {
        return EffectiveEventThreatDetectionCustomModuleName.newProjectLocationEffectiveEventThreatDetectionCustomModuleBuilder().setProject(project).setLocation(location).setEffectiveEventThreatDetectionCustomModule(effectiveEventThreatDetectionCustomModule).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static EffectiveEventThreatDetectionCustomModuleName ofFolderLocationEffectiveEventThreatDetectionCustomModuleName(String folder, String location, String effectiveEventThreatDetectionCustomModule) {
        return EffectiveEventThreatDetectionCustomModuleName.newFolderLocationEffectiveEventThreatDetectionCustomModuleBuilder().setFolder(folder).setLocation(location).setEffectiveEventThreatDetectionCustomModule(effectiveEventThreatDetectionCustomModule).build();
    }

    public static String format(String organization, String location, String effectiveEventThreatDetectionCustomModule) {
        return EffectiveEventThreatDetectionCustomModuleName.newBuilder().setOrganization(organization).setLocation(location).setEffectiveEventThreatDetectionCustomModule(effectiveEventThreatDetectionCustomModule).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatOrganizationLocationEffectiveEventThreatDetectionCustomModuleName(String organization, String location, String effectiveEventThreatDetectionCustomModule) {
        return EffectiveEventThreatDetectionCustomModuleName.newBuilder().setOrganization(organization).setLocation(location).setEffectiveEventThreatDetectionCustomModule(effectiveEventThreatDetectionCustomModule).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectLocationEffectiveEventThreatDetectionCustomModuleName(String project, String location, String effectiveEventThreatDetectionCustomModule) {
        return EffectiveEventThreatDetectionCustomModuleName.newProjectLocationEffectiveEventThreatDetectionCustomModuleBuilder().setProject(project).setLocation(location).setEffectiveEventThreatDetectionCustomModule(effectiveEventThreatDetectionCustomModule).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatFolderLocationEffectiveEventThreatDetectionCustomModuleName(String folder, String location, String effectiveEventThreatDetectionCustomModule) {
        return EffectiveEventThreatDetectionCustomModuleName.newFolderLocationEffectiveEventThreatDetectionCustomModuleBuilder().setFolder(folder).setLocation(location).setEffectiveEventThreatDetectionCustomModule(effectiveEventThreatDetectionCustomModule).build().toString();
    }

    public static EffectiveEventThreatDetectionCustomModuleName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (ORGANIZATION_LOCATION_EFFECTIVE_EVENT_THREAT_DETECTION_CUSTOM_MODULE.matches(formattedString)) {
            Map matchMap = ORGANIZATION_LOCATION_EFFECTIVE_EVENT_THREAT_DETECTION_CUSTOM_MODULE.match(formattedString);
            return EffectiveEventThreatDetectionCustomModuleName.ofOrganizationLocationEffectiveEventThreatDetectionCustomModuleName((String)matchMap.get("organization"), (String)matchMap.get("location"), (String)matchMap.get("effective_event_threat_detection_custom_module"));
        }
        if (PROJECT_LOCATION_EFFECTIVE_EVENT_THREAT_DETECTION_CUSTOM_MODULE.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_EFFECTIVE_EVENT_THREAT_DETECTION_CUSTOM_MODULE.match(formattedString);
            return EffectiveEventThreatDetectionCustomModuleName.ofProjectLocationEffectiveEventThreatDetectionCustomModuleName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("effective_event_threat_detection_custom_module"));
        }
        if (FOLDER_LOCATION_EFFECTIVE_EVENT_THREAT_DETECTION_CUSTOM_MODULE.matches(formattedString)) {
            Map matchMap = FOLDER_LOCATION_EFFECTIVE_EVENT_THREAT_DETECTION_CUSTOM_MODULE.match(formattedString);
            return EffectiveEventThreatDetectionCustomModuleName.ofFolderLocationEffectiveEventThreatDetectionCustomModuleName((String)matchMap.get("folder"), (String)matchMap.get("location"), (String)matchMap.get("effective_event_threat_detection_custom_module"));
        }
        throw new ValidationException("EffectiveEventThreatDetectionCustomModuleName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<EffectiveEventThreatDetectionCustomModuleName> parseList(List<String> formattedStrings) {
        ArrayList<EffectiveEventThreatDetectionCustomModuleName> list = new ArrayList<EffectiveEventThreatDetectionCustomModuleName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(EffectiveEventThreatDetectionCustomModuleName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<EffectiveEventThreatDetectionCustomModuleName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (EffectiveEventThreatDetectionCustomModuleName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_LOCATION_EFFECTIVE_EVENT_THREAT_DETECTION_CUSTOM_MODULE.matches(formattedString) || PROJECT_LOCATION_EFFECTIVE_EVENT_THREAT_DETECTION_CUSTOM_MODULE.matches(formattedString) || FOLDER_LOCATION_EFFECTIVE_EVENT_THREAT_DETECTION_CUSTOM_MODULE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            EffectiveEventThreatDetectionCustomModuleName effectiveEventThreatDetectionCustomModuleName = this;
            synchronized (effectiveEventThreatDetectionCustomModuleName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.effectiveEventThreatDetectionCustomModule != null) {
                        fieldMapBuilder.put((Object)"effective_event_threat_detection_custom_module", (Object)this.effectiveEventThreatDetectionCustomModule);
                    }
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put((Object)"folder", (Object)this.folder);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            EffectiveEventThreatDetectionCustomModuleName that = (EffectiveEventThreatDetectionCustomModuleName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.location, that.location) && Objects.equals(this.effectiveEventThreatDetectionCustomModule, that.effectiveEventThreatDetectionCustomModule) && Objects.equals(this.project, that.project) && Objects.equals(this.folder, that.folder);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.effectiveEventThreatDetectionCustomModule);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        return h ^= Objects.hashCode(this.folder);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class FolderLocationEffectiveEventThreatDetectionCustomModuleBuilder {
        private String folder;
        private String location;
        private String effectiveEventThreatDetectionCustomModule;

        protected FolderLocationEffectiveEventThreatDetectionCustomModuleBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getLocation() {
            return this.location;
        }

        public String getEffectiveEventThreatDetectionCustomModule() {
            return this.effectiveEventThreatDetectionCustomModule;
        }

        public FolderLocationEffectiveEventThreatDetectionCustomModuleBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderLocationEffectiveEventThreatDetectionCustomModuleBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public FolderLocationEffectiveEventThreatDetectionCustomModuleBuilder setEffectiveEventThreatDetectionCustomModule(String effectiveEventThreatDetectionCustomModule) {
            this.effectiveEventThreatDetectionCustomModule = effectiveEventThreatDetectionCustomModule;
            return this;
        }

        public EffectiveEventThreatDetectionCustomModuleName build() {
            return new EffectiveEventThreatDetectionCustomModuleName(this);
        }
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class ProjectLocationEffectiveEventThreatDetectionCustomModuleBuilder {
        private String project;
        private String location;
        private String effectiveEventThreatDetectionCustomModule;

        protected ProjectLocationEffectiveEventThreatDetectionCustomModuleBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getEffectiveEventThreatDetectionCustomModule() {
            return this.effectiveEventThreatDetectionCustomModule;
        }

        public ProjectLocationEffectiveEventThreatDetectionCustomModuleBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationEffectiveEventThreatDetectionCustomModuleBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationEffectiveEventThreatDetectionCustomModuleBuilder setEffectiveEventThreatDetectionCustomModule(String effectiveEventThreatDetectionCustomModule) {
            this.effectiveEventThreatDetectionCustomModule = effectiveEventThreatDetectionCustomModule;
            return this;
        }

        public EffectiveEventThreatDetectionCustomModuleName build() {
            return new EffectiveEventThreatDetectionCustomModuleName(this);
        }
    }

    public static class Builder {
        private String organization;
        private String location;
        private String effectiveEventThreatDetectionCustomModule;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public String getEffectiveEventThreatDetectionCustomModule() {
            return this.effectiveEventThreatDetectionCustomModule;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setEffectiveEventThreatDetectionCustomModule(String effectiveEventThreatDetectionCustomModule) {
            this.effectiveEventThreatDetectionCustomModule = effectiveEventThreatDetectionCustomModule;
            return this;
        }

        private Builder(EffectiveEventThreatDetectionCustomModuleName effectiveEventThreatDetectionCustomModuleName) {
            Preconditions.checkArgument((boolean)Objects.equals(effectiveEventThreatDetectionCustomModuleName.pathTemplate, ORGANIZATION_LOCATION_EFFECTIVE_EVENT_THREAT_DETECTION_CUSTOM_MODULE), (Object)"toBuilder is only supported when EffectiveEventThreatDetectionCustomModuleName has the pattern of organizations/{organization}/locations/{location}/effectiveEventThreatDetectionCustomModules/{effective_event_threat_detection_custom_module}");
            this.organization = effectiveEventThreatDetectionCustomModuleName.organization;
            this.location = effectiveEventThreatDetectionCustomModuleName.location;
            this.effectiveEventThreatDetectionCustomModule = effectiveEventThreatDetectionCustomModuleName.effectiveEventThreatDetectionCustomModule;
        }

        public EffectiveEventThreatDetectionCustomModuleName build() {
            return new EffectiveEventThreatDetectionCustomModuleName(this);
        }
    }
}

