/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.securitycentermanagement.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class EventThreatDetectionCustomModuleName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_LOCATION_EVENT_THREAT_DETECTION_CUSTOM_MODULE = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/locations/{location}/eventThreatDetectionCustomModules/{event_threat_detection_custom_module}");
    private static final PathTemplate PROJECT_LOCATION_EVENT_THREAT_DETECTION_CUSTOM_MODULE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/eventThreatDetectionCustomModules/{event_threat_detection_custom_module}");
    private static final PathTemplate FOLDER_LOCATION_EVENT_THREAT_DETECTION_CUSTOM_MODULE = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/locations/{location}/eventThreatDetectionCustomModules/{event_threat_detection_custom_module}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String organization;
    private final String location;
    private final String eventThreatDetectionCustomModule;
    private final String project;
    private final String folder;

    @Deprecated
    protected EventThreatDetectionCustomModuleName() {
        this.organization = null;
        this.location = null;
        this.eventThreatDetectionCustomModule = null;
        this.project = null;
        this.folder = null;
    }

    private EventThreatDetectionCustomModuleName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.eventThreatDetectionCustomModule = (String)Preconditions.checkNotNull((Object)builder.getEventThreatDetectionCustomModule());
        this.project = null;
        this.folder = null;
        this.pathTemplate = ORGANIZATION_LOCATION_EVENT_THREAT_DETECTION_CUSTOM_MODULE;
    }

    private EventThreatDetectionCustomModuleName(ProjectLocationEventThreatDetectionCustomModuleBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.eventThreatDetectionCustomModule = (String)Preconditions.checkNotNull((Object)builder.getEventThreatDetectionCustomModule());
        this.organization = null;
        this.folder = null;
        this.pathTemplate = PROJECT_LOCATION_EVENT_THREAT_DETECTION_CUSTOM_MODULE;
    }

    private EventThreatDetectionCustomModuleName(FolderLocationEventThreatDetectionCustomModuleBuilder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.eventThreatDetectionCustomModule = (String)Preconditions.checkNotNull((Object)builder.getEventThreatDetectionCustomModule());
        this.organization = null;
        this.project = null;
        this.pathTemplate = FOLDER_LOCATION_EVENT_THREAT_DETECTION_CUSTOM_MODULE;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getLocation() {
        return this.location;
    }

    public String getEventThreatDetectionCustomModule() {
        return this.eventThreatDetectionCustomModule;
    }

    public String getProject() {
        return this.project;
    }

    public String getFolder() {
        return this.folder;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newOrganizationLocationEventThreatDetectionCustomModuleBuilder() {
        return new Builder();
    }

    public static ProjectLocationEventThreatDetectionCustomModuleBuilder newProjectLocationEventThreatDetectionCustomModuleBuilder() {
        return new ProjectLocationEventThreatDetectionCustomModuleBuilder();
    }

    public static FolderLocationEventThreatDetectionCustomModuleBuilder newFolderLocationEventThreatDetectionCustomModuleBuilder() {
        return new FolderLocationEventThreatDetectionCustomModuleBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static EventThreatDetectionCustomModuleName of(String organization, String location, String eventThreatDetectionCustomModule) {
        return EventThreatDetectionCustomModuleName.newBuilder().setOrganization(organization).setLocation(location).setEventThreatDetectionCustomModule(eventThreatDetectionCustomModule).build();
    }

    public static EventThreatDetectionCustomModuleName ofOrganizationLocationEventThreatDetectionCustomModuleName(String organization, String location, String eventThreatDetectionCustomModule) {
        return EventThreatDetectionCustomModuleName.newBuilder().setOrganization(organization).setLocation(location).setEventThreatDetectionCustomModule(eventThreatDetectionCustomModule).build();
    }

    public static EventThreatDetectionCustomModuleName ofProjectLocationEventThreatDetectionCustomModuleName(String project, String location, String eventThreatDetectionCustomModule) {
        return EventThreatDetectionCustomModuleName.newProjectLocationEventThreatDetectionCustomModuleBuilder().setProject(project).setLocation(location).setEventThreatDetectionCustomModule(eventThreatDetectionCustomModule).build();
    }

    public static EventThreatDetectionCustomModuleName ofFolderLocationEventThreatDetectionCustomModuleName(String folder, String location, String eventThreatDetectionCustomModule) {
        return EventThreatDetectionCustomModuleName.newFolderLocationEventThreatDetectionCustomModuleBuilder().setFolder(folder).setLocation(location).setEventThreatDetectionCustomModule(eventThreatDetectionCustomModule).build();
    }

    public static String format(String organization, String location, String eventThreatDetectionCustomModule) {
        return EventThreatDetectionCustomModuleName.newBuilder().setOrganization(organization).setLocation(location).setEventThreatDetectionCustomModule(eventThreatDetectionCustomModule).build().toString();
    }

    public static String formatOrganizationLocationEventThreatDetectionCustomModuleName(String organization, String location, String eventThreatDetectionCustomModule) {
        return EventThreatDetectionCustomModuleName.newBuilder().setOrganization(organization).setLocation(location).setEventThreatDetectionCustomModule(eventThreatDetectionCustomModule).build().toString();
    }

    public static String formatProjectLocationEventThreatDetectionCustomModuleName(String project, String location, String eventThreatDetectionCustomModule) {
        return EventThreatDetectionCustomModuleName.newProjectLocationEventThreatDetectionCustomModuleBuilder().setProject(project).setLocation(location).setEventThreatDetectionCustomModule(eventThreatDetectionCustomModule).build().toString();
    }

    public static String formatFolderLocationEventThreatDetectionCustomModuleName(String folder, String location, String eventThreatDetectionCustomModule) {
        return EventThreatDetectionCustomModuleName.newFolderLocationEventThreatDetectionCustomModuleBuilder().setFolder(folder).setLocation(location).setEventThreatDetectionCustomModule(eventThreatDetectionCustomModule).build().toString();
    }

    public static EventThreatDetectionCustomModuleName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (ORGANIZATION_LOCATION_EVENT_THREAT_DETECTION_CUSTOM_MODULE.matches(formattedString)) {
            Map matchMap = ORGANIZATION_LOCATION_EVENT_THREAT_DETECTION_CUSTOM_MODULE.match(formattedString);
            return EventThreatDetectionCustomModuleName.ofOrganizationLocationEventThreatDetectionCustomModuleName((String)matchMap.get("organization"), (String)matchMap.get("location"), (String)matchMap.get("event_threat_detection_custom_module"));
        }
        if (PROJECT_LOCATION_EVENT_THREAT_DETECTION_CUSTOM_MODULE.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_EVENT_THREAT_DETECTION_CUSTOM_MODULE.match(formattedString);
            return EventThreatDetectionCustomModuleName.ofProjectLocationEventThreatDetectionCustomModuleName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("event_threat_detection_custom_module"));
        }
        if (FOLDER_LOCATION_EVENT_THREAT_DETECTION_CUSTOM_MODULE.matches(formattedString)) {
            Map matchMap = FOLDER_LOCATION_EVENT_THREAT_DETECTION_CUSTOM_MODULE.match(formattedString);
            return EventThreatDetectionCustomModuleName.ofFolderLocationEventThreatDetectionCustomModuleName((String)matchMap.get("folder"), (String)matchMap.get("location"), (String)matchMap.get("event_threat_detection_custom_module"));
        }
        throw new ValidationException("EventThreatDetectionCustomModuleName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<EventThreatDetectionCustomModuleName> parseList(List<String> formattedStrings) {
        ArrayList<EventThreatDetectionCustomModuleName> list = new ArrayList<EventThreatDetectionCustomModuleName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(EventThreatDetectionCustomModuleName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<EventThreatDetectionCustomModuleName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (EventThreatDetectionCustomModuleName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_LOCATION_EVENT_THREAT_DETECTION_CUSTOM_MODULE.matches(formattedString) || PROJECT_LOCATION_EVENT_THREAT_DETECTION_CUSTOM_MODULE.matches(formattedString) || FOLDER_LOCATION_EVENT_THREAT_DETECTION_CUSTOM_MODULE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            EventThreatDetectionCustomModuleName eventThreatDetectionCustomModuleName = this;
            synchronized (eventThreatDetectionCustomModuleName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.eventThreatDetectionCustomModule != null) {
                        fieldMapBuilder.put((Object)"event_threat_detection_custom_module", (Object)this.eventThreatDetectionCustomModule);
                    }
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put((Object)"folder", (Object)this.folder);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            EventThreatDetectionCustomModuleName that = (EventThreatDetectionCustomModuleName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.location, that.location) && Objects.equals(this.eventThreatDetectionCustomModule, that.eventThreatDetectionCustomModule) && Objects.equals(this.project, that.project) && Objects.equals(this.folder, that.folder);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.eventThreatDetectionCustomModule);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        return h ^= Objects.hashCode(this.folder);
    }

    public static class FolderLocationEventThreatDetectionCustomModuleBuilder {
        private String folder;
        private String location;
        private String eventThreatDetectionCustomModule;

        protected FolderLocationEventThreatDetectionCustomModuleBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getLocation() {
            return this.location;
        }

        public String getEventThreatDetectionCustomModule() {
            return this.eventThreatDetectionCustomModule;
        }

        public FolderLocationEventThreatDetectionCustomModuleBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderLocationEventThreatDetectionCustomModuleBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public FolderLocationEventThreatDetectionCustomModuleBuilder setEventThreatDetectionCustomModule(String eventThreatDetectionCustomModule) {
            this.eventThreatDetectionCustomModule = eventThreatDetectionCustomModule;
            return this;
        }

        public EventThreatDetectionCustomModuleName build() {
            return new EventThreatDetectionCustomModuleName(this);
        }
    }

    public static class ProjectLocationEventThreatDetectionCustomModuleBuilder {
        private String project;
        private String location;
        private String eventThreatDetectionCustomModule;

        protected ProjectLocationEventThreatDetectionCustomModuleBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getEventThreatDetectionCustomModule() {
            return this.eventThreatDetectionCustomModule;
        }

        public ProjectLocationEventThreatDetectionCustomModuleBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationEventThreatDetectionCustomModuleBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationEventThreatDetectionCustomModuleBuilder setEventThreatDetectionCustomModule(String eventThreatDetectionCustomModule) {
            this.eventThreatDetectionCustomModule = eventThreatDetectionCustomModule;
            return this;
        }

        public EventThreatDetectionCustomModuleName build() {
            return new EventThreatDetectionCustomModuleName(this);
        }
    }

    public static class Builder {
        private String organization;
        private String location;
        private String eventThreatDetectionCustomModule;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public String getEventThreatDetectionCustomModule() {
            return this.eventThreatDetectionCustomModule;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setEventThreatDetectionCustomModule(String eventThreatDetectionCustomModule) {
            this.eventThreatDetectionCustomModule = eventThreatDetectionCustomModule;
            return this;
        }

        private Builder(EventThreatDetectionCustomModuleName eventThreatDetectionCustomModuleName) {
            Preconditions.checkArgument((boolean)Objects.equals(eventThreatDetectionCustomModuleName.pathTemplate, ORGANIZATION_LOCATION_EVENT_THREAT_DETECTION_CUSTOM_MODULE), (Object)"toBuilder is only supported when EventThreatDetectionCustomModuleName has the pattern of organizations/{organization}/locations/{location}/eventThreatDetectionCustomModules/{event_threat_detection_custom_module}");
            this.organization = eventThreatDetectionCustomModuleName.organization;
            this.location = eventThreatDetectionCustomModuleName.location;
            this.eventThreatDetectionCustomModule = eventThreatDetectionCustomModuleName.eventThreatDetectionCustomModule;
        }

        public EventThreatDetectionCustomModuleName build() {
            return new EventThreatDetectionCustomModuleName(this);
        }
    }
}

