/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.securitycenter.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ValuedResourceName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_SIMULATION_VALUED_RESOURCE = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/simulations/{simulation}/valuedResources/{valued_resource}");
    private static final PathTemplate ORGANIZATION_LOCATION_SIMLUATION_VALUED_RESOURCE = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/locations/{location}/simulations/{simluation}/valuedResources/{valued_resource}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String organization;
    private final String simulation;
    private final String valuedResource;
    private final String location;
    private final String simluation;

    @Deprecated
    protected ValuedResourceName() {
        this.organization = null;
        this.simulation = null;
        this.valuedResource = null;
        this.location = null;
        this.simluation = null;
    }

    private ValuedResourceName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.simulation = (String)Preconditions.checkNotNull((Object)builder.getSimulation());
        this.valuedResource = (String)Preconditions.checkNotNull((Object)builder.getValuedResource());
        this.location = null;
        this.simluation = null;
        this.pathTemplate = ORGANIZATION_SIMULATION_VALUED_RESOURCE;
    }

    private ValuedResourceName(OrganizationLocationSimluationValuedResourceBuilder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.simluation = (String)Preconditions.checkNotNull((Object)builder.getSimluation());
        this.valuedResource = (String)Preconditions.checkNotNull((Object)builder.getValuedResource());
        this.simulation = null;
        this.pathTemplate = ORGANIZATION_LOCATION_SIMLUATION_VALUED_RESOURCE;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getSimulation() {
        return this.simulation;
    }

    public String getValuedResource() {
        return this.valuedResource;
    }

    public String getLocation() {
        return this.location;
    }

    public String getSimluation() {
        return this.simluation;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newOrganizationSimulationValuedResourceBuilder() {
        return new Builder();
    }

    public static OrganizationLocationSimluationValuedResourceBuilder newOrganizationLocationSimluationValuedResourceBuilder() {
        return new OrganizationLocationSimluationValuedResourceBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ValuedResourceName of(String organization, String simulation, String valuedResource) {
        return ValuedResourceName.newBuilder().setOrganization(organization).setSimulation(simulation).setValuedResource(valuedResource).build();
    }

    public static ValuedResourceName ofOrganizationSimulationValuedResourceName(String organization, String simulation, String valuedResource) {
        return ValuedResourceName.newBuilder().setOrganization(organization).setSimulation(simulation).setValuedResource(valuedResource).build();
    }

    public static ValuedResourceName ofOrganizationLocationSimluationValuedResourceName(String organization, String location, String simluation, String valuedResource) {
        return ValuedResourceName.newOrganizationLocationSimluationValuedResourceBuilder().setOrganization(organization).setLocation(location).setSimluation(simluation).setValuedResource(valuedResource).build();
    }

    public static String format(String organization, String simulation, String valuedResource) {
        return ValuedResourceName.newBuilder().setOrganization(organization).setSimulation(simulation).setValuedResource(valuedResource).build().toString();
    }

    public static String formatOrganizationSimulationValuedResourceName(String organization, String simulation, String valuedResource) {
        return ValuedResourceName.newBuilder().setOrganization(organization).setSimulation(simulation).setValuedResource(valuedResource).build().toString();
    }

    public static String formatOrganizationLocationSimluationValuedResourceName(String organization, String location, String simluation, String valuedResource) {
        return ValuedResourceName.newOrganizationLocationSimluationValuedResourceBuilder().setOrganization(organization).setLocation(location).setSimluation(simluation).setValuedResource(valuedResource).build().toString();
    }

    public static ValuedResourceName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (ORGANIZATION_SIMULATION_VALUED_RESOURCE.matches(formattedString)) {
            Map matchMap = ORGANIZATION_SIMULATION_VALUED_RESOURCE.match(formattedString);
            return ValuedResourceName.ofOrganizationSimulationValuedResourceName((String)matchMap.get("organization"), (String)matchMap.get("simulation"), (String)matchMap.get("valued_resource"));
        }
        if (ORGANIZATION_LOCATION_SIMLUATION_VALUED_RESOURCE.matches(formattedString)) {
            Map matchMap = ORGANIZATION_LOCATION_SIMLUATION_VALUED_RESOURCE.match(formattedString);
            return ValuedResourceName.ofOrganizationLocationSimluationValuedResourceName((String)matchMap.get("organization"), (String)matchMap.get("location"), (String)matchMap.get("simluation"), (String)matchMap.get("valued_resource"));
        }
        throw new ValidationException("ValuedResourceName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<ValuedResourceName> parseList(List<String> formattedStrings) {
        ArrayList<ValuedResourceName> list = new ArrayList<ValuedResourceName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ValuedResourceName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ValuedResourceName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ValuedResourceName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_SIMULATION_VALUED_RESOURCE.matches(formattedString) || ORGANIZATION_LOCATION_SIMLUATION_VALUED_RESOURCE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ValuedResourceName valuedResourceName = this;
            synchronized (valuedResourceName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.simulation != null) {
                        fieldMapBuilder.put((Object)"simulation", (Object)this.simulation);
                    }
                    if (this.valuedResource != null) {
                        fieldMapBuilder.put((Object)"valued_resource", (Object)this.valuedResource);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.simluation != null) {
                        fieldMapBuilder.put((Object)"simluation", (Object)this.simluation);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ValuedResourceName that = (ValuedResourceName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.simulation, that.simulation) && Objects.equals(this.valuedResource, that.valuedResource) && Objects.equals(this.location, that.location) && Objects.equals(this.simluation, that.simluation);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.simulation);
        h *= 1000003;
        h ^= Objects.hashCode(this.valuedResource);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.simluation);
    }

    public static class OrganizationLocationSimluationValuedResourceBuilder {
        private String organization;
        private String location;
        private String simluation;
        private String valuedResource;

        protected OrganizationLocationSimluationValuedResourceBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public String getSimluation() {
            return this.simluation;
        }

        public String getValuedResource() {
            return this.valuedResource;
        }

        public OrganizationLocationSimluationValuedResourceBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public OrganizationLocationSimluationValuedResourceBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public OrganizationLocationSimluationValuedResourceBuilder setSimluation(String simluation) {
            this.simluation = simluation;
            return this;
        }

        public OrganizationLocationSimluationValuedResourceBuilder setValuedResource(String valuedResource) {
            this.valuedResource = valuedResource;
            return this;
        }

        public ValuedResourceName build() {
            return new ValuedResourceName(this);
        }
    }

    public static class Builder {
        private String organization;
        private String simulation;
        private String valuedResource;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getSimulation() {
            return this.simulation;
        }

        public String getValuedResource() {
            return this.valuedResource;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setSimulation(String simulation) {
            this.simulation = simulation;
            return this;
        }

        public Builder setValuedResource(String valuedResource) {
            this.valuedResource = valuedResource;
            return this;
        }

        private Builder(ValuedResourceName valuedResourceName) {
            Preconditions.checkArgument((boolean)Objects.equals(valuedResourceName.pathTemplate, ORGANIZATION_SIMULATION_VALUED_RESOURCE), (Object)"toBuilder is only supported when ValuedResourceName has the pattern of organizations/{organization}/simulations/{simulation}/valuedResources/{valued_resource}");
            this.organization = valuedResourceName.organization;
            this.simulation = valuedResourceName.simulation;
            this.valuedResource = valuedResourceName.valuedResource;
        }

        public ValuedResourceName build() {
            return new ValuedResourceName(this);
        }
    }
}

