/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.securitycenter.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class NotificationConfigName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_LOCATION_NOTIFICATION_CONFIG = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/locations/{location}/notificationConfigs/{notification_config}");
    private static final PathTemplate FOLDER_LOCATION_NOTIFICATION_CONFIG = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/locations/{location}/notificationConfigs/{notification_config}");
    private static final PathTemplate PROJECT_LOCATION_NOTIFICATION_CONFIG = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/notificationConfigs/{notification_config}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String organization;
    private final String location;
    private final String notificationConfig;
    private final String folder;
    private final String project;

    @Deprecated
    protected NotificationConfigName() {
        this.organization = null;
        this.location = null;
        this.notificationConfig = null;
        this.folder = null;
        this.project = null;
    }

    private NotificationConfigName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.notificationConfig = (String)Preconditions.checkNotNull((Object)builder.getNotificationConfig());
        this.folder = null;
        this.project = null;
        this.pathTemplate = ORGANIZATION_LOCATION_NOTIFICATION_CONFIG;
    }

    private NotificationConfigName(FolderLocationNotificationConfigBuilder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.notificationConfig = (String)Preconditions.checkNotNull((Object)builder.getNotificationConfig());
        this.organization = null;
        this.project = null;
        this.pathTemplate = FOLDER_LOCATION_NOTIFICATION_CONFIG;
    }

    private NotificationConfigName(ProjectLocationNotificationConfigBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.notificationConfig = (String)Preconditions.checkNotNull((Object)builder.getNotificationConfig());
        this.organization = null;
        this.folder = null;
        this.pathTemplate = PROJECT_LOCATION_NOTIFICATION_CONFIG;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getLocation() {
        return this.location;
    }

    public String getNotificationConfig() {
        return this.notificationConfig;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getProject() {
        return this.project;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newOrganizationLocationNotificationConfigBuilder() {
        return new Builder();
    }

    public static FolderLocationNotificationConfigBuilder newFolderLocationNotificationConfigBuilder() {
        return new FolderLocationNotificationConfigBuilder();
    }

    public static ProjectLocationNotificationConfigBuilder newProjectLocationNotificationConfigBuilder() {
        return new ProjectLocationNotificationConfigBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static NotificationConfigName of(String organization, String location, String notificationConfig) {
        return NotificationConfigName.newBuilder().setOrganization(organization).setLocation(location).setNotificationConfig(notificationConfig).build();
    }

    public static NotificationConfigName ofOrganizationLocationNotificationConfigName(String organization, String location, String notificationConfig) {
        return NotificationConfigName.newBuilder().setOrganization(organization).setLocation(location).setNotificationConfig(notificationConfig).build();
    }

    public static NotificationConfigName ofFolderLocationNotificationConfigName(String folder, String location, String notificationConfig) {
        return NotificationConfigName.newFolderLocationNotificationConfigBuilder().setFolder(folder).setLocation(location).setNotificationConfig(notificationConfig).build();
    }

    public static NotificationConfigName ofProjectLocationNotificationConfigName(String project, String location, String notificationConfig) {
        return NotificationConfigName.newProjectLocationNotificationConfigBuilder().setProject(project).setLocation(location).setNotificationConfig(notificationConfig).build();
    }

    public static String format(String organization, String location, String notificationConfig) {
        return NotificationConfigName.newBuilder().setOrganization(organization).setLocation(location).setNotificationConfig(notificationConfig).build().toString();
    }

    public static String formatOrganizationLocationNotificationConfigName(String organization, String location, String notificationConfig) {
        return NotificationConfigName.newBuilder().setOrganization(organization).setLocation(location).setNotificationConfig(notificationConfig).build().toString();
    }

    public static String formatFolderLocationNotificationConfigName(String folder, String location, String notificationConfig) {
        return NotificationConfigName.newFolderLocationNotificationConfigBuilder().setFolder(folder).setLocation(location).setNotificationConfig(notificationConfig).build().toString();
    }

    public static String formatProjectLocationNotificationConfigName(String project, String location, String notificationConfig) {
        return NotificationConfigName.newProjectLocationNotificationConfigBuilder().setProject(project).setLocation(location).setNotificationConfig(notificationConfig).build().toString();
    }

    public static NotificationConfigName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (ORGANIZATION_LOCATION_NOTIFICATION_CONFIG.matches(formattedString)) {
            Map matchMap = ORGANIZATION_LOCATION_NOTIFICATION_CONFIG.match(formattedString);
            return NotificationConfigName.ofOrganizationLocationNotificationConfigName((String)matchMap.get("organization"), (String)matchMap.get("location"), (String)matchMap.get("notification_config"));
        }
        if (FOLDER_LOCATION_NOTIFICATION_CONFIG.matches(formattedString)) {
            Map matchMap = FOLDER_LOCATION_NOTIFICATION_CONFIG.match(formattedString);
            return NotificationConfigName.ofFolderLocationNotificationConfigName((String)matchMap.get("folder"), (String)matchMap.get("location"), (String)matchMap.get("notification_config"));
        }
        if (PROJECT_LOCATION_NOTIFICATION_CONFIG.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_NOTIFICATION_CONFIG.match(formattedString);
            return NotificationConfigName.ofProjectLocationNotificationConfigName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("notification_config"));
        }
        throw new ValidationException("NotificationConfigName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<NotificationConfigName> parseList(List<String> formattedStrings) {
        ArrayList<NotificationConfigName> list = new ArrayList<NotificationConfigName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(NotificationConfigName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<NotificationConfigName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (NotificationConfigName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_LOCATION_NOTIFICATION_CONFIG.matches(formattedString) || FOLDER_LOCATION_NOTIFICATION_CONFIG.matches(formattedString) || PROJECT_LOCATION_NOTIFICATION_CONFIG.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            NotificationConfigName notificationConfigName = this;
            synchronized (notificationConfigName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.notificationConfig != null) {
                        fieldMapBuilder.put((Object)"notification_config", (Object)this.notificationConfig);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put((Object)"folder", (Object)this.folder);
                    }
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            NotificationConfigName that = (NotificationConfigName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.location, that.location) && Objects.equals(this.notificationConfig, that.notificationConfig) && Objects.equals(this.folder, that.folder) && Objects.equals(this.project, that.project);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.notificationConfig);
        h *= 1000003;
        h ^= Objects.hashCode(this.folder);
        h *= 1000003;
        return h ^= Objects.hashCode(this.project);
    }

    public static class ProjectLocationNotificationConfigBuilder {
        private String project;
        private String location;
        private String notificationConfig;

        protected ProjectLocationNotificationConfigBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getNotificationConfig() {
            return this.notificationConfig;
        }

        public ProjectLocationNotificationConfigBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationNotificationConfigBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationNotificationConfigBuilder setNotificationConfig(String notificationConfig) {
            this.notificationConfig = notificationConfig;
            return this;
        }

        public NotificationConfigName build() {
            return new NotificationConfigName(this);
        }
    }

    public static class FolderLocationNotificationConfigBuilder {
        private String folder;
        private String location;
        private String notificationConfig;

        protected FolderLocationNotificationConfigBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getLocation() {
            return this.location;
        }

        public String getNotificationConfig() {
            return this.notificationConfig;
        }

        public FolderLocationNotificationConfigBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderLocationNotificationConfigBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public FolderLocationNotificationConfigBuilder setNotificationConfig(String notificationConfig) {
            this.notificationConfig = notificationConfig;
            return this;
        }

        public NotificationConfigName build() {
            return new NotificationConfigName(this);
        }
    }

    public static class Builder {
        private String organization;
        private String location;
        private String notificationConfig;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public String getNotificationConfig() {
            return this.notificationConfig;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setNotificationConfig(String notificationConfig) {
            this.notificationConfig = notificationConfig;
            return this;
        }

        private Builder(NotificationConfigName notificationConfigName) {
            Preconditions.checkArgument((boolean)Objects.equals(notificationConfigName.pathTemplate, ORGANIZATION_LOCATION_NOTIFICATION_CONFIG), (Object)"toBuilder is only supported when NotificationConfigName has the pattern of organizations/{organization}/locations/{location}/notificationConfigs/{notification_config}");
            this.organization = notificationConfigName.organization;
            this.location = notificationConfigName.location;
            this.notificationConfig = notificationConfigName.notificationConfig;
        }

        public NotificationConfigName build() {
            return new NotificationConfigName(this);
        }
    }
}

