/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.securitycenter.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ResourceValueConfigName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_RESOURCE_VALUE_CONFIG = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/resourceValueConfigs/{resource_value_config}");
    private static final PathTemplate ORGANIZATION_LOCATION_RESOURCE_VALUE_CONFIG = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/locations/{location}/resourceValueConfigs/{resource_value_config}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String organization;
    private final String resourceValueConfig;
    private final String location;

    @Deprecated
    protected ResourceValueConfigName() {
        this.organization = null;
        this.resourceValueConfig = null;
        this.location = null;
    }

    private ResourceValueConfigName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.resourceValueConfig = (String)Preconditions.checkNotNull((Object)builder.getResourceValueConfig());
        this.location = null;
        this.pathTemplate = ORGANIZATION_RESOURCE_VALUE_CONFIG;
    }

    private ResourceValueConfigName(OrganizationLocationResourceValueConfigBuilder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.resourceValueConfig = (String)Preconditions.checkNotNull((Object)builder.getResourceValueConfig());
        this.pathTemplate = ORGANIZATION_LOCATION_RESOURCE_VALUE_CONFIG;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getResourceValueConfig() {
        return this.resourceValueConfig;
    }

    public String getLocation() {
        return this.location;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newOrganizationResourceValueConfigBuilder() {
        return new Builder();
    }

    public static OrganizationLocationResourceValueConfigBuilder newOrganizationLocationResourceValueConfigBuilder() {
        return new OrganizationLocationResourceValueConfigBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ResourceValueConfigName of(String organization, String resourceValueConfig) {
        return ResourceValueConfigName.newBuilder().setOrganization(organization).setResourceValueConfig(resourceValueConfig).build();
    }

    public static ResourceValueConfigName ofOrganizationResourceValueConfigName(String organization, String resourceValueConfig) {
        return ResourceValueConfigName.newBuilder().setOrganization(organization).setResourceValueConfig(resourceValueConfig).build();
    }

    public static ResourceValueConfigName ofOrganizationLocationResourceValueConfigName(String organization, String location, String resourceValueConfig) {
        return ResourceValueConfigName.newOrganizationLocationResourceValueConfigBuilder().setOrganization(organization).setLocation(location).setResourceValueConfig(resourceValueConfig).build();
    }

    public static String format(String organization, String resourceValueConfig) {
        return ResourceValueConfigName.newBuilder().setOrganization(organization).setResourceValueConfig(resourceValueConfig).build().toString();
    }

    public static String formatOrganizationResourceValueConfigName(String organization, String resourceValueConfig) {
        return ResourceValueConfigName.newBuilder().setOrganization(organization).setResourceValueConfig(resourceValueConfig).build().toString();
    }

    public static String formatOrganizationLocationResourceValueConfigName(String organization, String location, String resourceValueConfig) {
        return ResourceValueConfigName.newOrganizationLocationResourceValueConfigBuilder().setOrganization(organization).setLocation(location).setResourceValueConfig(resourceValueConfig).build().toString();
    }

    public static ResourceValueConfigName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (ORGANIZATION_RESOURCE_VALUE_CONFIG.matches(formattedString)) {
            Map matchMap = ORGANIZATION_RESOURCE_VALUE_CONFIG.match(formattedString);
            return ResourceValueConfigName.ofOrganizationResourceValueConfigName((String)matchMap.get("organization"), (String)matchMap.get("resource_value_config"));
        }
        if (ORGANIZATION_LOCATION_RESOURCE_VALUE_CONFIG.matches(formattedString)) {
            Map matchMap = ORGANIZATION_LOCATION_RESOURCE_VALUE_CONFIG.match(formattedString);
            return ResourceValueConfigName.ofOrganizationLocationResourceValueConfigName((String)matchMap.get("organization"), (String)matchMap.get("location"), (String)matchMap.get("resource_value_config"));
        }
        throw new ValidationException("ResourceValueConfigName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<ResourceValueConfigName> parseList(List<String> formattedStrings) {
        ArrayList<ResourceValueConfigName> list = new ArrayList<ResourceValueConfigName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ResourceValueConfigName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ResourceValueConfigName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ResourceValueConfigName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_RESOURCE_VALUE_CONFIG.matches(formattedString) || ORGANIZATION_LOCATION_RESOURCE_VALUE_CONFIG.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ResourceValueConfigName resourceValueConfigName = this;
            synchronized (resourceValueConfigName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.resourceValueConfig != null) {
                        fieldMapBuilder.put((Object)"resource_value_config", (Object)this.resourceValueConfig);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ResourceValueConfigName that = (ResourceValueConfigName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.resourceValueConfig, that.resourceValueConfig) && Objects.equals(this.location, that.location);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.resourceValueConfig);
        h *= 1000003;
        return h ^= Objects.hashCode(this.location);
    }

    public static class OrganizationLocationResourceValueConfigBuilder {
        private String organization;
        private String location;
        private String resourceValueConfig;

        protected OrganizationLocationResourceValueConfigBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public String getResourceValueConfig() {
            return this.resourceValueConfig;
        }

        public OrganizationLocationResourceValueConfigBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public OrganizationLocationResourceValueConfigBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public OrganizationLocationResourceValueConfigBuilder setResourceValueConfig(String resourceValueConfig) {
            this.resourceValueConfig = resourceValueConfig;
            return this;
        }

        public ResourceValueConfigName build() {
            return new ResourceValueConfigName(this);
        }
    }

    public static class Builder {
        private String organization;
        private String resourceValueConfig;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getResourceValueConfig() {
            return this.resourceValueConfig;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setResourceValueConfig(String resourceValueConfig) {
            this.resourceValueConfig = resourceValueConfig;
            return this;
        }

        private Builder(ResourceValueConfigName resourceValueConfigName) {
            Preconditions.checkArgument((boolean)Objects.equals(resourceValueConfigName.pathTemplate, ORGANIZATION_RESOURCE_VALUE_CONFIG), (Object)"toBuilder is only supported when ResourceValueConfigName has the pattern of organizations/{organization}/resourceValueConfigs/{resource_value_config}");
            this.organization = resourceValueConfigName.organization;
            this.resourceValueConfig = resourceValueConfigName.resourceValueConfig;
        }

        public ResourceValueConfigName build() {
            return new ResourceValueConfigName(this);
        }
    }
}

