/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.securitycenter.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FindingName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_SOURCE_FINDING = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/sources/{source}/findings/{finding}");
    private static final PathTemplate ORGANIZATION_SOURCE_LOCATION_FINDING = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/sources/{source}/locations/{location}/findings/{finding}");
    private static final PathTemplate FOLDER_SOURCE_FINDING = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/sources/{source}/findings/{finding}");
    private static final PathTemplate FOLDER_SOURCE_LOCATION_FINDING = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/sources/{source}/locations/{location}/findings/{finding}");
    private static final PathTemplate PROJECT_SOURCE_FINDING = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/sources/{source}/findings/{finding}");
    private static final PathTemplate PROJECT_SOURCE_LOCATION_FINDING = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/sources/{source}/locations/{location}/findings/{finding}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String organization;
    private final String source;
    private final String finding;
    private final String location;
    private final String folder;
    private final String project;

    @Deprecated
    protected FindingName() {
        this.organization = null;
        this.source = null;
        this.finding = null;
        this.location = null;
        this.folder = null;
        this.project = null;
    }

    private FindingName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.source = (String)Preconditions.checkNotNull((Object)builder.getSource());
        this.finding = (String)Preconditions.checkNotNull((Object)builder.getFinding());
        this.location = null;
        this.folder = null;
        this.project = null;
        this.pathTemplate = ORGANIZATION_SOURCE_FINDING;
    }

    private FindingName(OrganizationSourceLocationFindingBuilder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.source = (String)Preconditions.checkNotNull((Object)builder.getSource());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.finding = (String)Preconditions.checkNotNull((Object)builder.getFinding());
        this.folder = null;
        this.project = null;
        this.pathTemplate = ORGANIZATION_SOURCE_LOCATION_FINDING;
    }

    private FindingName(FolderSourceFindingBuilder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.source = (String)Preconditions.checkNotNull((Object)builder.getSource());
        this.finding = (String)Preconditions.checkNotNull((Object)builder.getFinding());
        this.organization = null;
        this.location = null;
        this.project = null;
        this.pathTemplate = FOLDER_SOURCE_FINDING;
    }

    private FindingName(FolderSourceLocationFindingBuilder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.source = (String)Preconditions.checkNotNull((Object)builder.getSource());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.finding = (String)Preconditions.checkNotNull((Object)builder.getFinding());
        this.organization = null;
        this.project = null;
        this.pathTemplate = FOLDER_SOURCE_LOCATION_FINDING;
    }

    private FindingName(ProjectSourceFindingBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.source = (String)Preconditions.checkNotNull((Object)builder.getSource());
        this.finding = (String)Preconditions.checkNotNull((Object)builder.getFinding());
        this.organization = null;
        this.location = null;
        this.folder = null;
        this.pathTemplate = PROJECT_SOURCE_FINDING;
    }

    private FindingName(ProjectSourceLocationFindingBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.source = (String)Preconditions.checkNotNull((Object)builder.getSource());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.finding = (String)Preconditions.checkNotNull((Object)builder.getFinding());
        this.organization = null;
        this.folder = null;
        this.pathTemplate = PROJECT_SOURCE_LOCATION_FINDING;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getSource() {
        return this.source;
    }

    public String getFinding() {
        return this.finding;
    }

    public String getLocation() {
        return this.location;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getProject() {
        return this.project;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newOrganizationSourceFindingBuilder() {
        return new Builder();
    }

    public static OrganizationSourceLocationFindingBuilder newOrganizationSourceLocationFindingBuilder() {
        return new OrganizationSourceLocationFindingBuilder();
    }

    public static FolderSourceFindingBuilder newFolderSourceFindingBuilder() {
        return new FolderSourceFindingBuilder();
    }

    public static FolderSourceLocationFindingBuilder newFolderSourceLocationFindingBuilder() {
        return new FolderSourceLocationFindingBuilder();
    }

    public static ProjectSourceFindingBuilder newProjectSourceFindingBuilder() {
        return new ProjectSourceFindingBuilder();
    }

    public static ProjectSourceLocationFindingBuilder newProjectSourceLocationFindingBuilder() {
        return new ProjectSourceLocationFindingBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static FindingName of(String organization, String source, String finding) {
        return FindingName.newBuilder().setOrganization(organization).setSource(source).setFinding(finding).build();
    }

    public static FindingName ofOrganizationSourceFindingName(String organization, String source, String finding) {
        return FindingName.newBuilder().setOrganization(organization).setSource(source).setFinding(finding).build();
    }

    public static FindingName ofOrganizationSourceLocationFindingName(String organization, String source, String location, String finding) {
        return FindingName.newOrganizationSourceLocationFindingBuilder().setOrganization(organization).setSource(source).setLocation(location).setFinding(finding).build();
    }

    public static FindingName ofFolderSourceFindingName(String folder, String source, String finding) {
        return FindingName.newFolderSourceFindingBuilder().setFolder(folder).setSource(source).setFinding(finding).build();
    }

    public static FindingName ofFolderSourceLocationFindingName(String folder, String source, String location, String finding) {
        return FindingName.newFolderSourceLocationFindingBuilder().setFolder(folder).setSource(source).setLocation(location).setFinding(finding).build();
    }

    public static FindingName ofProjectSourceFindingName(String project, String source, String finding) {
        return FindingName.newProjectSourceFindingBuilder().setProject(project).setSource(source).setFinding(finding).build();
    }

    public static FindingName ofProjectSourceLocationFindingName(String project, String source, String location, String finding) {
        return FindingName.newProjectSourceLocationFindingBuilder().setProject(project).setSource(source).setLocation(location).setFinding(finding).build();
    }

    public static String format(String organization, String source, String finding) {
        return FindingName.newBuilder().setOrganization(organization).setSource(source).setFinding(finding).build().toString();
    }

    public static String formatOrganizationSourceFindingName(String organization, String source, String finding) {
        return FindingName.newBuilder().setOrganization(organization).setSource(source).setFinding(finding).build().toString();
    }

    public static String formatOrganizationSourceLocationFindingName(String organization, String source, String location, String finding) {
        return FindingName.newOrganizationSourceLocationFindingBuilder().setOrganization(organization).setSource(source).setLocation(location).setFinding(finding).build().toString();
    }

    public static String formatFolderSourceFindingName(String folder, String source, String finding) {
        return FindingName.newFolderSourceFindingBuilder().setFolder(folder).setSource(source).setFinding(finding).build().toString();
    }

    public static String formatFolderSourceLocationFindingName(String folder, String source, String location, String finding) {
        return FindingName.newFolderSourceLocationFindingBuilder().setFolder(folder).setSource(source).setLocation(location).setFinding(finding).build().toString();
    }

    public static String formatProjectSourceFindingName(String project, String source, String finding) {
        return FindingName.newProjectSourceFindingBuilder().setProject(project).setSource(source).setFinding(finding).build().toString();
    }

    public static String formatProjectSourceLocationFindingName(String project, String source, String location, String finding) {
        return FindingName.newProjectSourceLocationFindingBuilder().setProject(project).setSource(source).setLocation(location).setFinding(finding).build().toString();
    }

    public static FindingName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (ORGANIZATION_SOURCE_FINDING.matches(formattedString)) {
            Map matchMap = ORGANIZATION_SOURCE_FINDING.match(formattedString);
            return FindingName.ofOrganizationSourceFindingName((String)matchMap.get("organization"), (String)matchMap.get("source"), (String)matchMap.get("finding"));
        }
        if (ORGANIZATION_SOURCE_LOCATION_FINDING.matches(formattedString)) {
            Map matchMap = ORGANIZATION_SOURCE_LOCATION_FINDING.match(formattedString);
            return FindingName.ofOrganizationSourceLocationFindingName((String)matchMap.get("organization"), (String)matchMap.get("source"), (String)matchMap.get("location"), (String)matchMap.get("finding"));
        }
        if (FOLDER_SOURCE_FINDING.matches(formattedString)) {
            Map matchMap = FOLDER_SOURCE_FINDING.match(formattedString);
            return FindingName.ofFolderSourceFindingName((String)matchMap.get("folder"), (String)matchMap.get("source"), (String)matchMap.get("finding"));
        }
        if (FOLDER_SOURCE_LOCATION_FINDING.matches(formattedString)) {
            Map matchMap = FOLDER_SOURCE_LOCATION_FINDING.match(formattedString);
            return FindingName.ofFolderSourceLocationFindingName((String)matchMap.get("folder"), (String)matchMap.get("source"), (String)matchMap.get("location"), (String)matchMap.get("finding"));
        }
        if (PROJECT_SOURCE_FINDING.matches(formattedString)) {
            Map matchMap = PROJECT_SOURCE_FINDING.match(formattedString);
            return FindingName.ofProjectSourceFindingName((String)matchMap.get("project"), (String)matchMap.get("source"), (String)matchMap.get("finding"));
        }
        if (PROJECT_SOURCE_LOCATION_FINDING.matches(formattedString)) {
            Map matchMap = PROJECT_SOURCE_LOCATION_FINDING.match(formattedString);
            return FindingName.ofProjectSourceLocationFindingName((String)matchMap.get("project"), (String)matchMap.get("source"), (String)matchMap.get("location"), (String)matchMap.get("finding"));
        }
        throw new ValidationException("FindingName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<FindingName> parseList(List<String> formattedStrings) {
        ArrayList<FindingName> list = new ArrayList<FindingName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(FindingName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<FindingName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (FindingName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_SOURCE_FINDING.matches(formattedString) || ORGANIZATION_SOURCE_LOCATION_FINDING.matches(formattedString) || FOLDER_SOURCE_FINDING.matches(formattedString) || FOLDER_SOURCE_LOCATION_FINDING.matches(formattedString) || PROJECT_SOURCE_FINDING.matches(formattedString) || PROJECT_SOURCE_LOCATION_FINDING.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            FindingName findingName = this;
            synchronized (findingName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.source != null) {
                        fieldMapBuilder.put((Object)"source", (Object)this.source);
                    }
                    if (this.finding != null) {
                        fieldMapBuilder.put((Object)"finding", (Object)this.finding);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put((Object)"folder", (Object)this.folder);
                    }
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            FindingName that = (FindingName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.source, that.source) && Objects.equals(this.finding, that.finding) && Objects.equals(this.location, that.location) && Objects.equals(this.folder, that.folder) && Objects.equals(this.project, that.project);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.source);
        h *= 1000003;
        h ^= Objects.hashCode(this.finding);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.folder);
        h *= 1000003;
        return h ^= Objects.hashCode(this.project);
    }

    public static class ProjectSourceLocationFindingBuilder {
        private String project;
        private String source;
        private String location;
        private String finding;

        protected ProjectSourceLocationFindingBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getSource() {
            return this.source;
        }

        public String getLocation() {
            return this.location;
        }

        public String getFinding() {
            return this.finding;
        }

        public ProjectSourceLocationFindingBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectSourceLocationFindingBuilder setSource(String source) {
            this.source = source;
            return this;
        }

        public ProjectSourceLocationFindingBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectSourceLocationFindingBuilder setFinding(String finding) {
            this.finding = finding;
            return this;
        }

        public FindingName build() {
            return new FindingName(this);
        }
    }

    public static class ProjectSourceFindingBuilder {
        private String project;
        private String source;
        private String finding;

        protected ProjectSourceFindingBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getSource() {
            return this.source;
        }

        public String getFinding() {
            return this.finding;
        }

        public ProjectSourceFindingBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectSourceFindingBuilder setSource(String source) {
            this.source = source;
            return this;
        }

        public ProjectSourceFindingBuilder setFinding(String finding) {
            this.finding = finding;
            return this;
        }

        public FindingName build() {
            return new FindingName(this);
        }
    }

    public static class FolderSourceLocationFindingBuilder {
        private String folder;
        private String source;
        private String location;
        private String finding;

        protected FolderSourceLocationFindingBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getSource() {
            return this.source;
        }

        public String getLocation() {
            return this.location;
        }

        public String getFinding() {
            return this.finding;
        }

        public FolderSourceLocationFindingBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderSourceLocationFindingBuilder setSource(String source) {
            this.source = source;
            return this;
        }

        public FolderSourceLocationFindingBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public FolderSourceLocationFindingBuilder setFinding(String finding) {
            this.finding = finding;
            return this;
        }

        public FindingName build() {
            return new FindingName(this);
        }
    }

    public static class FolderSourceFindingBuilder {
        private String folder;
        private String source;
        private String finding;

        protected FolderSourceFindingBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getSource() {
            return this.source;
        }

        public String getFinding() {
            return this.finding;
        }

        public FolderSourceFindingBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderSourceFindingBuilder setSource(String source) {
            this.source = source;
            return this;
        }

        public FolderSourceFindingBuilder setFinding(String finding) {
            this.finding = finding;
            return this;
        }

        public FindingName build() {
            return new FindingName(this);
        }
    }

    public static class OrganizationSourceLocationFindingBuilder {
        private String organization;
        private String source;
        private String location;
        private String finding;

        protected OrganizationSourceLocationFindingBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getSource() {
            return this.source;
        }

        public String getLocation() {
            return this.location;
        }

        public String getFinding() {
            return this.finding;
        }

        public OrganizationSourceLocationFindingBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public OrganizationSourceLocationFindingBuilder setSource(String source) {
            this.source = source;
            return this;
        }

        public OrganizationSourceLocationFindingBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public OrganizationSourceLocationFindingBuilder setFinding(String finding) {
            this.finding = finding;
            return this;
        }

        public FindingName build() {
            return new FindingName(this);
        }
    }

    public static class Builder {
        private String organization;
        private String source;
        private String finding;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getSource() {
            return this.source;
        }

        public String getFinding() {
            return this.finding;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setSource(String source) {
            this.source = source;
            return this;
        }

        public Builder setFinding(String finding) {
            this.finding = finding;
            return this;
        }

        private Builder(FindingName findingName) {
            Preconditions.checkArgument((boolean)Objects.equals(findingName.pathTemplate, ORGANIZATION_SOURCE_FINDING), (Object)"toBuilder is only supported when FindingName has the pattern of organizations/{organization}/sources/{source}/findings/{finding}");
            this.organization = findingName.organization;
            this.source = findingName.source;
            this.finding = findingName.finding;
        }

        public FindingName build() {
            return new FindingName(this);
        }
    }
}

