/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.securitycenter.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AttackPathName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_SIMULATION_VALUED_RESOURCE_ATTACK_PATH = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/simulations/{simulation}/valuedResources/{valued_resource}/attackPaths/{attack_path}");
    private volatile Map<String, String> fieldValuesMap;
    private final String organization;
    private final String simulation;
    private final String valuedResource;
    private final String attackPath;

    @Deprecated
    protected AttackPathName() {
        this.organization = null;
        this.simulation = null;
        this.valuedResource = null;
        this.attackPath = null;
    }

    private AttackPathName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.simulation = (String)Preconditions.checkNotNull((Object)builder.getSimulation());
        this.valuedResource = (String)Preconditions.checkNotNull((Object)builder.getValuedResource());
        this.attackPath = (String)Preconditions.checkNotNull((Object)builder.getAttackPath());
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getSimulation() {
        return this.simulation;
    }

    public String getValuedResource() {
        return this.valuedResource;
    }

    public String getAttackPath() {
        return this.attackPath;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AttackPathName of(String organization, String simulation, String valuedResource, String attackPath) {
        return AttackPathName.newBuilder().setOrganization(organization).setSimulation(simulation).setValuedResource(valuedResource).setAttackPath(attackPath).build();
    }

    public static String format(String organization, String simulation, String valuedResource, String attackPath) {
        return AttackPathName.newBuilder().setOrganization(organization).setSimulation(simulation).setValuedResource(valuedResource).setAttackPath(attackPath).build().toString();
    }

    public static AttackPathName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = ORGANIZATION_SIMULATION_VALUED_RESOURCE_ATTACK_PATH.validatedMatch(formattedString, "AttackPathName.parse: formattedString not in valid format");
        return AttackPathName.of((String)matchMap.get("organization"), (String)matchMap.get("simulation"), (String)matchMap.get("valued_resource"), (String)matchMap.get("attack_path"));
    }

    public static List<AttackPathName> parseList(List<String> formattedStrings) {
        ArrayList<AttackPathName> list = new ArrayList<AttackPathName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AttackPathName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AttackPathName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AttackPathName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_SIMULATION_VALUED_RESOURCE_ATTACK_PATH.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AttackPathName attackPathName = this;
            synchronized (attackPathName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.simulation != null) {
                        fieldMapBuilder.put((Object)"simulation", (Object)this.simulation);
                    }
                    if (this.valuedResource != null) {
                        fieldMapBuilder.put((Object)"valued_resource", (Object)this.valuedResource);
                    }
                    if (this.attackPath != null) {
                        fieldMapBuilder.put((Object)"attack_path", (Object)this.attackPath);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return ORGANIZATION_SIMULATION_VALUED_RESOURCE_ATTACK_PATH.instantiate(new String[]{"organization", this.organization, "simulation", this.simulation, "valued_resource", this.valuedResource, "attack_path", this.attackPath});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AttackPathName that = (AttackPathName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.simulation, that.simulation) && Objects.equals(this.valuedResource, that.valuedResource) && Objects.equals(this.attackPath, that.attackPath);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.simulation);
        h *= 1000003;
        h ^= Objects.hashCode(this.valuedResource);
        h *= 1000003;
        return h ^= Objects.hashCode(this.attackPath);
    }

    public static class Builder {
        private String organization;
        private String simulation;
        private String valuedResource;
        private String attackPath;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getSimulation() {
            return this.simulation;
        }

        public String getValuedResource() {
            return this.valuedResource;
        }

        public String getAttackPath() {
            return this.attackPath;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setSimulation(String simulation) {
            this.simulation = simulation;
            return this;
        }

        public Builder setValuedResource(String valuedResource) {
            this.valuedResource = valuedResource;
            return this;
        }

        public Builder setAttackPath(String attackPath) {
            this.attackPath = attackPath;
            return this;
        }

        private Builder(AttackPathName attackPathName) {
            this.organization = attackPathName.organization;
            this.simulation = attackPathName.simulation;
            this.valuedResource = attackPathName.valuedResource;
            this.attackPath = attackPathName.attackPath;
        }

        public AttackPathName build() {
            return new AttackPathName(this);
        }
    }
}

