/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.securitycenter.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SecurityHealthAnalyticsSettingsName
implements ResourceName {
    private static final PathTemplate ORGANIZATION = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/securityHealthAnalyticsSettings");
    private static final PathTemplate FOLDER = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/securityHealthAnalyticsSettings");
    private static final PathTemplate PROJECT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/securityHealthAnalyticsSettings");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String organization;
    private final String folder;
    private final String project;

    @Deprecated
    protected SecurityHealthAnalyticsSettingsName() {
        this.organization = null;
        this.folder = null;
        this.project = null;
    }

    private SecurityHealthAnalyticsSettingsName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.folder = null;
        this.project = null;
        this.pathTemplate = ORGANIZATION;
    }

    private SecurityHealthAnalyticsSettingsName(FolderBuilder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.organization = null;
        this.project = null;
        this.pathTemplate = FOLDER;
    }

    private SecurityHealthAnalyticsSettingsName(ProjectBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.organization = null;
        this.folder = null;
        this.pathTemplate = PROJECT;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getProject() {
        return this.project;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newOrganizationBuilder() {
        return new Builder();
    }

    public static FolderBuilder newFolderBuilder() {
        return new FolderBuilder();
    }

    public static ProjectBuilder newProjectBuilder() {
        return new ProjectBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SecurityHealthAnalyticsSettingsName of(String organization) {
        return SecurityHealthAnalyticsSettingsName.newBuilder().setOrganization(organization).build();
    }

    public static SecurityHealthAnalyticsSettingsName ofOrganizationName(String organization) {
        return SecurityHealthAnalyticsSettingsName.newBuilder().setOrganization(organization).build();
    }

    public static SecurityHealthAnalyticsSettingsName ofFolderName(String folder) {
        return SecurityHealthAnalyticsSettingsName.newFolderBuilder().setFolder(folder).build();
    }

    public static SecurityHealthAnalyticsSettingsName ofProjectName(String project) {
        return SecurityHealthAnalyticsSettingsName.newProjectBuilder().setProject(project).build();
    }

    public static String format(String organization) {
        return SecurityHealthAnalyticsSettingsName.newBuilder().setOrganization(organization).build().toString();
    }

    public static String formatOrganizationName(String organization) {
        return SecurityHealthAnalyticsSettingsName.newBuilder().setOrganization(organization).build().toString();
    }

    public static String formatFolderName(String folder) {
        return SecurityHealthAnalyticsSettingsName.newFolderBuilder().setFolder(folder).build().toString();
    }

    public static String formatProjectName(String project) {
        return SecurityHealthAnalyticsSettingsName.newProjectBuilder().setProject(project).build().toString();
    }

    public static SecurityHealthAnalyticsSettingsName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (ORGANIZATION.matches(formattedString)) {
            Map matchMap = ORGANIZATION.match(formattedString);
            return SecurityHealthAnalyticsSettingsName.ofOrganizationName((String)matchMap.get("organization"));
        }
        if (FOLDER.matches(formattedString)) {
            Map matchMap = FOLDER.match(formattedString);
            return SecurityHealthAnalyticsSettingsName.ofFolderName((String)matchMap.get("folder"));
        }
        if (PROJECT.matches(formattedString)) {
            Map matchMap = PROJECT.match(formattedString);
            return SecurityHealthAnalyticsSettingsName.ofProjectName((String)matchMap.get("project"));
        }
        throw new ValidationException("SecurityHealthAnalyticsSettingsName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<SecurityHealthAnalyticsSettingsName> parseList(List<String> formattedStrings) {
        ArrayList<SecurityHealthAnalyticsSettingsName> list = new ArrayList<SecurityHealthAnalyticsSettingsName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SecurityHealthAnalyticsSettingsName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SecurityHealthAnalyticsSettingsName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SecurityHealthAnalyticsSettingsName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION.matches(formattedString) || FOLDER.matches(formattedString) || PROJECT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SecurityHealthAnalyticsSettingsName securityHealthAnalyticsSettingsName = this;
            synchronized (securityHealthAnalyticsSettingsName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put((Object)"folder", (Object)this.folder);
                    }
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            SecurityHealthAnalyticsSettingsName that = (SecurityHealthAnalyticsSettingsName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.folder, that.folder) && Objects.equals(this.project, that.project);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.folder);
        h *= 1000003;
        return h ^= Objects.hashCode(this.project);
    }

    public static class ProjectBuilder {
        private String project;

        protected ProjectBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public ProjectBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public SecurityHealthAnalyticsSettingsName build() {
            return new SecurityHealthAnalyticsSettingsName(this);
        }
    }

    public static class FolderBuilder {
        private String folder;

        protected FolderBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public FolderBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public SecurityHealthAnalyticsSettingsName build() {
            return new SecurityHealthAnalyticsSettingsName(this);
        }
    }

    public static class Builder {
        private String organization;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        private Builder(SecurityHealthAnalyticsSettingsName securityHealthAnalyticsSettingsName) {
            Preconditions.checkArgument((boolean)Objects.equals(securityHealthAnalyticsSettingsName.pathTemplate, ORGANIZATION), (Object)"toBuilder is only supported when SecurityHealthAnalyticsSettingsName has the pattern of organizations/{organization}/securityHealthAnalyticsSettings");
            this.organization = securityHealthAnalyticsSettingsName.organization;
        }

        public SecurityHealthAnalyticsSettingsName build() {
            return new SecurityHealthAnalyticsSettingsName(this);
        }
    }
}

