/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.securitycenter.v1;

import com.google.cloud.securitycenter.v1.CveOrBuilder;
import com.google.cloud.securitycenter.v1.Cvssv3;
import com.google.cloud.securitycenter.v1.Cvssv3OrBuilder;
import com.google.cloud.securitycenter.v1.Reference;
import com.google.cloud.securitycenter.v1.ReferenceOrBuilder;
import com.google.cloud.securitycenter.v1.VulnerabilityProto;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.Timestamp;
import com.google.protobuf.TimestampOrBuilder;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Cve
extends GeneratedMessageV3
implements CveOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int ID_FIELD_NUMBER = 1;
    private volatile Object id_ = "";
    public static final int REFERENCES_FIELD_NUMBER = 2;
    private List<Reference> references_;
    public static final int CVSSV3_FIELD_NUMBER = 3;
    private Cvssv3 cvssv3_;
    public static final int UPSTREAM_FIX_AVAILABLE_FIELD_NUMBER = 4;
    private boolean upstreamFixAvailable_ = false;
    public static final int IMPACT_FIELD_NUMBER = 5;
    private int impact_ = 0;
    public static final int EXPLOITATION_ACTIVITY_FIELD_NUMBER = 6;
    private int exploitationActivity_ = 0;
    public static final int OBSERVED_IN_THE_WILD_FIELD_NUMBER = 7;
    private boolean observedInTheWild_ = false;
    public static final int ZERO_DAY_FIELD_NUMBER = 8;
    private boolean zeroDay_ = false;
    public static final int EXPLOIT_RELEASE_DATE_FIELD_NUMBER = 9;
    private Timestamp exploitReleaseDate_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final Cve DEFAULT_INSTANCE = new Cve();
    private static final Parser<Cve> PARSER = new AbstractParser<Cve>(){

        public Cve parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = Cve.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private Cve(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private Cve() {
        this.id_ = "";
        this.references_ = Collections.emptyList();
        this.impact_ = 0;
        this.exploitationActivity_ = 0;
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new Cve();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return VulnerabilityProto.internal_static_google_cloud_securitycenter_v1_Cve_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return VulnerabilityProto.internal_static_google_cloud_securitycenter_v1_Cve_fieldAccessorTable.ensureFieldAccessorsInitialized(Cve.class, Builder.class);
    }

    @Override
    public String getId() {
        Object ref = this.id_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.id_ = s;
        return s;
    }

    @Override
    public ByteString getIdBytes() {
        Object ref = this.id_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.id_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public List<Reference> getReferencesList() {
        return this.references_;
    }

    @Override
    public List<? extends ReferenceOrBuilder> getReferencesOrBuilderList() {
        return this.references_;
    }

    @Override
    public int getReferencesCount() {
        return this.references_.size();
    }

    @Override
    public Reference getReferences(int index) {
        return this.references_.get(index);
    }

    @Override
    public ReferenceOrBuilder getReferencesOrBuilder(int index) {
        return this.references_.get(index);
    }

    @Override
    public boolean hasCvssv3() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public Cvssv3 getCvssv3() {
        return this.cvssv3_ == null ? Cvssv3.getDefaultInstance() : this.cvssv3_;
    }

    @Override
    public Cvssv3OrBuilder getCvssv3OrBuilder() {
        return this.cvssv3_ == null ? Cvssv3.getDefaultInstance() : this.cvssv3_;
    }

    @Override
    public boolean getUpstreamFixAvailable() {
        return this.upstreamFixAvailable_;
    }

    @Override
    public int getImpactValue() {
        return this.impact_;
    }

    @Override
    public RiskRating getImpact() {
        RiskRating result = RiskRating.forNumber(this.impact_);
        return result == null ? RiskRating.UNRECOGNIZED : result;
    }

    @Override
    public int getExploitationActivityValue() {
        return this.exploitationActivity_;
    }

    @Override
    public ExploitationActivity getExploitationActivity() {
        ExploitationActivity result = ExploitationActivity.forNumber(this.exploitationActivity_);
        return result == null ? ExploitationActivity.UNRECOGNIZED : result;
    }

    @Override
    public boolean getObservedInTheWild() {
        return this.observedInTheWild_;
    }

    @Override
    public boolean getZeroDay() {
        return this.zeroDay_;
    }

    @Override
    public boolean hasExploitReleaseDate() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public Timestamp getExploitReleaseDate() {
        return this.exploitReleaseDate_ == null ? Timestamp.getDefaultInstance() : this.exploitReleaseDate_;
    }

    @Override
    public TimestampOrBuilder getExploitReleaseDateOrBuilder() {
        return this.exploitReleaseDate_ == null ? Timestamp.getDefaultInstance() : this.exploitReleaseDate_;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        if (!GeneratedMessageV3.isStringEmpty((Object)this.id_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.id_);
        }
        for (int i = 0; i < this.references_.size(); ++i) {
            output.writeMessage(2, (MessageLite)this.references_.get(i));
        }
        if ((this.bitField0_ & 1) != 0) {
            output.writeMessage(3, (MessageLite)this.getCvssv3());
        }
        if (this.upstreamFixAvailable_) {
            output.writeBool(4, this.upstreamFixAvailable_);
        }
        if (this.impact_ != RiskRating.RISK_RATING_UNSPECIFIED.getNumber()) {
            output.writeEnum(5, this.impact_);
        }
        if (this.exploitationActivity_ != ExploitationActivity.EXPLOITATION_ACTIVITY_UNSPECIFIED.getNumber()) {
            output.writeEnum(6, this.exploitationActivity_);
        }
        if (this.observedInTheWild_) {
            output.writeBool(7, this.observedInTheWild_);
        }
        if (this.zeroDay_) {
            output.writeBool(8, this.zeroDay_);
        }
        if ((this.bitField0_ & 2) != 0) {
            output.writeMessage(9, (MessageLite)this.getExploitReleaseDate());
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.id_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.id_);
        }
        for (int i = 0; i < this.references_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)2, (MessageLite)((MessageLite)this.references_.get(i)));
        }
        if ((this.bitField0_ & 1) != 0) {
            size += CodedOutputStream.computeMessageSize((int)3, (MessageLite)this.getCvssv3());
        }
        if (this.upstreamFixAvailable_) {
            size += CodedOutputStream.computeBoolSize((int)4, (boolean)this.upstreamFixAvailable_);
        }
        if (this.impact_ != RiskRating.RISK_RATING_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)5, (int)this.impact_);
        }
        if (this.exploitationActivity_ != ExploitationActivity.EXPLOITATION_ACTIVITY_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)6, (int)this.exploitationActivity_);
        }
        if (this.observedInTheWild_) {
            size += CodedOutputStream.computeBoolSize((int)7, (boolean)this.observedInTheWild_);
        }
        if (this.zeroDay_) {
            size += CodedOutputStream.computeBoolSize((int)8, (boolean)this.zeroDay_);
        }
        if ((this.bitField0_ & 2) != 0) {
            size += CodedOutputStream.computeMessageSize((int)9, (MessageLite)this.getExploitReleaseDate());
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Cve)) {
            return super.equals(obj);
        }
        Cve other = (Cve)obj;
        if (!this.getId().equals(other.getId())) {
            return false;
        }
        if (!this.getReferencesList().equals(other.getReferencesList())) {
            return false;
        }
        if (this.hasCvssv3() != other.hasCvssv3()) {
            return false;
        }
        if (this.hasCvssv3() && !this.getCvssv3().equals(other.getCvssv3())) {
            return false;
        }
        if (this.getUpstreamFixAvailable() != other.getUpstreamFixAvailable()) {
            return false;
        }
        if (this.impact_ != other.impact_) {
            return false;
        }
        if (this.exploitationActivity_ != other.exploitationActivity_) {
            return false;
        }
        if (this.getObservedInTheWild() != other.getObservedInTheWild()) {
            return false;
        }
        if (this.getZeroDay() != other.getZeroDay()) {
            return false;
        }
        if (this.hasExploitReleaseDate() != other.hasExploitReleaseDate()) {
            return false;
        }
        if (this.hasExploitReleaseDate() && !this.getExploitReleaseDate().equals((Object)other.getExploitReleaseDate())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + Cve.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getId().hashCode();
        if (this.getReferencesCount() > 0) {
            hash = 37 * hash + 2;
            hash = 53 * hash + this.getReferencesList().hashCode();
        }
        if (this.hasCvssv3()) {
            hash = 37 * hash + 3;
            hash = 53 * hash + this.getCvssv3().hashCode();
        }
        hash = 37 * hash + 4;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getUpstreamFixAvailable());
        hash = 37 * hash + 5;
        hash = 53 * hash + this.impact_;
        hash = 37 * hash + 6;
        hash = 53 * hash + this.exploitationActivity_;
        hash = 37 * hash + 7;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getObservedInTheWild());
        hash = 37 * hash + 8;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getZeroDay());
        if (this.hasExploitReleaseDate()) {
            hash = 37 * hash + 9;
            hash = 53 * hash + this.getExploitReleaseDate().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static Cve parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (Cve)PARSER.parseFrom(data);
    }

    public static Cve parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Cve)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Cve parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (Cve)PARSER.parseFrom(data);
    }

    public static Cve parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Cve)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Cve parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (Cve)PARSER.parseFrom(data);
    }

    public static Cve parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Cve)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Cve parseFrom(InputStream input) throws IOException {
        return (Cve)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static Cve parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Cve)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Cve parseDelimitedFrom(InputStream input) throws IOException {
        return (Cve)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static Cve parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Cve)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Cve parseFrom(CodedInputStream input) throws IOException {
        return (Cve)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static Cve parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Cve)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return Cve.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Cve prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static Cve getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<Cve> parser() {
        return PARSER;
    }

    public Parser<Cve> getParserForType() {
        return PARSER;
    }

    public Cve getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements CveOrBuilder {
        private int bitField0_;
        private Object id_ = "";
        private List<Reference> references_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<Reference, Reference.Builder, ReferenceOrBuilder> referencesBuilder_;
        private Cvssv3 cvssv3_;
        private SingleFieldBuilderV3<Cvssv3, Cvssv3.Builder, Cvssv3OrBuilder> cvssv3Builder_;
        private boolean upstreamFixAvailable_;
        private int impact_ = 0;
        private int exploitationActivity_ = 0;
        private boolean observedInTheWild_;
        private boolean zeroDay_;
        private Timestamp exploitReleaseDate_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> exploitReleaseDateBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return VulnerabilityProto.internal_static_google_cloud_securitycenter_v1_Cve_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return VulnerabilityProto.internal_static_google_cloud_securitycenter_v1_Cve_fieldAccessorTable.ensureFieldAccessorsInitialized(Cve.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getReferencesFieldBuilder();
                this.getCvssv3FieldBuilder();
                this.getExploitReleaseDateFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.id_ = "";
            if (this.referencesBuilder_ == null) {
                this.references_ = Collections.emptyList();
            } else {
                this.references_ = null;
                this.referencesBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFFD;
            this.cvssv3_ = null;
            if (this.cvssv3Builder_ != null) {
                this.cvssv3Builder_.dispose();
                this.cvssv3Builder_ = null;
            }
            this.upstreamFixAvailable_ = false;
            this.impact_ = 0;
            this.exploitationActivity_ = 0;
            this.observedInTheWild_ = false;
            this.zeroDay_ = false;
            this.exploitReleaseDate_ = null;
            if (this.exploitReleaseDateBuilder_ != null) {
                this.exploitReleaseDateBuilder_.dispose();
                this.exploitReleaseDateBuilder_ = null;
            }
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return VulnerabilityProto.internal_static_google_cloud_securitycenter_v1_Cve_descriptor;
        }

        public Cve getDefaultInstanceForType() {
            return Cve.getDefaultInstance();
        }

        public Cve build() {
            Cve result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public Cve buildPartial() {
            Cve result = new Cve(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(Cve result) {
            if (this.referencesBuilder_ == null) {
                if ((this.bitField0_ & 2) != 0) {
                    this.references_ = Collections.unmodifiableList(this.references_);
                    this.bitField0_ &= 0xFFFFFFFD;
                }
                result.references_ = this.references_;
            } else {
                result.references_ = this.referencesBuilder_.build();
            }
        }

        private void buildPartial0(Cve result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.id_ = this.id_;
            }
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 4) != 0) {
                result.cvssv3_ = this.cvssv3Builder_ == null ? this.cvssv3_ : (Cvssv3)this.cvssv3Builder_.build();
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.upstreamFixAvailable_ = this.upstreamFixAvailable_;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.impact_ = this.impact_;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.exploitationActivity_ = this.exploitationActivity_;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.observedInTheWild_ = this.observedInTheWild_;
            }
            if ((from_bitField0_ & 0x80) != 0) {
                result.zeroDay_ = this.zeroDay_;
            }
            if ((from_bitField0_ & 0x100) != 0) {
                result.exploitReleaseDate_ = this.exploitReleaseDateBuilder_ == null ? this.exploitReleaseDate_ : (Timestamp)this.exploitReleaseDateBuilder_.build();
                to_bitField0_ |= 2;
            }
            Cve cve = result;
            cve.bitField0_ = cve.bitField0_ | to_bitField0_;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof Cve) {
                return this.mergeFrom((Cve)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(Cve other) {
            if (other == Cve.getDefaultInstance()) {
                return this;
            }
            if (!other.getId().isEmpty()) {
                this.id_ = other.id_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (this.referencesBuilder_ == null) {
                if (!other.references_.isEmpty()) {
                    if (this.references_.isEmpty()) {
                        this.references_ = other.references_;
                        this.bitField0_ &= 0xFFFFFFFD;
                    } else {
                        this.ensureReferencesIsMutable();
                        this.references_.addAll(other.references_);
                    }
                    this.onChanged();
                }
            } else if (!other.references_.isEmpty()) {
                if (this.referencesBuilder_.isEmpty()) {
                    this.referencesBuilder_.dispose();
                    this.referencesBuilder_ = null;
                    this.references_ = other.references_;
                    this.bitField0_ &= 0xFFFFFFFD;
                    this.referencesBuilder_ = alwaysUseFieldBuilders ? this.getReferencesFieldBuilder() : null;
                } else {
                    this.referencesBuilder_.addAllMessages((Iterable)other.references_);
                }
            }
            if (other.hasCvssv3()) {
                this.mergeCvssv3(other.getCvssv3());
            }
            if (other.getUpstreamFixAvailable()) {
                this.setUpstreamFixAvailable(other.getUpstreamFixAvailable());
            }
            if (other.impact_ != 0) {
                this.setImpactValue(other.getImpactValue());
            }
            if (other.exploitationActivity_ != 0) {
                this.setExploitationActivityValue(other.getExploitationActivityValue());
            }
            if (other.getObservedInTheWild()) {
                this.setObservedInTheWild(other.getObservedInTheWild());
            }
            if (other.getZeroDay()) {
                this.setZeroDay(other.getZeroDay());
            }
            if (other.hasExploitReleaseDate()) {
                this.mergeExploitReleaseDate(other.getExploitReleaseDate());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block17: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block17;
                        }
                        case 10: {
                            this.id_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block17;
                        }
                        case 18: {
                            Reference m = (Reference)input.readMessage(Reference.parser(), extensionRegistry);
                            if (this.referencesBuilder_ == null) {
                                this.ensureReferencesIsMutable();
                                this.references_.add(m);
                                continue block17;
                            }
                            this.referencesBuilder_.addMessage((AbstractMessage)m);
                            continue block17;
                        }
                        case 26: {
                            input.readMessage((MessageLite.Builder)this.getCvssv3FieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 4;
                            continue block17;
                        }
                        case 32: {
                            this.upstreamFixAvailable_ = input.readBool();
                            this.bitField0_ |= 8;
                            continue block17;
                        }
                        case 40: {
                            this.impact_ = input.readEnum();
                            this.bitField0_ |= 0x10;
                            continue block17;
                        }
                        case 48: {
                            this.exploitationActivity_ = input.readEnum();
                            this.bitField0_ |= 0x20;
                            continue block17;
                        }
                        case 56: {
                            this.observedInTheWild_ = input.readBool();
                            this.bitField0_ |= 0x40;
                            continue block17;
                        }
                        case 64: {
                            this.zeroDay_ = input.readBool();
                            this.bitField0_ |= 0x80;
                            continue block17;
                        }
                        case 74: {
                            input.readMessage((MessageLite.Builder)this.getExploitReleaseDateFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x100;
                            continue block17;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getId() {
            Object ref = this.id_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.id_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getIdBytes() {
            Object ref = this.id_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.id_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.id_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearId() {
            this.id_ = Cve.getDefaultInstance().getId();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Cve.checkByteStringIsUtf8((ByteString)value);
            this.id_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        private void ensureReferencesIsMutable() {
            if ((this.bitField0_ & 2) == 0) {
                this.references_ = new ArrayList<Reference>(this.references_);
                this.bitField0_ |= 2;
            }
        }

        @Override
        public List<Reference> getReferencesList() {
            if (this.referencesBuilder_ == null) {
                return Collections.unmodifiableList(this.references_);
            }
            return this.referencesBuilder_.getMessageList();
        }

        @Override
        public int getReferencesCount() {
            if (this.referencesBuilder_ == null) {
                return this.references_.size();
            }
            return this.referencesBuilder_.getCount();
        }

        @Override
        public Reference getReferences(int index) {
            if (this.referencesBuilder_ == null) {
                return this.references_.get(index);
            }
            return (Reference)this.referencesBuilder_.getMessage(index);
        }

        public Builder setReferences(int index, Reference value) {
            if (this.referencesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureReferencesIsMutable();
                this.references_.set(index, value);
                this.onChanged();
            } else {
                this.referencesBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setReferences(int index, Reference.Builder builderForValue) {
            if (this.referencesBuilder_ == null) {
                this.ensureReferencesIsMutable();
                this.references_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.referencesBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addReferences(Reference value) {
            if (this.referencesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureReferencesIsMutable();
                this.references_.add(value);
                this.onChanged();
            } else {
                this.referencesBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addReferences(int index, Reference value) {
            if (this.referencesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureReferencesIsMutable();
                this.references_.add(index, value);
                this.onChanged();
            } else {
                this.referencesBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addReferences(Reference.Builder builderForValue) {
            if (this.referencesBuilder_ == null) {
                this.ensureReferencesIsMutable();
                this.references_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.referencesBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addReferences(int index, Reference.Builder builderForValue) {
            if (this.referencesBuilder_ == null) {
                this.ensureReferencesIsMutable();
                this.references_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.referencesBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllReferences(Iterable<? extends Reference> values) {
            if (this.referencesBuilder_ == null) {
                this.ensureReferencesIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.references_);
                this.onChanged();
            } else {
                this.referencesBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearReferences() {
            if (this.referencesBuilder_ == null) {
                this.references_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFD;
                this.onChanged();
            } else {
                this.referencesBuilder_.clear();
            }
            return this;
        }

        public Builder removeReferences(int index) {
            if (this.referencesBuilder_ == null) {
                this.ensureReferencesIsMutable();
                this.references_.remove(index);
                this.onChanged();
            } else {
                this.referencesBuilder_.remove(index);
            }
            return this;
        }

        public Reference.Builder getReferencesBuilder(int index) {
            return (Reference.Builder)this.getReferencesFieldBuilder().getBuilder(index);
        }

        @Override
        public ReferenceOrBuilder getReferencesOrBuilder(int index) {
            if (this.referencesBuilder_ == null) {
                return this.references_.get(index);
            }
            return (ReferenceOrBuilder)this.referencesBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends ReferenceOrBuilder> getReferencesOrBuilderList() {
            if (this.referencesBuilder_ != null) {
                return this.referencesBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.references_);
        }

        public Reference.Builder addReferencesBuilder() {
            return (Reference.Builder)this.getReferencesFieldBuilder().addBuilder((AbstractMessage)Reference.getDefaultInstance());
        }

        public Reference.Builder addReferencesBuilder(int index) {
            return (Reference.Builder)this.getReferencesFieldBuilder().addBuilder(index, (AbstractMessage)Reference.getDefaultInstance());
        }

        public List<Reference.Builder> getReferencesBuilderList() {
            return this.getReferencesFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<Reference, Reference.Builder, ReferenceOrBuilder> getReferencesFieldBuilder() {
            if (this.referencesBuilder_ == null) {
                this.referencesBuilder_ = new RepeatedFieldBuilderV3(this.references_, (this.bitField0_ & 2) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.references_ = null;
            }
            return this.referencesBuilder_;
        }

        @Override
        public boolean hasCvssv3() {
            return (this.bitField0_ & 4) != 0;
        }

        @Override
        public Cvssv3 getCvssv3() {
            if (this.cvssv3Builder_ == null) {
                return this.cvssv3_ == null ? Cvssv3.getDefaultInstance() : this.cvssv3_;
            }
            return (Cvssv3)this.cvssv3Builder_.getMessage();
        }

        public Builder setCvssv3(Cvssv3 value) {
            if (this.cvssv3Builder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.cvssv3_ = value;
            } else {
                this.cvssv3Builder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder setCvssv3(Cvssv3.Builder builderForValue) {
            if (this.cvssv3Builder_ == null) {
                this.cvssv3_ = builderForValue.build();
            } else {
                this.cvssv3Builder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder mergeCvssv3(Cvssv3 value) {
            if (this.cvssv3Builder_ == null) {
                if ((this.bitField0_ & 4) != 0 && this.cvssv3_ != null && this.cvssv3_ != Cvssv3.getDefaultInstance()) {
                    this.getCvssv3Builder().mergeFrom(value);
                } else {
                    this.cvssv3_ = value;
                }
            } else {
                this.cvssv3Builder_.mergeFrom((AbstractMessage)value);
            }
            if (this.cvssv3_ != null) {
                this.bitField0_ |= 4;
                this.onChanged();
            }
            return this;
        }

        public Builder clearCvssv3() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.cvssv3_ = null;
            if (this.cvssv3Builder_ != null) {
                this.cvssv3Builder_.dispose();
                this.cvssv3Builder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Cvssv3.Builder getCvssv3Builder() {
            this.bitField0_ |= 4;
            this.onChanged();
            return (Cvssv3.Builder)this.getCvssv3FieldBuilder().getBuilder();
        }

        @Override
        public Cvssv3OrBuilder getCvssv3OrBuilder() {
            if (this.cvssv3Builder_ != null) {
                return (Cvssv3OrBuilder)this.cvssv3Builder_.getMessageOrBuilder();
            }
            return this.cvssv3_ == null ? Cvssv3.getDefaultInstance() : this.cvssv3_;
        }

        private SingleFieldBuilderV3<Cvssv3, Cvssv3.Builder, Cvssv3OrBuilder> getCvssv3FieldBuilder() {
            if (this.cvssv3Builder_ == null) {
                this.cvssv3Builder_ = new SingleFieldBuilderV3((AbstractMessage)this.getCvssv3(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.cvssv3_ = null;
            }
            return this.cvssv3Builder_;
        }

        @Override
        public boolean getUpstreamFixAvailable() {
            return this.upstreamFixAvailable_;
        }

        public Builder setUpstreamFixAvailable(boolean value) {
            this.upstreamFixAvailable_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder clearUpstreamFixAvailable() {
            this.bitField0_ &= 0xFFFFFFF7;
            this.upstreamFixAvailable_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public int getImpactValue() {
            return this.impact_;
        }

        public Builder setImpactValue(int value) {
            this.impact_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        @Override
        public RiskRating getImpact() {
            RiskRating result = RiskRating.forNumber(this.impact_);
            return result == null ? RiskRating.UNRECOGNIZED : result;
        }

        public Builder setImpact(RiskRating value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x10;
            this.impact_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearImpact() {
            this.bitField0_ &= 0xFFFFFFEF;
            this.impact_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getExploitationActivityValue() {
            return this.exploitationActivity_;
        }

        public Builder setExploitationActivityValue(int value) {
            this.exploitationActivity_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        @Override
        public ExploitationActivity getExploitationActivity() {
            ExploitationActivity result = ExploitationActivity.forNumber(this.exploitationActivity_);
            return result == null ? ExploitationActivity.UNRECOGNIZED : result;
        }

        public Builder setExploitationActivity(ExploitationActivity value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x20;
            this.exploitationActivity_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearExploitationActivity() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.exploitationActivity_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean getObservedInTheWild() {
            return this.observedInTheWild_;
        }

        public Builder setObservedInTheWild(boolean value) {
            this.observedInTheWild_ = value;
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder clearObservedInTheWild() {
            this.bitField0_ &= 0xFFFFFFBF;
            this.observedInTheWild_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public boolean getZeroDay() {
            return this.zeroDay_;
        }

        public Builder setZeroDay(boolean value) {
            this.zeroDay_ = value;
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder clearZeroDay() {
            this.bitField0_ &= 0xFFFFFF7F;
            this.zeroDay_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasExploitReleaseDate() {
            return (this.bitField0_ & 0x100) != 0;
        }

        @Override
        public Timestamp getExploitReleaseDate() {
            if (this.exploitReleaseDateBuilder_ == null) {
                return this.exploitReleaseDate_ == null ? Timestamp.getDefaultInstance() : this.exploitReleaseDate_;
            }
            return (Timestamp)this.exploitReleaseDateBuilder_.getMessage();
        }

        public Builder setExploitReleaseDate(Timestamp value) {
            if (this.exploitReleaseDateBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.exploitReleaseDate_ = value;
            } else {
                this.exploitReleaseDateBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder setExploitReleaseDate(Timestamp.Builder builderForValue) {
            if (this.exploitReleaseDateBuilder_ == null) {
                this.exploitReleaseDate_ = builderForValue.build();
            } else {
                this.exploitReleaseDateBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder mergeExploitReleaseDate(Timestamp value) {
            if (this.exploitReleaseDateBuilder_ == null) {
                if ((this.bitField0_ & 0x100) != 0 && this.exploitReleaseDate_ != null && this.exploitReleaseDate_ != Timestamp.getDefaultInstance()) {
                    this.getExploitReleaseDateBuilder().mergeFrom(value);
                } else {
                    this.exploitReleaseDate_ = value;
                }
            } else {
                this.exploitReleaseDateBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.exploitReleaseDate_ != null) {
                this.bitField0_ |= 0x100;
                this.onChanged();
            }
            return this;
        }

        public Builder clearExploitReleaseDate() {
            this.bitField0_ &= 0xFFFFFEFF;
            this.exploitReleaseDate_ = null;
            if (this.exploitReleaseDateBuilder_ != null) {
                this.exploitReleaseDateBuilder_.dispose();
                this.exploitReleaseDateBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Timestamp.Builder getExploitReleaseDateBuilder() {
            this.bitField0_ |= 0x100;
            this.onChanged();
            return (Timestamp.Builder)this.getExploitReleaseDateFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getExploitReleaseDateOrBuilder() {
            if (this.exploitReleaseDateBuilder_ != null) {
                return (TimestampOrBuilder)this.exploitReleaseDateBuilder_.getMessageOrBuilder();
            }
            return this.exploitReleaseDate_ == null ? Timestamp.getDefaultInstance() : this.exploitReleaseDate_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getExploitReleaseDateFieldBuilder() {
            if (this.exploitReleaseDateBuilder_ == null) {
                this.exploitReleaseDateBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getExploitReleaseDate(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.exploitReleaseDate_ = null;
            }
            return this.exploitReleaseDateBuilder_;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static enum ExploitationActivity implements ProtocolMessageEnum
    {
        EXPLOITATION_ACTIVITY_UNSPECIFIED(0),
        WIDE(1),
        CONFIRMED(2),
        AVAILABLE(3),
        ANTICIPATED(4),
        NO_KNOWN(5),
        UNRECOGNIZED(-1);

        public static final int EXPLOITATION_ACTIVITY_UNSPECIFIED_VALUE = 0;
        public static final int WIDE_VALUE = 1;
        public static final int CONFIRMED_VALUE = 2;
        public static final int AVAILABLE_VALUE = 3;
        public static final int ANTICIPATED_VALUE = 4;
        public static final int NO_KNOWN_VALUE = 5;
        private static final Internal.EnumLiteMap<ExploitationActivity> internalValueMap;
        private static final ExploitationActivity[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static ExploitationActivity valueOf(int value) {
            return ExploitationActivity.forNumber(value);
        }

        public static ExploitationActivity forNumber(int value) {
            switch (value) {
                case 0: {
                    return EXPLOITATION_ACTIVITY_UNSPECIFIED;
                }
                case 1: {
                    return WIDE;
                }
                case 2: {
                    return CONFIRMED;
                }
                case 3: {
                    return AVAILABLE;
                }
                case 4: {
                    return ANTICIPATED;
                }
                case 5: {
                    return NO_KNOWN;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<ExploitationActivity> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)ExploitationActivity.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return ExploitationActivity.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)Cve.getDescriptor().getEnumTypes().get(1);
        }

        public static ExploitationActivity valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != ExploitationActivity.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private ExploitationActivity(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<ExploitationActivity>(){

                public ExploitationActivity findValueByNumber(int number) {
                    return ExploitationActivity.forNumber(number);
                }
            };
            VALUES = ExploitationActivity.values();
        }
    }

    public static enum RiskRating implements ProtocolMessageEnum
    {
        RISK_RATING_UNSPECIFIED(0),
        LOW(1),
        MEDIUM(2),
        HIGH(3),
        CRITICAL(4),
        UNRECOGNIZED(-1);

        public static final int RISK_RATING_UNSPECIFIED_VALUE = 0;
        public static final int LOW_VALUE = 1;
        public static final int MEDIUM_VALUE = 2;
        public static final int HIGH_VALUE = 3;
        public static final int CRITICAL_VALUE = 4;
        private static final Internal.EnumLiteMap<RiskRating> internalValueMap;
        private static final RiskRating[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static RiskRating valueOf(int value) {
            return RiskRating.forNumber(value);
        }

        public static RiskRating forNumber(int value) {
            switch (value) {
                case 0: {
                    return RISK_RATING_UNSPECIFIED;
                }
                case 1: {
                    return LOW;
                }
                case 2: {
                    return MEDIUM;
                }
                case 3: {
                    return HIGH;
                }
                case 4: {
                    return CRITICAL;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<RiskRating> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)RiskRating.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return RiskRating.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)Cve.getDescriptor().getEnumTypes().get(0);
        }

        public static RiskRating valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != RiskRating.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private RiskRating(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<RiskRating>(){

                public RiskRating findValueByNumber(int number) {
                    return RiskRating.forNumber(number);
                }
            };
            VALUES = RiskRating.values();
        }
    }
}

