/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.securitycenter.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class NotificationConfigName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_NOTIFICATION_CONFIG = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/notificationConfigs/{notification_config}");
    private static final PathTemplate FOLDER_NOTIFICATION_CONFIG = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/notificationConfigs/{notification_config}");
    private static final PathTemplate PROJECT_NOTIFICATION_CONFIG = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/notificationConfigs/{notification_config}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String organization;
    private final String notificationConfig;
    private final String folder;
    private final String project;

    @Deprecated
    protected NotificationConfigName() {
        this.organization = null;
        this.notificationConfig = null;
        this.folder = null;
        this.project = null;
    }

    private NotificationConfigName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.notificationConfig = (String)Preconditions.checkNotNull((Object)builder.getNotificationConfig());
        this.folder = null;
        this.project = null;
        this.pathTemplate = ORGANIZATION_NOTIFICATION_CONFIG;
    }

    private NotificationConfigName(FolderNotificationConfigBuilder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.notificationConfig = (String)Preconditions.checkNotNull((Object)builder.getNotificationConfig());
        this.organization = null;
        this.project = null;
        this.pathTemplate = FOLDER_NOTIFICATION_CONFIG;
    }

    private NotificationConfigName(ProjectNotificationConfigBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.notificationConfig = (String)Preconditions.checkNotNull((Object)builder.getNotificationConfig());
        this.organization = null;
        this.folder = null;
        this.pathTemplate = PROJECT_NOTIFICATION_CONFIG;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getNotificationConfig() {
        return this.notificationConfig;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getProject() {
        return this.project;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newOrganizationNotificationConfigBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static FolderNotificationConfigBuilder newFolderNotificationConfigBuilder() {
        return new FolderNotificationConfigBuilder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static ProjectNotificationConfigBuilder newProjectNotificationConfigBuilder() {
        return new ProjectNotificationConfigBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static NotificationConfigName of(String organization, String notificationConfig) {
        return NotificationConfigName.newBuilder().setOrganization(organization).setNotificationConfig(notificationConfig).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static NotificationConfigName ofOrganizationNotificationConfigName(String organization, String notificationConfig) {
        return NotificationConfigName.newBuilder().setOrganization(organization).setNotificationConfig(notificationConfig).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static NotificationConfigName ofFolderNotificationConfigName(String folder, String notificationConfig) {
        return NotificationConfigName.newFolderNotificationConfigBuilder().setFolder(folder).setNotificationConfig(notificationConfig).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static NotificationConfigName ofProjectNotificationConfigName(String project, String notificationConfig) {
        return NotificationConfigName.newProjectNotificationConfigBuilder().setProject(project).setNotificationConfig(notificationConfig).build();
    }

    public static String format(String organization, String notificationConfig) {
        return NotificationConfigName.newBuilder().setOrganization(organization).setNotificationConfig(notificationConfig).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatOrganizationNotificationConfigName(String organization, String notificationConfig) {
        return NotificationConfigName.newBuilder().setOrganization(organization).setNotificationConfig(notificationConfig).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatFolderNotificationConfigName(String folder, String notificationConfig) {
        return NotificationConfigName.newFolderNotificationConfigBuilder().setFolder(folder).setNotificationConfig(notificationConfig).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectNotificationConfigName(String project, String notificationConfig) {
        return NotificationConfigName.newProjectNotificationConfigBuilder().setProject(project).setNotificationConfig(notificationConfig).build().toString();
    }

    public static NotificationConfigName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (ORGANIZATION_NOTIFICATION_CONFIG.matches(formattedString)) {
            Map matchMap = ORGANIZATION_NOTIFICATION_CONFIG.match(formattedString);
            return NotificationConfigName.ofOrganizationNotificationConfigName((String)matchMap.get("organization"), (String)matchMap.get("notification_config"));
        }
        if (FOLDER_NOTIFICATION_CONFIG.matches(formattedString)) {
            Map matchMap = FOLDER_NOTIFICATION_CONFIG.match(formattedString);
            return NotificationConfigName.ofFolderNotificationConfigName((String)matchMap.get("folder"), (String)matchMap.get("notification_config"));
        }
        if (PROJECT_NOTIFICATION_CONFIG.matches(formattedString)) {
            Map matchMap = PROJECT_NOTIFICATION_CONFIG.match(formattedString);
            return NotificationConfigName.ofProjectNotificationConfigName((String)matchMap.get("project"), (String)matchMap.get("notification_config"));
        }
        throw new ValidationException("NotificationConfigName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<NotificationConfigName> parseList(List<String> formattedStrings) {
        ArrayList<NotificationConfigName> list = new ArrayList<NotificationConfigName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(NotificationConfigName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<NotificationConfigName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (NotificationConfigName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_NOTIFICATION_CONFIG.matches(formattedString) || FOLDER_NOTIFICATION_CONFIG.matches(formattedString) || PROJECT_NOTIFICATION_CONFIG.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            NotificationConfigName notificationConfigName = this;
            synchronized (notificationConfigName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.notificationConfig != null) {
                        fieldMapBuilder.put((Object)"notification_config", (Object)this.notificationConfig);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put((Object)"folder", (Object)this.folder);
                    }
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            NotificationConfigName that = (NotificationConfigName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.notificationConfig, that.notificationConfig) && Objects.equals(this.folder, that.folder) && Objects.equals(this.project, that.project);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.notificationConfig);
        h *= 1000003;
        h ^= Objects.hashCode(this.folder);
        h *= 1000003;
        return h ^= Objects.hashCode(this.project);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class ProjectNotificationConfigBuilder {
        private String project;
        private String notificationConfig;

        protected ProjectNotificationConfigBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getNotificationConfig() {
            return this.notificationConfig;
        }

        public ProjectNotificationConfigBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectNotificationConfigBuilder setNotificationConfig(String notificationConfig) {
            this.notificationConfig = notificationConfig;
            return this;
        }

        public NotificationConfigName build() {
            return new NotificationConfigName(this);
        }
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class FolderNotificationConfigBuilder {
        private String folder;
        private String notificationConfig;

        protected FolderNotificationConfigBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getNotificationConfig() {
            return this.notificationConfig;
        }

        public FolderNotificationConfigBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderNotificationConfigBuilder setNotificationConfig(String notificationConfig) {
            this.notificationConfig = notificationConfig;
            return this;
        }

        public NotificationConfigName build() {
            return new NotificationConfigName(this);
        }
    }

    public static class Builder {
        private String organization;
        private String notificationConfig;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getNotificationConfig() {
            return this.notificationConfig;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setNotificationConfig(String notificationConfig) {
            this.notificationConfig = notificationConfig;
            return this;
        }

        private Builder(NotificationConfigName notificationConfigName) {
            Preconditions.checkArgument((boolean)Objects.equals(notificationConfigName.pathTemplate, ORGANIZATION_NOTIFICATION_CONFIG), (Object)"toBuilder is only supported when NotificationConfigName has the pattern of organizations/{organization}/notificationConfigs/{notification_config}");
            this.organization = notificationConfigName.organization;
            this.notificationConfig = notificationConfigName.notificationConfig;
        }

        public NotificationConfigName build() {
            return new NotificationConfigName(this);
        }
    }
}

