/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.securitycenter.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AssetName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/assets/{asset}");
    private volatile Map<String, String> fieldValuesMap;
    private final String organization;
    private final String asset;

    public String getOrganization() {
        return this.organization;
    }

    public String getAsset() {
        return this.asset;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private AssetName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.asset = (String)Preconditions.checkNotNull((Object)builder.getAsset());
    }

    public static AssetName of(String organization, String asset) {
        return AssetName.newBuilder().setOrganization(organization).setAsset(asset).build();
    }

    public static String format(String organization, String asset) {
        return AssetName.newBuilder().setOrganization(organization).setAsset(asset).build().toString();
    }

    public static AssetName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "AssetName.parse: formattedString not in valid format");
        return AssetName.of((String)matchMap.get("organization"), (String)matchMap.get("asset"));
    }

    public static List<AssetName> parseList(List<String> formattedStrings) {
        ArrayList<AssetName> list = new ArrayList<AssetName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AssetName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AssetName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AssetName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AssetName assetName = this;
            synchronized (assetName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    fieldMapBuilder.put((Object)"asset", (Object)this.asset);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"organization", this.organization, "asset", this.asset});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AssetName) {
            AssetName that = (AssetName)o;
            return this.organization.equals(that.organization) && this.asset.equals(that.asset);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.organization.hashCode();
        h *= 1000003;
        return h ^= this.asset.hashCode();
    }

    public static class Builder {
        private String organization;
        private String asset;

        public String getOrganization() {
            return this.organization;
        }

        public String getAsset() {
            return this.asset;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setAsset(String asset) {
            this.asset = asset;
            return this;
        }

        private Builder() {
        }

        private Builder(AssetName assetName) {
            this.organization = assetName.organization;
            this.asset = assetName.asset;
        }

        public AssetName build() {
            return new AssetName(this);
        }
    }
}

