/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.securitycenter.settings.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SettingsName
implements ResourceName {
    private static final PathTemplate ORGANIZATION = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/settings");
    private static final PathTemplate FOLDER = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/settings");
    private static final PathTemplate PROJECT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/settings");
    private static final PathTemplate PROJECT_LOCATION_CLUSTER = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/clusters/{cluster}/settings");
    private static final PathTemplate PROJECT_REGION_CLUSTER = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/regions/{region}/clusters/{cluster}/settings");
    private static final PathTemplate PROJECT_ZONE_CLUSTER = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/zones/{zone}/clusters/{cluster}/settings");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String organization;
    private final String folder;
    private final String project;
    private final String location;
    private final String cluster;
    private final String region;
    private final String zone;

    @Deprecated
    protected SettingsName() {
        this.organization = null;
        this.folder = null;
        this.project = null;
        this.location = null;
        this.cluster = null;
        this.region = null;
        this.zone = null;
    }

    private SettingsName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.folder = null;
        this.project = null;
        this.location = null;
        this.cluster = null;
        this.region = null;
        this.zone = null;
        this.pathTemplate = ORGANIZATION;
    }

    private SettingsName(FolderBuilder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.organization = null;
        this.project = null;
        this.location = null;
        this.cluster = null;
        this.region = null;
        this.zone = null;
        this.pathTemplate = FOLDER;
    }

    private SettingsName(ProjectBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.organization = null;
        this.folder = null;
        this.location = null;
        this.cluster = null;
        this.region = null;
        this.zone = null;
        this.pathTemplate = PROJECT;
    }

    private SettingsName(ProjectLocationClusterBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.cluster = (String)Preconditions.checkNotNull((Object)builder.getCluster());
        this.organization = null;
        this.folder = null;
        this.region = null;
        this.zone = null;
        this.pathTemplate = PROJECT_LOCATION_CLUSTER;
    }

    private SettingsName(ProjectRegionClusterBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.region = (String)Preconditions.checkNotNull((Object)builder.getRegion());
        this.cluster = (String)Preconditions.checkNotNull((Object)builder.getCluster());
        this.organization = null;
        this.folder = null;
        this.location = null;
        this.zone = null;
        this.pathTemplate = PROJECT_REGION_CLUSTER;
    }

    private SettingsName(ProjectZoneClusterBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.zone = (String)Preconditions.checkNotNull((Object)builder.getZone());
        this.cluster = (String)Preconditions.checkNotNull((Object)builder.getCluster());
        this.organization = null;
        this.folder = null;
        this.location = null;
        this.region = null;
        this.pathTemplate = PROJECT_ZONE_CLUSTER;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCluster() {
        return this.cluster;
    }

    public String getRegion() {
        return this.region;
    }

    public String getZone() {
        return this.zone;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newOrganizationBuilder() {
        return new Builder();
    }

    public static FolderBuilder newFolderBuilder() {
        return new FolderBuilder();
    }

    public static ProjectBuilder newProjectBuilder() {
        return new ProjectBuilder();
    }

    public static ProjectLocationClusterBuilder newProjectLocationClusterBuilder() {
        return new ProjectLocationClusterBuilder();
    }

    public static ProjectRegionClusterBuilder newProjectRegionClusterBuilder() {
        return new ProjectRegionClusterBuilder();
    }

    public static ProjectZoneClusterBuilder newProjectZoneClusterBuilder() {
        return new ProjectZoneClusterBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SettingsName of(String organization) {
        return SettingsName.newBuilder().setOrganization(organization).build();
    }

    public static SettingsName ofOrganizationName(String organization) {
        return SettingsName.newBuilder().setOrganization(organization).build();
    }

    public static SettingsName ofFolderName(String folder) {
        return SettingsName.newFolderBuilder().setFolder(folder).build();
    }

    public static SettingsName ofProjectName(String project) {
        return SettingsName.newProjectBuilder().setProject(project).build();
    }

    public static SettingsName ofProjectLocationClusterName(String project, String location, String cluster) {
        return SettingsName.newProjectLocationClusterBuilder().setProject(project).setLocation(location).setCluster(cluster).build();
    }

    public static SettingsName ofProjectRegionClusterName(String project, String region, String cluster) {
        return SettingsName.newProjectRegionClusterBuilder().setProject(project).setRegion(region).setCluster(cluster).build();
    }

    public static SettingsName ofProjectZoneClusterName(String project, String zone, String cluster) {
        return SettingsName.newProjectZoneClusterBuilder().setProject(project).setZone(zone).setCluster(cluster).build();
    }

    public static String format(String organization) {
        return SettingsName.newBuilder().setOrganization(organization).build().toString();
    }

    public static String formatOrganizationName(String organization) {
        return SettingsName.newBuilder().setOrganization(organization).build().toString();
    }

    public static String formatFolderName(String folder) {
        return SettingsName.newFolderBuilder().setFolder(folder).build().toString();
    }

    public static String formatProjectName(String project) {
        return SettingsName.newProjectBuilder().setProject(project).build().toString();
    }

    public static String formatProjectLocationClusterName(String project, String location, String cluster) {
        return SettingsName.newProjectLocationClusterBuilder().setProject(project).setLocation(location).setCluster(cluster).build().toString();
    }

    public static String formatProjectRegionClusterName(String project, String region, String cluster) {
        return SettingsName.newProjectRegionClusterBuilder().setProject(project).setRegion(region).setCluster(cluster).build().toString();
    }

    public static String formatProjectZoneClusterName(String project, String zone, String cluster) {
        return SettingsName.newProjectZoneClusterBuilder().setProject(project).setZone(zone).setCluster(cluster).build().toString();
    }

    public static SettingsName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (ORGANIZATION.matches(formattedString)) {
            Map matchMap = ORGANIZATION.match(formattedString);
            return SettingsName.ofOrganizationName((String)matchMap.get("organization"));
        }
        if (FOLDER.matches(formattedString)) {
            Map matchMap = FOLDER.match(formattedString);
            return SettingsName.ofFolderName((String)matchMap.get("folder"));
        }
        if (PROJECT.matches(formattedString)) {
            Map matchMap = PROJECT.match(formattedString);
            return SettingsName.ofProjectName((String)matchMap.get("project"));
        }
        if (PROJECT_LOCATION_CLUSTER.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_CLUSTER.match(formattedString);
            return SettingsName.ofProjectLocationClusterName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("cluster"));
        }
        if (PROJECT_REGION_CLUSTER.matches(formattedString)) {
            Map matchMap = PROJECT_REGION_CLUSTER.match(formattedString);
            return SettingsName.ofProjectRegionClusterName((String)matchMap.get("project"), (String)matchMap.get("region"), (String)matchMap.get("cluster"));
        }
        if (PROJECT_ZONE_CLUSTER.matches(formattedString)) {
            Map matchMap = PROJECT_ZONE_CLUSTER.match(formattedString);
            return SettingsName.ofProjectZoneClusterName((String)matchMap.get("project"), (String)matchMap.get("zone"), (String)matchMap.get("cluster"));
        }
        throw new ValidationException("SettingsName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<SettingsName> parseList(List<String> formattedStrings) {
        ArrayList<SettingsName> list = new ArrayList<SettingsName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SettingsName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SettingsName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SettingsName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION.matches(formattedString) || FOLDER.matches(formattedString) || PROJECT.matches(formattedString) || PROJECT_LOCATION_CLUSTER.matches(formattedString) || PROJECT_REGION_CLUSTER.matches(formattedString) || PROJECT_ZONE_CLUSTER.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SettingsName settingsName = this;
            synchronized (settingsName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put((Object)"folder", (Object)this.folder);
                    }
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.cluster != null) {
                        fieldMapBuilder.put((Object)"cluster", (Object)this.cluster);
                    }
                    if (this.region != null) {
                        fieldMapBuilder.put((Object)"region", (Object)this.region);
                    }
                    if (this.zone != null) {
                        fieldMapBuilder.put((Object)"zone", (Object)this.zone);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            SettingsName that = (SettingsName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.folder, that.folder) && Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.cluster, that.cluster) && Objects.equals(this.region, that.region) && Objects.equals(this.zone, that.zone);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.folder);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.cluster);
        h *= 1000003;
        h ^= Objects.hashCode(this.region);
        h *= 1000003;
        return h ^= Objects.hashCode(this.zone);
    }

    public static class ProjectZoneClusterBuilder {
        private String project;
        private String zone;
        private String cluster;

        protected ProjectZoneClusterBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getZone() {
            return this.zone;
        }

        public String getCluster() {
            return this.cluster;
        }

        public ProjectZoneClusterBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectZoneClusterBuilder setZone(String zone) {
            this.zone = zone;
            return this;
        }

        public ProjectZoneClusterBuilder setCluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public SettingsName build() {
            return new SettingsName(this);
        }
    }

    public static class ProjectRegionClusterBuilder {
        private String project;
        private String region;
        private String cluster;

        protected ProjectRegionClusterBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getRegion() {
            return this.region;
        }

        public String getCluster() {
            return this.cluster;
        }

        public ProjectRegionClusterBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectRegionClusterBuilder setRegion(String region) {
            this.region = region;
            return this;
        }

        public ProjectRegionClusterBuilder setCluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public SettingsName build() {
            return new SettingsName(this);
        }
    }

    public static class ProjectLocationClusterBuilder {
        private String project;
        private String location;
        private String cluster;

        protected ProjectLocationClusterBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCluster() {
            return this.cluster;
        }

        public ProjectLocationClusterBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationClusterBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationClusterBuilder setCluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public SettingsName build() {
            return new SettingsName(this);
        }
    }

    public static class ProjectBuilder {
        private String project;

        protected ProjectBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public ProjectBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public SettingsName build() {
            return new SettingsName(this);
        }
    }

    public static class FolderBuilder {
        private String folder;

        protected FolderBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public FolderBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public SettingsName build() {
            return new SettingsName(this);
        }
    }

    public static class Builder {
        private String organization;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        private Builder(SettingsName settingsName) {
            Preconditions.checkArgument((boolean)Objects.equals(settingsName.pathTemplate, ORGANIZATION), (Object)"toBuilder is only supported when SettingsName has the pattern of organizations/{organization}/settings");
            this.organization = settingsName.organization;
        }

        public SettingsName build() {
            return new SettingsName(this);
        }
    }
}

