/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.securitycenter.settings.v1beta1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ComponentSettingsName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_COMPONENT_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/components/{component}/settings");
    private static final PathTemplate FOLDER_COMPONENT_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/components/{component}/settings");
    private static final PathTemplate PROJECT_COMPONENT_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/components/{component}/settings");
    private static final PathTemplate PROJECT_LOCATION_CLUSTER_COMPONENT_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/clusters/{cluster}/components/{component}/settings");
    private static final PathTemplate PROJECT_REGION_CLUSTER_COMPONENT_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/regions/{region}/clusters/{cluster}/components/{component}/settings");
    private static final PathTemplate PROJECT_ZONE_CLUSTER_COMPONENT_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/zones/{zone}/clusters/{cluster}/components/{component}/settings");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private String organization;
    private String component;
    private String folder;
    private String project;
    private String location;
    private String cluster;
    private String region;
    private String zone;

    @Deprecated
    protected ComponentSettingsName() {
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getComponent() {
        return this.component;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCluster() {
        return this.cluster;
    }

    public String getRegion() {
        return this.region;
    }

    public String getZone() {
        return this.zone;
    }

    private ComponentSettingsName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.component = (String)Preconditions.checkNotNull((Object)builder.getComponent());
        this.pathTemplate = ORGANIZATION_COMPONENT_PATH_TEMPLATE;
    }

    private ComponentSettingsName(FolderComponentBuilder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.component = (String)Preconditions.checkNotNull((Object)builder.getComponent());
        this.pathTemplate = FOLDER_COMPONENT_PATH_TEMPLATE;
    }

    private ComponentSettingsName(ProjectComponentBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.component = (String)Preconditions.checkNotNull((Object)builder.getComponent());
        this.pathTemplate = PROJECT_COMPONENT_PATH_TEMPLATE;
    }

    private ComponentSettingsName(ProjectLocationClusterComponentBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.cluster = (String)Preconditions.checkNotNull((Object)builder.getCluster());
        this.component = (String)Preconditions.checkNotNull((Object)builder.getComponent());
        this.pathTemplate = PROJECT_LOCATION_CLUSTER_COMPONENT_PATH_TEMPLATE;
    }

    private ComponentSettingsName(ProjectRegionClusterComponentBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.region = (String)Preconditions.checkNotNull((Object)builder.getRegion());
        this.cluster = (String)Preconditions.checkNotNull((Object)builder.getCluster());
        this.component = (String)Preconditions.checkNotNull((Object)builder.getComponent());
        this.pathTemplate = PROJECT_REGION_CLUSTER_COMPONENT_PATH_TEMPLATE;
    }

    private ComponentSettingsName(ProjectZoneClusterComponentBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.zone = (String)Preconditions.checkNotNull((Object)builder.getZone());
        this.cluster = (String)Preconditions.checkNotNull((Object)builder.getCluster());
        this.component = (String)Preconditions.checkNotNull((Object)builder.getComponent());
        this.pathTemplate = PROJECT_ZONE_CLUSTER_COMPONENT_PATH_TEMPLATE;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newOrganizationComponentBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static FolderComponentBuilder newFolderComponentBuilder() {
        return new FolderComponentBuilder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static ProjectComponentBuilder newProjectComponentBuilder() {
        return new ProjectComponentBuilder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static ProjectLocationClusterComponentBuilder newProjectLocationClusterComponentBuilder() {
        return new ProjectLocationClusterComponentBuilder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static ProjectRegionClusterComponentBuilder newProjectRegionClusterComponentBuilder() {
        return new ProjectRegionClusterComponentBuilder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static ProjectZoneClusterComponentBuilder newProjectZoneClusterComponentBuilder() {
        return new ProjectZoneClusterComponentBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ComponentSettingsName of(String organization, String component) {
        return ComponentSettingsName.newOrganizationComponentBuilder().setOrganization(organization).setComponent(component).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static ComponentSettingsName ofOrganizationComponentName(String organization, String component) {
        return ComponentSettingsName.newOrganizationComponentBuilder().setOrganization(organization).setComponent(component).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static ComponentSettingsName ofFolderComponentName(String folder, String component) {
        return ComponentSettingsName.newFolderComponentBuilder().setFolder(folder).setComponent(component).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static ComponentSettingsName ofProjectComponentName(String project, String component) {
        return ComponentSettingsName.newProjectComponentBuilder().setProject(project).setComponent(component).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static ComponentSettingsName ofProjectLocationClusterComponentName(String project, String location, String cluster, String component) {
        return ComponentSettingsName.newProjectLocationClusterComponentBuilder().setProject(project).setLocation(location).setCluster(cluster).setComponent(component).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static ComponentSettingsName ofProjectRegionClusterComponentName(String project, String region, String cluster, String component) {
        return ComponentSettingsName.newProjectRegionClusterComponentBuilder().setProject(project).setRegion(region).setCluster(cluster).setComponent(component).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static ComponentSettingsName ofProjectZoneClusterComponentName(String project, String zone, String cluster, String component) {
        return ComponentSettingsName.newProjectZoneClusterComponentBuilder().setProject(project).setZone(zone).setCluster(cluster).setComponent(component).build();
    }

    public static String format(String organization, String component) {
        return ComponentSettingsName.newBuilder().setOrganization(organization).setComponent(component).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatOrganizationComponentName(String organization, String component) {
        return ComponentSettingsName.newBuilder().setOrganization(organization).setComponent(component).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatFolderComponentName(String folder, String component) {
        return ComponentSettingsName.newFolderComponentBuilder().setFolder(folder).setComponent(component).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectComponentName(String project, String component) {
        return ComponentSettingsName.newProjectComponentBuilder().setProject(project).setComponent(component).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectLocationClusterComponentName(String project, String location, String cluster, String component) {
        return ComponentSettingsName.newProjectLocationClusterComponentBuilder().setProject(project).setLocation(location).setCluster(cluster).setComponent(component).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectRegionClusterComponentName(String project, String region, String cluster, String component) {
        return ComponentSettingsName.newProjectRegionClusterComponentBuilder().setProject(project).setRegion(region).setCluster(cluster).setComponent(component).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectZoneClusterComponentName(String project, String zone, String cluster, String component) {
        return ComponentSettingsName.newProjectZoneClusterComponentBuilder().setProject(project).setZone(zone).setCluster(cluster).setComponent(component).build().toString();
    }

    public static ComponentSettingsName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (ORGANIZATION_COMPONENT_PATH_TEMPLATE.matches(formattedString)) {
            Map matchMap = ORGANIZATION_COMPONENT_PATH_TEMPLATE.match(formattedString);
            return ComponentSettingsName.ofOrganizationComponentName((String)matchMap.get("organization"), (String)matchMap.get("component"));
        }
        if (FOLDER_COMPONENT_PATH_TEMPLATE.matches(formattedString)) {
            Map matchMap = FOLDER_COMPONENT_PATH_TEMPLATE.match(formattedString);
            return ComponentSettingsName.ofFolderComponentName((String)matchMap.get("folder"), (String)matchMap.get("component"));
        }
        if (PROJECT_COMPONENT_PATH_TEMPLATE.matches(formattedString)) {
            Map matchMap = PROJECT_COMPONENT_PATH_TEMPLATE.match(formattedString);
            return ComponentSettingsName.ofProjectComponentName((String)matchMap.get("project"), (String)matchMap.get("component"));
        }
        if (PROJECT_LOCATION_CLUSTER_COMPONENT_PATH_TEMPLATE.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_CLUSTER_COMPONENT_PATH_TEMPLATE.match(formattedString);
            return ComponentSettingsName.ofProjectLocationClusterComponentName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("cluster"), (String)matchMap.get("component"));
        }
        if (PROJECT_REGION_CLUSTER_COMPONENT_PATH_TEMPLATE.matches(formattedString)) {
            Map matchMap = PROJECT_REGION_CLUSTER_COMPONENT_PATH_TEMPLATE.match(formattedString);
            return ComponentSettingsName.ofProjectRegionClusterComponentName((String)matchMap.get("project"), (String)matchMap.get("region"), (String)matchMap.get("cluster"), (String)matchMap.get("component"));
        }
        if (PROJECT_ZONE_CLUSTER_COMPONENT_PATH_TEMPLATE.matches(formattedString)) {
            Map matchMap = PROJECT_ZONE_CLUSTER_COMPONENT_PATH_TEMPLATE.match(formattedString);
            return ComponentSettingsName.ofProjectZoneClusterComponentName((String)matchMap.get("project"), (String)matchMap.get("zone"), (String)matchMap.get("cluster"), (String)matchMap.get("component"));
        }
        throw new ValidationException("JobName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<ComponentSettingsName> parseList(List<String> formattedStrings) {
        ArrayList<ComponentSettingsName> list = new ArrayList<ComponentSettingsName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ComponentSettingsName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ComponentSettingsName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ComponentSettingsName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_COMPONENT_PATH_TEMPLATE.matches(formattedString) || FOLDER_COMPONENT_PATH_TEMPLATE.matches(formattedString) || PROJECT_COMPONENT_PATH_TEMPLATE.matches(formattedString) || PROJECT_LOCATION_CLUSTER_COMPONENT_PATH_TEMPLATE.matches(formattedString) || PROJECT_REGION_CLUSTER_COMPONENT_PATH_TEMPLATE.matches(formattedString) || PROJECT_ZONE_CLUSTER_COMPONENT_PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ComponentSettingsName componentSettingsName = this;
            synchronized (componentSettingsName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.component != null) {
                        fieldMapBuilder.put((Object)"component", (Object)this.component);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put((Object)"folder", (Object)this.folder);
                    }
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.cluster != null) {
                        fieldMapBuilder.put((Object)"cluster", (Object)this.cluster);
                    }
                    if (this.region != null) {
                        fieldMapBuilder.put((Object)"region", (Object)this.region);
                    }
                    if (this.zone != null) {
                        fieldMapBuilder.put((Object)"zone", (Object)this.zone);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            ComponentSettingsName that = (ComponentSettingsName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.component, that.component) && Objects.equals(this.folder, that.folder) && Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.cluster, that.cluster) && Objects.equals(this.region, that.region) && Objects.equals(this.zone, that.zone);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.component);
        h *= 1000003;
        h ^= Objects.hashCode(this.folder);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.cluster);
        h *= 1000003;
        h ^= Objects.hashCode(this.region);
        h *= 1000003;
        return h ^= Objects.hashCode(this.zone);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class ProjectZoneClusterComponentBuilder {
        private String project;
        private String zone;
        private String cluster;
        private String component;

        private ProjectZoneClusterComponentBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getZone() {
            return this.zone;
        }

        public String getCluster() {
            return this.cluster;
        }

        public String getComponent() {
            return this.component;
        }

        public ProjectZoneClusterComponentBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectZoneClusterComponentBuilder setZone(String zone) {
            this.zone = zone;
            return this;
        }

        public ProjectZoneClusterComponentBuilder setCluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public ProjectZoneClusterComponentBuilder setComponent(String component) {
            this.component = component;
            return this;
        }

        public ComponentSettingsName build() {
            return new ComponentSettingsName(this);
        }
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class ProjectRegionClusterComponentBuilder {
        private String project;
        private String region;
        private String cluster;
        private String component;

        private ProjectRegionClusterComponentBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getRegion() {
            return this.region;
        }

        public String getCluster() {
            return this.cluster;
        }

        public String getComponent() {
            return this.component;
        }

        public ProjectRegionClusterComponentBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectRegionClusterComponentBuilder setRegion(String region) {
            this.region = region;
            return this;
        }

        public ProjectRegionClusterComponentBuilder setCluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public ProjectRegionClusterComponentBuilder setComponent(String component) {
            this.component = component;
            return this;
        }

        public ComponentSettingsName build() {
            return new ComponentSettingsName(this);
        }
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class ProjectLocationClusterComponentBuilder {
        private String project;
        private String location;
        private String cluster;
        private String component;

        private ProjectLocationClusterComponentBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCluster() {
            return this.cluster;
        }

        public String getComponent() {
            return this.component;
        }

        public ProjectLocationClusterComponentBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationClusterComponentBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationClusterComponentBuilder setCluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public ProjectLocationClusterComponentBuilder setComponent(String component) {
            this.component = component;
            return this;
        }

        public ComponentSettingsName build() {
            return new ComponentSettingsName(this);
        }
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class ProjectComponentBuilder {
        private String project;
        private String component;

        private ProjectComponentBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getComponent() {
            return this.component;
        }

        public ProjectComponentBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectComponentBuilder setComponent(String component) {
            this.component = component;
            return this;
        }

        public ComponentSettingsName build() {
            return new ComponentSettingsName(this);
        }
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class FolderComponentBuilder {
        private String folder;
        private String component;

        private FolderComponentBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getComponent() {
            return this.component;
        }

        public FolderComponentBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderComponentBuilder setComponent(String component) {
            this.component = component;
            return this;
        }

        public ComponentSettingsName build() {
            return new ComponentSettingsName(this);
        }
    }

    public static class Builder {
        private String organization;
        private String component;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getComponent() {
            return this.component;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setComponent(String component) {
            this.component = component;
            return this;
        }

        private Builder(ComponentSettingsName componentSettingsName) {
            Preconditions.checkArgument((componentSettingsName.pathTemplate == ORGANIZATION_COMPONENT_PATH_TEMPLATE ? 1 : 0) != 0, (Object)"toBuilder is only supported when ComponentSettingsName has the pattern of organizations/{organization}/components/{component}/settings.");
            this.organization = componentSettingsName.organization;
            this.component = componentSettingsName.component;
        }

        public ComponentSettingsName build() {
            return new ComponentSettingsName(this);
        }
    }
}

