/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.security.privateca.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ReusableConfigName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_REUSABLE_CONFIG = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/reusableConfigs/{reusable_config}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String reusableConfig;

    @Deprecated
    protected ReusableConfigName() {
        this.project = null;
        this.location = null;
        this.reusableConfig = null;
    }

    private ReusableConfigName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.reusableConfig = (String)Preconditions.checkNotNull((Object)builder.getReusableConfig());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getReusableConfig() {
        return this.reusableConfig;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ReusableConfigName of(String project, String location, String reusableConfig) {
        return ReusableConfigName.newBuilder().setProject(project).setLocation(location).setReusableConfig(reusableConfig).build();
    }

    public static String format(String project, String location, String reusableConfig) {
        return ReusableConfigName.newBuilder().setProject(project).setLocation(location).setReusableConfig(reusableConfig).build().toString();
    }

    public static ReusableConfigName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_REUSABLE_CONFIG.validatedMatch(formattedString, "ReusableConfigName.parse: formattedString not in valid format");
        return ReusableConfigName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("reusable_config"));
    }

    public static List<ReusableConfigName> parseList(List<String> formattedStrings) {
        ArrayList<ReusableConfigName> list = new ArrayList<ReusableConfigName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ReusableConfigName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ReusableConfigName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ReusableConfigName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_REUSABLE_CONFIG.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ReusableConfigName reusableConfigName = this;
            synchronized (reusableConfigName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.reusableConfig != null) {
                        fieldMapBuilder.put((Object)"reusable_config", (Object)this.reusableConfig);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_REUSABLE_CONFIG.instantiate(new String[]{"project", this.project, "location", this.location, "reusable_config", this.reusableConfig});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            ReusableConfigName that = (ReusableConfigName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.reusableConfig, that.reusableConfig);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.reusableConfig);
    }

    public static class Builder {
        private String project;
        private String location;
        private String reusableConfig;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getReusableConfig() {
            return this.reusableConfig;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setReusableConfig(String reusableConfig) {
            this.reusableConfig = reusableConfig;
            return this;
        }

        private Builder(ReusableConfigName reusableConfigName) {
            this.project = reusableConfigName.project;
            this.location = reusableConfigName.location;
            this.reusableConfig = reusableConfigName.reusableConfig;
        }

        public ReusableConfigName build() {
            return new ReusableConfigName(this);
        }
    }
}

