/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.security.privateca.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CertificateAuthorityName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/certificateAuthorities/{certificate_authority}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String certificateAuthority;

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCertificateAuthority() {
        return this.certificateAuthority;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private CertificateAuthorityName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.certificateAuthority = (String)Preconditions.checkNotNull((Object)builder.getCertificateAuthority());
    }

    public static CertificateAuthorityName of(String project, String location, String certificateAuthority) {
        return CertificateAuthorityName.newBuilder().setProject(project).setLocation(location).setCertificateAuthority(certificateAuthority).build();
    }

    public static String format(String project, String location, String certificateAuthority) {
        return CertificateAuthorityName.newBuilder().setProject(project).setLocation(location).setCertificateAuthority(certificateAuthority).build().toString();
    }

    public static CertificateAuthorityName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "CertificateAuthorityName.parse: formattedString not in valid format");
        return CertificateAuthorityName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("certificate_authority"));
    }

    public static List<CertificateAuthorityName> parseList(List<String> formattedStrings) {
        ArrayList<CertificateAuthorityName> list = new ArrayList<CertificateAuthorityName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CertificateAuthorityName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CertificateAuthorityName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CertificateAuthorityName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CertificateAuthorityName certificateAuthorityName = this;
            synchronized (certificateAuthorityName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"location", (Object)this.location);
                    fieldMapBuilder.put((Object)"certificateAuthority", (Object)this.certificateAuthority);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "location", this.location, "certificate_authority", this.certificateAuthority});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CertificateAuthorityName) {
            CertificateAuthorityName that = (CertificateAuthorityName)o;
            return this.project.equals(that.project) && this.location.equals(that.location) && this.certificateAuthority.equals(that.certificateAuthority);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        return h ^= this.certificateAuthority.hashCode();
    }

    public static class Builder {
        private String project;
        private String location;
        private String certificateAuthority;

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCertificateAuthority() {
            return this.certificateAuthority;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCertificateAuthority(String certificateAuthority) {
            this.certificateAuthority = certificateAuthority;
            return this;
        }

        private Builder() {
        }

        private Builder(CertificateAuthorityName certificateAuthorityName) {
            this.project = certificateAuthorityName.project;
            this.location = certificateAuthorityName.location;
            this.certificateAuthority = certificateAuthorityName.certificateAuthority;
        }

        public CertificateAuthorityName build() {
            return new CertificateAuthorityName(this);
        }
    }
}

