/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.security.privateca.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CertificateName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/certificateAuthorities/{certificate_authority}/certificates/{certificate}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String certificateAuthority;
    private final String certificate;

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCertificateAuthority() {
        return this.certificateAuthority;
    }

    public String getCertificate() {
        return this.certificate;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private CertificateName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.certificateAuthority = (String)Preconditions.checkNotNull((Object)builder.getCertificateAuthority());
        this.certificate = (String)Preconditions.checkNotNull((Object)builder.getCertificate());
    }

    public static CertificateName of(String project, String location, String certificateAuthority, String certificate) {
        return CertificateName.newBuilder().setProject(project).setLocation(location).setCertificateAuthority(certificateAuthority).setCertificate(certificate).build();
    }

    public static String format(String project, String location, String certificateAuthority, String certificate) {
        return CertificateName.newBuilder().setProject(project).setLocation(location).setCertificateAuthority(certificateAuthority).setCertificate(certificate).build().toString();
    }

    public static CertificateName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "CertificateName.parse: formattedString not in valid format");
        return CertificateName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("certificate_authority"), (String)matchMap.get("certificate"));
    }

    public static List<CertificateName> parseList(List<String> formattedStrings) {
        ArrayList<CertificateName> list = new ArrayList<CertificateName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CertificateName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CertificateName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CertificateName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CertificateName certificateName = this;
            synchronized (certificateName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"location", (Object)this.location);
                    fieldMapBuilder.put((Object)"certificateAuthority", (Object)this.certificateAuthority);
                    fieldMapBuilder.put((Object)"certificate", (Object)this.certificate);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "location", this.location, "certificate_authority", this.certificateAuthority, "certificate", this.certificate});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CertificateName) {
            CertificateName that = (CertificateName)o;
            return this.project.equals(that.project) && this.location.equals(that.location) && this.certificateAuthority.equals(that.certificateAuthority) && this.certificate.equals(that.certificate);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        h ^= this.certificateAuthority.hashCode();
        h *= 1000003;
        return h ^= this.certificate.hashCode();
    }

    public static class Builder {
        private String project;
        private String location;
        private String certificateAuthority;
        private String certificate;

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCertificateAuthority() {
            return this.certificateAuthority;
        }

        public String getCertificate() {
            return this.certificate;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCertificateAuthority(String certificateAuthority) {
            this.certificateAuthority = certificateAuthority;
            return this;
        }

        public Builder setCertificate(String certificate) {
            this.certificate = certificate;
            return this;
        }

        private Builder() {
        }

        private Builder(CertificateName certificateName) {
            this.project = certificateName.project;
            this.location = certificateName.location;
            this.certificateAuthority = certificateName.certificateAuthority;
            this.certificate = certificateName.certificate;
        }

        public CertificateName build() {
            return new CertificateName(this);
        }
    }
}

