/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.security.privateca.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CertificateAuthorityName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CA_POOL_CERTIFICATE_AUTHORITY = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/caPools/{ca_pool}/certificateAuthorities/{certificate_authority}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String caPool;
    private final String certificateAuthority;

    @Deprecated
    protected CertificateAuthorityName() {
        this.project = null;
        this.location = null;
        this.caPool = null;
        this.certificateAuthority = null;
    }

    private CertificateAuthorityName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.caPool = (String)Preconditions.checkNotNull((Object)builder.getCaPool());
        this.certificateAuthority = (String)Preconditions.checkNotNull((Object)builder.getCertificateAuthority());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCaPool() {
        return this.caPool;
    }

    public String getCertificateAuthority() {
        return this.certificateAuthority;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CertificateAuthorityName of(String project, String location, String caPool, String certificateAuthority) {
        return CertificateAuthorityName.newBuilder().setProject(project).setLocation(location).setCaPool(caPool).setCertificateAuthority(certificateAuthority).build();
    }

    public static String format(String project, String location, String caPool, String certificateAuthority) {
        return CertificateAuthorityName.newBuilder().setProject(project).setLocation(location).setCaPool(caPool).setCertificateAuthority(certificateAuthority).build().toString();
    }

    public static CertificateAuthorityName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_CA_POOL_CERTIFICATE_AUTHORITY.validatedMatch(formattedString, "CertificateAuthorityName.parse: formattedString not in valid format");
        return CertificateAuthorityName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("ca_pool"), (String)matchMap.get("certificate_authority"));
    }

    public static List<CertificateAuthorityName> parseList(List<String> formattedStrings) {
        ArrayList<CertificateAuthorityName> list = new ArrayList<CertificateAuthorityName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CertificateAuthorityName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CertificateAuthorityName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CertificateAuthorityName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CA_POOL_CERTIFICATE_AUTHORITY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CertificateAuthorityName certificateAuthorityName = this;
            synchronized (certificateAuthorityName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.caPool != null) {
                        fieldMapBuilder.put((Object)"ca_pool", (Object)this.caPool);
                    }
                    if (this.certificateAuthority != null) {
                        fieldMapBuilder.put((Object)"certificate_authority", (Object)this.certificateAuthority);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_CA_POOL_CERTIFICATE_AUTHORITY.instantiate(new String[]{"project", this.project, "location", this.location, "ca_pool", this.caPool, "certificate_authority", this.certificateAuthority});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            CertificateAuthorityName that = (CertificateAuthorityName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.caPool, that.caPool) && Objects.equals(this.certificateAuthority, that.certificateAuthority);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.caPool);
        h *= 1000003;
        return h ^= Objects.hashCode(this.certificateAuthority);
    }

    public static class Builder {
        private String project;
        private String location;
        private String caPool;
        private String certificateAuthority;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCaPool() {
            return this.caPool;
        }

        public String getCertificateAuthority() {
            return this.certificateAuthority;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCaPool(String caPool) {
            this.caPool = caPool;
            return this;
        }

        public Builder setCertificateAuthority(String certificateAuthority) {
            this.certificateAuthority = certificateAuthority;
            return this;
        }

        private Builder(CertificateAuthorityName certificateAuthorityName) {
            this.project = certificateAuthorityName.project;
            this.location = certificateAuthorityName.location;
            this.caPool = certificateAuthorityName.caPool;
            this.certificateAuthority = certificateAuthorityName.certificateAuthority;
        }

        public CertificateAuthorityName build() {
            return new CertificateAuthorityName(this);
        }
    }
}

