/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.securesourcemanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class HookName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_REPOSITORY_HOOK = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/repositories/{repository}/hooks/{hook}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String repository;
    private final String hook;

    @Deprecated
    protected HookName() {
        this.project = null;
        this.location = null;
        this.repository = null;
        this.hook = null;
    }

    private HookName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.repository = (String)Preconditions.checkNotNull((Object)builder.getRepository());
        this.hook = (String)Preconditions.checkNotNull((Object)builder.getHook());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getHook() {
        return this.hook;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static HookName of(String project, String location, String repository, String hook) {
        return HookName.newBuilder().setProject(project).setLocation(location).setRepository(repository).setHook(hook).build();
    }

    public static String format(String project, String location, String repository, String hook) {
        return HookName.newBuilder().setProject(project).setLocation(location).setRepository(repository).setHook(hook).build().toString();
    }

    public static HookName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_REPOSITORY_HOOK.validatedMatch(formattedString, "HookName.parse: formattedString not in valid format");
        return HookName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("repository"), (String)matchMap.get("hook"));
    }

    public static List<HookName> parseList(List<String> formattedStrings) {
        ArrayList<HookName> list = new ArrayList<HookName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(HookName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<HookName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (HookName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_REPOSITORY_HOOK.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            HookName hookName = this;
            synchronized (hookName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.repository != null) {
                        fieldMapBuilder.put((Object)"repository", (Object)this.repository);
                    }
                    if (this.hook != null) {
                        fieldMapBuilder.put((Object)"hook", (Object)this.hook);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_REPOSITORY_HOOK.instantiate(new String[]{"project", this.project, "location", this.location, "repository", this.repository, "hook", this.hook});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            HookName that = (HookName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.repository, that.repository) && Objects.equals(this.hook, that.hook);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.repository);
        h *= 1000003;
        return h ^= Objects.hashCode(this.hook);
    }

    public static class Builder {
        private String project;
        private String location;
        private String repository;
        private String hook;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getRepository() {
            return this.repository;
        }

        public String getHook() {
            return this.hook;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setRepository(String repository) {
            this.repository = repository;
            return this;
        }

        public Builder setHook(String hook) {
            this.hook = hook;
            return this;
        }

        private Builder(HookName hookName) {
            this.project = hookName.project;
            this.location = hookName.location;
            this.repository = hookName.repository;
            this.hook = hookName.hook;
        }

        public HookName build() {
            return new HookName(this);
        }
    }
}

