/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.scheduler.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class JobName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_JOB = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/jobs/{job}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String job;

    @Deprecated
    protected JobName() {
        this.project = null;
        this.location = null;
        this.job = null;
    }

    private JobName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.job = (String)Preconditions.checkNotNull((Object)builder.getJob());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getJob() {
        return this.job;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static JobName of(String project, String location, String job) {
        return JobName.newBuilder().setProject(project).setLocation(location).setJob(job).build();
    }

    public static String format(String project, String location, String job) {
        return JobName.newBuilder().setProject(project).setLocation(location).setJob(job).build().toString();
    }

    public static JobName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_JOB.validatedMatch(formattedString, "JobName.parse: formattedString not in valid format");
        return JobName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("job"));
    }

    public static List<JobName> parseList(List<String> formattedStrings) {
        ArrayList<JobName> list = new ArrayList<JobName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(JobName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<JobName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (JobName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_JOB.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            JobName jobName = this;
            synchronized (jobName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.job != null) {
                        fieldMapBuilder.put((Object)"job", (Object)this.job);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_JOB.instantiate(new String[]{"project", this.project, "location", this.location, "job", this.job});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            JobName that = (JobName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.job, that.job);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.job);
    }

    public static class Builder {
        private String project;
        private String location;
        private String job;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getJob() {
            return this.job;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setJob(String job) {
            this.job = job;
            return this;
        }

        private Builder(JobName jobName) {
            this.project = jobName.project;
            this.location = jobName.location;
            this.job = jobName.job;
        }

        public JobName build() {
            return new JobName(this);
        }
    }
}

