/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.run.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BuildWorkerPoolName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_WORKER_POOL = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/workerPools/{worker_pool}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String workerPool;

    @Deprecated
    protected BuildWorkerPoolName() {
        this.project = null;
        this.location = null;
        this.workerPool = null;
    }

    private BuildWorkerPoolName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.workerPool = (String)Preconditions.checkNotNull((Object)builder.getWorkerPool());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getWorkerPool() {
        return this.workerPool;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static BuildWorkerPoolName of(String project, String location, String workerPool) {
        return BuildWorkerPoolName.newBuilder().setProject(project).setLocation(location).setWorkerPool(workerPool).build();
    }

    public static String format(String project, String location, String workerPool) {
        return BuildWorkerPoolName.newBuilder().setProject(project).setLocation(location).setWorkerPool(workerPool).build().toString();
    }

    public static BuildWorkerPoolName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_WORKER_POOL.validatedMatch(formattedString, "BuildWorkerPoolName.parse: formattedString not in valid format");
        return BuildWorkerPoolName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("worker_pool"));
    }

    public static List<BuildWorkerPoolName> parseList(List<String> formattedStrings) {
        ArrayList<BuildWorkerPoolName> list = new ArrayList<BuildWorkerPoolName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(BuildWorkerPoolName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<BuildWorkerPoolName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (BuildWorkerPoolName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_WORKER_POOL.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            BuildWorkerPoolName buildWorkerPoolName = this;
            synchronized (buildWorkerPoolName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.workerPool != null) {
                        fieldMapBuilder.put((Object)"worker_pool", (Object)this.workerPool);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_WORKER_POOL.instantiate(new String[]{"project", this.project, "location", this.location, "worker_pool", this.workerPool});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            BuildWorkerPoolName that = (BuildWorkerPoolName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.workerPool, that.workerPool);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.workerPool);
    }

    public static class Builder {
        private String project;
        private String location;
        private String workerPool;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getWorkerPool() {
            return this.workerPool;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setWorkerPool(String workerPool) {
            this.workerPool = workerPool;
            return this;
        }

        private Builder(BuildWorkerPoolName buildWorkerPoolName) {
            this.project = buildWorkerPoolName.project;
            this.location = buildWorkerPoolName.location;
            this.workerPool = buildWorkerPoolName.workerPool;
        }

        public BuildWorkerPoolName build() {
            return new BuildWorkerPoolName(this);
        }
    }
}

